/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.javahttpserver;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.util.ImmutableList;
import org.glowroot.agent.plugin.api.util.ImmutableMap;
import org.glowroot.agent.plugin.javahttpserver.HttpHandlerAspect;
import org.glowroot.agent.plugin.javahttpserver.JavaHttpServerPluginProperties;
import org.glowroot.agent.plugin.javahttpserver.Strings;

class DetailCapture {
    private DetailCapture() {
    }

    static Map<String, Object> captureRequestHeaders(HttpHandlerAspect.HttpExchange exchange) {
        List<Pattern> capturePatterns = JavaHttpServerPluginProperties.captureRequestHeaders();
        if (capturePatterns.isEmpty()) {
            return Collections.emptyMap();
        }
        return DetailCapture.captureHeaders(capturePatterns, exchange.glowroot$getRequestHeaders(), JavaHttpServerPluginProperties.maskRequestHeaders());
    }

    static Map<String, Object> captureResponseHeaders(HttpHandlerAspect.HttpExchange exchange) {
        List<Pattern> capturePatterns = JavaHttpServerPluginProperties.captureResponseHeaders();
        if (capturePatterns.isEmpty()) {
            return Collections.emptyMap();
        }
        return DetailCapture.captureHeaders(capturePatterns, exchange.glowroot$getResponseHeaders(), Collections.emptyList());
    }

    private static Map<String, Object> captureHeaders(List<Pattern> capturePatterns, @Nullable HttpHandlerAspect.Headers headers, List<Pattern> maskPatterns) {
        if (headers == null) {
            return Collections.emptyMap();
        }
        Set headerNames = headers.keySet();
        if (headerNames == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> headersMap = new HashMap<String, Object>();
        for (String name : headerNames) {
            String keyLowerCase;
            if (name == null || !DetailCapture.matchesOneOf(keyLowerCase = name.toLowerCase(Locale.ENGLISH), capturePatterns)) continue;
            if (DetailCapture.matchesOneOf(keyLowerCase, maskPatterns)) {
                headersMap.put(name, "****");
                continue;
            }
            List values = (List)headers.get(name);
            if (values == null) continue;
            DetailCapture.captureHeader(name, values, headersMap);
        }
        return ImmutableMap.copyOf(headersMap);
    }

    @Nullable
    static String captureRequestRemoteAddr(HttpHandlerAspect.HttpExchange exchange) {
        if (JavaHttpServerPluginProperties.captureRequestRemoteAddr()) {
            return DetailCapture.getRemoteAddr(exchange.getRemoteAddress());
        }
        return null;
    }

    @Nullable
    private static String getRemoteAddr(@Nullable InetSocketAddress remoteAddress) {
        if (remoteAddress != null && remoteAddress.getAddress() != null) {
            return remoteAddress.getAddress().getHostAddress();
        }
        return null;
    }

    @Nullable
    static String captureRequestRemoteHost(HttpHandlerAspect.HttpExchange exchange) {
        if (JavaHttpServerPluginProperties.captureRequestRemoteHost()) {
            return DetailCapture.getRemoteHost(exchange.getRemoteAddress());
        }
        return null;
    }

    @Nullable
    private static String getRemoteHost(@Nullable InetSocketAddress remoteAddress) {
        if (remoteAddress != null) {
            return remoteAddress.getHostName();
        }
        return null;
    }

    private static boolean matchesOneOf(String key, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(key).matches()) continue;
            return true;
        }
        return false;
    }

    private static void captureHeader(String name, List<String> values, Map<String, Object> header) {
        if (values.isEmpty()) {
            header.put(name, "");
        } else {
            ArrayList<String> list = new ArrayList<String>();
            for (String value : values) {
                list.add(Strings.nullToEmpty(value));
            }
            header.put(name, ImmutableList.copyOf(list));
        }
    }
}

