/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.javahttpserver;

import java.util.HashMap;
import java.util.Map;
import org.glowroot.agent.plugin.api.Message;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.checker.Nullable;

class HttpHandlerMessageSupplier
extends MessageSupplier {
    private final String requestMethod;
    private final String requestUri;
    @Nullable
    private final String requestQueryString;
    private final Map<String, Object> requestHeaders;
    @Nullable
    private Map<String, Object> responseHeaders;
    @Nullable
    private final String requestRemoteAddr;
    @Nullable
    private final String requestRemoteHost;

    HttpHandlerMessageSupplier(String requestMethod, String requestUri, @Nullable String requestQueryString, Map<String, Object> requestHeaders, @Nullable String requestRemoteAddr, @Nullable String requestRemoteHost) {
        this.requestMethod = requestMethod;
        this.requestUri = requestUri;
        this.requestQueryString = requestQueryString;
        this.requestHeaders = requestHeaders;
        this.requestRemoteAddr = requestRemoteAddr;
        this.requestRemoteHost = requestRemoteHost;
    }

    @Override
    public Message get() {
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("Request http method", this.requestMethod);
        if (this.requestQueryString != null) {
            detail.put("Request query string", this.requestQueryString);
        }
        if (!this.requestHeaders.isEmpty()) {
            detail.put("Request headers", this.requestHeaders);
        }
        if (this.requestRemoteAddr != null) {
            detail.put("Request remote address", this.requestRemoteAddr);
        }
        if (this.requestRemoteHost != null) {
            detail.put("Request remote host", this.requestRemoteHost);
        }
        if (this.responseHeaders != null && !this.responseHeaders.isEmpty()) {
            detail.put("Response headers", this.responseHeaders);
        }
        return Message.create(this.requestUri, detail);
    }

    void setResponseHeaders(Map<String, Object> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }
}

