/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.databind.cfg;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ContextAttributes {
    public static ContextAttributes getEmpty() {
        return Impl.getEmpty();
    }

    public abstract Object getAttribute(Object var1);

    public abstract ContextAttributes withPerCallAttribute(Object var1, Object var2);

    public static class Impl
    extends ContextAttributes
    implements Serializable {
        protected static final Impl EMPTY = new Impl(Collections.emptyMap());
        protected static final Object NULL_SURROGATE = new Object();
        protected final Map<?, ?> _shared;
        protected transient Map<Object, Object> _nonShared;

        protected Impl(Map<?, ?> shared) {
            this._shared = shared;
            this._nonShared = null;
        }

        protected Impl(Map<?, ?> shared, Map<Object, Object> nonShared) {
            this._shared = shared;
            this._nonShared = nonShared;
        }

        public static ContextAttributes getEmpty() {
            return EMPTY;
        }

        @Override
        public Object getAttribute(Object key) {
            Object ob;
            if (this._nonShared != null && (ob = this._nonShared.get(key)) != null) {
                if (ob == NULL_SURROGATE) {
                    return null;
                }
                return ob;
            }
            return this._shared.get(key);
        }

        @Override
        public ContextAttributes withPerCallAttribute(Object key, Object value) {
            if (value == null) {
                if (this._shared.containsKey(key)) {
                    value = NULL_SURROGATE;
                } else {
                    if (this._nonShared == null || !this._nonShared.containsKey(key)) {
                        return this;
                    }
                    this._nonShared.remove(key);
                    return this;
                }
            }
            if (this._nonShared == null) {
                return this.nonSharedInstance(key, value);
            }
            this._nonShared.put(key, value);
            return this;
        }

        protected ContextAttributes nonSharedInstance(Object key, Object value) {
            HashMap<Object, Object> m = new HashMap<Object, Object>();
            if (value == null) {
                value = NULL_SURROGATE;
            }
            m.put(key, value);
            return new Impl(this._shared, m);
        }
    }
}

