/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonToken;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.type.WritableTypeId;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.cfg.JsonNodeFeature;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ContainerNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.MissingNode;

public class ObjectNode
extends ContainerNode<ObjectNode>
implements Serializable {
    protected final Map<String, JsonNode> _children = new LinkedHashMap<String, JsonNode>();

    public ObjectNode(JsonNodeFactory nc) {
        super(nc);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    @Override
    public final boolean isObject() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.values().iterator();
    }

    @Override
    public JsonNode get(String propertyName) {
        return this._children.get(propertyName);
    }

    @Override
    public JsonNode path(String propertyName) {
        JsonNode n = this._children.get(propertyName);
        if (n != null) {
            return n;
        }
        return MissingNode.getInstance();
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return this._children.entrySet().iterator();
    }

    @Override
    public void serialize(JsonGenerator g, SerializerProvider provider) throws IOException {
        if (provider != null) {
            boolean skipNulls;
            boolean trimEmptyArray = !provider.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
            boolean bl = skipNulls = !provider.isEnabled(JsonNodeFeature.WRITE_NULL_PROPERTIES);
            if (trimEmptyArray || skipNulls) {
                g.writeStartObject(this);
                this.serializeFilteredContents(g, provider, trimEmptyArray, skipNulls);
                g.writeEndObject();
                return;
            }
        }
        g.writeStartObject(this);
        for (Map.Entry<String, JsonNode> en : this._contentsToSerialize(provider).entrySet()) {
            JsonNode value = en.getValue();
            g.writeFieldName(en.getKey());
            value.serialize(g, provider);
        }
        g.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        boolean trimEmptyArray = false;
        boolean skipNulls = false;
        if (provider != null) {
            trimEmptyArray = !provider.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
            skipNulls = !provider.isEnabled(JsonNodeFeature.WRITE_NULL_PROPERTIES);
        }
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(this, JsonToken.START_OBJECT));
        if (trimEmptyArray || skipNulls) {
            this.serializeFilteredContents(g, provider, trimEmptyArray, skipNulls);
        } else {
            for (Map.Entry<String, JsonNode> en : this._contentsToSerialize(provider).entrySet()) {
                JsonNode value = en.getValue();
                g.writeFieldName(en.getKey());
                value.serialize(g, provider);
            }
        }
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    protected void serializeFilteredContents(JsonGenerator g, SerializerProvider ctxt, boolean trimEmptyArray, boolean skipNulls) throws IOException {
        for (Map.Entry<String, JsonNode> en : this._contentsToSerialize(ctxt).entrySet()) {
            JsonNode value = en.getValue();
            if (trimEmptyArray && value.isArray() && value.isEmpty(ctxt) || skipNulls && value.isNull()) continue;
            g.writeFieldName(en.getKey());
            value.serialize(g, ctxt);
        }
    }

    protected Map<String, JsonNode> _contentsToSerialize(SerializerProvider ctxt) {
        if (ctxt.isEnabled(JsonNodeFeature.WRITE_PROPERTIES_SORTED) && !this._children.isEmpty()) {
            return new TreeMap<String, JsonNode>(this._children);
        }
        return this._children;
    }

    public <T extends JsonNode> T set(String propertyName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        this._children.put(propertyName, value);
        return (T)this;
    }

    public JsonNode replace(String propertyName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return this._children.put(propertyName, value);
    }

    public JsonNode remove(String propertyName) {
        return this._children.remove(propertyName);
    }

    public ArrayNode putArray(String propertyName) {
        ArrayNode n = this.arrayNode();
        this._put(propertyName, n);
        return n;
    }

    public ObjectNode put(String fieldName, int v) {
        return this._put(fieldName, this.numberNode(v));
    }

    public ObjectNode put(String fieldName, String v) {
        return this._put(fieldName, v == null ? this.nullNode() : this.textNode(v));
    }

    public ObjectNode put(String fieldName, boolean v) {
        return this._put(fieldName, this.booleanNode(v));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ObjectNode) {
            return this._childrenEqual((ObjectNode)o);
        }
        return false;
    }

    protected boolean _childrenEqual(ObjectNode other) {
        return this._children.equals(other._children);
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    protected ObjectNode _put(String fieldName, JsonNode value) {
        this._children.put(fieldName, value);
        return this;
    }
}

