/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.glowroot.agent.jul.Level;
import org.glowroot.agent.jul.Logger;
import org.glowroot.agent.shaded.io.grpc.Deadline;
import org.glowroot.agent.shaded.io.grpc.PersistentHashArrayMappedTrie;
import org.glowroot.agent.shaded.io.grpc.ThreadLocalContextStorage;

public class Context {
    static final Logger log = Logger.getLogger(Context.class.getName());
    public static final Context ROOT = new Context();
    final CancellableContext cancellableAncestor = null;
    final PersistentHashArrayMappedTrie.Node<Object<?>, Object> keyValueEntries = null;
    final int generation;

    static Storage storage() {
        return LazyStorage.storage;
    }

    public static Context current() {
        Context current = Context.storage().current();
        if (current == null) {
            return ROOT;
        }
        return current;
    }

    private Context() {
        this.generation = 0;
        Context.validateGeneration(this.generation);
    }

    public Context attach() {
        Context prev = Context.storage().doAttach(this);
        if (prev == null) {
            return ROOT;
        }
        return prev;
    }

    public void detach(Context toAttach) {
        Context.checkNotNull(toAttach, "toAttach");
        Context.storage().detach(this, toAttach);
    }

    public boolean isCancelled() {
        if (this.cancellableAncestor == null) {
            return false;
        }
        return this.cancellableAncestor.isCancelled();
    }

    public Throwable cancellationCause() {
        if (this.cancellableAncestor == null) {
            return null;
        }
        return this.cancellableAncestor.cancellationCause();
    }

    public Deadline getDeadline() {
        if (this.cancellableAncestor == null) {
            return null;
        }
        return this.cancellableAncestor.getDeadline();
    }

    public void addListener(CancellationListener cancellationListener, Executor executor) {
        Context.checkNotNull(cancellationListener, "cancellationListener");
        Context.checkNotNull(executor, "executor");
        if (this.cancellableAncestor == null) {
            return;
        }
        this.cancellableAncestor.addListenerInternal(new ExecutableListener(executor, cancellationListener, this));
    }

    public void removeListener(CancellationListener cancellationListener) {
        if (this.cancellableAncestor == null) {
            return;
        }
        this.cancellableAncestor.removeListenerInternal(cancellationListener, this);
    }

    static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    private static void validateGeneration(int generation) {
        if (generation == 1000) {
            log.log(Level.SEVERE, "Context ancestry chain length is abnormally long. This suggests an error in application code. Length exceeded: 1000", new Exception());
        }
    }

    private static enum DirectExecutor implements Executor
    {
        INSTANCE;


        @Override
        public void execute(Runnable command) {
            command.run();
        }

        public String toString() {
            return "Context.DirectExecutor";
        }
    }

    private static final class ExecutableListener
    implements Runnable {
        private final Executor executor;
        final CancellationListener listener;
        private final Context context;

        ExecutableListener(Executor executor, CancellationListener listener, Context context) {
            this.executor = executor;
            this.listener = listener;
            this.context = context;
        }

        void deliver() {
            try {
                this.executor.execute(this);
            }
            catch (Throwable t) {
                log.log(Level.INFO, "Exception notifying context listener", t);
            }
        }

        @Override
        public void run() {
            this.listener.cancelled(this.context);
        }
    }

    public static abstract class Storage {
        public abstract Context doAttach(Context var1);

        public abstract void detach(Context var1, Context var2);

        public abstract Context current();
    }

    public static interface CancellationListener {
        public void cancelled(Context var1);
    }

    public static final class CancellableContext
    extends Context
    implements Closeable {
        private final Deadline deadline;
        private final Context uncancellableSurrogate;
        private ArrayList<ExecutableListener> listeners;
        private CancellationListener parentListener;
        private Throwable cancellationCause;
        private ScheduledFuture<?> pendingDeadline;
        private boolean cancelled;

        @Override
        public Context attach() {
            return this.uncancellableSurrogate.attach();
        }

        @Override
        public void detach(Context toAttach) {
            this.uncancellableSurrogate.detach(toAttach);
        }

        @Override
        public void addListener(CancellationListener cancellationListener, Executor executor) {
            CancellableContext.checkNotNull(cancellationListener, "cancellationListener");
            CancellableContext.checkNotNull(executor, "executor");
            this.addListenerInternal(new ExecutableListener(executor, cancellationListener, this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListenerInternal(ExecutableListener executableListener) {
            CancellableContext cancellableContext = this;
            synchronized (cancellableContext) {
                if (this.isCancelled()) {
                    executableListener.deliver();
                } else if (this.listeners == null) {
                    this.listeners = new ArrayList();
                    this.listeners.add(executableListener);
                    if (this.cancellableAncestor != null) {
                        this.parentListener = new CancellationListener(){

                            @Override
                            public void cancelled(Context context) {
                                CancellableContext.this.cancel(context.cancellationCause());
                            }
                        };
                        this.cancellableAncestor.addListenerInternal(new ExecutableListener(DirectExecutor.INSTANCE, this.parentListener, this));
                    }
                } else {
                    this.listeners.add(executableListener);
                }
            }
        }

        @Override
        public void removeListener(CancellationListener cancellationListener) {
            this.removeListenerInternal(cancellationListener, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeListenerInternal(CancellationListener cancellationListener, Context context) {
            CancellableContext cancellableContext = this;
            synchronized (cancellableContext) {
                if (this.listeners != null) {
                    for (int i = this.listeners.size() - 1; i >= 0; --i) {
                        ExecutableListener executableListener = this.listeners.get(i);
                        if (executableListener.listener != cancellationListener || executableListener.context != context) continue;
                        this.listeners.remove(i);
                        break;
                    }
                    if (this.listeners.isEmpty()) {
                        if (this.cancellableAncestor != null) {
                            this.cancellableAncestor.removeListener(this.parentListener);
                        }
                        this.parentListener = null;
                        this.listeners = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(Throwable cause) {
            boolean triggeredCancel = false;
            ScheduledFuture<?> localPendingDeadline = null;
            CancellableContext cancellableContext = this;
            synchronized (cancellableContext) {
                if (!this.cancelled) {
                    this.cancelled = true;
                    if (this.pendingDeadline != null) {
                        localPendingDeadline = this.pendingDeadline;
                        this.pendingDeadline = null;
                    }
                    this.cancellationCause = cause;
                    triggeredCancel = true;
                }
            }
            if (localPendingDeadline != null) {
                localPendingDeadline.cancel(false);
            }
            if (triggeredCancel) {
                this.notifyAndClearListeners();
            }
            return triggeredCancel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAndClearListeners() {
            ArrayList<ExecutableListener> tmpListeners;
            CancellationListener tmpParentListener;
            Iterator<ExecutableListener> iterator = this;
            synchronized (iterator) {
                if (this.listeners == null) {
                    return;
                }
                tmpParentListener = this.parentListener;
                this.parentListener = null;
                tmpListeners = this.listeners;
                this.listeners = null;
            }
            for (ExecutableListener tmpListener : tmpListeners) {
                if (tmpListener.context != this) continue;
                tmpListener.deliver();
            }
            for (ExecutableListener tmpListener : tmpListeners) {
                if (tmpListener.context == this) continue;
                tmpListener.deliver();
            }
            if (this.cancellableAncestor != null) {
                this.cancellableAncestor.removeListener(tmpParentListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            CancellableContext cancellableContext = this;
            synchronized (cancellableContext) {
                if (this.cancelled) {
                    return true;
                }
            }
            if (super.isCancelled()) {
                this.cancel(super.cancellationCause());
                return true;
            }
            return false;
        }

        @Override
        public Throwable cancellationCause() {
            if (this.isCancelled()) {
                return this.cancellationCause;
            }
            return null;
        }

        @Override
        public Deadline getDeadline() {
            return this.deadline;
        }

        @Override
        public void close() {
            this.cancel(null);
        }
    }

    private static final class LazyStorage {
        static final Storage storage;

        private static Storage createStorage(AtomicReference<? super ClassNotFoundException> deferredStorageFailure) {
            try {
                Class<?> clazz = Class.forName("org.glowroot.agent.shaded.io.grpc.override.ContextStorageOverride");
                return clazz.asSubclass(Storage.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                deferredStorageFailure.set(e);
                return new ThreadLocalContextStorage();
            }
            catch (Exception e) {
                throw new RuntimeException("Storage override failed to initialize", e);
            }
        }

        static {
            AtomicReference deferredStorageFailure = new AtomicReference();
            storage = LazyStorage.createStorage(deferredStorageFailure);
            Throwable failure = (Throwable)deferredStorageFailure.get();
            if (failure != null) {
                log.log(Level.FINE, "Storage override doesn't exist. Using default", failure);
            }
        }
    }
}

