/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.channel.nio;

import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import org.glowroot.agent.shaded.io.netty.channel.DefaultSelectStrategyFactory;
import org.glowroot.agent.shaded.io.netty.channel.EventLoop;
import org.glowroot.agent.shaded.io.netty.channel.EventLoopTaskQueueFactory;
import org.glowroot.agent.shaded.io.netty.channel.MultithreadEventLoopGroup;
import org.glowroot.agent.shaded.io.netty.channel.SelectStrategyFactory;
import org.glowroot.agent.shaded.io.netty.channel.nio.NioEventLoop;
import org.glowroot.agent.shaded.io.netty.util.concurrent.RejectedExecutionHandler;
import org.glowroot.agent.shaded.io.netty.util.concurrent.RejectedExecutionHandlers;

public class NioEventLoopGroup
extends MultithreadEventLoopGroup {
    public NioEventLoopGroup() {
        this(0);
    }

    public NioEventLoopGroup(int nThreads) {
        this(nThreads, (Executor)null);
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        this(nThreads, threadFactory, SelectorProvider.provider());
    }

    public NioEventLoopGroup(int nThreads, Executor executor) {
        this(nThreads, executor, SelectorProvider.provider());
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory, SelectorProvider selectorProvider) {
        this(nThreads, threadFactory, selectorProvider, DefaultSelectStrategyFactory.INSTANCE);
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory) {
        super(nThreads, threadFactory, selectorProvider, selectStrategyFactory, RejectedExecutionHandlers.reject());
    }

    public NioEventLoopGroup(int nThreads, Executor executor, SelectorProvider selectorProvider) {
        this(nThreads, executor, selectorProvider, DefaultSelectStrategyFactory.INSTANCE);
    }

    public NioEventLoopGroup(int nThreads, Executor executor, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory) {
        super(nThreads, executor, selectorProvider, selectStrategyFactory, RejectedExecutionHandlers.reject());
    }

    @Override
    protected EventLoop newChild(Executor executor, Object ... args) throws Exception {
        SelectorProvider selectorProvider = (SelectorProvider)args[0];
        SelectStrategyFactory selectStrategyFactory = (SelectStrategyFactory)args[1];
        RejectedExecutionHandler rejectedExecutionHandler = (RejectedExecutionHandler)args[2];
        EventLoopTaskQueueFactory taskQueueFactory = null;
        EventLoopTaskQueueFactory tailTaskQueueFactory = null;
        int argsLength = args.length;
        if (argsLength > 3) {
            taskQueueFactory = (EventLoopTaskQueueFactory)args[3];
        }
        if (argsLength > 4) {
            tailTaskQueueFactory = (EventLoopTaskQueueFactory)args[4];
        }
        return new NioEventLoop(this, executor, selectorProvider, selectStrategyFactory.newSelectStrategy(), rejectedExecutionHandler, taskQueueFactory, tailTaskQueueFactory);
    }
}

