/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.handler.ssl;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.glowroot.agent.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import org.glowroot.agent.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import org.glowroot.agent.shaded.io.netty.handler.ssl.ClientAuth;
import org.glowroot.agent.shaded.io.netty.handler.ssl.EnhancingX509ExtendedTrustManager;
import org.glowroot.agent.shaded.io.netty.handler.ssl.JdkSslContext;
import org.glowroot.agent.shaded.io.netty.util.internal.PlatformDependent;

@Deprecated
public final class JdkSslServerContext
extends JdkSslContext {
    JdkSslServerContext(Provider provider, X509Certificate[] trustCertCollection, TrustManagerFactory trustManagerFactory, X509Certificate[] keyCertChain, PrivateKey key, String keyPassword, KeyManagerFactory keyManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout, ClientAuth clientAuth, String[] protocols, boolean startTls, String keyStore) throws SSLException {
        super(JdkSslServerContext.newSSLContext(provider, trustCertCollection, trustManagerFactory, keyCertChain, key, keyPassword, keyManagerFactory, sessionCacheSize, sessionTimeout, keyStore), false, ciphers, cipherFilter, JdkSslServerContext.toNegotiator(apn, true), clientAuth, protocols, startTls);
    }

    private static SSLContext newSSLContext(Provider sslContextProvider, X509Certificate[] trustCertCollection, TrustManagerFactory trustManagerFactory, X509Certificate[] keyCertChain, PrivateKey key, String keyPassword, KeyManagerFactory keyManagerFactory, long sessionCacheSize, long sessionTimeout, String keyStore) throws SSLException {
        if (key == null && keyManagerFactory == null) {
            throw new NullPointerException("key, keyManagerFactory");
        }
        try {
            if (trustCertCollection != null) {
                trustManagerFactory = JdkSslServerContext.buildTrustManagerFactory(trustCertCollection, trustManagerFactory, keyStore);
            } else if (trustManagerFactory == null) {
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
            }
            if (key != null) {
                keyManagerFactory = JdkSslServerContext.buildKeyManagerFactory(keyCertChain, null, key, keyPassword, keyManagerFactory, null);
            }
            SSLContext ctx = sslContextProvider == null ? SSLContext.getInstance("TLS") : SSLContext.getInstance("TLS", sslContextProvider);
            ctx.init(keyManagerFactory.getKeyManagers(), JdkSslServerContext.wrapTrustManagerIfNeeded(trustManagerFactory.getTrustManagers()), null);
            SSLSessionContext sessCtx = ctx.getServerSessionContext();
            if (sessionCacheSize > 0L) {
                sessCtx.setSessionCacheSize((int)Math.min(sessionCacheSize, Integer.MAX_VALUE));
            }
            if (sessionTimeout > 0L) {
                sessCtx.setSessionTimeout((int)Math.min(sessionTimeout, Integer.MAX_VALUE));
            }
            return ctx;
        }
        catch (Exception e) {
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException("failed to initialize the server-side SSL context", e);
        }
    }

    private static TrustManager[] wrapTrustManagerIfNeeded(TrustManager[] trustManagers) {
        if (PlatformDependent.javaVersion() >= 7) {
            for (int i = 0; i < trustManagers.length; ++i) {
                TrustManager tm = trustManagers[i];
                if (!(tm instanceof X509ExtendedTrustManager)) continue;
                trustManagers[i] = new EnhancingX509ExtendedTrustManager((X509ExtendedTrustManager)tm);
            }
        }
        return trustManagers;
    }
}

