/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.handler.ssl;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.glowroot.agent.shaded.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import org.glowroot.agent.shaded.io.netty.handler.ssl.OpenSslSessionCache;
import org.glowroot.agent.shaded.io.netty.handler.ssl.OpenSslSessionId;
import org.glowroot.agent.shaded.io.netty.handler.ssl.OpenSslSessionStats;
import org.glowroot.agent.shaded.io.netty.handler.ssl.OpenSslSessionTicketKey;
import org.glowroot.agent.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import org.glowroot.agent.shaded.io.netty.internal.tcnative.SSL;
import org.glowroot.agent.shaded.io.netty.internal.tcnative.SSLContext;
import org.glowroot.agent.shaded.io.netty.internal.tcnative.SSLSessionCache;
import org.glowroot.agent.shaded.io.netty.internal.tcnative.SessionTicketKey;
import org.glowroot.agent.shaded.io.netty.util.internal.ObjectUtil;

public abstract class OpenSslSessionContext
implements SSLSessionContext {
    private final OpenSslSessionStats stats;
    private final OpenSslKeyMaterialProvider provider;
    final ReferenceCountedOpenSslContext context;
    private final OpenSslSessionCache sessionCache;
    private final long mask;

    OpenSslSessionContext(ReferenceCountedOpenSslContext context, OpenSslKeyMaterialProvider provider, long mask, OpenSslSessionCache cache) {
        this.context = context;
        this.provider = provider;
        this.mask = mask;
        this.stats = new OpenSslSessionStats(context);
        this.sessionCache = cache;
        SSLContext.setSSLSessionCache((long)context.ctx, (SSLSessionCache)cache);
    }

    final boolean useKeyManager() {
        return this.provider != null;
    }

    @Override
    public void setSessionCacheSize(int size) {
        ObjectUtil.checkPositiveOrZero(size, "size");
        this.sessionCache.setSessionCacheSize(size);
    }

    @Override
    public int getSessionCacheSize() {
        return this.sessionCache.getSessionCacheSize();
    }

    @Override
    public void setSessionTimeout(int seconds) {
        ObjectUtil.checkPositiveOrZero(seconds, "seconds");
        Lock writerLock = this.context.ctxLock.writeLock();
        writerLock.lock();
        try {
            SSLContext.setSessionCacheTimeout((long)this.context.ctx, (long)seconds);
            this.sessionCache.setSessionTimeout(seconds);
        }
        finally {
            writerLock.unlock();
        }
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionCache.getSessionTimeout();
    }

    @Override
    public SSLSession getSession(byte[] bytes) {
        return this.sessionCache.getSession(new OpenSslSessionId(bytes));
    }

    @Override
    public Enumeration<byte[]> getIds() {
        return new Enumeration<byte[]>(){
            private final Iterator<OpenSslSessionId> ids;
            {
                this.ids = OpenSslSessionContext.this.sessionCache.getIds().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.ids.hasNext();
            }

            @Override
            public byte[] nextElement() {
                return this.ids.next().cloneBytes();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTicketKeys(OpenSslSessionTicketKey ... keys) {
        ObjectUtil.checkNotNull(keys, "keys");
        SessionTicketKey[] ticketKeys = new SessionTicketKey[keys.length];
        for (int i = 0; i < ticketKeys.length; ++i) {
            ticketKeys[i] = keys[i].key;
        }
        Lock writerLock = this.context.ctxLock.writeLock();
        writerLock.lock();
        try {
            SSLContext.clearOptions((long)this.context.ctx, (int)SSL.SSL_OP_NO_TICKET);
            if (ticketKeys.length > 0) {
                SSLContext.setSessionTicketKeys((long)this.context.ctx, (SessionTicketKey[])ticketKeys);
            }
        }
        finally {
            writerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionCacheEnabled(boolean enabled) {
        long mode = enabled ? this.mask | SSL.SSL_SESS_CACHE_NO_INTERNAL_LOOKUP | SSL.SSL_SESS_CACHE_NO_INTERNAL_STORE : SSL.SSL_SESS_CACHE_OFF;
        Lock writerLock = this.context.ctxLock.writeLock();
        writerLock.lock();
        try {
            SSLContext.setSessionCacheMode((long)this.context.ctx, (long)mode);
            if (!enabled) {
                this.sessionCache.clear();
            }
        }
        finally {
            writerLock.unlock();
        }
    }

    final void removeFromCache(OpenSslSessionId id) {
        this.sessionCache.removeSessionWithId(id);
    }

    final boolean isInCache(OpenSslSessionId id) {
        return this.sessionCache.containsSessionWithId(id);
    }

    void setSessionFromCache(String host, int port, long ssl) {
        this.sessionCache.setSession(ssl, host, port);
    }

    final void destroy() {
        if (this.provider != null) {
            this.provider.destroy();
        }
        this.sessionCache.clear();
    }
}

