/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableAdvancedConfig;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.immutables.value.Value;

@Value.Immutable
public abstract class AdvancedConfig {
    public static final int OVERALL_AGGREGATE_QUERIES_HARD_LIMIT_MULTIPLIER = 10;
    public static final int TRANSACTION_AGGREGATE_QUERIES_HARD_LIMIT_MULTIPLIER = 2;
    public static final int OVERALL_AGGREGATE_SERVICE_CALLS_HARD_LIMIT_MULTIPLIER = 10;
    public static final int TRANSACTION_AGGREGATE_SERVICE_CALLS_HARD_LIMIT_MULTIPLIER = 2;

    @Value.Default
    public int immediatePartialStoreThresholdSeconds() {
        return 60;
    }

    @Value.Default
    public int maxTransactionAggregates() {
        return 500;
    }

    @Value.Default
    public int maxQueryAggregates() {
        return 500;
    }

    @Value.Default
    public int maxServiceCallAggregates() {
        return 500;
    }

    @Value.Default
    public int maxTraceEntriesPerTransaction() {
        return 2000;
    }

    @Value.Default
    public int maxProfileSamplesPerTransaction() {
        return 50000;
    }

    @Value.Default
    public int mbeanGaugeNotFoundDelaySeconds() {
        return 60;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Value.Default
    public boolean weavingTimer() {
        return false;
    }

    public AgentConfigOuterClass.AgentConfig.AdvancedConfig toProto() {
        return AgentConfigOuterClass.AgentConfig.AdvancedConfig.newBuilder().setImmediatePartialStoreThresholdSeconds(AdvancedConfig.of(this.immediatePartialStoreThresholdSeconds())).setMaxTransactionAggregates(AdvancedConfig.of(this.maxTransactionAggregates())).setMaxQueryAggregates(AdvancedConfig.of(this.maxQueryAggregates())).setMaxServiceCallAggregates(AdvancedConfig.of(this.maxServiceCallAggregates())).setMaxTraceEntriesPerTransaction(AdvancedConfig.of(this.maxTraceEntriesPerTransaction())).setMaxProfileSamplesPerTransaction(AdvancedConfig.of(this.maxProfileSamplesPerTransaction())).setMbeanGaugeNotFoundDelaySeconds(AdvancedConfig.of(this.mbeanGaugeNotFoundDelaySeconds())).setWeavingTimer(this.weavingTimer()).build();
    }

    public static ImmutableAdvancedConfig create(AgentConfigOuterClass.AgentConfig.AdvancedConfig config) {
        ImmutableAdvancedConfig.Builder builder = ImmutableAdvancedConfig.builder();
        if (config.hasImmediatePartialStoreThresholdSeconds()) {
            builder.immediatePartialStoreThresholdSeconds(config.getImmediatePartialStoreThresholdSeconds().getValue());
        }
        if (config.hasMaxTransactionAggregates()) {
            builder.maxTransactionAggregates(config.getMaxTransactionAggregates().getValue());
        }
        if (config.hasMaxQueryAggregates()) {
            builder.maxQueryAggregates(config.getMaxQueryAggregates().getValue());
        }
        if (config.hasMaxServiceCallAggregates()) {
            builder.maxServiceCallAggregates(config.getMaxServiceCallAggregates().getValue());
        }
        if (config.hasMaxTraceEntriesPerTransaction()) {
            builder.maxTraceEntriesPerTransaction(config.getMaxTraceEntriesPerTransaction().getValue());
        }
        if (config.hasMaxProfileSamplesPerTransaction()) {
            builder.maxProfileSamplesPerTransaction(config.getMaxProfileSamplesPerTransaction().getValue());
        }
        if (config.hasMbeanGaugeNotFoundDelaySeconds()) {
            builder.mbeanGaugeNotFoundDelaySeconds(config.getMbeanGaugeNotFoundDelaySeconds().getValue());
        }
        return builder.weavingTimer(config.getWeavingTimer()).build();
    }

    private static Proto.OptionalInt32 of(int value) {
        return Proto.OptionalInt32.newBuilder().setValue(value).build();
    }
}

