/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.live;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LiveAggregateRepository.SummaryQuery", generator="Immutables")
@Immutable
public final class ImmutableSummaryQuery
implements LiveAggregateRepository.SummaryQuery {
    private final String transactionType;
    private final long from;
    private final long to;
    private final int rollupLevel;

    private ImmutableSummaryQuery(String transactionType, long from, long to, int rollupLevel) {
        this.transactionType = transactionType;
        this.from = from;
        this.to = to;
        this.rollupLevel = rollupLevel;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="rollupLevel")
    public int rollupLevel() {
        return this.rollupLevel;
    }

    public final ImmutableSummaryQuery withTransactionType(String value) {
        String newValue = Objects.requireNonNull(value, "transactionType");
        if (this.transactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableSummaryQuery(newValue, this.from, this.to, this.rollupLevel);
    }

    public final ImmutableSummaryQuery withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        return new ImmutableSummaryQuery(this.transactionType, value, this.to, this.rollupLevel);
    }

    public final ImmutableSummaryQuery withTo(long value) {
        if (this.to == value) {
            return this;
        }
        return new ImmutableSummaryQuery(this.transactionType, this.from, value, this.rollupLevel);
    }

    public final ImmutableSummaryQuery withRollupLevel(int value) {
        if (this.rollupLevel == value) {
            return this;
        }
        return new ImmutableSummaryQuery(this.transactionType, this.from, this.to, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSummaryQuery && this.equalTo(0, (ImmutableSummaryQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableSummaryQuery another) {
        return this.transactionType.equals(another.transactionType) && this.from == another.from && this.to == another.to && this.rollupLevel == another.rollupLevel;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionType.hashCode();
        h += (h << 5) + Longs.hashCode(this.from);
        h += (h << 5) + Longs.hashCode(this.to);
        h += (h << 5) + this.rollupLevel;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SummaryQuery").omitNullValues().add("transactionType", this.transactionType).add("from", this.from).add("to", this.to).add("rollupLevel", this.rollupLevel).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSummaryQuery fromJson(Json json) {
        Builder builder = ImmutableSummaryQuery.builder();
        if (json.transactionType != null) {
            builder.transactionType(json.transactionType);
        }
        if (json.fromIsSet) {
            builder.from(json.from);
        }
        if (json.toIsSet) {
            builder.to(json.to);
        }
        if (json.rollupLevelIsSet) {
            builder.rollupLevel(json.rollupLevel);
        }
        return builder.build();
    }

    public static ImmutableSummaryQuery copyOf(LiveAggregateRepository.SummaryQuery instance) {
        if (instance instanceof ImmutableSummaryQuery) {
            return (ImmutableSummaryQuery)instance;
        }
        return ImmutableSummaryQuery.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LiveAggregateRepository.SummaryQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_TYPE = 1L;
        private static final long INIT_BIT_FROM = 2L;
        private static final long INIT_BIT_TO = 4L;
        private static final long INIT_BIT_ROLLUP_LEVEL = 8L;
        private long initBits = 15L;
        @Nullable
        private String transactionType;
        private long from;
        private long to;
        private int rollupLevel;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(LiveAggregateRepository.SummaryQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.transactionType(instance.transactionType());
            this.from(instance.from());
            this.to(instance.to());
            this.rollupLevel(instance.rollupLevel());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionType(String transactionType) {
            this.transactionType = Objects.requireNonNull(transactionType, "transactionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(long from) {
            this.from = from;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder to(long to) {
            this.to = to;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rollupLevel(int rollupLevel) {
            this.rollupLevel = rollupLevel;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSummaryQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSummaryQuery(this.transactionType, this.from, this.to, this.rollupLevel);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("from");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("to");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("rollupLevel");
            }
            return "Cannot build SummaryQuery, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LiveAggregateRepository.SummaryQuery", generator="Immutables")
    static final class Json
    implements LiveAggregateRepository.SummaryQuery {
        @Nullable
        String transactionType;
        long from;
        boolean fromIsSet;
        long to;
        boolean toIsSet;
        int rollupLevel;
        boolean rollupLevelIsSet;

        Json() {
        }

        @JsonProperty(value="transactionType")
        public void setTransactionType(String transactionType) {
            this.transactionType = transactionType;
        }

        @JsonProperty(value="from")
        public void setFrom(long from) {
            this.from = from;
            this.fromIsSet = true;
        }

        @JsonProperty(value="to")
        public void setTo(long to) {
            this.to = to;
            this.toIsSet = true;
        }

        @JsonProperty(value="rollupLevel")
        public void setRollupLevel(int rollupLevel) {
            this.rollupLevel = rollupLevel;
            this.rollupLevelIsSet = true;
        }

        @Override
        public String transactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long from() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long to() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int rollupLevel() {
            throw new UnsupportedOperationException();
        }
    }
}

