/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.weaving.ClassAnalyzer;
import org.glowroot.agent.weaving.MixinType;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClassAnalyzer.MatchedMixinTypes", generator="Immutables")
@Immutable
final class ImmutableMatchedMixinTypes
implements ClassAnalyzer.MatchedMixinTypes {
    private final ImmutableList<MixinType> reweavable;
    private final ImmutableList<MixinType> nonReweavable;

    private ImmutableMatchedMixinTypes(ImmutableList<MixinType> reweavable, ImmutableList<MixinType> nonReweavable) {
        this.reweavable = reweavable;
        this.nonReweavable = nonReweavable;
    }

    @JsonProperty(value="reweavable")
    public ImmutableList<MixinType> reweavable() {
        return this.reweavable;
    }

    @JsonProperty(value="nonReweavable")
    public ImmutableList<MixinType> nonReweavable() {
        return this.nonReweavable;
    }

    public final ImmutableMatchedMixinTypes withReweavable(MixinType ... elements) {
        ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMatchedMixinTypes(newValue, this.nonReweavable);
    }

    public final ImmutableMatchedMixinTypes withReweavable(Iterable<? extends MixinType> elements) {
        if (this.reweavable == elements) {
            return this;
        }
        ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMatchedMixinTypes(newValue, this.nonReweavable);
    }

    public final ImmutableMatchedMixinTypes withNonReweavable(MixinType ... elements) {
        ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMatchedMixinTypes(this.reweavable, newValue);
    }

    public final ImmutableMatchedMixinTypes withNonReweavable(Iterable<? extends MixinType> elements) {
        if (this.nonReweavable == elements) {
            return this;
        }
        ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMatchedMixinTypes(this.reweavable, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMatchedMixinTypes && this.equalTo(0, (ImmutableMatchedMixinTypes)another);
    }

    private boolean equalTo(int synthetic, ImmutableMatchedMixinTypes another) {
        return this.reweavable.equals(another.reweavable) && this.nonReweavable.equals(another.nonReweavable);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.reweavable.hashCode();
        h += (h << 5) + this.nonReweavable.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MatchedMixinTypes").omitNullValues().add("reweavable", this.reweavable).add("nonReweavable", this.nonReweavable).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMatchedMixinTypes fromJson(Json json) {
        Builder builder = ImmutableMatchedMixinTypes.builder();
        if (json.reweavable != null) {
            builder.addAllReweavable(json.reweavable);
        }
        if (json.nonReweavable != null) {
            builder.addAllNonReweavable(json.nonReweavable);
        }
        return builder.build();
    }

    public static ImmutableMatchedMixinTypes copyOf(ClassAnalyzer.MatchedMixinTypes instance) {
        if (instance instanceof ImmutableMatchedMixinTypes) {
            return (ImmutableMatchedMixinTypes)instance;
        }
        return ImmutableMatchedMixinTypes.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClassAnalyzer.MatchedMixinTypes", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<MixinType> reweavable = ImmutableList.builder();
        private ImmutableList.Builder<MixinType> nonReweavable = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ClassAnalyzer.MatchedMixinTypes instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllReweavable(instance.reweavable());
            this.addAllNonReweavable(instance.nonReweavable());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReweavable(MixinType element) {
            this.reweavable.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReweavable(MixinType ... elements) {
            this.reweavable.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reweavable(Iterable<? extends MixinType> elements) {
            this.reweavable = ImmutableList.builder();
            return this.addAllReweavable(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllReweavable(Iterable<? extends MixinType> elements) {
            this.reweavable.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNonReweavable(MixinType element) {
            this.nonReweavable.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNonReweavable(MixinType ... elements) {
            this.nonReweavable.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nonReweavable(Iterable<? extends MixinType> elements) {
            this.nonReweavable = ImmutableList.builder();
            return this.addAllNonReweavable(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNonReweavable(Iterable<? extends MixinType> elements) {
            this.nonReweavable.addAll(elements);
            return this;
        }

        public ImmutableMatchedMixinTypes build() {
            return new ImmutableMatchedMixinTypes((ImmutableList)this.reweavable.build(), (ImmutableList)this.nonReweavable.build());
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ClassAnalyzer.MatchedMixinTypes", generator="Immutables")
    static final class Json
    implements ClassAnalyzer.MatchedMixinTypes {
        @Nullable
        List<MixinType> reweavable = ImmutableList.of();
        @Nullable
        List<MixinType> nonReweavable = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="reweavable")
        public void setReweavable(List<MixinType> reweavable) {
            this.reweavable = reweavable;
        }

        @JsonProperty(value="nonReweavable")
        public void setNonReweavable(List<MixinType> nonReweavable) {
            this.nonReweavable = nonReweavable;
        }

        @Override
        public List<MixinType> reweavable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MixinType> nonReweavable() {
            throw new UnsupportedOperationException();
        }
    }
}

