/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.bytecode.api.Bytecode;
import org.glowroot.agent.bytecode.api.ThreadContextPlus;
import org.glowroot.agent.bytecode.api.ThreadContextThreadLocal;
import org.glowroot.agent.plugin.api.ParameterHolder;
import org.glowroot.agent.plugin.api.internal.ParameterHolderImpl;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.IsEnabled;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.objectweb.asm.Label;
import org.glowroot.agent.shaded.org.objectweb.asm.MethodVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.Opcodes;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.Method;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.AdviceAdapter;
import org.glowroot.agent.weaving.BootstrapMetaHolders;
import org.glowroot.agent.weaving.FrameDeduppingMethodVisitor;
import org.glowroot.agent.weaving.ImmutableCatchHandler;
import org.immutables.value.Value;

class WeavingMethodVisitor
extends AdviceAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WeavingMethodVisitor.class);
    private static final Type objectType = Type.getType(Object.class);
    private static final Type fastThreadContextThreadLocalHolderType = Type.getType(ThreadContextThreadLocal.Holder.class);
    private static final Type threadContextPlusType = Type.getType(ThreadContextPlus.class);
    private static final Type bytecodeType = Type.getType(Bytecode.class);
    private static final Type parameterHolderType = Type.getType(ParameterHolder.class);
    private static final Type parameterHolderImplType = Type.getType(ParameterHolderImpl.class);
    private static final Method parameterHolderImplCreateMethod = new Method("create", "(Ljava/lang/Object;)Lorg/glowroot/agent/plugin/api/internal/ParameterHolderImpl;");
    private static final Method parameterHolderImplGetMethod = new Method("get", "()Ljava/lang/Object;");
    private static final AtomicInteger nestingGroupIdCounter = new AtomicInteger(1);
    private static final AtomicInteger suppressionKeyIdCounter = new AtomicInteger(1);
    private static final ConcurrentMap<String, Integer> nestingGroupIds = new ConcurrentHashMap<String, Integer>();
    private static final ConcurrentMap<String, Integer> suppressionKeyIds = new ConcurrentHashMap<String, Integer>();
    private final boolean frames;
    private final int access;
    private final String name;
    private final Type owner;
    private final ImmutableList<Advice> advisors;
    private final Type[] argumentTypes;
    private final Type returnType;
    private final @Nullable String metaHolderInternalName;
    private final @Nullable Integer methodMetaGroupUniqueNum;
    private final boolean bootstrapClassLoader;
    private final boolean needsOnReturn;
    private final boolean needsOnThrow;
    private final Object[] implicitFrameLocals;
    private final Map<Advice, Integer> enabledLocals = Maps.newHashMap();
    private final Map<Advice, Integer> travelerLocals = Maps.newHashMap();
    private final Map<Advice, Integer> prevNestingGroupIdLocals = Maps.newHashMap();
    private final Map<Advice, Integer> prevSuppressionKeyIdLocals = Maps.newHashMap();
    private final Map<Advice, Map<Integer, Integer>> parameterHolderLocals = Maps.newHashMap();
    private @MonotonicNonNull Integer threadContextLocal;
    private @MonotonicNonNull Integer threadContextHolderLocal;
    private final List<CatchHandler> catchHandlers = Lists.newArrayList();
    private @MonotonicNonNull Integer returnOpcode;
    private @MonotonicNonNull Label methodStartLabel;
    private @MonotonicNonNull Label onReturnLabel;
    private @MonotonicNonNull Label catchStartLabel;
    private boolean visitedLocalVariableThis;
    private int[] savedArgLocals = new int[0];

    WeavingMethodVisitor(MethodVisitor mv, boolean frames, int access, String name, String descriptor, Type owner, List<Advice> advisors, @Nullable String metaHolderInternalName, @Nullable Integer methodMetaGroupUniqueNum, boolean bootstrapClassLoader) {
        super(589824, new FrameDeduppingMethodVisitor(mv), access, name, descriptor);
        boolean needsReceiver;
        this.frames = frames;
        this.access = access;
        this.name = name;
        this.owner = owner;
        this.advisors = ImmutableList.copyOf(advisors);
        this.argumentTypes = Type.getArgumentTypes(descriptor);
        this.returnType = Type.getReturnType(descriptor);
        this.metaHolderInternalName = metaHolderInternalName;
        this.methodMetaGroupUniqueNum = methodMetaGroupUniqueNum;
        this.bootstrapClassLoader = bootstrapClassLoader;
        boolean needsOnReturn = false;
        boolean needsOnThrow = false;
        for (Advice advice : advisors) {
            if (!advice.pointcut().nestingGroup().isEmpty() || !advice.pointcut().suppressionKey().isEmpty() || advice.onAfterAdvice() != null) {
                needsOnReturn = true;
                needsOnThrow = true;
                break;
            }
            if (advice.onReturnAdvice() != null) {
                needsOnReturn = true;
            }
            if (advice.onThrowAdvice() == null) continue;
            needsOnThrow = true;
        }
        this.needsOnReturn = needsOnReturn;
        this.needsOnThrow = needsOnThrow;
        int nImplicitFrameLocals = this.argumentTypes.length;
        boolean bl = needsReceiver = !Modifier.isStatic(access);
        if (needsReceiver) {
            ++nImplicitFrameLocals;
        }
        Object[] implicitFrameLocals = new Object[nImplicitFrameLocals];
        int i = 0;
        if (needsReceiver) {
            implicitFrameLocals[i++] = name.equals("<init>") ? Opcodes.UNINITIALIZED_THIS : owner.getInternalName();
        }
        for (Type argumentType : this.argumentTypes) {
            implicitFrameLocals[i++] = WeavingMethodVisitor.convert(argumentType);
        }
        this.implicitFrameLocals = implicitFrameLocals;
    }

    @Override
    protected void onMethodPreEnter() {
        this.stackFrameTracking = false;
        try {
            this.onMethodPreEnterInternal();
        }
        finally {
            this.stackFrameTracking = true;
        }
    }

    @Override
    protected void onMethodEnter() {
        this.stackFrameTracking = false;
        try {
            if (this.name.equals("<init>")) {
                this.implicitFrameLocals[0] = this.owner.getInternalName();
            }
            this.onMethodEnterInternal();
        }
        finally {
            this.stackFrameTracking = true;
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (this.needsOnReturn && WeavingMethodVisitor.isReturnOpcode(opcode)) {
            Preconditions.checkNotNull(this.onReturnLabel, "Call to onMethodEnter() is required");
            this.returnOpcode = opcode;
            this.stackFrameTracking = false;
            try {
                this.cleanUpStackIfNeeded(opcode);
            }
            finally {
                this.stackFrameTracking = true;
            }
            this.visitJumpInsn(167, this.onReturnLabel);
        } else {
            super.visitInsn(opcode);
        }
    }

    @Override
    public void visitLocalVariable(String name, String descriptor, @Nullable String signature, Label start, Label end, int index) {
        if (!name.equals("this") || this.visitedLocalVariableThis) {
            super.visitLocalVariable(name, descriptor, signature, start, end, index);
            return;
        }
        this.visitedLocalVariableThis = true;
        Preconditions.checkNotNull(this.methodStartLabel, "Call to onMethodEnter() is required");
        Label outerEndLabel = new Label();
        this.visitLabel(outerEndLabel);
        super.visitLocalVariable(name, descriptor, signature, this.methodStartLabel, outerEndLabel, index);
        for (int i = 0; i < this.advisors.size(); ++i) {
            Integer travelerLocalIndex;
            Advice advice = (Advice)this.advisors.get(i);
            Integer enabledLocalIndex = this.enabledLocals.get(advice);
            if (enabledLocalIndex != null) {
                super.visitLocalVariable("glowroot$enabled$" + i, Type.BOOLEAN_TYPE.getDescriptor(), null, this.methodStartLabel, outerEndLabel, enabledLocalIndex);
            }
            if ((travelerLocalIndex = this.travelerLocals.get(advice)) == null) continue;
            Type travelerType = advice.travelerType();
            if (travelerType == null) {
                logger.error("visitLocalVariable(): traveler local index is not null, but traveler type is null");
                continue;
            }
            super.visitLocalVariable("glowroot$traveler$" + i, travelerType.getDescriptor(), null, this.methodStartLabel, outerEndLabel, travelerLocalIndex);
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.stackFrameTracking = false;
        Label catchEndLabel = new Label();
        if (this.needsOnThrow) {
            this.visitLabel(catchEndLabel);
        }
        if (this.needsOnReturn && this.returnOpcode != null) {
            Preconditions.checkNotNull(this.onReturnLabel, "Call to onMethodEnter() is required");
            this.visitLabel(this.onReturnLabel);
            if (this.returnType.getSort() == 0) {
                this.visitImplicitFrame(new Object[0]);
            } else {
                this.visitImplicitFrame(WeavingMethodVisitor.convert(this.returnType));
            }
            for (Advice advice : Lists.reverse(this.advisors)) {
                this.visitOnReturnAdvice(advice, this.returnOpcode);
                this.visitOnAfterAdvice(advice, false);
            }
            this.resetCurrentNestingGroupIfNeeded(false);
            super.visitInsn(this.returnOpcode);
        }
        if (this.needsOnThrow) {
            this.visitCatchHandlers(catchEndLabel);
        }
        super.visitMaxs(maxStack, maxLocals);
    }

    private void onMethodPreEnterInternal() {
        this.methodStartLabel = new Label();
        this.visitLabel(this.methodStartLabel);
        for (Advice advice : this.advisors) {
            this.defineLocalVars(advice);
            this.defineTravelerLocalVar(advice);
            this.defineParameterHolderVars(advice);
        }
        if (this.name.equals("<init>")) {
            for (Advice advice : this.advisors) {
                this.evaluateLocalVars(advice);
                this.invokeOnBefore(advice, this.travelerLocals.get(advice));
            }
        }
        this.saveArgsForMethodExit();
    }

    private void onMethodEnterInternal() {
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advice advice = (Advice)this.advisors.get(i);
            if (!this.name.equals("<init>")) {
                this.evaluateLocalVars(advice);
                this.invokeOnBefore(advice, this.travelerLocals.get(advice));
            }
            if (advice.onAfterAdvice() == null && advice.onThrowAdvice() == null) continue;
            Label catchStartLabel = new Label();
            this.visitLabel(catchStartLabel);
            this.catchHandlers.add(ImmutableCatchHandler.of(catchStartLabel, this.advisors.subList(0, i + 1)));
        }
        if (this.needsOnReturn) {
            this.onReturnLabel = new Label();
        }
        if (this.needsOnThrow && this.catchHandlers.isEmpty()) {
            this.catchStartLabel = new Label();
            this.visitLabel(this.catchStartLabel);
        }
    }

    private void visitCatchHandlers(Label catchEndLabel) {
        if (this.catchHandlers.isEmpty()) {
            Preconditions.checkNotNull(this.catchStartLabel, "Call to onMethodEnter() is required");
            Label catchHandlerLabel = new Label();
            this.visitTryCatchBlock(this.catchStartLabel, catchEndLabel, catchHandlerLabel, "java/lang/Throwable");
            this.visitLabel(catchHandlerLabel);
            this.visitImplicitFrame("java/lang/Throwable");
            this.resetCurrentNestingGroupIfNeeded(true);
            this.visitInsn(191);
        } else {
            for (CatchHandler catchHandler : Lists.reverse(this.catchHandlers)) {
                Label catchHandlerLabel = new Label();
                this.visitTryCatchBlock(catchHandler.catchStartLabel(), catchEndLabel, catchHandlerLabel, "java/lang/Throwable");
                this.visitLabel(catchHandlerLabel);
                this.visitImplicitFrame("java/lang/Throwable");
                for (Advice advice : Lists.reverse(catchHandler.advisors())) {
                    this.visitOnThrowAdvice(advice);
                }
                for (Advice advice : Lists.reverse(catchHandler.advisors())) {
                    this.visitOnAfterAdvice(advice, true);
                }
                this.resetCurrentNestingGroupIfNeeded(true);
                this.visitInsn(191);
            }
        }
    }

    private void defineLocalVars(Advice advice) {
        boolean needThreadContextHolderLocal;
        Integer enabledLocal = null;
        Method isEnabledAdvice = advice.isEnabledAdvice();
        String nestingGroup = advice.pointcut().nestingGroup();
        String suppressibleUsingKey = advice.pointcut().suppressibleUsingKey();
        if (isEnabledAdvice != null || WeavingMethodVisitor.hasOtherEnabledFactors(advice, nestingGroup, suppressibleUsingKey)) {
            enabledLocal = this.newLocal(Type.BOOLEAN_TYPE);
            this.enabledLocals.put(advice, enabledLocal);
            this.visitInsn(3);
            this.storeLocal(enabledLocal);
        }
        String suppressionKey = advice.pointcut().suppressionKey();
        boolean bl = needThreadContextHolderLocal = !nestingGroup.isEmpty() || !suppressionKey.isEmpty() || !suppressibleUsingKey.isEmpty() || advice.hasBindThreadContext() || advice.hasBindOptionalThreadContext();
        if (needThreadContextHolderLocal && this.threadContextHolderLocal == null) {
            this.threadContextHolderLocal = this.newLocal(fastThreadContextThreadLocalHolderType);
            this.visitInsn(1);
            this.storeLocal(this.threadContextHolderLocal);
            this.threadContextLocal = this.newLocal(threadContextPlusType);
            this.visitInsn(1);
            this.storeLocal(this.threadContextLocal);
        }
        Integer prevNestingGroupIdLocal = null;
        if (!nestingGroup.isEmpty()) {
            prevNestingGroupIdLocal = this.newLocal(Type.INT_TYPE);
            this.prevNestingGroupIdLocals.put(advice, prevNestingGroupIdLocal);
            this.visitInsn(2);
            this.storeLocal(prevNestingGroupIdLocal);
        }
        Integer prevSuppressionKeyIdLocal = null;
        if (!suppressionKey.isEmpty()) {
            prevSuppressionKeyIdLocal = this.newLocal(Type.INT_TYPE);
            this.prevSuppressionKeyIdLocals.put(advice, prevSuppressionKeyIdLocal);
            this.visitInsn(2);
            this.storeLocal(prevSuppressionKeyIdLocal);
        }
    }

    private void evaluateLocalVars(Advice advice) {
        Method isEnabledAdvice = advice.isEnabledAdvice();
        String nestingGroup = advice.pointcut().nestingGroup();
        String suppressionKey = advice.pointcut().suppressionKey();
        String suppressibleUsingKey = advice.pointcut().suppressibleUsingKey();
        Label otherEnabledFactorsDisabledEnd = null;
        if (WeavingMethodVisitor.hasOtherEnabledFactors(advice, nestingGroup, suppressibleUsingKey)) {
            otherEnabledFactorsDisabledEnd = new Label();
        }
        if (isEnabledAdvice != null) {
            this.loadMethodParameters(advice.isEnabledParameters(), 0, null, advice.adviceType(), IsEnabled.class, false, null, nestingGroup, suppressionKey, new Object[0]);
            this.visitMethodInsn(184, advice.adviceType().getInternalName(), isEnabledAdvice.getName(), isEnabledAdvice.getDescriptor(), false);
            if (otherEnabledFactorsDisabledEnd == null) {
                int enabledLocal = Preconditions.checkNotNull(this.enabledLocals.get(advice));
                this.storeLocal(enabledLocal);
            } else {
                this.visitJumpInsn(153, otherEnabledFactorsDisabledEnd);
            }
        }
        if (otherEnabledFactorsDisabledEnd != null) {
            Preconditions.checkNotNull(this.threadContextHolderLocal);
            Preconditions.checkNotNull(this.threadContextLocal);
            this.loadMaybeNullThreadContext(new Object[0]);
            if (advice.hasBindThreadContext() && !advice.hasBindOptionalThreadContext()) {
                this.visitJumpInsn(198, otherEnabledFactorsDisabledEnd);
                if (!nestingGroup.isEmpty()) {
                    int prevNestingGroupIdLocal = Preconditions.checkNotNull(this.prevNestingGroupIdLocals.get(advice));
                    this.checkAndUpdateNestingGroupId(prevNestingGroupIdLocal, nestingGroup, otherEnabledFactorsDisabledEnd);
                }
                if (!suppressibleUsingKey.isEmpty()) {
                    this.checkSuppressibleUsingKey(suppressibleUsingKey, otherEnabledFactorsDisabledEnd);
                }
                if (!suppressionKey.isEmpty()) {
                    int prevSuppressionKeyIdLocal = Preconditions.checkNotNull(this.prevSuppressionKeyIdLocals.get(advice));
                    this.updateSuppressionKeyId(prevSuppressionKeyIdLocal, suppressionKey);
                }
            } else {
                Label label = new Label();
                this.visitJumpInsn(198, label);
                if (!nestingGroup.isEmpty()) {
                    int prevNestingGroupIdLocal = Preconditions.checkNotNull(this.prevNestingGroupIdLocals.get(advice));
                    this.checkAndUpdateNestingGroupId(prevNestingGroupIdLocal, nestingGroup, otherEnabledFactorsDisabledEnd);
                }
                if (!suppressibleUsingKey.isEmpty()) {
                    this.checkSuppressibleUsingKey(suppressibleUsingKey, otherEnabledFactorsDisabledEnd);
                }
                if (!suppressionKey.isEmpty()) {
                    int prevSuppressionKeyIdLocal = Preconditions.checkNotNull(this.prevSuppressionKeyIdLocals.get(advice));
                    this.updateSuppressionKeyId(prevSuppressionKeyIdLocal, suppressionKey);
                }
                this.visitLabel(label);
                this.visitImplicitFrame(new Object[0]);
            }
            this.visitInsn(4);
            Label otherEnabledFactorsStoreLabel = new Label();
            this.goTo(otherEnabledFactorsStoreLabel);
            this.visitLabel(otherEnabledFactorsDisabledEnd);
            this.visitImplicitFrame(new Object[0]);
            this.visitInsn(3);
            this.visitLabel(otherEnabledFactorsStoreLabel);
            this.visitImplicitFrame(INTEGER);
            int enabledLocal = Preconditions.checkNotNull(this.enabledLocals.get(advice));
            this.storeLocal(enabledLocal);
        } else if (!suppressionKey.isEmpty()) {
            Preconditions.checkNotNull(this.threadContextHolderLocal);
            Preconditions.checkNotNull(this.threadContextLocal);
            this.loadMaybeNullThreadContext(new Object[0]);
            Label label = new Label();
            this.visitJumpInsn(198, label);
            int prevSuppressionKeyIdLocal = Preconditions.checkNotNull(this.prevSuppressionKeyIdLocals.get(advice));
            this.updateSuppressionKeyId(prevSuppressionKeyIdLocal, suppressionKey);
            this.visitLabel(label);
            this.visitImplicitFrame(new Object[0]);
        }
    }

    @RequiresNonNull(value={"threadContextLocal"})
    private void checkAndUpdateNestingGroupId(int prevNestingGroupIdLocal, String nestingGroup, Label otherEnabledFactorsDisabledEnd) {
        this.loadLocal(this.threadContextLocal);
        this.visitMethodInsn(185, threadContextPlusType.getInternalName(), "getCurrentNestingGroupId", "()I", true);
        this.dup();
        this.storeLocal(prevNestingGroupIdLocal);
        int nestingGroupId = WeavingMethodVisitor.getNestingGroupId(nestingGroup);
        this.mv.visitLdcInsn(nestingGroupId);
        this.visitJumpInsn(159, otherEnabledFactorsDisabledEnd);
        this.loadLocal(this.threadContextLocal);
        this.mv.visitLdcInsn(nestingGroupId);
        this.visitMethodInsn(185, threadContextPlusType.getInternalName(), "setCurrentNestingGroupId", "(I)V", true);
    }

    @RequiresNonNull(value={"threadContextLocal"})
    private void checkSuppressibleUsingKey(String suppressibleUsingKey, Label otherEnabledFactorsDisabledEnd) {
        this.loadLocal(this.threadContextLocal);
        this.visitMethodInsn(185, threadContextPlusType.getInternalName(), "getCurrentSuppressionKeyId", "()I", true);
        int suppressionKeyId = WeavingMethodVisitor.getSuppressionKeyId(suppressibleUsingKey);
        this.mv.visitLdcInsn(suppressionKeyId);
        this.visitJumpInsn(159, otherEnabledFactorsDisabledEnd);
    }

    @RequiresNonNull(value={"threadContextLocal"})
    private void updateSuppressionKeyId(int prevSuppressionKeyIdLocal, String suppressionKey) {
        this.loadLocal(this.threadContextLocal);
        this.visitMethodInsn(185, threadContextPlusType.getInternalName(), "getCurrentSuppressionKeyId", "()I", true);
        this.storeLocal(prevSuppressionKeyIdLocal);
        int suppressionKeyId = WeavingMethodVisitor.getSuppressionKeyId(suppressionKey);
        this.loadLocal(this.threadContextLocal);
        this.mv.visitLdcInsn(suppressionKeyId);
        this.visitMethodInsn(185, threadContextPlusType.getInternalName(), "setCurrentSuppressionKeyId", "(I)V", true);
    }

    private void defineTravelerLocalVar(Advice advice) {
        Method onBeforeAdvice = advice.onBeforeAdvice();
        if (onBeforeAdvice == null) {
            return;
        }
        Type travelerType = advice.travelerType();
        if (travelerType == null) {
            return;
        }
        int travelerLocal = this.newLocal(travelerType);
        this.pushDefault(travelerType);
        this.storeLocal(travelerLocal);
        this.travelerLocals.put(advice, travelerLocal);
    }

    private void defineParameterHolderVars(Advice advice) {
        HashMap<Integer, Integer> locals = Maps.newHashMap();
        int argIndex = 0;
        for (Advice.AdviceParameter adviceParameter : advice.onBeforeParameters()) {
            if (adviceParameter.kind() != Advice.ParameterKind.METHOD_ARG) continue;
            if (adviceParameter.type().equals(parameterHolderType)) {
                int local = this.newLocal(parameterHolderImplType);
                this.visitInsn(1);
                this.storeLocal(local);
                locals.put(argIndex, local);
            }
            ++argIndex;
        }
        this.parameterHolderLocals.put(advice, locals);
    }

    private void invokeOnBefore(Advice advice, @Nullable Integer travelerLocal) {
        Method onBeforeAdvice = advice.onBeforeAdvice();
        if (onBeforeAdvice == null) {
            return;
        }
        Integer enabledLocal = this.enabledLocals.get(advice);
        Label onBeforeBlockEnd = null;
        if (enabledLocal != null) {
            if (this.name.equals("<init>")) {
                this.loadLocal(enabledLocal);
            } else {
                onBeforeBlockEnd = new Label();
                this.loadLocal(enabledLocal);
                this.visitJumpInsn(153, onBeforeBlockEnd);
            }
        }
        Map<Integer, Integer> parameterHolderLocals = Preconditions.checkNotNull(this.parameterHolderLocals.get(advice));
        this.loadMethodParameters(advice.onBeforeParameters(), 0, null, advice.adviceType(), OnBefore.class, false, parameterHolderLocals, advice.pointcut().nestingGroup(), advice.pointcut().suppressionKey(), new Object[0]);
        if (enabledLocal != null && this.name.equals("<init>")) {
            String descriptor = "(Z" + onBeforeAdvice.getDescriptor().substring(1);
            this.visitMethodInsn(184, advice.adviceType().getInternalName(), onBeforeAdvice.getName(), descriptor, false);
        } else {
            this.visitMethodInsn(184, advice.adviceType().getInternalName(), onBeforeAdvice.getName(), onBeforeAdvice.getDescriptor(), false);
        }
        if (travelerLocal != null) {
            this.storeLocal(travelerLocal);
        }
        for (Map.Entry<Integer, Integer> entry : parameterHolderLocals.entrySet()) {
            boolean primitive;
            int argIndex = entry.getKey();
            int parameterHolderLocal = entry.getValue();
            this.loadLocal(parameterHolderLocal);
            this.invokeVirtual(parameterHolderImplType, parameterHolderImplGetMethod);
            Type argType = this.getArgumentTypes()[argIndex];
            boolean bl = primitive = argType.getSort() < 9;
            if (primitive) {
                this.unbox(argType);
            } else {
                this.checkCast(argType);
            }
            this.storeArg(argIndex);
        }
        if (onBeforeBlockEnd != null) {
            this.visitLabel(onBeforeBlockEnd);
            this.visitImplicitFrame(new Object[0]);
        }
    }

    private void saveArgsForMethodExit() {
        int numSavedArgs = this.getNumSavedArgsNeeded();
        if (numSavedArgs == 0) {
            return;
        }
        this.savedArgLocals = new int[numSavedArgs];
        for (int i = 0; i < numSavedArgs; ++i) {
            this.savedArgLocals[i] = this.newLocal(this.argumentTypes[i]);
            this.loadArg(i);
            this.storeLocal(this.savedArgLocals[i]);
        }
    }

    private int getNumSavedArgsNeeded() {
        int numSaveArgsNeeded = 0;
        for (Advice advice : this.advisors) {
            numSaveArgsNeeded = Math.max(numSaveArgsNeeded, this.getNum(advice.onReturnParameters()));
            numSaveArgsNeeded = Math.max(numSaveArgsNeeded, this.getNum(advice.onAfterParameters()));
            numSaveArgsNeeded = Math.max(numSaveArgsNeeded, this.getNum(advice.onThrowParameters()));
        }
        return numSaveArgsNeeded;
    }

    private int getNum(List<Advice.AdviceParameter> adviceParameters) {
        int numSaveArgsNeeded = 0;
        for (Advice.AdviceParameter parameter : adviceParameters) {
            if (parameter.kind() == Advice.ParameterKind.METHOD_ARG_ARRAY) {
                return this.argumentTypes.length;
            }
            if (parameter.kind() != Advice.ParameterKind.METHOD_ARG) continue;
            ++numSaveArgsNeeded;
        }
        return numSaveArgsNeeded;
    }

    private void visitOnReturnAdvice(Advice advice, int opcode) {
        Method onReturnAdvice = advice.onReturnAdvice();
        if (onReturnAdvice == null) {
            return;
        }
        Integer enabledLocal = this.enabledLocals.get(advice);
        Label onReturnBlockEnd = null;
        if (enabledLocal != null) {
            onReturnBlockEnd = new Label();
            this.loadLocal(enabledLocal);
            this.visitJumpInsn(153, onReturnBlockEnd);
        }
        this.weaveOnReturnAdvice(opcode, advice, onReturnAdvice);
        if (onReturnBlockEnd != null) {
            this.visitLabel(onReturnBlockEnd);
            if (this.returnType.getSort() == 0) {
                this.visitImplicitFrame(new Object[0]);
            } else {
                this.visitImplicitFrame(WeavingMethodVisitor.convert(this.returnType));
            }
        }
    }

    private void weaveOnReturnAdvice(int opcode, Advice advice, Method onReturnAdvice) {
        if (onReturnAdvice.getArgumentTypes().length > 0) {
            Object[] stack;
            int startIndex;
            Advice.AdviceParameter parameter = (Advice.AdviceParameter)advice.onReturnParameters().get(0);
            boolean leaveReturnValueOnStack = onReturnAdvice.getReturnType().getSort() == 0;
            switch (parameter.kind()) {
                case RETURN: {
                    this.loadNonOptionalReturnValue(opcode, parameter, leaveReturnValueOnStack);
                    startIndex = 1;
                    if (leaveReturnValueOnStack && opcode != 177) {
                        stack = new Object[]{WeavingMethodVisitor.convert(this.returnType), WeavingMethodVisitor.convert(parameter.type())};
                        break;
                    }
                    stack = new Object[]{WeavingMethodVisitor.convert(parameter.type())};
                    break;
                }
                case OPTIONAL_RETURN: {
                    this.loadOptionalReturnValue(opcode, leaveReturnValueOnStack);
                    startIndex = 1;
                    if (leaveReturnValueOnStack && opcode != 177) {
                        stack = new Object[]{WeavingMethodVisitor.convert(this.returnType), WeavingMethodVisitor.convert(parameter.type())};
                        break;
                    }
                    stack = new Object[]{WeavingMethodVisitor.convert(parameter.type())};
                    break;
                }
                default: {
                    startIndex = 0;
                    if (opcode == 177) {
                        stack = new Object[]{};
                        break;
                    }
                    if (onReturnAdvice.getReturnType().getSort() == 0) {
                        stack = new Object[]{WeavingMethodVisitor.convert(this.returnType)};
                        break;
                    }
                    this.pop();
                    stack = new Object[]{};
                }
            }
            this.loadMethodParameters(advice.onReturnParameters(), startIndex, this.travelerLocals.get(advice), advice.adviceType(), OnReturn.class, true, null, advice.pointcut().nestingGroup(), advice.pointcut().suppressionKey(), stack);
        } else if (onReturnAdvice.getReturnType().getSort() != 0 && opcode != 177) {
            this.pop();
        }
        this.visitMethodInsn(184, advice.adviceType().getInternalName(), onReturnAdvice.getName(), onReturnAdvice.getDescriptor(), false);
        if (onReturnAdvice.getReturnType().getSort() != 0 && opcode == 177) {
            this.pop();
        }
    }

    private void loadNonOptionalReturnValue(int opcode, Advice.AdviceParameter parameter, boolean dup) {
        if (opcode == 177) {
            logger.warn("cannot use @BindReturn on a @Pointcut returning void");
            this.pushDefault(parameter.type());
        } else {
            boolean primitive = parameter.type().getSort() < 9;
            this.loadReturnValue(opcode, dup, !primitive);
        }
    }

    private void loadOptionalReturnValue(int opcode, boolean dup) {
        if (opcode == 177) {
            this.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/VoidReturn", "getInstance", "()Lorg/glowroot/agent/plugin/api/weaving/OptionalReturn;", false);
        } else {
            this.loadReturnValue(opcode, dup, true);
            this.visitMethodInsn(184, "org/glowroot/agent/bytecode/api/NonVoidReturn", "create", "(Ljava/lang/Object;)Lorg/glowroot/agent/plugin/api/weaving/OptionalReturn;", false);
        }
    }

    private void loadReturnValue(int opcode, boolean dup, boolean autobox) {
        if (dup) {
            if (opcode == 173 || opcode == 175) {
                this.visitInsn(92);
            } else {
                this.visitInsn(89);
            }
        }
        if (autobox && opcode != 176 && opcode != 191) {
            this.box(this.returnType);
        }
    }

    private void visitOnThrowAdvice(Advice advice) {
        Method onThrowAdvice = advice.onThrowAdvice();
        if (onThrowAdvice == null) {
            return;
        }
        Integer enabledLocal = this.enabledLocals.get(advice);
        Label onThrowBlockEnd = null;
        if (enabledLocal != null) {
            onThrowBlockEnd = new Label();
            this.loadLocal(enabledLocal);
            this.visitJumpInsn(153, onThrowBlockEnd);
        }
        if (onThrowAdvice.getArgumentTypes().length > 0) {
            Object[] stack;
            int startIndex;
            if (((Advice.AdviceParameter)advice.onThrowParameters().get(0)).kind() == Advice.ParameterKind.THROWABLE) {
                this.visitInsn(89);
                startIndex = 1;
                stack = new Object[]{"java/lang/Throwable", "java/lang/Throwable"};
            } else {
                startIndex = 0;
                stack = new Object[]{"java/lang/Throwable"};
            }
            this.loadMethodParameters(advice.onThrowParameters(), startIndex, this.travelerLocals.get(advice), advice.adviceType(), OnThrow.class, true, null, advice.pointcut().nestingGroup(), advice.pointcut().suppressionKey(), stack);
        }
        this.visitMethodInsn(184, advice.adviceType().getInternalName(), onThrowAdvice.getName(), onThrowAdvice.getDescriptor(), false);
        if (onThrowBlockEnd != null) {
            this.visitLabel(onThrowBlockEnd);
            this.visitImplicitFrame("java/lang/Throwable");
        }
    }

    private void visitOnAfterAdvice(Advice advice, boolean insideCatchHandler) {
        Method onAfterAdvice = advice.onAfterAdvice();
        if (onAfterAdvice == null) {
            return;
        }
        Integer enabledLocal = this.enabledLocals.get(advice);
        Label onAfterBlockEnd = null;
        if (enabledLocal != null) {
            onAfterBlockEnd = new Label();
            this.loadLocal(enabledLocal);
            this.visitJumpInsn(153, onAfterBlockEnd);
        }
        this.loadMethodParameters(advice.onAfterParameters(), 0, this.travelerLocals.get(advice), advice.adviceType(), OnAfter.class, true, null, advice.pointcut().nestingGroup(), advice.pointcut().suppressionKey(), new Object[0]);
        this.visitMethodInsn(184, advice.adviceType().getInternalName(), onAfterAdvice.getName(), onAfterAdvice.getDescriptor(), false);
        if (onAfterBlockEnd != null) {
            this.visitLabel(onAfterBlockEnd);
            if (insideCatchHandler) {
                this.visitImplicitFrame("java/lang/Throwable");
            } else if (this.returnType.getSort() == 0) {
                this.visitImplicitFrame(new Object[0]);
            } else {
                this.visitImplicitFrame(WeavingMethodVisitor.convert(this.returnType));
            }
        }
    }

    private void resetCurrentNestingGroupIfNeeded(boolean insideCatchHandler) {
        ListIterator i = this.advisors.listIterator(this.advisors.size());
        while (i.hasPrevious()) {
            Integer prevSuppressionKeyIdLocal;
            Advice advice = (Advice)i.previous();
            Integer prevNestingGroupIdLocal = this.prevNestingGroupIdLocals.get(advice);
            if (prevNestingGroupIdLocal != null) {
                this.loadLocal(prevNestingGroupIdLocal);
                this.visitInsn(2);
                Label label = new Label();
                this.visitJumpInsn(159, label);
                Preconditions.checkNotNull(this.threadContextLocal);
                this.loadLocal(this.threadContextLocal);
                this.loadLocal(prevNestingGroupIdLocal);
                this.visitMethodInsn(185, threadContextPlusType.getInternalName(), "setCurrentNestingGroupId", "(I)V", true);
                this.visitLabel(label);
                if (insideCatchHandler) {
                    this.visitImplicitFrame("java/lang/Throwable");
                } else if (this.returnType.getSort() == 0) {
                    this.visitImplicitFrame(new Object[0]);
                } else {
                    this.visitImplicitFrame(WeavingMethodVisitor.convert(this.returnType));
                }
            }
            if ((prevSuppressionKeyIdLocal = this.prevSuppressionKeyIdLocals.get(advice)) == null) continue;
            this.loadLocal(prevSuppressionKeyIdLocal);
            this.visitInsn(2);
            Label label = new Label();
            this.visitJumpInsn(159, label);
            Preconditions.checkNotNull(this.threadContextLocal);
            this.loadLocal(this.threadContextLocal);
            this.loadLocal(prevSuppressionKeyIdLocal);
            this.visitMethodInsn(185, threadContextPlusType.getInternalName(), "setCurrentSuppressionKeyId", "(I)V", true);
            this.visitLabel(label);
            if (insideCatchHandler) {
                this.visitImplicitFrame("java/lang/Throwable");
                continue;
            }
            if (this.returnType.getSort() == 0) {
                this.visitImplicitFrame(new Object[0]);
                continue;
            }
            this.visitImplicitFrame(WeavingMethodVisitor.convert(this.returnType));
        }
    }

    private void loadMethodParameters(List<Advice.AdviceParameter> parameters, int startIndex, @Nullable Integer travelerLocal, Type adviceType, Class<? extends Annotation> annotationType, boolean useSavedArgs, @Nullable Map<Integer, Integer> parameterHolderLocals, String nestingGroup, String suppressionKey, Object ... stack) {
        int argIndex = 0;
        block11: for (int i = startIndex; i < parameters.size(); ++i) {
            Advice.AdviceParameter parameter = parameters.get(i);
            switch (parameter.kind()) {
                case RECEIVER: {
                    this.loadTarget();
                    continue block11;
                }
                case METHOD_ARG: {
                    this.loadMethodParameter(adviceType, annotationType, argIndex, parameter, useSavedArgs);
                    if (parameterHolderLocals != null && parameter.type().getClassName().equals(ParameterHolder.class.getName())) {
                        this.invokeStatic(parameterHolderImplType, parameterHolderImplCreateMethod);
                        this.dup();
                        this.storeLocal(Preconditions.checkNotNull(parameterHolderLocals.get(argIndex)));
                    }
                    ++argIndex;
                    continue block11;
                }
                case METHOD_ARG_ARRAY: {
                    this.loadArgArray(useSavedArgs);
                    continue block11;
                }
                case METHOD_NAME: {
                    this.loadMethodName();
                    continue block11;
                }
                case TRAVELER: {
                    this.loadTraveler(travelerLocal, adviceType, annotationType, parameter);
                    continue block11;
                }
                case CLASS_META: {
                    Preconditions.checkNotNull(this.metaHolderInternalName);
                    this.loadClassMeta(parameter);
                    continue block11;
                }
                case METHOD_META: {
                    Preconditions.checkNotNull(this.metaHolderInternalName);
                    Preconditions.checkNotNull(this.methodMetaGroupUniqueNum);
                    this.loadMethodMeta(parameter);
                    continue block11;
                }
                case THREAD_CONTEXT: {
                    Preconditions.checkNotNull(this.threadContextLocal);
                    this.loadLocal(this.threadContextLocal);
                    continue block11;
                }
                case OPTIONAL_THREAD_CONTEXT: {
                    Preconditions.checkNotNull(this.threadContextHolderLocal);
                    Preconditions.checkNotNull(this.threadContextLocal);
                    this.loadOptionalThreadContext(nestingGroup, suppressionKey, stack);
                    continue block11;
                }
                default: {
                    logger.warn("the @{} method in {} has an unexpected parameter kind {} at index {}", new Object[]{annotationType.getSimpleName(), adviceType.getClassName(), parameter.kind(), i});
                    this.pushDefault(parameter.type());
                }
            }
        }
    }

    private void loadTarget() {
        if (!Modifier.isStatic(this.access)) {
            this.visitVarInsn(25, 0);
        } else {
            this.visitLdcInsn(this.owner.getClassName());
            this.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
        }
    }

    private void loadMethodParameter(Type adviceType, Class<? extends Annotation> annotationType, int argIndex, Advice.AdviceParameter parameter, boolean useSavedArg) {
        boolean primitive;
        if (argIndex >= this.argumentTypes.length) {
            logger.warn("the @{} method in {} has more @{} arguments than the number of args in the target method", annotationType.getSimpleName(), adviceType.getClassName(), BindParameter.class.getSimpleName());
            this.pushDefault(parameter.type());
            return;
        }
        if (useSavedArg) {
            this.loadLocal(this.savedArgLocals[argIndex]);
        } else {
            this.loadArg(argIndex);
        }
        boolean bl = primitive = parameter.type().getSort() < 9;
        if (!primitive) {
            this.box(this.argumentTypes[argIndex]);
        }
    }

    private void loadArgArray(boolean useSavedArgs) {
        this.push(this.argumentTypes.length);
        this.newArray(objectType);
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            this.dup();
            this.push(i);
            if (useSavedArgs) {
                this.loadLocal(this.savedArgLocals[i]);
            } else {
                this.loadArg(i);
            }
            this.box(this.argumentTypes[i]);
            this.arrayStore(objectType);
        }
    }

    private void loadMethodName() {
        this.visitLdcInsn(this.name);
    }

    private void loadTraveler(@Nullable Integer travelerLocal, Type adviceType, Class<? extends Annotation> annotationType, Advice.AdviceParameter parameter) {
        if (travelerLocal == null) {
            logger.warn("the @{} method in {} requested @{} but @{} returns void", annotationType.getSimpleName(), adviceType.getClassName(), BindTraveler.class.getSimpleName(), OnBefore.class.getSimpleName());
            this.pushDefault(parameter.type());
        } else {
            this.loadLocal(travelerLocal);
        }
    }

    @RequiresNonNull(value={"metaHolderInternalName"})
    private void loadClassMeta(Advice.AdviceParameter parameter) {
        Type classMetaFieldType = parameter.type();
        String classMetaFieldName = "glowroot$class$meta$" + classMetaFieldType.getInternalName().replace('/', '$');
        if (this.bootstrapClassLoader) {
            int index = BootstrapMetaHolders.reserveClassMetaHolderIndex(this.metaHolderInternalName, classMetaFieldName);
            this.push(index);
            this.visitMethodInsn(184, bytecodeType.getInternalName(), "getClassMeta", "(I)Ljava/lang/Object;", false);
            this.mv.visitTypeInsn(192, classMetaFieldType.getInternalName());
        } else {
            this.visitFieldInsn(178, this.metaHolderInternalName, classMetaFieldName, classMetaFieldType.getDescriptor());
        }
    }

    @RequiresNonNull(value={"metaHolderInternalName", "methodMetaGroupUniqueNum"})
    private void loadMethodMeta(Advice.AdviceParameter parameter) {
        Type methodMetaFieldType = parameter.type();
        String methodMetaFieldName = "glowroot$method$meta$" + this.methodMetaGroupUniqueNum + '$' + methodMetaFieldType.getInternalName().replace('/', '$');
        if (this.bootstrapClassLoader) {
            int index = BootstrapMetaHolders.reserveMethodMetaHolderIndex(this.metaHolderInternalName, methodMetaFieldName);
            this.push(index);
            this.visitMethodInsn(184, bytecodeType.getInternalName(), "getMethodMeta", "(I)Ljava/lang/Object;", false);
            this.mv.visitTypeInsn(192, methodMetaFieldType.getInternalName());
        } else {
            this.visitFieldInsn(178, this.metaHolderInternalName, methodMetaFieldName, methodMetaFieldType.getDescriptor());
        }
    }

    @RequiresNonNull(value={"threadContextHolderLocal", "threadContextLocal"})
    private void loadOptionalThreadContext(String nestingGroup, String suppressionKey, Object ... stack) {
        this.loadMaybeNullThreadContext(stack);
        Label label = new Label();
        this.visitJumpInsn(199, label);
        this.loadLocal(this.threadContextHolderLocal);
        if (nestingGroup.isEmpty()) {
            this.mv.visitLdcInsn(0);
        } else {
            this.mv.visitLdcInsn(WeavingMethodVisitor.getNestingGroupId(nestingGroup));
        }
        if (suppressionKey.isEmpty()) {
            this.mv.visitLdcInsn(0);
        } else {
            this.mv.visitLdcInsn(WeavingMethodVisitor.getSuppressionKeyId(suppressionKey));
        }
        this.visitMethodInsn(184, bytecodeType.getInternalName(), "createOptionalThreadContext", "(" + fastThreadContextThreadLocalHolderType.getDescriptor() + "II)" + threadContextPlusType.getDescriptor(), false);
        this.storeLocal(this.threadContextLocal);
        this.visitLabel(label);
        this.visitImplicitFrame(stack);
        this.loadLocal(this.threadContextLocal);
    }

    @RequiresNonNull(value={"threadContextHolderLocal", "threadContextLocal"})
    private void loadMaybeNullThreadContext(Object ... stack) {
        this.loadLocal(this.threadContextHolderLocal);
        Label label = new Label();
        this.visitJumpInsn(199, label);
        this.visitMethodInsn(184, bytecodeType.getInternalName(), "getCurrentThreadContextHolder", "()" + fastThreadContextThreadLocalHolderType.getDescriptor(), false);
        this.storeLocal(this.threadContextHolderLocal);
        this.visitLabel(label);
        this.visitImplicitFrame(stack);
        this.loadLocal(this.threadContextHolderLocal);
        this.visitMethodInsn(182, fastThreadContextThreadLocalHolderType.getInternalName(), "get", "()" + threadContextPlusType.getDescriptor(), false);
        this.dup();
        this.storeLocal(this.threadContextLocal);
    }

    private void visitImplicitFrame(Object ... stack) {
        if (this.frames) {
            super.visitFrame(-1, this.implicitFrameLocals.length, this.implicitFrameLocals, stack.length, stack);
        }
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        Preconditions.checkState(type == -1, "Unexpected frame type: " + type);
        int nExtraLocal = nLocal - this.implicitFrameLocals.length;
        if (this.implicitFrameLocals.length >= nLocal) {
            nExtraLocal = 0;
        } else {
            int i = 0;
            int j = 0;
            while (i < nLocal && j < this.implicitFrameLocals.length) {
                Object currLocal = Preconditions.checkNotNull(local)[i++];
                Object currImplicitFrameLocal = this.implicitFrameLocals[j++];
                if (currLocal != TOP || currImplicitFrameLocal != LONG && currImplicitFrameLocal != DOUBLE) continue;
                ++i;
            }
            nExtraLocal = nLocal - i;
        }
        if (nExtraLocal > 0) {
            Object[] overlay = new Object[this.implicitFrameLocals.length + nExtraLocal];
            System.arraycopy(this.implicitFrameLocals, 0, overlay, 0, this.implicitFrameLocals.length);
            System.arraycopy(Preconditions.checkNotNull(local), nLocal - nExtraLocal, overlay, this.implicitFrameLocals.length, nExtraLocal);
            super.visitFrame(type, overlay.length, overlay, nStack, stack);
        } else {
            super.visitFrame(type, this.implicitFrameLocals.length, this.implicitFrameLocals, nStack, stack);
        }
    }

    private void pushDefault(Type type) {
        WeavingMethodVisitor.pushDefault(this, type);
    }

    static void pushDefault(MethodVisitor mv, Type type) {
        switch (type.getSort()) {
            case 1: {
                mv.visitInsn(3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                mv.visitInsn(3);
                break;
            }
            case 6: {
                mv.visitInsn(11);
                break;
            }
            case 7: {
                mv.visitInsn(9);
                break;
            }
            case 8: {
                mv.visitInsn(14);
                break;
            }
            default: {
                mv.visitInsn(1);
            }
        }
    }

    private void cleanUpStackIfNeeded(int opcode) {
        int expectedStackFrameSize = WeavingMethodVisitor.getExpectedStackFrameSize(opcode);
        if (this.stackFrame.size() == expectedStackFrameSize) {
            return;
        }
        if (this.stackFrame.size() < expectedStackFrameSize) {
            return;
        }
        if (expectedStackFrameSize == 0) {
            this.cleanExcessFramesLeavingNothing();
            return;
        }
        if (expectedStackFrameSize == 1) {
            this.cleanExcessFramesLeavingOneWord();
            return;
        }
        this.cleanExcessFramesLeavingDoubleWord();
    }

    private void cleanExcessFramesLeavingNothing() {
        int excessFrames = this.stackFrame.size();
        for (int i = excessFrames - 1; i >= 0; --i) {
            if (this.stackFrame.get(i) == SECOND_WORD) {
                this.pop2();
                --i;
                continue;
            }
            this.pop();
        }
    }

    private void cleanExcessFramesLeavingOneWord() {
        int excessFrames = this.stackFrame.size() - 1;
        for (int i = excessFrames - 1; i >= 0; --i) {
            if (this.stackFrame.get(i) == SECOND_WORD) {
                super.visitInsn(91);
                this.pop();
                this.pop2();
                --i;
                continue;
            }
            this.swap();
            this.pop();
        }
    }

    private void cleanExcessFramesLeavingDoubleWord() {
        int excessFrames = this.stackFrame.size() - 2;
        for (int i = excessFrames - 1; i >= 0; --i) {
            if (this.stackFrame.get(i) == SECOND_WORD) {
                super.visitInsn(94);
                this.pop2();
                this.pop2();
                --i;
                continue;
            }
            super.visitInsn(93);
            this.pop2();
            this.pop();
        }
    }

    private static Object convert(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return INTEGER;
            }
            case 6: {
                return FLOAT;
            }
            case 7: {
                return LONG;
            }
            case 8: {
                return DOUBLE;
            }
            case 9: {
                return type.getDescriptor();
            }
            case 10: {
                return type.getInternalName();
            }
            case 11: {
                return type.getDescriptor();
            }
        }
        throw new IllegalStateException("Unexpected type: " + type.getDescriptor());
    }

    private static boolean hasOtherEnabledFactors(Advice advice, String nestingGroup, String suppressibleUsingKey) {
        return !nestingGroup.isEmpty() || !suppressibleUsingKey.isEmpty() || advice.hasBindThreadContext() && !advice.hasBindOptionalThreadContext();
    }

    private static int getNestingGroupId(String nestingGroup) {
        Integer nullableNestingGroupId = (Integer)nestingGroupIds.get(nestingGroup);
        if (nullableNestingGroupId != null) {
            return nullableNestingGroupId;
        }
        int nestingGroupId = nestingGroupIdCounter.getAndIncrement();
        Integer previousValue = nestingGroupIds.putIfAbsent(nestingGroup, nestingGroupId);
        if (previousValue == null) {
            return nestingGroupId;
        }
        return previousValue;
    }

    private static int getSuppressionKeyId(String suppressionKey) {
        Integer nullableSuppressionKeyId = (Integer)suppressionKeyIds.get(suppressionKey);
        if (nullableSuppressionKeyId != null) {
            return nullableSuppressionKeyId;
        }
        int suppressionKeyId = suppressionKeyIdCounter.getAndIncrement();
        Integer previousValue = suppressionKeyIds.putIfAbsent(suppressionKey, suppressionKeyId);
        if (previousValue == null) {
            return suppressionKeyId;
        }
        return previousValue;
    }

    private static boolean isReturnOpcode(int opcode) {
        return opcode >= 172 && opcode <= 177;
    }

    private static int getExpectedStackFrameSize(int opcode) {
        if (opcode == 172 || opcode == 174 || opcode == 176) {
            return 1;
        }
        if (opcode == 173 || opcode == 175) {
            return 2;
        }
        return 0;
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface CatchHandler {
        public Label catchStartLabel();

        public List<Advice> advisors();
    }
}

