-- MariaDB dump 10.19  Distrib 10.11.2-MariaDB, for osx10.18 (arm64)
--
-- Host: localhost    Database: jwdb
-- ------------------------------------------------------
-- Server version	10.11.2-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `SHKActivities`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKActivities` (
  `Id` varchar(100) NOT NULL,
  `ActivitySetDefinitionId` varchar(90) DEFAULT NULL,
  `ActivityDefinitionId` varchar(90) NOT NULL,
  `Process` decimal(19,0) NOT NULL,
  `TheResource` decimal(19,0) DEFAULT NULL,
  `PDefName` varchar(200) NOT NULL,
  `ProcessId` varchar(200) NOT NULL,
  `ResourceId` varchar(100) DEFAULT NULL,
  `State` decimal(19,0) NOT NULL,
  `BlockActivityId` varchar(100) DEFAULT NULL,
  `Performer` varchar(100) DEFAULT NULL,
  `IsPerformerAsynchronous` smallint(6) DEFAULT NULL,
  `Priority` int(11) DEFAULT NULL,
  `Name` varchar(254) DEFAULT NULL,
  `Activated` bigint(20) NOT NULL,
  `ActivatedTZO` bigint(20) NOT NULL,
  `Accepted` bigint(20) DEFAULT NULL,
  `AcceptedTZO` bigint(20) DEFAULT NULL,
  `LastStateTime` bigint(20) NOT NULL,
  `LastStateTimeTZO` bigint(20) NOT NULL,
  `LimitTime` bigint(20) NOT NULL,
  `LimitTimeTZO` bigint(20) NOT NULL,
  `Description` varchar(254) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKActivities` (`Id`),
  KEY `SHKActivities_TheResource` (`TheResource`),
  KEY `SHKActivities_State` (`State`),
  KEY `I2_SHKActivities` (`Process`,`ActivitySetDefinitionId`,`ActivityDefinitionId`),
  KEY `I3_SHKActivities` (`Process`,`State`),
  CONSTRAINT `SHKActivities_Process` FOREIGN KEY (`Process`) REFERENCES `SHKProcesses` (`oid`),
  CONSTRAINT `SHKActivities_State` FOREIGN KEY (`State`) REFERENCES `SHKActivityStates` (`oid`),
  CONSTRAINT `SHKActivities_TheResource` FOREIGN KEY (`TheResource`) REFERENCES `SHKResourcesTable` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKActivities`
--

LOCK TABLES `SHKActivities` WRITE;
/*!40000 ALTER TABLE `SHKActivities` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKActivities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKActivityData`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKActivityData` (
  `Activity` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` double DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `IsResult` smallint(6) NOT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKActivityData` (`CNT`),
  UNIQUE KEY `I2_SHKActivityData` (`Activity`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKActivityData_Activity` FOREIGN KEY (`Activity`) REFERENCES `SHKActivities` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKActivityData`
--

LOCK TABLES `SHKActivityData` WRITE;
/*!40000 ALTER TABLE `SHKActivityData` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKActivityData` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKActivityDataBLOBs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKActivityDataBLOBs` (
  `ActivityDataWOB` decimal(19,0) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKActivityDataBLOBs` (`ActivityDataWOB`,`OrdNo`),
  CONSTRAINT `SHKActivityDataBLOBs_ActivityDataWOB` FOREIGN KEY (`ActivityDataWOB`) REFERENCES `SHKActivityDataWOB` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKActivityDataBLOBs`
--

LOCK TABLES `SHKActivityDataBLOBs` WRITE;
/*!40000 ALTER TABLE `SHKActivityDataBLOBs` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKActivityDataBLOBs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKActivityDataWOB`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKActivityDataWOB` (
  `Activity` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` double DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `IsResult` smallint(6) NOT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKActivityDataWOB` (`CNT`),
  UNIQUE KEY `I2_SHKActivityDataWOB` (`Activity`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKActivityDataWOB_Activity` FOREIGN KEY (`Activity`) REFERENCES `SHKActivities` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKActivityDataWOB`
--

LOCK TABLES `SHKActivityDataWOB` WRITE;
/*!40000 ALTER TABLE `SHKActivityDataWOB` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKActivityDataWOB` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKActivityStateEventAudits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKActivityStateEventAudits` (
  `KeyValue` varchar(30) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKActivityStateEventAudits` (`KeyValue`),
  UNIQUE KEY `I2_SHKActivityStateEventAudits` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKActivityStateEventAudits`
--

LOCK TABLES `SHKActivityStateEventAudits` WRITE;
/*!40000 ALTER TABLE `SHKActivityStateEventAudits` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKActivityStateEventAudits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKActivityStates`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKActivityStates` (
  `KeyValue` varchar(30) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKActivityStates` (`KeyValue`),
  UNIQUE KEY `I2_SHKActivityStates` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKActivityStates`
--

LOCK TABLES `SHKActivityStates` WRITE;
/*!40000 ALTER TABLE `SHKActivityStates` DISABLE KEYS */;
INSERT INTO `SHKActivityStates` VALUES
('open.running','open.running',1000001,0),
('open.not_running.not_started','open.not_running.not_started',1000003,0),
('open.not_running.suspended','open.not_running.suspended',1000005,0),
('closed.completed','closed.completed',1000007,0),
('closed.terminated','closed.terminated',1000009,0),
('closed.aborted','closed.aborted',1000011,0);
/*!40000 ALTER TABLE `SHKActivityStates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKAndJoinTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKAndJoinTable` (
  `Process` decimal(19,0) NOT NULL,
  `BlockActivity` decimal(19,0) DEFAULT NULL,
  `ActivityDefinitionId` varchar(90) NOT NULL,
  `Activity` decimal(19,0) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKAndJoinTable` (`CNT`),
  KEY `SHKAndJoinTable_BlockActivity` (`BlockActivity`),
  KEY `I2_SHKAndJoinTable` (`Process`,`BlockActivity`,`ActivityDefinitionId`),
  KEY `I3_SHKAndJoinTable` (`Activity`),
  CONSTRAINT `SHKAndJoinTable_Activity` FOREIGN KEY (`Activity`) REFERENCES `SHKActivities` (`oid`),
  CONSTRAINT `SHKAndJoinTable_BlockActivity` FOREIGN KEY (`BlockActivity`) REFERENCES `SHKActivities` (`oid`),
  CONSTRAINT `SHKAndJoinTable_Process` FOREIGN KEY (`Process`) REFERENCES `SHKProcesses` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKAndJoinTable`
--

LOCK TABLES `SHKAndJoinTable` WRITE;
/*!40000 ALTER TABLE `SHKAndJoinTable` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKAndJoinTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKAssignmentEventAudits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKAssignmentEventAudits` (
  `RecordedTime` bigint(20) NOT NULL,
  `RecordedTimeTZO` bigint(20) NOT NULL,
  `TheUsername` varchar(100) NOT NULL,
  `TheType` decimal(19,0) NOT NULL,
  `ActivityId` varchar(100) NOT NULL,
  `ActivityName` varchar(254) DEFAULT NULL,
  `ProcessId` varchar(100) NOT NULL,
  `ProcessName` varchar(254) DEFAULT NULL,
  `ProcessFactoryName` varchar(200) NOT NULL,
  `ProcessFactoryVersion` varchar(20) NOT NULL,
  `ActivityDefinitionId` varchar(90) NOT NULL,
  `ActivityDefinitionName` varchar(90) DEFAULT NULL,
  `ActivityDefinitionType` int(11) NOT NULL,
  `ProcessDefinitionId` varchar(90) NOT NULL,
  `ProcessDefinitionName` varchar(90) DEFAULT NULL,
  `PackageId` varchar(90) NOT NULL,
  `OldResourceUsername` varchar(100) DEFAULT NULL,
  `OldResourceName` varchar(100) DEFAULT NULL,
  `NewResourceUsername` varchar(100) NOT NULL,
  `NewResourceName` varchar(100) DEFAULT NULL,
  `IsAccepted` smallint(6) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKAssignmentEventAudits` (`CNT`),
  KEY `SHKAssignmentEventAudits_TheType` (`TheType`),
  CONSTRAINT `SHKAssignmentEventAudits_TheType` FOREIGN KEY (`TheType`) REFERENCES `SHKEventTypes` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKAssignmentEventAudits`
--

LOCK TABLES `SHKAssignmentEventAudits` WRITE;
/*!40000 ALTER TABLE `SHKAssignmentEventAudits` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKAssignmentEventAudits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKAssignmentsTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKAssignmentsTable` (
  `Activity` decimal(19,0) NOT NULL,
  `TheResource` decimal(19,0) NOT NULL,
  `ActivityId` varchar(100) NOT NULL,
  `ActivityProcessId` varchar(100) NOT NULL,
  `ActivityProcessDefName` varchar(200) NOT NULL,
  `ResourceId` varchar(100) NOT NULL,
  `IsAccepted` smallint(6) NOT NULL,
  `IsValid` smallint(6) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKAssignmentsTable` (`CNT`),
  UNIQUE KEY `I2_SHKAssignmentsTable` (`Activity`,`TheResource`),
  KEY `I3_SHKAssignmentsTable` (`TheResource`,`IsValid`),
  KEY `I4_SHKAssignmentsTable` (`ActivityId`),
  KEY `I5_SHKAssignmentsTable` (`ResourceId`),
  KEY `FK_rnb6mhntls567xpifcfvygkuu` (`ActivityProcessId`),
  CONSTRAINT `FK_183e6adufsi558hl5p4dqkqsx` FOREIGN KEY (`ActivityId`) REFERENCES `SHKActivities` (`Id`),
  CONSTRAINT `FK_rnb6mhntls567xpifcfvygkuu` FOREIGN KEY (`ActivityProcessId`) REFERENCES `SHKProcesses` (`Id`),
  CONSTRAINT `SHKAssignmentsTable_Activity` FOREIGN KEY (`Activity`) REFERENCES `SHKActivities` (`oid`),
  CONSTRAINT `SHKAssignmentsTable_TheResource` FOREIGN KEY (`TheResource`) REFERENCES `SHKResourcesTable` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKAssignmentsTable`
--

LOCK TABLES `SHKAssignmentsTable` WRITE;
/*!40000 ALTER TABLE `SHKAssignmentsTable` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKAssignmentsTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKCounters`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKCounters` (
  `name` varchar(100) NOT NULL,
  `the_number` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKCounters` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKCounters`
--

LOCK TABLES `SHKCounters` WRITE;
/*!40000 ALTER TABLE `SHKCounters` DISABLE KEYS */;
INSERT INTO `SHKCounters` VALUES
('_xpdldata_',201,29504246,0);
/*!40000 ALTER TABLE `SHKCounters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKCreateProcessEventAudits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKCreateProcessEventAudits` (
  `RecordedTime` bigint(20) NOT NULL,
  `RecordedTimeTZO` bigint(20) NOT NULL,
  `TheUsername` varchar(100) NOT NULL,
  `TheType` decimal(19,0) NOT NULL,
  `ProcessId` varchar(100) NOT NULL,
  `ProcessName` varchar(254) DEFAULT NULL,
  `ProcessFactoryName` varchar(200) NOT NULL,
  `ProcessFactoryVersion` varchar(20) NOT NULL,
  `ProcessDefinitionId` varchar(90) NOT NULL,
  `ProcessDefinitionName` varchar(90) DEFAULT NULL,
  `PackageId` varchar(90) NOT NULL,
  `PActivityId` varchar(100) DEFAULT NULL,
  `PProcessId` varchar(100) DEFAULT NULL,
  `PProcessName` varchar(254) DEFAULT NULL,
  `PProcessFactoryName` varchar(200) DEFAULT NULL,
  `PProcessFactoryVersion` varchar(20) DEFAULT NULL,
  `PActivityDefinitionId` varchar(90) DEFAULT NULL,
  `PActivityDefinitionName` varchar(90) DEFAULT NULL,
  `PProcessDefinitionId` varchar(90) DEFAULT NULL,
  `PProcessDefinitionName` varchar(90) DEFAULT NULL,
  `PPackageId` varchar(90) DEFAULT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKCreateProcessEventAudits` (`CNT`),
  KEY `SHKCreateProcessEventAudits_TheType` (`TheType`),
  CONSTRAINT `SHKCreateProcessEventAudits_TheType` FOREIGN KEY (`TheType`) REFERENCES `SHKEventTypes` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKCreateProcessEventAudits`
--

LOCK TABLES `SHKCreateProcessEventAudits` WRITE;
/*!40000 ALTER TABLE `SHKCreateProcessEventAudits` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKCreateProcessEventAudits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKDataEventAudits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKDataEventAudits` (
  `RecordedTime` bigint(20) NOT NULL,
  `RecordedTimeTZO` bigint(20) NOT NULL,
  `TheUsername` varchar(100) NOT NULL,
  `TheType` decimal(19,0) NOT NULL,
  `ActivityId` varchar(100) DEFAULT NULL,
  `ActivityName` varchar(254) DEFAULT NULL,
  `ProcessId` varchar(100) NOT NULL,
  `ProcessName` varchar(254) DEFAULT NULL,
  `ProcessFactoryName` varchar(200) NOT NULL,
  `ProcessFactoryVersion` varchar(20) NOT NULL,
  `ActivityDefinitionId` varchar(90) DEFAULT NULL,
  `ActivityDefinitionName` varchar(90) DEFAULT NULL,
  `ActivityDefinitionType` int(11) DEFAULT NULL,
  `ProcessDefinitionId` varchar(90) NOT NULL,
  `ProcessDefinitionName` varchar(90) DEFAULT NULL,
  `PackageId` varchar(90) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKDataEventAudits` (`CNT`),
  KEY `SHKDataEventAudits_TheType` (`TheType`),
  CONSTRAINT `SHKDataEventAudits_TheType` FOREIGN KEY (`TheType`) REFERENCES `SHKEventTypes` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKDataEventAudits`
--

LOCK TABLES `SHKDataEventAudits` WRITE;
/*!40000 ALTER TABLE `SHKDataEventAudits` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKDataEventAudits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKDeadlines`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKDeadlines` (
  `Process` decimal(19,0) NOT NULL,
  `Activity` decimal(19,0) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `TimeLimit` bigint(20) NOT NULL,
  `TimeLimitTZO` bigint(20) NOT NULL,
  `ExceptionName` varchar(100) NOT NULL,
  `IsSynchronous` smallint(6) NOT NULL,
  `IsExecuted` smallint(6) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKDeadlines` (`CNT`),
  KEY `I2_SHKDeadlines` (`Process`,`TimeLimit`),
  KEY `I3_SHKDeadlines` (`Activity`,`TimeLimit`),
  CONSTRAINT `SHKDeadlines_Activity` FOREIGN KEY (`Activity`) REFERENCES `SHKActivities` (`oid`),
  CONSTRAINT `SHKDeadlines_Process` FOREIGN KEY (`Process`) REFERENCES `SHKProcesses` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKDeadlines`
--

LOCK TABLES `SHKDeadlines` WRITE;
/*!40000 ALTER TABLE `SHKDeadlines` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKDeadlines` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKEventTypes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKEventTypes` (
  `KeyValue` varchar(30) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKEventTypes` (`KeyValue`),
  UNIQUE KEY `I2_SHKEventTypes` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKEventTypes`
--

LOCK TABLES `SHKEventTypes` WRITE;
/*!40000 ALTER TABLE `SHKEventTypes` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKEventTypes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKGroupGroupTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKGroupGroupTable` (
  `sub_gid` decimal(19,0) NOT NULL,
  `groupid` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKGroupGroupTable` (`sub_gid`,`groupid`),
  KEY `I2_SHKGroupGroupTable` (`groupid`),
  CONSTRAINT `SHKGroupGroupTable_groupid` FOREIGN KEY (`groupid`) REFERENCES `SHKGroupTable` (`oid`),
  CONSTRAINT `SHKGroupGroupTable_sub_gid` FOREIGN KEY (`sub_gid`) REFERENCES `SHKGroupTable` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKGroupGroupTable`
--

LOCK TABLES `SHKGroupGroupTable` WRITE;
/*!40000 ALTER TABLE `SHKGroupGroupTable` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKGroupGroupTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKGroupTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKGroupTable` (
  `groupid` varchar(100) NOT NULL,
  `description` varchar(254) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKGroupTable` (`groupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKGroupTable`
--

LOCK TABLES `SHKGroupTable` WRITE;
/*!40000 ALTER TABLE `SHKGroupTable` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKGroupTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKGroupUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKGroupUser` (
  `USERNAME` varchar(100) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKGroupUser` (`USERNAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKGroupUser`
--

LOCK TABLES `SHKGroupUser` WRITE;
/*!40000 ALTER TABLE `SHKGroupUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKGroupUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKGroupUserPackLevelPart`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKGroupUserPackLevelPart` (
  `PARTICIPANTOID` decimal(19,0) NOT NULL,
  `USEROID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKGroupUserPackLevelPart` (`PARTICIPANTOID`,`USEROID`),
  KEY `SHKGroupUserPackLevelPart_USEROID` (`USEROID`),
  CONSTRAINT `SHKGroupUserPackLevelPart_PARTICIPANTOID` FOREIGN KEY (`PARTICIPANTOID`) REFERENCES `SHKPackLevelParticipant` (`oid`),
  CONSTRAINT `SHKGroupUserPackLevelPart_USEROID` FOREIGN KEY (`USEROID`) REFERENCES `SHKGroupUser` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKGroupUserPackLevelPart`
--

LOCK TABLES `SHKGroupUserPackLevelPart` WRITE;
/*!40000 ALTER TABLE `SHKGroupUserPackLevelPart` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKGroupUserPackLevelPart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKGroupUserProcLevelPart`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKGroupUserProcLevelPart` (
  `PARTICIPANTOID` decimal(19,0) NOT NULL,
  `USEROID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKGroupUserProcLevelPart` (`PARTICIPANTOID`,`USEROID`),
  KEY `SHKGroupUserProcLevelPart_USEROID` (`USEROID`),
  CONSTRAINT `SHKGroupUserProcLevelPart_PARTICIPANTOID` FOREIGN KEY (`PARTICIPANTOID`) REFERENCES `SHKProcLevelParticipant` (`oid`),
  CONSTRAINT `SHKGroupUserProcLevelPart_USEROID` FOREIGN KEY (`USEROID`) REFERENCES `SHKGroupUser` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKGroupUserProcLevelPart`
--

LOCK TABLES `SHKGroupUserProcLevelPart` WRITE;
/*!40000 ALTER TABLE `SHKGroupUserProcLevelPart` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKGroupUserProcLevelPart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKNewEventAuditData`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKNewEventAuditData` (
  `DataEventAudit` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` float DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKNewEventAuditData` (`CNT`),
  UNIQUE KEY `I2_SHKNewEventAuditData` (`DataEventAudit`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKNewEventAuditData_DataEventAudit` FOREIGN KEY (`DataEventAudit`) REFERENCES `SHKDataEventAudits` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKNewEventAuditData`
--

LOCK TABLES `SHKNewEventAuditData` WRITE;
/*!40000 ALTER TABLE `SHKNewEventAuditData` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKNewEventAuditData` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKNewEventAuditDataBLOBs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKNewEventAuditDataBLOBs` (
  `NewEventAuditDataWOB` decimal(19,0) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKNewEventAuditDataBLOBs` (`NewEventAuditDataWOB`,`OrdNo`),
  CONSTRAINT `SHKNewEventAuditDataBLOBs_NewEventAuditDataWOB` FOREIGN KEY (`NewEventAuditDataWOB`) REFERENCES `SHKNewEventAuditDataWOB` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKNewEventAuditDataBLOBs`
--

LOCK TABLES `SHKNewEventAuditDataBLOBs` WRITE;
/*!40000 ALTER TABLE `SHKNewEventAuditDataBLOBs` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKNewEventAuditDataBLOBs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKNewEventAuditDataWOB`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKNewEventAuditDataWOB` (
  `DataEventAudit` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` float DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKNewEventAuditDataWOB` (`CNT`),
  UNIQUE KEY `I2_SHKNewEventAuditDataWOB` (`DataEventAudit`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKNewEventAuditDataWOB_DataEventAudit` FOREIGN KEY (`DataEventAudit`) REFERENCES `SHKDataEventAudits` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKNewEventAuditDataWOB`
--

LOCK TABLES `SHKNewEventAuditDataWOB` WRITE;
/*!40000 ALTER TABLE `SHKNewEventAuditDataWOB` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKNewEventAuditDataWOB` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKNextXPDLVersions`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKNextXPDLVersions` (
  `XPDLId` varchar(90) NOT NULL,
  `NextVersion` varchar(20) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKNextXPDLVersions` (`XPDLId`,`NextVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKNextXPDLVersions`
--

LOCK TABLES `SHKNextXPDLVersions` WRITE;
/*!40000 ALTER TABLE `SHKNextXPDLVersions` DISABLE KEYS */;
INSERT INTO `SHKNextXPDLVersions` VALUES
('crm','2',1000201,0),
('dashboard','2',1000205,0),
('expenseclaim','2',1000209,0),
('isr','2',1000213,0),
('JogetDxShowcase','2',1000217,0);
/*!40000 ALTER TABLE `SHKNextXPDLVersions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKNormalUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKNormalUser` (
  `USERNAME` varchar(100) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKNormalUser` (`USERNAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKNormalUser`
--

LOCK TABLES `SHKNormalUser` WRITE;
/*!40000 ALTER TABLE `SHKNormalUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKNormalUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKOldEventAuditData`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKOldEventAuditData` (
  `DataEventAudit` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` float DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKOldEventAuditData` (`CNT`),
  UNIQUE KEY `I2_SHKOldEventAuditData` (`DataEventAudit`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKOldEventAuditData_DataEventAudit` FOREIGN KEY (`DataEventAudit`) REFERENCES `SHKDataEventAudits` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKOldEventAuditData`
--

LOCK TABLES `SHKOldEventAuditData` WRITE;
/*!40000 ALTER TABLE `SHKOldEventAuditData` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKOldEventAuditData` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKOldEventAuditDataBLOBs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKOldEventAuditDataBLOBs` (
  `OldEventAuditDataWOB` decimal(19,0) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKOldEventAuditDataBLOBs` (`OldEventAuditDataWOB`,`OrdNo`),
  CONSTRAINT `SHKOldEventAuditDataBLOBs_OldEventAuditDataWOB` FOREIGN KEY (`OldEventAuditDataWOB`) REFERENCES `SHKOldEventAuditDataWOB` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKOldEventAuditDataBLOBs`
--

LOCK TABLES `SHKOldEventAuditDataBLOBs` WRITE;
/*!40000 ALTER TABLE `SHKOldEventAuditDataBLOBs` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKOldEventAuditDataBLOBs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKOldEventAuditDataWOB`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKOldEventAuditDataWOB` (
  `DataEventAudit` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` float DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKOldEventAuditDataWOB` (`CNT`),
  UNIQUE KEY `I2_SHKOldEventAuditDataWOB` (`DataEventAudit`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKOldEventAuditDataWOB_DataEventAudit` FOREIGN KEY (`DataEventAudit`) REFERENCES `SHKDataEventAudits` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKOldEventAuditDataWOB`
--

LOCK TABLES `SHKOldEventAuditDataWOB` WRITE;
/*!40000 ALTER TABLE `SHKOldEventAuditDataWOB` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKOldEventAuditDataWOB` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKPackLevelParticipant`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKPackLevelParticipant` (
  `PARTICIPANT_ID` varchar(90) NOT NULL,
  `PACKAGEOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKPackLevelParticipant` (`PARTICIPANT_ID`,`PACKAGEOID`),
  KEY `SHKPackLevelParticipant_PACKAGEOID` (`PACKAGEOID`),
  CONSTRAINT `SHKPackLevelParticipant_PACKAGEOID` FOREIGN KEY (`PACKAGEOID`) REFERENCES `SHKXPDLParticipantPackage` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKPackLevelParticipant`
--

LOCK TABLES `SHKPackLevelParticipant` WRITE;
/*!40000 ALTER TABLE `SHKPackLevelParticipant` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKPackLevelParticipant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKPackLevelXPDLApp`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKPackLevelXPDLApp` (
  `APPLICATION_ID` varchar(90) NOT NULL,
  `PACKAGEOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKPackLevelXPDLApp` (`APPLICATION_ID`,`PACKAGEOID`),
  KEY `SHKPackLevelXPDLApp_PACKAGEOID` (`PACKAGEOID`),
  CONSTRAINT `SHKPackLevelXPDLApp_PACKAGEOID` FOREIGN KEY (`PACKAGEOID`) REFERENCES `SHKXPDLApplicationPackage` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKPackLevelXPDLApp`
--

LOCK TABLES `SHKPackLevelXPDLApp` WRITE;
/*!40000 ALTER TABLE `SHKPackLevelXPDLApp` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKPackLevelXPDLApp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKPackLevelXPDLAppTAAppDetUsr`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKPackLevelXPDLAppTAAppDetUsr` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKPackLevelXPDLAppTAAppDetUsr` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKPackLevelXPDLAppTAAppDetUsr_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKPackLevelXPDLAppTAAppDetUsr_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentAppDetailUser` (`oid`),
  CONSTRAINT `SHKPackLevelXPDLAppTAAppDetUsr_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKPackLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKPackLevelXPDLAppTAAppDetUsr`
--

LOCK TABLES `SHKPackLevelXPDLAppTAAppDetUsr` WRITE;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppTAAppDetUsr` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppTAAppDetUsr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKPackLevelXPDLAppTAAppDetail`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKPackLevelXPDLAppTAAppDetail` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKPackLevelXPDLAppTAAppDetail` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKPackLevelXPDLAppTAAppDetail_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKPackLevelXPDLAppTAAppDetail_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentAppDetail` (`oid`),
  CONSTRAINT `SHKPackLevelXPDLAppTAAppDetail_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKPackLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKPackLevelXPDLAppTAAppDetail`
--

LOCK TABLES `SHKPackLevelXPDLAppTAAppDetail` WRITE;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppTAAppDetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppTAAppDetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKPackLevelXPDLAppTAAppUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKPackLevelXPDLAppTAAppUser` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKPackLevelXPDLAppTAAppUser` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKPackLevelXPDLAppTAAppUser_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKPackLevelXPDLAppTAAppUser_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentAppUser` (`oid`),
  CONSTRAINT `SHKPackLevelXPDLAppTAAppUser_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKPackLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKPackLevelXPDLAppTAAppUser`
--

LOCK TABLES `SHKPackLevelXPDLAppTAAppUser` WRITE;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppTAAppUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppTAAppUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKPackLevelXPDLAppToolAgntApp`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKPackLevelXPDLAppToolAgntApp` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKPackLevelXPDLAppToolAgntApp` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKPackLevelXPDLAppToolAgntApp_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKPackLevelXPDLAppToolAgntApp_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentApp` (`oid`),
  CONSTRAINT `SHKPackLevelXPDLAppToolAgntApp_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKPackLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKPackLevelXPDLAppToolAgntApp`
--

LOCK TABLES `SHKPackLevelXPDLAppToolAgntApp` WRITE;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppToolAgntApp` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKPackLevelXPDLAppToolAgntApp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcLevelParticipant`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcLevelParticipant` (
  `PARTICIPANT_ID` varchar(90) NOT NULL,
  `PROCESSOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcLevelParticipant` (`PARTICIPANT_ID`,`PROCESSOID`),
  KEY `SHKProcLevelParticipant_PROCESSOID` (`PROCESSOID`),
  CONSTRAINT `SHKProcLevelParticipant_PROCESSOID` FOREIGN KEY (`PROCESSOID`) REFERENCES `SHKXPDLParticipantProcess` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcLevelParticipant`
--

LOCK TABLES `SHKProcLevelParticipant` WRITE;
/*!40000 ALTER TABLE `SHKProcLevelParticipant` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcLevelParticipant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcLevelXPDLApp`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcLevelXPDLApp` (
  `APPLICATION_ID` varchar(90) NOT NULL,
  `PROCESSOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcLevelXPDLApp` (`APPLICATION_ID`,`PROCESSOID`),
  KEY `SHKProcLevelXPDLApp_PROCESSOID` (`PROCESSOID`),
  CONSTRAINT `SHKProcLevelXPDLApp_PROCESSOID` FOREIGN KEY (`PROCESSOID`) REFERENCES `SHKXPDLApplicationProcess` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcLevelXPDLApp`
--

LOCK TABLES `SHKProcLevelXPDLApp` WRITE;
/*!40000 ALTER TABLE `SHKProcLevelXPDLApp` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcLevelXPDLApp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcLevelXPDLAppTAAppDetUsr`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcLevelXPDLAppTAAppDetUsr` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcLevelXPDLAppTAAppDetUsr` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKProcLevelXPDLAppTAAppDetUsr_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKProcLevelXPDLAppTAAppDetUsr_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentAppDetailUser` (`oid`),
  CONSTRAINT `SHKProcLevelXPDLAppTAAppDetUsr_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKProcLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcLevelXPDLAppTAAppDetUsr`
--

LOCK TABLES `SHKProcLevelXPDLAppTAAppDetUsr` WRITE;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppTAAppDetUsr` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppTAAppDetUsr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcLevelXPDLAppTAAppDetail`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcLevelXPDLAppTAAppDetail` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcLevelXPDLAppTAAppDetail` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKProcLevelXPDLAppTAAppDetail_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKProcLevelXPDLAppTAAppDetail_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentAppDetail` (`oid`),
  CONSTRAINT `SHKProcLevelXPDLAppTAAppDetail_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKProcLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcLevelXPDLAppTAAppDetail`
--

LOCK TABLES `SHKProcLevelXPDLAppTAAppDetail` WRITE;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppTAAppDetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppTAAppDetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcLevelXPDLAppTAAppUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcLevelXPDLAppTAAppUser` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcLevelXPDLAppTAAppUser` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKProcLevelXPDLAppTAAppUser_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKProcLevelXPDLAppTAAppUser_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentAppUser` (`oid`),
  CONSTRAINT `SHKProcLevelXPDLAppTAAppUser_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKProcLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcLevelXPDLAppTAAppUser`
--

LOCK TABLES `SHKProcLevelXPDLAppTAAppUser` WRITE;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppTAAppUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppTAAppUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcLevelXPDLAppToolAgntApp`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcLevelXPDLAppToolAgntApp` (
  `XPDL_APPOID` decimal(19,0) NOT NULL,
  `TOOLAGENTOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcLevelXPDLAppToolAgntApp` (`XPDL_APPOID`,`TOOLAGENTOID`),
  KEY `SHKProcLevelXPDLAppToolAgntApp_TOOLAGENTOID` (`TOOLAGENTOID`),
  CONSTRAINT `SHKProcLevelXPDLAppToolAgntApp_TOOLAGENTOID` FOREIGN KEY (`TOOLAGENTOID`) REFERENCES `SHKToolAgentApp` (`oid`),
  CONSTRAINT `SHKProcLevelXPDLAppToolAgntApp_XPDL_APPOID` FOREIGN KEY (`XPDL_APPOID`) REFERENCES `SHKProcLevelXPDLApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcLevelXPDLAppToolAgntApp`
--

LOCK TABLES `SHKProcLevelXPDLAppToolAgntApp` WRITE;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppToolAgntApp` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcLevelXPDLAppToolAgntApp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessData`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcessData` (
  `Process` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` double DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessData` (`CNT`),
  UNIQUE KEY `I2_SHKProcessData` (`Process`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKProcessData_Process` FOREIGN KEY (`Process`) REFERENCES `SHKProcesses` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessData`
--

LOCK TABLES `SHKProcessData` WRITE;
/*!40000 ALTER TABLE `SHKProcessData` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcessData` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessDataBLOBs`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcessDataBLOBs` (
  `ProcessDataWOB` decimal(19,0) NOT NULL,
  `VariableValue` mediumblob DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessDataBLOBs` (`ProcessDataWOB`,`OrdNo`),
  CONSTRAINT `SHKProcessDataBLOBs_ProcessDataWOB` FOREIGN KEY (`ProcessDataWOB`) REFERENCES `SHKProcessDataWOB` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessDataBLOBs`
--

LOCK TABLES `SHKProcessDataBLOBs` WRITE;
/*!40000 ALTER TABLE `SHKProcessDataBLOBs` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcessDataBLOBs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessDataWOB`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcessDataWOB` (
  `Process` decimal(19,0) NOT NULL,
  `VariableDefinitionId` varchar(100) NOT NULL,
  `VariableType` int(11) NOT NULL,
  `VariableValueXML` text DEFAULT NULL,
  `VariableValueVCHAR` varchar(4000) DEFAULT NULL,
  `VariableValueDBL` double DEFAULT NULL,
  `VariableValueLONG` bigint(20) DEFAULT NULL,
  `VariableValueDATE` datetime DEFAULT NULL,
  `VariableValueBOOL` smallint(6) DEFAULT NULL,
  `OrdNo` int(11) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessDataWOB` (`CNT`),
  UNIQUE KEY `I2_SHKProcessDataWOB` (`Process`,`VariableDefinitionId`,`OrdNo`),
  CONSTRAINT `SHKProcessDataWOB_Process` FOREIGN KEY (`Process`) REFERENCES `SHKProcesses` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessDataWOB`
--

LOCK TABLES `SHKProcessDataWOB` WRITE;
/*!40000 ALTER TABLE `SHKProcessDataWOB` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcessDataWOB` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessDefinitions`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcessDefinitions` (
  `Name` varchar(200) NOT NULL,
  `PackageId` varchar(90) NOT NULL,
  `ProcessDefinitionId` varchar(90) NOT NULL,
  `ProcessDefinitionCreated` bigint(20) NOT NULL,
  `ProcessDefinitionVersion` varchar(20) NOT NULL,
  `State` int(11) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessDefinitions` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessDefinitions`
--

LOCK TABLES `SHKProcessDefinitions` WRITE;
/*!40000 ALTER TABLE `SHKProcessDefinitions` DISABLE KEYS */;
INSERT INTO `SHKProcessDefinitions` VALUES
('crm#1#process1','crm','process1',1713505204805,'1',0,1000204,0),
('dashboard#1#process1','dashboard','process1',1713505207565,'1',0,1000208,0),
('expenseclaim#1#process1','expenseclaim','process1',1713505210510,'1',0,1000212,0),
('isr#1#isr','isr','isr',1713505212434,'1',0,1000216,0),
('JogetDxShowcase#1#process1','JogetDxShowcase','process1',1713505217777,'1',0,1000220,0),
('JogetDxShowcase#1#populateChart2','JogetDxShowcase','populateChart2',1713505217777,'1',0,1000221,0);
/*!40000 ALTER TABLE `SHKProcessDefinitions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessRequesters`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcessRequesters` (
  `Id` varchar(100) NOT NULL,
  `ActivityRequester` decimal(19,0) DEFAULT NULL,
  `ResourceRequester` decimal(19,0) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessRequesters` (`Id`),
  KEY `I2_SHKProcessRequesters` (`ActivityRequester`),
  KEY `I3_SHKProcessRequesters` (`ResourceRequester`),
  CONSTRAINT `SHKProcessRequesters_ActivityRequester` FOREIGN KEY (`ActivityRequester`) REFERENCES `SHKActivities` (`oid`),
  CONSTRAINT `SHKProcessRequesters_ResourceRequester` FOREIGN KEY (`ResourceRequester`) REFERENCES `SHKResourcesTable` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessRequesters`
--

LOCK TABLES `SHKProcessRequesters` WRITE;
/*!40000 ALTER TABLE `SHKProcessRequesters` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcessRequesters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessStateEventAudits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcessStateEventAudits` (
  `KeyValue` varchar(30) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessStateEventAudits` (`KeyValue`),
  UNIQUE KEY `I2_SHKProcessStateEventAudits` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessStateEventAudits`
--

LOCK TABLES `SHKProcessStateEventAudits` WRITE;
/*!40000 ALTER TABLE `SHKProcessStateEventAudits` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcessStateEventAudits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcessStates`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcessStates` (
  `KeyValue` varchar(30) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcessStates` (`KeyValue`),
  UNIQUE KEY `I2_SHKProcessStates` (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcessStates`
--

LOCK TABLES `SHKProcessStates` WRITE;
/*!40000 ALTER TABLE `SHKProcessStates` DISABLE KEYS */;
INSERT INTO `SHKProcessStates` VALUES
('open.running','open.running',1000000,0),
('open.not_running.not_started','open.not_running.not_started',1000002,0),
('open.not_running.suspended','open.not_running.suspended',1000004,0),
('closed.completed','closed.completed',1000006,0),
('closed.terminated','closed.terminated',1000008,0),
('closed.aborted','closed.aborted',1000010,0);
/*!40000 ALTER TABLE `SHKProcessStates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKProcesses`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKProcesses` (
  `SyncVersion` bigint(20) NOT NULL,
  `Id` varchar(100) NOT NULL,
  `ProcessDefinition` decimal(19,0) NOT NULL,
  `PDefName` varchar(200) NOT NULL,
  `ActivityRequesterId` varchar(100) DEFAULT NULL,
  `ActivityRequesterProcessId` varchar(100) DEFAULT NULL,
  `ResourceRequesterId` varchar(100) NOT NULL,
  `ExternalRequesterClassName` varchar(254) DEFAULT NULL,
  `State` decimal(19,0) NOT NULL,
  `Priority` int(11) DEFAULT NULL,
  `Name` varchar(254) DEFAULT NULL,
  `Created` bigint(20) NOT NULL,
  `CreatedTZO` bigint(20) NOT NULL,
  `Started` bigint(20) DEFAULT NULL,
  `StartedTZO` bigint(20) DEFAULT NULL,
  `LastStateTime` bigint(20) NOT NULL,
  `LastStateTimeTZO` bigint(20) NOT NULL,
  `LimitTime` bigint(20) NOT NULL,
  `LimitTimeTZO` bigint(20) NOT NULL,
  `Description` varchar(254) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKProcesses` (`Id`),
  KEY `I2_SHKProcesses` (`ProcessDefinition`),
  KEY `I3_SHKProcesses` (`State`),
  KEY `I4_SHKProcesses` (`ActivityRequesterId`),
  KEY `I5_SHKProcesses` (`ResourceRequesterId`),
  CONSTRAINT `SHKProcesses_ProcessDefinition` FOREIGN KEY (`ProcessDefinition`) REFERENCES `SHKProcessDefinitions` (`oid`),
  CONSTRAINT `SHKProcesses_State` FOREIGN KEY (`State`) REFERENCES `SHKProcessStates` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKProcesses`
--

LOCK TABLES `SHKProcesses` WRITE;
/*!40000 ALTER TABLE `SHKProcesses` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKProcesses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKResourcesTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKResourcesTable` (
  `Username` varchar(100) NOT NULL,
  `Name` varchar(100) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKResourcesTable` (`Username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKResourcesTable`
--

LOCK TABLES `SHKResourcesTable` WRITE;
/*!40000 ALTER TABLE `SHKResourcesTable` DISABLE KEYS */;
INSERT INTO `SHKResourcesTable` VALUES
('roleSystem',NULL,1000200,0);
/*!40000 ALTER TABLE `SHKResourcesTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKStateEventAudits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKStateEventAudits` (
  `RecordedTime` bigint(20) NOT NULL,
  `RecordedTimeTZO` bigint(20) NOT NULL,
  `TheUsername` varchar(100) NOT NULL,
  `TheType` decimal(19,0) NOT NULL,
  `ActivityId` varchar(100) DEFAULT NULL,
  `ActivityName` varchar(254) DEFAULT NULL,
  `ProcessId` varchar(100) NOT NULL,
  `ProcessName` varchar(254) DEFAULT NULL,
  `ProcessFactoryName` varchar(200) NOT NULL,
  `ProcessFactoryVersion` varchar(20) NOT NULL,
  `ActivityDefinitionId` varchar(90) DEFAULT NULL,
  `ActivityDefinitionName` varchar(90) DEFAULT NULL,
  `ActivityDefinitionType` int(11) DEFAULT NULL,
  `ProcessDefinitionId` varchar(90) NOT NULL,
  `ProcessDefinitionName` varchar(90) DEFAULT NULL,
  `PackageId` varchar(90) NOT NULL,
  `OldProcessState` decimal(19,0) DEFAULT NULL,
  `NewProcessState` decimal(19,0) DEFAULT NULL,
  `OldActivityState` decimal(19,0) DEFAULT NULL,
  `NewActivityState` decimal(19,0) DEFAULT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKStateEventAudits` (`CNT`),
  KEY `SHKStateEventAudits_TheType` (`TheType`),
  KEY `SHKStateEventAudits_OldProcessState` (`OldProcessState`),
  KEY `SHKStateEventAudits_NewProcessState` (`NewProcessState`),
  KEY `SHKStateEventAudits_OldActivityState` (`OldActivityState`),
  KEY `SHKStateEventAudits_NewActivityState` (`NewActivityState`),
  CONSTRAINT `SHKStateEventAudits_NewActivityState` FOREIGN KEY (`NewActivityState`) REFERENCES `SHKActivityStateEventAudits` (`oid`),
  CONSTRAINT `SHKStateEventAudits_NewProcessState` FOREIGN KEY (`NewProcessState`) REFERENCES `SHKProcessStateEventAudits` (`oid`),
  CONSTRAINT `SHKStateEventAudits_OldActivityState` FOREIGN KEY (`OldActivityState`) REFERENCES `SHKActivityStateEventAudits` (`oid`),
  CONSTRAINT `SHKStateEventAudits_OldProcessState` FOREIGN KEY (`OldProcessState`) REFERENCES `SHKProcessStateEventAudits` (`oid`),
  CONSTRAINT `SHKStateEventAudits_TheType` FOREIGN KEY (`TheType`) REFERENCES `SHKEventTypes` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKStateEventAudits`
--

LOCK TABLES `SHKStateEventAudits` WRITE;
/*!40000 ALTER TABLE `SHKStateEventAudits` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKStateEventAudits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKToolAgentApp`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKToolAgentApp` (
  `TOOL_AGENT_NAME` varchar(250) NOT NULL,
  `APP_NAME` varchar(90) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKToolAgentApp` (`TOOL_AGENT_NAME`,`APP_NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKToolAgentApp`
--

LOCK TABLES `SHKToolAgentApp` WRITE;
/*!40000 ALTER TABLE `SHKToolAgentApp` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKToolAgentApp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKToolAgentAppDetail`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKToolAgentAppDetail` (
  `APP_MODE` decimal(10,0) NOT NULL,
  `TOOLAGENT_APPOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKToolAgentAppDetail` (`APP_MODE`,`TOOLAGENT_APPOID`),
  KEY `SHKToolAgentAppDetail_TOOLAGENT_APPOID` (`TOOLAGENT_APPOID`),
  CONSTRAINT `SHKToolAgentAppDetail_TOOLAGENT_APPOID` FOREIGN KEY (`TOOLAGENT_APPOID`) REFERENCES `SHKToolAgentApp` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKToolAgentAppDetail`
--

LOCK TABLES `SHKToolAgentAppDetail` WRITE;
/*!40000 ALTER TABLE `SHKToolAgentAppDetail` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKToolAgentAppDetail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKToolAgentAppDetailUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKToolAgentAppDetailUser` (
  `TOOLAGENT_APPOID` decimal(19,0) NOT NULL,
  `USEROID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKToolAgentAppDetailUser` (`TOOLAGENT_APPOID`,`USEROID`),
  KEY `SHKToolAgentAppDetailUser_USEROID` (`USEROID`),
  CONSTRAINT `SHKToolAgentAppDetailUser_TOOLAGENT_APPOID` FOREIGN KEY (`TOOLAGENT_APPOID`) REFERENCES `SHKToolAgentAppDetail` (`oid`),
  CONSTRAINT `SHKToolAgentAppDetailUser_USEROID` FOREIGN KEY (`USEROID`) REFERENCES `SHKToolAgentUser` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKToolAgentAppDetailUser`
--

LOCK TABLES `SHKToolAgentAppDetailUser` WRITE;
/*!40000 ALTER TABLE `SHKToolAgentAppDetailUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKToolAgentAppDetailUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKToolAgentAppUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKToolAgentAppUser` (
  `TOOLAGENT_APPOID` decimal(19,0) NOT NULL,
  `USEROID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKToolAgentAppUser` (`TOOLAGENT_APPOID`,`USEROID`),
  KEY `SHKToolAgentAppUser_USEROID` (`USEROID`),
  CONSTRAINT `SHKToolAgentAppUser_TOOLAGENT_APPOID` FOREIGN KEY (`TOOLAGENT_APPOID`) REFERENCES `SHKToolAgentApp` (`oid`),
  CONSTRAINT `SHKToolAgentAppUser_USEROID` FOREIGN KEY (`USEROID`) REFERENCES `SHKToolAgentUser` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKToolAgentAppUser`
--

LOCK TABLES `SHKToolAgentAppUser` WRITE;
/*!40000 ALTER TABLE `SHKToolAgentAppUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKToolAgentAppUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKToolAgentUser`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKToolAgentUser` (
  `USERNAME` varchar(100) NOT NULL,
  `PWD` varchar(100) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKToolAgentUser` (`USERNAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKToolAgentUser`
--

LOCK TABLES `SHKToolAgentUser` WRITE;
/*!40000 ALTER TABLE `SHKToolAgentUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKToolAgentUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKUserGroupTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKUserGroupTable` (
  `userid` decimal(19,0) NOT NULL,
  `groupid` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKUserGroupTable` (`userid`,`groupid`),
  KEY `SHKUserGroupTable_groupid` (`groupid`),
  CONSTRAINT `SHKUserGroupTable_groupid` FOREIGN KEY (`groupid`) REFERENCES `SHKGroupTable` (`oid`),
  CONSTRAINT `SHKUserGroupTable_userid` FOREIGN KEY (`userid`) REFERENCES `SHKUserTable` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKUserGroupTable`
--

LOCK TABLES `SHKUserGroupTable` WRITE;
/*!40000 ALTER TABLE `SHKUserGroupTable` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKUserGroupTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKUserPackLevelPart`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKUserPackLevelPart` (
  `PARTICIPANTOID` decimal(19,0) NOT NULL,
  `USEROID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKUserPackLevelPart` (`PARTICIPANTOID`,`USEROID`),
  KEY `SHKUserPackLevelPart_USEROID` (`USEROID`),
  CONSTRAINT `SHKUserPackLevelPart_PARTICIPANTOID` FOREIGN KEY (`PARTICIPANTOID`) REFERENCES `SHKPackLevelParticipant` (`oid`),
  CONSTRAINT `SHKUserPackLevelPart_USEROID` FOREIGN KEY (`USEROID`) REFERENCES `SHKNormalUser` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKUserPackLevelPart`
--

LOCK TABLES `SHKUserPackLevelPart` WRITE;
/*!40000 ALTER TABLE `SHKUserPackLevelPart` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKUserPackLevelPart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKUserProcLevelParticipant`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKUserProcLevelParticipant` (
  `PARTICIPANTOID` decimal(19,0) NOT NULL,
  `USEROID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKUserProcLevelParticipant` (`PARTICIPANTOID`,`USEROID`),
  KEY `SHKUserProcLevelParticipant_USEROID` (`USEROID`),
  CONSTRAINT `SHKUserProcLevelParticipant_PARTICIPANTOID` FOREIGN KEY (`PARTICIPANTOID`) REFERENCES `SHKProcLevelParticipant` (`oid`),
  CONSTRAINT `SHKUserProcLevelParticipant_USEROID` FOREIGN KEY (`USEROID`) REFERENCES `SHKNormalUser` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKUserProcLevelParticipant`
--

LOCK TABLES `SHKUserProcLevelParticipant` WRITE;
/*!40000 ALTER TABLE `SHKUserProcLevelParticipant` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKUserProcLevelParticipant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKUserTable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKUserTable` (
  `userid` varchar(100) NOT NULL,
  `firstname` varchar(50) DEFAULT NULL,
  `lastname` varchar(50) DEFAULT NULL,
  `passwd` varchar(50) NOT NULL,
  `email` varchar(254) DEFAULT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKUserTable` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKUserTable`
--

LOCK TABLES `SHKUserTable` WRITE;
/*!40000 ALTER TABLE `SHKUserTable` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKUserTable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLApplicationPackage`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKXPDLApplicationPackage` (
  `PACKAGE_ID` varchar(90) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLApplicationPackage` (`PACKAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLApplicationPackage`
--

LOCK TABLES `SHKXPDLApplicationPackage` WRITE;
/*!40000 ALTER TABLE `SHKXPDLApplicationPackage` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLApplicationPackage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLApplicationProcess`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKXPDLApplicationProcess` (
  `PROCESS_ID` varchar(90) NOT NULL,
  `PACKAGEOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLApplicationProcess` (`PROCESS_ID`,`PACKAGEOID`),
  KEY `SHKXPDLApplicationProcess_PACKAGEOID` (`PACKAGEOID`),
  CONSTRAINT `SHKXPDLApplicationProcess_PACKAGEOID` FOREIGN KEY (`PACKAGEOID`) REFERENCES `SHKXPDLApplicationPackage` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLApplicationProcess`
--

LOCK TABLES `SHKXPDLApplicationProcess` WRITE;
/*!40000 ALTER TABLE `SHKXPDLApplicationProcess` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLApplicationProcess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLData`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKXPDLData` (
  `XPDLContent` longblob DEFAULT NULL,
  `XPDLClassContent` longblob DEFAULT NULL,
  `XPDL` decimal(19,0) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLData` (`CNT`),
  UNIQUE KEY `I2_SHKXPDLData` (`XPDL`),
  CONSTRAINT `SHKXPDLData_XPDL` FOREIGN KEY (`XPDL`) REFERENCES `SHKXPDLS` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLData`
--

LOCK TABLES `SHKXPDLData` WRITE;
/*!40000 ALTER TABLE `SHKXPDLData` DISABLE KEYS */;
INSERT INTO `SHKXPDLData` VALUES
('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Package xmlns=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" Id=\"crm\" Name=\"Customer Relationship Management\" xsi:schemaLocation=\"http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">\n    <PackageHeader>\n        <XPDLVersion>1.0</XPDLVersion>\n        <Vendor/>\n        <Created/>\n    </PackageHeader>\n    <Script Type=\"text/javascript\"/>\n    <Participants>\n        <Participant Id=\"requester\" Name=\"Requester\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"approver\" Name=\"Approver\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n    </Participants>\n    <Applications>\n        <Application Id=\"default_application\"/>\n    </Applications>\n    <WorkflowProcesses>\n        <WorkflowProcess Id=\"process1\" Name=\"Proposal Approval Process\">\n            <ProcessHeader DurationUnit=\"h\"/>\n            <DataFields>\n                <DataField Id=\"status\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"selectApprover\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n            </DataFields>\n            <Activities>\n                <Activity Id=\"approve_proposal\" Name=\"Approve Proposal\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"325,58.784088134765625\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"activity1\" Name=\"Resubmit Proposal\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"293,17.784095764160156\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"send_proposal\" Name=\"Finalize Proposal\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"788,24.170455932617188\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool1\" Name=\"Email Approved Notification\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"623,25.170455932617188\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool2\" Name=\"Email Reject Notification\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"692,59.1136474609375\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool3\" Name=\"Email Request For Approval\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Join Type=\"XOR\"/>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"145,61\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool4\" Name=\"Email Resubmit Notification\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"442,16\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route2\">\n                    <Route/>\n                    <Performer>approver</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition5\"/>\n                                    <TransitionRef Id=\"transition8\"/>\n                                    <TransitionRef Id=\"transition10\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"486,63.784088134765625\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route1\">\n                    <Route/>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"161,54.9886474609375\"/>\n                    </ExtendedAttributes>\n                </Activity>\n            </Activities>\n            <Transitions>\n                <Transition From=\"approve_proposal\" Id=\"transition2\" To=\"route2\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition5\" To=\"tool2\">\n                    <Condition Type=\"CONDITION\">status === \'Rejected\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"PBUILDER_TRANSITION_CONDITIONS\" Value=\"[{&quot;join&quot;:&quot;&amp;&amp;&quot;,&quot;variable&quot;:&quot;status&quot;,&quot;operator&quot;:&quot;===&quot;,&quot;value&quot;:&quot;Rejected&quot;}]\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool1\" Id=\"transition7\" To=\"send_proposal\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition8\" Name=\"Approved\" To=\"tool1\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition11\" To=\"tool3\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool3\" Id=\"transition9\" To=\"approve_proposal\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"activity1\" Id=\"transition12\" To=\"tool3\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition10\" To=\"tool4\">\n                    <Condition Type=\"CONDITION\">status === \'Resubmit\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"PBUILDER_TRANSITION_CONDITIONS\" Value=\"[{&quot;join&quot;:&quot;&amp;&amp;&quot;,&quot;variable&quot;:&quot;status&quot;,&quot;operator&quot;:&quot;===&quot;,&quot;value&quot;:&quot;Resubmit&quot;}]\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool4\" Id=\"transition13\" To=\"activity1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n            </Transitions>\n            <ExtendedAttributes>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER\" Value=\"requester;approver\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=send_proposal,X_OFFSET=912,Y_OFFSET=35,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=approver,CONNECTING_ACTIVITY_ID=tool2,X_OFFSET=850,Y_OFFSET=73,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_START_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=route1,X_OFFSET=101,Y_OFFSET=66,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULT\"/>\n            </ExtendedAttributes>\n        </WorkflowProcess>\n    </WorkflowProcesses>\n    <ExtendedAttributes>\n        <ExtendedAttribute Name=\"EDITING_TOOL\" Value=\"Web Workflow Designer\"/>\n        <ExtendedAttribute Name=\"EDITING_TOOL_VERSION\" Value=\"5.0-pre-alpha\"/>\n    </ExtendedAttributes>\n</Package>\n','\0sr\0\'org.enhydra.shark.xpdl.elements.Package~+Vmŀ~\0Z\0isTransientL\0extPkgRefsToIdst\0.Lorg/enhydra/shark/utilities/SequencedHashMap;L\0internalVersiont\0Ljava/lang/String;L\0\nnamespacest\0,Lorg/enhydra/shark/xpdl/elements/Namespaces;xr\0(org.enhydra.shark.xpdl.XMLComplexElement>(\0\0xr\05org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex2\0L\0\nelementMapq\0~\0L\0elementst\0Ljava/util/ArrayList;xr\0!org.enhydra.shark.xpdl.XMLElement#+B#\0Z\0\nisReadOnlyZ\0\nisRequiredL\0nameq\0~\0L\0originalElementHashCodet\0Ljava/lang/Integer;L\0parentt\0#Lorg/enhydra/shark/xpdl/XMLElement;L\0valueq\0~\0xpt\0Packagesr\0java.lang.Integer⠤8\0I\0valuexr\0java.lang.Number\0\0xp-pt\0\0sr\0,org.enhydra.shark.utilities.SequencedHashMap.\"\"&\0\0xpw\0\0\0\rt\0Idsr\0#org.enhydra.shark.xpdl.XMLAttribute#c݀M;\0L\0choicesq\0~\0xq\0~\0q\0~\0sq\0~\0q\Zq\0~\0\nt\0crmpt\0Namesq\0~\0\0q\0~\0sq\0~\0$cq\0~\0\nt\0 Customer Relationship Managementpt\0\rPackageHeadersr\0-org.enhydra.shark.xpdl.elements.PackageHeaderv,\0\0xq\0~\0\0q\0~\0sq\0~\0\'q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0XPDLVersionsr\0+org.enhydra.shark.xpdl.elements.XPDLVersion\"}Y.w\0\0xr\0\'org.enhydra.shark.xpdl.XMLSimpleElementm\0\0xq\0~\0q\0~\0!sq\0~\09Eq\0~\0t\01.0t\0Vendorsr\0&org.enhydra.shark.xpdl.elements.Vendor tE:\0\0xq\0~\0#q\0~\0\'sq\0~\0q\0~\0t\0\0t\0Createdsr\0\'org.enhydra.shark.xpdl.elements.CreatedzdK|[\0\0xq\0~\0#q\0~\0,sq\0~\0/3\Zq\0~\0t\0\0t\0Descriptionsr\0+org.enhydra.shark.xpdl.elements.Description۰738\0\0xq\0~\0#\0q\0~\01sq\0~\0[+Uq\0~\0t\0\0t\0\rDocumentationsr\0-org.enhydra.shark.xpdl.elements.Documentation`9y\0\0xq\0~\0#\0q\0~\06sq\0~\0\nq\0~\0t\0\0t\0PriorityUnitsr\0,org.enhydra.shark.xpdl.elements.PriorityUnit\0\0xq\0~\0#\0q\0~\0;sq\0~\0KFżq\0~\0t\0\0t\0CostUnitsr\0(org.enhydra.shark.xpdl.elements.CostUnit܎=H\0\0xq\0~\0#\0q\0~\0@sq\0~\0s$q\0~\0t\0\0xsr\0java.util.ArrayListxa\0I\0sizexp\0\0\0w\0\0\0q\0~\0$q\0~\0)q\0~\0.q\0~\03q\0~\08q\0~\0=q\0~\0Bxt\0RedefinableHeadersr\01org.enhydra.shark.xpdl.elements.RedefinableHeaderMϪ\'H\0\0xq\0~\0\0q\0~\0Gsq\0~\0G\Zq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0PublicationStatussq\0~\0\0q\0~\0Msq\0~\0L~q\0~\0It\0\0sq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0UNDER_REVISIONt\0RELEASEDt\0\nUNDER_TESTxt\0Authorsr\0&org.enhydra.shark.xpdl.elements.Author5fᧆ\0\0xq\0~\0#\0q\0~\0Usq\0~\0f%2^q\0~\0It\0\0t\0Versionsr\0\'org.enhydra.shark.xpdl.elements.Version9=3~JQ\0\0xq\0~\0#\0q\0~\0Zsq\0~\0)yq\0~\0It\0\0t\0Codepagesr\0(org.enhydra.shark.xpdl.elements.Codepage9$me\rG\0\0xq\0~\0#\0q\0~\0_sq\0~\0q\0~\0It\0\0t\0\nCountrykeysr\0*org.enhydra.shark.xpdl.elements.Countrykey.\0\0xq\0~\0#\0q\0~\0dsq\0~\0*R5q\0~\0It\0\0t\0Responsiblessr\0,org.enhydra.shark.xpdl.elements.Responsibles${S\0\0xr\0$org.enhydra.shark.xpdl.XMLCollectionjċm\0\0xq\0~\0\0q\0~\0isq\0~\0\\q\0~\0It\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0Nq\0~\0Wq\0~\0\\q\0~\0aq\0~\0fq\0~\0lxt\0ConformanceClasssr\00org.enhydra.shark.xpdl.elements.ConformanceClassy0|k\0\0xq\0~\0\0q\0~\0rsq\0~\0Rq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0GraphConformancesq\0~\0\0q\0~\0xsq\0~\0_]#q\0~\0tq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0FULL_BLOCKEDt\0LOOP_BLOCKEDt\0NON_BLOCKEDxxsq\0~\0E\0\0\0w\0\0\0q\0~\0yxt\0Scriptsr\0&org.enhydra.shark.xpdl.elements.ScriptQjS8\0\0xq\0~\0\0q\0~\0sq\0~\0czq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0Typesq\0~\0q\0~\0sq\0~\0Q7q\0~\0t\0text/javascriptpt\0Versionsq\0~\0\0q\0~\0sq\0~\0aohq\0~\0t\0\0pt\0Grammarsq\0~\0\0q\0~\0sq\0~\0#Oq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExternalPackagessr\00org.enhydra.shark.xpdl.elements.ExternalPackagesw\"+Ũ\0\0xq\0~\0k\0q\0~\0sq\0~\0qӳq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0TypeDeclarationssr\00org.enhydra.shark.xpdl.elements.TypeDeclarations\rOx5\0\0xq\0~\0k\0q\0~\0sq\0~\0+p\nq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Participantssr\0,org.enhydra.shark.xpdl.elements.Participantsh`g8J\0\0xq\0~\0k\0q\0~\0sq\0~\0U;q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Participanto$rc\0\0xr\0+org.enhydra.shark.xpdl.XMLCollectionElementCxvr\0\0xq\0~\0t\0Participantsq\0~\0 {q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Jwq\0~\0t\0	requesterpq\0~\0sq\0~\0\0q\0~\0sq\0~\0G\\q\0~\0t\0	Requesterpt\0ParticipantTypesr\0/org.enhydra.shark.xpdl.elements.ParticipantType>n݅\0\0xq\0~\0q\0~\0sq\0~\0(q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0gTq\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0t\0RESOURCE_SETt\0RESOURCEt\0ROLEt\0ORGANIZATIONAL_UNITt\0HUMANt\0SYSTEMxxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0	!\\q\0~\0t\0\0t\0ExternalReferencesr\01org.enhydra.shark.xpdl.elements.ExternalReferencebQ\0\0xq\0~\0\0q\0~\0sq\0~\0R\0q\0~\0t\0\0sq\0~\0w\0\0\0t\0xrefsq\0~\0\0q\0~\0sq\0~\05a#q\0~\0t\0\0pt\0locationsq\0~\0q\0~\0sq\0~\0w-q\0~\0t\0\0pt\0	namespacesq\0~\0\0q\0~\0sq\0~\0!\ZOq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExtendedAttributessr\02org.enhydra.shark.xpdl.elements.ExtendedAttributesOUF\0L\0extAttribsStringq\0~\0xq\0~\0k\0q\0~\0sq\0~\0t\nq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xsq\0~\0t\0Participantsq\0~\0sZq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\09q\0~\0t\0approverpq\0~\0sq\0~\0\0q\0~\0sq\0~\02\n]q\0~\0t\0Approverpt\0ParticipantTypesq\0~\0q\0~\0sq\0~\0)	q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\08[q\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0[q\0~\0t\0\0t\0ExternalReferencesq\0~\0\0q\0~\0sq\0~\0Xq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\00Bq\0~\0t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\00?q\0~\0t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0YRq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~	xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0@bouq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~xxt\0Applicationssr\0,org.enhydra.shark.xpdl.elements.Applications\0\0xq\0~\0k\0q\0~sq\0~\0z{q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Applicationv	RS\0\0xq\0~\0t\0Applicationsq\0~\0/tCq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0]>q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0\"|q\0~t\0\0pt\0Descriptionsq\0~\02\0q\0~\'sq\0~\0 eq\0~t\0\0t\0Choicesr\00org.enhydra.shark.xpdl.elements.ApplicationTypes?!\0\0xr\0\'org.enhydra.shark.xpdl.XMLComplexChoice|\"\0L\0choicesq\0~\0L\0choosenq\0~\0	xq\0~\0q\0~+sq\0~\0M	q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\00org.enhydra.shark.xpdl.elements.FormalParameterspBÁZ\0\0xq\0~\0k\0t\0FormalParameterssq\0~\04q\0~.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0\0t\0ExternalReferencesq\0~\0\0@Iq\0~.t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0CV<q\0~9t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0J\rq\0~9t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0ryq\0~9t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~>q\0~Aq\0~Dxxq\0~3t\0ExtendedAttributessq\0~\0\0q\0~Hsq\0~\0PAq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~!q\0~$q\0~(q\0~.q\0~Ixxt\0\nDataFieldssr\0*org.enhydra.shark.xpdl.elements.DataFieldsʦU\0\0xq\0~\0k\0q\0~Osq\0~\02Ycq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0WorkflowProcessessr\01org.enhydra.shark.xpdl.elements.WorkflowProcessesp_0,\0\0xq\0~\0k\0q\0~Vsq\0~\0Yq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0/org.enhydra.shark.xpdl.elements.WorkflowProcess%v0L\0\0xq\0~\0t\0WorkflowProcesssq\0~\0eWnq\0~Xt\0\0sq\0~\0w\0\0\0\rq\0~\0sq\0~\0q\0~\0sq\0~\0h$Щq\0~^t\0process1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0W}q\0~^t\0Proposal Approval Processpt\0AccessLevelsq\0~\0\0q\0~isq\0~\0x4/q\0~^q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0PUBLICt\0PRIVATExt\0\rProcessHeadersr\0-org.enhydra.shark.xpdl.elements.ProcessHeaderLC-)\0\0xq\0~\0q\0~osq\0~\0Yrxq\0~^t\0\0sq\0~\0w\0\0\0t\0DurationUnitsq\0~\0\0q\0~usq\0~\0q\0~qt\0hsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0Yt\0Mt\0Dt\0ht\0mt\0sxt\0Createdsq\0~\0-\0q\0~sq\0~\03[̙q\0~qt\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0mxbq\0~qt\0\0t\0Prioritysr\0(org.enhydra.shark.xpdl.elements.Priority`Nn>b\0\0xq\0~\0#\0q\0~sq\0~\0!q\0~qt\0\0t\0Limitsr\0%org.enhydra.shark.xpdl.elements.Limit1ӗ\0\0xq\0~\0#\0q\0~sq\0~\0N7q\0~qt\0\0t\0	ValidFromsr\0)org.enhydra.shark.xpdl.elements.ValidFromcŅ|L<\0\0xq\0~\0#\0q\0~sq\0~\0#Bq\0~qt\0\0t\0ValidTosr\0\'org.enhydra.shark.xpdl.elements.ValidToM\0\0xq\0~\0#\0q\0~sq\0~\0\r\0|4q\0~qt\0\0t\0TimeEstimationsr\0.org.enhydra.shark.xpdl.elements.TimeEstimationŀ\'3\0\0xq\0~\0\0q\0~sq\0~\0Dq\0~qt\0\0sq\0~\0w\0\0\0t\0WaitingTimesr\0+org.enhydra.shark.xpdl.elements.WaitingTimeN/\0\0xq\0~\0#\0q\0~sq\0~\05KHq\0~t\0\0t\0WorkingTimesr\0+org.enhydra.shark.xpdl.elements.WorkingTime~\0\0xq\0~\0#\0q\0~sq\0~\089cq\0~t\0\0t\0Durationsr\0(org.enhydra.shark.xpdl.elements.Duration C\0\0xq\0~\0#\0q\0~sq\0~\06q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~vq\0~q\0~q\0~q\0~q\0~q\0~q\0~xt\0RedefinableHeadersq\0~\0H\0q\0~sq\0~\0&q\0~^t\0\0sq\0~\0w\0\0\0q\0~\0Msq\0~\0\0q\0~\0Msq\0~\01u46q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~\0Rq\0~\0Sq\0~\0Txt\0Authorsq\0~\0V\0q\0~sq\0~\08~Zq\0~t\0\0t\0Versionsq\0~\0[\0q\0~sq\0~\0F:W<q\0~t\0\0t\0Codepagesq\0~\0`\0q\0~sq\0~\0zq\0~t\0\0t\0\nCountrykeysq\0~\0e\0q\0~sq\0~\06q\0~t\0\0t\0Responsiblessq\0~\0j\0q\0~sq\0~\0,fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~xt\0FormalParameterssq\0~2\0q\0~sq\0~\08q\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nDataFieldssq\0~P\0q\0~sq\0~\0jq\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.DataFieldI3.~\0\0xq\0~\0t\0	DataFieldsq\0~\0+	q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0^7q\0~t\0statuspq\0~\0sq\0~\0\0q\0~\0sq\0~\0keq\0~t\0\0pt\0IsArraysq\0~\0\0q\0~sq\0~\0@Quq\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0t\0TRUEt\0FALSExt\0DataTypesr\0(org.enhydra.shark.xpdl.elements.DataType\'4sM\0\0xq\0~\0q\0~sq\0~\0P@q\0~t\0\0sq\0~\0w\0\0\0t\0	DataTypessr\0)org.enhydra.shark.xpdl.elements.DataTypespcH,!\0Z\0\risInitializedxq\0~-q\0~sq\0~\0q\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sr\0)org.enhydra.shark.xpdl.elements.BasicType)w1\0\0xq\0~\0t\0	BasicTypesq\0~\0qq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0t\0STRINGt\0FLOATt\0INTEGERt\0	REFERENCEt\0DATETIMEt\0BOOLEANt\0	PERFORMERxxsq\0~\0E\0\0\0w\0\0\0q\0~xsr\0,org.enhydra.shark.xpdl.elements.DeclaredTypedR.\\^9\0\0xq\0~\0t\0DeclaredTypesq\0~\0-lMq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0u8q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsr\0*org.enhydra.shark.xpdl.elements.SchemaType&1oSH\0\0xq\0~\0t\0\nSchemaTypesq\0~\0Sq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0tkq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\09|Jq\0~ t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0d/q\0~ t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\ZE.q\0~ t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~%q\0~(q\0~+xsr\0*org.enhydra.shark.xpdl.elements.RecordType%K\0\0\0xq\0~\0kt\0\nRecordTypesq\0~\0E$q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.UnionType5PG\0\0xq\0~\0kt\0	UnionTypesq\0~\0J4~$q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0/org.enhydra.shark.xpdl.elements.EnumerationTypef3b\0\0xq\0~\0kt\0EnumerationTypesq\0~\0x0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.ArrayTypeg$\0N@\0\0xq\0~\0t\0	ArrayTypesq\0~\0p?{(q\0~t\0\0sq\0~\0w\0\0\0t\0\nLowerIndexsq\0~\0q\0~Jsq\0~\0Hiq\0~Et\0\0pt\0\nUpperIndexsq\0~\0q\0~Nsq\0~\0!Kq\0~Et\0\0pq\0~sq\0~q\0~sq\0~\0>Hq\0~Et\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~Kq\0~Oq\0~Rxsr\0(org.enhydra.shark.xpdl.elements.ListType\"ӟ\n\0\0xq\0~\0t\0ListTypesq\0~\05=q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~q\0~sq\0~\0Fq\0~Wt\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~\\xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesr\0,org.enhydra.shark.xpdl.elements.InitialValuej,zR\0\0xq\0~\0#\0q\0~asq\0~\08Fq\0~t\0\0t\0Lengthsr\0&org.enhydra.shark.xpdl.elements.LengthMW+-̩W\0\0xq\0~\0#\0q\0~fsq\0~\0Lq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~ksq\0~\0]nq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~osq\0~\0giq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~cq\0~hq\0~lq\0~pxsq\0~t\0	DataFieldsq\0~\0&=q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0?2	q\0~vt\0selectApproverpq\0~\0sq\0~\0\0q\0~\0sq\0~\0\Z_q\0~vt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0j\rq\0~vt\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xt\0DataTypesq\0~q\0~sq\0~\0`>q\0~vt\0\0sq\0~\0w\0\0\0q\0~sq\0~q\0~sq\0~\0ؤvq\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~t\0	BasicTypesq\0~\0Mxq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0z\'q\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~	q\0~\nq\0~q\0~q\0~\rxxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0DeclaredTypesq\0~\03K$q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0twq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\nSchemaTypesq\0~\0ltq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0ºq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0}.q\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\07\n@q\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0hHq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~/t\0\nRecordTypesq\0~\0qy$q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0	UnionTypesq\0~\0\nGaq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~=t\0EnumerationTypesq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Dt\0	ArrayTypesq\0~\08i+q\0~t\0\0sq\0~\0w\0\0\0q\0~Jsq\0~\0q\0~Jsq\0~\0bxkKq\0~t\0\0pq\0~Nsq\0~\0q\0~Nsq\0~\0Seq\0~t\0\0pq\0~sq\0~q\0~sq\0~\0;	q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~Vt\0ListTypesq\0~\0pq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~q\0~sq\0~\0Qvq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesq\0~b\0q\0~sq\0~\0\Zvq\0~vt\0\0t\0Lengthsq\0~g\0q\0~sq\0~\0b=6q\0~vt\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0>R4q\0~vt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0[|q\0~vt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~{q\0~~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0Participantssq\0~\0\0q\0~sq\0~\0BExMq\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Applicationssq\0~\0q\0~sq\0~\0[Yq\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ActivitySetssr\0,org.enhydra.shark.xpdl.elements.ActivitySetsqV[4\0\0xq\0~\0k\0q\0~\0sq\0~\0owyq\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nActivitiessr\0*org.enhydra.shark.xpdl.elements.Activities&G^lP\0\0xq\0~\0k\0q\0~sq\0~\0\"\rq\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0	w\0\0\0	sr\0(org.enhydra.shark.xpdl.elements.Activityt45\Z9\0\0xq\0~\0t\0Activitysq\0~\0\n6<q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0qq\0~t\0approve_proposalpq\0~\0sq\0~\0\0q\0~\0sq\0~\03*q\0~t\0Approve Proposalpt\0Descriptionsq\0~\02\0q\0~\Zsq\0~\0kq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0=;Cq\0~t\0\0q\0~\0sr\0-org.enhydra.shark.xpdl.elements.ActivityTypeseŽ{\0\0xq\0~-q\0~\0sq\0~\0&q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0%org.enhydra.shark.xpdl.elements.Route0e\rG\0\0xq\0~\0t\0Routesq\0~\0=1q\0~#t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0.org.enhydra.shark.xpdl.elements.Implementationr^%\0\0xq\0~\0t\0Implementationsq\0~\0J^\"q\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sr\03org.enhydra.shark.xpdl.elements.ImplementationTypes\rT١9\0\0xq\0~-q\0~\0sq\0~\0-.!q\0~/t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0\"org.enhydra.shark.xpdl.elements.No{.\0\0xq\0~\0t\0Nosq\0~\0nq\0~5t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0%org.enhydra.shark.xpdl.elements.ToolsCg\0\0xq\0~\0k\0t\0Toolssq\0~\0wn/q\0~5t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0\'org.enhydra.shark.xpdl.elements.SubFlow;Os7:$\0\0xq\0~\0t\0SubFlowsq\0~\0Lbq\0~5t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0&3q\0~Ht\0\0pt\0	Executionsq\0~\0\0q\0~Psq\0~\0#J-q\0~Hq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ASYNCHRt\0SYNCHRxt\0ActualParameterssr\00org.enhydra.shark.xpdl.elements.ActualParameters_K\0\0xq\0~\0k\0q\0~Vsq\0~\0%^Ԡq\0~Ht\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Qq\0~Xxxq\0~:xsq\0~\0E\0\0\0w\0\0\0q\0~5xsr\0-org.enhydra.shark.xpdl.elements.BlockActivityqcF\0\0xq\0~\0t\0\rBlockActivitysq\0~\0\n1q\0~#t\0\0sq\0~\0w\0\0\0t\0BlockIdsq\0~\0q\0~esq\0~\0#n1q\0~`t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~fxxq\0~/t\0	Performersr\0)org.enhydra.shark.xpdl.elements.Performer\"1%\0\0xq\0~\0#\0q\0~jsq\0~\0Qhq\0~t\0approvert\0	StartModesr\0)org.enhydra.shark.xpdl.elements.StartModenhS\0\0xq\0~\0\0q\0~osq\0~\0Mq\0~t\0\0sq\0~\0w\0\0\0t\0Modesr\00org.enhydra.shark.xpdl.elements.StartFinishModes~6zX\'\0\0xq\0~-\0q\0~usq\0~\0Gq\0~qt\0\0sq\0~\0E\0\0\0w\0\0\0sr\0,org.enhydra.shark.xpdl.XMLEmptyChoiceElement2;3_\0\0xq\0~\0\0t\0XMLEmptyChoiceElementsq\0~\05NSq\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.Automatict?_\0\0xq\0~\0t\0	Automaticsq\0~\07xq\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0&org.enhydra.shark.xpdl.elements.Manualv[ؤ\0\0xq\0~\0t\0Manualsq\0~\0(+q\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~|xsq\0~\0E\0\0\0w\0\0\0q\0~wxt\0\nFinishModesr\0*org.enhydra.shark.xpdl.elements.FinishMode{\0\0xq\0~\0\0q\0~sq\0~\0	Vq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0>xq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0aq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0yq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0cdq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0 Kq\0~t\0\0t\0	Deadlinessr\0)org.enhydra.shark.xpdl.elements.Deadlines>ɜ\0\0xq\0~\0k\0q\0~sq\0~\0Oq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsr\05org.enhydra.shark.xpdl.elements.SimulationInformation\"|I\0\0xq\0~\0\0q\0~sq\0~\0j`q\0~t\0\0sq\0~\0w\0\0\0t\0\rInstantiationsq\0~\0\0q\0~sq\0~\0*jq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ONCEt\0MULTIPLExt\0Costsr\0$org.enhydra.shark.xpdl.elements.Cost\0\0xq\0~\0#q\0~sq\0~\0wuq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0Hؼq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0\'Sq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0Qq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0Rq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsr\0$org.enhydra.shark.xpdl.elements.IconTU(}6\0\0xq\0~\0#\0q\0~sq\0~\0[>wq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0\\q\0~t\0\0t\0TransitionRestrictionssr\06org.enhydra.shark.xpdl.elements.TransitionRestrictionsC)׀i;\0\0xq\0~\0k\0q\0~sq\0~\0Rn}q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0*>q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\01org.enhydra.shark.xpdl.elements.ExtendedAttribute\\F\0\0xq\0~\0t\0ExtendedAttributesq\0~\0%qxq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0n	q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpt\0Valuesq\0~\0\0q\0~sq\0~\0\rWDq\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\04\\?q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\Zq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\01oEq\0~t\0325,58.784088134765625pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~#q\0~lq\0~qq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0PEq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0zq\0~t\0	activity1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0JQq\0~t\0Resubmit Proposalpt\0Descriptionsq\0~\02\0q\0~sq\0~\0O|q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0=q\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0i6~q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0\'*q\0~!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0#Wq\0~!t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0P*q\0~+t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0`q\0~0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0|aS:q\0~0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Gt\0SubFlowsq\0~\0c9Awq\0~0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0eq\0~@t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0m\'q\0~@q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~Ksq\0~\0)tq\0~@t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~Eq\0~Hq\0~Lxxq\0~4xsq\0~\0E\0\0\0w\0\0\0q\0~0xsq\0~_t\0\rBlockActivitysq\0~\02@q\0~!t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0Hlq\0~St\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Xxxq\0~+t\0	Performersq\0~k\0q\0~\\sq\0~\0zq\0~t\0	requestert\0	StartModesq\0~p\0q\0~`sq\0~\0MCq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0j\Zq\0~at\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0>Gq\0~et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0_qq\0~et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\066q\0~et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~ixsq\0~\0E\0\0\0w\0\0\0q\0~ext\0\nFinishModesq\0~\0q\0~|sq\0~\0Fq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\08Rq\0~}t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0g*q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0B6Eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0h!dq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0xzbq\0~t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0pq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0ouq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0c\Z0q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0Hq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0W&q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0qnq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0\nRq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0Tzq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0e{q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0d:q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0PKq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0gq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0eZq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\08qq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0F:q\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0ldoq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0s\ZBq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0Mq\0~t\0293,17.784095764160156pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~\Zq\0~q\0~!q\0~]q\0~aq\0~}q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0:!\"q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0mceq\0~t\0\rsend_proposalpq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~t\0Finalize Proposalpt\0Descriptionsq\0~\02\0q\0~sq\0~\0&,eq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0Qq\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0=q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0\0Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0E4q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0\Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0PbWq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Gt\0SubFlowsq\0~\0ir\\q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0z	q\0~ t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0<X7q\0~ q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~+sq\0~\0/O8q\0~ t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~%q\0~(q\0~,xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~_t\0\rBlockActivitysq\0~\0=q\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0?Bq\0~3t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~8xxq\0~t\0	Performersq\0~k\0q\0~<sq\0~\0)\04q\0~t\0	requestert\0	StartModesq\0~p\0q\0~@sq\0~\0dq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0Er6q\0~At\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\05\0\\q\0~Et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0\Z(q\0~Et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0-Nq\0~Et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Ixsq\0~\0E\0\0\0w\0\0\0q\0~Ext\0\nFinishModesq\0~\0q\0~\\sq\0~\0Ji#q\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0} Fq\0~]t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0fXq\0~at\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0q\0~at\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\01?q\0~at\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~exsq\0~\0E\0\0\0w\0\0\0q\0~axt\0Prioritysq\0~\0q\0~xsq\0~\0q\0~t\0\0t\0	Deadlinessq\0~\0q\0~|sq\0~\08uU	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0.q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0kqq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0|q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0n;q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0Xgq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0<ʦq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0GXcq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0P,yq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0}%q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0_q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0^2Փq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0^?eq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Kr@q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0g;q\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0SI/q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0uSq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0Wq\0~t\0788,24.170455932617188pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~=q\0~Aq\0~]q\0~yq\0~}q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\077=cq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0]q\0~t\0tool1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0(Rq\0~t\0Email Approved Notificationpt\0Descriptionsq\0~\02\0q\0~sq\0~\0Eq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0rq\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0|aq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0P/q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0bq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0]\nq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0{DD{q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0$org.enhydra.shark.xpdl.elements.Tool\\6&+G\0\0xq\0~\0t\0Toolsq\0~\0iq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0<	q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0D!q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0APPLICATIONt\0	PROCEDURExt\0ActualParameterssq\0~W\0q\0~sq\0~\0Wrg%q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0Gq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0IR,q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	q\0~q\0~q\0~xxsq\0~Gt\0SubFlowsq\0~\0I\"q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0-~vq\0~t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0t!q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~*sq\0~\0Fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~$q\0~\'q\0~+xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~_t\0\rBlockActivitysq\0~\0B=!_q\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0DMq\0~2t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~7xxq\0~t\0	Performersq\0~k\0q\0~;sq\0~\0l_q\0~t\0	requestert\0	StartModesq\0~p\0q\0~?sq\0~\0bȃq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0Iaq\0~@t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0<h	sq\0~Dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\08q\0~Dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\08^%q\0~Dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Hxsq\0~\0E\0\0\0w\0\0\0q\0~Dxt\0\nFinishModesq\0~\0q\0~[sq\0~\0:q\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0xJq\0~\\t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0Ql,q\0~`t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0yq\0~`t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0YJq\0~`t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~dxsq\0~\0E\0\0\0w\0\0\0q\0~`xt\0Prioritysq\0~\0q\0~wsq\0~\0&ĵq\0~t\0\0t\0	Deadlinessq\0~\0q\0~{sq\0~\0lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0H?\Zq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Kq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0H7q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0Bq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\03PMMq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0=q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0tDhq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0Aj6q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0p+}jq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0H{-q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0,q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0GJ0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0cmq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0eHq\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0,5q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0:vq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\04q\0~t\0623,25.170455932617188pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~<q\0~@q\0~\\q\0~xq\0~|q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0V@xq\0~t\0tool2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0D:	q\0~t\0Email Reject Notificationpt\0Descriptionsq\0~\02\0q\0~sq\0~\0]4q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0<,q\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0\'Rq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0colq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0P\\q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0j5q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0?C#4q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0&3q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0Toolsq\0~\0֛q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0i/5q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0O5q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~\rxt\0ActualParameterssq\0~W\0q\0~\nsq\0~\0wԔ\rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0*$q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0	Yq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~Gt\0SubFlowsq\0~\0z{\\q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0:q\0~t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0;q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~&sq\0~\0Jsq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~ q\0~#q\0~\'xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~_t\0\rBlockActivitysq\0~\0]䆽q\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\01F<q\0~.t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~3xxq\0~t\0	Performersq\0~k\0q\0~7sq\0~\0q\0~t\0approvert\0	StartModesq\0~p\0q\0~;sq\0~\0B>q\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0;*q\0~<t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0e\"q\0~@t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0i@q\0~@t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Rfq\0~@t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Dxsq\0~\0E\0\0\0w\0\0\0q\0~@xt\0\nFinishModesq\0~\0q\0~Wsq\0~\0LNq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0Z.q\0~Xt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0^Ɲq\0~\\t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Vq\0~\\t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0i<q\0~\\t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~`xsq\0~\0E\0\0\0w\0\0\0q\0~\\xt\0Prioritysq\0~\0q\0~ssq\0~\0,>Nq\0~t\0\0t\0	Deadlinessq\0~\0q\0~wsq\0~\0Nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~}sq\0~\0^	8xq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0R9=q\0~~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0?q\0~~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0*K{q\0~~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0=q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0#9Zq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0GȨq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\00	q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\09U:q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0[;q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Yq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0pq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\033q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0@ q\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0J5@q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0yq\0~t\0692,59.1136474609375pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~8q\0~<q\0~Xq\0~tq\0~xq\0~~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0%R$q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Aq\0~t\0tool3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0@Xq\0~t\0\ZEmail Request For Approvalpt\0Descriptionsq\0~\02\0q\0~sq\0~\0:Sq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0%eq\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0\\7+q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0U\"q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0xc̬q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0Toolsq\0~\0Q(.q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0=[q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0oq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~\rxt\0ActualParameterssq\0~W\0q\0~sq\0~\02fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0/rcKq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~q\0~q\0~\rq\0~xxsq\0~Gt\0SubFlowsq\0~\0y\nrq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0}q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~\"sq\0~\0E7ʐq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~#xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~_t\0\rBlockActivitysq\0~\0|Ճq\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0JzPq\0~*t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~/xxq\0~t\0	Performersq\0~k\0q\0~3sq\0~\0dq\0~t\0approvert\0	StartModesq\0~p\0q\0~7sq\0~\0dMq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\04)`q\0~8t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0S6Mq\0~<t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0F\'q\0~<t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0\0q\0~<t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~@xsq\0~\0E\0\0\0w\0\0\0q\0~<xt\0\nFinishModesq\0~\0q\0~Ssq\0~\0l<q\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0F˼q\0~Tt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0$q\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0~iq\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0e`q\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\\xsq\0~\0E\0\0\0w\0\0\0q\0~Xxt\0Prioritysq\0~\0q\0~osq\0~\0i9q\0~t\0\0t\0	Deadlinessq\0~\0q\0~ssq\0~\0\nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~ysq\0~\0~Cq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0]7q\0~zq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0uq\0~zt\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0!q\0~zt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0%Qq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0Dտwq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0n{q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0!q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0@q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0)4q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\05org.enhydra.shark.xpdl.elements.TransitionRestrictionN}\0\0xq\0~\0t\0TransitionRestrictionsq\0~\0W(q\0~t\0\0sq\0~\0w\0\0\0t\0Joinsr\0$org.enhydra.shark.xpdl.elements.Joinڕөx)5\0\0xq\0~\0\0q\0~sq\0~\0*oóq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Q9+q\0~t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ANDt\0XORxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Splitsr\0%org.enhydra.shark.xpdl.elements.Split~ѯWS\0\0xq\0~\0\0q\0~sq\0~\0/:fq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0^q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0TransitionRefssr\0.org.enhydra.shark.xpdl.elements.TransitionRefsъ\0\0xq\0~\0k\0q\0~sq\0~\0Uxq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Koq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0RDq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0<Dq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\03+q\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0`=Xq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0`#q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\04Qq\0~t\0145,61pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~4q\0~8q\0~Tq\0~pq\0~tq\0~zq\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0S;q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0:{̳q\0~t\0tool4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Yq\0~t\0Email Resubmit Notificationpt\0Descriptionsq\0~\02\0q\0~sq\0~\0.*Yxq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0Tͦq\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0*ٖsq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0Cbq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0?{q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\05q\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0Sq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0Toolsq\0~\07q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0+2q\0~	t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0odq\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~\rxt\0ActualParameterssq\0~W\0q\0~	\'sq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~	-sq\0~\05n,^q\0~	t\0\0t\0ExtendedAttributessq\0~\0\0q\0~	1sq\0~\0 q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~	!q\0~	$q\0~	(q\0~	.q\0~	2xxsq\0~Gt\0SubFlowsq\0~\0Dvq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0nvDq\0~	8t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0Aq\0~	8q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~	Csq\0~\0j.q\0~	8t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~	=q\0~	@q\0~	Dxxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xsq\0~_t\0\rBlockActivitysq\0~\0&q\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0z,@q\0~	Kt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~	Pxxq\0~	t\0	Performersq\0~k\0q\0~	Tsq\0~\0Oq\0~t\0	requestert\0	StartModesq\0~p\0q\0~	Xsq\0~\0Lq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0r7,q\0~	Yt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0U q\0~	]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0uxSq\0~	]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0KS9q\0~	]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	axsq\0~\0E\0\0\0w\0\0\0q\0~	]xt\0\nFinishModesq\0~\0q\0~	tsq\0~\0CJq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0q\0~	ut\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\02H,q\0~	yt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0q\0~	yt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0yq\0~	yt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	}xsq\0~\0E\0\0\0w\0\0\0q\0~	yxt\0Prioritysq\0~\0q\0~	sq\0~\0JHnq\0~t\0\0t\0	Deadlinessq\0~\0q\0~	sq\0~\09C\\q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~	sq\0~\0%5q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0q\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~	sq\0~\0Mq\0~	t\0\0t\0TimeEstimationsq\0~q\0~	sq\0~\0<4kQq\0~	t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~	sq\0~\0JToq\0~	t\0\0t\0WorkingTimesq\0~\0q\0~	sq\0~\0#EFq\0~	t\0\0t\0Durationsq\0~\0q\0~	sq\0~\0JBq\0~	t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	xxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	xt\0Iconsq\0~\0q\0~	sq\0~\0UQ/q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~	sq\0~\0%q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~	sq\0~\0)q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\0a@\nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0`q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0#jq\0~	t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0nKq\0~	t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xsq\0~t\0ExtendedAttributesq\0~\0)s+q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0	cyq\0~	t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0qq\0~	t\0442,16pxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~	Uq\0~	Yq\0~	uq\0~	q\0~	q\0~	q\0~	q\0~	q\0~	q\0~	xsq\0~t\0Activitysq\0~\0+t\0q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Mq\0~	t\0route2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Y<q\0~	t\0\0pt\0Descriptionsq\0~\02\0q\0~	sq\0~\09q\0~	t\0\0t\0Limitsq\0~\0q\0~	sq\0~\0]nq\0~	t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0Ueq\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0\0pq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0ʈq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0:/}q\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0|q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0G\nR^q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Gt\0SubFlowsq\0~\0FQq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0CVq\0~\nt\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0:ٟ?q\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~\n#sq\0~\0/Tq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\n q\0~\n$xxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~\nxsq\0~_t\0\rBlockActivitysq\0~\0Eq\0~	t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0lq\0~\n+t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\n0xxq\0~	t\0	Performersq\0~k\0q\0~\n4sq\0~\0\ZLq\0~	t\0approvert\0	StartModesq\0~p\0q\0~\n8sq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\09q\0~\n9t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0Ac.fq\0~\n=t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0eq\0~\n=t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0-aq\0~\n=t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nAxsq\0~\0E\0\0\0w\0\0\0q\0~\n=xt\0\nFinishModesq\0~\0q\0~\nTsq\0~\05(pDq\0~	t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0m`xq\0~\nUt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0q\0~\nYt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0liq\0~\nYt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0(5q\0~\nYt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\n]xsq\0~\0E\0\0\0w\0\0\0q\0~\nYxt\0Prioritysq\0~\0q\0~\npsq\0~\0q\0~	t\0\0t\0	Deadlinessq\0~\0q\0~\ntsq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~\nzsq\0~\0#x:q\0~	t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0eq\0~\n{q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~\nsq\0~\0T;|q\0~\n{t\0\0t\0TimeEstimationsq\0~q\0~\nsq\0~\0O~q\0~\n{t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\nsq\0~\0gF߲q\0~\nt\0\0t\0WorkingTimesq\0~\0q\0~\nsq\0~\0q\0~\nt\0\0t\0Durationsq\0~\0q\0~\nsq\0~\0pq\0~\nt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxt\0Iconsq\0~\0q\0~\nsq\0~\0?ϙVq\0~	t\0\0t\0\rDocumentationsq\0~\07\0q\0~\nsq\0~\0n%zRq\0~	t\0\0t\0TransitionRestrictionssq\0~\0q\0~\nsq\0~\0Uq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0TransitionRestrictionsq\0~\0*Ѵq\0~\nt\0\0sq\0~\0w\0\0\0t\0Joinsq\0~\0q\0~\nsq\0~\0q\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0*q\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\nxt\0Splitsq\0~\0q\0~\nsq\0~\0*^q\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\rgq\0~\nt\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0TransitionRefssq\0~\0q\0~\nsq\0~\03vyq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0-org.enhydra.shark.xpdl.elements.TransitionRef%-a\0\0xq\0~\0t\0\rTransitionRefsq\0~\0\"7cq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Nq\0~\nt\0transition5pxsq\0~\0E\0\0\0w\0\0\0q\0~\nxsq\0~\nt\0\rTransitionRefsq\0~\0DC)q\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0;q\0~\nt\0transition8pxsq\0~\0E\0\0\0w\0\0\0q\0~\nxsq\0~\nt\0\rTransitionRefsq\0~\0\rdq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\'%q\0~\nt\0transition10pxsq\0~\0E\0\0\0w\0\0\0q\0~\nxxxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxxt\0ExtendedAttributessq\0~\0\0q\0~\nsq\0~\0iq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0Hq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0qrjq\0~\nt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0) q\0~\nt\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxsq\0~t\0ExtendedAttributesq\0~\0yq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0wq\0~\nt\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0Mq\0~\nt\0486,63.784088134765625pxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxxpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	q\0~\n5q\0~\n9q\0~\nUq\0~\nqq\0~\nuq\0~\n{q\0~\nq\0~\nq\0~\nq\0~\nxsq\0~t\0Activitysq\0~\0E\0q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Q#q\0~t\0route1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0k\Z4q\0~t\0\0pt\0Descriptionsq\0~\02\0q\0~sq\0~\00>q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0Qaq\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0ZW[q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0`P\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0+q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0gyq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0Bnzq\0~#t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0a|wCq\0~#t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Gt\0SubFlowsq\0~\0xnMq\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Sgq\0~3t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0GLq\0~3q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~>sq\0~\0E;q\0~3t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~8q\0~;q\0~?xxq\0~\'xsq\0~\0E\0\0\0w\0\0\0q\0~#xsq\0~_t\0\rBlockActivitysq\0~\0f\nq\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0cq\0~Ft\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Kxxq\0~t\0	Performersq\0~k\0q\0~Osq\0~\0^Qoq\0~t\0	requestert\0	StartModesq\0~p\0q\0~Ssq\0~\0Dcq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0*@q\0~Tt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0$!q\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0eq\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0q\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\\xsq\0~\0E\0\0\0w\0\0\0q\0~Xxt\0\nFinishModesq\0~\0q\0~osq\0~\0e	Tq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0Yq\0~pt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0DQq\0~tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0q\0~tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0=GWq\0~tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~txt\0Prioritysq\0~\0q\0~sq\0~\0c3xq\0~t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0X-.q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0V\ZAq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0T\nq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0oq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0k?q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0S/q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0Og}q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0Wq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0^V:q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0}^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0d\ZKq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0BMq\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0	q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0?=q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0%q\0~t\0161,54.9886474609375pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	q\0~\rq\0~q\0~q\0~Pq\0~Tq\0~pq\0~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0Transitionssr\0+org.enhydra.shark.xpdl.elements.Transitions9>/i\0\0xq\0~\0k\0q\0~sq\0~\0K,q\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0	w\0\0\0	sr\0*org.enhydra.shark.xpdl.elements.Transitiontx\0\0xq\0~\0t\0\nTransitionsq\0~\0qq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0<\rq\0~t\0transition2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\"c(q\0~t\0\0pt\0Fromsq\0~\0q\0~sq\0~\06$,q\0~t\0approve_proposalpt\0Tosq\0~\0q\0~sq\0~\0\0^q\0~t\0route2pt\0	Conditionsr\0)org.enhydra.shark.xpdl.elements.ConditionDZ;|\0\0xq\0~\0\0q\0~sq\0~\0Ssq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0uK_dq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0	CONDITIONt\0	OTHERWISEt\0	EXCEPTIONt\0DEFAULTEXCEPTIONxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~\nsq\0~\0nAcq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0?GIq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0!Zq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0$6iq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0M `q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0[q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0?Aq\0~!t\0transition5pq\0~\0sq\0~\0\0q\0~\0sq\0~\0dyoq\0~!t\0\0pq\0~sq\0~\0q\0~sq\0~\0>>Weq\0~!t\0route2pq\0~sq\0~\0q\0~sq\0~\0/r.q\0~!t\0tool2pt\0	Conditionsq\0~\0q\0~2sq\0~\0pq\0~!t\0status === \'Rejected\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0<>}q\0~3t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~7xt\0Descriptionsq\0~\02\0q\0~<sq\0~\0Qq\0~!t\0\0t\0ExtendedAttributessq\0~\0\0q\0~@sq\0~\0siRq\0~!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0,tq\0~At\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0V!q\0~Ft\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\03?q\0~Ft\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~Kq\0~Nxsq\0~t\0ExtendedAttributesq\0~\04Ѡq\0~At\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{q\0~Rt\0PBUILDER_TRANSITION_CONDITIONSpq\0~sq\0~\0\0q\0~sq\0~\0P/3q\0~Rt\0G[{\"join\":\"&&\",\"variable\":\"status\",\"operator\":\"===\",\"value\":\"Rejected\"}]pxsq\0~\0E\0\0\0w\0\0\0q\0~Wq\0~Zxxpxsq\0~\0E\0\0\0w\0\0\0q\0~&q\0~)q\0~,q\0~/q\0~3q\0~=q\0~Axsq\0~t\0\nTransitionsq\0~\0RPq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{ʮq\0~_t\0transition7pq\0~\0sq\0~\0\0q\0~\0sq\0~\0εYq\0~_t\0\0pq\0~sq\0~\0q\0~sq\0~\0k8Oq\0~_t\0tool1pq\0~sq\0~\0q\0~sq\0~\08np+q\0~_t\0\rsend_proposalpt\0	Conditionsq\0~\0q\0~psq\0~\0CWq\0~_t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0jq\0~qq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~uxt\0Descriptionsq\0~\02\0q\0~ysq\0~\0!oq\0~_t\0\0t\0ExtendedAttributessq\0~\0\0q\0~}sq\0~\0Bbq\0~_t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0ygq\0~~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0}q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0c;q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~dq\0~gq\0~jq\0~mq\0~qq\0~zq\0~~xsq\0~t\0\nTransitionsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\05q\0~t\0transition8pq\0~\0sq\0~\0\0q\0~\0sq\0~\08\nxq\0~t\0Approvedpq\0~sq\0~\0q\0~sq\0~\0Vc q\0~t\0route2pq\0~sq\0~\0q\0~sq\0~\0,Bq\0~t\0tool1pt\0	Conditionsq\0~\0q\0~sq\0~\0PXq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0<aq\0~t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0J\r4q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0T|q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Z4!q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0fzq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0,ӓq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{iq\0~t\0transition11pq\0~\0sq\0~\0\0q\0~\0sq\0~\02=q\0~t\0\0pq\0~sq\0~\0q\0~sq\0~\0q\0~t\0route1pq\0~sq\0~\0q\0~sq\0~\0~q\0~t\0tool3pt\0	Conditionsq\0~\0q\0~sq\0~\0iK\rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0*+$q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0 Zq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Jq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0V~\rq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0~q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0wAq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ruxq\0~t\0transition9pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\"\\:q\0~t\0\0pq\0~sq\0~\0q\0~sq\0~\0+Tq\0~t\0tool3pq\0~sq\0~\0q\0~sq\0~\0pd)q\0~t\0approve_proposalpt\0	Conditionsq\0~\0q\0~\rsq\0~\0TɁiq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\08/q\0~\rq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\r	xt\0Descriptionsq\0~\02\0q\0~\r\rsq\0~\0i1q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0jKcq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0<(+q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0DӪq\0~\rt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0q\0~\rt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~\rq\0~\rq\0~\rq\0~\rxsq\0~t\0\nTransitionsq\0~\0@&q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0&tq\0~\r$t\0transition12pq\0~\0sq\0~\0\0q\0~\0sq\0~\0H8Iq\0~\r$t\0\0pq\0~sq\0~\0q\0~sq\0~\0u3+q\0~\r$t\0	activity1pq\0~sq\0~\0q\0~sq\0~\0,q\0~\r$t\0tool3pt\0	Conditionsq\0~\0q\0~\r5sq\0~\0?߈q\0~\r$t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Sq\0~\r6q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\r:xt\0Descriptionsq\0~\02\0q\0~\r>sq\0~\0uq\0~\r$t\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rBsq\0~\0^|6Uq\0~\r$t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0$q\0~\rCt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\"8q\0~\rHt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0xVq\0~\rHt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\rMq\0~\rPxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\r)q\0~\r,q\0~\r/q\0~\r2q\0~\r6q\0~\r?q\0~\rCxsq\0~t\0\nTransitionsq\0~\04q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0rq\0~\rUt\0transition10pq\0~\0sq\0~\0\0q\0~\0sq\0~\0_8l_q\0~\rUt\0\0pq\0~sq\0~\0q\0~sq\0~\06wq\0~\rUt\0route2pq\0~sq\0~\0q\0~sq\0~\0=٦9q\0~\rUt\0tool4pt\0	Conditionsq\0~\0q\0~\rfsq\0~\0o0q\0~\rUt\0status === \'Resubmit\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0daq\0~\rgt\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\rkxt\0Descriptionsq\0~\02\0q\0~\rpsq\0~\0^q\0~\rUt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rtsq\0~\07q\0~\rUt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0uGGq\0~\rut\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0<2q\0~\rzt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0.Iq\0~\rzt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0rq\0~\rut\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0IHυq\0~\rt\0PBUILDER_TRANSITION_CONDITIONSpq\0~sq\0~\0\0q\0~sq\0~\09G2q\0~\rt\0G[{\"join\":\"&&\",\"variable\":\"status\",\"operator\":\"===\",\"value\":\"Resubmit\"}]pxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rZq\0~\r]q\0~\r`q\0~\rcq\0~\rgq\0~\rqq\0~\ruxsq\0~t\0\nTransitionsq\0~\0}؉q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\09q\0~\rt\0transition13pq\0~\0sq\0~\0\0q\0~\0sq\0~\0vf5q\0~\rt\0\0pq\0~sq\0~\0q\0~sq\0~\0|_q\0~\rt\0tool4pq\0~sq\0~\0q\0~sq\0~\0swq\0~\rt\0	activity1pt\0	Conditionsq\0~\0q\0~\rsq\0~\0Qq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0U6_fq\0~\rq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0Descriptionsq\0~\02\0q\0~\rsq\0~\0JȌq\0~\rt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0$q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0{Bq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~\rt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\04qq\0~\rt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rxxt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\08hq\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0|iq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0pq\0~\rt\0%JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDERpq\0~sq\0~\0\0q\0~sq\0~\0*IՊq\0~\rt\0requester;approverpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0.q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Zq\0~\rt\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0(req\0~\rt\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=send_proposal,X_OFFSET=912,Y_OFFSET=35,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0Lsq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0$\'\nq\0~\rt\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0~b4q\0~\rt\0JaWE_GRAPH_PARTICIPANT_ID=approver,CONNECTING_ACTIVITY_ID=tool2,X_OFFSET=850,Y_OFFSET=73,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0E<9q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0$q\0~\rt\0JaWE_GRAPH_START_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0_q\0~\rt\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=route1,X_OFFSET=101,Y_OFFSET=66,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~cq\0~fq\0~jq\0~qq\0~q\0~q\0~q\0~q\0~q\0~q\0~	q\0~q\0~\rxxt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0gq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0\';Qq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\06Ĩq\0~t\0EDITING_TOOLpq\0~sq\0~\0\0q\0~sq\0~\0aq\0~t\0Web Workflow Designerpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	xsq\0~t\0ExtendedAttributesq\0~\0|fq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\Zq\0~\rt\0EDITING_TOOL_VERSIONpq\0~sq\0~\0\0q\0~sq\0~\0BBq\0~\rt\0\r5.0-pre-alphapxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~\0q\0~\0q\0~\0q\0~\0Iq\0~\0tq\0~\0q\0~\0q\0~\0q\0~\0q\0~q\0~Qq\0~Xq\0~\rx\0sq\0~\0w\0\0\0\0xt\01sr\0*org.enhydra.shark.xpdl.elements.Namespaces|<.R\0\0xq\0~\0kt\0\nNamespacessq\0~\0H0\'q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.Namespacez_\0\0xq\0~\0t\0	Namespacesq\0~\0y[܄q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0|q\0~$t\0xpdlpq\0~\0sq\0~\0q\0~\0sq\0~\00q\0~$t\0 http://www.wfmc.org/2002/XPDL1.0pxsq\0~\0E\0\0\0w\0\0\0q\0~)q\0~,xx',1000202,1,1000203,0),
('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Package xmlns=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" Id=\"dashboard\" Name=\"Employee Portal\" xsi:schemaLocation=\"http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">\n    <PackageHeader>\n        <XPDLVersion>1.0</XPDLVersion>\n        <Vendor/>\n        <Created/>\n    </PackageHeader>\n    <Script Type=\"text/javascript\"/>\n    <Participants>\n        <Participant Id=\"requester\" Name=\"Requester\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"approver\" Name=\"Approver\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n    </Participants>\n    <Applications>\n        <Application Id=\"default_application\"/>\n    </Applications>\n    <WorkflowProcesses>\n        <WorkflowProcess Id=\"process1\" Name=\"User Registration Process\">\n            <ProcessHeader DurationUnit=\"h\"/>\n            <DataFields>\n                <DataField Id=\"status\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"username\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n            </DataFields>\n            <Activities>\n                <Activity Id=\"activity1\" Name=\"Approve Registration\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"174,31.787506103515625\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route1\">\n                    <Route/>\n                    <Performer>approver</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition2\"/>\n                                    <TransitionRef Id=\"transition3\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"328,37.225006103515625\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool2\" Name=\"Send Rejection Email\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"525,117.01251220703125\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool3\" Name=\"Send User Registration Email\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"670,27\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"activity2\" Name=\"Create User\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"522,24.57501220703125\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool4\" Name=\"Email Request For Approval\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"171,26.987503051757812\"/>\n                    </ExtendedAttributes>\n                </Activity>\n            </Activities>\n            <Transitions>\n                <Transition From=\"activity1\" Id=\"transition1\" To=\"route1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition2\" To=\"activity2\">\n                    <Condition Type=\"CONDITION\">status === \'Approved\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"PBUILDER_TRANSITION_CONDITIONS\" Value=\"[{&quot;join&quot;:&quot;&amp;&amp;&quot;,&quot;variable&quot;:&quot;status&quot;,&quot;operator&quot;:&quot;===&quot;,&quot;value&quot;:&quot;Approved&quot;}]\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition3\" Name=\"Rejected\" To=\"tool2\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"activity2\" Id=\"transition4\" To=\"tool3\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool4\" Id=\"transition5\" To=\"activity1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n            </Transitions>\n            <ExtendedAttributes>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER\" Value=\"requester;approver\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=approver,CONNECTING_ACTIVITY_ID=tool2,X_OFFSET=706,Y_OFFSET=130,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=approver,CONNECTING_ACTIVITY_ID=tool3,X_OFFSET=836,Y_OFFSET=39,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_START_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=tool4,X_OFFSET=101,Y_OFFSET=41,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULT\"/>\n            </ExtendedAttributes>\n        </WorkflowProcess>\n    </WorkflowProcesses>\n    <ExtendedAttributes>\n        <ExtendedAttribute Name=\"EDITING_TOOL\" Value=\"Web Workflow Designer\"/>\n        <ExtendedAttribute Name=\"EDITING_TOOL_VERSION\" Value=\"5.0-pre-alpha\"/>\n    </ExtendedAttributes>\n</Package>\n','\0sr\0\'org.enhydra.shark.xpdl.elements.Package~+Vmŀ~\0Z\0isTransientL\0extPkgRefsToIdst\0.Lorg/enhydra/shark/utilities/SequencedHashMap;L\0internalVersiont\0Ljava/lang/String;L\0\nnamespacest\0,Lorg/enhydra/shark/xpdl/elements/Namespaces;xr\0(org.enhydra.shark.xpdl.XMLComplexElement>(\0\0xr\05org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex2\0L\0\nelementMapq\0~\0L\0elementst\0Ljava/util/ArrayList;xr\0!org.enhydra.shark.xpdl.XMLElement#+B#\0Z\0\nisReadOnlyZ\0\nisRequiredL\0nameq\0~\0L\0originalElementHashCodet\0Ljava/lang/Integer;L\0parentt\0#Lorg/enhydra/shark/xpdl/XMLElement;L\0valueq\0~\0xpt\0Packagesr\0java.lang.Integer⠤8\0I\0valuexr\0java.lang.Number\0\0xpp\0spt\0\0sr\0,org.enhydra.shark.utilities.SequencedHashMap.\"\"&\0\0xpw\0\0\0\rt\0Idsr\0#org.enhydra.shark.xpdl.XMLAttribute#c݀M;\0L\0choicesq\0~\0xq\0~\0q\0~\0sq\0~\0>q\0~\0\nt\0	dashboardpt\0Namesq\0~\0\0q\0~\0sq\0~\0[q\0~\0\nt\0Employee Portalpt\0\rPackageHeadersr\0-org.enhydra.shark.xpdl.elements.PackageHeaderv,\0\0xq\0~\0\0q\0~\0sq\0~\0Lq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0XPDLVersionsr\0+org.enhydra.shark.xpdl.elements.XPDLVersion\"}Y.w\0\0xr\0\'org.enhydra.shark.xpdl.XMLSimpleElementm\0\0xq\0~\0q\0~\0!sq\0~\0?eq\0~\0t\01.0t\0Vendorsr\0&org.enhydra.shark.xpdl.elements.Vendor tE:\0\0xq\0~\0#q\0~\0\'sq\0~\0(-q\0~\0t\0\0t\0Createdsr\0\'org.enhydra.shark.xpdl.elements.CreatedzdK|[\0\0xq\0~\0#q\0~\0,sq\0~\0C2q\0~\0t\0\0t\0Descriptionsr\0+org.enhydra.shark.xpdl.elements.Description۰738\0\0xq\0~\0#\0q\0~\01sq\0~\0CDq\0~\0t\0\0t\0\rDocumentationsr\0-org.enhydra.shark.xpdl.elements.Documentation`9y\0\0xq\0~\0#\0q\0~\06sq\0~\0P5lq\0~\0t\0\0t\0PriorityUnitsr\0,org.enhydra.shark.xpdl.elements.PriorityUnit\0\0xq\0~\0#\0q\0~\0;sq\0~\0Niq\0~\0t\0\0t\0CostUnitsr\0(org.enhydra.shark.xpdl.elements.CostUnit܎=H\0\0xq\0~\0#\0q\0~\0@sq\0~\0 +q\0~\0t\0\0xsr\0java.util.ArrayListxa\0I\0sizexp\0\0\0w\0\0\0q\0~\0$q\0~\0)q\0~\0.q\0~\03q\0~\08q\0~\0=q\0~\0Bxt\0RedefinableHeadersr\01org.enhydra.shark.xpdl.elements.RedefinableHeaderMϪ\'H\0\0xq\0~\0\0q\0~\0Gsq\0~\0Eq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0PublicationStatussq\0~\0\0q\0~\0Msq\0~\09V7q\0~\0It\0\0sq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0UNDER_REVISIONt\0RELEASEDt\0\nUNDER_TESTxt\0Authorsr\0&org.enhydra.shark.xpdl.elements.Author5fᧆ\0\0xq\0~\0#\0q\0~\0Usq\0~\0?A-q\0~\0It\0\0t\0Versionsr\0\'org.enhydra.shark.xpdl.elements.Version9=3~JQ\0\0xq\0~\0#\0q\0~\0Zsq\0~\0CHq\0~\0It\0\0t\0Codepagesr\0(org.enhydra.shark.xpdl.elements.Codepage9$me\rG\0\0xq\0~\0#\0q\0~\0_sq\0~\0!Mq\0~\0It\0\0t\0\nCountrykeysr\0*org.enhydra.shark.xpdl.elements.Countrykey.\0\0xq\0~\0#\0q\0~\0dsq\0~\0,q\0~\0It\0\0t\0Responsiblessr\0,org.enhydra.shark.xpdl.elements.Responsibles${S\0\0xr\0$org.enhydra.shark.xpdl.XMLCollectionjċm\0\0xq\0~\0\0q\0~\0isq\0~\0nq\0~\0It\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0Nq\0~\0Wq\0~\0\\q\0~\0aq\0~\0fq\0~\0lxt\0ConformanceClasssr\00org.enhydra.shark.xpdl.elements.ConformanceClassy0|k\0\0xq\0~\0\0q\0~\0rsq\0~\0oVq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0GraphConformancesq\0~\0\0q\0~\0xsq\0~\0Jjq\0~\0tq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0FULL_BLOCKEDt\0LOOP_BLOCKEDt\0NON_BLOCKEDxxsq\0~\0E\0\0\0w\0\0\0q\0~\0yxt\0Scriptsr\0&org.enhydra.shark.xpdl.elements.ScriptQjS8\0\0xq\0~\0\0q\0~\0sq\0~\04/q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0Typesq\0~\0q\0~\0sq\0~\0jq\0~\0t\0text/javascriptpt\0Versionsq\0~\0\0q\0~\0sq\0~\0	Rq\0~\0t\0\0pt\0Grammarsq\0~\0\0q\0~\0sq\0~\07q\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExternalPackagessr\00org.enhydra.shark.xpdl.elements.ExternalPackagesw\"+Ũ\0\0xq\0~\0k\0q\0~\0sq\0~\0q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0TypeDeclarationssr\00org.enhydra.shark.xpdl.elements.TypeDeclarations\rOx5\0\0xq\0~\0k\0q\0~\0sq\0~\0E4\'q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Participantssr\0,org.enhydra.shark.xpdl.elements.Participantsh`g8J\0\0xq\0~\0k\0q\0~\0sq\0~\08q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Participanto$rc\0\0xr\0+org.enhydra.shark.xpdl.XMLCollectionElementCxvr\0\0xq\0~\0t\0Participantsq\0~\0x1aq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0@q\0~\0t\0	requesterpq\0~\0sq\0~\0\0q\0~\0sq\0~\0u=q\0~\0t\0	Requesterpt\0ParticipantTypesr\0/org.enhydra.shark.xpdl.elements.ParticipantType>n݅\0\0xq\0~\0q\0~\0sq\0~\0q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0X+{q\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0t\0RESOURCE_SETt\0RESOURCEt\0ROLEt\0ORGANIZATIONAL_UNITt\0HUMANt\0SYSTEMxxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0(q\0~\0t\0\0t\0ExternalReferencesr\01org.enhydra.shark.xpdl.elements.ExternalReferencebQ\0\0xq\0~\0\0q\0~\0sq\0~\00Lq\0~\0t\0\0sq\0~\0w\0\0\0t\0xrefsq\0~\0\0q\0~\0sq\0~\0Gq\0~\0t\0\0pt\0locationsq\0~\0q\0~\0sq\0~\0Gǖq\0~\0t\0\0pt\0	namespacesq\0~\0\0q\0~\0sq\0~\0aq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExtendedAttributessr\02org.enhydra.shark.xpdl.elements.ExtendedAttributesOUF\0L\0extAttribsStringq\0~\0xq\0~\0k\0q\0~\0sq\0~\01uq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xsq\0~\0t\0Participantsq\0~\0qOq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0>6$q\0~\0t\0approverpq\0~\0sq\0~\0\0q\0~\0sq\0~\0\\oq\0~\0t\0Approverpt\0ParticipantTypesq\0~\0q\0~\0sq\0~\0&mlq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0aq\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0\n9\"q\0~\0t\0\0t\0ExternalReferencesq\0~\0\0q\0~\0sq\0~\0Sjq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\ZVHq\0~\0t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0-2q\0~\0t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0NE`q\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~	xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0f$tuq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~xxt\0Applicationssr\0,org.enhydra.shark.xpdl.elements.Applications\0\0xq\0~\0k\0q\0~sq\0~\0cq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Applicationv	RS\0\0xq\0~\0t\0Applicationsq\0~\0-.aq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Xlq\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0Y4q\0~t\0\0pt\0Descriptionsq\0~\02\0q\0~\'sq\0~\0X^q\0~t\0\0t\0Choicesr\00org.enhydra.shark.xpdl.elements.ApplicationTypes?!\0\0xr\0\'org.enhydra.shark.xpdl.XMLComplexChoice|\"\0L\0choicesq\0~\0L\0choosenq\0~\0	xq\0~\0q\0~+sq\0~\04JM,q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\00org.enhydra.shark.xpdl.elements.FormalParameterspBÁZ\0\0xq\0~\0k\0t\0FormalParameterssq\0~\0ZXcq\0~.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0\0t\0ExternalReferencesq\0~\0\'4q\0~.t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0S3q\0~9t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\05q\0~9t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0,$q\0~9t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~>q\0~Aq\0~Dxxq\0~3t\0ExtendedAttributessq\0~\0\0q\0~Hsq\0~\0s/q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~!q\0~$q\0~(q\0~.q\0~Ixxt\0\nDataFieldssr\0*org.enhydra.shark.xpdl.elements.DataFieldsʦU\0\0xq\0~\0k\0q\0~Osq\0~\0Lq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0WorkflowProcessessr\01org.enhydra.shark.xpdl.elements.WorkflowProcessesp_0,\0\0xq\0~\0k\0q\0~Vsq\0~\0`aq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0/org.enhydra.shark.xpdl.elements.WorkflowProcess%v0L\0\0xq\0~\0t\0WorkflowProcesssq\0~\0<q\0~Xt\0\0sq\0~\0w\0\0\0\rq\0~\0sq\0~\0q\0~\0sq\0~\0ZGq\0~^t\0process1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0/~s	q\0~^t\0User Registration Processpt\0AccessLevelsq\0~\0\0q\0~isq\0~\0`q\0~^q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0PUBLICt\0PRIVATExt\0\rProcessHeadersr\0-org.enhydra.shark.xpdl.elements.ProcessHeaderLC-)\0\0xq\0~\0q\0~osq\0~\0ew+q\0~^t\0\0sq\0~\0w\0\0\0t\0DurationUnitsq\0~\0\0q\0~usq\0~\0TWq\0~qt\0hsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0Yt\0Mt\0Dt\0ht\0mt\0sxt\0Createdsq\0~\0-\0q\0~sq\0~\0pq\0~qt\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0PBq\0~qt\0\0t\0Prioritysr\0(org.enhydra.shark.xpdl.elements.Priority`Nn>b\0\0xq\0~\0#\0q\0~sq\0~\0uq\0~qt\0\0t\0Limitsr\0%org.enhydra.shark.xpdl.elements.Limit1ӗ\0\0xq\0~\0#\0q\0~sq\0~\0y2q\0~qt\0\0t\0	ValidFromsr\0)org.enhydra.shark.xpdl.elements.ValidFromcŅ|L<\0\0xq\0~\0#\0q\0~sq\0~\0x7q\0~qt\0\0t\0ValidTosr\0\'org.enhydra.shark.xpdl.elements.ValidToM\0\0xq\0~\0#\0q\0~sq\0~\0\\3Hq\0~qt\0\0t\0TimeEstimationsr\0.org.enhydra.shark.xpdl.elements.TimeEstimationŀ\'3\0\0xq\0~\0\0q\0~sq\0~\0xaq\0~qt\0\0sq\0~\0w\0\0\0t\0WaitingTimesr\0+org.enhydra.shark.xpdl.elements.WaitingTimeN/\0\0xq\0~\0#\0q\0~sq\0~\09:q\0~t\0\0t\0WorkingTimesr\0+org.enhydra.shark.xpdl.elements.WorkingTime~\0\0xq\0~\0#\0q\0~sq\0~\067q\0~t\0\0t\0Durationsr\0(org.enhydra.shark.xpdl.elements.Duration C\0\0xq\0~\0#\0q\0~sq\0~\09q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~vq\0~q\0~q\0~q\0~q\0~q\0~q\0~xt\0RedefinableHeadersq\0~\0H\0q\0~sq\0~\02>+q\0~^t\0\0sq\0~\0w\0\0\0q\0~\0Msq\0~\0\0q\0~\0Msq\0~\0Gq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~\0Rq\0~\0Sq\0~\0Txt\0Authorsq\0~\0V\0q\0~sq\0~\0JZAq\0~t\0\0t\0Versionsq\0~\0[\0q\0~sq\0~\0Gwq\0~t\0\0t\0Codepagesq\0~\0`\0q\0~sq\0~\0Vq\0~t\0\0t\0\nCountrykeysq\0~\0e\0q\0~sq\0~\0Bk`q\0~t\0\0t\0Responsiblessq\0~\0j\0q\0~sq\0~\0j/q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~xt\0FormalParameterssq\0~2\0q\0~sq\0~\0aq\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nDataFieldssq\0~P\0q\0~sq\0~\0$q\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.DataFieldI3.~\0\0xq\0~\0t\0	DataFieldsq\0~\0y3q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0;cq\0~t\0statuspq\0~\0sq\0~\0\0q\0~\0sq\0~\0+@dq\0~t\0\0pt\0IsArraysq\0~\0\0q\0~sq\0~\0pEq\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0t\0TRUEt\0FALSExt\0DataTypesr\0(org.enhydra.shark.xpdl.elements.DataType\'4sM\0\0xq\0~\0q\0~sq\0~\0!b!q\0~t\0\0sq\0~\0w\0\0\0t\0	DataTypessr\0)org.enhydra.shark.xpdl.elements.DataTypespcH,!\0Z\0\risInitializedxq\0~-q\0~sq\0~\0|q\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sr\0)org.enhydra.shark.xpdl.elements.BasicType)w1\0\0xq\0~\0t\0	BasicTypesq\0~\05#tq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0b<THq\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0t\0STRINGt\0FLOATt\0INTEGERt\0	REFERENCEt\0DATETIMEt\0BOOLEANt\0	PERFORMERxxsq\0~\0E\0\0\0w\0\0\0q\0~xsr\0,org.enhydra.shark.xpdl.elements.DeclaredTypedR.\\^9\0\0xq\0~\0t\0DeclaredTypesq\0~\0RcMq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0*q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsr\0*org.enhydra.shark.xpdl.elements.SchemaType&1oSH\0\0xq\0~\0t\0\nSchemaTypesq\0~\07q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\07O]q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0{InDq\0~ t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0s3aq\0~ t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0ǹq\0~ t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~%q\0~(q\0~+xsr\0*org.enhydra.shark.xpdl.elements.RecordType%K\0\0\0xq\0~\0kt\0\nRecordTypesq\0~\0<rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.UnionType5PG\0\0xq\0~\0kt\0	UnionTypesq\0~\07Lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0/org.enhydra.shark.xpdl.elements.EnumerationTypef3b\0\0xq\0~\0kt\0EnumerationTypesq\0~\0_bq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.ArrayTypeg$\0N@\0\0xq\0~\0t\0	ArrayTypesq\0~\0pBHq\0~t\0\0sq\0~\0w\0\0\0t\0\nLowerIndexsq\0~\0q\0~Jsq\0~\0 q\0~Et\0\0pt\0\nUpperIndexsq\0~\0q\0~Nsq\0~\0\rq\0~Et\0\0pq\0~sq\0~q\0~sq\0~\0SJtCq\0~Et\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~Kq\0~Oq\0~Rxsr\0(org.enhydra.shark.xpdl.elements.ListType\"ӟ\n\0\0xq\0~\0t\0ListTypesq\0~\01	q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~q\0~sq\0~\0Y㞙q\0~Wt\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~\\xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesr\0,org.enhydra.shark.xpdl.elements.InitialValuej,zR\0\0xq\0~\0#\0q\0~asq\0~\0-Yq\0~t\0\0t\0Lengthsr\0&org.enhydra.shark.xpdl.elements.LengthMW+-̩W\0\0xq\0~\0#\0q\0~fsq\0~\0-q\0~t\0\0t\0Descriptionsq\0~\02\0q\0~ksq\0~\0qKJq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~osq\0~\04eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~cq\0~hq\0~lq\0~pxsq\0~t\0	DataFieldsq\0~\0\'q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Y\0{q\0~vt\0usernamepq\0~\0sq\0~\0\0q\0~\0sq\0~\0V8Rq\0~vt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0fq\0~vt\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xt\0DataTypesq\0~q\0~sq\0~\0XGq\0~vt\0\0sq\0~\0w\0\0\0q\0~sq\0~q\0~sq\0~\0T!q\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~t\0	BasicTypesq\0~\0w@q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0.hq\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~	q\0~\nq\0~q\0~q\0~\rxxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0DeclaredTypesq\0~\0gEnq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0vhq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\nSchemaTypesq\0~\0fiD|q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0ؤq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0C)q\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0{q\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0)^bq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~/t\0\nRecordTypesq\0~\0Kg\rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0	UnionTypesq\0~\0-,`q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~=t\0EnumerationTypesq\0~\0uq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Dt\0	ArrayTypesq\0~\068q\0~t\0\0sq\0~\0w\0\0\0q\0~Jsq\0~\0q\0~Jsq\0~\0@Rq\0~t\0\0pq\0~Nsq\0~\0q\0~Nsq\0~\0;zq\0~t\0\0pq\0~sq\0~q\0~sq\0~\0Zq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~Vt\0ListTypesq\0~\0$%q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~q\0~sq\0~\0>\Z܂q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesq\0~b\0q\0~sq\0~\0Qq\0~vt\0\0t\0Lengthsq\0~g\0q\0~sq\0~\0%q\0~vt\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0x8q\0~vt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0.q\0~vt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~{q\0~~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0Participantssq\0~\0\0q\0~sq\0~\0Uw8q\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Applicationssq\0~\0q\0~sq\0~\0<q\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ActivitySetssr\0,org.enhydra.shark.xpdl.elements.ActivitySetsqV[4\0\0xq\0~\0k\0q\0~\0sq\0~\0_q\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nActivitiessr\0*org.enhydra.shark.xpdl.elements.Activities&G^lP\0\0xq\0~\0k\0q\0~sq\0~\05ޮq\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0(org.enhydra.shark.xpdl.elements.Activityt45\Z9\0\0xq\0~\0t\0Activitysq\0~\0 q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{Bq\0~t\0	activity1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0bkq\0~t\0Approve Registrationpt\0Descriptionsq\0~\02\0q\0~\Zsq\0~\0|2q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0q\0~t\0\0q\0~\0sr\0-org.enhydra.shark.xpdl.elements.ActivityTypeseŽ{\0\0xq\0~-q\0~\0sq\0~\0w|q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0%org.enhydra.shark.xpdl.elements.Route0e\rG\0\0xq\0~\0t\0Routesq\0~\0H&\'q\0~#t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0.org.enhydra.shark.xpdl.elements.Implementationr^%\0\0xq\0~\0t\0Implementationsq\0~\0!BdQq\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sr\03org.enhydra.shark.xpdl.elements.ImplementationTypes\rT١9\0\0xq\0~-q\0~\0sq\0~\0zP\"q\0~/t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0\"org.enhydra.shark.xpdl.elements.No{.\0\0xq\0~\0t\0Nosq\0~\0kTq\0~5t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0%org.enhydra.shark.xpdl.elements.ToolsCg\0\0xq\0~\0k\0t\0Toolssq\0~\0q\0~5t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0\'org.enhydra.shark.xpdl.elements.SubFlow;Os7:$\0\0xq\0~\0t\0SubFlowsq\0~\0 m|q\0~5t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\0Qq\0~Ht\0\0pt\0	Executionsq\0~\0\0q\0~Psq\0~\0.FSq\0~Hq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ASYNCHRt\0SYNCHRxt\0ActualParameterssr\00org.enhydra.shark.xpdl.elements.ActualParameters_K\0\0xq\0~\0k\0q\0~Vsq\0~\0kKzq\0~Ht\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Qq\0~Xxxq\0~:xsq\0~\0E\0\0\0w\0\0\0q\0~5xsr\0-org.enhydra.shark.xpdl.elements.BlockActivityqcF\0\0xq\0~\0t\0\rBlockActivitysq\0~\0xq\0~#t\0\0sq\0~\0w\0\0\0t\0BlockIdsq\0~\0q\0~esq\0~\0\Z߈q\0~`t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~fxxq\0~/t\0	Performersr\0)org.enhydra.shark.xpdl.elements.Performer\"1%\0\0xq\0~\0#\0q\0~jsq\0~\0X4q\0~t\0approvert\0	StartModesr\0)org.enhydra.shark.xpdl.elements.StartModenhS\0\0xq\0~\0\0q\0~osq\0~\0@|q\0~t\0\0sq\0~\0w\0\0\0t\0Modesr\00org.enhydra.shark.xpdl.elements.StartFinishModes~6zX\'\0\0xq\0~-\0q\0~usq\0~\0cf˯q\0~qt\0\0sq\0~\0E\0\0\0w\0\0\0sr\0,org.enhydra.shark.xpdl.XMLEmptyChoiceElement2;3_\0\0xq\0~\0\0t\0XMLEmptyChoiceElementsq\0~\0o(q\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.Automatict?_\0\0xq\0~\0t\0	Automaticsq\0~\03]%q\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0&org.enhydra.shark.xpdl.elements.Manualv[ؤ\0\0xq\0~\0t\0Manualsq\0~\0Dq\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~|xsq\0~\0E\0\0\0w\0\0\0q\0~wxt\0\nFinishModesr\0*org.enhydra.shark.xpdl.elements.FinishMode{\0\0xq\0~\0\0q\0~sq\0~\0V%q\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0e}=q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0JHq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0A*q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Y6UYq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0KW`q\0~t\0\0t\0	Deadlinessr\0)org.enhydra.shark.xpdl.elements.Deadlines>ɜ\0\0xq\0~\0k\0q\0~sq\0~\0Dq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsr\05org.enhydra.shark.xpdl.elements.SimulationInformation\"|I\0\0xq\0~\0\0q\0~sq\0~\0dP/q\0~t\0\0sq\0~\0w\0\0\0t\0\rInstantiationsq\0~\0\0q\0~sq\0~\0\'2q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ONCEt\0MULTIPLExt\0Costsr\0$org.enhydra.shark.xpdl.elements.Cost\0\0xq\0~\0#q\0~sq\0~\0N.!q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0Eq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0 Qoq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0iq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\09Aq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsr\0$org.enhydra.shark.xpdl.elements.IconTU(}6\0\0xq\0~\0#\0q\0~sq\0~\00Fq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0eq\0~t\0\0t\0TransitionRestrictionssr\06org.enhydra.shark.xpdl.elements.TransitionRestrictionsC)׀i;\0\0xq\0~\0k\0q\0~sq\0~\06tq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0#]q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\01org.enhydra.shark.xpdl.elements.ExtendedAttribute\\F\0\0xq\0~\0t\0ExtendedAttributesq\0~\0E|M1q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0A\"q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpt\0Valuesq\0~\0\0q\0~sq\0~\0Toq\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0u|Hq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Rٲq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0\rXq\0~t\0174,31.787506103515625pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~#q\0~lq\0~qq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0r\0q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Zj-q\0~t\0route1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\\q\0~t\0\0pt\0Descriptionsq\0~\02\0q\0~sq\0~\0CFq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0lq\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0\Z!q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0{q\0~!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\02:~q\0~!t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0#ʀq\0~+t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0\0q\0~0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0Mq\0~0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Gt\0SubFlowsq\0~\0>hq\0~0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0I(mq\0~@t\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0FHq\0~@q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~Ksq\0~\0fGq-q\0~@t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~Eq\0~Hq\0~Lxxq\0~4xsq\0~\0E\0\0\0w\0\0\0q\0~0xsq\0~_t\0\rBlockActivitysq\0~\0s;q\0~!t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0yMq\0~St\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Xxxq\0~%t\0	Performersq\0~k\0q\0~\\sq\0~\0M\"q\0~t\0approvert\0	StartModesq\0~p\0q\0~`sq\0~\0aq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0|m\nq\0~at\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0.q\0~et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0	#q\0~et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0CWhq\0~et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~ixsq\0~\0E\0\0\0w\0\0\0q\0~ext\0\nFinishModesq\0~\0q\0~|sq\0~\0	nq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0Ahq\0~}t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0jq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0P5-q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0~ھMq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0N]Hq\0~t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0t/ėq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0ttq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0 @q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\04sq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0>bq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0jq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0\nۼq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0-q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0Pzq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0M:q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0\Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\05org.enhydra.shark.xpdl.elements.TransitionRestrictionN}\0\0xq\0~\0t\0TransitionRestrictionsq\0~\0>q\0~t\0\0sq\0~\0w\0\0\0t\0Joinsr\0$org.enhydra.shark.xpdl.elements.Joinڕөx)5\0\0xq\0~\0\0q\0~sq\0~\06)q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ANDt\0XORxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Splitsr\0%org.enhydra.shark.xpdl.elements.Split~ѯWS\0\0xq\0~\0\0q\0~sq\0~\0Sq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0w>q\0~t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0TransitionRefssr\0.org.enhydra.shark.xpdl.elements.TransitionRefsъ\0\0xq\0~\0k\0q\0~sq\0~\0k}q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0-org.enhydra.shark.xpdl.elements.TransitionRef%-a\0\0xq\0~\0t\0\rTransitionRefsq\0~\0%@7q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0pЌq\0~t\0transition2pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rTransitionRefsq\0~\0Iq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0C^Bq\0~t\0transition3pxsq\0~\0E\0\0\0w\0\0\0q\0~xxxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0޺q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\04q\0~\rt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0uUUq\0~\rt\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0bOqq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\09+q\0~t\0328,37.225006103515625pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~!xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~\Zq\0~q\0~!q\0~]q\0~aq\0~}q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0a:q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Cxcq\0~&t\0tool2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0@q\0~&t\0Send Rejection Emailpt\0Descriptionsq\0~\02\0q\0~1sq\0~\0YJlq\0~&t\0\0t\0Limitsq\0~\0q\0~5sq\0~\0<9q\0~&t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0|)q\0~&t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\00Cq\0~9t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0cq\0~9t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0sq\0~Ct\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0+:<q\0~Ht\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0q\0~Ht\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0$org.enhydra.shark.xpdl.elements.Tool\\6&+G\0\0xq\0~\0t\0Toolsq\0~\0R\'q\0~Rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~Yt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0wuq\0~Yq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0APPLICATIONt\0	PROCEDURExt\0ActualParameterssq\0~W\0q\0~fsq\0~\0qxy9q\0~Yt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~lsq\0~\0hVCq\0~Yt\0\0t\0ExtendedAttributessq\0~\0\0q\0~psq\0~\0+Ôq\0~Yt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~^q\0~aq\0~gq\0~mq\0~qxxsq\0~Gt\0SubFlowsq\0~\0sDq\0~Ht\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0;NHq\0~wt\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0A/q\0~wq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~sq\0~\0ONq\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~|q\0~q\0~xxq\0~Rxsq\0~\0E\0\0\0w\0\0\0q\0~Hxsq\0~_t\0\rBlockActivitysq\0~\06q\0~9t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0}Q^q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~Ct\0	Performersq\0~k\0q\0~sq\0~\0M q\0~&t\0approvert\0	StartModesq\0~p\0q\0~sq\0~\0wq\0~&t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0LKq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0umȴq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0b#`\Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0,$q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0	sq\0~&t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\02q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0g\"q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0ybq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0|q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0zq\0~&t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0mq\0~&t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0|i:q\0~&t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0bq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0FMq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0=q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0	Cq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0Eq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0\'q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\05q\0~&t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0u}q\0~&t\0\0t\0TransitionRestrictionssq\0~\0q\0~\0sq\0~\0F@q\0~&t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0||q\0~&t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0J7/q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0mKq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0C<vq\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0:q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Iq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0|q\0~t\0525,117.01251220703125pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~ xxpxsq\0~\0E\0\0\0w\0\0\0q\0~+q\0~.q\0~2q\0~6q\0~9q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0_q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Jq\0~%t\0tool3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0YHq\0~%t\0Send User Registration Emailpt\0Descriptionsq\0~\02\0q\0~0sq\0~\0hq\0~%t\0\0t\0Limitsq\0~\0q\0~4sq\0~\0\"7q\0~%t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0*q\0~%t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0jr[q\0~8t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0\0muq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0\ZT?q\0~Bt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0<5~cq\0~Gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0j+q\0~Gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Xt\0Toolsq\0~\0)iEkq\0~Qt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Àq\0~Wt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\00q\0~Wq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~dq\0~ext\0ActualParameterssq\0~W\0q\0~bsq\0~\0,q\0~Wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~hsq\0~\0ڵq\0~Wt\0\0t\0ExtendedAttributessq\0~\0\0q\0~lsq\0~\0u{lq\0~Wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\\q\0~_q\0~cq\0~iq\0~mxxsq\0~Gt\0SubFlowsq\0~\0\"q\0~Gt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0<y[q\0~st\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0+(q\0~sq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~~sq\0~\0Xqq\0~st\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~xq\0~{q\0~xxq\0~Qxsq\0~\0E\0\0\0w\0\0\0q\0~Gxsq\0~_t\0\rBlockActivitysq\0~\0q\0~8t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0fqq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~Bt\0	Performersq\0~k\0q\0~sq\0~\0\n[q\0~%t\0approvert\0	StartModesq\0~p\0q\0~sq\0~\0W~Sq\0~%t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0Kj{q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0(pSq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0(xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0!18q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0s1q\0~%t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0@q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0eIq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0|A\nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0CJq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0^wq\0~%t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0^fq\0~%t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0p}q\0~%t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0d]8q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\09q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0T~q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0J۴q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0l,qq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0\"=.q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0q\0~%t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0\neҚq\0~%t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0Ia+q\0~%t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0^q\0~%t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0jq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\06&Gq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0\"Nq\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~xsq\0~t\0ExtendedAttributesq\0~\0^yq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0[Nq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0TQlq\0~t\0670,27pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~*q\0~-q\0~1q\0~5q\0~8q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\03{pq\0~!t\0	activity2pq\0~\0sq\0~\0\0q\0~\0sq\0~\00|q\0~!t\0Create Userpt\0Descriptionsq\0~\02\0q\0~,sq\0~\0:eq\0~!t\0\0t\0Limitsq\0~\0q\0~0sq\0~\0Lѷaq\0~!t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0~q\0~!t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0l(#q\0~4t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0Sq\0~4t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\0PEvq\0~>t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0/	q\0~Ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0Xq\0~Ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~Gt\0SubFlowsq\0~\0a\0;q\0~Ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Yq\0~St\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0|m)7q\0~Sq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~^sq\0~\0t4Mq\0~St\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~Xq\0~[q\0~_xxq\0~Gxsq\0~\0E\0\0\0w\0\0\0q\0~Cxsq\0~_t\0\rBlockActivitysq\0~\0ډq\0~4t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0Zs,q\0~ft\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~kxxq\0~>t\0	Performersq\0~k\0q\0~osq\0~\0Otq\0~!t\0approvert\0	StartModesq\0~p\0q\0~ssq\0~\0q\0~!t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0\\J=uq\0~tt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0e_q\0~xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0}2q\0~xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0?1q\0~xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~|xsq\0~\0E\0\0\0w\0\0\0q\0~xxt\0\nFinishModesq\0~\0q\0~sq\0~\0/q\0~!t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0q2q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0BMSBq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0@Eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0q`nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0-q\0~!t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0zyq\0~!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0xj~q\0~!t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Bq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0DwIq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0@q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0=B_q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0*Sq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0Q$}q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0%1q\0~!t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0Rͳq\0~!t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0\"x?q\0~!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0\Z9/q\0~!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0Mq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Clq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0f.Bq\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\08^q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\00q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0~)Rq\0~t\0522,24.57501220703125pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~&q\0~)q\0~-q\0~1q\0~4q\0~pq\0~tq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0Pq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0&jDq\0~t\0tool4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0R׉q\0~t\0\ZEmail Request For Approvalpt\0Descriptionsq\0~\02\0q\0~sq\0~\0rʏq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0}lq\0~t\0\0q\0~\0sq\0~\"q\0~\0sq\0~\0\rTq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\'t\0Routesq\0~\0cUݣq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~.t\0Implementationsq\0~\0E\nhq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~4q\0~\0sq\0~\07W q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~9t\0Nosq\0~\0(̂aq\0~#t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~@\0t\0Toolssq\0~\0e9q\0~#t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Xt\0Toolsq\0~\0\Zw1Hq\0~-t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0.Kq\0~3t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0q5Req\0~3q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~dq\0~ext\0ActualParameterssq\0~W\0q\0~>sq\0~\0i]q\0~3t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~Dsq\0~\0V*q\0~3t\0\0t\0ExtendedAttributessq\0~\0\0q\0~Hsq\0~\0ut	q\0~3t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~8q\0~;q\0~?q\0~Eq\0~Ixxsq\0~Gt\0SubFlowsq\0~\0P(q\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0]q\0~Ot\0\0pq\0~Psq\0~\0\0q\0~Psq\0~\0\\q\0~Oq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Tq\0~Uxt\0ActualParameterssq\0~W\0q\0~Zsq\0~\0v0q\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~Wq\0~[xxq\0~-xsq\0~\0E\0\0\0w\0\0\0q\0~#xsq\0~_t\0\rBlockActivitysq\0~\0o3$q\0~t\0\0sq\0~\0w\0\0\0q\0~esq\0~\0q\0~esq\0~\0D.q\0~bt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~gxxq\0~t\0	Performersq\0~k\0q\0~ksq\0~\09I}q\0~t\0	requestert\0	StartModesq\0~p\0q\0~osq\0~\09u*q\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0Og!q\0~pt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0ObEq\0~tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0nV.q\0~tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\083q\0~tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~txt\0\nFinishModesq\0~\0q\0~sq\0~\0HAq\0~t\0\0sq\0~\0w\0\0\0q\0~usq\0~v\0q\0~usq\0~\0q|%q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~{\0t\0XMLEmptyChoiceElementsq\0~\0Pfq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0wq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0~fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0\\8q\0~t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0kq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0Yq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\08Ncq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0JXq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0Gq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0?Q8q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0\rΧq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\0q\0~sq\0~\0m\Zq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0>32q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0Kpq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\03lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0i\'q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0mPw\rq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0|q\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\06\Zq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0)Eq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0GK)q\0~t\0171,26.987503051757812pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	q\0~\rq\0~q\0~q\0~lq\0~pq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0Transitionssr\0+org.enhydra.shark.xpdl.elements.Transitions9>/i\0\0xq\0~\0k\0q\0~sq\0~\0q\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0*org.enhydra.shark.xpdl.elements.Transitiontx\0\0xq\0~\0t\0\nTransitionsq\0~\0l73q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\'qq\0~	t\0transition1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0+@q\0~	t\0\0pt\0Fromsq\0~\0q\0~	sq\0~\0[nq\0~	t\0	activity1pt\0Tosq\0~\0q\0~	sq\0~\0=,gq\0~	t\0route1pt\0	Conditionsr\0)org.enhydra.shark.xpdl.elements.ConditionDZ;|\0\0xq\0~\0\0q\0~	sq\0~\0^vq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0plq\0~	\Zq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0	CONDITIONt\0	OTHERWISEt\0	EXCEPTIONt\0DEFAULTEXCEPTIONxxsq\0~\0E\0\0\0w\0\0\0q\0~	xt\0Descriptionsq\0~\02\0q\0~	&sq\0~\0.9Aq\0~	t\0\0t\0ExtendedAttributessq\0~\0\0q\0~	*sq\0~\07[.q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0^֬[q\0~	+t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0)Hq\0~	0t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0[zq\0~	0t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~	5q\0~	8xxpxsq\0~\0E\0\0\0w\0\0\0q\0~	\nq\0~	\rq\0~	q\0~	q\0~	\Zq\0~	\'q\0~	+xsq\0~	t\0\nTransitionsq\0~\0Sq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\00z,q\0~	=t\0transition2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0^3q\0~	=t\0\0pq\0~	sq\0~\0q\0~	sq\0~\08>mq\0~	=t\0route1pq\0~	sq\0~\0q\0~	sq\0~\0^q\0~	=t\0	activity2pt\0	Conditionsq\0~	\0q\0~	Nsq\0~\0X\"q\0~	=t\0status === \'Approved\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0ggq\0~	Ot\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~	!q\0~	\"q\0~	#q\0~	$xxsq\0~\0E\0\0\0w\0\0\0q\0~	Sxt\0Descriptionsq\0~\02\0q\0~	Xsq\0~\0nxq\0~	=t\0\0t\0ExtendedAttributessq\0~\0\0q\0~	\\sq\0~\0q\0~	=t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0!Dq\0~	]t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\\q\0~	bt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0R.q\0~	bt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~	gq\0~	jxsq\0~t\0ExtendedAttributesq\0~\0^\nCq\0~	]t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0kqq\0~	nt\0PBUILDER_TRANSITION_CONDITIONSpq\0~sq\0~\0\0q\0~sq\0~\0%Tq\0~	nt\0G[{\"join\":\"&&\",\"variable\":\"status\",\"operator\":\"===\",\"value\":\"Approved\"}]pxsq\0~\0E\0\0\0w\0\0\0q\0~	sq\0~	vxxpxsq\0~\0E\0\0\0w\0\0\0q\0~	Bq\0~	Eq\0~	Hq\0~	Kq\0~	Oq\0~	Yq\0~	]xsq\0~	t\0\nTransitionsq\0~\0sq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0`&wq\0~	{t\0transition3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0usaq\0~	{t\0Rejectedpq\0~	sq\0~\0q\0~	sq\0~\0{Jq\0~	{t\0route1pq\0~	sq\0~\0q\0~	sq\0~\0Zq\0~	{t\0tool2pt\0	Conditionsq\0~	\0q\0~	sq\0~\0jJq\0~	{t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0?2Jq\0~	t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~	!q\0~	\"q\0~	#q\0~	$xxsq\0~\0E\0\0\0w\0\0\0q\0~	xt\0Descriptionsq\0~\02\0q\0~	sq\0~\0p?sq\0~	{t\0\0t\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\0^1nq\0~	{t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0`saq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0aJ\\q\0~	t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0*[q\0~	t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xxpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	q\0~	q\0~	xsq\0~	t\0\nTransitionsq\0~\0#=eoq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0fq\0~	t\0transition4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0|R2q\0~	t\0\0pq\0~	sq\0~\0q\0~	sq\0~\0X;5q\0~	t\0	activity2pq\0~	sq\0~\0q\0~	sq\0~\0nq\0~	t\0tool3pt\0	Conditionsq\0~	\0q\0~	sq\0~\046q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\05Aq\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~	!q\0~	\"q\0~	#q\0~	$xxsq\0~\0E\0\0\0w\0\0\0q\0~	xt\0Descriptionsq\0~\02\0q\0~	sq\0~\06*q\0~	t\0\0t\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\0[q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0	j$q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0sq\0~	t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\01 q\0~	t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xxpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	q\0~	q\0~	xsq\0~	t\0\nTransitionsq\0~\03Cq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{|q\0~	t\0transition5pq\0~\0sq\0~\0\0q\0~\0sq\0~\0,q\0~	t\0\0pq\0~	sq\0~\0q\0~	sq\0~\09d9Vq\0~	t\0tool4pq\0~	sq\0~\0q\0~	sq\0~\0Mhbq\0~	t\0	activity1pt\0	Conditionsq\0~	\0q\0~	sq\0~\0a(q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0y\\\nq\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~	!q\0~	\"q\0~	#q\0~	$xxsq\0~\0E\0\0\0w\0\0\0q\0~	xt\0Descriptionsq\0~\02\0q\0~	sq\0~\07;q\0~	t\0\0t\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\0KPIq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0$\0pq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0eqq\0~\nt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\08R7q\0~\nt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\n\nxxpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	q\0~	q\0~	xxt\0ExtendedAttributessq\0~\0\0q\0~\nsq\0~\0[q\0~^t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0.\\q\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0+S*q\0~\nt\0%JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDERpq\0~sq\0~\0\0q\0~sq\0~\0Oq\0~\nt\0requester;approverpxsq\0~\0E\0\0\0w\0\0\0q\0~\n\Zq\0~\nxsq\0~t\0ExtendedAttributesq\0~\0PMq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0%Dq\0~\n!t\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0*	q\0~\n!t\0JaWE_GRAPH_PARTICIPANT_ID=approver,CONNECTING_ACTIVITY_ID=tool2,X_OFFSET=706,Y_OFFSET=130,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\n&q\0~\n)xsq\0~t\0ExtendedAttributesq\0~\0A\'Mbq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Zn3q\0~\n-t\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0mgq\0~\n-t\0JaWE_GRAPH_PARTICIPANT_ID=approver,CONNECTING_ACTIVITY_ID=tool3,X_OFFSET=836,Y_OFFSET=39,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\n2q\0~\n5xsq\0~t\0ExtendedAttributesq\0~\07+gq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Lq\0~\n9t\0JaWE_GRAPH_START_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0mq\0~\n9t\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=tool4,X_OFFSET=101,Y_OFFSET=41,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\n>q\0~\nAxxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~cq\0~fq\0~jq\0~qq\0~q\0~q\0~q\0~q\0~q\0~q\0~	q\0~q\0~\nxxt\0ExtendedAttributessq\0~\0\0q\0~\nFsq\0~\0>E[xq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0\rŕq\0~\nGt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0r۽q\0~\nLt\0EDITING_TOOLpq\0~sq\0~\0\0q\0~sq\0~\0\"*6:q\0~\nLt\0Web Workflow Designerpxsq\0~\0E\0\0\0w\0\0\0q\0~\nQq\0~\nTxsq\0~t\0ExtendedAttributesq\0~\0LjMq\0~\nGt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0/$q\0~\nXt\0EDITING_TOOL_VERSIONpq\0~sq\0~\0\0q\0~sq\0~\0\0;q\0~\nXt\0\r5.0-pre-alphapxsq\0~\0E\0\0\0w\0\0\0q\0~\n]q\0~\n`xxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~\0q\0~\0q\0~\0q\0~\0Iq\0~\0tq\0~\0q\0~\0q\0~\0q\0~\0q\0~q\0~Qq\0~Xq\0~\nGx\0sq\0~\0w\0\0\0\0xt\01sr\0*org.enhydra.shark.xpdl.elements.Namespaces|<.R\0\0xq\0~\0kt\0\nNamespacessq\0~\0:q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.Namespacez_\0\0xq\0~\0t\0	Namespacesq\0~\0zq\0~\nht\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Rq\0~\not\0xpdlpq\0~\0sq\0~\0q\0~\0sq\0~\0SEq\0~\not\0 http://www.wfmc.org/2002/XPDL1.0pxsq\0~\0E\0\0\0w\0\0\0q\0~\ntq\0~\nwxx',1000206,2,1000207,0),
('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Package xmlns=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" Id=\"expenseclaim\" Name=\"v6 Expenses Claim\" xsi:schemaLocation=\"http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">\n    <PackageHeader>\n        <XPDLVersion>1.0</XPDLVersion>\n        <Vendor/>\n        <Created/>\n    </PackageHeader>\n    <Script Type=\"text/javascript\"/>\n    <Participants>\n        <Participant Id=\"claimant\" Name=\"Claimant\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"approver\" Name=\"Approver\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"finance\" Name=\"Finance\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n    </Participants>\n    <Applications>\n        <Application Id=\"default_application\"/>\n    </Applications>\n    <WorkflowProcesses>\n        <WorkflowProcess Id=\"process1\" Name=\"Expense Approval Process\">\n            <ProcessHeader DurationUnit=\"h\"/>\n            <DataFields>\n                <DataField Id=\"status\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"SelectApprover\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n            </DataFields>\n            <Activities>\n                <Activity Id=\"approve_claim\" Name=\"HOD Approve\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Join Type=\"XOR\"/>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"271,11.26251220703125\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route1\">\n                    <Route/>\n                    <Performer>approver</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition10\"/>\n                                    <TransitionRef Id=\"transition14\"/>\n                                    <TransitionRef Id=\"transition16\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"468,15.024996948242176\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"verify_claim\" Name=\"Finance Verify\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>finance</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"finance\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"445,46.56248779296874\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route2\">\n                    <Route/>\n                    <Performer>finance</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition7\"/>\n                                    <TransitionRef Id=\"transition8\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"finance\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"622,50.37498779296874\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool1\" Name=\"Notify Claimant Finance Verified\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>finance</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"finance\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"754,45.58751220703124\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool2\" Name=\"Notify Claimant Finance Rejected\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>finance</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"finance\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"589,136.1625244140625\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool3\" Name=\"Notify Claimant Resubmit\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>claimant</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"claimant\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"432,33.62499923706055\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"new_claim\" Name=\"Claimant Edit\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>claimant</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"claimant\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"124,36.87499649804687\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool4\" Name=\"Update Status=Submitted\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"115.64773559570312,110.71590326953125\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"resubmit\" Name=\"Claimant Resubmit\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>claimant</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"claimant\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"259,34.66666825097656\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool5\" Name=\"Notify Approver\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"267,111.34090326953125\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool6\" Name=\"Notify Finance\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"445,111.87499140429688\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool7\" Name=\"Notify Claimant Rejected\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"697,14.962509155273438\"/>\n                    </ExtendedAttributes>\n                </Activity>\n            </Activities>\n            <Transitions>\n                <Transition From=\"approve_claim\" Id=\"transition1\" To=\"route1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"verify_claim\" Id=\"transition4\" To=\"route2\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition7\" Name=\"verified\" To=\"tool1\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition8\" To=\"tool2\">\n                    <Condition Type=\"CONDITION\">status===\'Rejected by Finance\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"new_claim\" Id=\"t_new_claim_tool4\" To=\"tool4\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"resubmit\" Id=\"t_resubmit_approve_claim\" To=\"approve_claim\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool4\" Id=\"transition11\" To=\"tool5\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool5\" Id=\"transition12\" To=\"approve_claim\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition10\" To=\"tool3\">\n                    <Condition Type=\"CONDITION\">status===\'Resubmit\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool3\" Id=\"transition13\" To=\"resubmit\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition14\" Name=\"approved\" To=\"tool6\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool6\" Id=\"transition15\" To=\"verify_claim\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition16\" To=\"tool7\">\n                    <Condition Type=\"CONDITION\">status===\'Rejected by HOD\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n            </Transitions>\n            <ExtendedAttributes>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER\" Value=\"claimant;approver;finance\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=finance,CONNECTING_ACTIVITY_ID=tool2,X_OFFSET=758,Y_OFFSET=145,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=finance,CONNECTING_ACTIVITY_ID=tool1,X_OFFSET=915,Y_OFFSET=57,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_START_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=claimant,CONNECTING_ACTIVITY_ID=new_claim,X_OFFSET=63,Y_OFFSET=53,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=approver,CONNECTING_ACTIVITY_ID=tool7,X_OFFSET=865,Y_OFFSET=28,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n            </ExtendedAttributes>\n        </WorkflowProcess>\n    </WorkflowProcesses>\n    <ExtendedAttributes>\n        <ExtendedAttribute Name=\"EDITING_TOOL\" Value=\"Web Workflow Designer\"/>\n        <ExtendedAttribute Name=\"EDITING_TOOL_VERSION\" Value=\"5.0-pre-alpha\"/>\n    </ExtendedAttributes>\n</Package>\n','\0sr\0\'org.enhydra.shark.xpdl.elements.Package~+Vmŀ~\0Z\0isTransientL\0extPkgRefsToIdst\0.Lorg/enhydra/shark/utilities/SequencedHashMap;L\0internalVersiont\0Ljava/lang/String;L\0\nnamespacest\0,Lorg/enhydra/shark/xpdl/elements/Namespaces;xr\0(org.enhydra.shark.xpdl.XMLComplexElement>(\0\0xr\05org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex2\0L\0\nelementMapq\0~\0L\0elementst\0Ljava/util/ArrayList;xr\0!org.enhydra.shark.xpdl.XMLElement#+B#\0Z\0\nisReadOnlyZ\0\nisRequiredL\0nameq\0~\0L\0originalElementHashCodet\0Ljava/lang/Integer;L\0parentt\0#Lorg/enhydra/shark/xpdl/XMLElement;L\0valueq\0~\0xpt\0Packagesr\0java.lang.Integer⠤8\0I\0valuexr\0java.lang.Number\0\0xp0Zpt\0\0sr\0,org.enhydra.shark.utilities.SequencedHashMap.\"\"&\0\0xpw\0\0\0\rt\0Idsr\0#org.enhydra.shark.xpdl.XMLAttribute#c݀M;\0L\0choicesq\0~\0xq\0~\0q\0~\0sq\0~\0$3q\0~\0\nt\0expenseclaimpt\0Namesq\0~\0\0q\0~\0sq\0~\0\Ziq\0~\0\nt\0v6 Expenses Claimpt\0\rPackageHeadersr\0-org.enhydra.shark.xpdl.elements.PackageHeaderv,\0\0xq\0~\0\0q\0~\0sq\0~\0Jq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0XPDLVersionsr\0+org.enhydra.shark.xpdl.elements.XPDLVersion\"}Y.w\0\0xr\0\'org.enhydra.shark.xpdl.XMLSimpleElementm\0\0xq\0~\0q\0~\0!sq\0~\0pOq\0~\0t\01.0t\0Vendorsr\0&org.enhydra.shark.xpdl.elements.Vendor tE:\0\0xq\0~\0#q\0~\0\'sq\0~\0BFq\0~\0t\0\0t\0Createdsr\0\'org.enhydra.shark.xpdl.elements.CreatedzdK|[\0\0xq\0~\0#q\0~\0,sq\0~\0Uqq\0~\0t\0\0t\0Descriptionsr\0+org.enhydra.shark.xpdl.elements.Description۰738\0\0xq\0~\0#\0q\0~\01sq\0~\0P\'q\0~\0t\0\0t\0\rDocumentationsr\0-org.enhydra.shark.xpdl.elements.Documentation`9y\0\0xq\0~\0#\0q\0~\06sq\0~\0_Mq\0~\0t\0\0t\0PriorityUnitsr\0,org.enhydra.shark.xpdl.elements.PriorityUnit\0\0xq\0~\0#\0q\0~\0;sq\0~\0)ަq\0~\0t\0\0t\0CostUnitsr\0(org.enhydra.shark.xpdl.elements.CostUnit܎=H\0\0xq\0~\0#\0q\0~\0@sq\0~\0*q\0~\0t\0\0xsr\0java.util.ArrayListxa\0I\0sizexp\0\0\0w\0\0\0q\0~\0$q\0~\0)q\0~\0.q\0~\03q\0~\08q\0~\0=q\0~\0Bxt\0RedefinableHeadersr\01org.enhydra.shark.xpdl.elements.RedefinableHeaderMϪ\'H\0\0xq\0~\0\0q\0~\0Gsq\0~\0>hq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0PublicationStatussq\0~\0\0q\0~\0Msq\0~\0\'\nFq\0~\0It\0\0sq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0UNDER_REVISIONt\0RELEASEDt\0\nUNDER_TESTxt\0Authorsr\0&org.enhydra.shark.xpdl.elements.Author5fᧆ\0\0xq\0~\0#\0q\0~\0Usq\0~\0{?q\0~\0It\0\0t\0Versionsr\0\'org.enhydra.shark.xpdl.elements.Version9=3~JQ\0\0xq\0~\0#\0q\0~\0Zsq\0~\0*@q\0~\0It\0\0t\0Codepagesr\0(org.enhydra.shark.xpdl.elements.Codepage9$me\rG\0\0xq\0~\0#\0q\0~\0_sq\0~\0	yq\0~\0It\0\0t\0\nCountrykeysr\0*org.enhydra.shark.xpdl.elements.Countrykey.\0\0xq\0~\0#\0q\0~\0dsq\0~\0jq\0~\0It\0\0t\0Responsiblessr\0,org.enhydra.shark.xpdl.elements.Responsibles${S\0\0xr\0$org.enhydra.shark.xpdl.XMLCollectionjċm\0\0xq\0~\0\0q\0~\0isq\0~\0oljq\0~\0It\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0Nq\0~\0Wq\0~\0\\q\0~\0aq\0~\0fq\0~\0lxt\0ConformanceClasssr\00org.enhydra.shark.xpdl.elements.ConformanceClassy0|k\0\0xq\0~\0\0q\0~\0rsq\0~\0B\":^q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0GraphConformancesq\0~\0\0q\0~\0xsq\0~\07q\0~\0tq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0FULL_BLOCKEDt\0LOOP_BLOCKEDt\0NON_BLOCKEDxxsq\0~\0E\0\0\0w\0\0\0q\0~\0yxt\0Scriptsr\0&org.enhydra.shark.xpdl.elements.ScriptQjS8\0\0xq\0~\0\0q\0~\0sq\0~\0*Oq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0Typesq\0~\0q\0~\0sq\0~\0~q\0~\0t\0text/javascriptpt\0Versionsq\0~\0\0q\0~\0sq\0~\0-,7q\0~\0t\0\0pt\0Grammarsq\0~\0\0q\0~\0sq\0~\0RDq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExternalPackagessr\00org.enhydra.shark.xpdl.elements.ExternalPackagesw\"+Ũ\0\0xq\0~\0k\0q\0~\0sq\0~\0SSyq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0TypeDeclarationssr\00org.enhydra.shark.xpdl.elements.TypeDeclarations\rOx5\0\0xq\0~\0k\0q\0~\0sq\0~\0Uqq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Participantssr\0,org.enhydra.shark.xpdl.elements.Participantsh`g8J\0\0xq\0~\0k\0q\0~\0sq\0~\0<q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Participanto$rc\0\0xr\0+org.enhydra.shark.xpdl.XMLCollectionElementCxvr\0\0xq\0~\0t\0Participantsq\0~\0q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0$|q\0~\0t\0claimantpq\0~\0sq\0~\0\0q\0~\0sq\0~\07;q\0~\0t\0Claimantpt\0ParticipantTypesr\0/org.enhydra.shark.xpdl.elements.ParticipantType>n݅\0\0xq\0~\0q\0~\0sq\0~\0}q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\'sOq\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0t\0RESOURCE_SETt\0RESOURCEt\0ROLEt\0ORGANIZATIONAL_UNITt\0HUMANt\0SYSTEMxxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\00q\0~\0t\0\0t\0ExternalReferencesr\01org.enhydra.shark.xpdl.elements.ExternalReferencebQ\0\0xq\0~\0\0q\0~\0sq\0~\0{\0vq\0~\0t\0\0sq\0~\0w\0\0\0t\0xrefsq\0~\0\0q\0~\0sq\0~\0)q\0~\0t\0\0pt\0locationsq\0~\0q\0~\0sq\0~\0~q\0~\0t\0\0pt\0	namespacesq\0~\0\0q\0~\0sq\0~\0eyq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExtendedAttributessr\02org.enhydra.shark.xpdl.elements.ExtendedAttributesOUF\0L\0extAttribsStringq\0~\0xq\0~\0k\0q\0~\0sq\0~\0Yq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xsq\0~\0t\0Participantsq\0~\0<ŗq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0_,q\0~\0t\0approverpq\0~\0sq\0~\0\0q\0~\0sq\0~\0\'q\0~\0t\0Approverpt\0ParticipantTypesq\0~\0q\0~\0sq\0~\0\'%q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0~(t	q\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0nBq\0~\0t\0\0t\0ExternalReferencesq\0~\0\0q\0~\0sq\0~\0y*q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\rߏ|q\0~\0t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\00j*q\0~\0t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Hq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~	xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0.q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~xsq\0~\0t\0Participantsq\0~\0>}q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\02)q\0~t\0financepq\0~\0sq\0~\0\0q\0~\0sq\0~\0Jvjq\0~t\0Financept\0ParticipantTypesq\0~\0q\0~sq\0~\0C:q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\nq\0~ t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~$xt\0Descriptionsq\0~\02\0q\0~)sq\0~\0FGGXq\0~t\0\0t\0ExternalReferencesq\0~\0\0q\0~-sq\0~\0;w5]q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\'Q !q\0~.t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0bSdq\0~.t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~.t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~2q\0~5q\0~8xt\0ExtendedAttributessq\0~\0\0q\0~<sq\0~\0^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~ q\0~*q\0~.q\0~=xxt\0Applicationssr\0,org.enhydra.shark.xpdl.elements.Applications\0\0xq\0~\0k\0q\0~Csq\0~\0\rRq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Applicationv	RS\0\0xq\0~\0t\0Applicationsq\0~\0Jq\0~Et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0zrq\0~Kt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\09Aq\0~Kt\0\0pt\0Descriptionsq\0~\02\0q\0~Vsq\0~\0*tq\0~Kt\0\0t\0Choicesr\00org.enhydra.shark.xpdl.elements.ApplicationTypes?!\0\0xr\0\'org.enhydra.shark.xpdl.XMLComplexChoice|\"\0L\0choicesq\0~\0L\0choosenq\0~\0	xq\0~\0q\0~Zsq\0~\0q\0~Kt\0\0sq\0~\0E\0\0\0w\0\0\0sr\00org.enhydra.shark.xpdl.elements.FormalParameterspBÁZ\0\0xq\0~\0k\0t\0FormalParameterssq\0~\0\r]Jq\0~]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0\0t\0ExternalReferencesq\0~\0Yǅq\0~]t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0S}v6q\0~ht\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0zq\0~ht\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0dj)q\0~ht\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~mq\0~pq\0~sxxq\0~bt\0ExtendedAttributessq\0~\0\0q\0~wsq\0~\0q\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Pq\0~Sq\0~Wq\0~]q\0~xxxt\0\nDataFieldssr\0*org.enhydra.shark.xpdl.elements.DataFieldsʦU\0\0xq\0~\0k\0q\0~~sq\0~\0C:q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0WorkflowProcessessr\01org.enhydra.shark.xpdl.elements.WorkflowProcessesp_0,\0\0xq\0~\0k\0q\0~sq\0~\0uq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0/org.enhydra.shark.xpdl.elements.WorkflowProcess%v0L\0\0xq\0~\0t\0WorkflowProcesssq\0~\0\\q\0~t\0\0sq\0~\0w\0\0\0\rq\0~\0sq\0~\0q\0~\0sq\0~\0tRdq\0~t\0process1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0(q\0~t\0Expense Approval Processpt\0AccessLevelsq\0~\0\0q\0~sq\0~\0O\nU:q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0PUBLICt\0PRIVATExt\0\rProcessHeadersr\0-org.enhydra.shark.xpdl.elements.ProcessHeaderLC-)\0\0xq\0~\0q\0~sq\0~\0/*q\0~t\0\0sq\0~\0w\0\0\0t\0DurationUnitsq\0~\0\0q\0~sq\0~\0\nX q\0~t\0hsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0Yt\0Mt\0Dt\0ht\0mt\0sxt\0Createdsq\0~\0-\0q\0~sq\0~\0?նq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0\"5q\0~t\0\0t\0Prioritysr\0(org.enhydra.shark.xpdl.elements.Priority`Nn>b\0\0xq\0~\0#\0q\0~sq\0~\0J\"eLq\0~t\0\0t\0Limitsr\0%org.enhydra.shark.xpdl.elements.Limit1ӗ\0\0xq\0~\0#\0q\0~sq\0~\0Qq\0~t\0\0t\0	ValidFromsr\0)org.enhydra.shark.xpdl.elements.ValidFromcŅ|L<\0\0xq\0~\0#\0q\0~sq\0~\0gq\0~t\0\0t\0ValidTosr\0\'org.enhydra.shark.xpdl.elements.ValidToM\0\0xq\0~\0#\0q\0~sq\0~\0j8q\0~t\0\0t\0TimeEstimationsr\0.org.enhydra.shark.xpdl.elements.TimeEstimationŀ\'3\0\0xq\0~\0\0q\0~sq\0~\03(q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesr\0+org.enhydra.shark.xpdl.elements.WaitingTimeN/\0\0xq\0~\0#\0q\0~sq\0~\0:q\0~t\0\0t\0WorkingTimesr\0+org.enhydra.shark.xpdl.elements.WorkingTime~\0\0xq\0~\0#\0q\0~sq\0~\0h\Z+q\0~t\0\0t\0Durationsr\0(org.enhydra.shark.xpdl.elements.Duration C\0\0xq\0~\0#\0q\0~sq\0~\0{_-q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xt\0RedefinableHeadersq\0~\0H\0q\0~sq\0~\09\Zvq\0~t\0\0sq\0~\0w\0\0\0q\0~\0Msq\0~\0\0q\0~\0Msq\0~\0f@Eq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~\0Rq\0~\0Sq\0~\0Txt\0Authorsq\0~\0V\0q\0~sq\0~\0_?Aq\0~t\0\0t\0Versionsq\0~\0[\0q\0~sq\0~\0&?Iq\0~t\0\0t\0Codepagesq\0~\0`\0q\0~sq\0~\0HEq\0~t\0\0t\0\nCountrykeysq\0~\0e\0q\0~sq\0~\0,fq\0~t\0\0t\0Responsiblessq\0~\0j\0q\0~sq\0~\0Lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~xt\0FormalParameterssq\0~a\0q\0~sq\0~\0WЖq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nDataFieldssq\0~\0q\0~sq\0~\0Yq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.DataFieldI3.~\0\0xq\0~\0t\0	DataFieldsq\0~\0r:q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Qp(q\0~t\0statuspq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~t\0\0pt\0IsArraysq\0~\0\0q\0~sq\0~\0q\0-q\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0t\0TRUEt\0FALSExt\0DataTypesr\0(org.enhydra.shark.xpdl.elements.DataType\'4sM\0\0xq\0~\0q\0~ sq\0~\0+q\0~t\0\0sq\0~\0w\0\0\0t\0	DataTypessr\0)org.enhydra.shark.xpdl.elements.DataTypespcH,!\0Z\0\risInitializedxq\0~\\q\0~&sq\0~\0W9[q\0~\"t\0\0sq\0~\0E\0\0\0	w\0\0\0	sr\0)org.enhydra.shark.xpdl.elements.BasicType)w1\0\0xq\0~\0t\0	BasicTypesq\0~\03@q\0~(t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Y_q\0~-t\0STRINGsq\0~\0E\0\0\0w\0\0\0t\0STRINGt\0FLOATt\0INTEGERt\0	REFERENCEt\0DATETIMEt\0BOOLEANt\0	PERFORMERxxsq\0~\0E\0\0\0w\0\0\0q\0~2xsr\0,org.enhydra.shark.xpdl.elements.DeclaredTypedR.\\^9\0\0xq\0~\0t\0DeclaredTypesq\0~\05(q\0~(t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0.{q\0~?t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Dxsr\0*org.enhydra.shark.xpdl.elements.SchemaType&1oSH\0\0xq\0~\0t\0\nSchemaTypesq\0~\0%87q\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0Aq\0~(t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0eWBq\0~Ot\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0Xq\0~Ot\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0n7q\0~Ot\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~Wq\0~Zxsr\0*org.enhydra.shark.xpdl.elements.RecordType%K\0\0\0xq\0~\0kt\0\nRecordTypesq\0~\0\"Mq\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.UnionType5PG\0\0xq\0~\0kt\0	UnionTypesq\0~\0}Roq\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0/org.enhydra.shark.xpdl.elements.EnumerationTypef3b\0\0xq\0~\0kt\0EnumerationTypesq\0~\0	8q\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.ArrayTypeg$\0N@\0\0xq\0~\0t\0	ArrayTypesq\0~\0X\ZDsq\0~(t\0\0sq\0~\0w\0\0\0t\0\nLowerIndexsq\0~\0q\0~ysq\0~\0)2q\0~tt\0\0pt\0\nUpperIndexsq\0~\0q\0~}sq\0~\0wUrq\0~tt\0\0pq\0~&sq\0~\'q\0~&sq\0~\0pRmq\0~tt\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~zq\0~~q\0~xsr\0(org.enhydra.shark.xpdl.elements.ListType\"ӟ\n\0\0xq\0~\0t\0ListTypesq\0~\0zq\0~(t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0<G00q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~-xsq\0~\0E\0\0\0w\0\0\0q\0~(xt\0InitialValuesr\0,org.enhydra.shark.xpdl.elements.InitialValuej,zR\0\0xq\0~\0#\0q\0~sq\0~\0dAq\0~t\0\0t\0Lengthsr\0&org.enhydra.shark.xpdl.elements.LengthMW+-̩W\0\0xq\0~\0#\0q\0~sq\0~\0Vlq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0q:9q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0tQq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~\Zq\0~\"q\0~q\0~q\0~q\0~xsq\0~\rt\0	DataFieldsq\0~\0oNq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0@c4q\0~t\0SelectApproverpq\0~\0sq\0~\0\0q\0~\0sq\0~\0)0q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0G߶q\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xt\0DataTypesq\0~!q\0~sq\0~\0_4&q\0~t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0\"Lq\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~,t\0	BasicTypesq\0~\0D1q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0]93q\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~6q\0~7q\0~8q\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~>t\0DeclaredTypesq\0~\0#Deq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0)~q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~Ht\0\nSchemaTypesq\0~\0,sq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\08q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\08Jq\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0dvq\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\03,q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~^t\0\nRecordTypesq\0~\0[q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~et\0	UnionTypesq\0~\0Qq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~lt\0EnumerationTypesq\0~\0f{eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~st\0	ArrayTypesq\0~\05q\0~t\0\0sq\0~\0w\0\0\0q\0~ysq\0~\0q\0~ysq\0~\09wnq\0~t\0\0pq\0~}sq\0~\0q\0~}sq\0~\0t\"q\0~t\0\0pq\0~&sq\0~\'q\0~&sq\0~\0Iq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~t\0ListTypesq\0~\0yΣq\0~t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0Cq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesq\0~\0q\0~sq\0~\0~q\0~t\0\0t\0Lengthsq\0~\0q\0~sq\0~\0;\Zq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\07Fq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0	Oq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0Participantssq\0~\0\0q\0~#sq\0~\0Q>bq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Applicationssq\0~D\0q\0~)sq\0~\0(k2q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ActivitySetssr\0,org.enhydra.shark.xpdl.elements.ActivitySetsqV[4\0\0xq\0~\0k\0q\0~/sq\0~\0{lVq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nActivitiessr\0*org.enhydra.shark.xpdl.elements.Activities&G^lP\0\0xq\0~\0k\0q\0~6sq\0~\01q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\rw\0\0\0\rsr\0(org.enhydra.shark.xpdl.elements.Activityt45\Z9\0\0xq\0~\0t\0Activitysq\0~\0pBq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0}.WFq\0~>t\0\rapprove_claimpq\0~\0sq\0~\0\0q\0~\0sq\0~\0}W-q\0~>t\0HOD Approvept\0Descriptionsq\0~\02\0q\0~Isq\0~\07q\0~>t\0\0t\0Limitsq\0~\0q\0~Msq\0~\0Oq\0~>t\0\0q\0~\0sr\0-org.enhydra.shark.xpdl.elements.ActivityTypeseŽ{\0\0xq\0~\\q\0~\0sq\0~\0jq\0~>t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0%org.enhydra.shark.xpdl.elements.Route0e\rG\0\0xq\0~\0t\0Routesq\0~\0)xq\0~Rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0.org.enhydra.shark.xpdl.elements.Implementationr^%\0\0xq\0~\0t\0Implementationsq\0~\0Y5q\0~Rt\0\0sq\0~\0w\0\0\0q\0~\0sr\03org.enhydra.shark.xpdl.elements.ImplementationTypes\rT١9\0\0xq\0~\\q\0~\0sq\0~\00#q\0~^t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0\"org.enhydra.shark.xpdl.elements.No{.\0\0xq\0~\0t\0Nosq\0~\0-Ŭq\0~dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0%org.enhydra.shark.xpdl.elements.ToolsCg\0\0xq\0~\0k\0t\0Toolssq\0~\0B5q\0~dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0\'org.enhydra.shark.xpdl.elements.SubFlow;Os7:$\0\0xq\0~\0t\0SubFlowsq\0~\0)q\0~dt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0(Zq\0~wt\0\0pt\0	Executionsq\0~\0\0q\0~sq\0~\0+1q\0~wq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ASYNCHRt\0SYNCHRxt\0ActualParameterssr\00org.enhydra.shark.xpdl.elements.ActualParameters_K\0\0xq\0~\0k\0q\0~sq\0~\0%լ8q\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~|q\0~q\0~xxq\0~ixsq\0~\0E\0\0\0w\0\0\0q\0~dxsr\0-org.enhydra.shark.xpdl.elements.BlockActivityqcF\0\0xq\0~\0t\0\rBlockActivitysq\0~\0Gq\0~Rt\0\0sq\0~\0w\0\0\0t\0BlockIdsq\0~\0q\0~sq\0~\0vםzq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~^t\0	Performersr\0)org.enhydra.shark.xpdl.elements.Performer\"1%\0\0xq\0~\0#\0q\0~sq\0~\0R,q\0~>t\0approvert\0	StartModesr\0)org.enhydra.shark.xpdl.elements.StartModenhS\0\0xq\0~\0\0q\0~sq\0~\0Z	y.q\0~>t\0\0sq\0~\0w\0\0\0t\0Modesr\00org.enhydra.shark.xpdl.elements.StartFinishModes~6zX\'\0\0xq\0~\\\0q\0~sq\0~\0oLq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0,org.enhydra.shark.xpdl.XMLEmptyChoiceElement2;3_\0\0xq\0~\0\0t\0XMLEmptyChoiceElementsq\0~\0Cq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.Automatict?_\0\0xq\0~\0t\0	Automaticsq\0~\02vq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0&org.enhydra.shark.xpdl.elements.Manualv[ؤ\0\0xq\0~\0t\0Manualsq\0~\0mvDq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesr\0*org.enhydra.shark.xpdl.elements.FinishMode{\0\0xq\0~\0\0q\0~sq\0~\0-~#q\0~>t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0N?q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Gq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0¼q\0~>t\0\0t\0	Deadlinessr\0)org.enhydra.shark.xpdl.elements.Deadlines>ɜ\0\0xq\0~\0k\0q\0~sq\0~\0&ï[q\0~>t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsr\05org.enhydra.shark.xpdl.elements.SimulationInformation\"|I\0\0xq\0~\0\0q\0~sq\0~\0Aq\0~>t\0\0sq\0~\0w\0\0\0t\0\rInstantiationsq\0~\0\0q\0~sq\0~\0l;q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ONCEt\0MULTIPLExt\0Costsr\0$org.enhydra.shark.xpdl.elements.Cost\0\0xq\0~\0#q\0~sq\0~\03q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\08q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0Lq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\02ӇTq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0@\0?q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsr\0$org.enhydra.shark.xpdl.elements.IconTU(}6\0\0xq\0~\0#\0q\0~sq\0~\0Cq\0~>t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0cg8q\0~>t\0\0t\0TransitionRestrictionssr\06org.enhydra.shark.xpdl.elements.TransitionRestrictionsC)׀i;\0\0xq\0~\0k\0q\0~sq\0~\0M>q\0~>t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\05org.enhydra.shark.xpdl.elements.TransitionRestrictionN}\0\0xq\0~\0t\0TransitionRestrictionsq\0~\0&Ssq\0~t\0\0sq\0~\0w\0\0\0t\0Joinsr\0$org.enhydra.shark.xpdl.elements.Joinڕөx)5\0\0xq\0~\0\0q\0~\"sq\0~\0`q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~$t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ANDt\0XORxxsq\0~\0E\0\0\0w\0\0\0q\0~(xt\0Splitsr\0%org.enhydra.shark.xpdl.elements.Split~ѯWS\0\0xq\0~\0\0q\0~/sq\0~\0dq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0;Aq\0~1q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~,q\0~-xt\0TransitionRefssr\0.org.enhydra.shark.xpdl.elements.TransitionRefsъ\0\0xq\0~\0k\0q\0~8sq\0~\0Egq\0~1t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~5q\0~:xxsq\0~\0E\0\0\0w\0\0\0q\0~$q\0~1xxt\0ExtendedAttributessq\0~\0\0q\0~Asq\0~\02FDq\0~>t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\01org.enhydra.shark.xpdl.elements.ExtendedAttribute\\F\0\0xq\0~\0t\0ExtendedAttributesq\0~\0-q\0~Bt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Gyq\0~Ht\0JaWE_GRAPH_PARTICIPANT_IDpt\0Valuesq\0~\0\0q\0~Psq\0~\0cqq\0~Ht\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Qxsq\0~Gt\0ExtendedAttributesq\0~\0q\0~Bt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0w	q\0~Ut\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0h\0q\0~Ut\0271,11.26251220703125pxsq\0~\0E\0\0\0w\0\0\0q\0~Zq\0~]xxpxsq\0~\0E\0\0\0w\0\0\0q\0~Cq\0~Fq\0~Jq\0~Nq\0~Rq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~Bxsq\0~=t\0Activitysq\0~\07q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0+Lq\0~bt\0route1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0W$q\0~bt\0\0pt\0Descriptionsq\0~\02\0q\0~msq\0~\0p\0hiq\0~bt\0\0t\0Limitsq\0~\0q\0~qsq\0~\0p8n}q\0~bt\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0q\0~bt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0M1q\0~ut\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0>[q\0~ut\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0\rU3q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0hq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0Lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~vt\0SubFlowsq\0~\0H$q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\09rq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0.+q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0-[Jq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0tq\0~ut\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0fBq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~yt\0	Performersq\0~\0q\0~sq\0~\0AHY0q\0~bt\0approvert\0	StartModesq\0~\0q\0~sq\0~\0N94Xq\0~bt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\'f_gq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0J?q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Xt6q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0[Kq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0<aGq\0~bt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0	1q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0}q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0PPq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Hq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0ab:q\0~bt\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0YKq\0~bt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0sq\0~bt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0.Hq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0&PNq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0 Իq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0dGq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0y=]q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0]9dq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\0;.tq\0~bt\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0Mq\0~bt\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0q\0~bt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0TransitionRestrictionsq\0~\0{q\0~t\0\0sq\0~\0w\0\0\0t\0Joinsq\0~#\0q\0~(sq\0~\0m0nq\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0*q\0~)q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~,q\0~-xxsq\0~\0E\0\0\0w\0\0\0q\0~-xt\0Splitsq\0~0\0q\0~1sq\0~\0 q\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~2t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~,q\0~-xt\0TransitionRefssq\0~9\0q\0~:sq\0~\0v\nvq\0~2t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0-org.enhydra.shark.xpdl.elements.TransitionRef%-a\0\0xq\0~\0t\0\rTransitionRefsq\0~\0\"3q\0~;t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0a?q\0~At\0transition10pxsq\0~\0E\0\0\0w\0\0\0q\0~Fxsq\0~@t\0\rTransitionRefsq\0~\0u#-q\0~;t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0lq\0~Jt\0transition14pxsq\0~\0E\0\0\0w\0\0\0q\0~Oxsq\0~@t\0\rTransitionRefsq\0~\0P!q\0~;t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0DFq\0~St\0transition16pxsq\0~\0E\0\0\0w\0\0\0q\0~Xxxxsq\0~\0E\0\0\0w\0\0\0q\0~6q\0~;xxsq\0~\0E\0\0\0w\0\0\0q\0~)q\0~2xxt\0ExtendedAttributessq\0~\0\0q\0~^sq\0~\0Cq\0~bt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0 q\0~_t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\09q\0~dt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\06[Vq\0~dt\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~iq\0~lxsq\0~Gt\0ExtendedAttributesq\0~\0HYq\0~_t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0d~q\0~pt\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\01wq\0~pt\0468,15.024996948242176pxsq\0~\0E\0\0\0w\0\0\0q\0~uq\0~xxxpxsq\0~\0E\0\0\0w\0\0\0q\0~gq\0~jq\0~nq\0~rq\0~uq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~\Zq\0~q\0~_xsq\0~=t\0Activitysq\0~\0 MLq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0>̤q\0~}t\0verify_claimpq\0~\0sq\0~\0\0q\0~\0sq\0~\02[q\0~}t\0Finance Verifypt\0Descriptionsq\0~\02\0q\0~sq\0~\0MFq\0~}t\0\0t\0Limitsq\0~\0q\0~sq\0~\0Fq\0~}t\0\0q\0~\0sq\0~Qq\0~\0sq\0~\01Y<q\0~}t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0f~q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0!qq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0`8q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0bB]q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0_q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~vt\0SubFlowsq\0~\02W=q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0bNq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0BDq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\02q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Kq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0Pq\0~}t\0financet\0	StartModesq\0~\0q\0~sq\0~\0s3q\0~}t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0l_q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Yq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0z|E8q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0gy&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0_HDq\0~}t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0rt׏q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0+OTq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0FH<q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0>]2q\0~}t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0qeq\0~}t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0~q\0~}t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0]^q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\"sq\0~\0hlq\0~t\0\0t\0WorkingTimesq\0~\0q\0~&sq\0~\0j	dMq\0~t\0\0t\0Durationsq\0~\0q\0~*sq\0~\0QTiq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~#q\0~\'q\0~+xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~\Zq\0~xt\0Iconsq\0~\r\0q\0~0sq\0~\01~q\0~}t\0\0t\0\rDocumentationsq\0~\07\0q\0~4sq\0~\0*\r,q\0~}t\0\0t\0TransitionRestrictionssq\0~\0q\0~8sq\0~\0q\0~}t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~>sq\0~\05q\0~}t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0\nq\0~?t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\08Nq\0~Dt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0$6Yq\0~Dt\0financepxsq\0~\0E\0\0\0w\0\0\0q\0~Iq\0~Lxsq\0~Gt\0ExtendedAttributesq\0~\0%q\0~?t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0O<q\0~Pt\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0zq\0~Pt\0445,46.56248779296874pxsq\0~\0E\0\0\0w\0\0\0q\0~Uq\0~Xxxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~1q\0~5q\0~9q\0~?xsq\0~=t\0Activitysq\0~\0]A9q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0`q\0~]t\0route2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0lq\0~]t\0\0pt\0Descriptionsq\0~\02\0q\0~hsq\0~\07?+\Zq\0~]t\0\0t\0Limitsq\0~\0q\0~lsq\0~\0|_q\0~]t\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0(q\0~]t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0{|q\0~pt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\05wyq\0~pt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0.\Z\0q\0~zt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0&n\n3q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0*oq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~vt\0SubFlowsq\0~\0$mjq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Zq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0ZQPq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\05q\0~pt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0dq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~tt\0	Performersq\0~\0q\0~sq\0~\0.Ijq\0~]t\0financet\0	StartModesq\0~\0q\0~sq\0~\0~Nxq\0~]t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0-7bq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\00q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Acq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\02xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0aqq\0~]t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0V߶q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0[V4q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0L&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0`q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0?q\0~]t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0k\nCq\0~]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0E\Zq\0~]t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0;1q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0!4|q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0Ǟq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0#jq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0~E:;q\0~t\0\0t\0Durationsq\0~\0q\0~\nsq\0~\0N@[q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\0nEq\0~]t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0]q\0~]t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0Orْq\0~]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0TransitionRestrictionsq\0~\0.q\0~t\0\0sq\0~\0w\0\0\0t\0Joinsq\0~#\0q\0~#sq\0~\0.Eq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0(`YGq\0~$q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~,q\0~-xxsq\0~\0E\0\0\0w\0\0\0q\0~(xt\0Splitsq\0~0\0q\0~,sq\0~\0Ck]q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0V)ߔq\0~-t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~,q\0~-xt\0TransitionRefssq\0~9\0q\0~5sq\0~\0(QGq\0~-t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~@t\0\rTransitionRefsq\0~\0rkZq\0~6t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0T> q\0~;t\0transition7pxsq\0~\0E\0\0\0w\0\0\0q\0~@xsq\0~@t\0\rTransitionRefsq\0~\0^q\0~6t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~Dt\0transition8pxsq\0~\0E\0\0\0w\0\0\0q\0~Ixxxsq\0~\0E\0\0\0w\0\0\0q\0~1q\0~6xxsq\0~\0E\0\0\0w\0\0\0q\0~$q\0~-xxt\0ExtendedAttributessq\0~\0\0q\0~Osq\0~\0#Hq\0~]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0?Kq\0~Pt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~Ut\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0iIq\0~Ut\0financepxsq\0~\0E\0\0\0w\0\0\0q\0~Zq\0~]xsq\0~Gt\0ExtendedAttributesq\0~\0	1Rcq\0~Pt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\Zq\0~at\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0\"hq\0~at\0622,50.37498779296874pxsq\0~\0E\0\0\0w\0\0\0q\0~fq\0~ixxpxsq\0~\0E\0\0\0w\0\0\0q\0~bq\0~eq\0~iq\0~mq\0~pq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~Pxsq\0~=t\0Activitysq\0~\07q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0aq\0~nt\0tool1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0>q\0~nt\0 Notify Claimant Finance Verifiedpt\0Descriptionsq\0~\02\0q\0~ysq\0~\03(q\0~nt\0\0t\0Limitsq\0~\0q\0~}sq\0~\0\n[q\0~nt\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0tLq\0~nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0duPq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0\\q\\q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0b_&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0JWq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0$org.enhydra.shark.xpdl.elements.Tool\\6&+G\0\0xq\0~\0t\0Toolsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0M?q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0nq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0APPLICATIONt\0	PROCEDURExt\0ActualParameterssq\0~\0q\0~sq\0~\0yq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0uh-q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0K	Iq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~vt\0SubFlowsq\0~\0cf{q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0,Isq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0d\rq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0=Tq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0-q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Jٕq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0Fpq\0~nt\0financet\0	StartModesq\0~\0q\0~sq\0~\0[q\0~nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0>uOq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0P.mq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0GKGq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0?Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0=eq\0~nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0?֚q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0)\rYq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0~a>q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0H#q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Prioritysq\0~\0q\0~sq\0~\0Qq\0~nt\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0q\0~nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~!sq\0~\0/jq\0~nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Gqq\0~\"q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~)sq\0~\0Y_Tq\0~\"t\0\0t\0TimeEstimationsq\0~q\0~-sq\0~\03Qmq\0~\"t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~2sq\0~\02q\0~.t\0\0t\0WorkingTimesq\0~\0q\0~6sq\0~\0KPdq\0~.t\0\0t\0Durationsq\0~\0q\0~:sq\0~\0q\0~.t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~3q\0~7q\0~;xxsq\0~\0E\0\0\0w\0\0\0q\0~&q\0~*q\0~.xt\0Iconsq\0~\r\0q\0~@sq\0~\0/q\0~nt\0\0t\0\rDocumentationsq\0~\07\0q\0~Dsq\0~\00Sq\0~nt\0\0t\0TransitionRestrictionssq\0~\0q\0~Hsq\0~\0q\0~nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~Nsq\0~\0d~q\0~nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0j	q\0~Ot\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0_<q\0~Tt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0[d	q\0~Tt\0financepxsq\0~\0E\0\0\0w\0\0\0q\0~Yq\0~\\xsq\0~Gt\0ExtendedAttributesq\0~\0f1q\0~Ot\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~`t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0c֓,q\0~`t\0754,45.58751220703124pxsq\0~\0E\0\0\0w\0\0\0q\0~eq\0~hxxpxsq\0~\0E\0\0\0w\0\0\0q\0~sq\0~vq\0~zq\0~~q\0~q\0~q\0~q\0~q\0~q\0~q\0~\"q\0~Aq\0~Eq\0~Iq\0~Oxsq\0~=t\0Activitysq\0~\0q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\\Vq\0~mt\0tool2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~mt\0 Notify Claimant Finance Rejectedpt\0Descriptionsq\0~\02\0q\0~xsq\0~\0\"07q\0~mt\0\0t\0Limitsq\0~\0q\0~|sq\0~\0BLq\0~mt\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0U<q\0~mt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0j|q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0nܗq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0x,q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0M\'q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0z&Tq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0`nq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0$q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0NK/q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0bcq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0[Ҋ[q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0HTq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~vt\0SubFlowsq\0~\0p\n.q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0h&eq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0<^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\02Seq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0vjq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0F\'iq\0~mt\0financet\0	StartModesq\0~\0q\0~sq\0~\0, ?q\0~mt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0udq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Tϣq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0:q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Z:*q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0eq\0~mt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Soq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0z;q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0>q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0:q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	\0xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~	sq\0~\0		q\0~mt\0\0t\0	Deadlinessq\0~\0q\0~	sq\0~\0*q\0~mt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~	sq\0~\0Dyq\0~mt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0oq\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~	%sq\0~\0*\Zq\0~	t\0\0t\0TimeEstimationsq\0~q\0~	)sq\0~\0uq\0~	t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~	.sq\0~\0#`q\0~	*t\0\0t\0WorkingTimesq\0~\0q\0~	2sq\0~\0Tֳ<q\0~	*t\0\0t\0Durationsq\0~\0q\0~	6sq\0~\0v}q\0~	*t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~	/q\0~	3q\0~	7xxsq\0~\0E\0\0\0w\0\0\0q\0~	\"q\0~	&q\0~	*xt\0Iconsq\0~\r\0q\0~	<sq\0~\0uٞq\0~mt\0\0t\0\rDocumentationsq\0~\07\0q\0~	@sq\0~\0}e.q\0~mt\0\0t\0TransitionRestrictionssq\0~\0q\0~	Dsq\0~\0fq\0~mt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~	Jsq\0~\0eq\0~mt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0d۴q\0~	Kt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0k^q\0~	Pt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0?\Zq\0~	Pt\0financepxsq\0~\0E\0\0\0w\0\0\0q\0~	Uq\0~	Xxsq\0~Gt\0ExtendedAttributesq\0~\0&q\0~	Kt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0*q\0~	\\t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0\0Əq\0~	\\t\0589,136.1625244140625pxsq\0~\0E\0\0\0w\0\0\0q\0~	aq\0~	dxxpxsq\0~\0E\0\0\0w\0\0\0q\0~rq\0~uq\0~yq\0~}q\0~q\0~q\0~q\0~q\0~	q\0~	q\0~	q\0~	=q\0~	Aq\0~	Eq\0~	Kxsq\0~=t\0Activitysq\0~\0ic9aq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0}3Oq\0~	it\0tool3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0)\nq\0~	it\0Notify Claimant Resubmitpt\0Descriptionsq\0~\02\0q\0~	tsq\0~\0fq\0~	it\0\0t\0Limitsq\0~\0q\0~	xsq\0~\0Rtq\0~	it\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0\"wq\0~	it\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\06\Z1q\0~	|t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0x?q\0~	|t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0b_*\'q\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0LK;<q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0+Dq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0yjq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0l.\0q\0~	t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~	sq\0~\0Rmq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~	sq\0~\0\ZEq\0~	t\0\0t\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\0^ێq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	xxsq\0~vt\0SubFlowsq\0~\0,xq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\07q\0~	t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0\"\rWq\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~	sq\0~\0Mjq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xsq\0~t\0\rBlockActivitysq\0~\0 q\0~	|t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0~q\0~	t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~	xxq\0~	t\0	Performersq\0~\0q\0~	sq\0~\06sq\0~	it\0claimantt\0	StartModesq\0~\0q\0~	sq\0~\0|qq\0~	it\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0`{q\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0K!q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Qxq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0 q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xt\0\nFinishModesq\0~\0q\0~	sq\0~\0g6Xq\0~	it\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0.V)q\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0M!q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0jM9q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xt\0Prioritysq\0~\0q\0~\nsq\0~\0%{q\0~	it\0\0t\0	Deadlinessq\0~\0q\0~\nsq\0~\0.q\0~	it\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~\nsq\0~\0Jsq\0~	it\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0:)%q\0~\n\Zq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~\n!sq\0~\0T$q\0~\n\Zt\0\0t\0TimeEstimationsq\0~q\0~\n%sq\0~\0q\0~\n\Zt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\n*sq\0~\0PMq\0~\n&t\0\0t\0WorkingTimesq\0~\0q\0~\n.sq\0~\0\'j^Jq\0~\n&t\0\0t\0Durationsq\0~\0q\0~\n2sq\0~\0FLq\0~\n&t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~\n+q\0~\n/q\0~\n3xxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\n\"q\0~\n&xt\0Iconsq\0~\r\0q\0~\n8sq\0~\0p@q\0~	it\0\0t\0\rDocumentationsq\0~\07\0q\0~\n<sq\0~\0Lzq\0~	it\0\0t\0TransitionRestrictionssq\0~\0q\0~\n@sq\0~\09q\0~	it\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\nFsq\0~\0sUq\0~	it\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0,*q\0~\nGt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0XJ[q\0~\nLt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\09Řq\0~\nLt\0claimantpxsq\0~\0E\0\0\0w\0\0\0q\0~\nQq\0~\nTxsq\0~Gt\0ExtendedAttributesq\0~\0ftq\0~\nGt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0(Fq\0~\nXt\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0.q\0~\nXt\0432,33.62499923706055pxsq\0~\0E\0\0\0w\0\0\0q\0~\n]q\0~\n`xxpxsq\0~\0E\0\0\0w\0\0\0q\0~	nq\0~	qq\0~	uq\0~	yq\0~	|q\0~	q\0~	q\0~	q\0~\nq\0~\nq\0~\n\Zq\0~\n9q\0~\n=q\0~\nAq\0~\nGxsq\0~=t\0Activitysq\0~\0\0q[q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~\net\0	new_claimpq\0~\0sq\0~\0\0q\0~\0sq\0~\0Bq\0~\net\0\rClaimant Editpt\0Descriptionsq\0~\02\0q\0~\npsq\0~\0vq\0~\net\0\0t\0Limitsq\0~\0q\0~\ntsq\0~\0(Sq\0~\net\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0&q\0~\net\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0t*\\q\0~\nxt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0]Aq\0~\nxt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0iq\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\091q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0|uq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~vt\0SubFlowsq\0~\0,?q\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~\nt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0zvUq\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\nsq\0~\0]Grq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~\nxsq\0~t\0\rBlockActivitysq\0~\0VyGq\0~\nxt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0h?7q\0~\nt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\nxxq\0~\nt\0	Performersq\0~\0q\0~\nsq\0~\0)٫q\0~\net\0claimantt\0	StartModesq\0~\0q\0~\nsq\0~\0K+q\0~\net\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Wnq\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0xXZ*q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\04q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Cd7q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~\nxt\0\nFinishModesq\0~\0q\0~\nsq\0~\0J;5q\0~\net\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0pRq\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0K9:q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0vq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0tq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~\nxt\0Prioritysq\0~\0q\0~\nsq\0~\07#$q\0~\net\0\0t\0	Deadlinessq\0~\0q\0~\nsq\0~\0瘑q\0~\net\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~\nsq\0~\0y)q\0~\net\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0%ȵ	q\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0ܜq\0~\nt\0\0t\0TimeEstimationsq\0~q\0~sq\0~\02Ҭq\0~\nt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\nsq\0~\0r?q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0ڀq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0ixq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\0Nrq\0~\net\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0lwq\0~\net\0\0t\0TransitionRestrictionssq\0~\0q\0~ sq\0~\0*rzq\0~\net\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~&sq\0~\0!q\0~\net\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0Grq\0~\'t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0X>7q\0~,t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0\ngq\0~,t\0claimantpxsq\0~\0E\0\0\0w\0\0\0q\0~1q\0~4xsq\0~Gt\0ExtendedAttributesq\0~\0@!q\0~\'t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0r9`q\0~8t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\09Xϱq\0~8t\0124,36.87499649804687pxsq\0~\0E\0\0\0w\0\0\0q\0~=q\0~@xxpxsq\0~\0E\0\0\0w\0\0\0q\0~\njq\0~\nmq\0~\nqq\0~\nuq\0~\nxq\0~\nq\0~\nq\0~\nq\0~\nq\0~\nq\0~\nq\0~q\0~q\0~!q\0~\'xsq\0~=t\0Activitysq\0~\0*)q\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Q\\q\0~Et\0tool4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Dwq\0~Et\0Update Status=Submittedpt\0Descriptionsq\0~\02\0q\0~Psq\0~\0EHq\0~Et\0\0t\0Limitsq\0~\0q\0~Tsq\0~\0:\"q\0~Et\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0Q25q\0~Et\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0q\0~Xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\06F6q\0~Xt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0/)q\0~bt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0q\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0d{q\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\01qO!q\0~qt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\04>q\0~wt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~wq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0Jrq\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0$]9(q\0~wt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0bq\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~|q\0~q\0~q\0~q\0~xxsq\0~vt\0SubFlowsq\0~\0B\nq\0~gt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0<eq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0^hyq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0e q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~qxsq\0~\0E\0\0\0w\0\0\0q\0~gxsq\0~t\0\rBlockActivitysq\0~\0w\Zq\0~Xt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0XHGq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~bt\0	Performersq\0~\0q\0~sq\0~\0EGq\0~Et\0approvert\0	StartModesq\0~\0q\0~sq\0~\03q\0~Et\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0;q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0i/C|q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\08nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0Wgq\0~Et\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0*q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0\Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\09$q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0 1t]q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0vq\0~Et\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0<bq\0~Et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0#Rq\0~Et\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0iq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0Q֑q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0ySzq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0N,q\0~t\0\0t\0WorkingTimesq\0~\0q\0~\nsq\0~\0]\"sq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0\r#q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\0h*0nq\0~Et\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0g0q\0~Et\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0)\nq\0~Et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\"sq\0~\0hL1q\0~Et\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0-*pq\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0 Nq\0~(t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0\'0;0q\0~(t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~-q\0~0xsq\0~Gt\0ExtendedAttributesq\0~\0knSq\0~#t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\\lq\0~4t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0,L@q\0~4t\0%115.64773559570312,110.71590326953125pxsq\0~\0E\0\0\0w\0\0\0q\0~9q\0~<xxpxsq\0~\0E\0\0\0w\0\0\0q\0~Jq\0~Mq\0~Qq\0~Uq\0~Xq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~#xsq\0~=t\0Activitysq\0~\0\n=Uq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~At\0resubmitpq\0~\0sq\0~\0\0q\0~\0sq\0~\0\"_&q\0~At\0Claimant Resubmitpt\0Descriptionsq\0~\02\0q\0~Lsq\0~\0WtBq\0~At\0\0t\0Limitsq\0~\0q\0~Psq\0~\0iq\0~At\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0mq\0~At\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0P3q\0~Tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0lBq\0~Tt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0ۻwq\0~^t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0L˂q\0~ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0L?q\0~ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~vt\0SubFlowsq\0~\0*(^q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0oK>kq\0~st\0\0pq\0~sq\0~\0\0q\0~sq\0~\0]Kq\0~sq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~~sq\0~\00NVq\0~st\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~xq\0~{q\0~xxq\0~gxsq\0~\0E\0\0\0w\0\0\0q\0~cxsq\0~t\0\rBlockActivitysq\0~\0k(q\0~Tt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0]^q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~^t\0	Performersq\0~\0q\0~sq\0~\0Rq\0~At\0claimantt\0	StartModesq\0~\0q\0~sq\0~\0u<q\0~At\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\05q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0,\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0{&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0\0Cq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0Sq\0~At\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Y;q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0rPq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\08q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0<\Z#q\0~At\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0aq\0~At\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0q[q\0~At\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\03\nq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\07Yq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0)=oq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\07OOq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0=Peq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\0nq\0~At\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0)q\0~At\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0\\V+q\0~At\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0dHq\0~At\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0IFq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0kGq\0~\rt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0ͳq\0~\rt\0claimantpxsq\0~\0E\0\0\0w\0\0\0q\0~\r\rq\0~\rxsq\0~Gt\0ExtendedAttributesq\0~\0\\/q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\\Iq\0~\rt\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0hCZq\0~\rt\0259,34.66666825097656pxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~Fq\0~Iq\0~Mq\0~Qq\0~Tq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~\rxsq\0~=t\0Activitysq\0~\0\n\Zq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0/V$q\0~\r!t\0tool5pq\0~\0sq\0~\0\0q\0~\0sq\0~\0+ۆq\0~\r!t\0Notify Approverpt\0Descriptionsq\0~\02\0q\0~\r,sq\0~\08Y3q\0~\r!t\0\0t\0Limitsq\0~\0q\0~\r0sq\0~\0H[q\0~\r!t\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0Z\\q\0~\r!t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0-}q\0~\r4t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0\\q\0~\r4t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0VKq\0~\r>t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0~\0-q\0~\rCt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0xuq\0~\rCt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0	q\0~\rMt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0$q\0~\rSt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0ynTq\0~\rSq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\r^sq\0~\0E\\q\0~\rSt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~\rdsq\0~\00q\0~\rSt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rhsq\0~\0,q\0~\rSt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\rXq\0~\r[q\0~\r_q\0~\req\0~\rixxsq\0~vt\0SubFlowsq\0~\0+\rq\0~\rCt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\"\0lq\0~\rot\0\0pq\0~sq\0~\0\0q\0~sq\0~\0kuq\0~\roq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\rzsq\0~\0Pkq\0~\rot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\rtq\0~\rwq\0~\r{xxq\0~\rMxsq\0~\0E\0\0\0w\0\0\0q\0~\rCxsq\0~t\0\rBlockActivitysq\0~\0tRq\0~\r4t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0ndq\0~\rt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\rxxq\0~\r>t\0	Performersq\0~\0q\0~\rsq\0~\04q\0~\r!t\0approvert\0	StartModesq\0~\0q\0~\rsq\0~\0emq\0~\r!t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0=vq\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0LC[q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\086q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Oy%Aq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\rxsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0\nFinishModesq\0~\0q\0~\rsq\0~\0q\0~\r!t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0?p.q\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\02{>q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0K\Zq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\07q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\rxsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0Prioritysq\0~\0q\0~\rsq\0~\0^ʯq\0~\r!t\0\0t\0	Deadlinessq\0~\0q\0~\rsq\0~\04۲q\0~\r!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~\rsq\0~\0(Eq\0~\r!t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0q\0~\rq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~\rsq\0~\0_xq\0~\rt\0\0t\0TimeEstimationsq\0~q\0~\rsq\0~\0`wq\0~\rt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\rsq\0~\0t%q\0~\rt\0\0t\0WorkingTimesq\0~\0q\0~\rsq\0~\0\\q\0~\rt\0\0t\0Durationsq\0~\0q\0~\rsq\0~\0gq\0~\rt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rxxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rxt\0Iconsq\0~\r\0q\0~\rsq\0~\0qeq\0~\r!t\0\0t\0\rDocumentationsq\0~\07\0q\0~\rsq\0~\0Aj\0q\0~\r!t\0\0t\0TransitionRestrictionssq\0~\0q\0~\rsq\0~\0t!jq\0~\r!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0%+.	q\0~\r!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\06\'q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0%5q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0qq\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0,\nq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0svyq\0~t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0_Qq\0~t\0267,111.34090326953125pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~\r&q\0~\r)q\0~\r-q\0~\r1q\0~\r4q\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rxsq\0~=t\0Activitysq\0~\0	&vq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0@q\0~t\0tool6pq\0~\0sq\0~\0\0q\0~\0sq\0~\0@~̧q\0~t\0Notify Financept\0Descriptionsq\0~\02\0q\0~(sq\0~\00}	oq\0~t\0\0t\0Limitsq\0~\0q\0~,sq\0~\0`yq\0~t\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0pykq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0Fp7q\0~0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\0:/q\0~0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\023q\0~:t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0}q\0~?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0kMq\0~?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0zq\0~It\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0tq\0~Ot\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0!Ԕtq\0~Oq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~Zsq\0~\0vRq\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~`sq\0~\0f׭Eq\0~Ot\0\0t\0ExtendedAttributessq\0~\0\0q\0~dsq\0~\0q\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~Wq\0~[q\0~aq\0~exxsq\0~vt\0SubFlowsq\0~\0$q\0~?t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Kq\0~kt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0iUq\0~kq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~vsq\0~\0j{q\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~pq\0~sq\0~wxxq\0~Ixsq\0~\0E\0\0\0w\0\0\0q\0~?xsq\0~t\0\rBlockActivitysq\0~\0q1*q\0~0t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\'Upq\0~~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~:t\0	Performersq\0~\0q\0~sq\0~\0uq\0~t\0approvert\0	StartModesq\0~\0q\0~sq\0~\0!/Bq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Q~q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0ca\\q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Ĵq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0I>sq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0WT+q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0:>q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0|#q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0\'q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0i]q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0R2 q\0~t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\02#wq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0\\jq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0%q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0q\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0mI6q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0%\nq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0Bjq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0R0Oq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\0pq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0yh\rq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0k%q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0;q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0}Aq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0zq\0~\0t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0\0B/5q\0~\0t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0]Rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0@uq\0~t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0wVq\0~t\0445,111.87499140429688pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~\"q\0~%q\0~)q\0~-q\0~0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~=t\0Activitysq\0~\0fRq\0~8t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0tSdq\0~t\0tool7pq\0~\0sq\0~\0\0q\0~\0sq\0~\0cdXq\0~t\0Notify Claimant Rejectedpt\0Descriptionsq\0~\02\0q\0~$sq\0~\0	q\0~t\0\0t\0Limitsq\0~\0q\0~(sq\0~\0d`7q\0~t\0\0q\0~\0sq\0~Qq\0~\0sq\0~\0M3q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~Vt\0Routesq\0~\0M\"q\0~,t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~]t\0Implementationsq\0~\08Z+q\0~,t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~cq\0~\0sq\0~\0Wpeq\0~6t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Nosq\0~\0Kq\0~;t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~o\0t\0Toolssq\0~\0Xܠq\0~;t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0,q\0~Et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Suq\0~Kt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0Tq\0~Kq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~Vsq\0~\0zPfq\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~\\sq\0~\0!jq\0~Kt\0\0t\0ExtendedAttributessq\0~\0\0q\0~`sq\0~\0[l\"q\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Pq\0~Sq\0~Wq\0~]q\0~axxsq\0~vt\0SubFlowsq\0~\0\Z q\0~;t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0N*wq\0~gt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0w9q\0~gq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~rsq\0~\0*)q\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~lq\0~oq\0~sxxq\0~Exsq\0~\0E\0\0\0w\0\0\0q\0~;xsq\0~t\0\rBlockActivitysq\0~\04.q\0~,t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0)q\0~zt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~6t\0	Performersq\0~\0q\0~sq\0~\0q\0~t\0approvert\0	StartModesq\0~\0q\0~sq\0~\0#<Lq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0ùq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0\\_q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0\nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\07Gsq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0_q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0uq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Qޱvq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0}\Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0g\nq\0~t\0\0t\0	Deadlinessq\0~\0q\0~sq\0~\0@HIq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0d,q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Ib5q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~q\0~sq\0~\0zOq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0ۄq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0Tq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0>q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0.q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~\r\0q\0~sq\0~\0z4՚q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0#\0q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0kq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0(~q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0hMq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0)6q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~Psq\0~\0\0q\0~Psq\0~\0\\{q\0~t\0approverpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0rk$q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0rbq\0~t\0JaWE_GRAPH_OFFSETpq\0~Psq\0~\0\0q\0~Psq\0~\0*q\0~t\0697,14.962509155273438pxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~!q\0~%q\0~)q\0~,q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0Transitionssr\0+org.enhydra.shark.xpdl.elements.Transitions9>/i\0\0xq\0~\0k\0q\0~sq\0~\0qIq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\rw\0\0\0\rsr\0*org.enhydra.shark.xpdl.elements.Transitiontx\0\0xq\0~\0t\0\nTransitionsq\0~\0KmYq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0$uq\0~t\0transition1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0gfq\0~t\0\0pt\0Fromsq\0~\0q\0~(sq\0~\0\\nq\0~t\0\rapprove_claimpt\0Tosq\0~\0q\0~,sq\0~\0oYq\0~t\0route1pt\0	Conditionsr\0)org.enhydra.shark.xpdl.elements.ConditionDZ;|\0\0xq\0~\0\0q\0~0sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0~4~q\0~2q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0	CONDITIONt\0	OTHERWISEt\0	EXCEPTIONt\0DEFAULTEXCEPTIONxxsq\0~\0E\0\0\0w\0\0\0q\0~6xt\0Descriptionsq\0~\02\0q\0~>sq\0~\0~?q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~Bsq\0~\0,\"Kq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0,q\0~Ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0]q\0~Ht\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0^Rq\0~Ht\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Pxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\"q\0~%q\0~)q\0~-q\0~2q\0~?q\0~Cxsq\0~t\0\nTransitionsq\0~\0-@q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0z.Jq\0~Ut\0transition4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0gq\0~Ut\0\0pq\0~(sq\0~\0q\0~(sq\0~\0ykpq\0~Ut\0verify_claimpq\0~,sq\0~\0q\0~,sq\0~\0zq\0~Ut\0route2pt\0	Conditionsq\0~1\0q\0~fsq\0~\0~;m)q\0~Ut\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0[Υq\0~gq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~kxt\0Descriptionsq\0~\02\0q\0~osq\0~\0Oˏq\0~Ut\0\0t\0ExtendedAttributessq\0~\0\0q\0~ssq\0~\0_Rq\0~Ut\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0Ye/q\0~tt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0|Gq\0~yt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0egbq\0~yt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~Zq\0~]q\0~`q\0~cq\0~gq\0~pq\0~txsq\0~t\0\nTransitionsq\0~\0&dEq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0^Y3q\0~t\0transition7pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Qq\0~t\0verifiedpq\0~(sq\0~\0q\0~(sq\0~\0V9q\0~t\0route2pq\0~,sq\0~\0q\0~,sq\0~\0@ڋq\0~t\0tool1pt\0	Conditionsq\0~1\0q\0~sq\0~\09q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0+}q\0~t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0?oaq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\08q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\09tXq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\09q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0jdq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Ǎdq\0~t\0transition8pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\Z+q\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\00Ecq\0~t\0route2pq\0~,sq\0~\0q\0~,sq\0~\0C`q\0~t\0tool2pt\0	Conditionsq\0~1\0q\0~sq\0~\0{Eq\0~t\0status===\'Rejected by Finance\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0`q\0~t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0&q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0`kq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0:q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0]{jq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0PTq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0X@Lq\0~t\0t_new_claim_tool4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0l\Zq\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0(\"q\0~t\0	new_claimpq\0~,sq\0~\0q\0~,sq\0~\0bi<q\0~t\0tool4pt\0	Conditionsq\0~1\0q\0~sq\0~\09q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Hq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0c	 Uq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0?tq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0(Zq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\08>q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~	xsq\0~t\0\nTransitionsq\0~\0?Dq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0#kQq\0~t\0t_resubmit_approve_claimpq\0~\0sq\0~\0\0q\0~\0sq\0~\0d,q\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0Ǒq\0~t\0resubmitpq\0~,sq\0~\0q\0~,sq\0~\0E˫&q\0~t\0\rapprove_claimpt\0	Conditionsq\0~1\0q\0~,sq\0~\0rPq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0*Sq\0~-q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~1xt\0Descriptionsq\0~\02\0q\0~5sq\0~\02Ⱦq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~9sq\0~\00pq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0]q\0~:t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{NXq\0~?t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0fb<~q\0~?t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~Dq\0~Gxxpxsq\0~\0E\0\0\0w\0\0\0q\0~ q\0~#q\0~&q\0~)q\0~-q\0~6q\0~:xsq\0~t\0\nTransitionsq\0~\0-S4q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0jq\0~Lt\0transition11pq\0~\0sq\0~\0\0q\0~\0sq\0~\0)q\0~Lt\0\0pq\0~(sq\0~\0q\0~(sq\0~\0hhq\0~Lt\0tool4pq\0~,sq\0~\0q\0~,sq\0~\0yq\0~Lt\0tool5pt\0	Conditionsq\0~1\0q\0~]sq\0~\0:q\0~Lt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0D!q\0~^q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~bxt\0Descriptionsq\0~\02\0q\0~fsq\0~\0ZPq\0~Lt\0\0t\0ExtendedAttributessq\0~\0\0q\0~jsq\0~\0oq\0~Lt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0t\\Yq\0~kt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~pt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0)Oq\0~pt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~uq\0~xxsq\0~Gt\0ExtendedAttributesq\0~\0?tq\0~kt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0.Ыq\0~|t\0JaWE_GRAPH_BREAK_POINTSpq\0~Psq\0~\0\0q\0~Psq\0~\0\"P\nq\0~|t\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~Qq\0~Tq\0~Wq\0~Zq\0~^q\0~gq\0~kxsq\0~t\0\nTransitionsq\0~\0!Z}q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0C@q\0~t\0transition12pq\0~\0sq\0~\0\0q\0~\0sq\0~\0vݵq\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0eW3q\0~t\0tool5pq\0~,sq\0~\0q\0~,sq\0~\0Naq\0~t\0\rapprove_claimpt\0	Conditionsq\0~1\0q\0~sq\0~\0{q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0]Nq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\07q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0?l$q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0,Iq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Nfq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\06)q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0Dzq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\03Qq\0~t\0transition10pq\0~\0sq\0~\0\0q\0~\0sq\0~\00q\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0>rq\0~t\0route1pq\0~,sq\0~\0q\0~,sq\0~\0=q\0~t\0tool3pt\0	Conditionsq\0~1\0q\0~sq\0~\0!q\0~t\0status===\'Resubmit\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0)Kkq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0Nq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0>+|q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0Vq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0Qzq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\03wpq\0~t\0transition13pq\0~\0sq\0~\0\0q\0~\0sq\0~\0hzq\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0\0Y:q\0~t\0tool3pq\0~,sq\0~\0q\0~,sq\0~\0aCq\0~t\0resubmitpt\0	Conditionsq\0~1\0q\0~sq\0~\0fq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0*fVq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0Meq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~\nsq\0~\0uq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0@qq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0if	q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0PLq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0Dq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\ra|q\0~t\0transition14pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\Z01q\0~t\0approvedpq\0~(sq\0~\0q\0~(sq\0~\0U:Xq\0~t\0route1pq\0~,sq\0~\0q\0~,sq\0~\0\nq\0~t\0tool6pt\0	Conditionsq\0~1\0q\0~.sq\0~\0amq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0f}q\0~/t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~3xt\0Descriptionsq\0~\02\0q\0~8sq\0~\0tq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~<sq\0~\0\'/kq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0JWq\0~=t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Qq3q\0~Bt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0j_q\0~Bt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~Gq\0~Jxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\"q\0~%q\0~(q\0~+q\0~/q\0~9q\0~=xsq\0~t\0\nTransitionsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0!%gq\0~Ot\0transition15pq\0~\0sq\0~\0\0q\0~\0sq\0~\0dzq\0~Ot\0\0pq\0~(sq\0~\0q\0~(sq\0~\0R?q\0~Ot\0tool6pq\0~,sq\0~\0q\0~,sq\0~\0\"q\0~Ot\0verify_claimpt\0	Conditionsq\0~1\0q\0~`sq\0~\0EȺq\0~Ot\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\Zzq\0~aq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~ext\0Descriptionsq\0~\02\0q\0~isq\0~\0hq\0~Ot\0\0t\0ExtendedAttributessq\0~\0\0q\0~msq\0~\0Z+q\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0F+{q\0~nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0dI*q\0~st\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0%ƺq\0~st\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~xq\0~{xxpxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~Wq\0~Zq\0~]q\0~aq\0~jq\0~nxsq\0~t\0\nTransitionsq\0~\0Iq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0|\rjq\0~t\0transition16pq\0~\0sq\0~\0\0q\0~\0sq\0~\00tq\0~t\0\0pq\0~(sq\0~\0q\0~(sq\0~\0&\Zq\0~t\0route1pq\0~,sq\0~\0q\0~,sq\0~\0q\0~t\0tool7pt\0	Conditionsq\0~1\0q\0~sq\0~\0%1q\0~t\0\Zstatus===\'Rejected by HOD\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0WFq\0~t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0\0mq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0dq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0/q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~Psq\0~\0\0q\0~Psq\0~\0\\Aq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0mNq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0\0WZq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0iCCq\0~t\0%JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDERpq\0~Psq\0~\0\0q\0~Psq\0~\0:pLq\0~t\0claimant;approver;financepxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0({q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\00Iq\0~t\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~Psq\0~\0\0q\0~Psq\0~\0F\\q\0~t\0JaWE_GRAPH_PARTICIPANT_ID=finance,CONNECTING_ACTIVITY_ID=tool2,X_OFFSET=758,Y_OFFSET=145,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0~^aLq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\02*q\0~t\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~Psq\0~\0\0q\0~Psq\0~\0H=q\0~t\0JaWE_GRAPH_PARTICIPANT_ID=finance,CONNECTING_ACTIVITY_ID=tool1,X_OFFSET=915,Y_OFFSET=57,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0;8q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\06@q\0~t\0JaWE_GRAPH_START_OF_WORKFLOWpq\0~Psq\0~\0\0q\0~Psq\0~\0KWq\0~t\0JaWE_GRAPH_PARTICIPANT_ID=claimant,CONNECTING_ACTIVITY_ID=new_claim,X_OFFSET=63,Y_OFFSET=53,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0/.gq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0D.hq\0~t\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~Psq\0~\0\0q\0~Psq\0~\0h!q\0~t\0JaWE_GRAPH_PARTICIPANT_ID=approver,CONNECTING_ACTIVITY_ID=tool7,X_OFFSET=865,Y_OFFSET=28,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~$q\0~*q\0~1q\0~8q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0m\'q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0ExtendedAttributesq\0~\0]rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0WR^	q\0~t\0EDITING_TOOLpq\0~Psq\0~\0\0q\0~Psq\0~\0>2q\0~t\0Web Workflow Designerpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~xsq\0~Gt\0ExtendedAttributesq\0~\0\"dq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0EDITING_TOOL_VERSIONpq\0~Psq\0~\0\0q\0~Psq\0~\0B-z6q\0~t\0\r5.0-pre-alphapxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~\0q\0~\0q\0~\0q\0~\0Iq\0~\0tq\0~\0q\0~\0q\0~\0q\0~\0q\0~Eq\0~q\0~q\0~x\0sq\0~\0w\0\0\0\0xt\01sr\0*org.enhydra.shark.xpdl.elements.Namespaces|<.R\0\0xq\0~\0kt\0\nNamespacessq\0~\0D {q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.Namespacez_\0\0xq\0~\0t\0	Namespacesq\0~\0PIXq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0cq\0~t\0xpdlpq\0~\0sq\0~\0q\0~\0sq\0~\02 q\0~t\0 http://www.wfmc.org/2002/XPDL1.0pxsq\0~\0E\0\0\0w\0\0\0q\0~#q\0~&xx',1000210,3,1000211,0),
('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Package xmlns=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" Id=\"isr\" Name=\"Internal Service Request\" xsi:schemaLocation=\"http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">\n    <PackageHeader>\n        <XPDLVersion>1.0</XPDLVersion>\n        <Vendor/>\n        <Created/>\n    </PackageHeader>\n    <Script Type=\"text/javascript\"/>\n    <Participants>\n        <Participant Id=\"requester\" Name=\"Requester\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"hod\" Name=\"HOD\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"assignee\" Name=\"Assignee\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n    </Participants>\n    <Applications>\n        <Application Id=\"default_application\"/>\n    </Applications>\n    <WorkflowProcesses>\n        <WorkflowProcess Id=\"isr\" Name=\"ISR Process\">\n            <ProcessHeader DurationUnit=\"h\"/>\n            <DataFields>\n                <DataField Id=\"status\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"attention\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"assignee\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n            </DataFields>\n            <Activities>\n                <Activity Id=\"resolve_request\" Name=\"Resolve Request\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>hod</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"hod\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"216,43.72727869677735\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"resolve_assigned_request\" Name=\"Resolve Request\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>assignee</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"assignee\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"568,21.51249999999999\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"send_rejected_notifiction\" Name=\"Send Rejected Notification\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"493,64.37500666308594\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route1\" Name=\"Route 1\">\n                    <Route/>\n                    <Performer>hod</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Join Type=\"XOR\"/>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition4\"/>\n                                    <TransitionRef Id=\"transition3\"/>\n                                    <TransitionRef Id=\"transition12\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"hod\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"392,49.72727869677735\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"verifiy_resolved_request\" Name=\"Verify Resolved Request\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Join Type=\"XOR\"/>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"834,27\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route2\" Name=\"Route 2\">\n                    <Route/>\n                    <Performer>requester</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition10\"/>\n                                    <TransitionRef Id=\"transition9\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"995,30.45453547167969\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"send_verified_notification\" Name=\"Send Verified Notification\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"963,132.3374816894531\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"resolve_reopened_request\" Name=\"Resolve Reopened Request\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>hod</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"hod\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"956,39.44319056201172\"/>\n                    </ExtendedAttributes>\n                </Activity>\n            </Activities>\n            <Transitions>\n                <Transition From=\"resolve_request\" Id=\"transition1\" To=\"route1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition3\" To=\"send_rejected_notifiction\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition4\" To=\"resolve_assigned_request\">\n                    <Condition Type=\"CONDITION\">status === \"Assigned\"</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"resolve_assigned_request\" Id=\"transition6\" To=\"verifiy_resolved_request\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"verifiy_resolved_request\" Id=\"transition8\" To=\"route2\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition9\" To=\"resolve_reopened_request\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition10\" To=\"send_verified_notification\">\n                    <Condition Type=\"CONDITION\">status === \"Verified\"</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition12\" To=\"verifiy_resolved_request\">\n                    <Condition Type=\"CONDITION\">status === \"Resolved\"</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_BREAK_POINTS\" Value=\"orthogonal\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"resolve_reopened_request\" Id=\"transition13\" To=\"route1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n            </Transitions>\n            <ExtendedAttributes>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER\" Value=\"hod;requester;assignee\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_START_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=resolve_request,X_OFFSET=257,Y_OFFSET=83,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=send_verified_notification,X_OFFSET=1156,Y_OFFSET=140,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=send_rejected_notifiction,X_OFFSET=671,Y_OFFSET=76,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n            </ExtendedAttributes>\n        </WorkflowProcess>\n    </WorkflowProcesses>\n    <ExtendedAttributes>\n        <ExtendedAttribute Name=\"EDITING_TOOL\" Value=\"Web Workflow Designer\"/>\n        <ExtendedAttribute Name=\"EDITING_TOOL_VERSION\" Value=\"5.0-pre-alpha\"/>\n    </ExtendedAttributes>\n</Package>\n','\0sr\0\'org.enhydra.shark.xpdl.elements.Package~+Vmŀ~\0Z\0isTransientL\0extPkgRefsToIdst\0.Lorg/enhydra/shark/utilities/SequencedHashMap;L\0internalVersiont\0Ljava/lang/String;L\0\nnamespacest\0,Lorg/enhydra/shark/xpdl/elements/Namespaces;xr\0(org.enhydra.shark.xpdl.XMLComplexElement>(\0\0xr\05org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex2\0L\0\nelementMapq\0~\0L\0elementst\0Ljava/util/ArrayList;xr\0!org.enhydra.shark.xpdl.XMLElement#+B#\0Z\0\nisReadOnlyZ\0\nisRequiredL\0nameq\0~\0L\0originalElementHashCodet\0Ljava/lang/Integer;L\0parentt\0#Lorg/enhydra/shark/xpdl/XMLElement;L\0valueq\0~\0xpt\0Packagesr\0java.lang.Integer⠤8\0I\0valuexr\0java.lang.Number\0\0xppt\0\0sr\0,org.enhydra.shark.utilities.SequencedHashMap.\"\"&\0\0xpw\0\0\0\rt\0Idsr\0#org.enhydra.shark.xpdl.XMLAttribute#c݀M;\0L\0choicesq\0~\0xq\0~\0q\0~\0sq\0~\0}\\q\0~\0\nt\0isrpt\0Namesq\0~\0\0q\0~\0sq\0~\0]yq\0~\0\nt\0Internal Service Requestpt\0\rPackageHeadersr\0-org.enhydra.shark.xpdl.elements.PackageHeaderv,\0\0xq\0~\0\0q\0~\0sq\0~\0P	\"Tq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0XPDLVersionsr\0+org.enhydra.shark.xpdl.elements.XPDLVersion\"}Y.w\0\0xr\0\'org.enhydra.shark.xpdl.XMLSimpleElementm\0\0xq\0~\0q\0~\0!sq\0~\08!q\0~\0t\01.0t\0Vendorsr\0&org.enhydra.shark.xpdl.elements.Vendor tE:\0\0xq\0~\0#q\0~\0\'sq\0~\00:q\0~\0t\0\0t\0Createdsr\0\'org.enhydra.shark.xpdl.elements.CreatedzdK|[\0\0xq\0~\0#q\0~\0,sq\0~\0Qsq\0~\0t\0\0t\0Descriptionsr\0+org.enhydra.shark.xpdl.elements.Description۰738\0\0xq\0~\0#\0q\0~\01sq\0~\0Hq\0~\0t\0\0t\0\rDocumentationsr\0-org.enhydra.shark.xpdl.elements.Documentation`9y\0\0xq\0~\0#\0q\0~\06sq\0~\08q\0~\0t\0\0t\0PriorityUnitsr\0,org.enhydra.shark.xpdl.elements.PriorityUnit\0\0xq\0~\0#\0q\0~\0;sq\0~\0giq\0~\0t\0\0t\0CostUnitsr\0(org.enhydra.shark.xpdl.elements.CostUnit܎=H\0\0xq\0~\0#\0q\0~\0@sq\0~\0\rdq\0~\0t\0\0xsr\0java.util.ArrayListxa\0I\0sizexp\0\0\0w\0\0\0q\0~\0$q\0~\0)q\0~\0.q\0~\03q\0~\08q\0~\0=q\0~\0Bxt\0RedefinableHeadersr\01org.enhydra.shark.xpdl.elements.RedefinableHeaderMϪ\'H\0\0xq\0~\0\0q\0~\0Gsq\0~\0j6\rBq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0PublicationStatussq\0~\0\0q\0~\0Msq\0~\0\nzq\0~\0It\0\0sq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0UNDER_REVISIONt\0RELEASEDt\0\nUNDER_TESTxt\0Authorsr\0&org.enhydra.shark.xpdl.elements.Author5fᧆ\0\0xq\0~\0#\0q\0~\0Usq\0~\0]q\0~\0It\0\0t\0Versionsr\0\'org.enhydra.shark.xpdl.elements.Version9=3~JQ\0\0xq\0~\0#\0q\0~\0Zsq\0~\0u7q\0~\0It\0\0t\0Codepagesr\0(org.enhydra.shark.xpdl.elements.Codepage9$me\rG\0\0xq\0~\0#\0q\0~\0_sq\0~\0/xq\0~\0It\0\0t\0\nCountrykeysr\0*org.enhydra.shark.xpdl.elements.Countrykey.\0\0xq\0~\0#\0q\0~\0dsq\0~\0p=q\0~\0It\0\0t\0Responsiblessr\0,org.enhydra.shark.xpdl.elements.Responsibles${S\0\0xr\0$org.enhydra.shark.xpdl.XMLCollectionjċm\0\0xq\0~\0\0q\0~\0isq\0~\0h+q\0~\0It\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0Nq\0~\0Wq\0~\0\\q\0~\0aq\0~\0fq\0~\0lxt\0ConformanceClasssr\00org.enhydra.shark.xpdl.elements.ConformanceClassy0|k\0\0xq\0~\0\0q\0~\0rsq\0~\0Dġq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0GraphConformancesq\0~\0\0q\0~\0xsq\0~\0\0:q\0~\0tq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0FULL_BLOCKEDt\0LOOP_BLOCKEDt\0NON_BLOCKEDxxsq\0~\0E\0\0\0w\0\0\0q\0~\0yxt\0Scriptsr\0&org.enhydra.shark.xpdl.elements.ScriptQjS8\0\0xq\0~\0\0q\0~\0sq\0~\0)iq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0Typesq\0~\0q\0~\0sq\0~\0!2_zq\0~\0t\0text/javascriptpt\0Versionsq\0~\0\0q\0~\0sq\0~\0@!q\0~\0t\0\0pt\0Grammarsq\0~\0\0q\0~\0sq\0~\0jq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExternalPackagessr\00org.enhydra.shark.xpdl.elements.ExternalPackagesw\"+Ũ\0\0xq\0~\0k\0q\0~\0sq\0~\0KPq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0TypeDeclarationssr\00org.enhydra.shark.xpdl.elements.TypeDeclarations\rOx5\0\0xq\0~\0k\0q\0~\0sq\0~\0x[q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Participantssr\0,org.enhydra.shark.xpdl.elements.Participantsh`g8J\0\0xq\0~\0k\0q\0~\0sq\0~\0y;q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Participanto$rc\0\0xr\0+org.enhydra.shark.xpdl.XMLCollectionElementCxvr\0\0xq\0~\0t\0Participantsq\0~\0(ӯq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0#\nq\0~\0t\0	requesterpq\0~\0sq\0~\0\0q\0~\0sq\0~\03&Gq\0~\0t\0	Requesterpt\0ParticipantTypesr\0/org.enhydra.shark.xpdl.elements.ParticipantType>n݅\0\0xq\0~\0q\0~\0sq\0~\0Fq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0jlcq\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0t\0RESOURCE_SETt\0RESOURCEt\0ROLEt\0ORGANIZATIONAL_UNITt\0HUMANt\0SYSTEMxxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0$TXq\0~\0t\0\0t\0ExternalReferencesr\01org.enhydra.shark.xpdl.elements.ExternalReferencebQ\0\0xq\0~\0\0q\0~\0sq\0~\0%(\0q\0~\0t\0\0sq\0~\0w\0\0\0t\0xrefsq\0~\0\0q\0~\0sq\0~\0+%Cq\0~\0t\0\0pt\0locationsq\0~\0q\0~\0sq\0~\0\"X8q\0~\0t\0\0pt\0	namespacesq\0~\0\0q\0~\0sq\0~\0Zq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExtendedAttributessr\02org.enhydra.shark.xpdl.elements.ExtendedAttributesOUF\0L\0extAttribsStringq\0~\0xq\0~\0k\0q\0~\0sq\0~\0yq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xsq\0~\0t\0Participantsq\0~\0q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Hq\0~\0t\0hodpq\0~\0sq\0~\0\0q\0~\0sq\0~\0=+[q\0~\0t\0HODpt\0ParticipantTypesq\0~\0q\0~\0sq\0~\0Qq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\03[Jq\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0X\0 q\0~\0t\0\0t\0ExternalReferencesq\0~\0\0q\0~\0sq\0~\0t`q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\025Tq\0~\0t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0[Sq\0~\0t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0K@q\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~	xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0TXqq\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~xsq\0~\0t\0Participantsq\0~\0|wq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0w\nq\0~t\0assigneepq\0~\0sq\0~\0\0q\0~\0sq\0~\0g^q\0~t\0Assigneept\0ParticipantTypesq\0~\0q\0~sq\0~\0S9NSq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0`q\0~ t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~$xt\0Descriptionsq\0~\02\0q\0~)sq\0~\0{hq\0~t\0\0t\0ExternalReferencesq\0~\0\0q\0~-sq\0~\0Zׇq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0CVq\0~.t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0Zyq\0~.t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0zzq\0~.t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~2q\0~5q\0~8xt\0ExtendedAttributessq\0~\0\0q\0~<sq\0~\0l`q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~ q\0~*q\0~.q\0~=xxt\0Applicationssr\0,org.enhydra.shark.xpdl.elements.Applications\0\0xq\0~\0k\0q\0~Csq\0~\0:%G!q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Applicationv	RS\0\0xq\0~\0t\0Applicationsq\0~\0B\'^q\0~Et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0s]>q\0~Kt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0Wuq\0~Kt\0\0pt\0Descriptionsq\0~\02\0q\0~Vsq\0~\0n~&q\0~Kt\0\0t\0Choicesr\00org.enhydra.shark.xpdl.elements.ApplicationTypes?!\0\0xr\0\'org.enhydra.shark.xpdl.XMLComplexChoice|\"\0L\0choicesq\0~\0L\0choosenq\0~\0	xq\0~\0q\0~Zsq\0~\0fCq\0~Kt\0\0sq\0~\0E\0\0\0w\0\0\0sr\00org.enhydra.shark.xpdl.elements.FormalParameterspBÁZ\0\0xq\0~\0k\0t\0FormalParameterssq\0~\0}aq\0~]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0\0t\0ExternalReferencesq\0~\0q\0~]t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\ZtJKq\0~ht\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0*8q\0~ht\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0_Sq\0~ht\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~mq\0~pq\0~sxxq\0~bt\0ExtendedAttributessq\0~\0\0q\0~wsq\0~\0o+\\^q\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Pq\0~Sq\0~Wq\0~]q\0~xxxt\0\nDataFieldssr\0*org.enhydra.shark.xpdl.elements.DataFieldsʦU\0\0xq\0~\0k\0q\0~~sq\0~\0v{q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0WorkflowProcessessr\01org.enhydra.shark.xpdl.elements.WorkflowProcessesp_0,\0\0xq\0~\0k\0q\0~sq\0~\0[q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0/org.enhydra.shark.xpdl.elements.WorkflowProcess%v0L\0\0xq\0~\0t\0WorkflowProcesssq\0~\0s݆q\0~t\0\0sq\0~\0w\0\0\0\rq\0~\0sq\0~\0q\0~\0sq\0~\0mKq\0~t\0isrpq\0~\0sq\0~\0\0q\0~\0sq\0~\08q\0~t\0ISR Processpt\0AccessLevelsq\0~\0\0q\0~sq\0~\0Y^-q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0PUBLICt\0PRIVATExt\0\rProcessHeadersr\0-org.enhydra.shark.xpdl.elements.ProcessHeaderLC-)\0\0xq\0~\0q\0~sq\0~\0Svq\0~t\0\0sq\0~\0w\0\0\0t\0DurationUnitsq\0~\0\0q\0~sq\0~\0>aq\0~t\0hsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0Yt\0Mt\0Dt\0ht\0mt\0sxt\0Createdsq\0~\0-\0q\0~sq\0~\0pbq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0Xyq\0~t\0\0t\0Prioritysr\0(org.enhydra.shark.xpdl.elements.Priority`Nn>b\0\0xq\0~\0#\0q\0~sq\0~\03~5#q\0~t\0\0t\0Limitsr\0%org.enhydra.shark.xpdl.elements.Limit1ӗ\0\0xq\0~\0#\0q\0~sq\0~\0\"1q\0~t\0\0t\0	ValidFromsr\0)org.enhydra.shark.xpdl.elements.ValidFromcŅ|L<\0\0xq\0~\0#\0q\0~sq\0~\0BoUq\0~t\0\0t\0ValidTosr\0\'org.enhydra.shark.xpdl.elements.ValidToM\0\0xq\0~\0#\0q\0~sq\0~\0Uiq\0~t\0\0t\0TimeEstimationsr\0.org.enhydra.shark.xpdl.elements.TimeEstimationŀ\'3\0\0xq\0~\0\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesr\0+org.enhydra.shark.xpdl.elements.WaitingTimeN/\0\0xq\0~\0#\0q\0~sq\0~\0=Iq\0~t\0\0t\0WorkingTimesr\0+org.enhydra.shark.xpdl.elements.WorkingTime~\0\0xq\0~\0#\0q\0~sq\0~\0q\0~t\0\0t\0Durationsr\0(org.enhydra.shark.xpdl.elements.Duration C\0\0xq\0~\0#\0q\0~sq\0~\0 6.*q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xt\0RedefinableHeadersq\0~\0H\0q\0~sq\0~\0h8q\0~t\0\0sq\0~\0w\0\0\0q\0~\0Msq\0~\0\0q\0~\0Msq\0~\0g1q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~\0Rq\0~\0Sq\0~\0Txt\0Authorsq\0~\0V\0q\0~sq\0~\0g;q\0~t\0\0t\0Versionsq\0~\0[\0q\0~sq\0~\01q\0~t\0\0t\0Codepagesq\0~\0`\0q\0~sq\0~\0sZq\0~t\0\0t\0\nCountrykeysq\0~\0e\0q\0~sq\0~\0%tq\0~t\0\0t\0Responsiblessq\0~\0j\0q\0~sq\0~\0w\\q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~xt\0FormalParameterssq\0~a\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nDataFieldssq\0~\0q\0~sq\0~\0>֙q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.DataFieldI3.~\0\0xq\0~\0t\0	DataFieldsq\0~\0fq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Oq\0~t\0statuspq\0~\0sq\0~\0\0q\0~\0sq\0~\0Aq\0~t\0\0pt\0IsArraysq\0~\0\0q\0~sq\0~\0GAWq\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0t\0TRUEt\0FALSExt\0DataTypesr\0(org.enhydra.shark.xpdl.elements.DataType\'4sM\0\0xq\0~\0q\0~ sq\0~\0Gq\0~t\0\0sq\0~\0w\0\0\0t\0	DataTypessr\0)org.enhydra.shark.xpdl.elements.DataTypespcH,!\0Z\0\risInitializedxq\0~\\q\0~&sq\0~\0G	q\0~\"t\0\0sq\0~\0E\0\0\0	w\0\0\0	sr\0)org.enhydra.shark.xpdl.elements.BasicType)w1\0\0xq\0~\0t\0	BasicTypesq\0~\09`q\0~(t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0k))q\0~-t\0STRINGsq\0~\0E\0\0\0w\0\0\0t\0STRINGt\0FLOATt\0INTEGERt\0	REFERENCEt\0DATETIMEt\0BOOLEANt\0	PERFORMERxxsq\0~\0E\0\0\0w\0\0\0q\0~2xsr\0,org.enhydra.shark.xpdl.elements.DeclaredTypedR.\\^9\0\0xq\0~\0t\0DeclaredTypesq\0~\0:q\0~(t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0.q\0~?t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Dxsr\0*org.enhydra.shark.xpdl.elements.SchemaType&1oSH\0\0xq\0~\0t\0\nSchemaTypesq\0~\0qyq\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0&q\0~(t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0b\'zq\0~Ot\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0q\0~Ot\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\04\0=q\0~Ot\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~Wq\0~Zxsr\0*org.enhydra.shark.xpdl.elements.RecordType%K\0\0\0xq\0~\0kt\0\nRecordTypesq\0~\0ugq\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.UnionType5PG\0\0xq\0~\0kt\0	UnionTypesq\0~\0&1q\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0/org.enhydra.shark.xpdl.elements.EnumerationTypef3b\0\0xq\0~\0kt\0EnumerationTypesq\0~\0>yq\0~(t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.ArrayTypeg$\0N@\0\0xq\0~\0t\0	ArrayTypesq\0~\0)0Qq\0~(t\0\0sq\0~\0w\0\0\0t\0\nLowerIndexsq\0~\0q\0~ysq\0~\0qNq\0~tt\0\0pt\0\nUpperIndexsq\0~\0q\0~}sq\0~\0/vq\0~tt\0\0pq\0~&sq\0~\'q\0~&sq\0~\0]=;q\0~tt\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~zq\0~~q\0~xsr\0(org.enhydra.shark.xpdl.elements.ListType\"ӟ\n\0\0xq\0~\0t\0ListTypesq\0~\0%oq\0~(t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0Cq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~-xsq\0~\0E\0\0\0w\0\0\0q\0~(xt\0InitialValuesr\0,org.enhydra.shark.xpdl.elements.InitialValuej,zR\0\0xq\0~\0#\0q\0~sq\0~\0zq\0~t\0\0t\0Lengthsr\0&org.enhydra.shark.xpdl.elements.LengthMW+-̩W\0\0xq\0~\0#\0q\0~sq\0~\0\nq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0(q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\04\rCq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~\Zq\0~\"q\0~q\0~q\0~q\0~xsq\0~\rt\0	DataFieldsq\0~\0L7q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0x\nq\0~t\0	attentionpq\0~\0sq\0~\0\0q\0~\0sq\0~\0QRq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0q\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xt\0DataTypesq\0~!q\0~sq\0~\0..q\0~t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0^mq\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~,t\0	BasicTypesq\0~\00hsq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0!pq\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~6q\0~7q\0~8q\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~>t\0DeclaredTypesq\0~\0yq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0QNq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~Ht\0\nSchemaTypesq\0~\0\'iq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0-q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0=cq\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0郁q\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0dFBq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~^t\0\nRecordTypesq\0~\09Ĝq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~et\0	UnionTypesq\0~\0W֊wq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~lt\0EnumerationTypesq\0~\0wq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~st\0	ArrayTypesq\0~\0Us9q\0~t\0\0sq\0~\0w\0\0\0q\0~ysq\0~\0q\0~ysq\0~\0:^/q\0~t\0\0pq\0~}sq\0~\0q\0~}sq\0~\0Yt(q\0~t\0\0pq\0~&sq\0~\'q\0~&sq\0~\0eKGq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~t\0ListTypesq\0~\0/q\0~t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesq\0~\0q\0~sq\0~\0ygq\0~t\0\0t\0Lengthsq\0~\0q\0~sq\0~\0A½q\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0v1aWq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\07xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~\rt\0	DataFieldsq\0~\0ziwq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0,oq\0~#t\0assigneepq\0~\0sq\0~\0\0q\0~\0sq\0~\0V\nq\0~#t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0ZEq\0~#t\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xt\0DataTypesq\0~!q\0~2sq\0~\0m{0q\0~#t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0sq\0~3t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~,t\0	BasicTypesq\0~\0\'fq\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0|Aq\0~;t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~6q\0~7q\0~8q\0~9q\0~:q\0~;q\0~<xxsq\0~\0E\0\0\0w\0\0\0q\0~@xsq\0~>t\0DeclaredTypesq\0~\0Mw0q\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{sq\0~Et\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Jxsq\0~Ht\0\nSchemaTypesq\0~\0q\0~7t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0?\rq\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0zlq\0~Tt\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0#vq\0~Tt\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0!q\0~Tt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~Yq\0~\\q\0~_xsq\0~^t\0\nRecordTypesq\0~\0Wq\0~7t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~et\0	UnionTypesq\0~\0v}q\0~7t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~lt\0EnumerationTypesq\0~\0vKq\0~7t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~st\0	ArrayTypesq\0~\0Xj	q\0~7t\0\0sq\0~\0w\0\0\0q\0~ysq\0~\0q\0~ysq\0~\0\'\'6q\0~ut\0\0pq\0~}sq\0~\0q\0~}sq\0~\0-ٯq\0~ut\0\0pq\0~&sq\0~\'q\0~&sq\0~\0rq\0~ut\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~zq\0~}q\0~xsq\0~t\0ListTypesq\0~\0q\0~7t\0\0sq\0~\0w\0\0\0q\0~&sq\0~\'q\0~&sq\0~\0uq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~;xsq\0~\0E\0\0\0w\0\0\0q\0~7xt\0InitialValuesq\0~\0q\0~sq\0~\0xs\0&q\0~#t\0\0t\0Lengthsq\0~\0q\0~sq\0~\0^A-q\0~#t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0=q*q\0~#t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\06NEq\0~#t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~(q\0~+q\0~.q\0~3q\0~q\0~q\0~q\0~xxt\0Participantssq\0~\0\0q\0~sq\0~\0 T2q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Applicationssq\0~D\0q\0~sq\0~\0*q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ActivitySetssr\0,org.enhydra.shark.xpdl.elements.ActivitySetsqV[4\0\0xq\0~\0k\0q\0~sq\0~\0Naq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nActivitiessr\0*org.enhydra.shark.xpdl.elements.Activities&G^lP\0\0xq\0~\0k\0q\0~sq\0~\0.sq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0(org.enhydra.shark.xpdl.elements.Activityt45\Z9\0\0xq\0~\0t\0Activitysq\0~\0U_q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0hq\0~t\0resolve_requestpq\0~\0sq\0~\0\0q\0~\0sq\0~\0\0%Fq\0~t\0Resolve Requestpt\0Descriptionsq\0~\02\0q\0~sq\0~\0qq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0$q\0~t\0\0q\0~\0sr\0-org.enhydra.shark.xpdl.elements.ActivityTypeseŽ{\0\0xq\0~\\q\0~\0sq\0~\0ANq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0%org.enhydra.shark.xpdl.elements.Route0e\rG\0\0xq\0~\0t\0Routesq\0~\0o=q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0.org.enhydra.shark.xpdl.elements.Implementationr^%\0\0xq\0~\0t\0Implementationsq\0~\0z<Eq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sr\03org.enhydra.shark.xpdl.elements.ImplementationTypes\rT١9\0\0xq\0~\\q\0~\0sq\0~\0cA|mq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0\"org.enhydra.shark.xpdl.elements.No{.\0\0xq\0~\0t\0Nosq\0~\01]q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0%org.enhydra.shark.xpdl.elements.ToolsCg\0\0xq\0~\0k\0t\0Toolssq\0~\0Aq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0\'org.enhydra.shark.xpdl.elements.SubFlow;Os7:$\0\0xq\0~\0t\0SubFlowsq\0~\0bq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\n|[q\0~t\0\0pt\0	Executionsq\0~\0\0q\0~sq\0~\0q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ASYNCHRt\0SYNCHRxt\0ActualParameterssr\00org.enhydra.shark.xpdl.elements.ActualParameters_K\0\0xq\0~\0k\0q\0~sq\0~\0gnq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsr\0-org.enhydra.shark.xpdl.elements.BlockActivityqcF\0\0xq\0~\0t\0\rBlockActivitysq\0~\0cq\0~t\0\0sq\0~\0w\0\0\0t\0BlockIdsq\0~\0q\0~sq\0~\0Zo1q\0~\rt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersr\0)org.enhydra.shark.xpdl.elements.Performer\"1%\0\0xq\0~\0#\0q\0~sq\0~\0d*(q\0~t\0hodt\0	StartModesr\0)org.enhydra.shark.xpdl.elements.StartModenhS\0\0xq\0~\0\0q\0~sq\0~\0`wq\0~t\0\0sq\0~\0w\0\0\0t\0Modesr\00org.enhydra.shark.xpdl.elements.StartFinishModes~6zX\'\0\0xq\0~\\\0q\0~\"sq\0~\0?Ǩ*q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0,org.enhydra.shark.xpdl.XMLEmptyChoiceElement2;3_\0\0xq\0~\0\0t\0XMLEmptyChoiceElementsq\0~\0sTq\0~$t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.Automatict?_\0\0xq\0~\0t\0	Automaticsq\0~\0+q\0~$t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0&org.enhydra.shark.xpdl.elements.Manualv[ؤ\0\0xq\0~\0t\0Manualsq\0~\0PXq\0~$t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~)xsq\0~\0E\0\0\0w\0\0\0q\0~$xt\0\nFinishModesr\0*org.enhydra.shark.xpdl.elements.FinishMode{\0\0xq\0~\0\0q\0~>sq\0~\0%q\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0q#q\0~@t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0z0q\0~Dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0aq\0~Dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0yߚGq\0~Dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Hxsq\0~\0E\0\0\0w\0\0\0q\0~Dxt\0Prioritysq\0~\0q\0~[sq\0~\06dq\0~t\0\0t\0	Deadlinessr\0)org.enhydra.shark.xpdl.elements.Deadlines>ɜ\0\0xq\0~\0k\0q\0~_sq\0~\0\";q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsr\05org.enhydra.shark.xpdl.elements.SimulationInformation\"|I\0\0xq\0~\0\0q\0~fsq\0~\0Jq\0~t\0\0sq\0~\0w\0\0\0t\0\rInstantiationsq\0~\0\0q\0~lsq\0~\0t0q\0~hq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ONCEt\0MULTIPLExt\0Costsr\0$org.enhydra.shark.xpdl.elements.Cost\0\0xq\0~\0#q\0~rsq\0~\0Dcq\0~ht\0\0t\0TimeEstimationsq\0~q\0~wsq\0~\0	)q\0~ht\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~|sq\0~\0u4q\0~xt\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0Imq\0~xt\0\0t\0Durationsq\0~\0q\0~sq\0~\0;q\0~xt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~}q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~mq\0~tq\0~xxt\0Iconsr\0$org.enhydra.shark.xpdl.elements.IconTU(}6\0\0xq\0~\0#\0q\0~sq\0~\0L)q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0`bq\0~t\0\0t\0TransitionRestrictionssr\06org.enhydra.shark.xpdl.elements.TransitionRestrictionsC)׀i;\0\0xq\0~\0k\0q\0~sq\0~\0<qq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\05-q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\01org.enhydra.shark.xpdl.elements.ExtendedAttribute\\F\0\0xq\0~\0t\0ExtendedAttributesq\0~\0Gq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0}q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpt\0Valuesq\0~\0\0q\0~sq\0~\0	q\0~t\0hodpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0B3q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\0q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0\rf0q\0~t\0216,43.72727869677735pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~@q\0~\\q\0~aq\0~hq\0~q\0~q\0~q\0~xsq\0~t\0Activitysq\0~\0z|q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Hq\0~t\0resolve_assigned_requestpq\0~\0sq\0~\0\0q\0~\0sq\0~\0hq\0~t\0Resolve Requestpt\0Descriptionsq\0~\02\0q\0~sq\0~\0Ɍq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0jq\0~t\0\0q\0~\0sq\0~q\0~\0sq\0~\0W<q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\00Oq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0h+Dq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0D|q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0\"Tq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0`3q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0VZ>$q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0%>q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0)q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0Ey`q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0BUzq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Zq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~	sq\0~\0q\0~t\0assigneet\0	StartModesq\0~\0q\0~\rsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0|#q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0nΔq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0O\Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0CGBq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~?\0q\0~)sq\0~\0Oq\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\04q\0~*t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0]}3q\0~.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0Vq\0~.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0T^q\0~.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~2xsq\0~\0E\0\0\0w\0\0\0q\0~.xt\0Prioritysq\0~\0q\0~Esq\0~\09!I&q\0~t\0\0t\0	Deadlinessq\0~`\0q\0~Isq\0~\0\rwq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~Osq\0~\0(uq\0~t\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0P!q\0~Pq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~Wsq\0~\0\'\"q\0~Pt\0\0t\0TimeEstimationsq\0~q\0~[sq\0~\0s+q\0~Pt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~`sq\0~\0P3q\0~\\t\0\0t\0WorkingTimesq\0~\0q\0~dsq\0~\0E~\"q\0~\\t\0\0t\0Durationsq\0~\0q\0~hsq\0~\0;fq\0~\\t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~aq\0~eq\0~ixxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~Xq\0~\\xt\0Iconsq\0~\0q\0~nsq\0~\07q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~rsq\0~\0yLq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~vsq\0~\0L7q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~|sq\0~\0\Z6Uq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0{Gq\0~}t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0S\\q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0Q<q\0~t\0assigneepxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0Vq\0~}t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0C>Eq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0Hq\0~t\0568,21.51249999999999pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~\nq\0~q\0~*q\0~Fq\0~Jq\0~Pq\0~oq\0~sq\0~wq\0~}xsq\0~t\0Activitysq\0~\0Vvq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0*J߬q\0~t\0send_rejected_notifictionpq\0~\0sq\0~\0\0q\0~\0sq\0~\0Nw1q\0~t\0\ZSend Rejected Notificationpt\0Descriptionsq\0~\02\0q\0~sq\0~\0}q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0c.q\0~t\0\0q\0~\0sq\0~q\0~\0sq\0~\0\0q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0uL>q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0	q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0>q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0;mq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0<q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0$org.enhydra.shark.xpdl.elements.Tool\\6&+G\0\0xq\0~\0t\0Toolsq\0~\02p[q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\\yPq\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\05Z>{q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0APPLICATIONt\0	PROCEDURExt\0ActualParameterssq\0~\0q\0~sq\0~\0|Lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0\rq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\08R1q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~t\0SubFlowsq\0~\0]wbq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0x,q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0^_gq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0>q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0]Wq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0+)Rq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0oq\0~t\0	requestert\0	StartModesq\0~\0q\0~sq\0~\0w\ZDq\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\08Bq\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0tuq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\07=Sq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0\rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~?\0q\0~(sq\0~\0O=q\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0\0q\0~)t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0\\yWq\0~-t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0vq\0~-t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0~Vq\0~-t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~1xsq\0~\0E\0\0\0w\0\0\0q\0~-xt\0Prioritysq\0~\0q\0~Dsq\0~\0sq\0~t\0\0t\0	Deadlinessq\0~`\0q\0~Hsq\0~\0e&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~Nsq\0~\0Uq\0~t\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0|q\0~Oq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~Vsq\0~\0^q\0~Ot\0\0t\0TimeEstimationsq\0~q\0~Zsq\0~\0 {q\0~Ot\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~_sq\0~\0 6q\0~[t\0\0t\0WorkingTimesq\0~\0q\0~csq\0~\0]q\0~[t\0\0t\0Durationsq\0~\0q\0~gsq\0~\0+~q\0~[t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~`q\0~dq\0~hxxsq\0~\0E\0\0\0w\0\0\0q\0~Sq\0~Wq\0~[xt\0Iconsq\0~\0q\0~msq\0~\0.?;q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~qsq\0~\0j^q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~usq\0~\0[q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~{sq\0~\0{mq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\02Dq\0~|t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0#q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0~2q\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\04q\0~|t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0!mq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\06sߤq\0~t\0493,64.37500666308594pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~	q\0~\rq\0~)q\0~Eq\0~Iq\0~Oq\0~nq\0~rq\0~vq\0~|xsq\0~t\0Activitysq\0~\0]Z#q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\06Lq\0~t\0route1pq\0~\0sq\0~\0\0q\0~\0sq\0~\09&q\0~t\0Route 1pt\0Descriptionsq\0~\02\0q\0~sq\0~\0Cbq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0k!oYq\0~t\0\0q\0~\0sq\0~q\0~\0sq\0~\0`q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\070q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0dq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0Cqq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0(Ђkq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0A(~q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0.q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\01|q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0)stq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0\Zwq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\Zq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0Ohq\0~t\0hodt\0	StartModesq\0~\0q\0~sq\0~\00q\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0NYq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0P/q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0@uq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0\rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~?\0q\0~sq\0~\07Ԝ.q\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0x`q\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0wfYq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0AWq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0%VHq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0Prioritysq\0~\0q\0~$sq\0~\0d/q\0~t\0\0t\0	Deadlinessq\0~`\0q\0~(sq\0~\0#4q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~.sq\0~\0D;~q\0~t\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0T.Qq\0~/q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~6sq\0~\0|q\0~/t\0\0t\0TimeEstimationsq\0~q\0~:sq\0~\0Iq\0~/t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~?sq\0~\0Q1q\0~;t\0\0t\0WorkingTimesq\0~\0q\0~Csq\0~\0|$q\0~;t\0\0t\0Durationsq\0~\0q\0~Gsq\0~\0xJŃq\0~;t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~@q\0~Dq\0~Hxxsq\0~\0E\0\0\0w\0\0\0q\0~3q\0~7q\0~;xt\0Iconsq\0~\0q\0~Msq\0~\0?q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~Qsq\0~\0f}cq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~Usq\0~\04\rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\05org.enhydra.shark.xpdl.elements.TransitionRestrictionN}\0\0xq\0~\0t\0TransitionRestrictionsq\0~\0:q\0~Vt\0\0sq\0~\0w\0\0\0t\0Joinsr\0$org.enhydra.shark.xpdl.elements.Joinڕөx)5\0\0xq\0~\0\0q\0~asq\0~\0YHq\0~\\t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0s2q\0~ct\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ANDt\0XORxxsq\0~\0E\0\0\0w\0\0\0q\0~gxt\0Splitsr\0%org.enhydra.shark.xpdl.elements.Split~ѯWS\0\0xq\0~\0\0q\0~nsq\0~\0&q\0~\\t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0^Vq\0~pt\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~kq\0~lxt\0TransitionRefssr\0.org.enhydra.shark.xpdl.elements.TransitionRefsъ\0\0xq\0~\0k\0q\0~xsq\0~\0q\0~pt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0-org.enhydra.shark.xpdl.elements.TransitionRef%-a\0\0xq\0~\0t\0\rTransitionRefsq\0~\0q\0~zt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0I6q\0~t\0transition4pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rTransitionRefsq\0~\0.)H:q\0~zt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0`aİq\0~t\0transition3pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rTransitionRefsq\0~\0!:q\0~zt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0!ӽq\0~t\0transition12pxsq\0~\0E\0\0\0w\0\0\0q\0~xxxsq\0~\0E\0\0\0w\0\0\0q\0~tq\0~zxxsq\0~\0E\0\0\0w\0\0\0q\0~cq\0~pxxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\09_q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0Gɕq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0xq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0yFq\0~t\0hodpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0jq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0KPq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0{q\0~t\0392,49.72727869677735pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~	q\0~%q\0~)q\0~/q\0~Nq\0~Rq\0~Vq\0~xsq\0~t\0Activitysq\0~\0,q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0verifiy_resolved_requestpq\0~\0sq\0~\0\0q\0~\0sq\0~\0Qq\0~t\0Verify Resolved Requestpt\0Descriptionsq\0~\02\0q\0~sq\0~\0\0q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\00tZq\0~t\0\0q\0~\0sq\0~q\0~\0sq\0~\0_Kq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0Rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0D޿q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0πiq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0Pq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0xIq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0al(q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0T\Z-q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0bguq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0nSq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~\nsq\0~\0iq\0~t\0	requestert\0	StartModesq\0~\0q\0~sq\0~\0m+*q\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\01[\Zq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0~v\Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0scLq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0iHq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~?\0q\0~*sq\0~\0Lq\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0.29q\0~+t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\03ƞq\0~/t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0ieq\0~/t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0zq\0~/t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~3xsq\0~\0E\0\0\0w\0\0\0q\0~/xt\0Prioritysq\0~\0q\0~Fsq\0~\0atq\0~t\0\0t\0	Deadlinessq\0~`\0q\0~Jsq\0~\0Uq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~Psq\0~\03q\0~t\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0.q\0~Qq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~Xsq\0~\0Aq\0~Qt\0\0t\0TimeEstimationsq\0~q\0~\\sq\0~\05gq\0~Qt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~asq\0~\0FUq\0~]t\0\0t\0WorkingTimesq\0~\0q\0~esq\0~\0U^q\0~]t\0\0t\0Durationsq\0~\0q\0~isq\0~\0E-q\0~]t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~bq\0~fq\0~jxxsq\0~\0E\0\0\0w\0\0\0q\0~Uq\0~Yq\0~]xt\0Iconsq\0~\0q\0~osq\0~\0q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~ssq\0~\08 q\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~wsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~[t\0TransitionRestrictionsq\0~\0T	q\0~xt\0\0sq\0~\0w\0\0\0t\0Joinsq\0~b\0q\0~sq\0~\0^5q\0~}t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\00cq\0~t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~kq\0~lxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Splitsq\0~o\0q\0~sq\0~\0͛q\0~}t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~kq\0~lxt\0TransitionRefssq\0~y\0q\0~sq\0~\0eN+q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0gX+q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0/#q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0s!n,q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0R\rq\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0iq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0?Oq\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0Gqq\0~t\0834,27pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~+q\0~Gq\0~Kq\0~Qq\0~pq\0~tq\0~xq\0~xsq\0~t\0Activitysq\0~\0CG,q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0g#q\0~t\0route2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\ZP`q\0~t\0Route 2pt\0Descriptionsq\0~\02\0q\0~sq\0~\0j|q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0 9!q\0~t\0\0q\0~\0sq\0~q\0~\0sq\0~\0Zq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0*q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0sLPq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0Z=)q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0Pq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0ZUq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0M]q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0xeq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0`6q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0aI#q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0)ڌq\0~	\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~	xxq\0~t\0	Performersq\0~\0q\0~		sq\0~\0<L,q\0~t\0	requestert\0	StartModesq\0~\0q\0~	\rsq\0~\0iGq\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0*y)Yq\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0Rsq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0F\'q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0z>\\q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xt\0\nFinishModesq\0~?\0q\0~	)sq\0~\06q\0~t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0=Yq\0~	*t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0JXq\0~	.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0Wjq\0~	.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0<~fZq\0~	.t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	2xsq\0~\0E\0\0\0w\0\0\0q\0~	.xt\0Prioritysq\0~\0q\0~	Esq\0~\0	Cq\0~t\0\0t\0	Deadlinessq\0~`\0q\0~	Isq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~	Osq\0~\0Qeq\0~t\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0KRq\0~	Pq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~	Wsq\0~\0_kq\0~	Pt\0\0t\0TimeEstimationsq\0~q\0~	[sq\0~\0FUq\0~	Pt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~	`sq\0~\0IYq\0~	\\t\0\0t\0WorkingTimesq\0~\0q\0~	dsq\0~\0)^q\0~	\\t\0\0t\0Durationsq\0~\0q\0~	hsq\0~\0b6,q\0~	\\t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~	aq\0~	eq\0~	ixxsq\0~\0E\0\0\0w\0\0\0q\0~	Tq\0~	Xq\0~	\\xt\0Iconsq\0~\0q\0~	nsq\0~\0n=2q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~	rsq\0~\0oq\0~t\0\0t\0TransitionRestrictionssq\0~\0q\0~	vsq\0~\03q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~[t\0TransitionRestrictionsq\0~\0<T/q\0~	wt\0\0sq\0~\0w\0\0\0t\0Joinsq\0~b\0q\0~	sq\0~\0Nq\0~	|t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Q{.q\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~kq\0~lxxsq\0~\0E\0\0\0w\0\0\0q\0~	xt\0Splitsq\0~o\0q\0~	sq\0~\0O~q\0~	|t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0W.Gq\0~	t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~kq\0~lxt\0TransitionRefssq\0~y\0q\0~	sq\0~\0O*q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0\rTransitionRefsq\0~\0gq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~	t\0transition10pxsq\0~\0E\0\0\0w\0\0\0q\0~	xsq\0~t\0\rTransitionRefsq\0~\0\0)q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0aUDq\0~	t\0transition9pxsq\0~\0E\0\0\0w\0\0\0q\0~	xxxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xxt\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\0`,q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0u,/q\0~	t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0/sq\0~	t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xsq\0~t\0ExtendedAttributesq\0~\0/<s3q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0DCq\0~	t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\08?+q\0~	t\0995,30.45453547167969pxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~	\nq\0~	q\0~	*q\0~	Fq\0~	Jq\0~	Pq\0~	oq\0~	sq\0~	wq\0~	xsq\0~t\0Activitysq\0~\0	q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0*q\0~	t\0\Zsend_verified_notificationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0E$uq\0~	t\0\ZSend Verified Notificationpt\0Descriptionsq\0~\02\0q\0~	sq\0~\0mq\0~	t\0\0t\0Limitsq\0~\0q\0~	sq\0~\0_6q\0~	t\0\0q\0~\0sq\0~q\0~\0sq\0~\08q5q\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0Y%dq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0saq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0aq\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0!62Wq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0PY2q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0&\Z1q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Gdq\0~	t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\00[q\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\n	sq\0~\0U>q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~\nsq\0~\0q\0~	t\0\0t\0ExtendedAttributessq\0~\0\0q\0~\nsq\0~\0-9%q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\n\nq\0~\nq\0~\nxxsq\0~t\0SubFlowsq\0~\0pmX%q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0	cq\0~\n\Zt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0،q\0~\n\Zq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\n%sq\0~\0tq\0~\n\Zt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\n\"q\0~\n&xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xsq\0~t\0\rBlockActivitysq\0~\0.cq\0~	t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\05{q\0~\n-t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\n2xxq\0~	t\0	Performersq\0~\0q\0~\n6sq\0~\0*Tq\0~	t\0	requestert\0	StartModesq\0~\0q\0~\n:sq\0~\0h.Јq\0~	t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0\0^q\0~\n;t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\076q\0~\n?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0}]~q\0~\n?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0%q\0~\n?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nCxsq\0~\0E\0\0\0w\0\0\0q\0~\n?xt\0\nFinishModesq\0~?\0q\0~\nVsq\0~\0Bǫq\0~	t\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0Aq\0~\nWt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0wq\0~\n[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0#zq\0~\n[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\07Dq\0~\n[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\n_xsq\0~\0E\0\0\0w\0\0\0q\0~\n[xt\0Prioritysq\0~\0q\0~\nrsq\0~\0o9vq\0~	t\0\0t\0	Deadlinessq\0~`\0q\0~\nvsq\0~\00q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~\n|sq\0~\0Elq\0~	t\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0j;q\0~\n}q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~\nsq\0~\0&psq\0~\n}t\0\0t\0TimeEstimationsq\0~q\0~\nsq\0~\0\":q\0~\n}t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\nsq\0~\0vYq\0~\nt\0\0t\0WorkingTimesq\0~\0q\0~\nsq\0~\0Jq\0~\nt\0\0t\0Durationsq\0~\0q\0~\nsq\0~\0W]q\0~\nt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxt\0Iconsq\0~\0q\0~\nsq\0~\0%[q\0~	t\0\0t\0\rDocumentationsq\0~\07\0q\0~\nsq\0~\0>q\0~	t\0\0t\0TransitionRestrictionssq\0~\0q\0~\nsq\0~\0\0hCq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\nsq\0~\0PB@q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0$Kq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0e!3q\0~\nt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0Xq\0~\nt\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxsq\0~t\0ExtendedAttributesq\0~\04Lq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0R!mq\0~\nt\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0lq\0~\nt\0963,132.3374816894531pxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxxpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	q\0~\n7q\0~\n;q\0~\nWq\0~\nsq\0~\nwq\0~\n}q\0~\nq\0~\nq\0~\nq\0~\nxsq\0~t\0Activitysq\0~\0\n0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0y{q\0~\nt\0resolve_reopened_requestpq\0~\0sq\0~\0\0q\0~\0sq\0~\08q\0~\nt\0Resolve Reopened Requestpt\0Descriptionsq\0~\02\0q\0~\nsq\0~\0b1\'q\0~\nt\0\0t\0Limitsq\0~\0q\0~\nsq\0~\0wrq\0~\nt\0\0q\0~\0sq\0~q\0~\0sq\0~\00~dq\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0?q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0lrq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0+hq\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0L14q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0lNq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0/q\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Dq\0~\nt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0tTq\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0Mq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~q\0~xxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~\nxsq\0~t\0\rBlockActivitysq\0~\0%HYq\0~\nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\\xq\0~\rt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~\nt\0	Performersq\0~\0q\0~sq\0~\0q\0~\nt\0hodt\0	StartModesq\0~\0q\0~\Zsq\0~\0GPq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0 *q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0_q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0[4)q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0iuq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~#xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~?\0q\0~6sq\0~\0K/Vpq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\"sq\0~#\0q\0~\"sq\0~\0q\0~7t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~(\0t\0XMLEmptyChoiceElementsq\0~\0\Z@q\0~;t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~/t\0	Automaticsq\0~\0\'	(q\0~;t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~6t\0Manualsq\0~\0D_=q\0~;t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~?xsq\0~\0E\0\0\0w\0\0\0q\0~;xt\0Prioritysq\0~\0q\0~Rsq\0~\0|Lq\0~\nt\0\0t\0	Deadlinessq\0~`\0q\0~Vsq\0~\0tLF7q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~g\0q\0~\\sq\0~\0q\0~\nt\0\0sq\0~\0w\0\0\0q\0~lsq\0~\0\0q\0~lsq\0~\0&q\0~]q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~pq\0~qxt\0Costsq\0~sq\0~dsq\0~\0PU}q\0~]t\0\0t\0TimeEstimationsq\0~q\0~hsq\0~\0FPq\0~]t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~msq\0~\0q\0~it\0\0t\0WorkingTimesq\0~\0q\0~qsq\0~\0\npq\0~it\0\0t\0Durationsq\0~\0q\0~usq\0~\0tq\0~it\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~nq\0~rq\0~vxxsq\0~\0E\0\0\0w\0\0\0q\0~aq\0~eq\0~ixt\0Iconsq\0~\0q\0~{sq\0~\0@[~q\0~\nt\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0g\0Qq\0~\nt\0\0t\0TransitionRestrictionssq\0~\0q\0~sq\0~\0V|7q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0XX%q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0,q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0X4Vlq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~sq\0~\0\0q\0~sq\0~\0Gq\0~t\0hodpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0$1eq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Y9q\0~t\0JaWE_GRAPH_OFFSETpq\0~sq\0~\0\0q\0~sq\0~\0#wZq\0~t\0956,39.44319056201172pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nq\0~\nq\0~\nq\0~q\0~q\0~7q\0~Sq\0~Wq\0~]q\0~|q\0~q\0~q\0~xxt\0Transitionssr\0+org.enhydra.shark.xpdl.elements.Transitions9>/i\0\0xq\0~\0k\0q\0~sq\0~\0l,0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0	w\0\0\0	sr\0*org.enhydra.shark.xpdl.elements.Transitiontx\0\0xq\0~\0t\0\nTransitionsq\0~\0Faq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0iqq\0~t\0transition1pq\0~\0sq\0~\0\0q\0~\0sq\0~\04Ҍq\0~t\0\0pt\0Fromsq\0~\0q\0~sq\0~\0Poq\0~t\0resolve_requestpt\0Tosq\0~\0q\0~sq\0~\07CDvq\0~t\0route1pt\0	Conditionsr\0)org.enhydra.shark.xpdl.elements.ConditionDZ;|\0\0xq\0~\0\0q\0~sq\0~\0A+q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\\nq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0	CONDITIONt\0	OTHERWISEt\0	EXCEPTIONt\0DEFAULTEXCEPTIONxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0qWq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Q5rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0M2q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0`9\\q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0Fq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0_Lq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Bq\0~t\0transition3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0(UNq\0~t\0\0pq\0~sq\0~\0q\0~sq\0~\0]q\0~t\0route1pq\0~sq\0~\0q\0~sq\0~\0s01q\0~t\0send_rejected_notifictionpt\0	Conditionsq\0~\0q\0~sq\0~\0@5q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\01kq\0~t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0G,q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0E\rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0=jX)q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\0q\0~\rt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0l\0Sq\0~\rt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0\\C0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\03mq\0~t\0JaWE_GRAPH_BREAK_POINTSpq\0~sq\0~\0\0q\0~sq\0~\0,q\0~t\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~!xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0xq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0IbZxq\0~&t\0transition4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0qmzq\0~&t\0\0pq\0~sq\0~\0q\0~sq\0~\0:dq\0~&t\0route1pq\0~sq\0~\0q\0~sq\0~\02q\0~&t\0resolve_assigned_requestpt\0	Conditionsq\0~\0q\0~7sq\0~\0nXq\0~&t\0status === \"Assigned\"sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0t6q\0~8t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~<xt\0Descriptionsq\0~\02\0q\0~Asq\0~\0zbq\0~&t\0\0t\0ExtendedAttributessq\0~\0\0q\0~Esq\0~\0gq\0~&t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0zlq\0~Ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0gZq\0~Kt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0Mq\0~Kt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~Pq\0~Sxsq\0~t\0ExtendedAttributesq\0~\0Yq\0~Ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Gwq\0~Wt\0JaWE_GRAPH_BREAK_POINTSpq\0~sq\0~\0\0q\0~sq\0~\0|y:q\0~Wt\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~\\q\0~_xxpxsq\0~\0E\0\0\0w\0\0\0q\0~+q\0~.q\0~1q\0~4q\0~8q\0~Bq\0~Fxsq\0~t\0\nTransitionsq\0~\0>6Tq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\02ػq\0~dt\0transition6pq\0~\0sq\0~\0\0q\0~\0sq\0~\06Aq\0~dt\0\0pq\0~sq\0~\0q\0~sq\0~\0:qq\0~dt\0resolve_assigned_requestpq\0~sq\0~\0q\0~sq\0~\0s$q\0~dt\0verifiy_resolved_requestpt\0	Conditionsq\0~\0q\0~usq\0~\08Z[iq\0~dt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\07,q\0~vq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~zxt\0Descriptionsq\0~\02\0q\0~~sq\0~\0(uKq\0~dt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0XQq\0~dt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0rmq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Vq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0rq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0j	q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0L$q\0~t\0JaWE_GRAPH_BREAK_POINTSpq\0~sq\0~\0\0q\0~sq\0~\0Rnq\0~t\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~iq\0~lq\0~oq\0~rq\0~vq\0~q\0~xsq\0~t\0\nTransitionsq\0~\00uq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\nq\0~t\0transition8pq\0~\0sq\0~\0\0q\0~\0sq\0~\0+q\0~t\0\0pq\0~sq\0~\0q\0~sq\0~\0qdTq\0~t\0verifiy_resolved_requestpq\0~sq\0~\0q\0~sq\0~\0Ylq\0~t\0route2pt\0	Conditionsq\0~\0q\0~sq\0~\0eC}Yq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\04Yq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0s2q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0t^ǵq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0xq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0xq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0.jĆq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0r7q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0+q\0~t\0transition9pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Pj0q\0~t\0\0pq\0~sq\0~\0q\0~sq\0~\0u!q\0~t\0route2pq\0~sq\0~\0q\0~sq\0~\0(sYq\0~t\0resolve_reopened_requestpt\0	Conditionsq\0~\0q\0~sq\0~\0nq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\08=4q\0~t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0s0]q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0uWq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0|q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0=dq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0Z\Zo1q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~t\0ExtendedAttributesq\0~\0u֎q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0>yq\0~\rt\0JaWE_GRAPH_BREAK_POINTSpq\0~sq\0~\0\0q\0~sq\0~\0wq\0~\rt\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~t\0\nTransitionsq\0~\0~ycq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0_\0q\0~\rt\0transition10pq\0~\0sq\0~\0\0q\0~\0sq\0~\0hKZq\0~\rt\0\0pq\0~sq\0~\0q\0~sq\0~\0}q\0~\rt\0route2pq\0~sq\0~\0q\0~sq\0~\0\0q\0~\rt\0\Zsend_verified_notificationpt\0	Conditionsq\0~\0q\0~\r!sq\0~\0]>nq\0~\rt\0status === \"Verified\"sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0e\ZPq\0~\r\"t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\r&xt\0Descriptionsq\0~\02\0q\0~\r+sq\0~\0%O\Zq\0~\rt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\r/sq\0~\0?tgq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0!/_q\0~\r0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0/q\0~\r5t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0>q\0~\r5t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\r:q\0~\r=xsq\0~t\0ExtendedAttributesq\0~\0*	q\0~\r0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0u߿q\0~\rAt\0JaWE_GRAPH_BREAK_POINTSpq\0~sq\0~\0\0q\0~sq\0~\0,q\0~\rAt\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~\rFq\0~\rIxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rq\0~\rq\0~\r\"q\0~\r,q\0~\r0xsq\0~t\0\nTransitionsq\0~\0[:q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Cq\0~\rNt\0transition12pq\0~\0sq\0~\0\0q\0~\0sq\0~\0̛q\0~\rNt\0\0pq\0~sq\0~\0q\0~sq\0~\0GɻTq\0~\rNt\0route1pq\0~sq\0~\0q\0~sq\0~\0Ob|q\0~\rNt\0verifiy_resolved_requestpt\0	Conditionsq\0~\0q\0~\r_sq\0~\0Qhq\0~\rNt\0status === \"Resolved\"sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0[ǎq\0~\r`t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\rdxt\0Descriptionsq\0~\02\0q\0~\risq\0~\0q\0~\rNt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rmsq\0~\0Tqzq\0~\rNt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0[q\0~\rnt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\Zq\0~\rst\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0Nq\0~\rst\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\rxq\0~\r{xsq\0~t\0ExtendedAttributesq\0~\0+yq\0~\rnt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0yhq\0~\rt\0JaWE_GRAPH_BREAK_POINTSpq\0~sq\0~\0\0q\0~sq\0~\0ni^q\0~\rt\0\northogonalpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rSq\0~\rVq\0~\rYq\0~\r\\q\0~\r`q\0~\rjq\0~\rnxsq\0~t\0\nTransitionsq\0~\0NL9q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\06q\0~\rt\0transition13pq\0~\0sq\0~\0\0q\0~\0sq\0~\0fMq\0~\rt\0\0pq\0~sq\0~\0q\0~sq\0~\0}p>q\0~\rt\0resolve_reopened_requestpq\0~sq\0~\0q\0~sq\0~\0Bq\0~\rt\0route1pt\0	Conditionsq\0~\0q\0~\rsq\0~\0\nq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0qq\0~\rq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0Descriptionsq\0~\02\0q\0~\rsq\0~\0p?aq\0~\rt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0fwq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0\'Jq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0+dq\0~\rt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~sq\0~\0\0q\0~sq\0~\0 f5q\0~\rt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rxxt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0h;q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0J(q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\0[q\0~\rt\0%JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDERpq\0~sq\0~\0\0q\0~sq\0~\0ȼ<q\0~\rt\0hod;requester;assigneepxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0E<q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~\rt\0JaWE_GRAPH_START_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0V/Sq\0~\rt\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=resolve_request,X_OFFSET=257,Y_OFFSET=83,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0~Pq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0.^q\0~\rt\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0}q\0~\rt\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=send_verified_notification,X_OFFSET=1156,Y_OFFSET=140,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxsq\0~t\0ExtendedAttributesq\0~\0YDq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0(J q\0~\rt\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~sq\0~\0\0q\0~sq\0~\0:mq\0~\rt\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=send_rejected_notifiction,X_OFFSET=671,Y_OFFSET=76,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~\rxxt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0}Qq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0ExtendedAttributesq\0~\0/;q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0u8^4q\0~\rt\0EDITING_TOOLpq\0~sq\0~\0\0q\0~sq\0~\0Aq\0~\rt\0Web Workflow Designerpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~xsq\0~t\0ExtendedAttributesq\0~\0,)q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0.Boq\0~t\0EDITING_TOOL_VERSIONpq\0~sq\0~\0\0q\0~sq\0~\05eq\0~t\0\r5.0-pre-alphapxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~\0q\0~\0q\0~\0q\0~\0Iq\0~\0tq\0~\0q\0~\0q\0~\0q\0~\0q\0~Eq\0~q\0~q\0~\rx\0sq\0~\0w\0\0\0\0xt\01sr\0*org.enhydra.shark.xpdl.elements.Namespaces|<.R\0\0xq\0~\0kt\0\nNamespacessq\0~\0mϬq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.Namespacez_\0\0xq\0~\0t\0	Namespacesq\0~\0cyq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0/4q\0~t\0xpdlpq\0~\0sq\0~\0q\0~\0sq\0~\0MYq\0~t\0 http://www.wfmc.org/2002/XPDL1.0pxsq\0~\0E\0\0\0w\0\0\0q\0~\"q\0~%xx',1000214,4,1000215,0),
('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Package xmlns=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" Id=\"JogetDxShowcase\" Name=\"Joget DX Showcase\" xsi:schemaLocation=\"http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">\n    <PackageHeader>\n        <XPDLVersion>1.0</XPDLVersion>\n        <Vendor/>\n        <Created/>\n    </PackageHeader>\n    <Script Type=\"text/javascript\"/>\n    <Participants>\n        <Participant Id=\"requester\" Name=\"requester\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"approver1\" Name=\"approver1\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"approver2\" Name=\"approver2\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n        <Participant Id=\"participant4\" Name=\"Participant 4\">\n            <ParticipantType Type=\"ROLE\"/>\n        </Participant>\n    </Participants>\n    <Applications>\n        <Application Id=\"default_application\"/>\n    </Applications>\n    <WorkflowProcesses>\n        <WorkflowProcess Id=\"process1\" Name=\"Process 1\">\n            <ProcessHeader DurationUnit=\"h\"/>\n            <DataFields>\n                <DataField Id=\"approvalStatus1\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"approvalStatus2\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"approverUsername1\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n                <DataField Id=\"approverUsername2\" IsArray=\"FALSE\">\n                    <DataType>\n                        <BasicType Type=\"STRING\"/>\n                    </DataType>\n                </DataField>\n            </DataFields>\n            <Activities>\n                <Activity Id=\"route1\">\n                    <Route/>\n                    <Performer>requester</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Join Type=\"XOR\"/>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"313.17047119140625,9\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route2\">\n                    <Route/>\n                    <Performer>approver1</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition4\"/>\n                                    <TransitionRef Id=\"transition8\"/>\n                                    <TransitionRef Id=\"transition15\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver1\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"462.352294921875,10\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"route3\">\n                    <Route/>\n                    <Performer>approver2</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Split Type=\"XOR\">\n                                <TransitionRefs>\n                                    <TransitionRef Id=\"transition11\"/>\n                                    <TransitionRef Id=\"transition12\"/>\n                                </TransitionRefs>\n                            </Split>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver2\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"626.75,10\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"email2\" Name=\"Email Notify Requester Resubmit\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <TransitionRestrictions>\n                        <TransitionRestriction>\n                            <Join Type=\"XOR\"/>\n                        </TransitionRestriction>\n                    </TransitionRestrictions>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"611.6375122070312,6\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"email3\" Name=\"Email Notify Approver2\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver2</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver2\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"296.63751220703125,5\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"email1\" Name=\"Email Notify Approver1\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"156,5\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"approver1\" Name=\"Pending Approver 1\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>approver1</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver1\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"288.8182067871094,5\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"approver2\" Name=\"Pending Approver 2\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>approver2</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver2\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"457.42047119140625,6\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"email4\" Name=\"Email Notify Requester Complete\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver2</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver2\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"766.25,6\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"resubmit\" Name=\"Requester to Resubmit\">\n                    <Implementation>\n                        <No/>\n                    </Implementation>\n                    <Performer>requester</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"requester\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"410.45458984375,6.988639831542969\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool5\" Name=\"Update Approver 2 Status\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver1</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver1\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"752,4\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"tool6\" Name=\"Email Notify Requester Rejected\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>approver1</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"approver1\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"754,82\"/>\n                    </ExtendedAttributes>\n                </Activity>\n            </Activities>\n            <Transitions>\n                <Transition From=\"email1\" Id=\"transition1\" To=\"route1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"approver1\" Id=\"transition3\" To=\"route2\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition4\" To=\"email2\">\n                    <Condition Type=\"CONDITION\">approvalStatus1 === \'Resubmit\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"PBUILDER_TRANSITION_CONDITIONS\" Value=\"[{&quot;join&quot;:&quot;&amp;&amp;&quot;,&quot;variable&quot;:&quot;approvalStatus1&quot;,&quot;operator&quot;:&quot;===&quot;,&quot;value&quot;:&quot;Resubmit&quot;}]\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"email2\" Id=\"transition5\" To=\"resubmit\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"resubmit\" Id=\"transition7\" To=\"route1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition8\" To=\"email3\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"email3\" Id=\"transition9\" To=\"approver2\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"approver2\" Id=\"transition10\" To=\"route3\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route1\" Id=\"transition13\" To=\"approver1\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route3\" Id=\"transition11\" To=\"email2\">\n                    <Condition Type=\"CONDITION\">approvalStatus2 === \'Resubmit\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"PBUILDER_TRANSITION_CONDITIONS\" Value=\"[{&quot;join&quot;:&quot;&amp;&amp;&quot;,&quot;variable&quot;:&quot;approvalStatus2&quot;,&quot;operator&quot;:&quot;===&quot;,&quot;value&quot;:&quot;Resubmit&quot;}]\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route3\" Id=\"transition12\" To=\"email4\">\n                    <Condition Type=\"OTHERWISE\"/>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"route2\" Id=\"transition15\" To=\"tool5\">\n                    <Condition Type=\"CONDITION\">approvalStatus1 === \'Rejected\'</Condition>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                        <ExtendedAttribute Name=\"PBUILDER_TRANSITION_CONDITIONS\" Value=\"[{&quot;join&quot;:&quot;&amp;&amp;&quot;,&quot;variable&quot;:&quot;approvalStatus1&quot;,&quot;operator&quot;:&quot;===&quot;,&quot;value&quot;:&quot;Rejected&quot;}]\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool5\" Id=\"transition16\" To=\"tool6\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n            </Transitions>\n            <ExtendedAttributes>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER\" Value=\"requester;approver1;approver2\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_START_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=email1,X_OFFSET=80,Y_OFFSET=18,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=approver2,CONNECTING_ACTIVITY_ID=email4,X_OFFSET=926,Y_OFFSET=17,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=approver1,CONNECTING_ACTIVITY_ID=tool6,X_OFFSET=912,Y_OFFSET=95,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n            </ExtendedAttributes>\n        </WorkflowProcess>\n        <WorkflowProcess Id=\"populateChart2\" Name=\"Populate Data For Charts\">\n            <ProcessHeader DurationUnit=\"h\"/>\n            <Activities>\n                <Activity Id=\"tool2\" Name=\"Populate Stock Data Tables\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>participant4</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"participant4\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"306.17047119140625,29\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"populateDataChart2\" Name=\"Populate Standard Data Tables\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>participant4</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"participant4\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"157,26.98863983154297\"/>\n                    </ExtendedAttributes>\n                </Activity>\n                <Activity Id=\"populateMeetingData\" Name=\"Populate Meeting Data\">\n                    <Implementation>\n                        <Tool Id=\"default_application\"/>\n                    </Implementation>\n                    <Performer>participant4</Performer>\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_PARTICIPANT_ID\" Value=\"participant4\"/>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_OFFSET\" Value=\"472.15277099609375,27\"/>\n                    </ExtendedAttributes>\n                </Activity>\n            </Activities>\n            <Transitions>\n                <Transition From=\"populateDataChart2\" Id=\"transition1\" To=\"tool2\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n                <Transition From=\"tool2\" Id=\"transition2\" To=\"populateMeetingData\">\n                    <ExtendedAttributes>\n                        <ExtendedAttribute Name=\"JaWE_GRAPH_TRANSITION_STYLE\" Value=\"NO_ROUTING_ORTHOGONAL\"/>\n                    </ExtendedAttributes>\n                </Transition>\n            </Transitions>\n            <ExtendedAttributes>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER\" Value=\"participant4\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_START_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=participant4,CONNECTING_ACTIVITY_ID=populateDataChart2,X_OFFSET=80,Y_OFFSET=40,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULT\"/>\n                <ExtendedAttribute Name=\"JaWE_GRAPH_END_OF_WORKFLOW\" Value=\"JaWE_GRAPH_PARTICIPANT_ID=participant4,CONNECTING_ACTIVITY_ID=populateMeetingData,X_OFFSET=615,Y_OFFSET=38,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULT\"/>\n            </ExtendedAttributes>\n        </WorkflowProcess>\n    </WorkflowProcesses>\n    <ExtendedAttributes>\n        <ExtendedAttribute Name=\"EDITING_TOOL\" Value=\"Web Workflow Designer\"/>\n        <ExtendedAttribute Name=\"EDITING_TOOL_VERSION\" Value=\"5.0-pre-alpha\"/>\n    </ExtendedAttributes>\n</Package>\n','\0sr\0\'org.enhydra.shark.xpdl.elements.Package~+Vmŀ~\0Z\0isTransientL\0extPkgRefsToIdst\0.Lorg/enhydra/shark/utilities/SequencedHashMap;L\0internalVersiont\0Ljava/lang/String;L\0\nnamespacest\0,Lorg/enhydra/shark/xpdl/elements/Namespaces;xr\0(org.enhydra.shark.xpdl.XMLComplexElement>(\0\0xr\05org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex2\0L\0\nelementMapq\0~\0L\0elementst\0Ljava/util/ArrayList;xr\0!org.enhydra.shark.xpdl.XMLElement#+B#\0Z\0\nisReadOnlyZ\0\nisRequiredL\0nameq\0~\0L\0originalElementHashCodet\0Ljava/lang/Integer;L\0parentt\0#Lorg/enhydra/shark/xpdl/XMLElement;L\0valueq\0~\0xpt\0Packagesr\0java.lang.Integer⠤8\0I\0valuexr\0java.lang.Number\0\0xpRfpt\0\0sr\0,org.enhydra.shark.utilities.SequencedHashMap.\"\"&\0\0xpw\0\0\0\rt\0Idsr\0#org.enhydra.shark.xpdl.XMLAttribute#c݀M;\0L\0choicesq\0~\0xq\0~\0q\0~\0sq\0~\0Y4q\0~\0\nt\0JogetDxShowcasept\0Namesq\0~\0\0q\0~\0sq\0~\0cLq\0~\0\nt\0Joget DX Showcasept\0\rPackageHeadersr\0-org.enhydra.shark.xpdl.elements.PackageHeaderv,\0\0xq\0~\0\0q\0~\0sq\0~\0_q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0XPDLVersionsr\0+org.enhydra.shark.xpdl.elements.XPDLVersion\"}Y.w\0\0xr\0\'org.enhydra.shark.xpdl.XMLSimpleElementm\0\0xq\0~\0q\0~\0!sq\0~\0 Xq\0~\0t\01.0t\0Vendorsr\0&org.enhydra.shark.xpdl.elements.Vendor tE:\0\0xq\0~\0#q\0~\0\'sq\0~\0bwq\0~\0t\0\0t\0Createdsr\0\'org.enhydra.shark.xpdl.elements.CreatedzdK|[\0\0xq\0~\0#q\0~\0,sq\0~\09$hgq\0~\0t\0\0t\0Descriptionsr\0+org.enhydra.shark.xpdl.elements.Description۰738\0\0xq\0~\0#\0q\0~\01sq\0~\0q\0~\0t\0\0t\0\rDocumentationsr\0-org.enhydra.shark.xpdl.elements.Documentation`9y\0\0xq\0~\0#\0q\0~\06sq\0~\0Lq\0~\0t\0\0t\0PriorityUnitsr\0,org.enhydra.shark.xpdl.elements.PriorityUnit\0\0xq\0~\0#\0q\0~\0;sq\0~\0AOq\0~\0t\0\0t\0CostUnitsr\0(org.enhydra.shark.xpdl.elements.CostUnit܎=H\0\0xq\0~\0#\0q\0~\0@sq\0~\0[6Aq\0~\0t\0\0xsr\0java.util.ArrayListxa\0I\0sizexp\0\0\0w\0\0\0q\0~\0$q\0~\0)q\0~\0.q\0~\03q\0~\08q\0~\0=q\0~\0Bxt\0RedefinableHeadersr\01org.enhydra.shark.xpdl.elements.RedefinableHeaderMϪ\'H\0\0xq\0~\0\0q\0~\0Gsq\0~\0I!q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0PublicationStatussq\0~\0\0q\0~\0Msq\0~\0]q\0~\0It\0\0sq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0UNDER_REVISIONt\0RELEASEDt\0\nUNDER_TESTxt\0Authorsr\0&org.enhydra.shark.xpdl.elements.Author5fᧆ\0\0xq\0~\0#\0q\0~\0Usq\0~\0q\0~\0It\0\0t\0Versionsr\0\'org.enhydra.shark.xpdl.elements.Version9=3~JQ\0\0xq\0~\0#\0q\0~\0Zsq\0~\0p8q\0~\0It\0\0t\0Codepagesr\0(org.enhydra.shark.xpdl.elements.Codepage9$me\rG\0\0xq\0~\0#\0q\0~\0_sq\0~\0$&a q\0~\0It\0\0t\0\nCountrykeysr\0*org.enhydra.shark.xpdl.elements.Countrykey.\0\0xq\0~\0#\0q\0~\0dsq\0~\0Uqq\0~\0It\0\0t\0Responsiblessr\0,org.enhydra.shark.xpdl.elements.Responsibles${S\0\0xr\0$org.enhydra.shark.xpdl.XMLCollectionjċm\0\0xq\0~\0\0q\0~\0isq\0~\0Ԥq\0~\0It\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0Nq\0~\0Wq\0~\0\\q\0~\0aq\0~\0fq\0~\0lxt\0ConformanceClasssr\00org.enhydra.shark.xpdl.elements.ConformanceClassy0|k\0\0xq\0~\0\0q\0~\0rsq\0~\08q\0~\0\nt\0\0sq\0~\0w\0\0\0t\0GraphConformancesq\0~\0\0q\0~\0xsq\0~\0/Mq\0~\0tq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0FULL_BLOCKEDt\0LOOP_BLOCKEDt\0NON_BLOCKEDxxsq\0~\0E\0\0\0w\0\0\0q\0~\0yxt\0Scriptsr\0&org.enhydra.shark.xpdl.elements.ScriptQjS8\0\0xq\0~\0\0q\0~\0sq\0~\0uq\0~\0\nt\0\0sq\0~\0w\0\0\0t\0Typesq\0~\0q\0~\0sq\0~\0\\}Kq\0~\0t\0text/javascriptpt\0Versionsq\0~\0\0q\0~\0sq\0~\0cq\0~\0t\0\0pt\0Grammarsq\0~\0\0q\0~\0sq\0~\0	,q\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExternalPackagessr\00org.enhydra.shark.xpdl.elements.ExternalPackagesw\"+Ũ\0\0xq\0~\0k\0q\0~\0sq\0~\0Kq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0TypeDeclarationssr\00org.enhydra.shark.xpdl.elements.TypeDeclarations\rOx5\0\0xq\0~\0k\0q\0~\0sq\0~\0kNR	q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Participantssr\0,org.enhydra.shark.xpdl.elements.Participantsh`g8J\0\0xq\0~\0k\0q\0~\0sq\0~\0\'q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Participanto$rc\0\0xr\0+org.enhydra.shark.xpdl.XMLCollectionElementCxvr\0\0xq\0~\0t\0Participantsq\0~\0uq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Dclq\0~\0t\0	requesterpq\0~\0sq\0~\0\0q\0~\0sq\0~\0KMq\0~\0t\0	requesterpt\0ParticipantTypesr\0/org.enhydra.shark.xpdl.elements.ParticipantType>n݅\0\0xq\0~\0q\0~\0sq\0~\0pq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{q\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0t\0RESOURCE_SETt\0RESOURCEt\0ROLEt\0ORGANIZATIONAL_UNITt\0HUMANt\0SYSTEMxxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0h1Yq\0~\0t\0\0t\0ExternalReferencesr\01org.enhydra.shark.xpdl.elements.ExternalReferencebQ\0\0xq\0~\0\0q\0~\0sq\0~\0!Fq\0~\0t\0\0sq\0~\0w\0\0\0t\0xrefsq\0~\0\0q\0~\0sq\0~\0u~q\0~\0t\0\0pt\0locationsq\0~\0q\0~\0sq\0~\0OEJq\0~\0t\0\0pt\0	namespacesq\0~\0\0q\0~\0sq\0~\0+BCq\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0xt\0ExtendedAttributessr\02org.enhydra.shark.xpdl.elements.ExtendedAttributesOUF\0L\0extAttribsStringq\0~\0xq\0~\0k\0q\0~\0sq\0~\06q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xsq\0~\0t\0Participantsq\0~\0!\nq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~\0t\0	approver1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0`q\0~\0t\0	approver1pt\0ParticipantTypesq\0~\0q\0~\0sq\0~\0<Iq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0d+Qq\0~\0t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Descriptionsq\0~\02\0q\0~\0sq\0~\0snOFq\0~\0t\0\0t\0ExternalReferencesq\0~\0\0q\0~\0sq\0~\0=^q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0?q\0~\0t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0\"|q\0~\0t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0#q\0~\0t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~	xt\0ExtendedAttributessq\0~\0\0q\0~\rsq\0~\0h0q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~xsq\0~\0t\0Participantsq\0~\02u?q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0eq\0~t\0	approver2pq\0~\0sq\0~\0\0q\0~\0sq\0~\01q\0~t\0	approver2pt\0ParticipantTypesq\0~\0q\0~sq\0~\0 Wq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{RJq\0~ t\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~$xt\0Descriptionsq\0~\02\0q\0~)sq\0~\0afcq\0~t\0\0t\0ExternalReferencesq\0~\0\0q\0~-sq\0~\04Iq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0+q\0~.t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0Bq\0~.t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\0ёq\0~.t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~2q\0~5q\0~8xt\0ExtendedAttributessq\0~\0\0q\0~<sq\0~\0fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~ q\0~*q\0~.q\0~=xsq\0~\0t\0Participantsq\0~\0coʡq\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0oq\0~Ct\0participant4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\rq\0~Ct\0\rParticipant 4pt\0ParticipantTypesq\0~\0q\0~Nsq\0~\02Iq\0~Ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0D;_q\0~Ot\0ROLEsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0q\0~\0xxsq\0~\0E\0\0\0w\0\0\0q\0~Sxt\0Descriptionsq\0~\02\0q\0~Xsq\0~\0Yˡq\0~Ct\0\0t\0ExternalReferencesq\0~\0\0q\0~\\sq\0~\0Tq\0~Ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0ZR(q\0~]t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0G~Pq\0~]t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0xЋq\0~]t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~aq\0~dq\0~gxt\0ExtendedAttributessq\0~\0\0q\0~ksq\0~\0$q\0~Ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Hq\0~Kq\0~Oq\0~Yq\0~]q\0~lxxt\0Applicationssr\0,org.enhydra.shark.xpdl.elements.Applications\0\0xq\0~\0k\0q\0~rsq\0~\0q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0+org.enhydra.shark.xpdl.elements.Applicationv	RS\0\0xq\0~\0t\0Applicationsq\0~\0^Nq\0~tt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\06q\0~zt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0Kq\0~zt\0\0pt\0Descriptionsq\0~\02\0q\0~sq\0~\0*]q\0~zt\0\0t\0Choicesr\00org.enhydra.shark.xpdl.elements.ApplicationTypes?!\0\0xr\0\'org.enhydra.shark.xpdl.XMLComplexChoice|\"\0L\0choicesq\0~\0L\0choosenq\0~\0	xq\0~\0q\0~sq\0~\0\n\rq\0~zt\0\0sq\0~\0E\0\0\0w\0\0\0sr\00org.enhydra.shark.xpdl.elements.FormalParameterspBÁZ\0\0xq\0~\0k\0t\0FormalParameterssq\0~\0{Q[q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0\0t\0ExternalReferencesq\0~\0R:oq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\"Ϟdq\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\00	q\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0GW<q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Eq\0~zt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxt\0\nDataFieldssr\0*org.enhydra.shark.xpdl.elements.DataFieldsʦU\0\0xq\0~\0k\0q\0~sq\0~\01߱|q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0WorkflowProcessessr\01org.enhydra.shark.xpdl.elements.WorkflowProcessesp_0,\0\0xq\0~\0k\0q\0~sq\0~\0(sTq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0/org.enhydra.shark.xpdl.elements.WorkflowProcess%v0L\0\0xq\0~\0t\0WorkflowProcesssq\0~\0Haq\0~t\0\0sq\0~\0w\0\0\0\rq\0~\0sq\0~\0q\0~\0sq\0~\0]eq\0~t\0process1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0#\'dq\0~t\0	Process 1pt\0AccessLevelsq\0~\0\0q\0~sq\0~\03tq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0PUBLICt\0PRIVATExt\0\rProcessHeadersr\0-org.enhydra.shark.xpdl.elements.ProcessHeaderLC-)\0\0xq\0~\0q\0~sq\0~\0lS:q\0~t\0\0sq\0~\0w\0\0\0t\0DurationUnitsq\0~\0\0q\0~sq\0~\0q\0~t\0hsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0Yt\0Mt\0Dt\0ht\0mt\0sxt\0Createdsq\0~\0-\0q\0~sq\0~\0 Jq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0t/\0q\0~t\0\0t\0Prioritysr\0(org.enhydra.shark.xpdl.elements.Priority`Nn>b\0\0xq\0~\0#\0q\0~sq\0~\0aLq\0~t\0\0t\0Limitsr\0%org.enhydra.shark.xpdl.elements.Limit1ӗ\0\0xq\0~\0#\0q\0~sq\0~\0a؃q\0~t\0\0t\0	ValidFromsr\0)org.enhydra.shark.xpdl.elements.ValidFromcŅ|L<\0\0xq\0~\0#\0q\0~sq\0~\0c<jq\0~t\0\0t\0ValidTosr\0\'org.enhydra.shark.xpdl.elements.ValidToM\0\0xq\0~\0#\0q\0~sq\0~\0kCq\0~t\0\0t\0TimeEstimationsr\0.org.enhydra.shark.xpdl.elements.TimeEstimationŀ\'3\0\0xq\0~\0\0q\0~sq\0~\0	Lq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesr\0+org.enhydra.shark.xpdl.elements.WaitingTimeN/\0\0xq\0~\0#\0q\0~\0sq\0~\0(Eq\0~t\0\0t\0WorkingTimesr\0+org.enhydra.shark.xpdl.elements.WorkingTime~\0\0xq\0~\0#\0q\0~sq\0~\0\nq\0~t\0\0t\0Durationsr\0(org.enhydra.shark.xpdl.elements.Duration C\0\0xq\0~\0#\0q\0~\nsq\0~\0}##q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~xt\0RedefinableHeadersq\0~\0H\0q\0~sq\0~\0Nq\0~t\0\0sq\0~\0w\0\0\0q\0~\0Msq\0~\0\0q\0~\0Msq\0~\0Hq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~\0Rq\0~\0Sq\0~\0Txt\0Authorsq\0~\0V\0q\0~sq\0~\0F\0q\0~t\0\0t\0Versionsq\0~\0[\0q\0~sq\0~\0w:dq\0~t\0\0t\0Codepagesq\0~\0`\0q\0~!sq\0~\0.tq\0~t\0\0t\0\nCountrykeysq\0~\0e\0q\0~%sq\0~\0j<Iq\0~t\0\0t\0Responsiblessq\0~\0j\0q\0~)sq\0~\0	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~\Zq\0~q\0~\"q\0~&q\0~*xt\0FormalParameterssq\0~\0q\0~0sq\0~\0]q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nDataFieldssq\0~\0q\0~6sq\0~\0@rq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.DataFieldI3.~\0\0xq\0~\0t\0	DataFieldsq\0~\0diq\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0pT?q\0~=t\0approvalStatus1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0}q\0~=t\0\0pt\0IsArraysq\0~\0\0q\0~Hsq\0~\0UVq\0~=t\0FALSEsq\0~\0E\0\0\0w\0\0\0t\0TRUEt\0FALSExt\0DataTypesr\0(org.enhydra.shark.xpdl.elements.DataType\'4sM\0\0xq\0~\0q\0~Osq\0~\0|y q\0~=t\0\0sq\0~\0w\0\0\0t\0	DataTypessr\0)org.enhydra.shark.xpdl.elements.DataTypespcH,!\0Z\0\risInitializedxq\0~q\0~Usq\0~\0nզq\0~Qt\0\0sq\0~\0E\0\0\0	w\0\0\0	sr\0)org.enhydra.shark.xpdl.elements.BasicType)w1\0\0xq\0~\0t\0	BasicTypesq\0~\0zpjq\0~Wt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0VTq\0~\\t\0STRINGsq\0~\0E\0\0\0w\0\0\0t\0STRINGt\0FLOATt\0INTEGERt\0	REFERENCEt\0DATETIMEt\0BOOLEANt\0	PERFORMERxxsq\0~\0E\0\0\0w\0\0\0q\0~axsr\0,org.enhydra.shark.xpdl.elements.DeclaredTypedR.\\^9\0\0xq\0~\0t\0DeclaredTypesq\0~\0	q\0~Wt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\09\0q\0~nt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~sxsr\0*org.enhydra.shark.xpdl.elements.SchemaType&1oSH\0\0xq\0~\0t\0\nSchemaTypesq\0~\0P&q\0~Wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0Sq\0~Wt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0l:q\0~~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0U3q\0~~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\04q\0~~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsr\0*org.enhydra.shark.xpdl.elements.RecordType%K\0\0\0xq\0~\0kt\0\nRecordTypesq\0~\0q\0~Wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.UnionType5PG\0\0xq\0~\0kt\0	UnionTypesq\0~\0t[,q\0~Wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0/org.enhydra.shark.xpdl.elements.EnumerationTypef3b\0\0xq\0~\0kt\0EnumerationTypesq\0~\0Wq\0~Wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.ArrayTypeg$\0N@\0\0xq\0~\0t\0	ArrayTypesq\0~\0hq\0~Wt\0\0sq\0~\0w\0\0\0t\0\nLowerIndexsq\0~\0q\0~sq\0~\0BΪGq\0~t\0\0pt\0\nUpperIndexsq\0~\0q\0~sq\0~\0kEq\0~t\0\0pq\0~Usq\0~Vq\0~Usq\0~\0;q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsr\0(org.enhydra.shark.xpdl.elements.ListType\"ӟ\n\0\0xq\0~\0t\0ListTypesq\0~\02\rCq\0~Wt\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\0&[iq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~\\xsq\0~\0E\0\0\0w\0\0\0q\0~Wxt\0InitialValuesr\0,org.enhydra.shark.xpdl.elements.InitialValuej,zR\0\0xq\0~\0#\0q\0~sq\0~\0@Ƈq\0~=t\0\0t\0Lengthsr\0&org.enhydra.shark.xpdl.elements.LengthMW+-̩W\0\0xq\0~\0#\0q\0~sq\0~\0&q\0~=t\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0D<:q\0~=t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0s&q\0~=t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Bq\0~Eq\0~Iq\0~Qq\0~q\0~q\0~q\0~xsq\0~<t\0	DataFieldsq\0~\05q\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0B)Pq\0~t\0approvalStatus2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0pPq\0~t\0\0pq\0~Hsq\0~\0\0q\0~Hsq\0~\0+}q\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Nxt\0DataTypesq\0~Pq\0~sq\0~\0fɂqq\0~t\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\0SzAq\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~[t\0	BasicTypesq\0~\0XDq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0<Gq\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~eq\0~fq\0~gq\0~hq\0~iq\0~jq\0~kxxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~mt\0DeclaredTypesq\0~\0Wq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~wt\0\nSchemaTypesq\0~\0Vgq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0RLq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0z,gq\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0gˌq\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0JBq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\rq\0~xsq\0~t\0\nRecordTypesq\0~\0zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	UnionTypesq\0~\0pUq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0EnumerationTypesq\0~\022q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	ArrayTypesq\0~\0Fq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0ĩq\0~&t\0\0pq\0~sq\0~\0q\0~sq\0~\0q\0~&t\0\0pq\0~Usq\0~Vq\0~Usq\0~\0Ldq\0~&t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~+q\0~.q\0~1xsq\0~t\0ListTypesq\0~\05hq\0~t\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\07#q\0~5t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~:xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesq\0~\0q\0~?sq\0~\07q\0~t\0\0t\0Lengthsq\0~\0q\0~Csq\0~\0hb\'q\0~t\0\0t\0Descriptionsq\0~\02\0q\0~Gsq\0~\0\\Rq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~Ksq\0~\0#q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~@q\0~Dq\0~Hq\0~Lxsq\0~<t\0	DataFieldsq\0~\0$!Eq\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Sqq\0~Rt\0approverUsername1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0r<q\0~Rt\0\0pq\0~Hsq\0~\0\0q\0~Hsq\0~\0¬gq\0~Rt\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Nxt\0DataTypesq\0~Pq\0~asq\0~\0=(q\0~Rt\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\0n\"q\0~bt\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~[t\0	BasicTypesq\0~\0fq\0~ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Nq\0~jt\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~eq\0~fq\0~gq\0~hq\0~iq\0~jq\0~kxxsq\0~\0E\0\0\0w\0\0\0q\0~oxsq\0~mt\0DeclaredTypesq\0~\01~Oq\0~ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Jrq\0~tt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~yxsq\0~wt\0\nSchemaTypesq\0~\0ۚ|q\0~ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\0:q\0~ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0@Ͽq\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0	[q\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0^8q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~t\0\nRecordTypesq\0~\0qәq\0~ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	UnionTypesq\0~\0/^Lq\0~ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0EnumerationTypesq\0~\0DQq\0~ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	ArrayTypesq\0~\0	Wq\0~ft\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0nxq\0~t\0\0pq\0~sq\0~\0q\0~sq\0~\0[\\q\0~t\0\0pq\0~Usq\0~Vq\0~Usq\0~\0U\\%q\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xsq\0~t\0ListTypesq\0~\0˴q\0~ft\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\03=Nq\0~t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~jxsq\0~\0E\0\0\0w\0\0\0q\0~fxt\0InitialValuesq\0~\0q\0~sq\0~\0%q\0~Rt\0\0t\0Lengthsq\0~\0q\0~sq\0~\0s\rqq\0~Rt\0\0t\0Descriptionsq\0~\02\0q\0~sq\0~\0ue?q\0~Rt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0,t\'q\0~Rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~Wq\0~Zq\0~]q\0~bq\0~q\0~q\0~q\0~xsq\0~<t\0	DataFieldsq\0~\0^lq\0~7t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0&kG\'q\0~t\0approverUsername2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Q q\0~t\0\0pq\0~Hsq\0~\0\0q\0~Hsq\0~\0-Vq\0~t\0FALSEsq\0~\0E\0\0\0w\0\0\0q\0~Mq\0~Nxt\0DataTypesq\0~Pq\0~sq\0~\0^eq\0~t\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\0DiLq\0~t\0\0sq\0~\0E\0\0\0	w\0\0\0	sq\0~[t\0	BasicTypesq\0~\0<q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0amq\0~t\0STRINGsq\0~\0E\0\0\0w\0\0\0q\0~eq\0~fq\0~gq\0~hq\0~iq\0~jq\0~kxxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~mt\0DeclaredTypesq\0~\0(49q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\"mq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~wt\0\nSchemaTypesq\0~\0~q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0ExternalReferencesq\0~\08~q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\01Nlq\0~t\0\0pq\0~\0sq\0~\0q\0~\0sq\0~\0}/q\0~t\0\0pq\0~\0sq\0~\0\0q\0~\0sq\0~\0,V4jq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	q\0~xsq\0~t\0\nRecordTypesq\0~\0wEiq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	UnionTypesq\0~\02q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0EnumerationTypesq\0~\02q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	ArrayTypesq\0~\0/wq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0svtq\0~\"t\0\0pq\0~sq\0~\0q\0~sq\0~\0oq\0~\"t\0\0pq\0~Usq\0~Vq\0~Usq\0~\0:bbq\0~\"t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~\'q\0~*q\0~-xsq\0~t\0ListTypesq\0~\06Xq\0~t\0\0sq\0~\0w\0\0\0q\0~Usq\0~Vq\0~Usq\0~\0req\0~1t\0\0ppxsq\0~\0E\0\0\0w\0\0\0q\0~6xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0InitialValuesq\0~\0q\0~;sq\0~\0 [q\0~t\0\0t\0Lengthsq\0~\0q\0~?sq\0~\0Iq\0~t\0\0t\0Descriptionsq\0~\02\0q\0~Csq\0~\0kq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~Gsq\0~\0Bpq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~<q\0~@q\0~Dq\0~Hxxt\0Participantssq\0~\0\0q\0~Nsq\0~\0HIGq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Applicationssq\0~s\0q\0~Tsq\0~\0zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ActivitySetssr\0,org.enhydra.shark.xpdl.elements.ActivitySetsqV[4\0\0xq\0~\0k\0q\0~Zsq\0~\0q/lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nActivitiessr\0*org.enhydra.shark.xpdl.elements.Activities&G^lP\0\0xq\0~\0k\0q\0~asq\0~\0\Z҉*q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0(org.enhydra.shark.xpdl.elements.Activityt45\Z9\0\0xq\0~\0t\0Activitysq\0~\0f53q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Gq\0~it\0route1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0-fRbq\0~it\0\0pt\0Descriptionsq\0~\02\0q\0~tsq\0~\0RÖq\0~it\0\0t\0Limitsq\0~\0q\0~xsq\0~\05MKq\0~it\0\0q\0~\0sr\0-org.enhydra.shark.xpdl.elements.ActivityTypeseŽ{\0\0xq\0~q\0~\0sq\0~\0:[|q\0~it\0\0sq\0~\0E\0\0\0w\0\0\0sr\0%org.enhydra.shark.xpdl.elements.Route0e\rG\0\0xq\0~\0t\0Routesq\0~\0%lq\0~}t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0.org.enhydra.shark.xpdl.elements.Implementationr^%\0\0xq\0~\0t\0Implementationsq\0~\007Dq\0~}t\0\0sq\0~\0w\0\0\0q\0~\0sr\03org.enhydra.shark.xpdl.elements.ImplementationTypes\rT١9\0\0xq\0~q\0~\0sq\0~\0hGq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0\"org.enhydra.shark.xpdl.elements.No{.\0\0xq\0~\0t\0Nosq\0~\0`ռ\"q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0%org.enhydra.shark.xpdl.elements.ToolsCg\0\0xq\0~\0k\0t\0Toolssq\0~\0\"q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0\'org.enhydra.shark.xpdl.elements.SubFlow;Os7:$\0\0xq\0~\0t\0SubFlowsq\0~\0,\\]q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0F	q\0~t\0\0pt\0	Executionsq\0~\0\0q\0~sq\0~\0q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ASYNCHRt\0SYNCHRxt\0ActualParameterssr\00org.enhydra.shark.xpdl.elements.ActualParameters_K\0\0xq\0~\0k\0q\0~sq\0~\01@!q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsr\0-org.enhydra.shark.xpdl.elements.BlockActivityqcF\0\0xq\0~\0t\0\rBlockActivitysq\0~\0_Dnq\0~}t\0\0sq\0~\0w\0\0\0t\0BlockIdsq\0~\0q\0~sq\0~\0qq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersr\0)org.enhydra.shark.xpdl.elements.Performer\"1%\0\0xq\0~\0#\0q\0~sq\0~\0^q\0~it\0	requestert\0	StartModesr\0)org.enhydra.shark.xpdl.elements.StartModenhS\0\0xq\0~\0\0q\0~sq\0~\0nàq\0~it\0\0sq\0~\0w\0\0\0t\0Modesr\00org.enhydra.shark.xpdl.elements.StartFinishModes~6zX\'\0\0xq\0~\0q\0~sq\0~\04q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sr\0,org.enhydra.shark.xpdl.XMLEmptyChoiceElement2;3_\0\0xq\0~\0\0t\0XMLEmptyChoiceElementsq\0~\0Bq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0)org.enhydra.shark.xpdl.elements.Automatict?_\0\0xq\0~\0t\0	Automaticsq\0~\0C\'q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsr\0&org.enhydra.shark.xpdl.elements.Manualv[ؤ\0\0xq\0~\0t\0Manualsq\0~\03y\\q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesr\0*org.enhydra.shark.xpdl.elements.FinishMode{\0\0xq\0~\0\0q\0~sq\0~\0\nq\0~it\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Lلq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Q7oq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0{q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0F(wq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0_q\0~it\0\0t\0	Deadlinessr\0)org.enhydra.shark.xpdl.elements.Deadlines>ɜ\0\0xq\0~\0k\0q\0~sq\0~\05Yq\0~it\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsr\05org.enhydra.shark.xpdl.elements.SimulationInformation\"|I\0\0xq\0~\0\0q\0~sq\0~\0\"-q\0~it\0\0sq\0~\0w\0\0\0t\0\rInstantiationsq\0~\0\0q\0~sq\0~\05q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ONCEt\0MULTIPLExt\0Costsr\0$org.enhydra.shark.xpdl.elements.Cost\0\0xq\0~\0#q\0~sq\0~\0i)6q\0~t\0\0t\0TimeEstimationsq\0~q\0~$sq\0~\0vR-q\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~)sq\0~\0Xq\0~%t\0\0t\0WorkingTimesq\0~\0q\0~-sq\0~\00{q\0~%t\0\0t\0Durationsq\0~\0q\0~1sq\0~\0L>q\0~%t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~*q\0~.q\0~2xxsq\0~\0E\0\0\0w\0\0\0q\0~\Zq\0~!q\0~%xt\0Iconsr\0$org.enhydra.shark.xpdl.elements.IconTU(}6\0\0xq\0~\0#\0q\0~7sq\0~\0^Zq\0~it\0\0t\0\rDocumentationsq\0~\07\0q\0~<sq\0~\0mcq\0~it\0\0t\0TransitionRestrictionssr\06org.enhydra.shark.xpdl.elements.TransitionRestrictionsC)׀i;\0\0xq\0~\0k\0q\0~@sq\0~\0q\0~it\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\05org.enhydra.shark.xpdl.elements.TransitionRestrictionN}\0\0xq\0~\0t\0TransitionRestrictionsq\0~\0Pq\0~Bt\0\0sq\0~\0w\0\0\0t\0Joinsr\0$org.enhydra.shark.xpdl.elements.Joinڕөx)5\0\0xq\0~\0\0q\0~Msq\0~\0wr^q\0~Ht\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0%Kq\0~Ot\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0ANDt\0XORxxsq\0~\0E\0\0\0w\0\0\0q\0~Sxt\0Splitsr\0%org.enhydra.shark.xpdl.elements.Split~ѯWS\0\0xq\0~\0\0q\0~Zsq\0~\0@Н_q\0~Ht\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0]})Iq\0~\\q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxt\0TransitionRefssr\0.org.enhydra.shark.xpdl.elements.TransitionRefsъ\0\0xq\0~\0k\0q\0~csq\0~\08ևq\0~\\t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~`q\0~exxsq\0~\0E\0\0\0w\0\0\0q\0~Oq\0~\\xxt\0ExtendedAttributessq\0~\0\0q\0~lsq\0~\0u}q\0~it\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\01org.enhydra.shark.xpdl.elements.ExtendedAttribute\\F\0\0xq\0~\0t\0ExtendedAttributesq\0~\0aq\0~mt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~st\0JaWE_GRAPH_PARTICIPANT_IDpt\0Valuesq\0~\0\0q\0~{sq\0~\0Woq\0~st\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~xq\0~|xsq\0~rt\0ExtendedAttributesq\0~\0Q(q\0~mt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0?=q\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\08q\0~t\0313.17047119140625,9pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~nq\0~qq\0~uq\0~yq\0~}q\0~q\0~q\0~q\0~	q\0~q\0~q\0~9q\0~=q\0~Bq\0~mxsq\0~ht\0Activitysq\0~\012q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Eq\0~t\0route2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~t\0\0pt\0Descriptionsq\0~\02\0q\0~sq\0~\0cȿq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0gq\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0M\Zq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0LLq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0)q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0;F\'q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0&Xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0@q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0FVq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0L+q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0Dq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0ö\Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0`nOq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0lq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0q\0~t\0	approver1t\0	StartModesq\0~\0q\0~sq\0~\0\n~q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0f!q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0\\q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0%q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0]Wq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0\nq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0S}q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0J#q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Vy|q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0c!q\0~\0t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~\0xt\0Prioritysq\0~\0q\0~sq\0~\0!Lq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~!sq\0~\02q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0J\Zq\0~\"q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~)sq\0~\0P\0q\0~\"t\0\0t\0TimeEstimationsq\0~q\0~-sq\0~\0=)iq\0~\"t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~2sq\0~\0WIq\0~.t\0\0t\0WorkingTimesq\0~\0q\0~6sq\0~\0lq\0~.t\0\0t\0Durationsq\0~\0q\0~:sq\0~\0;q\0~.t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~3q\0~7q\0~;xxsq\0~\0E\0\0\0w\0\0\0q\0~&q\0~*q\0~.xt\0Iconsq\0~8\0q\0~@sq\0~\0K0q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~Dsq\0~\0F~q\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~Hsq\0~\09?q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0TransitionRestrictionsq\0~\0\r1Wq\0~It\0\0sq\0~\0w\0\0\0t\0Joinsq\0~N\0q\0~Ssq\0~\0x(q\0~Nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Nq\0~Tq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxxsq\0~\0E\0\0\0w\0\0\0q\0~Xxt\0Splitsq\0~[\0q\0~\\sq\0~\0>q\0~Nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\">q\0~]t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxt\0TransitionRefssq\0~d\0q\0~esq\0~\0drq\0~]t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0-org.enhydra.shark.xpdl.elements.TransitionRef%-a\0\0xq\0~\0t\0\rTransitionRefsq\0~\0mq\0~ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Ơ1q\0~lt\0transition4pxsq\0~\0E\0\0\0w\0\0\0q\0~qxsq\0~kt\0\rTransitionRefsq\0~\08ʝq\0~ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0G%q\0~ut\0transition8pxsq\0~\0E\0\0\0w\0\0\0q\0~zxsq\0~kt\0\rTransitionRefsq\0~\0?\\q\0~ft\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\04q\0~~t\0transition15pxsq\0~\0E\0\0\0w\0\0\0q\0~xxxsq\0~\0E\0\0\0w\0\0\0q\0~aq\0~fxxsq\0~\0E\0\0\0w\0\0\0q\0~Tq\0~]xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0-Vk&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0GϪq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\08q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0|d7q\0~t\0	approver1pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0jCq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0>K\nq\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0o,:q\0~t\0462.352294921875,10pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~\"q\0~Aq\0~Eq\0~Iq\0~xsq\0~ht\0Activitysq\0~\03?Tq\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0]q\0~t\0route3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0aq\0~t\0\0pt\0Descriptionsq\0~\02\0q\0~sq\0~\0(q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0YAq\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0Sq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0Jouq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0)\"OBq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0/;q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0F:q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0wq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0Leq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0>q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0=c!q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0l q\0~t\0	approver2t\0	StartModesq\0~\0q\0~sq\0~\0kxq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Nq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0\"Bq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Jq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0kUVq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Ex^3q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0W/q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Eq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0`q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~2sq\0~\0[zoYq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~6sq\0~\0,+q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~<sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\01]q\0~=q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~Dsq\0~\096q\0~=t\0\0t\0TimeEstimationsq\0~q\0~Hsq\0~\0M@Aq\0~=t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~Msq\0~\0CSq\0~It\0\0t\0WorkingTimesq\0~\0q\0~Qsq\0~\0(q\0~It\0\0t\0Durationsq\0~\0q\0~Usq\0~\0q\0~It\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~Nq\0~Rq\0~Vxxsq\0~\0E\0\0\0w\0\0\0q\0~Aq\0~Eq\0~Ixt\0Iconsq\0~8\0q\0~[sq\0~\0y\r?q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~_sq\0~\0Mq\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~csq\0~\0mJq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0TransitionRestrictionsq\0~\0/@q\0~dt\0\0sq\0~\0w\0\0\0t\0Joinsq\0~N\0q\0~nsq\0~\0P|j6q\0~it\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0gMq\0~oq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxxsq\0~\0E\0\0\0w\0\0\0q\0~sxt\0Splitsq\0~[\0q\0~wsq\0~\0Jq\0~it\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0[u@%q\0~xt\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxt\0TransitionRefssq\0~d\0q\0~sq\0~\0h뼧q\0~xt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~kt\0\rTransitionRefsq\0~\0\n q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0?kq\0~t\0transition11pxsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~kt\0\rTransitionRefsq\0~\0v@q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{%rjq\0~t\0transition12pxsq\0~\0E\0\0\0w\0\0\0q\0~xxxsq\0~\0E\0\0\0w\0\0\0q\0~|q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~oq\0~xxxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0؏<q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0qƔq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\01=%mq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0Bq\0~t\0	approver2pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0\'q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0&7q\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0~xq\0~t\0	626.75,10pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~3q\0~7q\0~=q\0~\\q\0~`q\0~dq\0~xsq\0~ht\0Activitysq\0~\0{LAq\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Fq\0~t\0email2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0}2tq\0~t\0Email Notify Requester Resubmitpt\0Descriptionsq\0~\02\0q\0~sq\0~\0hxq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0Wq\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0N0q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0:&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0h?q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0kq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0\".kq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0(Xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0$org.enhydra.shark.xpdl.elements.Tool\\6&+G\0\0xq\0~\0t\0Toolsq\0~\0*q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\03\"q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0;͘q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0APPLICATIONt\0	PROCEDURExt\0ActualParameterssq\0~\0q\0~sq\0~\0Xq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0!#PYq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0v<hpq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~\0q\0~xxsq\0~t\0SubFlowsq\0~\0<|q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0^{q\0~\nt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0I~Ǟq\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0Oq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0\0Μ\"q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0mΏ>q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\"xxq\0~t\0	Performersq\0~\0q\0~&sq\0~\0R.q\0~t\0	requestert\0	StartModesq\0~\0q\0~*sq\0~\0`Bq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\08q\0~+t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0io{q\0~/t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0E[q\0~/t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Ztq\0~/t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~3xsq\0~\0E\0\0\0w\0\0\0q\0~/xt\0\nFinishModesq\0~\0q\0~Fsq\0~\0Pˤq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Zwq\0~Gt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0inq\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0!fq\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0\\ȇq\0~Kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Oxsq\0~\0E\0\0\0w\0\0\0q\0~Kxt\0Prioritysq\0~\0q\0~bsq\0~\0m~q\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~fsq\0~\0/Gq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~lsq\0~\0]T3q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0E9\";q\0~mq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~tsq\0~\0c@}q\0~mt\0\0t\0TimeEstimationsq\0~q\0~xsq\0~\02q\0~mt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~}sq\0~\0zC!q\0~yt\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0vq\0~yt\0\0t\0Durationsq\0~\0q\0~sq\0~\0lq\0~yt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~qq\0~uq\0~yxt\0Iconsq\0~8\0q\0~sq\0~\00q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0@%q\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~sq\0~\0\ZcRq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~Gt\0TransitionRestrictionsq\0~\0Rq\0~t\0\0sq\0~\0w\0\0\0t\0Joinsq\0~N\0q\0~sq\0~\0H\"q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0t_0q\0~t\0XORsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Splitsq\0~[\0q\0~sq\0~\09q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0,~+q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~Wq\0~Xxt\0TransitionRefssq\0~d\0q\0~sq\0~\0\rǟq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0qɳq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0eq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0:kq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0 pmq\0~t\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0EMuq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0]˺q\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0r$q\0~t\0611.6375122070312,6pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~\'q\0~+q\0~Gq\0~cq\0~gq\0~mq\0~q\0~q\0~q\0~xsq\0~ht\0Activitysq\0~\0TxNq\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Xo$q\0~t\0email3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Kq\0~t\0Email Notify Approver2pt\0Descriptionsq\0~\02\0q\0~sq\0~\0KIGq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0fְq\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0}\'Fq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0v4q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0_\rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0|q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\06q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0qq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0	Mq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\"q\0~		t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0PVq\0~		q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~	sq\0~\0`q\0~		t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~	\Zsq\0~\0iq\0~		t\0\0t\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\02ADq\0~		t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	xxsq\0~t\0SubFlowsq\0~\0FPiq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0VR@q\0~	%t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0F.q\0~	%q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~	0sq\0~\0q\0~	%t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~	*q\0~	-q\0~	1xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0^]q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\Z!q\0~	8t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~	=xxq\0~t\0	Performersq\0~\0q\0~	Asq\0~\0CSq\0~t\0	approver2t\0	StartModesq\0~\0q\0~	Esq\0~\0x\0q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0A nq\0~	Ft\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0lq\0~	Jt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0l1uq\0~	Jt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0N`q\0~	Jt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	Nxsq\0~\0E\0\0\0w\0\0\0q\0~	Jxt\0\nFinishModesq\0~\0q\0~	asq\0~\0t<q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0eq\0~	bt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0kRHq\0~	ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0IBq\0~	ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0RIYq\0~	ft\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~	jxsq\0~\0E\0\0\0w\0\0\0q\0~	fxt\0Prioritysq\0~\0q\0~	}sq\0~\0p\Zq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~	sq\0~\0	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~	sq\0~\02§q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0*:rq\0~	q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~	sq\0~\0caq\0~	t\0\0t\0TimeEstimationsq\0~q\0~	sq\0~\0cq\0~	t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~	sq\0~\04HOq\0~	t\0\0t\0WorkingTimesq\0~\0q\0~	sq\0~\0Hq\0~	t\0\0t\0Durationsq\0~\0q\0~	sq\0~\0Uh\0q\0~	t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	xxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	xt\0Iconsq\0~8\0q\0~	sq\0~\0U3q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~	sq\0~\0+v\'bq\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~	sq\0~\0[Iq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~	sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0Fy<q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0M`+q\0~	t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0`̖$q\0~	t\0	approver2pxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xsq\0~rt\0ExtendedAttributesq\0~\0:uq\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\04q\0~	t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0xq\0~	t\0296.63751220703125,5pxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~	Bq\0~	Fq\0~	bq\0~	~q\0~	q\0~	q\0~	q\0~	q\0~	q\0~	xsq\0~ht\0Activitysq\0~\0|9q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\0q\0~	t\0email1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Czq\0~	t\0Email Notify Approver1pt\0Descriptionsq\0~\02\0q\0~	sq\0~\0ךq\0~	t\0\0t\0Limitsq\0~\0q\0~	sq\0~\0-\n5q\0~	t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0Hq\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0u q\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0K[q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\075q\0~	t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0{Pq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0G$sq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0\0\0q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0<q\0~\nt\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0Iq\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\nsq\0~\0n^{q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~\nsq\0~\0.Xq\0~\nt\0\0t\0ExtendedAttributessq\0~\0\0q\0~\n\Zsq\0~\0jMq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~\n\nq\0~\n\rq\0~\nq\0~\nq\0~\nxxsq\0~t\0SubFlowsq\0~\0q\0~	t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0H\0>q\0~\n!t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0	q\0~\n!q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\n,sq\0~\0iDIq\0~\n!t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\n&q\0~\n)q\0~\n-xxq\0~	xsq\0~\0E\0\0\0w\0\0\0q\0~	xsq\0~t\0\rBlockActivitysq\0~\0Hm\'q\0~	t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\0kq\0~\n4t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\n9xxq\0~	t\0	Performersq\0~\0q\0~\n=sq\0~\0(iq\0~	t\0	requestert\0	StartModesq\0~\0q\0~\nAsq\0~\0Zhq\0~	t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0{q\0~\nBt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0/\'iq\0~\nFt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0~+q\0~\nFt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0aL5q\0~\nFt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nJxsq\0~\0E\0\0\0w\0\0\0q\0~\nFxt\0\nFinishModesq\0~\0q\0~\n]sq\0~\01q\0~	t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Ckq\0~\n^t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\00p\nq\0~\nbt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\03sq\0~\nbt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\05!q\0~\nbt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nfxsq\0~\0E\0\0\0w\0\0\0q\0~\nbxt\0Prioritysq\0~\0q\0~\nysq\0~\0;\0q\0~	t\0\0t\0	Deadlinessq\0~\r\0q\0~\n}sq\0~\0Zq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~\nsq\0~\0\"3q\0~	t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0GAq\0~\nq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~\nsq\0~\0*9q\0~\nt\0\0t\0TimeEstimationsq\0~q\0~\nsq\0~\0F$&q\0~\nt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\nsq\0~\0Xq\0~\nt\0\0t\0WorkingTimesq\0~\0q\0~\nsq\0~\0~q\0~\nt\0\0t\0Durationsq\0~\0q\0~\nsq\0~\0Uצxq\0~\nt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nxt\0Iconsq\0~8\0q\0~\nsq\0~\02$nq\0~	t\0\0t\0\rDocumentationsq\0~\07\0q\0~\nsq\0~\0\rq\0~	t\0\0t\0TransitionRestrictionssq\0~A\0q\0~\nsq\0~\0{lfq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\nsq\0~\0Eq\0~	t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0zq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\07\nq\0~\nt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0+q\0~\nt\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxsq\0~rt\0ExtendedAttributesq\0~\0PVjq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0mvq\0~\nt\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0,Đq\0~\nt\0156,5pxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nxxpxsq\0~\0E\0\0\0w\0\0\0q\0~	q\0~	q\0~	q\0~	q\0~	q\0~\n>q\0~\nBq\0~\n^q\0~\nzq\0~\n~q\0~\nq\0~\nq\0~\nq\0~\nq\0~\nxsq\0~ht\0Activitysq\0~\0\0gyq\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Uq\0~\nt\0	approver1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0e7q\0~\nt\0Pending Approver 1pt\0Descriptionsq\0~\02\0q\0~\nsq\0~\0tq\0~\nt\0\0t\0Limitsq\0~\0q\0~\nsq\0~\0q\0~\nt\0\0q\0~\0sq\0~|q\0~\0sq\0~\0 ۳q\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0x4q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0PMq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\03q\0~\nt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0Nq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\02q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0`mq\0~\nt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Wq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\08\"w(q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0)q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~	q\0~\rxxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~\nxsq\0~t\0\rBlockActivitysq\0~\0\Z\'q\0~\nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\07`q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~\nt\0	Performersq\0~\0q\0~sq\0~\0\Zjq\0~\nt\0	approver1t\0	StartModesq\0~\0q\0~!sq\0~\0AA&q\0~\nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\0q\0~\"t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0%Bq\0~&t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0QCq\0~&t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0aq\0~&t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~*xsq\0~\0E\0\0\0w\0\0\0q\0~&xt\0\nFinishModesq\0~\0q\0~=sq\0~\0Eq\0~\nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0tpq\0~>t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0z\nq\0~Bt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0q\0~Bt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\03\'q\0~Bt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Fxsq\0~\0E\0\0\0w\0\0\0q\0~Bxt\0Prioritysq\0~\0q\0~Ysq\0~\0oq\0~\nt\0\0t\0	Deadlinessq\0~\r\0q\0~]sq\0~\0/, q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~csq\0~\0!q\0~\nt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0%q\0~dq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~ksq\0~\0sF0q\0~dt\0\0t\0TimeEstimationsq\0~q\0~osq\0~\0m/q\0~dt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~tsq\0~\0Ccq\0~pt\0\0t\0WorkingTimesq\0~\0q\0~xsq\0~\0X=Lq\0~pt\0\0t\0Durationsq\0~\0q\0~|sq\0~\0\ZKq\0~pt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~uq\0~yq\0~}xxsq\0~\0E\0\0\0w\0\0\0q\0~hq\0~lq\0~pxt\0Iconsq\0~8\0q\0~sq\0~\0/q\0~\nt\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0 gq\0~\nt\0\0t\0TransitionRestrictionssq\0~A\0q\0~sq\0~\0Uq\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0i#q\0~\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0k~q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0(1q\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\04ghq\0~t\0	approver1pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0J\rq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0:]q\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0}q\0~t\0288.8182067871094,5pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\nq\0~\nq\0~\nq\0~\nq\0~q\0~\"q\0~>q\0~Zq\0~^q\0~dq\0~q\0~q\0~q\0~xsq\0~ht\0Activitysq\0~\0\'q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0=q\0~t\0	approver2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\"q\0~t\0Pending Approver 2pt\0Descriptionsq\0~\02\0q\0~sq\0~\0@/.q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0+\\q\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0tq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0Rdlq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0jJq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0!A)+q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0>\"q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0gMq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0Yq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0qGgq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0xq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0-=q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0L@q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0rq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0k\rq\0~t\0	approver2t\0	StartModesq\0~\0q\0~sq\0~\0.Jq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0N%Lq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0M8\nq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0KWrq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0}&Lq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\nxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0c\0q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0_@q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0ccq\0~\"t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0d^j3q\0~\"t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0M[q\0~\"t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~&xsq\0~\0E\0\0\0w\0\0\0q\0~\"xt\0Prioritysq\0~\0q\0~9sq\0~\09Oq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~=sq\0~\0Dɿiq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~Csq\0~\0SQJ1q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0=q\0~Dq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~Ksq\0~\0_Dq\0~Dt\0\0t\0TimeEstimationsq\0~q\0~Osq\0~\0V\"(q\0~Dt\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~Tsq\0~\0q\0~Pt\0\0t\0WorkingTimesq\0~\0q\0~Xsq\0~\0d\'`q\0~Pt\0\0t\0Durationsq\0~\0q\0~\\sq\0~\0 q\0~Pt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~Uq\0~Yq\0~]xxsq\0~\0E\0\0\0w\0\0\0q\0~Hq\0~Lq\0~Pxt\0Iconsq\0~8\0q\0~bsq\0~\038q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~fsq\0~\0/)q\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~jsq\0~\0\\4q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~psq\0~\0N@q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0oXAq\0~qt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0h[q\0~vt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0D#q\0~vt\0	approver2pxsq\0~\0E\0\0\0w\0\0\0q\0~{q\0~~xsq\0~rt\0ExtendedAttributesq\0~\0`{\rq\0~qt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0OfOq\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0xq\0~t\0457.42047119140625,6pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~:q\0~>q\0~Dq\0~cq\0~gq\0~kq\0~qxsq\0~ht\0Activitysq\0~\0S!q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0gIq\0~t\0email4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0=Hq\0~t\0Email Notify Requester Completept\0Descriptionsq\0~\02\0q\0~sq\0~\0>q\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0bq\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0F3q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0~q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0+/&7q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0B:q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0+}q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0Dnq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Hq\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0rq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\08{q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0}_Aq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0L8;q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~t\0SubFlowsq\0~\0Zq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Xaq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0dq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0hZq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0$Zq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0^Xq\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0N鑁q\0~t\0	approver2t\0	StartModesq\0~\0q\0~sq\0~\0vEq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0eMq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Xmq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0orM^q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0e~q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\rxsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0\nFinishModesq\0~\0q\0~\rsq\0~\0fb(q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Z;[cq\0~\r\Zt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0.ݒq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0~*oq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\r\"xsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0Prioritysq\0~\0q\0~\r5sq\0~\0K9;wq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~\r9sq\0~\0	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~\r?sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0\'`qq\0~\r@q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~\rGsq\0~\0q\0~\r@t\0\0t\0TimeEstimationsq\0~q\0~\rKsq\0~\0}q\0~\r@t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~\rPsq\0~\0FNdq\0~\rLt\0\0t\0WorkingTimesq\0~\0q\0~\rTsq\0~\0aMq\0~\rLt\0\0t\0Durationsq\0~\0q\0~\rXsq\0~\0Gqq\0~\rLt\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~\rQq\0~\rUq\0~\rYxxsq\0~\0E\0\0\0w\0\0\0q\0~\rDq\0~\rHq\0~\rLxt\0Iconsq\0~8\0q\0~\r^sq\0~\0ToMq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~\rbsq\0~\0a0A}q\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~\rfsq\0~\0mw.q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~\rlsq\0~\0Iq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0Fr!q\0~\rmt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0qnq\0~\rrt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\04q\0~\rrt\0	approver2pxsq\0~\0E\0\0\0w\0\0\0q\0~\rwq\0~\rzxsq\0~rt\0ExtendedAttributesq\0~\0eq\0~\rmt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0_b#q\0~\r~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\09+-q\0~\r~t\0766.25,6pxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~\r\Zq\0~\r6q\0~\r:q\0~\r@q\0~\r_q\0~\rcq\0~\rgq\0~\rmxsq\0~ht\0Activitysq\0~\0I	q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0#PϞq\0~\rt\0resubmitpq\0~\0sq\0~\0\0q\0~\0sq\0~\0Lݐq\0~\rt\0Requester to Resubmitpt\0Descriptionsq\0~\02\0q\0~\rsq\0~\0hHp]q\0~\rt\0\0t\0Limitsq\0~\0q\0~\rsq\0~\0PY:q\0~\rt\0\0q\0~\0sq\0~|q\0~\0sq\0~\0cq\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\09Iq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0q\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0܍q\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\00(B3q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0tMq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0SubFlowsq\0~\0Gqq\0~\rt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0	)!q\0~\rt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0{bzq\0~\rq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\rsq\0~\0q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rxxq\0~\rxsq\0~\0E\0\0\0w\0\0\0q\0~\rxsq\0~t\0\rBlockActivitysq\0~\0/7Hq\0~\rt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0oq\0~\rt\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~\rxxq\0~\rt\0	Performersq\0~\0q\0~\rsq\0~\0\nq\0~\rt\0	requestert\0	StartModesq\0~\0q\0~\rsq\0~\0\n8:q\0~\rt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0,5Bq\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0.q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0<gq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Aq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~\rxsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0\nFinishModesq\0~\0q\0~\rsq\0~\0̐q\0~\rt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0~\03>q\0~\rt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Tq\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0U9q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0^q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~\rxt\0Prioritysq\0~\0q\0~sq\0~\0{$q\0~\rt\0\0t\0	Deadlinessq\0~\r\0q\0~sq\0~\0	q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0q\0~\rt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0y=Kq\0~ q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~\'sq\0~\0+q\0~ t\0\0t\0TimeEstimationsq\0~q\0~+sq\0~\0-Sq\0~ t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~0sq\0~\0usq\0~,t\0\0t\0WorkingTimesq\0~\0q\0~4sq\0~\0ahq\0~,t\0\0t\0Durationsq\0~\0q\0~8sq\0~\0/,q\0~,t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~1q\0~5q\0~9xxsq\0~\0E\0\0\0w\0\0\0q\0~$q\0~(q\0~,xt\0Iconsq\0~8\0q\0~>sq\0~\0xq\0~\rt\0\0t\0\rDocumentationsq\0~\07\0q\0~Bsq\0~\0l^q\0~\rt\0\0t\0TransitionRestrictionssq\0~A\0q\0~Fsq\0~\0K1q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~Lsq\0~\0<q\0~\rt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\08q\0~Mt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\08?0q\0~Rt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0rq\0~Rt\0	requesterpxsq\0~\0E\0\0\0w\0\0\0q\0~Wq\0~Zxsq\0~rt\0ExtendedAttributesq\0~\0Oʤoq\0~Mt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0IES7q\0~^t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0rq\0~^t\0!410.45458984375,6.988639831542969pxsq\0~\0E\0\0\0w\0\0\0q\0~cq\0~fxxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~\rq\0~q\0~\Zq\0~ q\0~?q\0~Cq\0~Gq\0~Mxsq\0~ht\0Activitysq\0~\0q\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0֌q\0~kt\0tool5pq\0~\0sq\0~\0\0q\0~\0sq\0~\0\rJ!q\0~kt\0Update Approver 2 Statuspt\0Descriptionsq\0~\02\0q\0~vsq\0~\0nq\0~kt\0\0t\0Limitsq\0~\0q\0~zsq\0~\0O\n^q\0~kt\0\0q\0~\0sq\0~|q\0~\0sq\0~\0;q\0~kt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0L@q\0~~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0\nNSq\0~~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0Jq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0E@q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0\\q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0&}0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Sq\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0:2ߗq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0yq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0d\\k>q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0+q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~t\0SubFlowsq\0~\0u`q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0j0q\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0(1q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0m!\\q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0Gqvq\0~~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0)(q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0/N`q\0~kt\0	approver1t\0	StartModesq\0~\0q\0~sq\0~\0[uq\0~kt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\04q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0#7%q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0pq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0<Pq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0sNq\0~kt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0iΌq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\07\'q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0$G\\q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0\Z	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~sq\0~\0\'pq\0~kt\0\0t\0	Deadlinessq\0~\r\0q\0~sq\0~\0-\'xq\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\04IIq\0~kt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0~q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~#sq\0~\0\\6q\0~t\0\0t\0TimeEstimationsq\0~q\0~\'sq\0~\0Xq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~,sq\0~\0&q\0~(t\0\0t\0WorkingTimesq\0~\0q\0~0sq\0~\0dHq\0~(t\0\0t\0Durationsq\0~\0q\0~4sq\0~\0QUq\0~(t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~-q\0~1q\0~5xxsq\0~\0E\0\0\0w\0\0\0q\0~ q\0~$q\0~(xt\0Iconsq\0~8\0q\0~:sq\0~\01bq\0~kt\0\0t\0\rDocumentationsq\0~\07\0q\0~>sq\0~\0`Dq\0~kt\0\0t\0TransitionRestrictionssq\0~A\0q\0~Bsq\0~\0hOq\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~Hsq\0~\03P\rqq\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0mW*q\0~It\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0U/q\0~Nt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\08΢q\0~Nt\0	approver1pxsq\0~\0E\0\0\0w\0\0\0q\0~Sq\0~Vxsq\0~rt\0ExtendedAttributesq\0~\0{.Aq\0~It\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0{&q\0~Zt\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0&q\0~Zt\0752,4pxsq\0~\0E\0\0\0w\0\0\0q\0~_q\0~bxxpxsq\0~\0E\0\0\0w\0\0\0q\0~pq\0~sq\0~wq\0~{q\0~~q\0~q\0~q\0~q\0~q\0~q\0~q\0~;q\0~?q\0~Cq\0~Ixsq\0~ht\0Activitysq\0~\0kQq\0~ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0[(q\0~gt\0tool6pq\0~\0sq\0~\0\0q\0~\0sq\0~\0>cq\0~gt\0Email Notify Requester Rejectedpt\0Descriptionsq\0~\02\0q\0~rsq\0~\0uOq\0~gt\0\0t\0Limitsq\0~\0q\0~vsq\0~\0<q\0~gt\0\0q\0~\0sq\0~|q\0~\0sq\0~\0\"qq\0~gt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0?q\0~zt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\08)Maq\0~zt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0Uq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0}&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0/cq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0-гq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0cq\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0g1q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0:zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0[q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0sq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~t\0SubFlowsq\0~\0]q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0L#Wq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\04Nhq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0fw&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0sq\0~zt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\"q\0~t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~xxq\0~t\0	Performersq\0~\0q\0~sq\0~\0q\0~gt\0	approver1t\0	StartModesq\0~\0q\0~sq\0~\0lAq\0~gt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0$q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0xGPq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0|p/q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0`q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0\nFinishModesq\0~\0q\0~sq\0~\0dOFq\0~gt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0Ig\']q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0Vq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0Cq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\07Ngq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Prioritysq\0~\0q\0~\rsq\0~\0Q*q\0~gt\0\0t\0	Deadlinessq\0~\r\0q\0~sq\0~\0+^\\q\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0tq\0~gt\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Yo	q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~sq\0~\0yq\0~t\0\0t\0TimeEstimationsq\0~q\0~#sq\0~\0 gq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~(sq\0~\0{Ezq\0~$t\0\0t\0WorkingTimesq\0~\0q\0~,sq\0~\0aq<q\0~$t\0\0t\0Durationsq\0~\0q\0~0sq\0~\0礆q\0~$t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~)q\0~-q\0~1xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~ q\0~$xt\0Iconsq\0~8\0q\0~6sq\0~\0\0q\0~gt\0\0t\0\rDocumentationsq\0~\07\0q\0~:sq\0~\0N]q\0~gt\0\0t\0TransitionRestrictionssq\0~A\0q\0~>sq\0~\0Ta*eq\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~Dsq\0~\0l\Zwq\0~gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0-invq\0~Et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0?q\0~Jt\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0q\0~Jt\0	approver1pxsq\0~\0E\0\0\0w\0\0\0q\0~Oq\0~Rxsq\0~rt\0ExtendedAttributesq\0~\0 \rq\0~Et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0FVmq\0~Vt\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\02Rq\0~Vt\0754,82pxsq\0~\0E\0\0\0w\0\0\0q\0~[q\0~^xxpxsq\0~\0E\0\0\0w\0\0\0q\0~lq\0~oq\0~sq\0~wq\0~zq\0~q\0~q\0~q\0~q\0~q\0~q\0~7q\0~;q\0~?q\0~Exxt\0Transitionssr\0+org.enhydra.shark.xpdl.elements.Transitions9>/i\0\0xq\0~\0k\0q\0~csq\0~\0)q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\rw\0\0\0\rsr\0*org.enhydra.shark.xpdl.elements.Transitiontx\0\0xq\0~\0t\0\nTransitionsq\0~\0h͍q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0$q\0~kt\0transition1pq\0~\0sq\0~\0\0q\0~\0sq\0~\07Dq\0~kt\0\0pt\0Fromsq\0~\0q\0~vsq\0~\0\'q\0~kt\0email1pt\0Tosq\0~\0q\0~zsq\0~\08q\0~kt\0route1pt\0	Conditionsr\0)org.enhydra.shark.xpdl.elements.ConditionDZ;|\0\0xq\0~\0\0q\0~~sq\0~\0jq\0~kt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Jxq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pt\0	CONDITIONt\0	OTHERWISEt\0	EXCEPTIONt\0DEFAULTEXCEPTIONxxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0[,Eq\0~kt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0jeq\0~kt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0g3q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0!|+q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0&лq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~pq\0~sq\0~wq\0~{q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0%\rKq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\Z=q\0~t\0transition3pq\0~\0sq\0~\0\0q\0~\0sq\0~\0vq\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0SӠq\0~t\0	approver1pq\0~zsq\0~\0q\0~zsq\0~\0Uq\0~t\0route2pt\0	Conditionsq\0~\0q\0~sq\0~\0=[5q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\06/Gq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0lJq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0g,q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0Iq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0=Bq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\07q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0!;q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0n\0Lq\0~t\0transition4pq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0%*:q\0~t\0route2pq\0~zsq\0~\0q\0~zsq\0~\0Y|nq\0~t\0email2pt\0	Conditionsq\0~\0q\0~sq\0~\0t kq\0~t\0approvalStatus1 === \'Resubmit\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0\0q\0~t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0:q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0unq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0L2xq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0kdq\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0YEq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0X{q\0~t\0PBUILDER_TRANSITION_CONDITIONSpq\0~{sq\0~\0\0q\0~{sq\0~\0-O\Zq\0~t\0P[{\"join\":\"&&\",\"variable\":\"approvalStatus1\",\"operator\":\"===\",\"value\":\"Resubmit\"}]pxsq\0~\0E\0\0\0w\0\0\0q\0~\nq\0~\rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0bwHkq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0lh?q\0~t\0transition5pq\0~\0sq\0~\0\0q\0~\0sq\0~\0o%9q\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0${q\0~t\0email2pq\0~zsq\0~\0q\0~zsq\0~\0>q\0~t\0resubmitpt\0	Conditionsq\0~\0q\0~#sq\0~\07\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\03{q\0~$q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~(xt\0Descriptionsq\0~\02\0q\0~,sq\0~\0Uiq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~0sq\0~\0Fzq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0n]q\0~1t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0sFq\0~6t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0D`q\0~6t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~;q\0~>xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~\Zq\0~q\0~ q\0~$q\0~-q\0~1xsq\0~jt\0\nTransitionsq\0~\0zq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Pq\0~Ct\0transition7pq\0~\0sq\0~\0\0q\0~\0sq\0~\0-7q\0~Ct\0\0pq\0~vsq\0~\0q\0~vsq\0~\0q\0~Ct\0resubmitpq\0~zsq\0~\0q\0~zsq\0~\0Pkq\0~Ct\0route1pt\0	Conditionsq\0~\0q\0~Tsq\0~\0,2q\0~Ct\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0jxTq\0~Uq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~Yxt\0Descriptionsq\0~\02\0q\0~]sq\0~\0xq\0~Ct\0\0t\0ExtendedAttributessq\0~\0\0q\0~asq\0~\0iXq\0~Ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0hq\0~bt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0yo&q\0~gt\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0]m4q\0~gt\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~lq\0~oxxpxsq\0~\0E\0\0\0w\0\0\0q\0~Hq\0~Kq\0~Nq\0~Qq\0~Uq\0~^q\0~bxsq\0~jt\0\nTransitionsq\0~\0<$q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~tt\0transition8pq\0~\0sq\0~\0\0q\0~\0sq\0~\0Tq\0~tt\0\0pq\0~vsq\0~\0q\0~vsq\0~\0Hsq\0~tt\0route2pq\0~zsq\0~\0q\0~zsq\0~\0R7\nq\0~tt\0email3pt\0	Conditionsq\0~\0q\0~sq\0~\0	%aq\0~tt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0wgq\0~t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0lq\0~tt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Pq\0~tt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0Gq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0K9q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0U6/q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~yq\0~|q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0:q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0u\Zq\0~t\0transition9pq\0~\0sq\0~\0\0q\0~\0sq\0~\0buaq\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0- q\0~t\0email3pq\0~zsq\0~\0q\0~zsq\0~\0q\0~t\0	approver2pt\0	Conditionsq\0~\0q\0~sq\0~\0-xdq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0( q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0R޹q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0-q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0>לq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\'-֝q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0!q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\01oq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0(vq\0~t\0transition10pq\0~\0sq\0~\0\0q\0~\0sq\0~\0%!5Xq\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0Iq\0~t\0	approver2pq\0~zsq\0~\0q\0~zsq\0~\0\0+Ydq\0~t\0route3pt\0	Conditionsq\0~\0q\0~sq\0~\0)YIq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0?q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0egQq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0IJq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0P~yq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0	7z\Zq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~\0q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0_JDq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Hq\0~t\0transition13pq\0~\0sq\0~\0\0q\0~\0sq\0~\0G[q\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0\\pCbq\0~t\0route1pq\0~zsq\0~\0q\0~zsq\0~\0n%\\q\0~t\0	approver1pt\0	Conditionsq\0~\0q\0~sq\0~\0Nv	q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Cq\0~\Zq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~\"sq\0~\0VWq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~&sq\0~\0o&q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0TJq\0~\'t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0U)q\0~,t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0\0Esq\0~,t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~1q\0~4xxpxsq\0~\0E\0\0\0w\0\0\0q\0~\rq\0~q\0~q\0~q\0~\Zq\0~#q\0~\'xsq\0~jt\0\nTransitionsq\0~\0{q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0gq\0~9t\0transition11pq\0~\0sq\0~\0\0q\0~\0sq\0~\0wuq\0~9t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0!Ǖbq\0~9t\0route3pq\0~zsq\0~\0q\0~zsq\0~\0Ms0q\0~9t\0email2pt\0	Conditionsq\0~\0q\0~Jsq\0~\0R~\"q\0~9t\0approvalStatus2 === \'Resubmit\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Oq\0~Kt\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~Oxt\0Descriptionsq\0~\02\0q\0~Tsq\0~\0.Hq\0~9t\0\0t\0ExtendedAttributessq\0~\0\0q\0~Xsq\0~\0BD$q\0~9t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0\nCq\0~Yt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\rըq\0~^t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0[>\nq\0~^t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~cq\0~fxsq\0~rt\0ExtendedAttributesq\0~\0miEq\0~Yt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\05q\0~jt\0PBUILDER_TRANSITION_CONDITIONSpq\0~{sq\0~\0\0q\0~{sq\0~\0V\'CAq\0~jt\0P[{\"join\":\"&&\",\"variable\":\"approvalStatus2\",\"operator\":\"===\",\"value\":\"Resubmit\"}]pxsq\0~\0E\0\0\0w\0\0\0q\0~oq\0~rxxpxsq\0~\0E\0\0\0w\0\0\0q\0~>q\0~Aq\0~Dq\0~Gq\0~Kq\0~Uq\0~Yxsq\0~jt\0\nTransitionsq\0~\0l;q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0}(q\0~wt\0transition12pq\0~\0sq\0~\0\0q\0~\0sq\0~\00qxq\0~wt\0\0pq\0~vsq\0~\0q\0~vsq\0~\0NPq\0~wt\0route3pq\0~zsq\0~\0q\0~zsq\0~\0\\ q\0~wt\0email4pt\0	Conditionsq\0~\0q\0~sq\0~\0UʓGq\0~wt\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0#q\0~t\0	OTHERWISEsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0Gw~;q\0~wt\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0|ycq\0~wt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0\nO+q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0>\\q\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0\'q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~|q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\02<q\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0A{q\0~t\0transition15pq\0~\0sq\0~\0\0q\0~\0sq\0~\0R]q\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0qwkq\0~t\0route2pq\0~zsq\0~\0q\0~zsq\0~\0Pq\0~t\0tool5pt\0	Conditionsq\0~\0q\0~sq\0~\0y؁kq\0~t\0approvalStatus1 === \'Rejected\'sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\07\"\nq\0~t\0	CONDITIONsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0[qʉq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\03Mq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\01Ķq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0ctq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0a;}q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\01Qq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0V!q\0~t\0PBUILDER_TRANSITION_CONDITIONSpq\0~{sq\0~\0\0q\0~{sq\0~\0-lq\0~t\0P[{\"join\":\"&&\",\"variable\":\"approvalStatus1\",\"operator\":\"===\",\"value\":\"Rejected\"}]pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0)Dq\0~et\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0MNeq\0~t\0transition16pq\0~\0sq\0~\0\0q\0~\0sq\0~\0wceq\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0\'^q\0~t\0tool5pq\0~zsq\0~\0q\0~zsq\0~\0±q\0~t\0tool6pt\0	Conditionsq\0~\0q\0~sq\0~\0{|߶q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0&	6q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0;Yq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0Pq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0.q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0uq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0\"q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xxt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0u]q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0@2Mq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0lq\0~t\0%JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDERpq\0~{sq\0~\0\0q\0~{sq\0~\0u\\tq\0~t\0requester;approver1;approver2pxsq\0~\0E\0\0\0w\0\0\0q\0~#q\0~&xsq\0~rt\0ExtendedAttributesq\0~\0il1q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0;Ჹq\0~*t\0JaWE_GRAPH_START_OF_WORKFLOWpq\0~{sq\0~\0\0q\0~{sq\0~\0/8q\0~*t\0JaWE_GRAPH_PARTICIPANT_ID=requester,CONNECTING_ACTIVITY_ID=email1,X_OFFSET=80,Y_OFFSET=18,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~/q\0~2xsq\0~rt\0ExtendedAttributesq\0~\09Ӿq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\07q\0~6t\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~{sq\0~\0\0q\0~{sq\0~\02q\0~6t\0JaWE_GRAPH_PARTICIPANT_ID=approver2,CONNECTING_ACTIVITY_ID=email4,X_OFFSET=926,Y_OFFSET=17,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~;q\0~>xsq\0~rt\0ExtendedAttributesq\0~\0wgRq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0p !q\0~Bt\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~{sq\0~\0\0q\0~{sq\0~\0Btq\0~Bt\0JaWE_GRAPH_PARTICIPANT_ID=approver1,CONNECTING_ACTIVITY_ID=tool6,X_OFFSET=912,Y_OFFSET=95,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~Gq\0~Jxxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~q\0~q\0~q\0~q\0~q\0~1q\0~7q\0~Oq\0~Uq\0~\\q\0~cq\0~eq\0~xsq\0~t\0WorkflowProcesssq\0~\0VUq\0~t\0\0sq\0~\0w\0\0\0\rq\0~\0sq\0~\0q\0~\0sq\0~\0Pq\0~Ot\0populateChart2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0z2q\0~Ot\0Populate Data For Chartspq\0~sq\0~\0\0q\0~sq\0~\0;%q\0~Oq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0\rProcessHeadersq\0~q\0~]sq\0~\0jCq\0~Ot\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0&Re{q\0~^t\0hsq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~q\0~q\0~xt\0Createdsq\0~\0-\0q\0~fsq\0~\0K#psq\0~^t\0\0t\0Descriptionsq\0~\02\0q\0~jsq\0~\0Qd\"q\0~^t\0\0t\0Prioritysq\0~\0q\0~nsq\0~\09Cq\0~^t\0\0t\0Limitsq\0~\0q\0~rsq\0~\0ˀq\0~^t\0\0t\0	ValidFromsq\0~\0q\0~vsq\0~\0\\q\0~^t\0\0t\0ValidTosq\0~\0q\0~zsq\0~\0Q4q\0~^t\0\0t\0TimeEstimationsq\0~\0q\0~~sq\0~\0Bq\0~^t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0UQq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0W)q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0]\nq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~bq\0~gq\0~kq\0~oq\0~sq\0~wq\0~{q\0~xt\0RedefinableHeadersq\0~\0H\0q\0~sq\0~\02zq\0~Ot\0\0sq\0~\0w\0\0\0q\0~\0Msq\0~\0\0q\0~\0Msq\0~\0jEq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~\0Rq\0~\0Sq\0~\0Txt\0Authorsq\0~\0V\0q\0~sq\0~\0ïq\0~t\0\0t\0Versionsq\0~\0[\0q\0~sq\0~\06oq\0~t\0\0t\0Codepagesq\0~\0`\0q\0~sq\0~\0RX_q\0~t\0\0t\0\nCountrykeysq\0~\0e\0q\0~sq\0~\07q\0~t\0\0t\0Responsiblessq\0~\0j\0q\0~sq\0~\0\rq%q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~xt\0FormalParameterssq\0~\0q\0~sq\0~\0jGLq\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nDataFieldssq\0~\0q\0~sq\0~\0 q\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Participantssq\0~\0\0q\0~sq\0~\03O,q\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Applicationssq\0~s\0q\0~sq\0~\0q\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ActivitySetssq\0~[\0q\0~sq\0~\0O}q\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0\nActivitiessq\0~b\0q\0~sq\0~\0ш4q\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~ht\0Activitysq\0~\0\n^fq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0b٤2q\0~t\0tool2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0q\0~t\0\ZPopulate Stock Data Tablespt\0Descriptionsq\0~\02\0q\0~sq\0~\0BCq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0e?`q\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0\Z8Lq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0EQq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\07q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\02^q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0qn	q\0~\0t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Vyѳq\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0yCq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~sq\0~\0a5q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\03Uq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0#q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~xxsq\0~t\0SubFlowsq\0~\0\\Wq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\nyq\0~\"t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0Oq\0~\"q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~-sq\0~\0Jgq\0~\"t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~\'q\0~*q\0~.xxq\0~\0xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0T	q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0J6Žq\0~5t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~:xxq\0~t\0	Performersq\0~\0q\0~>sq\0~\036q\0~t\0participant4t\0	StartModesq\0~\0q\0~Bsq\0~\0AOq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0XGzq\0~Ct\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0:q\0~Gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0q\0~Gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0vEq\0~Gt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Kxsq\0~\0E\0\0\0w\0\0\0q\0~Gxt\0\nFinishModesq\0~\0q\0~^sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0yOq\0~_t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\085q\0~ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0`:hq\0~ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0t#_q\0~ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~gxsq\0~\0E\0\0\0w\0\0\0q\0~cxt\0Prioritysq\0~\0q\0~zsq\0~\0{^9q\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~~sq\0~\0?yq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0Rq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0<Nұq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~sq\0~\06\nq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0Iq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0DKq\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0#q\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0Nq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~8\0q\0~sq\0~\0(8q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\045q\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~sq\0~\0n=q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0o{q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0hq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0tOwq\0~t\0participant4pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0(bq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0g35q\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0]VMq\0~t\0306.17047119140625,29pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~?q\0~Cq\0~_q\0~{q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~ht\0Activitysq\0~\0\0%olq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0nOq\0~t\0populateDataChart2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0C4>q\0~t\0Populate Standard Data Tablespt\0Descriptionsq\0~\02\0q\0~sq\0~\0Mq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0(?;*q\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0JoNq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\09q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0[Ӝq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0\nUq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0Zkq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0m<q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0|q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\'Qq\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0wo\"q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~\rsq\0~\0h8\Zq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0)kq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0c%=q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~\nq\0~q\0~q\0~xxsq\0~t\0SubFlowsq\0~\0yh&q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0yq\0~t\0\0pq\0~sq\0~\0\0q\0~sq\0~\0(~q\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~)sq\0~\0GPNq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~#q\0~&q\0~*xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\00q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0&q\0~1t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~6xxq\0~t\0	Performersq\0~\0q\0~:sq\0~\0@(q\0~t\0participant4t\0	StartModesq\0~\0q\0~>sq\0~\0[rq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0|q\0~?t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0t^q\0~Ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0_q\0~Ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0U^9q\0~Ct\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Gxsq\0~\0E\0\0\0w\0\0\0q\0~Cxt\0\nFinishModesq\0~\0q\0~Zsq\0~\0<SQXq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0\Z&q\0~[t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\01q\0~_t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0!q\0~_t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0q2%q\0~_t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~cxsq\0~\0E\0\0\0w\0\0\0q\0~_xt\0Prioritysq\0~\0q\0~vsq\0~\0}Afq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~zsq\0~\0sbq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~sq\0~\0.Vq\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0xZeq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~sq\0~\0Gfq\0~t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0jq\0~t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0/q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0E<Eq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0v,#q\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~8\0q\0~sq\0~\0mq\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0q\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~sq\0~\0<Aݚq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0\n8nkq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Pq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0(Lq\0~t\0participant4pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0_Idq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0q\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0T;q\0~t\0157,26.98863983154297pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~;q\0~?q\0~[q\0~wq\0~{q\0~q\0~q\0~q\0~q\0~xsq\0~ht\0Activitysq\0~\0>q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0xq\0~t\0populateMeetingDatapq\0~\0sq\0~\0\0q\0~\0sq\0~\0,z/q\0~t\0Populate Meeting Datapt\0Descriptionsq\0~\02\0q\0~sq\0~\0dρq\0~t\0\0t\0Limitsq\0~\0q\0~sq\0~\0I4q\0~t\0\0q\0~\0sq\0~|q\0~\0sq\0~\0`vwq\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Routesq\0~\0\r͡q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Implementationsq\0~\0V<q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~q\0~\0sq\0~\0\r/q\0~t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~t\0Nosq\0~\0Y0Sq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~\0t\0Toolssq\0~\0*#Mq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~t\0Toolsq\0~\0|c\"q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0W%q\0~t\0default_applicationpq\0~\0sq\0~\0\0q\0~\0sq\0~\0bq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~	sq\0~\06mq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0Descriptionsq\0~\02\0q\0~sq\0~\0?\'q\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0d[Cq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~\nq\0~q\0~xxsq\0~t\0SubFlowsq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0\Zq\0~\Zt\0\0pq\0~sq\0~\0\0q\0~sq\0~\0D8q\0~\Zq\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0ActualParameterssq\0~\0q\0~%sq\0~\0tCq\0~\Zt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~\"q\0~&xxq\0~xsq\0~\0E\0\0\0w\0\0\0q\0~xsq\0~t\0\rBlockActivitysq\0~\0M!q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\01q\0~-t\0\0pxsq\0~\0E\0\0\0w\0\0\0q\0~2xxq\0~t\0	Performersq\0~\0q\0~6sq\0~\01:q\0~t\0participant4t\0	StartModesq\0~\0q\0~:sq\0~\0]:q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0 q\0~;t\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0&zXq\0~?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0;q\0~?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0Nq\0~?t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~Cxsq\0~\0E\0\0\0w\0\0\0q\0~?xt\0\nFinishModesq\0~\0q\0~Vsq\0~\0c3q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0q\0~sq\0~\0g}q\0~Wt\0\0sq\0~\0E\0\0\0w\0\0\0sq\0~\0t\0XMLEmptyChoiceElementsq\0~\0_A_rq\0~[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0	Automaticsq\0~\0apVq\0~[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xsq\0~t\0Manualsq\0~\0g<Xq\0~[t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xxq\0~_xsq\0~\0E\0\0\0w\0\0\0q\0~[xt\0Prioritysq\0~\0q\0~rsq\0~\0Pyq\0~t\0\0t\0	Deadlinessq\0~\r\0q\0~vsq\0~\0`	q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0SimulationInformationsq\0~\0q\0~|sq\0~\0G-q\0~t\0\0sq\0~\0w\0\0\0q\0~sq\0~\0\0q\0~sq\0~\0Bq\0~}q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~xt\0Costsq\0~ q\0~sq\0~\0Z.q\0~}t\0\0t\0TimeEstimationsq\0~q\0~sq\0~\0lpq\0~}t\0\0sq\0~\0w\0\0\0t\0WaitingTimesq\0~\0q\0~sq\0~\0=\"+q\0~t\0\0t\0WorkingTimesq\0~\0q\0~sq\0~\0dBq\0~t\0\0t\0Durationsq\0~\0q\0~sq\0~\0CUq\0~t\0\0xsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~xt\0Iconsq\0~8\0q\0~sq\0~\0+\\;q\0~t\0\0t\0\rDocumentationsq\0~\07\0q\0~sq\0~\0q\0~t\0\0t\0TransitionRestrictionssq\0~A\0q\0~sq\0~\08RQq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0\0w\0\0\0\0xt\0ExtendedAttributessq\0~\0\0q\0~sq\0~\07Z%q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0EPq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0@ۅq\0~t\0JaWE_GRAPH_PARTICIPANT_IDpq\0~{sq\0~\0\0q\0~{sq\0~\0r<q\0~t\0participant4pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xsq\0~rt\0ExtendedAttributesq\0~\0e*uq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0,q\0~t\0JaWE_GRAPH_OFFSETpq\0~{sq\0~\0\0q\0~{sq\0~\0~Yq\0~t\0472.15277099609375,27pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~7q\0~;q\0~Wq\0~sq\0~wq\0~}q\0~q\0~q\0~q\0~xxt\0Transitionssq\0~d\0q\0~sq\0~\0Iq\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~jt\0\nTransitionsq\0~\0LMq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0/yq\0~t\0transition1pq\0~\0sq\0~\0\0q\0~\0sq\0~\0X?q\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0m{kq\0~t\0populateDataChart2pq\0~zsq\0~\0q\0~zsq\0~\0p;q\0~t\0tool2pt\0	Conditionsq\0~\0q\0~sq\0~\0yԟPq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0KƓq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0lIq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0r+Fq\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0Xnyq\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0mhFq\0~t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0a.q\0~t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~q\0~q\0~q\0~q\0~xsq\0~jt\0\nTransitionsq\0~\0o_9q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Lq\0~t\0transition2pq\0~\0sq\0~\0\0q\0~\0sq\0~\0<Lq\0~t\0\0pq\0~vsq\0~\0q\0~vsq\0~\0<\rq\0~t\0tool2pq\0~zsq\0~\0q\0~zsq\0~\0aq\0~t\0populateMeetingDatapt\0	Conditionsq\0~\0q\0~sq\0~\0\'q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0\0q\0~\0sq\0~\0Z	υq\0~q\0~\0Psq\0~\0E\0\0\0w\0\0\0q\0~\0Pq\0~q\0~q\0~q\0~xxsq\0~\0E\0\0\0w\0\0\0q\0~xt\0Descriptionsq\0~\02\0q\0~sq\0~\0`Iq\0~t\0\0t\0ExtendedAttributessq\0~\0\0q\0~sq\0~\0q\0~t\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0q\0~t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0Veq\0~#t\0JaWE_GRAPH_TRANSITION_STYLEpq\0~{sq\0~\0\0q\0~{sq\0~\0%1q\0~#t\0NO_ROUTING_ORTHOGONALpxsq\0~\0E\0\0\0w\0\0\0q\0~(q\0~+xxpxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~q\0~\nq\0~\rq\0~q\0~\Zq\0~xxt\0ExtendedAttributessq\0~\0\0q\0~0sq\0~\0sHq\0~Ot\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0[m:q\0~1t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0OXq\0~6t\0%JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDERpq\0~{sq\0~\0\0q\0~{sq\0~\0/q\0~6t\0participant4pxsq\0~\0E\0\0\0w\0\0\0q\0~;q\0~>xsq\0~rt\0ExtendedAttributesq\0~\0Qq\0~1t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0/+5q\0~Bt\0JaWE_GRAPH_START_OF_WORKFLOWpq\0~{sq\0~\0\0q\0~{sq\0~\0q\0~Bt\0JaWE_GRAPH_PARTICIPANT_ID=participant4,CONNECTING_ACTIVITY_ID=populateDataChart2,X_OFFSET=80,Y_OFFSET=40,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=START_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~Gq\0~Jxsq\0~rt\0ExtendedAttributesq\0~\0Y{q\0~1t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0|q\0~Nt\0\ZJaWE_GRAPH_END_OF_WORKFLOWpq\0~{sq\0~\0\0q\0~{sq\0~\0ynq\0~Nt\0JaWE_GRAPH_PARTICIPANT_ID=participant4,CONNECTING_ACTIVITY_ID=populateMeetingData,X_OFFSET=615,Y_OFFSET=38,JaWE_GRAPH_TRANSITION_STYLE=NO_ROUTING_ORTHOGONAL,TYPE=END_DEFAULTpxsq\0~\0E\0\0\0w\0\0\0q\0~Sq\0~Vxxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~Tq\0~Wq\0~Zq\0~^q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~q\0~1xxt\0ExtendedAttributessq\0~\0\0q\0~[sq\0~\0^q\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sq\0~rt\0ExtendedAttributesq\0~\0Bfq\0~\\t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0mq\0~at\0EDITING_TOOLpq\0~{sq\0~\0\0q\0~{sq\0~\0\n>q\0~at\0Web Workflow Designerpxsq\0~\0E\0\0\0w\0\0\0q\0~fq\0~ixsq\0~rt\0ExtendedAttributesq\0~\0=sgq\0~\\t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0J&q\0~mt\0EDITING_TOOL_VERSIONpq\0~{sq\0~\0\0q\0~{sq\0~\0\0|q\0~mt\0\r5.0-pre-alphapxsq\0~\0E\0\0\0w\0\0\0q\0~rq\0~uxxpxsq\0~\0E\0\0\0\rw\0\0\0\rq\0~\0q\0~\0q\0~\0q\0~\0Iq\0~\0tq\0~\0q\0~\0q\0~\0q\0~\0q\0~tq\0~q\0~q\0~\\x\0sq\0~\0w\0\0\0\0xt\01sr\0*org.enhydra.shark.xpdl.elements.Namespaces|<.R\0\0xq\0~\0kt\0\nNamespacessq\0~\0JkZq\0~\0\nt\0\0sq\0~\0w\0\0\0\0xsq\0~\0E\0\0\0w\0\0\0sr\0)org.enhydra.shark.xpdl.elements.Namespacez_\0\0xq\0~\0t\0	Namespacesq\0~\0:q\0~}t\0\0sq\0~\0w\0\0\0q\0~\0sq\0~\0q\0~\0sq\0~\0mcq\0~t\0xpdlpq\0~\0sq\0~\0q\0~\0sq\0~\0\Zq\0~t\0 http://www.wfmc.org/2002/XPDL1.0pxsq\0~\0E\0\0\0w\0\0\0q\0~q\0~xx',1000218,5,1000219,0);
/*!40000 ALTER TABLE `SHKXPDLData` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLHistory`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKXPDLHistory` (
  `XPDLId` varchar(90) NOT NULL,
  `XPDLVersion` varchar(20) NOT NULL,
  `XPDLClassVersion` bigint(20) NOT NULL,
  `XPDLUploadTime` datetime NOT NULL,
  `XPDLHistoryUploadTime` datetime NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLHistory` (`XPDLId`,`XPDLVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLHistory`
--

LOCK TABLES `SHKXPDLHistory` WRITE;
/*!40000 ALTER TABLE `SHKXPDLHistory` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLHistory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLHistoryData`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKXPDLHistoryData` (
  `XPDLContent` mediumblob NOT NULL,
  `XPDLClassContent` mediumblob NOT NULL,
  `XPDLHistory` decimal(19,0) NOT NULL,
  `CNT` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLHistoryData` (`CNT`),
  KEY `SHKXPDLHistoryData_XPDLHistory` (`XPDLHistory`),
  CONSTRAINT `SHKXPDLHistoryData_XPDLHistory` FOREIGN KEY (`XPDLHistory`) REFERENCES `SHKXPDLHistory` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLHistoryData`
--

LOCK TABLES `SHKXPDLHistoryData` WRITE;
/*!40000 ALTER TABLE `SHKXPDLHistoryData` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLHistoryData` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLParticipantPackage`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKXPDLParticipantPackage` (
  `PACKAGE_ID` varchar(90) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLParticipantPackage` (`PACKAGE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLParticipantPackage`
--

LOCK TABLES `SHKXPDLParticipantPackage` WRITE;
/*!40000 ALTER TABLE `SHKXPDLParticipantPackage` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLParticipantPackage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLParticipantProcess`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKXPDLParticipantProcess` (
  `PROCESS_ID` varchar(90) NOT NULL,
  `PACKAGEOID` decimal(19,0) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLParticipantProcess` (`PROCESS_ID`,`PACKAGEOID`),
  KEY `SHKXPDLParticipantProcess_PACKAGEOID` (`PACKAGEOID`),
  CONSTRAINT `SHKXPDLParticipantProcess_PACKAGEOID` FOREIGN KEY (`PACKAGEOID`) REFERENCES `SHKXPDLParticipantPackage` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLParticipantProcess`
--

LOCK TABLES `SHKXPDLParticipantProcess` WRITE;
/*!40000 ALTER TABLE `SHKXPDLParticipantProcess` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLParticipantProcess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLReferences`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKXPDLReferences` (
  `ReferredXPDLId` varchar(90) NOT NULL,
  `ReferringXPDL` decimal(19,0) NOT NULL,
  `ReferredXPDLNumber` int(11) NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLReferences` (`ReferredXPDLId`,`ReferringXPDL`),
  KEY `SHKXPDLReferences_ReferringXPDL` (`ReferringXPDL`),
  CONSTRAINT `SHKXPDLReferences_ReferringXPDL` FOREIGN KEY (`ReferringXPDL`) REFERENCES `SHKXPDLS` (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLReferences`
--

LOCK TABLES `SHKXPDLReferences` WRITE;
/*!40000 ALTER TABLE `SHKXPDLReferences` DISABLE KEYS */;
/*!40000 ALTER TABLE `SHKXPDLReferences` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SHKXPDLS`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SHKXPDLS` (
  `XPDLId` varchar(90) NOT NULL,
  `XPDLVersion` varchar(20) NOT NULL,
  `XPDLClassVersion` bigint(20) NOT NULL,
  `XPDLUploadTime` datetime NOT NULL,
  `oid` decimal(19,0) NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`oid`),
  UNIQUE KEY `I1_SHKXPDLS` (`XPDLId`,`XPDLVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SHKXPDLS`
--

LOCK TABLES `SHKXPDLS` WRITE;
/*!40000 ALTER TABLE `SHKXPDLS` DISABLE KEYS */;
INSERT INTO `SHKXPDLS` VALUES
('crm','1',1184650391000,'2024-04-19 13:40:04',1000202,0),
('dashboard','1',1184650391000,'2024-04-19 13:40:07',1000206,0),
('expenseclaim','1',1184650391000,'2024-04-19 13:40:10',1000210,0),
('isr','1',1184650391000,'2024-04-19 13:40:12',1000214,0),
('JogetDxShowcase','1',1184650391000,'2024-04-19 13:40:17',1000218,0);
/*!40000 ALTER TABLE `SHKXPDLS` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_app`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_app` (
  `appId` varchar(255) NOT NULL,
  `appVersion` bigint(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `published` bit(1) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `license` text DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `meta` longtext DEFAULT NULL,
  PRIMARY KEY (`appId`,`appVersion`),
  KEY `idx_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_app`
--

LOCK TABLES `app_app` WRITE;
/*!40000 ALTER TABLE `app_app` DISABLE KEYS */;
INSERT INTO `app_app` VALUES
('appcenter',1,'App Center','','2024-04-19 13:40:43','2024-04-19 13:40:43','oRIgWuw8ed5OmS98TSZFxocskOFXU0v3VPneM0k80NqSBK2r6RhNzTNTryZkuj4W',NULL,NULL),
('crm',1,'Customer Relationship Management','','2024-04-19 13:39:53','2024-04-19 13:40:06','Vfe6Df5AdlrGEPqFYgTt8XuGJ4XiTt2NnBLEovw3qoQ=',NULL,NULL),
('dashboard',1,'Employee Portal','','2024-04-19 13:40:06','2024-04-19 13:40:08','EG7vI0pxpjL7ThQ8m9sQSeEfsbmWrC4TbI37BKjZlO5jbwy29bpHrw==',NULL,NULL),
('expenseclaim',1,'Expenses Claim','','2024-04-19 13:40:08','2024-04-19 13:40:10','cggLRcAgu9fsi9+Evtai7+EX+Fx2lx0tRzfPsTbAfbQCrT5RWUgR7w==',NULL,NULL),
('isr',1,'Internal Service Request','','2024-04-19 13:40:11','2024-04-19 13:40:12','BXiIDyi75K/balSfhqm1i7aycpqYcRKBBPMkO7zfnto=',NULL,NULL),
('JogetDxShowcase',1,'Joget DX Showcase','','2024-04-19 13:40:12','2024-04-19 13:40:18','1i44Neuka7RRu+22/jBpdqFp/tdq4ijmTtjtQIzB0iiChu98G79hNHSaJF+QK4EE',NULL,NULL);
/*!40000 ALTER TABLE `app_app` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_builder`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_builder` (
  `appId` varchar(255) NOT NULL,
  `appVersion` bigint(20) NOT NULL,
  `id` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `json` longtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  PRIMARY KEY (`appId`,`appVersion`,`id`),
  KEY `idx_name` (`name`),
  KEY `idx_type` (`type`),
  CONSTRAINT `FK_idup4nrrc79iy4kc46wf5919j` FOREIGN KEY (`appId`, `appVersion`) REFERENCES `app_app` (`appId`, `appVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_builder`
--

LOCK TABLES `app_builder` WRITE;
/*!40000 ALTER TABLE `app_builder` DISABLE KEYS */;
INSERT INTO `app_builder` VALUES
('appcenter',1,'INTERNAL_TAGGING','Tagging','internal','2024-04-19 13:40:43','2024-04-19 13:40:43','{\n    \"datas\": {\n        \"form\": {},\n        \"list\": {},\n        \"userview\": {\n            \"v\": [\"t07\"],\n            \"v3\": [\"t08\"]\n        }\n    },\n    \"labels\": {\n        \"t01\": {\"color\": \"red\"},\n        \"t02\": {\"color\": \"pink\"},\n        \"t03\": {\"color\": \"orange\"},\n        \"t04\": {\"color\": \"yellow\"},\n        \"t05\": {\"color\": \"green\"},\n        \"t06\": {\"color\": \"lime\"},\n        \"t07\": {\n            \"color\": \"blue\",\n            \"label\": \"Default\"\n        },\n        \"t08\": {\n            \"color\": \"sky\",\n            \"label\": \"Glass\"\n        },\n        \"t09\": {\"color\": \"purple\"},\n        \"t10\": {\"color\": \"black\"}\n    }\n}',NULL),
('appcenter',1,'up-0497CD0F62BD44DEEAF1294D58166A1A','Design App','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:43','2024-04-19 13:40:43','{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-color\":\"#343A40\",\"textContent\":\"<i class=\\\"fas fa-pencil-ruler\\\"><\\/i> Design App\",\"id\":\"4F8DD38005EF4A1D6E90DB9905DB85B1\",\"tagName\":\"h2\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-font-weight\":\"500\",\"style-color\":\"#5B6DD0\",\"style-font-size\":\"15px\",\"textContent\":\"<div class=\\\"fs-5 text-dark fw-bold text-hover-primary text-dark lh-base text-gray-600\\\">You can create a plain new app or using existing template.<\\/div>\",\"id\":\"B29BC24932A1434C38A57D6762E392F4\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-tablet-flex\":\"0 0 80%\",\"id\":\"250FBB9B445C4ED51FACA40E02FD68FD\",\"style-tablet-max-width\":\"80%\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.Link\",\"properties\":{\"style-position\":\"relative\",\"style-color\":\"#009EF7\",\"style-float\":\"right\",\"label\":\"View All Templates\",\"type\":\"pagecomponent\",\"url\":\"templates\",\"target\":\"self\",\"style-font-weight\":\"500\",\"style-top\":\"0px\",\"userviewCacheDuration\":\"20\",\"userviewCacheScope\":\"\",\"id\":\"B2E40400A1B0460E2EAD915F31D05A40\",\"style-mobile-float\":\"left\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"9A60610B505C43E7600120C6E0A0049B\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"80%\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"AC0E8473AD5A458AE62FF9731C57904C\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HorizontalRuleComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"2rem\",\"style-border-style\":\"dashed\",\"id\":\"2467CC0560574D034B27F12A07668BDB\",\"style-border-color\":\"#E4E6EF\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<div class=\\\"card data-row\\\">\\n    <div class=\\\"card-body\\\">\\n        <div style=\\\"\\\" class=\\\"ph_columns column_5 column_body column_img body_column_5 card-text mb-1\\\">\\n            <div style=\\\"background-image:url(\'#request.contextPath#/images/appCenterCreateApp.png\');height:0;padding-bottom:50%;width:100%;background-size:cover;background-repeat: no-repeat;display:inline-block;\\\"><\\/div>\\n        <\\/div> \\n        <div style=\\\"\\\" class=\\\"ph_columns column_0 column_body column_name body_column_0 card-text mb-1\\\">\\n            Create Your App\\n        <\\/div>     \\n        <div style=\\\"\\\" class=\\\"ph_columns column_6 column_body column_desc body_column_6 card-text mb-1\\\">\\n            <p>Create your own enterprise application with Joget. Get started now!<\\/p>\\n        <\\/div>\\n        <div class=\\\"card-actions\\\">\\n            <a style=\\\"\\\" href=\\\"javascript:appCreate(\'\');\\\" target=\\\"_self\\\" class=\\\"ph_rowActions rowAction_0 rowaction_body body_rowAction_0  btn btn-sm btn-primary link_rowAction_0\\\">Create New App<\\/a>\\n        <\\/div>\\n    <\\/div>\\n<\\/div>\",\"color\":\"#348fe2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"id\":\"EC89DBB912E2451322834E357EFEF5F9\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"value\":\"3,291,922\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-flex\":\"0 0 33.33%\",\"style-max-width\":\"33.33%\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.DataListMenu\",\"properties\":{\"cacheAllLinks\":\"\",\"customHeader\":\"\",\"style-border-bottom-width\":\"0px\",\"keyName\":\"\",\"customFooter\":\"\",\"enableOffline\":\"\",\"label\":\"List\",\"customId\":\"newTemplate\",\"buttonPosition\":\"bottomLeft\",\"datalistId\":\"list_newTemplate\",\"checkboxPosition\":\"no\",\"selectionType\":\"multiple\",\"userviewCacheDuration\":\"20\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"style-border-left-width\":\"0px\",\"style-border-right-width\":\"0px\",\"id\":\"85384F9C698948E1CB5A00FB08FE4A3F\",\"rowCount\":\"\",\"style-border-top-width\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"15px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"33.33%\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"B28AB2BFC72B4764DE5EACAF8BFD5C3C\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-padding-right\":\"15px\",\"style-margin-bottom\":\"50px\",\"id\":\"894EDF7ED18C446DEF9B2A341D113819\",\"customId\":\"\",\"style-padding-left\":\"15px\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-color\":\"#343A40\",\"style-font-size\":\"1.35rem\",\"textContent\":\"Community\",\"id\":\"4F3CD71D50784C33052FC55E464B0B46\",\"tagName\":\"h5\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-font-weight\":\"500\",\"style-color\":\"#5B6DD0\",\"style-font-size\":\"15px\",\"textContent\":\"<div class=\\\"fs-5 text-dark fw-bold text-hover-primary text-dark lh-base text-gray-600\\\"><span>Joget provides an all encompassing ecosystem that supports community learning and adoption.<\\/span><\\/div>\",\"id\":\"19826EDB85514108BF420DC7B5C8C34D\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HorizontalRuleComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"2rem\",\"style-border-style\":\"dashed\",\"id\":\"C693D3BA71754746C740445CD1FABE88\",\"style-border-color\":\"#E4E6EF\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<div class=\\\"main-wrapper\\\">\\r\\n\\t<a href=\\\"https://marketplace.joget.org/\\\" target=\\\"_blank\\\"><i class=\\\"material-icons fas fa-cart-arrow-down\\\"><\\/i><\\/a>\\r\\n<\\/div>\\r\\n<style>\\r\\n.main-wrapper {\\r\\n\\t\\tborder-radius: 4px;\\r\\n\\t\\tpadding: 10px;\\r\\n\\t\\tposition: relative;\\r\\n\\t\\ttext-align: center;\\r\\n}\\r\\n\\r\\ni.material-icons {\\r\\n\\t\\tfont-size: 1.5rem;\\r\\n\\t\\tcolor: white;\\r\\n\\t\\tposition: relative;\\r\\n\\t\\tborder-radius: 50%;\\r\\n\\t\\tpadding: 5px;\\r\\n\\t\\tmargin: 3px;\\r\\n\\t\\twidth:80px;\\r\\n\\t\\theight:80px;\\r\\n\\t\\ttext-align:center;\\r\\n\\t\\tbox-shadow: 0 1px 3px rgba(0, 0, 0, 0.12), 0 1px 2px rgba(0, 0, 0, 0.24);\\r\\n\\t\\ttransition: color 0.2s ease, background-color 0.2s ease, transform 0.3s ease;\\r\\n}\\r\\n\\r\\ni.material-icons:after {\\r\\n\\t\\tcontent: \\\"\\\";\\r\\n\\t\\twidth: 100%;\\r\\n\\t\\theight: 100%;\\r\\n\\t\\tborder: solid 2px;\\r\\n\\t\\ttransform: scale(0.8);\\r\\n\\t\\tposition: absolute;\\r\\n\\t\\ttop: -3px;\\r\\n\\t\\tleft: -10px;\\r\\n\\t\\tborder-radius: 50%;\\r\\n\\t\\ttransition: all 0.3s ease;\\r\\n}\\r\\n\\r\\ni.material-icons:hover:after {\\r\\n\\t\\ttransform: scale(1);\\r\\n\\t\\tbox-shadow: 10px 0 20px rgba(0, 0, 0, 0.19), 6px 0 6px rgba(0, 0, 0, 0.23);\\r\\n}\\r\\n\\r\\ni.material-icons:nth-of-type(1) {\\r\\n\\t\\tbackground-color:#009EF7;\\r\\n}\\r\\n\\r\\ni.material-icons:nth-of-type(1):hover {\\r\\n\\t\\tcolor: #009EF7;\\r\\n}\\r\\n\\r\\ni.material-icons:nth-of-type(1):after {\\r\\n\\t\\tborder-color: #009EF7;\\r\\n}\\r\\n\\r\\ni.material-icons:hover {\\r\\n\\t\\tbackground-color: transparent;\\r\\n\\t\\ttransform: rotate(90deg);\\r\\n\\t\\tcursor: pointer;\\r\\n\\t\\tbox-shadow: none;\\r\\n}\\r\\n\\r\\n\\ti.material-icons {\\r\\n\\t\\tpadding:20px;\\r\\n\\t\\tmargin:10px;\\r\\n\\t\\tfont-size:2.1rem;\\r\\n\\t}\\r\\n\\ti.material-icons:after {\\r\\n\\t\\tborder-width:3px;\\r\\n\\t\\ttop:-3px;\\r\\n\\t\\tleft:-3px;\\r\\n}\\r\\n<\\/style>\",\"id\":\"9AD7CD678EB24D8E6984BEF7A5FAD79E\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-text-align\":\"center\",\"style-color\":\"#343A40\",\"style-font-size\":\"21px\",\"textContent\":\"Marketplace\",\"id\":\"E6C15176381741ADAC0D487A6738FBD1\",\"tagName\":\"h1\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"5px\",\"style-margin-bottom\":\"5px\",\"textContent\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: center;\\\">Download ready made apps, plugins, templates and more from the Joget Marketplace.<\\/p>\",\"id\":\"74D99A11DD9B415E72D30379ECF0E049\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"id\":\"DA2EAD04C86444C6D7C8BAAFF45BA375\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-tablet-flex\":\"0 0 33%\",\"style-tablet-max-width\":\"33%\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<div class=\\\"main-wrapper\\\">\\r\\n    <a class=\\\"d-block overlay\\\" data-fslightbox=\\\"lightbox-hot-sales\\\" href=\\\"https://answers.joget.org/\\\" target=\\\"_blank\\\">\\r\\n    <i class=\\\"material-icons far fa-comment\\\"><\\/i><\\/a><\\/div>\",\"id\":\"BE3E1641501F40F06DA2BB6362C16C56\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-text-align\":\"center\",\"style-color\":\"#343A40\",\"style-font-size\":\"21px\",\"textContent\":\"Community\",\"id\":\"CE99D936BFB149AE96C55AF34975972C\",\"tagName\":\"h1\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"5px\",\"style-margin-bottom\":\"5px\",\"style-margin-left\":\"15px\",\"style-margin-right\":\"15px\",\"textContent\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: center;\\\">Join the Community Q&amp;A Site to ask questions, get answers, and help others in the Joget Community.<\\/p>\",\"id\":\"8AD6FCE6BBFB49627220DA6E4DE65FAB\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"id\":\"621CF7BC07664DD825852D222B919A16\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-tablet-flex\":\"0 0 33%\",\"style-tablet-max-width\":\"33%\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<div class=\\\"main-wrapper\\\">\\r\\n    <a href=\\\"https://community.joget.org/\\\" target=\\\"_blank\\\">\\r\\n        <i class=\\\"material-icons fas fa-book\\\"><\\/i>\\r\\n    <\\/a>\\r\\n<\\/div>\",\"id\":\"B20A5F30800944CB296076241494CF21\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-text-align\":\"center\",\"style-color\":\"#343A40\",\"style-font-size\":\"21px\",\"textContent\":\"Knowledge Base\",\"id\":\"808A20B26280467A8F31182BDBF78FFD\",\"tagName\":\"h1\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"5px\",\"style-margin-bottom\":\"5px\",\"style-margin-left\":\"15px\",\"style-margin-right\":\"15px\",\"textContent\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: center;\\\">Access additional tutorials, user and developer reference, samples and other documentation.<\\/p>\",\"id\":\"E9EAF4281A684F0ECA39C4B324978987\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"id\":\"BE41109C1CBB492E7474017E93D04CED\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-tablet-flex\":\"0 0 33%\",\"style-tablet-max-width\":\"33%\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<div class=\\\"main-wrapper\\\">\\n    <a href=\\\"https://github.com/jogetworkflow/jw-community\\\" target=\\\"_blank\\\">\\n    <i class=\\\"material-icons fas fa-code-branch\\\"><\\/i><\\/a><\\/div>\",\"id\":\"C616412A3FB44FA6A2C7B4949907656B\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-text-align\":\"center\",\"style-color\":\"#343A40\",\"style-font-size\":\"21px\",\"textContent\":\"Open Source\",\"id\":\"11B4B133289A468D5F1F6729E1E1F429\",\"tagName\":\"h1\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"5px\",\"style-margin-bottom\":\"5px\",\"style-margin-left\":\"15px\",\"style-margin-right\":\"15px\",\"textContent\":\"<p class=\\\"CDesc\\\" style=\\\"text-align: center;\\\">Join the open source GitHub project to access and contribute to the source code.<\\/p>\",\"id\":\"E8239437D9154F869462544888F2B1B3\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"id\":\"761E8C1614324F8D0A868BA9A49DED5F\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-tablet-flex\":\"0 0 50%\",\"style-tablet-max-width\":\"50%\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<div class=\\\"main-wrapper\\\">\\r\\n    <a href=\\\"https://translate.joget.org/\\\" target=\\\"_blank\\\">\\r\\n\\t<i class=\\\"material-icons zmdi zmdi-translate\\\"><\\/i>\\r\\n\\t<\\/a>\\r\\n<\\/div>\",\"id\":\"DFE07F6328DC48E5F6AD604E5A3DF988\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-text-align\":\"center\",\"style-color\":\"#343A40\",\"style-font-size\":\"21px\",\"textContent\":\"Translations\",\"id\":\"97A86FEEDC2148C97BD9BA7DF81B3ACC\",\"tagName\":\"h1\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"5px\",\"style-margin-bottom\":\"5px\",\"style-margin-left\":\"15px\",\"style-margin-right\":\"15px\",\"textContent\":\"<p style=\\\"text-align: center;\\\">Get translations for more than 20 languages, and contribute to the translation effort in Joget Translations.<\\/p>\",\"id\":\"C0C8B006494F4856EB0E78D247563076\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"id\":\"0B8F084D0ECB450CBB9309079DBA3F08\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-tablet-flex\":\"0 0 50%\",\"style-tablet-max-width\":\"50%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"style-margin-bottom\":\"50px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"33%\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"33%\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"33%\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"50%\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"50%\"}],\"css-mobile-stack-columns\":\"true\",\"style-mobile-margin-bottom\":\"25px\",\"id\":\"5F7E5572513C4A9C7FFDCD2B12791585\",\"customId\":\"\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-color\":\"#343A40\",\"style-font-size\":\"1.35rem\",\"textContent\":\"Tutorial\",\"id\":\"CFEB99EA9DBF4F1E786EA7CD85A51C5C\",\"tagName\":\"h5\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-font-weight\":\"500\",\"style-color\":\"#5B6DD0\",\"style-font-size\":\"15px\",\"textContent\":\"<div class=\\\"fs-5 text-dark fw-bold text-hover-primary text-dark lh-base text-gray-600\\\">\\n<div class=\\\"fs-5 text-dark fw-bold text-hover-primary text-dark lh-base text-gray-600\\\">Get a quick overview of Joget from the introductory and overview video tutorials or learn the in-depth workings of Joget by signing up for a free course at the Joget Academy.<\\/div>\\n<\\/div>\",\"id\":\"DF5069B71D404BC8374EC367B647B0DD\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HorizontalRuleComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"2rem\",\"style-border-style\":\"dashed\",\"id\":\"77827FCA7C044260398026C2CE008735\",\"style-border-color\":\"#E4E6EF\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-color\":\"#626970\",\"style-font-size\":\"1.1rem\",\"textContent\":\"<i class=\\\"zmdi zmdi-collection-video\\\"><\\/i> Watch Introduction Videos - Build Your First App\",\"id\":\"F368BE55138E43561E62C8719624804F\",\"tagName\":\"h5\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<iframe class=\\\"embed-responsive-item card-rounded h-275px w-100\\\" src=\\\"https://www.youtube.com/embed/BXeqa6qkvUM\\\" allowfullscreen=\\\"allowfullscreen\\\" data-gtm-yt-inspected-11=\\\"true\\\" id=\\\"video1\\\" data-gtm-yt-inspected-31871541_91=\\\"true\\\" title=\\\"Part 1 -Designing a New App\\\" style=\\\"height: 250px;border-radius: 10px;border: none;\\\"><\\/iframe>\",\"id\":\"4A83CCC18A77400FE1477577F2DC9D5D\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-font-weight\":\"500\",\"style-color\":\"#7E8299\",\"style-font-size\":\"15px\",\"textContent\":\"Part 1 \\u2013 Designing a New App\",\"id\":\"D3E7B68AD8434AFA1162D0A1BD2F1E8C\",\"tagName\":\"h1\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"id\":\"9769BF334EAC41ADE04701449ECC1D4B\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"1C34EE3EBE9848CA9290D525732FFC66\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<iframe class=\\\"embed-responsive-item card-rounded h-275px w-100\\\" style=\\\"height: 250px;border-radius: 10px;border: none;\\\" src=\\\"https://www.youtube.com/embed/ANmu9ckiqvI\\\" allowfullscreen=\\\"allowfullscreen\\\" data-gtm-yt-inspected-11=\\\"true\\\" id=\\\"video2\\\" data-gtm-yt-inspected-31871541_91=\\\"true\\\" title=\\\"Part 2 - Designing a Form\\\"><\\/iframe>\\n\",\"id\":\"B75441D88B5B4DE0DA659877F679F871\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-font-weight\":\"500\",\"style-color\":\"#7E8299\",\"style-font-size\":\"15px\",\"textContent\":\"Part 2 \\u2013 Designing a Form\",\"id\":\"6BC20E13D28541740A42F6801EA6B4C0\",\"tagName\":\"h1\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-right\":\"0px\",\"style-mobile-padding-left\":\"0px\",\"id\":\"22036E48F4ED428A2C395D577F77A952\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"0C81E19C7D414DB77A1E910D5AEB3F0E\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"DBF708B6F3964ED6E1E3527F592BE463\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<iframe class=\\\"embed-responsive-item card-rounded h-275px w-100\\\" style=\\\"height: 250px;border-radius: 10px;border: none;\\\" src=\\\"https://www.youtube.com/embed/Z_mlAfVS_oQ\\\" allowfullscreen=\\\"allowfullscreen\\\" data-gtm-yt-inspected-11=\\\"true\\\" id=\\\"video3\\\" data-gtm-yt-inspected-31871541_91=\\\"true\\\" title=\\\"Part 3 - Designing a List\\\"><\\/iframe>\",\"id\":\"3D7D506DFDFB477B1432541ACDADD45E\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-font-weight\":\"500\",\"style-color\":\"#7E8299\",\"style-font-size\":\"15px\",\"textContent\":\"Part 3 \\u2013 Designing a List\",\"id\":\"CEF6F57620B24C09FA742C1958AB45F8\",\"tagName\":\"h1\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-right\":\"0px\",\"style-mobile-padding-left\":\"0px\",\"id\":\"604F03F4688F4730C6A45B78891BE099\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"A9E8AB80485642DF4FD5BFEE67659E62\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<iframe class=\\\"embed-responsive-item card-rounded h-275px w-100\\\" style=\\\"height: 250px;border-radius: 10px;border: none;\\\" src=\\\"https://www.youtube.com/embed/FxD6olBFwhc\\\" allowfullscreen=\\\"allowfullscreen\\\" data-gtm-yt-inspected-11=\\\"true\\\" id=\\\"video4\\\" data-gtm-yt-inspected-31871541_91=\\\"true\\\" title=\\\"Part 4 - Designing a UI\\\"><\\/iframe>\",\"id\":\"38DEE40749A24DEF344BD00C6D0BA8C7\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-font-weight\":\"500\",\"style-color\":\"#7E8299\",\"style-font-size\":\"15px\",\"textContent\":\"Part 4 \\u2013 Designing a Userview\",\"id\":\"1B8606420FA14065796051FF56C37FD4\",\"tagName\":\"h1\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-right\":\"0px\",\"style-mobile-padding-left\":\"0px\",\"id\":\"91ABA03A45E14746D71E5568CB4DFB69\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"48B7C16AF0F446B7B16218678EFB0FF9\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"2E35DA7D3E3F41BE9FFFE6B3095E6095\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<iframe class=\\\"embed-responsive-item card-rounded h-275px w-100\\\" style=\\\"height: 250px;border-radius: 10px;border: none;\\\" src=\\\"https://www.youtube.com/embed/nzM_UtLzutA\\\" allowfullscreen=\\\"allowfullscreen\\\" data-gtm-yt-inspected-11=\\\"true\\\" id=\\\"video5\\\" data-gtm-yt-inspected-31871541_91=\\\"true\\\" title=\\\"Part 5 - Designing a Process\\\"><\\/iframe>\\r\\n\",\"id\":\"898D066A4D744E109E7A08C98761EFFE\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-font-weight\":\"500\",\"style-color\":\"#7E8299\",\"style-font-size\":\"15px\",\"textContent\":\"Part 5 \\u2013 Designing a Process\",\"id\":\"D497C8FCFBDB46D19559CACA1167EDFC\",\"tagName\":\"h1\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-right\":\"0px\",\"style-mobile-padding-left\":\"0px\",\"id\":\"8BE14AADA62E46422F552810778B9BBE\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"262F4A346DAF444DBBC40BB513EFD3E6\"}},{\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"EE3EA7E194C54CBAD7411C0A92223D90\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"FE6369799C864C319066FB1AAFAE1FA3\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ImageComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-margin-left\":\"0px\",\"attr-width\":\"100%\",\"attr-height\":\"100%\",\"attr-src\":\"#request.contextPath#/images/appCenterAcademy.png\",\"id\":\"C9F5838828F049A21F098E81DC4A009A\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"id\":\"A99D175BE9164067C28453894C6E7C53\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-flex\":\"0 0 40%\",\"id\":\"9C75B6DE0177452D50EB1BB613D33D64\",\"style-max-width\":\"40%\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-color\":\"#343A40\",\"style-font-size\":\"22px\",\"textContent\":\"<span class=\\\"vc_icon_element-icon fa fa-graduation-cap\\\"><\\/span> Learn with Joget Academy\",\"id\":\"0EF2DB5B37ED49EDA9D6EA6AC824833D\",\"tagName\":\"h5\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-font-weight\":\"500\",\"style-color\":\"#5B6DD0\",\"style-font-size\":\"15px\",\"textContent\":\"<div class=\\\"fs-5 text-dark fw-bold text-hover-primary text-dark lh-base text-gray-600\\\">\\n<div class=\\\"fs-5 text-dark fw-bold text-hover-primary text-dark lh-base text-gray-600\\\"><span>Visit the Joget Academy and sign up for an online learning course.<\\/span><\\/div>\\n<\\/div>\",\"id\":\"93868F769F3D4CB314B88907E74A5B3C\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.Link\",\"properties\":{\"style-font-weight\":\"500\",\"userviewCacheDuration\":\"20\",\"userviewCacheScope\":\"\",\"style-color\":\"#009EF7\",\"style-font-size\":\"15px\",\"id\":\"32A9F7E3F580445877435EDE1CFF395B\",\"label\":\"Start Now\",\"type\":\"pagecomponent\",\"style-display\":\"block\",\"url\":\"https://academy.joget.org/lms/courses\",\"target\":\"blank\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-margin-top\":\"0px\",\"style-margin-top\":\"10%\",\"id\":\"115791FD766249624E4777C255B1BD31\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"D1F302CD595B4B4D50B779CCE33C9F14\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"40%\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"3B68A17E8CC04B5EFBCC70FA8D8D586D\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-padding-right\":\"10px\",\"style-margin-top\":\"20px\",\"style-padding-bottom\":\"10px\",\"style-border-style\":\"dashed\",\"style-margin-bottom\":\"20px\",\"id\":\"AED245A047CB49A6405198CF2B1AFCE7\",\"style-border-color\":\"#E4E6EF\",\"style-padding-top\":\"10px\",\"customId\":\"\",\"style-border-radius\":\"10px\",\"style-padding-left\":\"10px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-padding-bottom\":\"0px\",\"style-mobile-padding-right\":\"0px\",\"style-mobile-padding-left\":\"0px\",\"id\":\"DFE52E6DC6594F5D7A1208E35DFCCFBA\",\"customId\":\"\",\"style-mobile-padding-top\":\"0px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"id\":\"1525FB813CA84CC70A23890EEDEE9E54\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"id\":\"E28DDE2DA6A24615F1F18665B87591C1\",\"style-padding-top\":\"25px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#FFFFFF\",\"style-padding-bottom\":\"0px\",\"style-mobile-margin-left\":\"0%\",\"id\":\"CF9BE1662CEA47717282164F140A8E5A\",\"style-padding-top\":\"0px\",\"customId\":\"\",\"style-tablet-margin-right\":\"0%\",\"style-tablet-margin-left\":\"0%\",\"style-border-radius\":\"10px\",\"style-mobile-margin-right\":\"0%\"}},{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-0497CD0F62BD44DEEAF1294D58166A1A\"}}',NULL),
('appcenter',1,'up-4E2A517C3275429806518BAA8D29AB1F','Administration','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:43','2024-04-19 13:40:43','{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-color\":\"#3B4348\",\"textContent\":\"<i class=\\\"fas fa-digital-tachograph\\\"><\\/i> Administration\",\"id\":\"61316B62895446C4E93BFE40ED935E01\",\"tagName\":\"h3\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"25px\",\"style-color\":\"#000000\",\"textContent\":\"<i class=\\\"fas fa-tachometer-alt\\\"><\\/i> Monitor\",\"id\":\"AE25821C2F234BABD548048DEC4B2A33\",\"tagName\":\"h5\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'100%\', tags: \'light-bg grid\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}};\\n            background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;font-weight:600;\\\">\\n                {{header||STATUS}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#1ab394}}; \\n                             color:#fff;\\\">\\n                    {{headerTag||Daily}}\\n                <\\/span>\\n                {{reload}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div>  \\n    <div class=\\\"card-body row d-flex flex-wrap pb-0\\\">\\n        {{repeat||[{value: \\\"12\\\", title: \\\"Messages\\\", color: \\\"#ED5565\\\"},{value: \\\"28\\\", title: \\\"Posts\\\", color: \\\"#1ab394\\\"},{value: \\\"15\\\", title: \\\"Comments\\\", color: \\\"#23c6c8\\\"},{value: \\\"20\\\", title: \\\"News\\\", color: \\\"#1c84c6\\\"}]}}\\n            <div class=\\\"col-4\\\"\\n                 style=\\\"margin-bottom: 15px\\\">\\n                <a href=\\\"{{repeat.link}}\\\" \\n                   class=\\\"btn\\\"\\n                   style=\\\"background-color:{{repeat.color}};\\n                          color:#ffffff;\\n                          padding: 5px 10px;\\n                          margin-right:20px;\\n                          font-weight: 600;\\n                          opacity:1;\\\">\\n                   {{repeat.value}}\\n                <\\/a>  \\n                {{repeat.title}}\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"color\":\"#348fe2\",\"headerTag\":\"Last 4 hours\",\"tagColor\":\"#0BAB73\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\",\"bgImg\":\"\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"repeat\":[{\"color\":\"#348FE2\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\",\"title\":\"Total Transactions\",\"value\":\"#stats.transactionCount#\"},{\"color\":\"#ECBB0D\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\",\"title\":\"Total Slow Traces\",\"value\":\"#stats.slowTrace#\"},{\"color\":\"#E2344F\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\",\"title\":\"Total Error Count\",\"value\":\"#stats.errorCount#\"}],\"header\":\"Performance Data\",\"id\":\"9A46CFB43B564FB0834DBD24B25F5E15\",\"value\":\"3,291,922\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"style-margin-bottom\":\"15px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"BCC203BF2F024AFE154A9E9D1A6FF2E7\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag complex\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}};\\n            background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000\\\">\\n                {{header||VISITORS}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#1ab394}}; \\n                      color:#fff;\\\">\\n                    {{headerTag||Daily}}\\n                <\\/span>\\n                {{reload}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div>\\n    <div class=\\\"card-body row\\\">\\n        {{repeat||[{value: \\\"406,42\\\", subvalue: \\\"33% <i class=\\\\\\\"fa fa-level-up\\\\\\\"><\\/i>\\\", subtitle: \\\"Rapid pace\\\", color: \\\"#1ab394\\\"},{value: \\\"206,12\\\", subvalue: \\\"10% <i class=\\\\\\\"fa fa-level-up\\\\\\\"><\\/i>\\\", subtitle: \\\"Slow pace\\\", color: \\\"#8753de\\\"}]}}\\n            <div class=\\\"stats-info col-6\\\">\\n                <p style=\\\"font-size: 24px;\\n                color: rgba(0,0,0,.8);\\n                          margin-bottom: 0;\\\">\\n                    {{repeat.value}}\\n                <\\/p>\\n                <p style=\\\"color:{{repeat.color}}\\\">\\n                    <span style=\\\"font-weight:bold;\\\">\\n                        {{repeat.subvalue}}\\n                    <\\/span> \\n                    <span style=\\\"font-size:100%;\\\">\\n                        {{repeat.subtitle}}\\n                    <\\/span>\\n                <\\/p>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"color\":\"#348fe2\",\"headerTag\":\"Latest\",\"tagColor\":\"#0BAB73\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/running\');\",\"bgImg\":\"\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"style-font-weight\":\"500\",\"reload\":\"\",\"bgColor\":\"\",\"style-margin-bottom\":\"15px\",\"repeat\":[{\"color\":\"#119C5D\",\"subvalue\":\"\",\"subtitle\":\"Running Process\",\"value\":\"#stats.runningProcess#\"},{\"color\":\"#B2B2B2\",\"subvalue\":\"\",\"subtitle\":\"Completed Process\",\"value\":\"#stats.completedProcess#\"}],\"header\":\"All Process\",\"id\":\"E213F291CC434CD89583F4D4B616D8EB\",\"value\":\"3,291,922\",\"height\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg icon\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#ff5b57}};\\n            background-image:url(\'{{bgImg}}\');  \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body text-center\\\">\\n        <div class=\\\"stats-icon\\\" \\n             style=\\\"font-size: 42px; \\n                    color: #fff; \\n                    line-height:0;\\\">\\n            {{icon||<i class=\\\"fas fa-globe\\\"><\\/i>}}\\n        <\\/div>\\n        <div class=\\\"stats-info\\\">\\n            <p style=\\\"font-size: 18px; \\n                      font-weight: 600; \\n                      margin-bottom: 0;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n            <h4 style=\\\"font-size: 12px; \\n                       font-weight:bold; \\n                       margin: 5px 0;\\\">\\n                {{title||VISITS}}\\n            <\\/h4>\\n            {{description||<div style=\\\"font-size:80%;\\\">daily<\\/div>}}\\n        <\\/div>\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"color\":\"#009EF7\",\"icon\":\"<i class=\\\"fas fa-scroll\\\"><\\/i>\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/slogs\');\",\"style-height\":\"100%\",\"description\":\"Click to View Logs\",\"bgImg\":\"\",\"title\":\"System Log\",\"customId\":\"\",\"reload\":\"\",\"id\":\"AA855960088C49D046A9B063C87AE4FC\",\"value\":\"<br>\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg icon\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#ff5b57}};\\n            background-image:url(\'{{bgImg}}\');  \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body text-center\\\">\\n        <div class=\\\"stats-icon\\\" \\n             style=\\\"font-size: 42px; \\n                    color: #fff; \\n                    line-height:0;\\\">\\n            {{icon||<i class=\\\"fas fa-globe\\\"><\\/i>}}\\n        <\\/div>\\n        <div class=\\\"stats-info\\\">\\n            <p style=\\\"font-size: 18px; \\n                      font-weight: 600; \\n                      margin-bottom: 0;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n            <h4 style=\\\"font-size: 12px; \\n                       font-weight:bold; \\n                       margin: 5px 0;\\\">\\n                {{title||VISITS}}\\n            <\\/h4>\\n            {{description||<div style=\\\"font-size:80%;\\\">daily<\\/div>}}\\n        <\\/div>\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"color\":\"#080655\",\"icon\":\"<i class=\\\"fas fa-server\\\"><\\/i>\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/apm\');\",\"style-height\":\"100%\",\"description\":\"Cluster Nodes Found\",\"bgImg\":\"\",\"title\":\"#stats.nodeCount#\",\"customId\":\"\",\"reload\":\"\",\"id\":\"13C1564E98D84E1BF6C0F65A79423E8C\",\"value\":\"<br>\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"794DA766B69D466F3C25A3F591C2C3FF\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-flex\":\"0 0 40%\",\"style-max-width\":\"40%\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}};\\n            background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\" style=\\\"color:#000;font-weight:600;\\\">\\n                {{header||VISITORS}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#1ab394}}; \\n                             color:#fff;\\\">\\n                    {{headerTag||Daily}}\\n                <\\/span>\\n                {{reload}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2\\\">\\n        {{repeat||[{value: \\\"10/200 GB\\\", title: \\\"Memory\\\", color: \\\"#ED5565\\\", \'progressbar-value\' : \'60\'},{value: \\\"20 GB\\\", title: \\\"Bandwidth\\\", color: \\\"#23c6c8\\\", \'progressbar-value\' : \'50\'},{value: \\\"73%\\\", title: \\\"Activity\\\", color: \\\"#1c84c6\\\", \'progressbar-value\' : \'73\'}]}}\\n            <div class=\\\"px-3 pb-2\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"color\":\"#348fe2\",\"headerTag\":\"Latest\",\"tagColor\":\"#0BAB73\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/monitor/governance\');\",\"style-height\":\"98%\",\"bgImg\":\"\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"repeat\":[{\"color\":\"#A9A9A9\",\"progressbar-value\":\"#stats.ResponseTimesCheck#\",\"title\":\"Response Times\",\"value\":\"#stats.ResponseTimesCheck#  %\"},{\"color\":\"#A9A9A9\",\"progressbar-value\":\"#stats.MemoryUsageCheck#\",\"title\":\"Memory Usage\",\"value\":\"#stats.MemoryUsageCheck#  %\"},{\"color\":\"#A9A9A9\",\"progressbar-value\":\"#stats.CpuUsageCheck#\",\"title\":\"CPU Usage\",\"value\":\"#stats.CpuUsageCheck#  %\"},{\"color\":\"#A9A9A9\",\"progressbar-value\":\"#stats.DbConnectionsCheck#\",\"title\":\"DB Connections\",\"value\":\"#stats.DbConnectionsCheck#  %\"},{\"color\":\"#A9A9A9\",\"progressbar-value\":\"#stats.ErrorRateCheck#\",\"title\":\"Error Rate\",\"value\":\"#stats.ErrorRateCheck#  %\"}],\"header\":\"Governance Health Check (%)\",\"id\":\"FF13DE7F3F4249C90D7FDA32EAE9A358\",\"value\":\"3,291,922\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-flex\":\"0 0 60%\",\"style-max-width\":\"60%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"40%\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"60%\",\"style-tablet-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"CD6B604C45F24C869CC610CBCED7C1CA\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"25px\",\"style-color\":\"#000000\",\"textContent\":\"<i class=\\\"fas fa-th\\\"><\\/i> Apps\",\"id\":\"2918970A648D440752EA19A4ADF0E9C8\",\"tagName\":\"h5\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"linkLabel\":\"View All Apps\",\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg link pie\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#8753de}}; \\n            background-image:url(\'{{bgImg}}\'); \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body row\\\">\\n        <div class=\\\"stats-icon col-4 pl-0 d-flex align-items-center\\\">\\n            <div id=\\\"chart-{{id}}\\\"\\n                 style=\\\"color:#000\\\" \\n                 data-chart-type=\\\"pie\\\" \\n                 data-chart-custom=\\\"{{chartConfig}}\\\" \\n                 data-chart-colors=\\\"{{chartColors}}\\\"  \\n                 data-chart-labels=\\\"{{chartLabels||Item 1,Item 2,Item 3,Item 4}}\\\"\\n                 data-chart-values=\\\"{{chartData||[25, 66, 41, 89]}}\\\">\\n            <\\/div>\\n        <\\/div>\\n        <div class=\\\"stats-info col-8 text-right\\\">\\n            <p style=\\\"font-size: 24px; \\n                      font-weight: 600; \\n                      color: #000;\\n                      margin-bottom: 0;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n            <h4 style=\\\"font-size: 15px;\\n                       margin: 5px 0;\\n                       color: rgba(0,0,0,.6);\\\">\\n                {{title||TOTAL VISITORS}}\\n            <\\/h4>\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"card-footer text-right\\\" \\n                style=\\\"padding:5px 15px; \\n                       background:rgba(0,0,0,.6); \\n                       color:rgba(255,255,255,0.6) !important;\\\">\\n        <a style=\\\"color: inherit; \\n                  font-size:12px;\\\" \\n           href=\\\"{{link||#}}\\\">\\n            {{linkLabel||View Detail}} \\n            <i class=\\\"fas fa-arrow-alt-circle-right\\\"><\\/i>\\n        <\\/a>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#FFFFFF\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/desktop/apps\');\",\"bgImg\":\"\",\"title\":\"Total Apps\",\"customId\":\"1\",\"chartData\":\"{data: [#stats.publishedAppCount#,#stats.unpublishedAppCount#]}\",\"chartConfig\":\"\",\"reload\":\"\",\"id\":\"8FF3FFF7314E4E46779C1F72CB4DA113\",\"value\":\"#stats.app.total#\",\"chartLabels\":\"Publish App, UnPublished App\",\"chartColors\":\"#50cd89,#ffc700\",\"height\":\"100%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'light-bg pie\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch\\\" \\n     style=\\\"height:{{height}};\\n            background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-icon col-4 py-3 pr-0 d-flex align-items-center\\\">\\n        <div id=\\\"chart-{{id}}\\\" \\n             data-chart-type=\\\"pie\\\" \\n             data-chart-custom=\\\"{{chartConfig}}\\\" \\n             data-chart-config=\\\"{theme:{monochrome: {enabled: true,shadeTo: \'light\', color: \'{{color||#ff5b57}}\', shadeIntensity: 0.6}}}\\\"  \\n             data-chart-labels=\\\"{{chartLabels||Item 1,Item 2,Item 3,Item 4}}\\\"\\n             data-chart-values=\\\"{{chartData||[25, 66, 41, 89]}}\\\">\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8 text-right\\\">\\n        <p style=\\\"font-size: 24px; \\n                  color: rgba(0,0,0,.8);\\n                  font-weight: 600; \\n                  margin-bottom: 10px;\\\">\\n            {{value||3,291,922}}\\n        <\\/p>\\n        <h4 style=\\\"font-size: 15px;\\n                   color: rgba(0,0,0,.6);\\n                   margin: 5px 0;\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#3F84F4\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"bgImg\":\"\",\"title\":\"Total Forms\",\"customId\":\"\",\"chartData\":\"{data:[#stats.form.countPerApp#]}\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"642ED203501E45361102BB1E99CC80B9\",\"value\":\"#stats.form.total#\",\"chartLabels\":\"#stats.appList#\",\"chartColors\":\"\",\"height\":\"100%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'light-bg pie\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch\\\" \\n     style=\\\"height:{{height}};\\n            background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-icon col-4 py-3 pr-0 d-flex align-items-center\\\">\\n        <div id=\\\"chart-{{id}}\\\" \\n             data-chart-type=\\\"pie\\\" \\n             data-chart-custom=\\\"{{chartConfig}}\\\" \\n             data-chart-config=\\\"{theme:{monochrome: {enabled: true,shadeTo: \'light\', color: \'{{color||#ff5b57}}\', shadeIntensity: 0.6}}}\\\"  \\n             data-chart-labels=\\\"{{chartLabels||Item 1,Item 2,Item 3,Item 4}}\\\"\\n             data-chart-values=\\\"{{chartData||[25, 66, 41, 89]}}\\\">\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8 text-right\\\">\\n        <p style=\\\"font-size: 24px;\\n                    color: rgba(0,0,0,.8);\\n                  font-weight: 600; \\n                  margin-bottom: 10px;\\\">\\n            {{value||3,291,922}}\\n        <\\/p>\\n        <h4 style=\\\"font-size: 15px;\\n                   color: rgba(0,0,0,.6);\\n                   margin: 5px 0;\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#6638B6\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"bgImg\":\"\",\"title\":\"Total Lists\",\"customId\":\"\",\"chartData\":\"{data:[#stats.list.countPerApp#]}\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"7C84A4735ACE41910D97582AE29F05D6\",\"value\":\"#stats.list.total#\",\"chartLabels\":\"#stats.appList#\",\"chartColors\":\"\",\"height\":\"100%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'light-bg pie\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch\\\" \\n     style=\\\"height:{{height}};\\n            background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-icon col-4 py-3 pr-0 d-flex align-items-center\\\">\\n        <div id=\\\"chart-{{id}}\\\" \\n             data-chart-type=\\\"pie\\\" \\n             data-chart-custom=\\\"{{chartConfig}}\\\" \\n             data-chart-config=\\\"{theme:{monochrome: {enabled: true,shadeTo: \'light\', color: \'{{color||#ff5b57}}\', shadeIntensity: 0.6}}}\\\"  \\n             data-chart-labels=\\\"{{chartLabels||Item 1,Item 2,Item 3,Item 4}}\\\"\\n             data-chart-values=\\\"{{chartData||[25, 66, 41, 89]}}\\\">\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8 text-right\\\">\\n        <p style=\\\"font-size: 24px; \\n        color: rgba(0,0,0,.8);\\n                  font-weight: 600; \\n                  margin-bottom: 10px;\\\">\\n            {{value||3,291,922}}\\n        <\\/p>\\n        <h4 style=\\\"font-size: 15px;\\n                   color: rgba(0,0,0,.6);\\n                   margin: 5px 0;\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#FFC107\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"bgImg\":\"\",\"title\":\"Total UIs\",\"customId\":\"\",\"chartData\":\"{data:[#stats.UI.countPerApp#]}\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"24667F714AE04B6CF1825FD92A25A3C7\",\"value\":\"#stats.UI.total#\",\"chartLabels\":\"#stats.appList#\",\"chartColors\":\"\",\"height\":\"100%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"style-margin-bottom\":\"15px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"0AAA340B0C694E6285CA9FC83B9CB308\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"25px\",\"style-color\":\"#000000\",\"textContent\":\"<i class=\\\"fas fa-users\\\"><\\/i> Users\",\"id\":\"3E8D0FCDBF9D44423CDE018F0F2F2E7C\",\"tagName\":\"h5\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"linkLabel\":\"View All Users\",\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg link donut\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#8753de}}; \\n            background-image:url(\'{{bgImg}}\'); \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body row\\\">\\n        <div class=\\\"stats-info col-8\\\">\\n            <h4 style=\\\"font-size: 15px;\\n                       margin: 5px 0;\\n                        color: rgba(0,0,0,.6);\\\">\\n                {{title||TOTAL VISITORS}}\\n            <\\/h4>\\n            <p style=\\\"font-size: 24px; \\n                      font-weight: 600; \\n                      color:#000;\\n                      margin-bottom: 0;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n        <\\/div>\\n        <div class=\\\"stats-icon col-4 pl-0 d-flex align-items-center\\\"\\n             style=\\\"color:#000\\\">\\n            <div id=\\\"chart-{{id}}\\\" \\n                 data-chart-type=\\\"donut\\\" \\n                 data-chart-custom=\\\"{{chartConfig}}\\\" \\n                 data-chart-colors=\\\"{{chartColors}}\\\"   \\n                 data-chart-config=\\\"{stroke:{width: 1}}\\\"  \\n                 data-chart-labels=\\\"{{chartLabels||Item 1,Item 2,Item 3,Item 4}}\\\"\\n                 data-chart-values=\\\"{{chartData||[25, 66, 41, 89]}}\\\">\\n            <\\/div>\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"card-footer text-right\\\" \\n                style=\\\"padding:5px 15px; \\n                       background:rgba(0,0,0,.6); \\n                       color:rgba(255,255,255,0.6) !important;\\\">\\n        <a style=\\\"color: inherit; \\n                  font-size:12px;\\\" \\n           href=\\\"{{link||#}}\\\">\\n            {{linkLabel||View Detail}} \\n            <i class=\\\"fas fa-arrow-alt-circle-right\\\"><\\/i>\\n        <\\/a>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#FFFFFF\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/directory/users\');\",\"bgImg\":\"\",\"title\":\"Total Users\",\"customId\":\"\",\"chartData\":\"{data: [#stats.user.active#,#stats.user.inactive#]}\",\"chartConfig\":\"\",\"reload\":\"\",\"id\":\"8FD4AAB012DC44587255D037E3C1D1DC\",\"value\":\"#stats.user.total#\",\"chartLabels\":\"Active User, Inactive User\",\"chartColors\":\"#7239ea,#009EF7\",\"height\":\"100%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"linkLabel\":\"View All Groups\",\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg link bar\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#8753de}}; \\n            background-image:url(\'{{bgImg}}\'); \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body row\\\">\\n        <div class=\\\"stats-info col-8\\\">\\n            <h4 style=\\\"font-size: 15px;\\n                       margin: 5px 0;\\n                       color: rgba(255,255,255,.7);\\\">\\n                {{title||TOTAL VISITORS}}\\n            <\\/h4>\\n            <p style=\\\"font-size: 24px; \\n                      font-weight: 600; \\n                      margin-bottom: 0;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n        <\\/div>\\n        <div class=\\\"stats-icon col-4 pl-0 d-flex align-items-center\\\">\\n            <div id=\\\"chart-{{id}}\\\"\\n                 style=\\\"color:#000\\\" \\n                 data-chart-type=\\\"bar\\\" \\n                 data-chart-custom=\\\"{{chartConfig}}\\\" \\n                 data-chart-color=\\\"#fff\\\"\\n                 data-chart-labels=\\\"{{chartLabels||Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec}}\\\"\\n                 data-chart-values=\\\"{{chartData||[{data:[25, 66, 41, 89, 63, 25, 44, 12, 36, 9, 54, 33]}]}}\\\">\\n            <\\/div>\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"card-footer text-right\\\" \\n                style=\\\"padding:5px 15px; \\n                       background:rgba(0,0,0,.6); \\n                       color:rgba(255,255,255,0.6) !important;\\\">\\n        <a style=\\\"color: inherit; \\n                  font-size:12px;\\\" \\n           href=\\\"{{link||#}}\\\">\\n            {{linkLabel||View Detail}} \\n            <i class=\\\"fas fa-arrow-alt-circle-right\\\"><\\/i>\\n        <\\/a>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#1D325E\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/directory/groups\');\",\"style-height\":\"100%\",\"bgImg\":\"\",\"title\":\"Total Groups\",\"customId\":\"\",\"chartData\":\"[{data:[#stats.group.countPerGroup#]}]\",\"chartConfig\":\"\",\"reload\":\"\",\"id\":\"4BBD819578914F8AFA97A55420FB2D36\",\"value\":\"#stats.group.total#\",\"chartLabels\":\"#stats.groupList#\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"style-margin-bottom\":\"15px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"5FF2FCA311A14C3C45C25F5D12EA3837\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"25px\",\"style-color\":\"#000000\",\"textContent\":\"<i class=\\\"fas fa-cogs\\\"><\\/i> Settings\",\"id\":\"10DC2D3359884080BCF09222D7B54A9E\",\"tagName\":\"h5\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"linkLabel\":\"Click to View More Settings\",\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg icon\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#ff5b57}};\\n            background-image:url(\'{{bgImg}}\');  \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body text-center\\\">\\n        <div class=\\\"stats-icon\\\" \\n             style=\\\"font-size: 42px; \\n                    color: #fff; \\n                    line-height:0;\\\">\\n            {{icon||<i class=\\\"fas fa-globe\\\"><\\/i>}}\\n        <\\/div>\\n        <div class=\\\"stats-info\\\">\\n            <p style=\\\"font-size: 18px; \\n                      font-weight: 600; \\n                      margin-bottom: 0;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n            <h4 style=\\\"font-size: 12px; \\n                       font-weight:bold; \\n                       margin: 5px 0;\\\">\\n                {{title||VISITS}}\\n            <\\/h4>\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"card-footer text-right\\\" \\n                style=\\\"padding:5px 15px; \\n                       background:rgba(0,0,0,.6); \\n                       color:rgba(255,255,255,0.6) !important;\\\">\\n        <a style=\\\"color: inherit; \\n                  font-size:12px;\\\" \\n           href=\\\"{{link||#}}\\\">\\n            {{linkLabel||View Detail}} \\n            <i class=\\\"fas fa-arrow-alt-circle-right\\\"><\\/i>\\n        <\\/a>\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"color\":\"#5734E2\",\"icon\":\"<i class=\\\"fas fa-cogs\\\"><\\/i>\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/setting/general\');\",\"style-height\":\"100%\",\"description\":\"\",\"bgImg\":\"\",\"title\":\"General Settings\",\"customId\":\"\",\"reload\":\"\",\"id\":\"7711DBF482644DCC04F151AC7DAD98DF\",\"value\":\"<br>\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"linkLabel\":\"System Information\",\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg icon link\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#8753de}}; \\n            background-image:url(\'{{bgImg}}\'); \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body row\\\">\\n        <div class=\\\"stats-info col-12\\\">\\n            <h4 style=\\\"font-size: 20px;\\n                    font-weight: 600;\\n                       margin: 0px 0;\\n                       margin-bottom: 15px;\\n                       color: rgba(255,255,255,.7);\\\">\\n                {{title||TOTAL VISITORS}}\\n            <\\/h4>\\n            <p style=\\\"font-size: 13px; \\n                      font-weight: 600; \\n                      margin-bottom: 0px;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"card-footer text-right\\\" \\n                style=\\\"padding:5px 15px; \\n                       background:rgba(0,0,0,.6); \\n                       color:rgba(255,255,255,0.6) !important;\\\">\\n        <a style=\\\"color: inherit; \\n                  font-size:12px;\\\" \\n           href=\\\"{{link||#}}\\\">\\n            {{linkLabel||View Detail}} \\n            <i class=\\\"fas fa-arrow-alt-circle-right\\\"><\\/i>\\n        <\\/a>\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"zmdi zmdi-globe-alt\\\"><\\/i>\",\"link\":\"javascript:AdminBar.showQuickOverlay(\'#request.baseURL#/web/console/setting/sysinfo\');\",\"style-height\":\"100%\",\"bgImg\":\"\",\"title\":\"Version\",\"customId\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"833C998482894E3D11E5AA01FA76291A\",\"value\":\"@@enterprise.console.footer.message@@<br>@@console.footer.label.revision@@\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"20DB6C4EFAB24BDFB4E28B244528DA38\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"6BE4850CA13040D6D88E42244DF067AA\"}},{\"className\":\"menu-component\"},{\"elements\":[{\"elements\":[],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-flex\":\"0 0 100%\",\"style-max-width\":\"100%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"100%\",\"style-tablet-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"7F88094D03C249DB76B9FC711B7C87F7\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-4E2A517C3275429806518BAA8D29AB1F\"}}',NULL),
('appcenter',1,'up-8C70B71371B942B6D48A7E9B4C1DB8D1','Home','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:43','2024-04-19 13:40:43','{\"elements\":[{\"elements\":[{\"elements\":[{\"elements\":[{\"elements\":[],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-mobile-margin-top\":\"15px\",\"style-margin-top\":\"30px\",\"style-text-align\":\"center\",\"style-margin-bottom\":\"20px\",\"permission_rules\":{\"F6E97C06864E4F62843B259A8C9AB1AD\":{\"hidden\":\"true\"},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"style-color\":\"#FFFFFF\",\"style-mobile-margin-bottom\":\"15px\",\"style-font-size\":\"13px\",\"attr-data-events-triggering\":[],\"id\":\"8358CCF066424B1AF09EBF61A96EAFC5\",\"customId\":\"assignment_msg\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-position\":\"absolute\",\"permission_rules\":{\"F6E97C06864E4F62843B259A8C9AB1AD\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"style-color\":\"#FFFFFF\",\"style-line-height\":\"40px\",\"style-font-size\":\"20px\",\"textContent\":\" \",\"attr-data-events-triggering\":[],\"tagName\":\"h3\",\"customId\":\"clock\",\"style-top\":\"35px\",\"style-margin-top\":\"0px\",\"style-right\":\"15px\",\"style-text-align\":\"left\",\"style-margin-bottom\":\"0px\",\"id\":\"E92400A7CBAD40DC6E28B620D44D34D6\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-font-weight\":\"500\",\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"F6E97C06864E4F62843B259A8C9AB1AD\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"style-color\":\"#7E8299\",\"style-margin-right\":\"10px\",\"textContent\":\"#i18n.Design New App#\",\"attr-data-events-triggering\":[],\"attr-href\":\"design_app\",\"id\":\"8EFC9D21190A4BFBE31A945826FF6B34\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-font-weight\":\"500\",\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"F6E97C06864E4F62843B259A8C9AB1AD\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"style-color\":\"#7E8299\",\"style-margin-right\":\"15px\",\"attr-onclick\":\"appImport();return false;\",\"textContent\":\"#i18n.Import App#\",\"attr-data-events-triggering\":[],\"attr-href\":\"#\",\"id\":\"10862931081E4DF47D44CCDFC696CAD6\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ButtonComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-font-weight\":\"500\",\"css-display-type\":\"btn btn-light\",\"permission_rules\":{\"F6E97C06864E4F62843B259A8C9AB1AD\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"style-color\":\"#7E8299\",\"attr-onclick\":\"AdminBar.showQuickOverlay(\\\"#request.contextPath#/web/desktop/marketplace/app?url=\\\" + encodeURIComponent(\\\"#platform.marketplaceUrl#\\\"));return false\",\"textContent\":\"#i18n.Download from Marketplace#\",\"attr-data-events-triggering\":[],\"attr-href\":\"#\",\"id\":\"07863BFB349747ED1A6E45812F7C5F97\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-padding-bottom\":\"0px\",\"style-text-align\":\"center\",\"hidden\":\"true\",\"style-margin-bottom\":\"0px\",\"permission_rules\":{\"F6E97C06864E4F62843B259A8C9AB1AD\":{\"hidden\":\"true\"},\"58F9FBEA76264BE037991759BC1645A2\":{\"hidden\":\"\"}},\"attr-data-events-triggering\":[],\"id\":\"96141190357145C9478235142772AEC5\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.ScriptComponent\",\"properties\":{\"attr-data-events-listening\":[],\"permission_rules\":{\"F6E97C06864E4F62843B259A8C9AB1AD\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"attr-data-events-triggering\":[],\"id\":\"66465E19B19A4481B8BD32BD9BBC0D83\",\"customId\":\"\",\"script\":\"$(function(){\\n    window[\\\"ajaxContentPlaceholder\\\"][\\\"#request.contextPath#/web/userview/appcenter/v/_/home\\\"] = \\\"dashboard\\\";\\n    \\n    var updateClock = function(clock, day){\\n        var date = new Date();\\n        var ampm = date.getHours() < 12 ? \'AM\' : \'PM\';\\n        var hours = date.getHours() == 0\\n                  ? 12\\n                  : date.getHours() > 12\\n                    ? date.getHours() - 12\\n                    : date.getHours();\\n        var minutes = date.getMinutes() < 10 \\n                    ? \'0\' + date.getMinutes() \\n                    : date.getMinutes();\\n        var style = $(clock).find(\\\"style\\\"); \\n        var dstyle = $(day).find(\\\"style\\\"); \\n        $(clock).text(hours + \\\":\\\" + minutes + \\\" \\\" + ampm);\\n        $(day).text(date.toLocaleDateString(\\\"en-US\\\", { weekday: \'long\', year: \'numeric\', month: \'long\', day: \'numeric\' }));\\n        $(clock).append(style);\\n        $(day).append(dstyle);\\n    };\\n    \\n    var clock = $(\\\"#clock\\\");\\n    var day = $(\\\"#date\\\")\\n    if (clock.length > 0) {\\n        updateClock(clock, day);\\n        window.setInterval(function() {\\n            updateClock(clock, day);\\n        }, 10000);\\n    }\\n    \\n    $(\\\".inbox-notification\\\").off(\\\"inbox_notification_updated\\\");\\n    $(\\\".inbox-notification\\\").on(\\\"inbox_notification_updated\\\", function(){\\n        var style = $(\\\"#assignment_msg\\\").find(\\\"style\\\");        \\n        $(\\\"#assignment_msg\\\").html(\'<h3 style=\\\"color:#fff;\\\">Hello #currentUser.firstName#, <\\/h3><a style=\\\"color:#fff;opacity: 0.75 !important;\\\" href=\\\"#request.baseURL#/web/userview/appcenter/home/_/_ja_inbox\\\"><h5>\' + $(\\\".inbox-notification .dropdown-menu-title span\\\").text() + \'<h5><\\/a>\');\\n        $(\\\"#assignment_msg\\\").append(style);\\n    });\\n    \\n    $(\\\".inbox-notification\\\").trigger(\\\"inbox_notification_updated\\\");\\n});\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"permission_rules\":{\"F6E97C06864E4F62843B259A8C9AB1AD\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"attr-data-events-triggering\":[],\"id\":\"970F3C4619204E5D5F9253C3A2B9D8A3\",\"customId\":\"inbox_container\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-top\":\"15px\",\"style-position\":\"absolute\",\"style-color\":\"#FFFFFF\",\"style-left\":\"30px\",\"textContent\":\"<i class=\\\"zmdi zmdi-apps\\\"><\\/i> App Center\",\"id\":\"41B14E1F2C034F11E6F29E4A157C3FEC\",\"tagName\":\"h1\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-top\":\"15px\",\"style-right\":\"15px\",\"style-position\":\"absolute\",\"style-text-align\":\"center\",\"permission_rules\":{\"F6E97C06864E4F62843B259A8C9AB1AD\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"style-color\":\"#FFFFFF\",\"style-font-size\":\"20px\",\"textContent\":\" \",\"id\":\"681B2A6A3E604CDA411A34255B7BD9E3\",\"tagName\":\"h6\",\"customId\":\"date\"}},{\"permission_rules\":{\"F6E97C06864E4F62843B259A8C9AB1AD\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-custom\":\"padding:20px;\",\"style-flex\":\"0 0 100%\",\"style-background-image\":\"#request.contextPath#/images/appCenterBanner.png\",\"style-max-width\":\"100%\",\"style-mobile-padding-top\":\"80px\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"col-0-style-custom\":\"padding:20px;\",\"col-1-style-tablet-custom\":\"padding:80px 40px 40px 20px;\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"100%\",\"style-tablet-max-width\":\"\"}],\"permission_rules\":{\"F6E97C06864E4F62843B259A8C9AB1AD\":{},\"58F9FBEA76264BE037991759BC1645A2\":{}},\"col-1-style-custom\":\"padding:80px 80px 40px 20px;\",\"css-mobile-stack-columns\":\"true\",\"attr-data-events-triggering\":[],\"customId\":\"home_column\",\"col-0-style-mobile-padding-top\":\"80px\",\"gutter\":\"\",\"id\":\"74DC9C5E101D4BB4D955B3B9C5FE48D3\",\"col-0-style-background-image\":\"#request.contextPath#/images/appCenterBanner.png\",\"col-1-style-mobile-custom\":\"padding: 0px 20px 20px;\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-8C70B71371B942B6D48A7E9B4C1DB8D1\"}}',NULL),
('appcenter',1,'up-95447DD6260B48B2E00C1354A179CD44','Templates','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:43','2024-04-19 13:40:43','{\"elements\":[{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-95447DD6260B48B2E00C1354A179CD44\"}}',NULL),
('crm',1,'INTERNAL_TAGGING','Tagging','internal','2024-04-19 13:40:02','2024-04-19 13:40:02','{\n  \"labels\" : {\n    \"t01\" : {\n      \"color\" : \"red\"\n    },\n    \"t02\" : {\n      \"color\" : \"pink\"\n    },\n    \"t03\" : {\n      \"color\" : \"orange\"\n    },\n    \"t04\" : {\n      \"color\" : \"yellow\"\n    },\n    \"t05\" : {\n      \"color\" : \"green\"\n    },\n    \"t06\" : {\n      \"color\" : \"lime\"\n    },\n    \"t07\" : {\n      \"color\" : \"blue\"\n    },\n    \"t08\" : {\n      \"color\" : \"sky\"\n    },\n    \"t09\" : {\n      \"color\" : \"purple\"\n    },\n    \"t10\" : {\n      \"color\" : \"black\"\n    }\n  },\n  \"datas\" : {\n    \"form\" : {\n      \"crm_proposal_approval_form\" : [ \"t01\" ],\n      \"crm_proposal_resubmit_form\" : [ \"t01\" ],\n      \"crm_proposal_form\" : [ \"t01\" ],\n      \"crm_proposal_sending_form\" : [ \"t01\" ],\n      \"AccountsMain\" : [ \"t07\" ],\n      \"crm_account\" : [ \"t07\" ],\n      \"AccountContacts\" : [ \"t05\" ],\n      \"AccountContactSub\" : [ \"t05\" ],\n      \"crm_contact\" : [ \"t05\" ],\n      \"Users\" : [ \"t09\" ],\n      \"crm_opportunity\" : [ \"t03\" ]\n    },\n    \"list\" : {\n      \"ProposalsDashboard\" : [ \"t01\" ],\n      \"Users\" : [ \"t09\" ],\n      \"UsersDashboard\" : [ \"t09\" ],\n      \"ProposalDashboardInbox\" : [ \"t01\" ],\n      \"Proposal\" : [ \"t01\" ],\n      \"ContactDashboard\" : [ \"t05\" ],\n      \"crm_opportunity_list\" : [ \"t03\" ],\n      \"crm_account_list\" : [ \"t07\" ],\n      \"AccountsDashboard\" : [ \"t07\" ],\n      \"crm_contact_list\" : [ \"t05\" ],\n      \"OpportunityDashboard\" : [ \"t03\" ]\n    },\n    \"userview\" : {\n      \"crm_userview_sales\" : [ \"t02\" ]\n    }\n  }\n}',NULL),
('crm',1,'up-4119535788344E2780088BE6E9701674','CRM Dashboard','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:02','2024-04-19 13:40:02','{\"elements\":[{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch border-0\\\" style=\\\"background-color:{{color||#348fe2}}; color:#fff;\\\">\\n    <div class=\\\"stats-icon col-4 py-3 d-flex align-items-center justify-content-center rounded-left\\\" style=\\\"background:rgba(0,0,0,.4); font-size: 48px; color: #fff;\\\">\\n        {{icon||<i class=\\\"fas fa-globe\\\"><\\/i>}}\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8\\\">\\n        <p style=\\\"font-size: 24px; font-weight: 600; margin-bottom: 10px;\\\">{{value||3,291,922}}<\\/p>\\n        <h4 style=\\\"font-size: 12px;margin: 5px 0;\\\">{{title||TOTAL VISITORS}}<\\/h4>\\n    <\\/div>\\n<\\/div>\",\"color\":\"#FF9000\",\"icon\":\"<i class=\\\"fas fa-address-book\\\"><\\/i>\",\"link\":\"account_list\",\"id\":\"71DC3AF8D8B64F7A81C98CC1437643B5\",\"title\":\"NUMBER OF ACCOUNTS\",\"customId\":\"\",\"value\":\"#datalist.total.AccountsDashboard#\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch border-0\\\" style=\\\"background-color:{{color||#348fe2}}; color:#fff;\\\">\\n    <div class=\\\"stats-icon col-4 py-3 d-flex align-items-center justify-content-center rounded-left\\\" style=\\\"background:rgba(0,0,0,.4); font-size: 48px; color: #fff;\\\">\\n        {{icon||<i class=\\\"fas fa-globe\\\"><\\/i>}}\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8\\\">\\n        <p style=\\\"font-size: 24px; font-weight: 600; margin-bottom: 10px;\\\">{{value||3,291,922}}<\\/p>\\n        <h4 style=\\\"font-size: 12px;margin: 5px 0;\\\">{{title||TOTAL VISITORS}}<\\/h4>\\n    <\\/div>\\n<\\/div>\",\"color\":\"#3BCB13\",\"icon\":\"<i class=\\\"far fa-address-card\\\"><\\/i>\",\"link\":\"contact_list\",\"id\":\"8A747E57A76B4655C641AFB12154ACAF\",\"title\":\"TOTAL CONTACTS\",\"customId\":\"\",\"value\":\"#datalist.total.ContactDashboard#\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch border-0\\\" style=\\\"background-color:{{color||#348fe2}}; color:#fff;\\\">\\n    <div class=\\\"stats-icon col-4 py-3 d-flex align-items-center justify-content-center rounded-left\\\" style=\\\"background:rgba(0,0,0,.4); font-size: 48px; color: #fff;\\\">\\n        {{icon||<i class=\\\"fas fa-globe\\\"><\\/i>}}\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8\\\">\\n        <p style=\\\"font-size: 24px; font-weight: 600; margin-bottom: 10px;\\\">{{value||3,291,922}}<\\/p>\\n        <h4 style=\\\"font-size: 12px;margin: 5px 0;\\\">{{title||TOTAL VISITORS}}<\\/h4>\\n    <\\/div>\\n<\\/div>\",\"color\":\"#DD34E2\",\"icon\":\"<i class=\\\"fas fa-money-check-alt\\\"><\\/i>\",\"link\":\"opportunity_list\",\"id\":\"4BBD6B08937A464929CF1C5FCE47BD97\",\"title\":\"TOTAL OPPORTUNITIES\",\"customId\":\"\",\"value\":\"#datalist.total.OpportunityDashboard#\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"90EA88ED7C024B15695CF590BD6A40FB\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch border-0\\\" style=\\\"background-color:{{color||#348fe2}}; color:#fff;\\\">\\n    <div class=\\\"stats-icon col-4 py-3 d-flex align-items-center justify-content-center rounded-left\\\" style=\\\"background:rgba(0,0,0,.4); font-size: 48px; color: #fff;\\\">\\n        {{icon||<i class=\\\"fas fa-globe\\\"><\\/i>}}\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8\\\">\\n        <p style=\\\"font-size: 24px; font-weight: 600; margin-bottom: 10px;\\\">{{value||3,291,922}}<\\/p>\\n        <h4 style=\\\"font-size: 12px;margin: 5px 0;\\\">{{title||TOTAL VISITORS}}<\\/h4>\\n    <\\/div>\\n<\\/div>\",\"color\":\"#A79D00\",\"icon\":\"<i class=\\\"fas fa-file-alt\\\"><\\/i>\",\"link\":\"proposal_list\",\"id\":\"C326A19938BB4E89FBF961EBB2A8627A\",\"title\":\"TOTAL PROPOSALS\",\"customId\":\"\",\"value\":\"#datalist.total.ProposalsDashboard#\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"B9020BFAB6CC431E7555EE0F5DE32868\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"E91114572BF64CBBB2CDF0AD8C9D2A84\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"id\":\"BFADD515EF574C4E6738EC299551C2F1\"}},{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-4119535788344E2780088BE6E9701674\"}}','crm_userview_sales'),
('crm',1,'up-E0C637EF07594EA8935F2FD3755410DA','Welcome','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:02','2024-04-19 13:40:02','{\"elements\":[{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-E0C637EF07594EA8935F2FD3755410DA\"}}','crm_userview_sales'),
('dashboard',1,'up-525CD003EAB44123B5AD50839A706BC8','Dashboard','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:06','2024-04-19 13:40:06','{\"elements\":[{\"className\":\"menu-component\"},{\"className\":\"org.joget.plugin.enterprise.HtmlCodeComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<script type=\\\"text/javascript\\\">// <![CDATA[\\r\\n    function loadApps() {\\r\\n        // show loading icon\\r\\n        $(\\\"#published-apps\\\").empty();\\r\\n        var loading = $(\'<div id=\\\"apps-loading\\\"><img src=\\\"#request.contextPath#/images/v3/portlet_loading.gif\\\" /><\\/div>\');\\r\\n        $(\\\"#published-apps\\\").append(loading);\\r\\n                                    \\r\\n        // load JSON\\r\\n        $.ajax({ \\r\\n            url : \\\"#request.contextPath#/web/json/apps/published/userviews\\\",\\r\\n            dataType:\'jsonp\',\\r\\n            success:function(data) {\\r\\n                var content = \\\"\\\";\\r\\n                var apps = data.apps;\\r\\n                for( var i=0; i<apps.length; i++) {\\r\\n                    // add app\\r\\n                    var app = apps[i];\\r\\n                    content += \'<li><h3>\' + app.name + \'<\\/h3><ul class=\\\"landing-ul2\\\">\';\\r\\n                    // add userviews\\r\\n                    var userviews = apps[i].userviews;\\r\\n                    for( var j=0; j<userviews.length; j++){\\r\\n                        var uv = userviews[j];\\r\\n                        content += \'<li><a target=\\\"_blank\\\" href=\\\"\' + uv.url + \'\\\">\\\\\\r\\n                                                        <span class=\\\"landing-li-title\\\">\' + uv.name + \'<\\/span>\\\\\\r\\n                                                        <\\/a><\\/li>\';\\r\\n                    }\\r\\n                    content += \\\"<\\/ul>\\\";\\r\\n                }\\r\\n\\r\\n                // show apps, hide loading icon\\r\\n                $(loading).remove();\\r\\n                $(\\\"#published-apps\\\").append($(content));\\r\\n            }\\r\\n        });\\r\\n    }\\r\\n    $(document).ready(loadApps);\\r\\n    // ]]><\\/script>\",\"id\":\"B542EAC943B44A3BB939FB9601303A75\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-525CD003EAB44123B5AD50839A706BC8\"}}','home'),
('expenseclaim',1,'up-6352FA6CEE9D43AABF3734F092C0C52F','About','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:09','2024-04-19 13:40:09','{\"elements\":[{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-6352FA6CEE9D43AABF3734F092C0C52F\"}}','home'),
('expenseclaim',1,'up-BE8152B27C024938A3AA82BA91B7783B','Welcome','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:09','2024-04-19 13:40:09','{\"elements\":[{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-BE8152B27C024938A3AA82BA91B7783B\"}}','home'),
('expenseclaim',1,'up-D7AC42CBC83548ABB13C84C4BC7BE611','Dashboard','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:09','2024-04-19 13:40:09','{\"elements\":[{\"elements\":[],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"id\":\"21DA0607699C4EF609B34760A8C46275\"}},{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-D7AC42CBC83548ABB13C84C4BC7BE611\"}}','home'),
('expenseclaim',1,'up-F577A77F42B74CAFBE96DC23AC909A6F','Submitted Expenses','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:09','2024-04-19 13:40:09','{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HorizontalRuleComponent\",\"properties\":{\"id\":\"CF415C68214C4F96F417D5B5768C23D0\"}},{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-F577A77F42B74CAFBE96DC23AC909A6F\"}}','home'),
('isr',1,'up-5ECB552FB8AA48F2AE35980233EFE6D7','Welcome','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:12','2024-04-19 13:40:12','{\"elements\":[{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-5ECB552FB8AA48F2AE35980233EFE6D7\"}}','isr'),
('isr',1,'up-B635A679CCDD49FCB0123AC20BE41B69','About','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:12','2024-04-19 13:40:12','{\"elements\":[{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-B635A679CCDD49FCB0123AC20BE41B69\"}}','isr'),
('JogetDxShowcase',1,'up-404B244847FD43E49153EE2F31A0DA97','Dashboard','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:16','2024-04-19 13:40:16','{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch border-0\\\" style=\\\"background-color:{{color||#348fe2}}; color:#fff;\\\">\\n    <div class=\\\"stats-icon col-4 py-3 d-flex align-items-center justify-content-center rounded-left\\\" style=\\\"background:rgba(0,0,0,.4); font-size: 48px; color: #fff;\\\">\\n        {{icon||<i class=\\\"fas fa-globe\\\"><\\/i>}}\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8\\\">\\n        <p style=\\\"font-size: 24px; font-weight: 600; margin-bottom: 10px;\\\">{{value||3,291,922}}<\\/p>\\n        <h4 style=\\\"font-size: 12px;margin: 5px 0;\\\">{{title||TOTAL VISITORS}}<\\/h4>\\n    <\\/div>\\n<\\/div>\",\"color\":\"#66BB69\",\"icon\":\"<i class=\\\"fas fa-cubes\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"120px\",\"id\":\"3C4A591270FF48A2A543CE6454B5E968\",\"title\":\"TOTAL APPS\",\"customId\":\"\",\"value\":\"#stats.app.total#\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"E765F3E95E574516C580FE7AB7631BEE\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg bar\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch border-0\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#f59c1a}}; \\n            background-image:url(\'{{bgImg}}\'); \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-icon col-4 py-3 d-flex align-items-center \\n                justify-content-center rounded-left\\\" \\n         style=\\\"background:rgba(0,0,0,.4);\\\">\\n        <div id=\\\"chart-{{id}}\\\" \\n             style=\\\"color:#000\\\"\\n             data-chart-type=\\\"bar\\\" \\n             data-chart-custom=\\\"{{chartConfig}}\\\" \\n             data-chart-color=\\\"#fff\\\"\\n             data-chart-labels=\\\"{{chartLabels||Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec}}\\\"\\n             data-chart-values=\\\"{{chartData||[{data:[25, 66, 41, 89, 63, 25, 44, 12, 36, 9, 54, 33]}]}}\\\">\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8\\\">\\n        <p style=\\\"font-size: 24px; \\n                  font-weight: 600; \\n                  margin-bottom: 10px;\\\">\\n            {{value||3,291,922}}\\n        <\\/p>\\n        <h4 style=\\\"font-size: 12px;\\n                   margin: 5px 0;\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#66BB69\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"120px\",\"bgImg\":\"\",\"title\":\"TOTAL FORMS\",\"customId\":\"\",\"chartData\":\"[{data:[#stats.form.countPerApp#]}]\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"4AC9C3A93D5E4EEDB0784A9723F2BE00\",\"value\":\"#stats.form.total#\",\"chartLabels\":\"#stats.appList#\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"DB3BE49B9BAF47ADCE150B5803F1A82F\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg line\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch border-0\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#f59c1a}}; \\n            background-image:url(\'{{bgImg}}\'); \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-icon col-4 py-3 d-flex align-items-center \\n                justify-content-center rounded-left\\\" \\n         style=\\\"background:rgba(0,0,0,.4);\\\">\\n        <div id=\\\"chart-{{id}}\\\"\\n             style=\\\"color:#000\\\" \\n             data-chart-type=\\\"line\\\" \\n             data-chart-custom=\\\"{{chartConfig}}\\\" \\n             data-chart-color=\\\"#fff\\\"\\n             data-chart-labels=\\\"{{chartLabels||Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec}}\\\"\\n             data-chart-values=\\\"{{chartData||[{data:[25, 66, 41, 89, 63, 25, 44, 12, 36, 9, 54, 33]}]}}\\\">\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8\\\">\\n        <p style=\\\"font-size: 24px; \\n                  font-weight: 600; \\n                  margin-bottom: 10px;\\\">\\n            {{value||3,291,922}}\\n        <\\/p>\\n        <h4 style=\\\"font-size: 12px;\\n                   margin: 5px 0;\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#66BB69\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"120px\",\"bgImg\":\"\",\"title\":\"TOTAL LISTS\",\"customId\":\"\",\"chartData\":\"[{data:[#stats.list.countPerApp#]}]\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"66115B2E122A490847AFE7E62A00FCD8\",\"value\":\"#stats.list.total#\",\"chartLabels\":\"#stats.appList#\",\"chartColors\":\"\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"93C1F43EF5FB485228A2AF6BB45E788C\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg area\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch border-0\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#f59c1a}}; \\n            background-image:url(\'{{bgImg}}\'); \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-icon col-4 py-3 d-flex align-items-center \\n                justify-content-center rounded-left\\\" \\n         style=\\\"background:rgba(0,0,0,.4);\\\">\\n        <div id=\\\"chart-{{id}}\\\" \\n             style=\\\"color:#000\\\"\\n             data-chart-type=\\\"area\\\" \\n             data-chart-custom=\\\"{{chartConfig}}\\\" \\n             data-chart-color=\\\"#fff\\\"\\n             data-chart-labels=\\\"{{chartLabels||Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec}}\\\"\\n             data-chart-values=\\\"{{chartData||[{data:[25, 66, 41, 89, 63, 25, 44, 12, 36, 9, 54, 33]}]}}\\\">\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8\\\">\\n        <p style=\\\"font-size: 24px; \\n                  font-weight: 600; \\n                  margin-bottom: 10px;\\\">\\n            {{value||3,291,922}}\\n        <\\/p>\\n        <h4 style=\\\"font-size: 12px;\\n                   margin: 5px 0;\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#66BB69\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"120px\",\"bgImg\":\"\",\"title\":\"TOTAL UIs\",\"customId\":\"\",\"chartData\":\"[{data:[#stats.UI.countPerApp#]}]\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"48754D9C77114742170967AB7046C1BB\",\"value\":\"#stats.UI.total#\",\"chartLabels\":\"#stats.appList#\",\"chartColors\":\"\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"34355842DA0745CB7546FDECD628C31E\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"42A67595E2004FAEDCD3434D0976602D\"}},{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-404B244847FD43E49153EE2F31A0DA97\"}}','v'),
('JogetDxShowcase',1,'up-455D13D3CBC24935327B1148B9BD3BE0','Accordion','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:16','2024-04-19 13:40:16','{\"elements\":[{\"className\":\"menu-component\"},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer eu sapien a ligula finibus ultricies. Duis sit amet rutrum erat, at consequat libero. Donec gravida, tortor eget mattis pellentesque, lorem enim malesuada purus, eleifend lobortis mi odio eu felis. Phasellus euismod sem sed quam aliquam lacinia. Aliquam sit amet tincidunt urna. Sed mauris dui, accumsan vitae tincidunt et, molestie sed lectus. Etiam aliquam, ligula sit amet dapibus pharetra, diam odio sollicitudin augue, pharetra pellentesque felis lacus vitae nisl. Vestibulum sagittis, odio et volutpat vehicula, urna elit luctus elit, sagittis pretium sem lectus ac tortor. Quisque auctor ex non justo luctus placerat. Fusce elit sem, dictum porta libero vel, pretium blandit nulla.<\\/p>\",\"id\":\"8221DE22377440C403B8C90D691FA7D5\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.AccordionChildComponent\",\"properties\":{\"expanded\":\"true\",\"id\":\"B941082A7A2046EF77A4068AA1E9343C\",\"label\":\"Accordion Item 1\",\"customId\":\"\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p><span>Curabitur egestas erat viverra lacinia vestibulum. Mauris efficitur ligula eget leo ultrices, non mollis leo dignissim. In hac habitasse platea dictumst. Vestibulum viverra, urna quis tristique commodo, quam erat scelerisque mauris, pulvinar porttitor odio magna et nisl. Etiam ut mauris hendrerit, eleifend ligula vitae, egestas elit. Mauris pretium felis lacus, eget volutpat massa semper id. Quisque finibus neque facilisis elit posuere pulvinar.<\\/span><\\/p>\",\"id\":\"CE338A095C364005FA545CBE09D262B3\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.AccordionChildComponent\",\"properties\":{\"expanded\":\"\",\"id\":\"0A2A6260E6C9422600AEB1200F1A69D6\",\"label\":\"Accordion Item 2\",\"customId\":\"\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.ParagraphComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p><span>Etiam facilisis, felis vel vulputate sollicitudin, lacus est volutpat augue, id fermentum nunc nulla sit amet leo. Fusce ultricies pellentesque nisl, et rutrum dolor mollis sit amet. Aliquam bibendum vulputate elit, et faucibus dui egestas aliquet. Maecenas sit amet urna eget metus semper aliquet. Sed et massa quis lorem hendrerit pellentesque eget et neque. In sit amet ultricies dolor. Aenean tempor velit tortor, eu imperdiet neque mollis id. Nulla condimentum ipsum a felis rhoncus, sed viverra lectus egestas. Proin cursus sollicitudin libero et tempor. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Fusce id ex vehicula, malesuada dolor ac, efficitur eros.<\\/span><\\/p>\",\"id\":\"7186E24FBC474986D2BE812CB5E5E7E1\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.AccordionChildComponent\",\"properties\":{\"expanded\":\"\",\"id\":\"A94A56C1938A4A187EF51BF8E354D8A8\",\"label\":\"Accordion Item 3\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.AccordionComponent\",\"properties\":{\"attr-data-events-listening\":[],\"accordion\":[{\"expanded\":\"true\",\"id\":\"B941082A7A2046EF77A4068AA1E9343C\",\"label\":\"Accordion Item 1\",\"customId\":\"\"},{\"expanded\":\"\",\"id\":\"0A2A6260E6C9422600AEB1200F1A69D6\",\"label\":\"Accordion Item 2\",\"customId\":\"\"},{\"expanded\":\"\",\"id\":\"A94A56C1938A4A187EF51BF8E354D8A8\",\"label\":\"Accordion Item 3\",\"customId\":\"\"}],\"id\":\"9BF6DFC1162040B77577FCAE880DEC11\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-455D13D3CBC24935327B1148B9BD3BE0\"}}','v'),
('JogetDxShowcase',1,'up-46C54D8B4F6A4AA7B1520778A1A34F78','Area Chart','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:16','2024-04-19 13:40:16','{\"elements\":[{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-46C54D8B4F6A4AA7B1520778A1A34F78\"}}','v'),
('JogetDxShowcase',1,'up-8B7AFA736DAC4F239DCE742902825C37','Welcome','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:16','2024-04-19 13:40:16','{\"elements\":[{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-8B7AFA736DAC4F239DCE742902825C37\"}}','v'),
('JogetDxShowcase',1,'up-8EFE945CEDA44B633D5A6D50DBF6A95F','List Templates','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:16','2024-04-19 13:40:16','{\"elements\":[{\"className\":\"menu-component\"},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"App Icon\",\"id\":\"B7B5B87684DD4472B70E4E4AA0EC2678\",\"tagName\":\"h4\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.DataListMenu\",\"properties\":{\"cacheAllLinks\":\"\",\"customHeader\":\"\",\"keyName\":\"\",\"customFooter\":\"\",\"enableOffline\":\"\",\"label\":\"List\",\"customId\":\"\",\"buttonPosition\":\"bottomLeft\",\"datalistId\":\"appIcon\",\"checkboxPosition\":\"left\",\"selectionType\":\"multiple\",\"userviewCacheDuration\":\"20\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"id\":\"05C9A3C862C94B5F62D354C68E744FCE\",\"rowCount\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"20px\",\"style-margin-bottom\":\"20px\",\"id\":\"D7402A894B874190D540E3B89EF081BD\",\"customId\":\"\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"Simple Card\",\"id\":\"E2B49FE21AC044274D1796C6405C9FBB\",\"tagName\":\"h4\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.DataListMenu\",\"properties\":{\"cacheAllLinks\":\"\",\"customHeader\":\"\",\"keyName\":\"\",\"customFooter\":\"\",\"enableOffline\":\"\",\"label\":\"List\",\"customId\":\"\",\"buttonPosition\":\"bottomLeft\",\"datalistId\":\"simplecard\",\"checkboxPosition\":\"left\",\"selectionType\":\"multiple\",\"userviewCacheDuration\":\"20\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"id\":\"CC728871A50946BDC13516034BC6F1E4\",\"rowCount\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"20px\",\"style-margin-bottom\":\"20px\",\"id\":\"385F5FB8BBD44D20572D9BFEC95A5A31\",\"customId\":\"\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"Simple List\",\"id\":\"49A45EB108DC4180380667474A127025\",\"tagName\":\"h4\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.DataListMenu\",\"properties\":{\"cacheAllLinks\":\"\",\"customHeader\":\"\",\"keyName\":\"\",\"customFooter\":\"\",\"enableOffline\":\"\",\"label\":\"List\",\"customId\":\"\",\"buttonPosition\":\"bottomLeft\",\"datalistId\":\"simplelist\",\"checkboxPosition\":\"no\",\"selectionType\":\"multiple\",\"userviewCacheDuration\":\"20\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"id\":\"D2E42A60F1004800096AC2BB030933C4\",\"rowCount\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"20px\",\"style-margin-bottom\":\"20px\",\"id\":\"BC8EDD55D2644B8DB37297745A81BA28\",\"customId\":\"\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"Column Data List\",\"id\":\"F6905E20128B4C9129041D10C0A27922\",\"tagName\":\"h4\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.DataListMenu\",\"properties\":{\"cacheAllLinks\":\"\",\"customHeader\":\"\",\"keyName\":\"\",\"customFooter\":\"\",\"enableOffline\":\"\",\"label\":\"List\",\"customId\":\"\",\"buttonPosition\":\"bottomLeft\",\"datalistId\":\"columnslist\",\"checkboxPosition\":\"no\",\"selectionType\":\"multiple\",\"userviewCacheDuration\":\"20\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"id\":\"715D4A3CE2204B9DF8BA3CB8D551C1F3\",\"rowCount\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"20px\",\"style-margin-bottom\":\"20px\",\"id\":\"80443211210D42B2FAB4B137C6FEEC03\",\"customId\":\"\"}},{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.HeadingComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"Classic Table\",\"id\":\"B1B638D8BB3C4DEE73FF77935E1C63BD\",\"tagName\":\"h4\",\"customId\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.DataListMenu\",\"properties\":{\"cacheAllLinks\":\"\",\"customHeader\":\"\",\"keyName\":\"\",\"customFooter\":\"\",\"enableOffline\":\"\",\"label\":\"List\",\"customId\":\"\",\"buttonPosition\":\"bottomLeft\",\"datalistId\":\"classic\",\"checkboxPosition\":\"no\",\"selectionType\":\"multiple\",\"userviewCacheDuration\":\"20\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"id\":\"6956D49A024E424716E9E0B3DD9FB38C\",\"rowCount\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-margin-top\":\"20px\",\"style-margin-bottom\":\"20px\",\"id\":\"B39AFBCEA4354E722819713345952817\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-8EFE945CEDA44B633D5A6D50DBF6A95F\"}}','v'),
('JogetDxShowcase',1,'up-9FA45D2954F0406CCF139BD80A359C1E','Component Layout','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:16','2024-04-19 13:40:16','{\"elements\":[{\"className\":\"menu-component\"},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"6769E95C517447422A7E38A1E5BF94F8\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"CFF083C8408E491C1C14EEFF46754F00\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"55AA2408A6FC4747F9BAD91D3088FE05\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"7AF39EE494294AF9FF23D1E32BB9B1BB\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"E00B3FD3AEAB4DA2D780A1C2F0757F27\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"A3276F4EACC648BEF1D38BAAB7D9B54C\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"E5EC04A84881430B3220548612820FA5\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"A335E556761A4C27B99370C7BCE35A18\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"062F32F2A0454DD737855C345203E90D\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"8905E4A5FA074E54AB052D23371484E5\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"836C10EA512B4DBCAB59DA1AA4900682\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"EA3F06A5B93E485B1C2F321D86CB9EB3\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"EB2F30A8269049E98F1807DA1182638A\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"86C23DDBBD2C492C1D0F15194874D85C\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"F5802E80F8324AC995FB715E4757CFA1\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"8595DCA3AA654A80AE30D8702F118210\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"A9046D7CCC214885F60B753EC81BAF93\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"AD0F0AF303304FE13B808205C02A0779\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"6127C551598740BC1DFA35C27B552591\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"DD3CB3D2775D4982D28F04266C27A9A9\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"21DE6F8BB7644D95C5B1953467D4996C\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"D2F8A91F981A4B0311DABFC987A02EDC\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"56040C119DC64ED4368B23DC61C818DC\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"773BDFB84BE745C8650C8DC0E55465CD\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"9A98BD6D6F1D40ADF00DDCD959C91929\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"F2334D76A00445D70D39E31267EC879A\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"11DBE29DA6624612F7AA3830684962C2\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"71ED92477D844C6BA82C880A54C7BCB4\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"9D42F23C216046C339C1F5E5EA9B3066\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"876C81D0AF0C417A8AAA6A94CF7D7C82\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"D41BB3ACBA284A4A89972AEBD229CB48\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"F3190797656041C4034E1B9130B2CABF\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"C497EA452F3C4DAEA2030030405F70EE\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"27AD0DE414D54C30A6D0C058356CF8B1\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"85704A6FE4104240B051EAFED217BF63\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"9A7A4657E5BA494496EFE092D80606B8\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"8EDC764D4A1E45C6B2C205300369EA7B\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"CD79EDCA8B4F4C105E592E8354153926\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"6FC0BBBC75684AEF614CCB5F0FDE3071\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"2C42D06DA4EA446BA2118B5D3CE0E3C8\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"D59E98AA15F3486150CED14B9CCDEEEF\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"667DE6BFBF8942B58D016C8242078E9D\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"72F18E23912E4539B5A903D3BBB12041\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"B85A2710D8DF40E54958160EA0C78F38\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"FE38AE474C38420438BDEDF7A07C5BA5\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"F848D9E1D4084BB8D4BDDEDDBDB82B8E\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"44259815701B42FB8358C9D4C9AD0C78\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"819D864A117F46AB4229D96D2921E532\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"9332C809E7724583B9F1E89A3B427A7D\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"0BC47CA2BBDD4D2BCC918B47F946CAE5\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"43467E9633FF4383EE8C2BFC14044E4C\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"78E82813A61149F7FBF235648CEF9177\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"7342ACC28DC34F8B0A0722B957437F8B\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"8ABEDA3391214FEB1E43341615658D57\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"C511F99EC3B54904934960B2F572DBF8\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"24FCA69A1DF74D01E7DD8C712DA7F577\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"796AC027BB40423A8D84D8599DE03051\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"E14D530CFA104E1E2BA4010EFAB06260\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"874CB74866E6462016897E9DC8070E3B\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"3F8FFFD05C0D40A0F4A3120413D45EA2\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"00D77677DA8D443F205ABB221C607288\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"38A972B55478486B48C299BC6D7E04F4\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"CE32E899DDC0470D2FC06E76473D1981\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"155C1FE457EF483DE180B24F4D4628E4\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"631A9244E86F48EBFCA199EF46CB8D2F\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"0BDB814568C143D8A38B4BCD43075038\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"AE6F9A86A965496504E669E4FC448EFD\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"5B35A2C1957141AD64D056D8B06E3372\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"535784C299124C0E86E0C6B46810618A\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"5DD02C19CBF045B63C6896C62E380764\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"96282E8125CD4633794682D08891D77B\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"30188BA0CCC14E2F49E2390DDD452835\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"EA3B19F3EFAC484C1F31712AA6BAD5F2\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"441B712CA9AB40F9BF27AB9CCA865D70\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"B772EB9640264569E331573C356B7A12\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"21735718D17144FA5161A8DA3DE9BD82\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"B1D5573E3B3A4CA77115D76500A5BCD8\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"D97E668D23D44390D98AD955A2769B9A\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"F9766ABC0F8741C646ACEDD529FE7BD5\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"14911631888542FC8D1EB5D1CF15BD81\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"084721F1F3024F8F8E421ABC33339081\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"98955B7E98A940C93B95F4C4493AE30C\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"E7E7ADC509EB4CB795AB6C1837C05678\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"546368AF489F4C23B62DC6B78D183EE9\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"3C088975878E4257C9AD2E9422B68895\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"4FC3734233114F5187B0EC0D436527D2\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"1A4F85691C92432EE18C1E0791FDE583\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-flex\":\"0 0 66.66%\",\"style-max-width\":\"66.66%\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"3C0FCD0EDC0245FB88634B75A8D78C01\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"0E656B5E42E541229FE2CDDB652FE86F\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"66.66%\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"5E94B26E08E14093705F15BDC1966829\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"E175CBAE198A41D8F2280AF6CB0B5701\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"904C9A57FF29491479158225D8E17ACB\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.userview.lib.component.LabelComponent\",\"properties\":{\"attr-data-events-listening\":[],\"textContent\":\"<p>Cell<\\/p>\",\"id\":\"B7A6B834D99D4B784617E5CDFF30A117\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ContainerComponent\",\"properties\":{\"attr-data-events-listening\":[],\"style-background-color\":\"#6366F3\",\"style-text-align\":\"center\",\"style-border-bottom-width\":\"1px\",\"style-color\":\"#FFFFFF\",\"style-border-left-width\":\"1px\",\"style-border-right-width\":\"1px\",\"id\":\"5F57FE57062545FBD57DE498510E4409\",\"style-border-color\":\"#B8B8B8\",\"style-border-top-width\":\"1px\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"style-flex\":\"0 0 66.66%\",\"style-max-width\":\"66.66%\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"66.66%\",\"style-tablet-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"A27A0C404DFE40EC21836AE8BEC016FC\",\"customId\":\"\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-9FA45D2954F0406CCF139BD80A359C1E\"}}','v'),
('JogetDxShowcase',1,'up-A8BC522C85ED42A56E1506FE9976804B','Information Tiles','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:16','2024-04-19 13:40:16','{\"elements\":[{\"className\":\"menu-component\"},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch border-0\\\" style=\\\"background-color:{{color||#348fe2}}; color:#fff;\\\">\\n    <div class=\\\"stats-icon col-4 py-3 d-flex align-items-center justify-content-center rounded-left\\\" style=\\\"background:rgba(0,0,0,.4); font-size: 48px; color: #fff;\\\">\\n        {{icon||<i class=\\\"fas fa-globe\\\"><\\/i>}}\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8\\\">\\n        <p style=\\\"font-size: 24px; font-weight: 600; margin-bottom: 10px;\\\">{{value||3,291,922}}<\\/p>\\n        <h4 style=\\\"font-size: 12px;margin: 5px 0;\\\">{{title||TOTAL VISITORS}}<\\/h4>\\n    <\\/div>\\n<\\/div>\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-cubes\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"120px\",\"id\":\"56F7CA37490D4E34639114762EA70D31\",\"title\":\"TOTAL APPS\",\"customId\":\"\",\"value\":\"#stats.app.total#\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'light-bg bar\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch\\\" \\n     style=\\\"height:{{height}};\\n            background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-icon col-4 py-3 d-flex align-items-center \\n                justify-content-center rounded-left\\\" \\n         style=\\\"background-color:{{color||#348fe2}};\\\">\\n        <div id=\\\"chart-{{id}}\\\" \\n             data-chart-type=\\\"bar\\\" \\n             data-chart-custom=\\\"{{chartConfig}}\\\" \\n             data-chart-color=\\\"#fff\\\"\\n             data-chart-labels=\\\"{{chartLabels||Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec}}\\\"\\n             data-chart-values=\\\"{{chartData||[{data:[25, 66, 41, 89, 63, 25, 44, 12, 36, 9, 54, 33]}]}}\\\">\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8 text-center\\\">\\n        <p style=\\\"font-size: 24px; \\n                  font-weight: 600; \\n                  margin-bottom: 10px;\\\">\\n            {{value||3,291,922}}\\n        <\\/p>\\n        <h4 style=\\\"font-size: 12px;\\n                   color: rgba(0,0,0,.7);\\n                   margin: 5px 0;\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"120px\",\"bgImg\":\"\",\"title\":\"TOTAL FORMS\",\"customId\":\"\",\"chartData\":\"[{data:[#stats.form.countPerApp#]}]\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"A7929E88C2EB436B5CE9FCC532FB05B8\",\"value\":\"#stats.form.total#\",\"chartLabels\":\"#stats.appList#\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg line\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#348fe2}}; \\n            background-image:url(\'{{bgImg}}\');\\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body row\\\">\\n        <div class=\\\"stats-info col-8\\\">\\n            <h4 style=\\\"font-size: 12px;\\n                       margin: 5px 0;\\n                       color: rgba(255,255,255,.7);\\\">\\n                {{title||TOTAL VISITORS}}\\n            <\\/h4>\\n            <p style=\\\"font-size: 24px; \\n                      font-weight: 600; \\n                      margin-bottom: 0;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n        <\\/div>\\n        <div class=\\\"stats-icon col-4 pl-0 d-flex align-items-center\\\"\\n             style=\\\"color:#000\\\">\\n            <div id=\\\"chart-{{id}}\\\" \\n                 data-chart-type=\\\"line\\\" \\n                 data-chart-custom=\\\"{{chartConfig}}\\\"\\n                 data-chart-color=\\\"#fff\\\"\\n                 data-chart-labels=\\\"{{chartLabels||Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec}}\\\"\\n                 data-chart-values=\\\"{{chartData||[{data:[25, 66, 41, 89, 63, 25, 44, 12, 36, 9, 54, 33]}]}}\\\">\\n            <\\/div>\\n        <\\/div>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"120px\",\"bgImg\":\"\",\"title\":\"TOTAL LISTS\",\"customId\":\"\",\"chartData\":\"[{data:[#stats.list.countPerApp#]}]\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"45D2EAC9627C425EEA9709AD49E5151D\",\"value\":\"#stats.list.total#\",\"chartLabels\":\"#stats.appList#\",\"chartColors\":\"\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"493DBF9F55404F70C20D531EA9ACF127\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg area\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#49b6d6}}; \\n            background-image:url(\'{{bgImg}}\'); \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body row\\\">\\n        <div class=\\\"stats-icon col-4 pr-0 d-flex align-items-center\\\"\\n             style=\\\"color:#000\\\">\\n            <div id=\\\"chart-{{id}}\\\" \\n                 data-chart-type=\\\"area\\\" \\n                 data-chart-custom=\\\"{{chartConfig}}\\\" \\n                 data-chart-color=\\\"#fff\\\"\\n                 data-chart-labels=\\\"{{chartLabels||Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec}}\\\"\\n                 data-chart-values=\\\"{{chartData||[{data:[25, 66, 41, 89, 63, 25, 44, 12, 36, 9, 54, 33]}]}}\\\">\\n            <\\/div>\\n        <\\/div>\\n        <div class=\\\"stats-info col-8  text-right\\\">\\n            <h4 style=\\\"font-size: 12px;\\n                       margin: 5px 0;\\\">\\n                {{title||TOTAL VISITORS}}\\n            <\\/h4>\\n            <p style=\\\"font-size: 24px; \\n                      font-weight: 600; \\n                      margin-bottom: 0;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n        <\\/div>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"120px\",\"bgImg\":\"\",\"title\":\"TOTAL LISTS\",\"customId\":\"\",\"chartData\":\"[{data:[#stats.list.countPerApp#]}]\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"6EE9A38860E24795B881914C31B656F3\",\"value\":\"#stats.list.total#\",\"chartLabels\":\"#stats.appList#\",\"chartColors\":\"\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"AD47D6A51BD14F7115196259A2D3CF38\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"22BBE64553FC4D91FE7AD063A2E9313D\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'light-bg\'}-->\\n<div class=\\\"card text-center py-3\\\" \\n     style=\\\"height:{{height}};\\n            background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-info\\\">\\n        <h4 style=\\\"font-size: 12px;\\n                   margin: 5px 0;\\n                   font-weight: normal;\\n                   color: rgba(0,0,0,.7);\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n        <p style=\\\"font-size: 28px; \\n                  font-weight: 600; \\n                  margin-bottom: 0;\\\">\\n            {{value||3,291,922}}\\n        <\\/p>\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-cubes\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"120px\",\"bgImg\":\"\",\"title\":\"TOTAL APPS\",\"customId\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"87208FA988AD40EC3FC95A1A135132B8\",\"value\":\"#stats.app.total#\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"80CEB48AF6814B8CB478D41E25316F9B\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'light-bg line\'}-->\\n<div class=\\\"card flex-row align-items-center align-items-stretch\\\" \\n     style=\\\"height:{{height}};\\n            background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-icon col-4 py-3 pr-0 d-flex align-items-center\\\">\\n        <div id=\\\"chart-{{id}}\\\" \\n             data-chart-type=\\\"line\\\" \\n             data-chart-custom=\\\"{{chartConfig}}\\\" \\n             data-chart-color=\\\"{{color||#ff5b57}}\\\"\\n             data-chart-labels=\\\"{{chartLabels||Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec}}\\\"\\n             data-chart-values=\\\"{{chartData||[{data:[25, 66, 41, 89, 63, 25, 44, 12, 36, 9, 54, 33]}]}}\\\">\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"stats-info py-3 col-8 text-right\\\">\\n        <p style=\\\"font-size: 24px; \\n                  font-weight: 600; \\n                  margin-bottom: 10px;\\\">\\n            {{value||3,291,922}}\\n        <\\/p>\\n        <h4 style=\\\"font-size: 12px;\\n                   color: rgba(0,0,0,.6);\\n                   margin: 5px 0;\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"120px\",\"bgImg\":\"\",\"title\":\"TOTAL FORMS\",\"customId\":\"\",\"chartData\":\"[{data:[#stats.form.countPerApp#]}]\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"B1F8F75FA35E49328F1122201B656628\",\"value\":\"#stats.form.total#\",\"chartLabels\":\"#stats.appList#\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"B8F35BA466934807ED94130204F10A74\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"linkLabel\":\"View Details\",\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg link area\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#8753de}}; \\n            background-image:url(\'{{bgImg}}\'); \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body row\\\">\\n        <div class=\\\"stats-info col-8\\\">\\n            <h4 style=\\\"font-size: 12px;\\n                       margin: 5px 0;\\n                       color: rgba(255,255,255,.7);\\\">\\n                {{title||TOTAL VISITORS}}\\n            <\\/h4>\\n            <p style=\\\"font-size: 24px; \\n                      font-weight: 600; \\n                      margin-bottom: 0;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n        <\\/div>\\n        <div class=\\\"stats-icon col-4 pl-0 d-flex align-items-center\\\">\\n            <div id=\\\"chart-{{id}}\\\" \\n                 style=\\\"color:#000\\\"\\n                 data-chart-type=\\\"area\\\" \\n                 data-chart-custom=\\\"{{chartConfig}}\\\" \\n                 data-chart-color=\\\"#fff\\\"\\n                 data-chart-labels=\\\"{{chartLabels||Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec}}\\\"\\n                 data-chart-values=\\\"{{chartData||[{data:[25, 66, 41, 89, 63, 25, 44, 12, 36, 9, 54, 33]}]}}\\\">\\n            <\\/div>\\n        <\\/div>\\n    <\\/div>\\n    <div class=\\\"card-footer text-right\\\" \\n                style=\\\"padding:5px 15px; \\n                       background:rgba(0,0,0,.6); \\n                       color:rgba(255,255,255,0.6) !important;\\\">\\n        <a style=\\\"color: inherit; \\n                  font-size:12px;\\\" \\n           href=\\\"{{link||#}}\\\">\\n            {{linkLabel||View Detail}} \\n            <i class=\\\"fas fa-arrow-alt-circle-right\\\"><\\/i>\\n        <\\/a>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"#\",\"style-height\":\"120px\",\"bgImg\":\"\",\"title\":\"TOTAL LISTS\",\"customId\":\"\",\"chartData\":\"[{data:[#stats.list.countPerApp#]}]\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"1954C5C316A54D0791B04E05E8F50B0E\",\"value\":\"#stats.list.total#\",\"chartLabels\":\"#stats.appList#\",\"chartColors\":\"\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"123E064EEAF84906B763309C494C2EC6\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"linkLabel\":\"View Details\",\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg link line\'}-->\\n<div class=\\\"card border-0\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#37bc9b}}; \\n            background-image:url(\'{{bgImg}}\'); \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body row\\\">\\n        <div class=\\\"stats-icon col-4 pr-0 d-flex align-items-center\\\">\\n            <div id=\\\"chart-{{id}}\\\" \\n                 style=\\\"color:#000\\\"\\n                 data-chart-type=\\\"line\\\" \\n                 data-chart-custom=\\\"{{chartConfig}}\\\" \\n                 data-chart-color=\\\"#fff\\\"\\n                 data-chart-labels=\\\"{{chartLabels||Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec}}\\\"\\n                 data-chart-values=\\\"{{chartData||[{data:[25, 66, 41, 89, 63, 25, 44, 12, 36, 9, 54, 33]}]}}\\\">\\n            <\\/div>\\n        <\\/div>\\n        <div class=\\\"stats-info col-8 text-right\\\">\\n            <p style=\\\"font-size: 24px; \\n                      margin-bottom: 5px;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n            <h4 style=\\\"font-weight:thin; \\n                       font-size: 12px;\\n                       margin: 5px 0;\\n                       color: rgba(255,255,255,.7);\\\">\\n                {{title||TOTAL VISITORS}}\\n            <\\/h4>\\n        <\\/div>\\n    <\\/div>\\n    <a class=\\\"card-footer d-flex flex-row align-items-center \\n              justify-content-between\\\" \\n       style=\\\"padding:5px 15px; \\n              background:#3a3f51; \\n              color:#fff !important;\\\" \\n       href=\\\"{{link||#}}\\\">\\n        <span>\\n            {{linkLabel||View Detail}}\\n        <\\/span>\\n        <i class=\\\"fas fa-arrow-alt-circle-right\\\"><\\/i>\\n    <\\/a>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"#\",\"style-height\":\"120px\",\"bgImg\":\"\",\"title\":\"TOTAL LISTS\",\"customId\":\"\",\"chartData\":\"[{data:[#stats.list.countPerApp#]}]\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"44EE8DE0B22A445F099A6D0819D744FB\",\"value\":\"#stats.list.total#\",\"chartLabels\":\"#stats.appList#\",\"chartColors\":\"\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"E59F18FDB22E4188C4A2BDFEC8D4A31B\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"7B10661F62E7461FE7F405202536C0A6\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'light-bg bar\'}-->\\n<div class=\\\"card text-center p-3\\\"\\n     style=\\\"background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-info\\\">\\n        <h4 style=\\\"font-size: 12px;\\n                   margin: 5px 0;\\n                   font-weight: normal;\\n                   color: rgba(0,0,0,.7);\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n        <div class=\\\"stats-icon pt-2 d-flex align-items-center\\\">\\n            <div id=\\\"chart-{{id}}\\\" \\n                 data-chart-type=\\\"bar\\\" \\n                 data-chart-custom=\\\"{{chartConfig}}\\\"\\n                 data-chart-height=\\\"{{height||120px}}\\\"\\n                 data-chart-color=\\\"{{color||#563d7c}}\\\"\\n                 data-chart-labels=\\\"{{chartLabels||Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec}}\\\"\\n                 data-chart-values=\\\"{{chartData||[{data:[25, 66, 41, 89, 63, 25, 44, 12, 36, 9, 54, 33]}]}}\\\">\\n            <\\/div>\\n        <\\/div>\\n    <\\/div> \\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"280px\",\"bgImg\":\"\",\"title\":\"TOTAL FORMS\",\"customId\":\"\",\"chartData\":\"[{data:[#stats.form.countPerApp#]}]\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"AC0AB736617C4AD949B88DAA923FFAAF\",\"value\":\"#datalist.col.sum.areaChart.column_2#\",\"chartLabels\":\"#stats.appList#\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg area\'}-->\\n<div class=\\\"card text-center p-3\\\" \\n     style=\\\"background-color:{{color||#7266ba}};\\n            background-image:url(\'{{bgImg}}\');  \\n            color:#fff;\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-info\\\">\\n        <h4 style=\\\"font-size: 12px;\\n                   margin: 5px 0;\\n                   font-weight: normal;\\n                   color: rgba(255,255,255,.7);\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n        <div class=\\\"stats-icon pt-2 d-flex align-items-center\\\">\\n            <div id=\\\"chart-{{id}}\\\" \\n                 style=\\\"color:#000\\\"\\n                 data-chart-type=\\\"area\\\" \\n                 data-chart-custom=\\\"{{chartConfig}}\\\"\\n                 data-chart-height=\\\"{{height||120px}}\\\"\\n                 data-chart-color=\\\"#ffffff\\\"\\n                 data-chart-labels=\\\"{{chartLabels||Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec}}\\\"\\n                 data-chart-values=\\\"{{chartData||[{data:[25, 66, 41, 89, 63, 25, 44, 12, 36, 9, 54, 33]}]}}\\\">\\n            <\\/div>\\n        <\\/div>\\n    <\\/div>\\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"280px\",\"bgImg\":\"\",\"title\":\"TOTAL FORMS\",\"customId\":\"\",\"chartData\":\"[{data:[#stats.form.countPerApp#]}]\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"466C81FFC71D4FA2D13D51F1EC8BBDBD\",\"value\":\"#datalist.col.sum.areaChart.column_2#\",\"chartLabels\":\"#stats.appList#\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'light-bg donut\'}-->\\n<div class=\\\"card text-center p-3\\\"\\n     style=\\\"background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-info\\\">\\n        <h4 style=\\\"font-size: 12px;\\n                   margin: 5px 0;\\n                   font-weight: normal;\\n                   color: rgba(0,0,0,.7);\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n        <div class=\\\"stats-icon pt-2 d-flex align-items-center\\\">\\n            <div id=\\\"chart-{{id}}\\\" \\n                 data-chart-type=\\\"donut\\\" \\n                 data-chart-custom=\\\"{{chartConfig}}\\\" \\n                 data-chart-height=\\\"{{height||120px}}\\\" \\n                 data-chart-colors=\\\"{{chartColors}}\\\"   \\n                 data-chart-config=\\\"{stroke:{width: 1}}\\\"  \\n                 data-chart-labels=\\\"{{chartLabels||Item 1,Item 2,Item 3,Item 4}}\\\"\\n                 data-chart-values=\\\"{{chartData||[25, 66, 41, 89]}}\\\">\\n            <\\/div>\\n        <\\/div>\\n    <\\/div> \\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"280px\",\"bgImg\":\"\",\"title\":\"TOTAL FORMS\",\"customId\":\"\",\"chartData\":\"{data:[#stats.form.countPerApp#]}\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"396865664749427F7C16A8737782D0D0\",\"value\":\"#datalist.col.sum.areaChart.column_2#\",\"chartLabels\":\"#stats.appList#\",\"chartColors\":\"\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'light-bg gauge\'}-->\\n<div class=\\\"card text-center p-3\\\"\\n     style=\\\"background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"stats-info\\\">\\n        <h4 style=\\\"font-size: 12px;\\n                   margin: 5px 0;\\n                   font-weight: normal;\\n                   color: rgba(0,0,0,.7);\\\">\\n            {{title||TOTAL VISITORS}}\\n        <\\/h4>\\n        <div class=\\\"stats-icon pt-2 d-flex align-items-center\\\">\\n            <div id=\\\"chart-{{id}}\\\" \\n                 data-chart-type=\\\"radialBar\\\" \\n                 data-chart-custom=\\\"{{chartConfig}}\\\" \\n                 data-chart-height=\\\"{{height||120px}}\\\" \\n                 data-chart-color=\\\"{{color||#563d7c}}\\\"\\n                 data-chart-config=\\\"{plotOptions: {radialBar: {dataLabels: {show: true,name: {show:false}, value: {fontSize: \'20px\', offsetY: 7, color:\'{{color||#563d7c}}\'}}, track: {background: \'#00000022\'}}}, tooltip: {theme: \'light\'}, stroke: {width: 1, colors : [\'#fff\']}}\\\"  \\n                 data-chart-labels=\\\"{{chartLabels}}\\\"  \\n                 data-chart-values=\\\"{{chartData||[53]}}\\\">\\n            <\\/div>\\n        <\\/div>\\n    <\\/div> \\n    <script>\\n        $(function(){\\n            loadScript(\\\"{{contextPath}}/js/apexcharts-sparkline.js\\\", function(){\\n                $(\\\"#chart-{{id}}\\\").acSparkline();\\n            });\\n        });\\n    <\\/script>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"link\":\"\",\"style-height\":\"280px\",\"bgImg\":\"\",\"title\":\"TOTAL FORMS\",\"customId\":\"\",\"chartData\":\"[54]\",\"chartConfig\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"23A59466ABAB4476702ADE30600F557E\",\"value\":\"#datalist.col.sum.areaChart.column_2#\",\"chartLabels\":\"#stats.appList#\",\"chartColors\":\"\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"attr-data-events-listening\":[],\"gutter\":\"5px\",\"columns\":[{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"},{\"style-mobile-max-width\":\"\",\"style-max-width\":\"\",\"style-tablet-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"8D9F3B85A1344809938DF72AA0853C2D\",\"customId\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'dark-bg icon progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}};\\n            background-color:{{color||#333333}};\\n            background-image:url(\'{{bgImg}}\'); \\n            color:#fff\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body\\\">\\n        <div class=\\\"stats-icon text-right\\\" \\n             style=\\\"font-size: 36px; \\n                    line-height:0;\\\">\\n            {{icon||<i class=\\\"la la-globe\\\"><\\/i>}}\\n        <\\/div>\\n        <div class=\\\"stats-info\\\">\\n            <p style=\\\"font-size: 18px; \\n                      font-weight: 600; \\n                      margin-bottom: 0;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n            <h4 style=\\\"font-size: 12px; \\n                       font-weight:300; \\n                       color: rgba(255,255,255,.8); \\n                       margin: 5px 0;\\\">\\n                {{title||VISITS}}\\n            <\\/h4>\\n            <div class=\\\"stats-progress\\\" \\n                 style=\\\"margin-top:5px;\\\">\\n                <div class=\\\"progress\\\" \\n                     style=\\\"height:5px;\\n                            background: rgba(0,0,0,.5);\\\">\\n                    <div class=\\\"progress-bar progress-bar-striped\\\" \\n                         style=\\\"width: {{progressbar-value||70}}%; \\n                                transition: width .6s ease; \\n                                background-color:#ffffff\\\">\\n                    <\\/div>\\n                <\\/div>    \\n            <\\/div>\\n        <\\/div>\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"reload\":\"\",\"color\":\"#348FE2\",\"progressbar-value\":\"50\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"bgImg\":\"\",\"id\":\"D93619EA2CF14B64FCCB448A3E551DDD\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"value\":\"3,291,922\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'250px\', tags: \'light-bg icon progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}};\\n            background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body\\\">\\n        <div class=\\\"stats-icon text-right\\\" \\n             style=\\\"font-size: 36px; \\n                    color: rgba(0,0,0,.6); \\n                    line-height:0;\\\">\\n            {{icon||<i class=\\\"la la-globe\\\"><\\/i>}}\\n        <\\/div>\\n        <div class=\\\"stats-info\\\">\\n            <p style=\\\"font-size: 18px; \\n                      font-weight: 600; \\n                      margin-bottom: 0;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n            <h4 style=\\\"font-size: 12px; \\n                       font-weight:bold; \\n                       color: rgba(0,0,0,.7); \\n                       margin: 5px 0;\\\">\\n                {{title||VISITS}}\\n            <\\/h4>\\n            <div class=\\\"stats-progress\\\" \\n                 style=\\\"margin-top:5px;\\\">\\n                <div class=\\\"progress\\\" \\n                     style=\\\"height:5px;\\\">\\n                    <div class=\\\"progress-bar progress-bar-striped\\\" \\n                         style=\\\"width: {{progressbar-value||70}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{color||#27c24c}};\\\">\\n                    <\\/div>\\n                <\\/div>    \\n            <\\/div>\\n        <\\/div>\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"progressbar-value\":\"50\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"bgImg\":\"\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"81EF3F0E6D734C56FE39562D2E0D5129\",\"value\":\"3,291,922\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'320px\', tags: \'dark-bg icon progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}}; \\n            background-color:{{color||#2d353c}}; \\n            color:#fff; \\n            overflow: hidden;\\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body row\\\">\\n        <div class=\\\"stats-info col-8\\\">\\n            <h4 style=\\\"font-size: 12px;\\n                       margin: 0px 0px 3px;\\n                       color: rgba(255,255,255,.7);\\\">\\n                {{title||TOTAL VISITORS}}\\n            <\\/h4>\\n            <p style=\\\"font-size: 24px; \\n                      font-weight: 600; \\n                      margin-bottom: 10px;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n        <\\/div>\\n        <div class=\\\"stats-icon col-4\\\" \\n             style=\\\"position:relative\\\">\\n            <span style=\\\"left:-10px; \\n                         position:absolute; \\n                         opacity: .15; \\n                         font-size: 140px; \\n                         text-shadow: 3px 7px rgb(0 0 0 / 25%);\\n                         line-height: 0;\\\">\\n                {{icon||<i class=\\\"fas fa-globe\\\"><\\/i>}}\\n            <\\/span>\\n        <\\/div>\\n        <div class=\\\"stats-progress col-12\\\">\\n            <div class=\\\"progress\\\" \\n                 style=\\\"background: rgba(0,0,0,.5);\\n                        height: 2px;\\n                        margin: 0 0 15px; \\n                        border-radius: 4px;\\\">\\n                <div class=\\\"progress-bar\\\" \\n                     style=\\\"width: {{progressbar-value||70.1}}%; \\n                            transition: width .6s ease; \\n                            background-color:#fff;\\\">\\n                <\\/div>\\n            <\\/div>    \\n        <\\/div>\\n        <div class=\\\"stats-desc col-12\\\" \\n             style=\\\"color: rgba(255,255,255,.7); \\n                    font-size:80%;\\\">\\n            {{description||Better than last week (70.1%)}}\\n        <\\/div>\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"progressbar-value\":\"50\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"description\":\"Better than last week (70%)\",\"bgImg\":\"\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"reload\":\"\",\"id\":\"58F4DDA57CEB4BBFA8E56C48AAC1EE69\",\"value\":\"3,291,922\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"3427B51DB4044931FC0CC6C46FBE1FAE\"}},{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'320px\', tags: \'light-bg icon progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}}; \\n            overflow: hidden;\\n            background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div style=\\\"position: absolute;\\n                top: 5px;\\n                right: 5px;\\n                z-index: 1;\\\">\\n        {{reload}}\\n    <\\/div>\\n    <div class=\\\"card-body row\\\">\\n        <div class=\\\"stats-info col-8\\\">\\n            <h4 style=\\\"font-size: 12px;\\n                       margin: 0px 0px 3px;\\n                       color: rgba(0,0,0,.7);\\\">\\n                {{title||TOTAL VISITORS}}\\n            <\\/h4>\\n            <p style=\\\"font-size: 24px; \\n                      font-weight: 600; \\n                      margin-bottom: 10px;\\\">\\n                {{value||3,291,922}}\\n            <\\/p>\\n        <\\/div>\\n        <div class=\\\"stats-icon col-4\\\" \\n             style=\\\"position:relative\\\">\\n            <span style=\\\"left:-10px; \\n                         position:absolute; \\n                         opacity: .1; \\n                         font-size: 140px; \\n                         color: {{color||#49b6d6}};\\n                         text-shadow: 3px 7px rgb(0 0 0 / 25%);\\n                         line-height: 0;\\\">\\n                {{icon||<i class=\\\"fas fa-globe\\\"><\\/i>}}\\n            <\\/span>\\n        <\\/div>\\n        <div class=\\\"stats-progress col-12\\\">\\n            <div class=\\\"progress\\\" \\n                 style=\\\"background: rgba(0,0,0,.5);\\n                        height: 2px;\\n                        margin: 0 0 15px; \\n                        border-radius: 4px;\\\">\\n                <div class=\\\"progress-bar\\\" \\n                     style=\\\"width: {{progressbar-value||70.1}}%; \\n                            transition: width .6s ease; \\n                            background-color:{{color||#49b6d6}};\\\">\\n                <\\/div>\\n            <\\/div>    \\n        <\\/div>\\n        <div class=\\\"stats-desc col-12\\\" \\n             style=\\\"color: rgba(0,0,0,.5); \\n                    font-size:80%;\\\">\\n            {{description||Better than last week (70.1%)}}\\n        <\\/div>\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"color\":\"#348FE2\",\"progressbar-value\":\"50\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"description\":\"Better than last week (70%)\",\"bgImg\":\"\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"id\":\"4106ED5D7FF2477E1AFF32274A56D958\",\"value\":\"3,291,922\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{\"id\":\"5D64E02946C84ECE0FFBCC66181B22A6\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"50CF72D9A712489FCF4B9AE1DAA100C6\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.InformationTileComponent\",\"properties\":{\"attr-data-events-listening\":[],\"template\":\"<!--{sampleWidth: \'350px\', tags: \'light-bg header tag progress\'}-->\\n<div class=\\\"card\\\" \\n     style=\\\"height:{{height}};\\n            background-color:{{bgColor}}; \\n            background-image:url(\'{{bgImg}}\');\\\">\\n    <div class=\\\"card-header\\\" \\n         style=\\\"background-color:transparent;\\\">\\n        <div class=\\\"row\\\">\\n            <div class=\\\"header-title col-8\\\">\\n                {{header||VISITORS}}\\n            <\\/div>\\n            <div class=\\\"header-tag col-4 text-right pl-0\\\">\\n                <span class=\\\"badge\\\" \\n                      style=\\\"background-color:{{tagColor||#1ab394}}; \\n                             color:#fff;\\\">\\n                    {{headerTag||Daily}}\\n                <\\/span>\\n                {{reload}}\\n            <\\/div>\\n        <\\/div>    \\n    <\\/div> \\n    <div class=\\\"pt-3 pb-2\\\">\\n        {{repeat||[{value: \\\"10/200 GB\\\", title: \\\"Memory\\\", color: \\\"#ED5565\\\", \'progressbar-value\' : \'60\'},{value: \\\"20 GB\\\", title: \\\"Bandwidth\\\", color: \\\"#23c6c8\\\", \'progressbar-value\' : \'50\'},{value: \\\"73%\\\", title: \\\"Activity\\\", color: \\\"#1c84c6\\\", \'progressbar-value\' : \'73\'}]}}\\n            <div class=\\\"px-3 pb-2\\\">\\n                <div class=\\\"mb-1\\\">\\n                    <span>\\n                        {{repeat.title}}\\n                    <\\/span>\\n                    <small class=\\\"float-right\\\">\\n                        {{repeat.value}}\\n                    <\\/small>\\n                <\\/div>\\n                <div class=\\\"progress progress-small\\\">\\n                    <div class=\\\"progress-bar\\\" \\n                         style=\\\"width: {{repeat.progressbar-value}}%; \\n                                transition: width .6s ease; \\n                                background-color:{{repeat.color}};\\\">\\n                    <\\/div>\\n                <\\/div>\\n            <\\/div>\\n        {{repeat}}\\n    <\\/div>\\n<\\/div>\\n<!---->\",\"color\":\"#348fe2\",\"headerTag\":\"Daily\",\"tagColor\":\"#13C4A6\",\"icon\":\"<i class=\\\"fas fa-globe\\\"><\\/i>\",\"bgImg\":\"\",\"title\":\"TOTAL VISITS\",\"customId\":\"\",\"reload\":\"\",\"bgColor\":\"\",\"repeat\":[{\"color\":\"#C33A61\",\"progressbar-value\":\"15\",\"title\":\"Memory\",\"value\":\"10/200 GB\"},{\"color\":\"#14BA8B\",\"progressbar-value\":\"50\",\"title\":\"Bandwidth\",\"value\":\"20GB\"}],\"header\":\"STATS\",\"id\":\"5C5B341809E444ADE9E4D97D076F8382\",\"value\":\"3,291,922\",\"height\":\"\"}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}},{\"className\":\"org.joget.apps.userview.lib.component.ColumnComponent\",\"properties\":{}}],\"className\":\"org.joget.apps.userview.lib.component.ColumnsComponent\",\"properties\":{\"gutter\":\"5px\",\"columns\":[{\"style-max-width\":\"\"},{\"style-max-width\":\"\"}],\"css-mobile-stack-columns\":\"true\",\"id\":\"DFC6EE8EC77D4D81DD190A08E44A9DE3\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-A8BC522C85ED42A56E1506FE9976804B\"}}','v'),
('JogetDxShowcase',1,'up-AA954DE23D264BCAB4FBDB8E186604EE','Joget Resources','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:16','2024-04-19 13:40:16','{\"elements\":[{\"className\":\"menu-component\"}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-AA954DE23D264BCAB4FBDB8E186604EE\"}}','v'),
('JogetDxShowcase',1,'up-E1FC6D362C2942E2D6C852DA339C1873','Component Events','INTERNAL_USERVIEW_PAGE','2024-04-19 13:40:16','2024-04-19 13:40:16','{\"elements\":[{\"className\":\"menu-component\"},{\"className\":\"org.joget.plugin.enterprise.CrudMenu\",\"properties\":{\"attr-data-events-listening\":[{\"eventObject\":\"2BFC6F0D8C8549F483CFA04F6FD6577A\",\"name\":\"reload_table\",\"action\":\"reload\"}],\"list-customFooter\":\"\",\"cacheAllLinks\":\"\",\"editFormId\":\"calendarMeeting\",\"edit-saveButtonLabel\":\"\",\"list-showDeleteButton\":\"yes\",\"list-newButtonLabel\":\"\",\"enableOffline\":\"\",\"list-deleteSubformData\":\"\",\"edit-afterSavedReloadTarget\":\"true\",\"selectionType\":\"multiple\",\"attr-data-ajax-component\":\"true\",\"addFormId\":\"\",\"id\":\"A4244152E1624F6CFEB30CA8015C7654\",\"add-messageShowAfterComplete\":\"\",\"edit-readonlyLabel\":\"\",\"list-editLinkLabel\":\"\",\"add-cancelButtonLabel\":\"\",\"list-deleteFiles\":\"\",\"add-afterSavedReloadTarget\":\"true\",\"add-customHeader\":\"\",\"attr-data-events-triggering\":[{\"ajaxMethod\":\"linkClicked\",\"notMatchName\":\"hide_form\",\"name\":\"load_form\",\"parametersRules\":[{\"name\":\"_mode\",\"value\":\"edit\",\"operator\":\"==\"}]}],\"edit-readonly\":\"\",\"datalistId\":\"list_calendarMeeting\",\"edit-nextButtonLabel\":\"\",\"list-confirmation\":\"\",\"userviewCacheDuration\":\"20\",\"add-afterSaved\":\"list\",\"list-customHeader\":\"\",\"edit-customHeader\":\"\",\"list-abortRelatedRunningProcesses\":\"\",\"edit-prevButtonLabel\":\"\",\"customId\":\"\",\"edit-afterSaved\":\"list\",\"list-deleteButtonLabel\":\"\",\"checkboxPosition\":\"left\",\"add-customFooter\":\"\",\"list-deleteGridData\":\"\",\"edit-allowRecordTraveling\":\"\",\"rowCount\":\"\",\"edit-customFooter\":\"\",\"keyName\":\"\",\"label\":\"Manage Meeting\",\"list-newLinkTarget\":\"\",\"edit-lastButtonLabel\":\"\",\"buttonPosition\":\"bottomLeft\",\"edit-firstButtonLabel\":\"\",\"add-saveButtonLabel\":\"\",\"edit-messageShowAfterComplete\":\"\",\"cacheListAction\":\"\",\"userviewCacheScope\":\"\",\"edit-moreActions\":[],\"list-moreActions\":[],\"edit-backButtonLabel\":\"\",\"list-editLinkTarget\":\"\"}},{\"className\":\"org.joget.apps.userview.lib.FormMenu\",\"properties\":{\"attr-data-events-listening\":[{\"eventObject\":\"A4244152E1624F6CFEB30CA8015C7654\",\"name\":\"hide_form\",\"action\":\"hide\"},{\"eventObject\":\"A4244152E1624F6CFEB30CA8015C7654\",\"name\":\"load_form\",\"action\":\"parameters\",\"parameters\":[{\"name\":\"id\",\"value\":\"{id}\"},{\"name\":\"close\",\"value\":\"false\"},{\"name\":\"_action\",\"value\":\"edit\"},{\"name\":\"_mode\",\"value\":\"edit\"}]},{\"eventObject\":\"\",\"name\":\"page_loaded\",\"action\":\"hide\"},{\"eventObject\":\"2BFC6F0D8C8549F483CFA04F6FD6577A\",\"name\":\"hide_form\",\"action\":\"hide\"}],\"loadDataWithKey\":\"\",\"redirectUrlOnCancel\":\"?close=true\",\"actionOnCancel\":\"\",\"redirectTargetOnCancel\":\"top\",\"customFooter\":\"\",\"enableOffline\":\"\",\"paramName\":\"\",\"afterSavedReloadTarget\":\"true\",\"customId\":\"\",\"showInPopupDialog\":\"\",\"cancelButtonLabel\":\"\",\"readonly\":\"\",\"attr-data-ajax-component\":\"true\",\"actionAfterSaved\":\"\",\"id\":\"2BFC6F0D8C8549F483CFA04F6FD6577A\",\"fieldPassover\":\"\",\"redirectUrlAfterComplete\":\"\",\"formId\":\"calendarMeeting\",\"customHeader\":\"\",\"fieldPassoverMethod\":\"append\",\"keyName\":\"\",\"redirectTargetOnComplete\":\"\",\"attr-data-events-triggering\":[{\"ajaxMethod\":\"get\",\"notMatchName\":\"\",\"name\":\"hide_form\",\"parametersRules\":[{\"name\":\"close\",\"value\":\"true\",\"operator\":\"==\"}]},{\"ajaxMethod\":\"post\",\"notMatchName\":\"\",\"name\":\"reload_table\",\"parametersRules\":[]}],\"label\":\"Form\",\"messageShowAfterComplete\":\"\",\"userviewCacheDuration\":\"20\",\"submitButtonLabel\":\"\",\"userviewCacheScope\":\"\",\"readonlyLabel\":\"\"}}],\"className\":\"org.joget.apps.userview.model.UserviewPage\",\"properties\":{\"id\":\"up-E1FC6D362C2942E2D6C852DA339C1873\"}}','v');
/*!40000 ALTER TABLE `app_builder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_datalist`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_datalist` (
  `appId` varchar(255) NOT NULL,
  `appVersion` bigint(20) NOT NULL,
  `id` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `json` longtext DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  PRIMARY KEY (`appId`,`appVersion`,`id`),
  KEY `FK5E9247A6462EF4C7` (`appId`,`appVersion`),
  KEY `idx_name` (`name`),
  CONSTRAINT `FK5E9247A6462EF4C7` FOREIGN KEY (`appId`, `appVersion`) REFERENCES `app_app` (`appId`, `appVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_datalist`
--

LOCK TABLES `app_datalist` WRITE;
/*!40000 ALTER TABLE `app_datalist` DISABLE KEYS */;
INSERT INTO `app_datalist` VALUES
('appcenter',1,'applist','App List',NULL,'{\"actions\":[],\"binder\":{\"className\":\"org.joget.apps.datalist.lib.JsonApiDatalistBinder\",\"properties\":{\"jsonUrl\":\"#request.baseURL#\\/web\\/json\\/apps\\/published\\/userviews?appCenter=true\",\"requestType\":\"\",\"headers\":[],\"copyCookies\":\"true\",\"multirowBaseObject\":\"apps.userviews\",\"totalRowCountObject\":\"\",\"primaryKey\":\"id\",\"handlePaging\":\"true\",\"handleFilters\":\"true\",\"debugMode\":\"\",\"sampleResponse\":\"{\\n    \\\"apps\\\":[\\n        {\\n            \\\"name\\\": \\\"Customer Relationship Management\\\",\\n            \\\"userviews\\\":[\\n                {\\n                    \\\"imageUrl\\\":\\\"\\/jw\\/web\\/app\\/crm\\/resources\\/crm.png\\\",\\n                    \\\"name\\\":\\\"CRM\\\",\\n                    \\\"id\\\": \\\"crm_userview_sales\\\",\\n                    \\\"category\\\":\\\"\\\",\\n                    \\\"version\\\":1,\\n                    \\\"url\\\": \\\"\\/jw\\/web\\/userview\\/crm\\/crm_userview_sales\\\"\\n                }\\n            ],\\n            \\\"id\\\":\\\"crm\\\",\\n            \\\"version\\\":1\\n        }\\n    ]\\n}\",\"joinObjectKeysAndValues\":\"\"}},\"card-style-background-color\":\"#F5F8FA\",\"card-style-border-radius\":\"10px\",\"card-style-border-width\":\"0px\",\"card-style-hover-background-color\":\"#F5F8FA\",\"card-style-hover-border-color\":\"#FFFFFF\",\"card-style-hover-custom\":\"transition: all 0.2s ease-out;\\r\\nbox-shadow: 0px 4px 8px rgba(38, 38, 38, 0.2);\\r\\ntop: -5px;\\r\\nborder: 1px solid #cccccc;\\r\\nbackground-color: white;\",\"card-style-max-height\":\"200px\",\"card-style-min-height\":\"200px\",\"card-style-padding-bottom\":\"0px\",\"card-style-padding-left\":\"0px\",\"card-style-padding-right\":\"0px\",\"card-style-padding-top\":\"2.25rem\",\"card-style-text-align\":\"center\",\"column_title\":[{\"id\":\"column_2\",\"name\":\"name\",\"label\":\"name\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}},\"style-font-size\":\"16px\",\"style-color\":\"#495057\",\"style-line-height\":\"20px\",\"style-custom\":\"text-overflow: ellipsis;\\r\\noverflow: hidden;\\r\\ndisplay: -webkit-box;\\r\\n-webkit-line-clamp: 2;\\r\\n-webkit-box-orient: vertical;\"}],\"columns\":[],\"considerFilterWhenGetTotal\":\"\",\"description\":\"\",\"disableResponsive\":\"\",\"filters\":[{\"id\":\"filter_0\",\"name\":\"apps.name\",\"label\":\"App Name\",\"filterParamName\":\"d-1331669-fn_apps.name\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\",\"filterSelection\":\"String\",\"searchFields\":\"\"}},\"datalist_type\":\"filter\",\"hidden\":\"\"}],\"hidePageSize\":\"true\",\"id\":\"applist\",\"name\":\"App List\",\"order\":\"2\",\"orderBy\":\"\",\"pageSize\":\"100\",\"pageSizeSelectorOptions\":\"10\",\"permission_rules\":[{\"permission\":{\"className\":\"org.joget.plugin.enterprise.AdminUserviewPermission\",\"properties\":{}},\"permission_key\":\"9D3F667778064DF2976BDBE2C629EA8D\",\"permission_name\":\"Is Admin\"}],\"responsiveMode\":\"\",\"rowAction_card\":[{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"id\":\"rowAction_2\",\"properties\":{\"confirmation\":\"\",\"datalist_type\":\"row_action\",\"header_label\":\"\",\"href\":\"#request.baseURL#\\/web\\/userview\",\"hrefColumn\":\"apps.id;id\",\"hrefParam\":\";\",\"label\":\"Hyperlink\",\"link-css-display-type\":\"btn btn-sm btn-primary\",\"rules\":[],\"target\":\"_blank\",\"style-custom\":\"box-shadow: none;\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{}}}}],\"rowActions\":[{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"hidden\":\"true\",\"id\":\"rowAction_0\",\"label\":\"Hyperlink\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{\"hidden\":\"\"}},\"properties\":{\"confirmation\":\"\",\"datalist_type\":\"row_action\",\"header_label\":\"\",\"href\":\"#request.baseURL#\\/web\\/console\\/app\",\"hrefColumn\":\"apps.id;apps.version;builders\",\"hrefParam\":\";;\",\"label\":\"<i class=\\\"fas fa-pen\\\"><\\/i> \",\"link-css-display-type\":\"btn btn-sm btn-primary\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{}},\"rules\":[],\"style-border-radius\":\"50%\",\"style-custom\":\"transition: 0.2s display ease-in-out;\",\"style-display\":\"none\",\"style-height\":\"30px\",\"style-position\":\"absolute\",\"style-right\":\"10px\",\"style-top\":\"10px\",\"style-width\":\"30px\",\"target\":\"_blank\",\"hidden\":\"true\"}}],\"searchPopup\":\"\",\"showDataWhenFilterSet\":\"\",\"template\":{\"className\":\"org.joget.apps.datalist.lib.AppIconTemplate\",\"properties\":{\"columns_mobile\":\"col-12\",\"columns_tablet\":\"col-md-6\",\"columns_desktop\":\"col-lg-2\",\"splitListByColumn\":\"\",\"enableSuperApp\":\"\"}},\"useSession\":\"\",\"column_image\":[{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"filterable\":true,\"format\":{\"className\":\"org.joget.apps.datalist.lib.ImageFormatter\",\"properties\":{\"defaultImage\":\"#request.baseURL#\\/web\\/userview\\/screenshot\\/appcenter\\/v\",\"height\":\"90px\",\"imageSrc\":\"\",\"imagefullsize\":\"\",\"width\":\"90px\"}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_0\",\"label\":\"imageUrl\",\"name\":\"imageUrl\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{\"exclude_export\":\"true\",\"hidden\":\"false\",\"include_export\":\"\"}},\"renderHtml\":\"\",\"sortable\":\"false\",\"style\":\"\",\"style-border-radius\":\"10px\",\"width\":\"\"}]}','2024-04-19 13:40:43','2024-04-19 13:40:43'),
('appcenter',1,'list_appList','List - Template List',NULL,'{\"actions\":[],\"binder\":{\"className\":\"org.joget.apps.datalist.lib.JsonApiDatalistBinder\",\"properties\":{\"copyCookies\":\"true\",\"debugMode\":\"\",\"handlePaging\":\"true\",\"headers\":[],\"jsonUrl\":\"#request.baseURL#\\/web\\/json\\/marketplace\\/list?type=Template&search={name}\",\"multirowBaseObject\":\"response\",\"primaryKey\":\"id\",\"requestType\":\"\",\"sampleResponse\":\"[\\n      {\\n        \\\"brief\\\": \\\"\\\",\\n        \\\"img\\\": \\\"\\\",\\n        \\\"developedBy\\\": \\\"\\\",\\n        \\\"joget_version\\\": \\\"\\\",\\n        \\\"count\\\": \\\"\\\",\\n        \\\"rating\\\": \\\"\\\",\\n        \\\"edition\\\": \\\"\\\",\\n        \\\"isNew\\\": \\\"\\\",\\n        \\\"version\\\": \\\"\\\",\\n        \\\"license\\\": \\\"\\\",\\n        \\\"contributor\\\": \\\"\\\",\\n        \\\"size\\\": \\\"\\\",\\n        \\\"price\\\": \\\"\\\",\\n        \\\"name\\\": \\\"\\\",\\n        \\\"id\\\": \\\"-v1\\\",\\n        \\\"tag\\\": \\\"\\\",\\n        \\\"category\\\": \\\"\\\",\\n        \\\"subcategory\\\": \\\"\\\",\\n        \\\"desc\\\": \\\"\\\"\\n      }\\n]\",\"totalRowCountObject\":\"\"}},\"buttonPosition\":\"bottomLeft\",\"card-style-margin-top\":\"10px\",\"checkboxPosition\":\"left\",\"column_title\":[{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_0\",\"label\":\"App Name\",\"name\":\"name\",\"renderHtml\":\"\",\"sortable\":\"false\",\"style\":\"\",\"style-color\":\"#181C32\",\"width\":\"\"}],\"columns\":[{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.BeanShellFormatter\",\"properties\":{\"script\":\"return value + \\\" <i class=\\\\\\\"fas fa-star\\\\\\\" style=\\\\\\\"color:#FDDA0D;\\\\\\\"><\\/i>\\\" \"}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_2\",\"label\":\"Rating\",\"name\":\"rating\",\"renderHtml\":\"\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.BeanShellFormatter\",\"properties\":{\"script\":\"return \\\"by\\\" + (value.equals(\\\"Joget, Inc.\\\")?\\\"<span class=\\\\\\\"badge badge-light-primary\\\\\\\">Joget, Inc.<\\/span>\\\":\\\"<span class=\\\\\\\"badge badge-light-info\\\\\\\">\\\"+value+\\\"<\\/span>\\\")\"}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_1\",\"label\":\"Design By\",\"name\":\"developedBy\",\"renderHtml\":\"\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"filterable\":true,\"format\":{\"className\":\"org.joget.apps.datalist.lib.ImageFormatter\",\"properties\":{\"defaultImage\":\"\",\"height\":\"0;padding-bottom:50%\",\"imageSrc\":\"\",\"imagefullsize\":\"\",\"width\":\"100%\"}},\"headerAlignment\":\"\",\"hidden\":\"true\",\"id\":\"column_5\",\"include_export\":\"\",\"label\":\"Image\",\"name\":\"img\",\"renderHtml\":\"\",\"sortable\":\"false\",\"style\":\"\",\"style-border-radius\":\"10px\",\"style-display\":\"none\",\"style-max-width\":\"100%\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"filterable\":true,\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_6\",\"label\":\"desc\",\"name\":\"desc\",\"renderHtml\":\"\",\"sortable\":\"false\",\"style\":\"\",\"style-margin-top\":\"25px\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.BeanShellFormatter\",\"properties\":{\"script\":\"return \\\"<i class=\\\\\\\"zmdi zmdi-download\\\\\\\"><\\/i> \\\" + value;\"}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_3\",\"label\":\"No Of Download\",\"name\":\"count\",\"renderHtml\":\"\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"}],\"considerFilterWhenGetTotal\":\"\",\"description\":\"\",\"filters\":[{\"datalist_type\":\"filter\",\"filterParamName\":\"d-6451840-fn_name\",\"id\":\"filter_0\",\"label\":\"Search\",\"name\":\"name\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{}}}],\"hidePageSize\":\"\",\"id\":\"list_appList\",\"name\":\"List - Template List\",\"order\":\"2\",\"orderBy\":\"name\",\"pageSize\":\"15\",\"pageSizeSelectorOptions\":\"15,30,60,90\",\"responsiveMode\":\"\",\"rowActions\":[{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"id\":\"rowAction_0\",\"properties\":{\"confirmation\":\"\",\"datalist_type\":\"row_action\",\"header_label\":\"\",\"href\":\"javascript:appCreate(\'{id}\');\",\"hrefColumn\":\"\",\"hrefParam\":\"\",\"label\":\"Use This Template\",\"link-css-display-type\":\"btn btn-sm btn-primary\",\"rules\":[],\"target\":\"_self\"}},{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"id\":\"rowAction_1\",\"properties\":{\"confirmation\":\"\",\"datalist_type\":\"row_action\",\"header_label\":\"\",\"href\":\"javascript:AdminBar.showQuickOverlay(\'#request.contextPath#\\/web\\/desktop\\/marketplace\\/app?url=\' + encodeURIComponent(\'#platform.marketplaceUrl#\\/jw\\/web\\/userview\\/mp\\/mpp\\/_\\/vad?id={id}\'))\",\"hrefColumn\":\"\",\"hrefParam\":\"\",\"label\":\"More Info\",\"link-css-display-type\":\"btn btn-sm btn-light\",\"rules\":[],\"style-margin-left\":\"10px\",\"style-padding-left\":\"30px\",\"style-padding-right\":\"30px\",\"target\":\"_self\"}}],\"showDataWhenFilterSet\":\"\",\"showPageSizeSelector\":\"true\",\"template\":{\"className\":\"org.joget.apps.datalist.lib.SimpleCardTemplate\",\"properties\":{\"image\":\"\",\"inlineLabel\":\"\",\"footerMsg\":\"\",\"cardAction\":\"\",\"columns_mobile\":\"col-12\",\"columns_tablet\":\"col-md-6\",\"columns_desktop\":\"col-lg-4\"}},\"useSession\":\"\"}','2024-04-19 13:40:43','2024-04-19 13:40:43'),
('appcenter',1,'list_newTemplate','List - New Template',NULL,'{\"considerFilterWhenGetTotal\":\"\",\"template\":{\"className\":\"org.joget.apps.datalist.lib.SimpleCardTemplate\",\"properties\":{\"image\":\"\",\"inlineLabel\":\"\",\"footerMsg\":\"\",\"cardAction\":\"\",\"columns_mobile\":\"col-12\",\"columns_tablet\":\"col-md-6\",\"columns_desktop\":\"col-lg-6\"}},\"useSession\":\"\",\"responsiveMode\":\"\",\"showPageSizeSelector\":\"true\",\"columns\":[{\"filterable\":true,\"hidden\":\"false\",\"include_export\":\"\",\"renderHtml\":\"\",\"format\":{\"className\":\"org.joget.apps.datalist.lib.ImageFormatter\",\"properties\":{\"imageSrc\":\"\",\"imagefullsize\":\"\",\"height\":\"0;padding-bottom:50%\",\"width\":\"100%\",\"defaultImage\":\"\"}},\"label\":\"Image\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"headerAlignment\":\"\",\"name\":\"img\",\"width\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"style\":\"\",\"id\":\"column_5\",\"alignment\":\"\",\"style-max-width\":\"100%\",\"style-border-radius\":\"10px\"},{\"hidden\":\"false\",\"renderHtml\":\"\",\"style-color\":\"#181C32\",\"format\":{\"className\":\"\",\"properties\":{}},\"label\":\"App Name\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"headerAlignment\":\"\",\"name\":\"name\",\"width\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"style\":\"\",\"id\":\"column_0\",\"alignment\":\"\"},{\"filterable\":true,\"hidden\":\"false\",\"renderHtml\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"label\":\"desc\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"style-margin-top\":\"25px\",\"headerAlignment\":\"\",\"name\":\"desc\",\"width\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"style\":\"\",\"id\":\"column_6\",\"alignment\":\"\"}],\"rowActions\":[{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"id\":\"rowAction_0\",\"properties\":{\"hrefColumn\":\"\",\"hrefParam\":\"\",\"rules\":[],\"confirmation\":\"\",\"href\":\"javascript:appCreate(\'{id}\');\",\"label\":\"Use This Template\",\"datalist_type\":\"row_action\",\"link-css-display-type\":\"btn btn-sm btn-primary\",\"header_label\":\"\",\"target\":\"_self\"}},{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"id\":\"rowAction_1\",\"properties\":{\"style-padding-right\":\"30px\",\"hrefColumn\":\"\",\"style-margin-left\":\"10px\",\"hrefParam\":\"\",\"rules\":[],\"confirmation\":\"\",\"label\":\"More Info\",\"datalist_type\":\"row_action\",\"header_label\":\"\",\"style-padding-left\":\"30px\",\"target\":\"_self\",\"href\":\"javascript:AdminBar.showQuickOverlay(\'#request.contextPath#\\/web\\/desktop\\/marketplace\\/app?url=\' + encodeURIComponent(\'#platform.marketplaceUrl#\\/jw\\/web\\/userview\\/mp\\/mpp\\/_\\/vad?id={id}\'))\",\"link-css-display-type\":\"btn btn-sm btn-light\"}}],\"description\":\"\",\"orderBy\":\"name\",\"pageSize\":\"0\",\"filters\":[],\"showDataWhenFilterSet\":\"\",\"buttonPosition\":\"bottomLeft\",\"hidePageSize\":\"true\",\"pageSizeSelectorOptions\":\"15,30,60,90\",\"checkboxPosition\":\"left\",\"column_title\":[],\"name\":\"List - New Template\",\"card-style-margin-top\":\"10px\",\"id\":\"list_newTemplate\",\"binder\":{\"className\":\"org.joget.apps.datalist.lib.JsonApiDatalistBinder\",\"properties\":{\"jsonUrl\":\"#request.baseURL#\\/web\\/json\\/marketplace\\/list?type=Template&isNew=true&rows=2&sort=name&desc=false\",\"requestType\":\"\",\"headers\":[],\"copyCookies\":\"true\",\"multirowBaseObject\":\"response\",\"totalRowCountObject\":\"\",\"primaryKey\":\"id\",\"handlePaging\":\"\",\"debugMode\":\"\",\"sampleResponse\":\"[\\n      {\\n        \\\"brief\\\": \\\"\\\",\\n        \\\"img\\\": \\\"\\\",\\n        \\\"developedBy\\\": \\\"\\\",\\n        \\\"joget_version\\\": \\\"\\\",\\n        \\\"count\\\": \\\"\\\",\\n        \\\"rating\\\": \\\"\\\",\\n        \\\"edition\\\": \\\"\\\",\\n        \\\"isNew\\\": \\\"\\\",\\n        \\\"version\\\": \\\"\\\",\\n        \\\"license\\\": \\\"\\\",\\n        \\\"contributor\\\": \\\"\\\",\\n        \\\"size\\\": \\\"\\\",\\n        \\\"price\\\": \\\"\\\",\\n        \\\"name\\\": \\\"\\\",\\n        \\\"id\\\": \\\"-v1\\\",\\n        \\\"tag\\\": \\\"\\\",\\n        \\\"category\\\": \\\"\\\",\\n        \\\"subcategory\\\": \\\"\\\",\\n        \\\"desc\\\": \\\"\\\"\\n      }\\n]\"}},\"actions\":[],\"order\":\"2\"}','2024-04-19 13:40:43','2024-04-19 13:40:43'),
('crm',1,'AccountsDashboard','Accounts Dashboard',NULL,'{\"id\":\"AccountsDashboard\",\"name\":\"Accounts Dashboard\",\"hidePageSize\":\"true\",\"pageSize\":\"10\",\"order\":\"1\",\"orderBy\":\"dateModified\",\"description\":\"\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"crm_account\",\"joins\":[],\"filters\":[],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_0\",\"name\":\"id\",\"label\":\"ID\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"name\":\"accountName\",\"label\":\"Account Name\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"properties\":{\"href\":\"AccountForm\",\"target\":\"_top\",\"hrefParam\":\"id\",\"hrefColumn\":\"id\",\"label\":\"\",\"confirmation\":\"\",\"visible\":\"\"}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_2\",\"label\":\"City\",\"displayLabel\":\"City\",\"name\":\"city\"}]}','2024-04-19 13:40:01','2024-04-19 13:40:01'),
('crm',1,'ContactDashboard','Contacts Dashboard',NULL,'{\"id\":\"ContactDashboard\",\"name\":\"Contacts Dashboard\",\"pageSize\":\"10\",\"order\":\"1\",\"orderBy\":\"dateModified\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"true\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"crm_contact\",\"joins\":[],\"filters\":[],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_0\",\"name\":\"firstName\",\"label\":\"First name\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"properties\":{\"href\":\"ContactForm\",\"target\":\"_top\",\"hrefParam\":\"id\",\"hrefColumn\":\"id\",\"label\":\"Hyperlink\",\"confirmation\":\"\",\"visible\":\"\"}},\"format\":{\"className\":\"\",\"properties\":{}},\"datalist_type\":\"\"},{\"id\":\"column_2\",\"label\":\"Last name\",\"displayLabel\":\"Last Name\",\"name\":\"lastName\",\"datalist_type\":\"\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_4\",\"label\":\"Mobile Number\",\"displayLabel\":\"Mobile Number\",\"name\":\"mobile\"}]}','2024-04-19 13:40:02','2024-04-19 13:40:02'),
('crm',1,'crm_account_list','Accounts',NULL,'{\"id\":\"crm_account_list\",\"name\":\"Accounts\",\"hidePageSize\":\"\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"pageSize\":\"0\",\"order\":\"2\",\"orderBy\":\"accountName\",\"description\":\"\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[{\"id\":\"rowAction_0\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"type\":\"text\",\"properties\":{\"href\":\"contact_list\",\"target\":\"_self\",\"hrefParam\":\"d-6304176-fn_account\",\"hrefColumn\":\"id\",\"label\":\"View Contacts\",\"confirmation\":\"\",\"visible\":\"\",\"rules\":[]},\"name\":\"Data List Hyperlink\",\"label\":\"Hyperlink\"},{\"id\":\"rowAction_1\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"type\":\"text\",\"properties\":{\"href\":\"ContactForm\",\"target\":\"_self\",\"hrefParam\":\"fk_account\",\"hrefColumn\":\"id\",\"label\":\"New Contact\",\"confirmation\":\"\",\"visible\":\"\",\"rules\":[]},\"name\":\"Data List Hyperlink\",\"label\":\"Hyperlink\"}],\"actions\":[],\"filters\":[{\"id\":\"filter_4\",\"name\":\"id\",\"filterParamName\":\"d-5043735-fn_id\",\"label\":\"Acc Id\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_3\",\"name\":\"accountName\",\"filterParamName\":\"d-5043735-fn_accountName\",\"label\":\"Acc Name\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_2\",\"name\":\"city\",\"label\":\"City\"},{\"id\":\"filter_1\",\"name\":\"state\",\"label\":\"State\"},{\"id\":\"filter_0\",\"name\":\"country\",\"label\":\"Country\"}],\"binder\":{\"name\":\"\",\"className\":\"org.joget.apps.datalist.lib.FormRowDataListBinder\",\"properties\":{\"formDefId\":\"crm_account\"}},\"columns\":[{\"id\":\"column_0\",\"name\":\"id\",\"label\":\"Acc Id\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"name\":\"accountName\",\"label\":\"Acc Name\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"properties\":{\"href\":\"AccountForm\",\"target\":\"_self\",\"hrefParam\":\"id\",\"hrefColumn\":\"id\",\"label\":\"\",\"confirmation\":\"\",\"visible\":\"\"}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_6\",\"name\":\"fax\",\"label\":\"Fax\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_2\",\"label\":\"City\",\"displayLabel\":\"City\",\"name\":\"city\"},{\"id\":\"column_4\",\"name\":\"state\",\"label\":\"State\",\"sortable\":\"true\",\"filterable\":\"true\",\"action\":\"\",\"formats\":\";\"},{\"id\":\"column_5\",\"name\":\"country\",\"label\":\"Country\",\"sortable\":\"true\",\"filterable\":\"true\",\"action\":\"\",\"formats\":\";\"},{\"id\":\"column_3\",\"label\":\"Date Modified\",\"displayLabel\":\"Date Modified\",\"name\":\"dateModified\"}]}','2024-04-19 13:40:02','2024-04-19 13:40:02'),
('crm',1,'crm_contact_list','Contacts',NULL,'{\"id\":\"crm_contact_list\",\"name\":\"Contacts\",\"pageSize\":\"0\",\"order\":\"2\",\"orderBy\":\"account\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[{\"id\":\"filter_1\",\"name\":\"account\",\"filterParamName\":\"d-6304176-fn_account\",\"label\":\"Acc Name\",\"type\":{\"className\":\"org.joget.plugin.enterprise.SelectBoxDataListFilterType\",\"properties\":{\"multiple\":\"autocomplete\",\"size\":\"\",\"defaultValue\":\"\",\"options\":[],\"optionsBinder\":{\"className\":\"org.joget.apps.form.lib.FormOptionsBinder\",\"properties\":{\"formDefId\":\"crm_account\",\"idColumn\":\"\",\"labelColumn\":\"accountName\",\"groupingColumn\":\"\",\"extraCondition\":\"\",\"addEmptyOption\":\"\",\"emptyLabel\":\"\",\"useAjax\":\"\"}}}}},{\"id\":\"filter_2\",\"name\":\"firstName\",\"filterParamName\":\"d-6304176-fn_firstName\",\"label\":\"First Name\",\"type\":{\"className\":\"org.joget.plugin.enterprise.SelectBoxDataListFilterType\",\"properties\":{\"multiple\":\"autocomplete\",\"size\":\"\",\"defaultValue\":\"\",\"options\":[],\"optionsBinder\":{\"className\":\"org.joget.apps.form.lib.FormOptionsBinder\",\"properties\":{\"formDefId\":\"crm_contact\",\"idColumn\":\"firstName\",\"labelColumn\":\"firstName\",\"groupingColumn\":\"\",\"extraCondition\":\"\",\"addEmptyOption\":\"\",\"emptyLabel\":\"\",\"useAjax\":\"\"}}}}},{\"id\":\"filter_0\",\"name\":\"lastName\",\"label\":\"Last Name\"},{\"id\":\"filter_3\",\"name\":\"mobile\",\"filterParamName\":\"d-6304176-fn_mobile\",\"label\":\"Mobile\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}}],\"binder\":{\"className\":\"org.joget.apps.datalist.lib.FormRowDataListBinder\",\"properties\":{\"formDefId\":\"crm_contact\",\"extraCondition\":\"\"}},\"columns\":[{\"id\":\"column_2\",\"name\":\"account\",\"label\":\"Acc Name\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"properties\":{\"href\":\"AccountForm\",\"target\":\"_self\",\"hrefParam\":\"id\",\"hrefColumn\":\"account\",\"label\":\"\",\"confirmation\":\"\",\"visible\":\"\"}},\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[],\"optionsBinder\":{\"className\":\"org.joget.apps.form.lib.FormOptionsBinder\",\"properties\":{\"formDefId\":\"crm_account\",\"idColumn\":\"id\",\"labelColumn\":\"accountName\",\"groupingColumn\":\"\",\"extraCondition\":\"\",\"addEmptyOption\":\"\",\"emptyLabel\":\"\",\"useAjax\":\"\"}}}}},{\"id\":\"column_7\",\"label\":\"Title\",\"displayLabel\":\"Title\",\"name\":\"title\"},{\"id\":\"column_5\",\"name\":\"firstName\",\"label\":\"First name\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"properties\":{\"href\":\"ContactForm\",\"target\":\"_top\",\"hrefParam\":\"id\",\"hrefColumn\":\"id\",\"label\":\"Link\",\"confirmation\":\"\",\"visible\":\"\"}},\"format\":{\"className\":\"\",\"properties\":{}},\"datalist_type\":\"\"},{\"id\":\"column_4\",\"name\":\"lastName\",\"label\":\"Last name\",\"sortable\":\"true\",\"filterable\":\"true\",\"action\":{\"className\":\"\",\"properties\":{}},\"formats\":\";\",\"datalist_type\":\"\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_3\",\"name\":\"mobile\",\"label\":\"Mobile\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_0\",\"name\":\"office\",\"label\":\"Office\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"name\":\"email\",\"label\":\"Email\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}},\"datalist_type\":\"\"},{\"id\":\"column_6\",\"name\":\"dateModified\",\"label\":\"Date Modified\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}]}','2024-04-19 13:40:02','2024-04-19 13:40:02'),
('crm',1,'crm_opportunity_list','Opportunity',NULL,'{\"id\":\"crm_opportunity_list\",\"name\":\"Opportunity\",\"hidePageSize\":\"\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateModified\",\"description\":\"\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[{\"id\":\"filter_2\",\"name\":\"account\",\"filterParamName\":\"d-4412661-fn_account\",\"label\":\"Account\",\"type\":{\"className\":\"org.joget.plugin.enterprise.SelectBoxDataListFilterType\",\"properties\":{\"multiple\":\"autocomplete\",\"size\":\"\",\"defaultValue\":\"\",\"options\":[],\"optionsBinder\":{\"className\":\"org.joget.apps.form.lib.FormOptionsBinder\",\"properties\":{\"formDefId\":\"crm_account\",\"idColumn\":\"\",\"labelColumn\":\"accountName\",\"groupingColumn\":\"\",\"extraCondition\":\"\",\"addEmptyOption\":\"\",\"emptyLabel\":\"\",\"useAjax\":\"\"}}}}},{\"id\":\"filter_1\",\"name\":\"title\",\"label\":\"Opportunity Title\"},{\"id\":\"filter_0\",\"name\":\"stage\",\"filterParamName\":\"d-4412661-fn_stage\",\"label\":\"Stage\",\"type\":{\"className\":\"org.joget.plugin.enterprise.SelectBoxDataListFilterType\",\"properties\":{\"multiple\":\"\",\"size\":\"\",\"defaultValue\":\"\",\"options\":[{\"value\":\"open\",\"label\":\"Open\"},{\"value\":\"won\",\"label\":\"Won\"},{\"value\":\"lost\",\"label\":\"Lost\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}}},{\"id\":\"filter_3\",\"name\":\"source\",\"filterParamName\":\"d-4412661-fn_source\",\"label\":\"Source\",\"type\":{\"className\":\"org.joget.plugin.enterprise.SelectBoxDataListFilterType\",\"properties\":{\"multiple\":\"\",\"size\":\"\",\"defaultValue\":\"\",\"options\":[{\"value\":\"Direct\",\"label\":\"Direct\"},{\"value\":\"Indirect\",\"label\":\"Indirect\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}}}],\"binder\":{\"name\":\"\",\"className\":\"org.joget.apps.datalist.lib.FormRowDataListBinder\",\"properties\":{\"formDefId\":\"crm_opportunity\"}},\"columns\":[{\"id\":\"column_4\",\"name\":\"account\",\"label\":\"Acc Name\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[],\"optionsBinder\":{\"className\":\"org.joget.apps.form.lib.FormOptionsBinder\",\"properties\":{\"formDefId\":\"crm_account\",\"idColumn\":\"\",\"labelColumn\":\"accountName\",\"groupingColumn\":\"\",\"extraCondition\":\"\",\"addEmptyOption\":\"\",\"emptyLabel\":\"\",\"useAjax\":\"\"}}}}},{\"id\":\"column_0\",\"name\":\"title\",\"label\":\"Opp Title\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"properties\":{\"href\":\"OpportunityForm\",\"target\":\"_self\",\"hrefParam\":\"id\",\"hrefColumn\":\"id\",\"label\":\"Title\",\"confirmation\":\"\",\"visible\":\"\"}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_5\",\"label\":\"Description\",\"displayLabel\":\"Description\",\"name\":\"description\"},{\"id\":\"column_2\",\"name\":\"amount\",\"label\":\"Amount $\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignRight\",\"headerAlignment\":\"dataListAlignRight\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_3\",\"name\":\"stage\",\"label\":\"Stage\",\"sortable\":\"true\",\"filterable\":\"true\",\"action\":\"\",\"formats\":\";\"},{\"id\":\"column_6\",\"label\":\"Source\",\"displayLabel\":\"Source\",\"name\":\"source\"},{\"id\":\"column_1\",\"name\":\"dateModified\",\"label\":\"Date Modified\",\"sortable\":\"true\",\"filterable\":\"true\",\"action\":\"\",\"formats\":\";\"}]}','2024-04-19 13:40:02','2024-04-19 13:40:02'),
('crm',1,'OpportunityDashboard','Opportunity Dashboard',NULL,'{\"id\":\"OpportunityDashboard\",\"name\":\"Opportunity Dashboard\",\"hidePageSize\":\"true\",\"pageSize\":\"10\",\"order\":\"1\",\"orderBy\":\"dateModified\",\"description\":\"\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"crm_opportunity\",\"joins\":[],\"filters\":[],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_0\",\"name\":\"account\",\"label\":\"Account\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_2\",\"name\":\"title\",\"label\":\"Opp. Title\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"properties\":{\"href\":\"OpportunityForm\",\"target\":\"_top\",\"hrefParam\":\"id\",\"hrefColumn\":\"id\",\"label\":\"\",\"confirmation\":\"\",\"visible\":\"\"}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"name\":\"amount\",\"label\":\"Amount\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignRight\",\"headerAlignment\":\"dataListAlignRight\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}]}','2024-04-19 13:40:02','2024-04-19 13:40:02'),
('crm',1,'Proposal','Proposals',NULL,'{\"id\":\"Proposal\",\"name\":\"Proposals\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[{\"name\":\"Data List Hyperlink Action\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"type\":\"text\",\"id\":\"action_0\",\"properties\":{\"href\":\"proposal_process\",\"target\":\"_self\",\"label\":\"Submit A New Proposal\",\"confirmation\":\"\",\"visible\":\"true\",\"datalist_type\":\"action\"}}],\"filters\":[{\"id\":\"filter_2\",\"name\":\"account\",\"filterParamName\":\"d-3959580-fn_account\",\"label\":\"Account\",\"type\":{\"className\":\"org.joget.plugin.enterprise.SelectBoxDataListFilterType\",\"properties\":{\"multiple\":\"autocomplete\",\"size\":\"\",\"defaultValue\":\"\",\"options\":[],\"optionsBinder\":{\"className\":\"org.joget.apps.form.lib.FormOptionsBinder\",\"properties\":{\"formDefId\":\"crm_account\",\"idColumn\":\"\",\"labelColumn\":\"accountName\",\"groupingColumn\":\"\",\"extraCondition\":\"\",\"addEmptyOption\":\"\",\"emptyLabel\":\"\",\"useAjax\":\"\"}}}}},{\"id\":\"filter_1\",\"name\":\"title\",\"label\":\"Proposal Title\"},{\"id\":\"filter_0\",\"name\":\"status\",\"label\":\"Status\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"crm_proposal_approval_form\",\"joins\":[],\"filters\":[],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_2\",\"name\":\"refNo\",\"label\":\"#\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"dataListAlignLeft\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_0\",\"name\":\"account\",\"label\":\"Acc Name\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"dataListAlignLeft\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[],\"optionsBinder\":{\"className\":\"org.joget.apps.form.lib.FormOptionsBinder\",\"properties\":{\"formDefId\":\"crm_account\",\"idColumn\":\"\",\"labelColumn\":\"accountName\",\"groupingColumn\":\"\",\"extraCondition\":\"\",\"addEmptyOption\":\"\",\"emptyLabel\":\"\",\"useAjax\":\"\"}}}}},{\"id\":\"column_4\",\"name\":\"title\",\"label\":\"Proposal Title\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"dataListAlignLeft\",\"action\":{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"properties\":{\"href\":\"ProposalForm\",\"target\":\"_self\",\"hrefParam\":\"id\",\"hrefColumn\":\"id\",\"label\":\"\",\"confirmation\":\"\",\"visible\":\"\"}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"name\":\"description\",\"label\":\"Description\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"dataListAlignLeft\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_7\",\"name\":\"status\",\"label\":\"Status\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[{\"value\":\"Approved\",\"label\":\"<span style=\'color:green;font-weight:bold;\'>Approved<\\/span>\"},{\"value\":\"Resubmit\",\"label\":\"<span style=\'color:red;font-weight:bold;\'>Resubmit<\\/span>\"},{\"value\":\"Rejected\",\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected<\\/span>\"},{\"value\":\"New\",\"label\":\"<span style=\'color:blue;font-weight:bold;\'>New<\\/span>\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}}},{\"id\":\"column_6\",\"name\":\"selectApprover\",\"label\":\"Approver\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_3\",\"label\":\"ID\",\"name\":\"id\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.plugin.enterprise.ProcessStatusDatalistFormatter\",\"properties\":{\"showProcessName\":\"\",\"showFutureActivities\":\"true\",\"showSkippedActivities\":\"\",\"usernameFormat\":\"combine\",\"eventClick\":\"\"}}}]}','2024-04-19 13:40:02','2024-04-19 13:40:02'),
('crm',1,'ProposalDashboardInbox','Proposal Dashboard Inbox',NULL,'{\"id\":\"ProposalDashboardInbox\",\"name\":\"Proposal Dashboard Inbox\",\"pageSize\":\"10\",\"order\":\"1\",\"orderBy\":\"dateModified\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"true\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"crm_proposal_approval_form\",\"joins\":[],\"filters\":[],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_4\",\"name\":\"title\",\"label\":\"Proposal Title\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"dataListAlignLeft\",\"action\":{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"properties\":{\"href\":\"ProposalForm\",\"target\":\"_self\",\"hrefParam\":\"id\",\"hrefColumn\":\"id\",\"label\":\"\",\"confirmation\":\"\",\"visible\":\"\"}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_0\",\"label\":\"Status\",\"name\":\"status\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[{\"value\":\"Approved\",\"label\":\"<span style=\'color:lime;font-weight:bold;\'>Approved<\\/span>\"},{\"value\":\"Resubmit\",\"label\":\"<span style=\'color:red;font-weight:bold;\'>Resubmit<\\/span>\"},{\"value\":\"Rejected\",\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected<\\/span>\"},{\"value\":\"New\",\"label\":\"<span style=\'color:blue;font-weight:bold;\'>New<\\/span>\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}}}]}','2024-04-19 13:40:02','2024-04-19 13:40:02'),
('crm',1,'ProposalsDashboard','Proposals Dashboard',NULL,'{\"id\":\"ProposalsDashboard\",\"name\":\"Proposals Dashboard\",\"hidePageSize\":\"true\",\"pageSize\":\"10\",\"order\":\"1\",\"orderBy\":\"dateModified\",\"description\":\"\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"joins\":[],\"having\":[],\"aggregateField\":[],\"formDefId\":\"crm_proposal_approval_form\",\"extraCondition\":\"\",\"filters\":[],\"groupBy\":\"\"}},\"columns\":[{\"id\":\"column_0\",\"name\":\"account\",\"label\":\"Acc Name\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"dataListAlignLeft\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_4\",\"name\":\"title\",\"label\":\"Proposal Title\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"dataListAlignLeft\",\"action\":{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"properties\":{\"href\":\"ProposalForm\",\"target\":\"_top\",\"hrefParam\":\"id\",\"hrefColumn\":\"id\",\"label\":\"\",\"confirmation\":\"\",\"visible\":\"\"}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"name\":\"status\",\"label\":\"Status\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[{\"value\":\"Approved\",\"label\":\"<span style=\'color:green;font-weight:bold;\'>Approved<\\/span>\"},{\"value\":\"Resubmit\",\"label\":\"<span style=\'color:red;font-weight:bold;\'>Resubmit<\\/span>\"},{\"value\":\"Rejected\",\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected<\\/span>\"},{\"value\":\"New\",\"label\":\"<span style=\'color:blue;font-weight:bold;\'>New<\\/span>\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}}}]}','2024-04-19 13:40:02','2024-04-19 13:40:02'),
('crm',1,'Users','Users',NULL,'{\"id\":\"Users\",\"name\":\"Users\",\"pageSize\":\"0\",\"order\":\"2\",\"orderBy\":\"username\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[{\"name\":\"Data List Hyperlink Action\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"type\":\"text\",\"id\":\"rowAction_0\",\"properties\":{\"href\":\"UserForm\",\"target\":\"_self\",\"hrefParam\":\"id\",\"hrefColumn\":\"username\",\"label\":\"Edit\",\"confirmation\":\"\",\"datalist_type\":\"row_action\",\"rules\":[{\"join\":\"AND\",\"field\":\"username\",\"operator\":\"<>\",\"value\":\"admin\"}]}}],\"actions\":[],\"filters\":[{\"id\":\"filter_0\",\"datalist_type\":\"filter\",\"name\":\"username\",\"filterParamName\":\"d-146950-fn_username\",\"label\":\"Username\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_2\",\"datalist_type\":\"filter\",\"name\":\"firstName\",\"filterParamName\":\"d-146950-fn_firstName\",\"label\":\"First Name\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_1\",\"datalist_type\":\"filter\",\"name\":\"lastName\",\"filterParamName\":\"d-146950-fn_lastName\",\"label\":\"Last Name\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_3\",\"datalist_type\":\"filter\",\"name\":\"email\",\"filterParamName\":\"d-146950-fn_email\",\"label\":\"Email\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.JogetEntityDatalistBinder\",\"properties\":{\"entity\":\"User\",\"filters\":[],\"extraCondition\":\"\"}},\"columns\":[{\"id\":\"column_0\",\"datalist_type\":\"column\",\"name\":\"username\",\"label\":\"Username\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"datalist_type\":\"column\",\"name\":\"firstName\",\"label\":\"First name\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_2\",\"datalist_type\":\"column\",\"name\":\"lastName\",\"label\":\"Last name\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_4\",\"datalist_type\":\"column\",\"name\":\"active\",\"label\":\"Active\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[{\"value\":\"1\",\"label\":\"Yes\"},{\"value\":\"0\",\"label\":\"No\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}}},{\"id\":\"column_3\",\"label\":\"Email\",\"displayLabel\":\"email\",\"name\":\"email\",\"datalist_type\":\"\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}]}','2024-04-19 13:40:02','2024-04-19 13:40:02'),
('crm',1,'UsersDashboard','Users Dashboard',NULL,'{\"id\":\"UsersDashboard\",\"name\":\"Users Dashboard\",\"pageSize\":\"10\",\"order\":\"2\",\"orderBy\":\"username\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"true\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.JogetEntityDatalistBinder\",\"properties\":{\"entity\":\"User\",\"filters\":[{\"join\":\"AND\",\"field\":\"username\",\"operator\":\"<>\",\"value\":\"admin\"}],\"extraCondition\":\"\"}},\"columns\":[{\"id\":\"column_0\",\"datalist_type\":\"column\",\"name\":\"username\",\"label\":\"Username\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"datalist_type\":\"column\",\"name\":\"firstName\",\"label\":\"First name\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"properties\":{\"href\":\"UserForm\",\"target\":\"_parent\",\"hrefParam\":\"id\",\"hrefColumn\":\"username\",\"label\":\"Link\",\"confirmation\":\"\",\"visible\":\"\"}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_2\",\"datalist_type\":\"column\",\"name\":\"lastName\",\"label\":\"Last name\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}]}','2024-04-19 13:40:02','2024-04-19 13:40:02'),
('dashboard',1,'user_list','User Registration List',NULL,'{\"id\":\"user_list\",\"name\":\"User Registration List\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[{\"id\":\"filter_0\",\"name\":\"username\",\"label\":\"Desired Username\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"user_approval\",\"joins\":[],\"filters\":[],\"extraCondition\":\"\",\"groupBy\":\"\",\"functionColumns\":[],\"customSelectionValue\":\"\"}},\"columns\":[{\"id\":\"column_6\",\"label\":\"Desired Username\",\"name\":\"username\"},{\"id\":\"column_2\",\"label\":\"First Name\",\"name\":\"firstName\"},{\"id\":\"column_1\",\"label\":\"Last Name\",\"name\":\"lastName\"},{\"id\":\"column_3\",\"label\":\"Email\",\"name\":\"email\"},{\"id\":\"column_0\",\"datalist_type\":\"column\",\"name\":\"status\",\"label\":\"Status\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"formatting\":\"b\",\"size\":\"\",\"color\":\"\",\"formDefId\":\"\",\"field\":\"\"}}},{\"id\":\"column_4\",\"label\":\"Date Created\",\"name\":\"dateCreated\"}]}','2024-04-19 13:40:06','2024-04-19 13:40:06'),
('expenseclaim',1,'ExpenseClaimDInbox','Expense Dash Inbox',NULL,'{\"actions\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"aggregateField\":[],\"extraCondition\":\"\",\"filters\":[],\"formDefId\":\"ExpensesClaim\",\"groupBy\":\"\",\"having\":[],\"joins\":[]}},\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"columns\":[{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"true\",\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"color\":\"\",\"field\":\"\",\"formDefId\":\"\",\"formatting\":\"\",\"size\":\"\"}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_1\",\"label\":\"Title\",\"name\":\"title\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\",\"include_export\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"true\",\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Approved&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Approved by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;Finance<\\/span>\",\"value\":\"Rejected by Finance\"},{\"label\":\"<span style=\'color:gray;font-weight:bold;\'>Draft<\\/span>\",\"value\":\"Draft\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Rejected by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Resubmit<\\/span>\",\"value\":\"Resubmit\"},{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Verified&nbsp;By&nbsp;Finance<\\/span>\",\"value\":\"Verified by Finance\"},{\"label\":\"<span style=\'color:orange;font-weight:bold;\'>Submitted<\\/span>\",\"value\":\"Submitted\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_0\",\"label\":\"Status\",\"name\":\"status\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\",\"include_export\":\"\"}],\"considerFilterWhenGetTotal\":\"\",\"description\":\"\",\"filters\":[],\"hidePageSize\":\"true\",\"id\":\"ExpenseClaimDInbox\",\"name\":\"Expense Dash Inbox\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"pageSize\":\"10\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"rowActions\":[],\"showDataWhenFilterSet\":\"\",\"showPageSizeSelector\":\"true\",\"useSession\":\"\"}','2024-04-19 13:40:09','2024-04-19 13:40:09'),
('expenseclaim',1,'ExpenseListMini','Expense Dash MyExpenses',NULL,'{\"actions\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"aggregateField\":[],\"extraCondition\":\"\",\"filters\":[{\"field\":\"username\",\"join\":\"AND\",\"operator\":\"=\",\"value\":\"#currentUser.username#\"}],\"formDefId\":\"ExpensesClaim\",\"groupBy\":\"\",\"having\":[],\"joins\":[]}},\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"columns\":[{\"action\":{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"properties\":{\"confirmation\":\"\",\"href\":\"#request.contextPath#\\/web\\/userview\\/expenseclaim\\/home\\/_\\/expensesclaimview?_mode=edit\",\"hrefColumn\":\"id\",\"hrefParam\":\"id\",\"label\":\"Edit\",\"target\":\"_top\"}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"true\",\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"color\":\"blue\",\"field\":\"\",\"formDefId\":\"\",\"formatting\":\"strong\",\"size\":\"\"}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_1\",\"label\":\"Title\",\"name\":\"title\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\",\"include_export\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"dataListAlignRight\",\"datalist_type\":\"column\",\"exclude_export\":\"true\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"dataListAlignRight\",\"hidden\":\"false\",\"id\":\"column_0\",\"label\":\"Amount $\",\"name\":\"total\",\"sortable\":\"true\",\"style\":\"text-align: right;\",\"width\":\"\",\"include_export\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"true\",\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Approved&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Approved by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;Finance<\\/span>\",\"value\":\"Rejected by Finance\"},{\"label\":\"<span style=\'color:gray;font-weight:bold;\'>Draft<\\/span>\",\"value\":\"Draft\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Rejected by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Resubmit<\\/span>\",\"value\":\"Resubmit\"},{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Verified&nbsp;By&nbsp;Finance<\\/span>\",\"value\":\"Verified by Finance\"},{\"label\":\"<span style=\'color:orange;font-weight:bold;\'>Submitted<\\/span>\",\"value\":\"Submitted\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_2\",\"label\":\"Status\",\"name\":\"status\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\",\"include_export\":\"\"}],\"considerFilterWhenGetTotal\":\"\",\"description\":\"\",\"filters\":[],\"hidePageSize\":\"true\",\"id\":\"ExpenseListMini\",\"name\":\"Expense Dash MyExpenses\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"pageSize\":\"10\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"rowActions\":[],\"showDataWhenFilterSet\":\"\",\"showPageSizeSelector\":\"true\",\"useSession\":\"\",\"template\":{\"className\":\"\",\"properties\":{}}}','2024-04-19 13:40:09','2024-04-19 13:40:09'),
('expenseclaim',1,'ExpensesApproved','Expense Approved',NULL,'{\"id\":\"ExpensesApproved\",\"name\":\"Expense Approved\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"actions\":[],\"description\":\"\",\"filters\":[{\"filterParamName\":\"d-5777152-fn_title\",\"id\":\"filter_1\",\"label\":\"Title\",\"name\":\"title\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"filterParamName\":\"d-5777152-fn_dateCreated\",\"id\":\"filter_0\",\"label\":\"Date Created\",\"name\":\"dateCreated\",\"type\":{\"className\":\"org.joget.plugin.enterprise.DateRangeDataListFilterType\",\"properties\":{\"format\":\"yy-mm-dd\",\"formatJava\":\"yyyy-MM-dd\",\"fromDefaultValue\":\"\",\"fromLabel\":\"From\",\"showFieldLabel\":\"true\",\"toDefaultValue\":\"\",\"toLabel\":\"To\",\"yearRange\":\"c-10:c+10\"}}}],\"hidePageSize\":\"\",\"rowActions\":[],\"showDataWhenFilterSet\":\"\",\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"customSelectionValue\":\"\",\"extraCondition\":\"\",\"filters\":[{\"field\":\"status\",\"join\":\"AND\",\"operator\":\"=\",\"value\":\"Approved by HOD\"},{\"field\":\"username\",\"join\":\"AND\",\"operator\":\"=\",\"value\":\"#currentUser.username#\"}],\"formDefId\":\"ExpensesApproval\",\"functionColumns\":[],\"groupBy\":\"\",\"joins\":[]}},\"columns\":[{\"action\":{\"className\":\"\",\"properties\":{}},\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"hidden\":\"false\",\"id\":\"column_1\",\"label\":\"#\",\"name\":\"ref\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"},{\"id\":\"column_0\",\"label\":\"Title\",\"name\":\"title\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Approved&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Approved by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;Finance<\\/span>\",\"value\":\"Rejected by Finance\"},{\"label\":\"<span style=\'color:gray;font-weight:bold;\'>Draft<\\/span>\",\"value\":\"Draft\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Rejected by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Resubmit<\\/span>\",\"value\":\"Resubmit\"},{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Verified&nbsp;By&nbsp;Finance<\\/span>\",\"value\":\"Verified by Finance\"},{\"label\":\"<span style=\'color:orange;font-weight:bold;\'>Submitted<\\/span>\",\"value\":\"Submitted\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_3\",\"label\":\"Status\",\"name\":\"status\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"dataListAlignRight\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"dataListAlignRight\",\"hidden\":\"false\",\"id\":\"column_2\",\"label\":\"Amount $\",\"name\":\"total\",\"sortable\":\"true\",\"style\":\"text-align: right;\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"hidden\":\"false\",\"id\":\"column_5\",\"label\":\"Created\",\"name\":\"dateCreated\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\",\"datalist_type\":\"column\",\"alignment\":\"\",\"headerAlignment\":\"\"}]}','2024-04-19 13:40:09','2024-04-19 13:40:09'),
('expenseclaim',1,'ExpensesByMonths','Expenses By Months',NULL,'{\"id\":\"ExpensesByMonths\",\"name\":\"Expenses By Months\",\"pageSize\":\"0\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"order\":\"\",\"orderBy\":\"\",\"description\":\"\",\"actions\":[],\"rowActions\":[],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"ExpensesClaim\",\"joins\":[],\"filters\":[{\"join\":\"AND\",\"field\":\"username\",\"operator\":\"=\",\"value\":\"#currentUser.username#\"},{\"join\":\"AND\",\"field\":\"dateCreatedYearMonth\",\"operator\":\">=\",\"value\":\"#date.MONTH-12.yyyy-MM#\"}],\"extraCondition\":\"\",\"aggregateField\":[{\"field\":\"total\",\"function\":\"AFD_SUM_\"}],\"groupBy\":\"dateCreatedYearMonth\",\"having\":[],\"functionColumns\":[{\"alias\":\"dateCreatedYearMonth\",\"function\":\"#beanshell.dateCreatedYearMonth#\"}],\"customSelectionValue\":\"\"}},\"columns\":[{\"id\":\"column_0\",\"name\":\"AFD_FUNC_dateCreatedYearMonth\",\"label\":\"dateCreatedYearMonth\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\"},{\"id\":\"column_1\",\"name\":\"AFD_SUM_total\",\"label\":\"Total Amount $ (SUM)\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\"}],\"template\":{\"className\":\"\",\"properties\":{}}}','2024-04-19 13:40:09','2024-04-19 13:40:09'),
('expenseclaim',1,'ExpensesClosed','Expense Closed',NULL,'{\"id\":\"ExpensesClosed\",\"name\":\"Expense Closed\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"actions\":[],\"description\":\"\",\"filters\":[{\"filterParamName\":\"d-5777152-fn_title\",\"id\":\"filter_1\",\"label\":\"Title\",\"name\":\"title\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"filterParamName\":\"d-5777152-fn_dateCreated\",\"id\":\"filter_0\",\"label\":\"Date Created\",\"name\":\"dateCreated\",\"type\":{\"className\":\"org.joget.plugin.enterprise.DateRangeDataListFilterType\",\"properties\":{\"format\":\"yy-mm-dd\",\"formatJava\":\"yyyy-MM-dd\",\"fromDefaultValue\":\"\",\"fromLabel\":\"From\",\"showFieldLabel\":\"true\",\"toDefaultValue\":\"\",\"toLabel\":\"To\",\"yearRange\":\"c-10:c+10\"}}}],\"hidePageSize\":\"\",\"rowActions\":[],\"showDataWhenFilterSet\":\"\",\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"customSelectionValue\":\"\",\"extraCondition\":\"\",\"filters\":[{\"field\":\"status\",\"join\":\"AND\",\"operator\":\"=\",\"value\":\"Verified by Finance\"},{\"field\":\"username\",\"join\":\"AND\",\"operator\":\"=\",\"value\":\"#currentUser.username#\"}],\"formDefId\":\"ExpensesApproval\",\"functionColumns\":[],\"groupBy\":\"\",\"joins\":[]}},\"columns\":[{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.NestedDatalistFormatter\",\"properties\":{\"addEmptyRow\":\"true\",\"customHeaderColor\":\"\",\"exportOptions\":\"\",\"listId\":\"list_ExpensesClaimEntry\",\"requestParams\":[{\"defaultValue\":\"\",\"hrefColumn\":\"id\",\"param\":\"d-1246756-fn_claim\"}]}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_1\",\"label\":\"#\",\"name\":\"ref\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_0\",\"label\":\"Title\",\"name\":\"title\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Approved&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Approved by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;Finance<\\/span>\",\"value\":\"Rejected by Finance\"},{\"label\":\"<span style=\'color:gray;font-weight:bold;\'>Draft<\\/span>\",\"value\":\"Draft\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Rejected by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Resubmit<\\/span>\",\"value\":\"Resubmit\"},{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Verified&nbsp;By&nbsp;Finance<\\/span>\",\"value\":\"Verified by Finance\"},{\"label\":\"<span style=\'color:orange;font-weight:bold;\'>Submitted<\\/span>\",\"value\":\"Submitted\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_3\",\"label\":\"Status\",\"name\":\"status\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"dataListAlignRight\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"dataListAlignRight\",\"hidden\":\"false\",\"id\":\"column_2\",\"label\":\"Amount $\",\"name\":\"total\",\"sortable\":\"true\",\"style\":\"text-align:right;\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"hidden\":\"false\",\"id\":\"column_4\",\"label\":\"Created\",\"name\":\"dateCreated\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\",\"datalist_type\":\"column\",\"alignment\":\"\",\"headerAlignment\":\"\"}],\"template\":{\"className\":\"\",\"properties\":{}}}','2024-04-19 13:40:09','2024-04-19 13:40:09'),
('expenseclaim',1,'ExpensesInbox','Expense Inbox',NULL,'{\"id\":\"ExpensesInbox\",\"name\":\"Expense Inbox\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"actions\":[{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"id\":\"action_0\",\"label\":\"Hyperlink\",\"name\":\"Data List Hyperlink Action\",\"properties\":{\"confirmation\":\"\",\"href\":\"new_claim\",\"label\":\"Create A New Expense Claim\",\"target\":\"_self\",\"visible\":\"true\",\"hrefParam\":\"\",\"hrefColumn\":\"\",\"datalist_type\":\"\"},\"type\":\"text\"}],\"description\":\"\",\"filters\":[{\"filterParamName\":\"d-5777152-fn_title\",\"id\":\"filter_1\",\"label\":\"Title\",\"name\":\"title\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"filterParamName\":\"d-6857696-fn_claimant\",\"id\":\"filter_2\",\"label\":\"Submit By\",\"name\":\"claimant\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"filterParamName\":\"d-5777152-fn_dateCreated\",\"id\":\"filter_0\",\"label\":\"Date Created\",\"name\":\"dateCreated\",\"type\":{\"className\":\"org.joget.plugin.enterprise.DateRangeDataListFilterType\",\"properties\":{\"format\":\"yy-mm-dd\",\"formatJava\":\"yyyy-MM-dd\",\"fromDefaultValue\":\"\",\"fromLabel\":\"From\",\"showFieldLabel\":\"true\",\"toDefaultValue\":\"\",\"toLabel\":\"To\",\"yearRange\":\"c-10:c+10\"}}}],\"hidePageSize\":\"\",\"rowActions\":[],\"showDataWhenFilterSet\":\"\",\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"aggregateField\":[],\"extraCondition\":\"\",\"filters\":[],\"formDefId\":\"ExpensesClaim\",\"groupBy\":\"\",\"having\":[],\"joins\":[]}},\"columns\":[{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.NestedDatalistFormatter\",\"properties\":{\"addEmptyRow\":\"true\",\"customHeaderColor\":\"\",\"exportOptions\":\"\",\"listId\":\"list_ExpensesClaimEntry\",\"requestParams\":[{\"defaultValue\":\"\",\"hrefColumn\":\"id\",\"param\":\"d-1246756-fn_claim\"}]}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_0\",\"label\":\"#\",\"name\":\"ref\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\",\"renderHtml\":\"\",\"style-tablet-display\":\"inline-block\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"hidden\":\"false\",\"id\":\"column_1\",\"label\":\"Title\",\"name\":\"title\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Approved&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Approved by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;Finance<\\/span>\",\"value\":\"Rejected by Finance\"},{\"label\":\"<span style=\'color:gray;font-weight:bold;\'>Draft<\\/span>\",\"value\":\"Draft\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Rejected by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Resubmit<\\/span>\",\"value\":\"Resubmit\"},{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Verified&nbsp;By&nbsp;Finance<\\/span>\",\"value\":\"Verified by Finance\"},{\"label\":\"<span style=\'color:orange;font-weight:bold;\'>Submitted<\\/span>\",\"value\":\"Submitted\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_3\",\"label\":\"Status\",\"name\":\"status\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"dataListAlignRight\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"dataListAlignRight\",\"hidden\":\"false\",\"id\":\"column_2\",\"label\":\"Amount $\",\"name\":\"total\",\"sortable\":\"true\",\"style\":\"text-align:right;\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"hidden\":\"false\",\"id\":\"column_4\",\"label\":\"Submit By\",\"name\":\"claimant\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\"},{\"displayLabel\":\"Remark\",\"id\":\"column_5\",\"label\":\"Remark\",\"name\":\"remark\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"displayLabel\":\"Select Approver\",\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_6\",\"label\":\"Approver\",\"name\":\"SelectApprover\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_7\",\"label\":\"Created\",\"name\":\"dateCreated\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\",\"datalist_type\":\"column\"}],\"template\":{\"className\":\"\",\"properties\":{}}}','2024-04-19 13:40:09','2024-04-19 13:40:09'),
('expenseclaim',1,'ExpensesListAll','Expense All',NULL,'{\"id\":\"ExpensesListAll\",\"name\":\"Expense All\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"actions\":[],\"description\":\"\",\"filters\":[{\"filterParamName\":\"d-5777152-fn_title\",\"id\":\"filter_1\",\"label\":\"Title\",\"name\":\"title\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"filterParamName\":\"d-6857696-fn_claimant\",\"id\":\"filter_2\",\"label\":\"Submit By\",\"name\":\"claimant\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"filterParamName\":\"d-5777152-fn_dateCreated\",\"id\":\"filter_0\",\"label\":\"Date Created\",\"name\":\"dateCreated\",\"type\":{\"className\":\"org.joget.plugin.enterprise.DateRangeDataListFilterType\",\"properties\":{\"format\":\"yy-mm-dd\",\"formatJava\":\"yyyy-MM-dd\",\"fromDefaultValue\":\"\",\"fromLabel\":\"From\",\"showFieldLabel\":\"true\",\"toDefaultValue\":\"\",\"toLabel\":\"To\",\"yearRange\":\"c-10:c+10\"}}}],\"hidePageSize\":\"\",\"rowActions\":[],\"showDataWhenFilterSet\":\"\",\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"aggregateField\":[],\"extraCondition\":\"\",\"filters\":[{\"field\":\"status\",\"join\":\"AND\",\"operator\":\"<>\",\"value\":\"Draft\"}],\"formDefId\":\"ExpensesClaim\",\"groupBy\":\"\",\"having\":[],\"joins\":[]}},\"columns\":[{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.NestedDatalistFormatter\",\"properties\":{\"addEmptyRow\":\"true\",\"customHeaderColor\":\"\",\"exportOptions\":\"\",\"listId\":\"list_ExpensesClaimEntry\",\"requestParams\":[{\"defaultValue\":\"\",\"hrefColumn\":\"id\",\"param\":\"d-1246756-fn_claim\"}]}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_0\",\"label\":\"#\",\"name\":\"ref\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_1\",\"label\":\"Title\",\"name\":\"title\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Approved&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Approved by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;Finance<\\/span>\",\"value\":\"Rejected by Finance\"},{\"label\":\"<span style=\'color:gray;font-weight:bold;\'>Draft<\\/span>\",\"value\":\"Draft\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Rejected by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Resubmit<\\/span>\",\"value\":\"Resubmit\"},{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Verified&nbsp;By&nbsp;Finance<\\/span>\",\"value\":\"Verified by Finance\"},{\"label\":\"<span style=\'color:orange;font-weight:bold;\'>Submitted<\\/span>\",\"value\":\"Submitted\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_3\",\"label\":\"Status\",\"name\":\"status\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"dataListAlignRight\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"filterable\":true,\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"dataListAlignRight\",\"hidden\":\"false\",\"id\":\"column_8\",\"label\":\"Amount $\",\"name\":\"total\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"hidden\":\"false\",\"id\":\"column_4\",\"label\":\"Submit By\",\"name\":\"claimant\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_5\",\"label\":\"Claimant Remark\",\"name\":\"remark\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"},{\"displayLabel\":\"Select Approver\",\"id\":\"column_6\",\"label\":\"Select Approver\",\"name\":\"SelectApprover\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_7\",\"label\":\"Created\",\"name\":\"dateCreated\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\",\"datalist_type\":\"column\"}],\"template\":{\"className\":\"\",\"properties\":{}},\"responsiveMode\":\"\",\"rowActionsMode\":\"\",\"disableResponsive\":\"\"}','2024-04-19 13:40:09','2024-04-19 13:40:09'),
('expenseclaim',1,'ExpensesRejected','Expense Rejected',NULL,'{\"id\":\"ExpensesRejected\",\"name\":\"Expense Rejected\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"actions\":[],\"description\":\"\",\"filters\":[{\"filterParamName\":\"d-5777152-fn_title\",\"id\":\"filter_0\",\"label\":\"Title\",\"name\":\"title\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"filterParamName\":\"d-5777152-fn_dateCreated\",\"id\":\"filter_1\",\"label\":\"Date Created\",\"name\":\"dateCreated\",\"type\":{\"className\":\"org.joget.plugin.enterprise.DateRangeDataListFilterType\",\"properties\":{\"format\":\"yy-mm-dd\",\"formatJava\":\"yyyy-MM-dd\",\"fromDefaultValue\":\"\",\"fromLabel\":\"From\",\"showFieldLabel\":\"true\",\"toDefaultValue\":\"\",\"toLabel\":\"To\",\"yearRange\":\"c-10:c+10\"}}}],\"hidePageSize\":\"\",\"rowActions\":[],\"showDataWhenFilterSet\":\"\",\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"customSelectionValue\":\"\",\"extraCondition\":\"\",\"filters\":[{\"field\":\"status\",\"join\":\"AND\",\"operator\":\"IN\",\"value\":\"Rejected by HOD;Rejected by Finance\"},{\"field\":\"username\",\"join\":\"AND\",\"operator\":\"=\",\"value\":\"#currentUser.username#\"}],\"formDefId\":\"ExpensesApproval\",\"functionColumns\":[],\"groupBy\":\"\",\"joins\":[]}},\"columns\":[{\"action\":{\"className\":\"\",\"properties\":{}},\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"hidden\":\"false\",\"id\":\"column_1\",\"label\":\"#\",\"name\":\"ref\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\"},{\"id\":\"column_0\",\"label\":\"Title\",\"name\":\"title\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Approved&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Approved by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;Finance<\\/span>\",\"value\":\"Rejected by Finance\"},{\"label\":\"<span style=\'color:gray;font-weight:bold;\'>Draft<\\/span>\",\"value\":\"Draft\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Rejected by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Resubmit<\\/span>\",\"value\":\"Resubmit\"},{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Verified&nbsp;By&nbsp;Finance<\\/span>\",\"value\":\"Verified by Finance\"},{\"label\":\"<span style=\'color:orange;font-weight:bold;\'>Submitted<\\/span>\",\"value\":\"Submitted\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_4\",\"label\":\"Status\",\"name\":\"status\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"dataListAlignRight\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"dataListAlignRight\",\"hidden\":\"false\",\"id\":\"column_2\",\"label\":\"Amount $\",\"name\":\"total\",\"sortable\":\"false\",\"style\":\"text-align: right;\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"hidden\":\"false\",\"id\":\"column_3\",\"label\":\"Created\",\"name\":\"dateCreated\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\",\"datalist_type\":\"column\",\"alignment\":\"\",\"headerAlignment\":\"\"}]}','2024-04-19 13:40:09','2024-04-19 13:40:09'),
('expenseclaim',1,'ExpensesSubmitted','Expense Submitted',NULL,'{\"id\":\"ExpensesSubmitted\",\"name\":\"Expense Submitted\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateModified\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"actions\":[{\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"id\":\"action_0\",\"label\":\"Hyperlink\",\"name\":\"Data List Hyperlink Action\",\"properties\":{\"confirmation\":\"\",\"href\":\"new_claim\",\"label\":\"Create A New Expense Claim\",\"target\":\"_self\",\"visible\":\"true\"},\"type\":\"text\"}],\"description\":\"\",\"filters\":[{\"filterParamName\":\"d-5777152-fn_title\",\"id\":\"filter_0\",\"label\":\"Title\",\"name\":\"title\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"filterParamName\":\"d-5777152-fn_dateCreated\",\"id\":\"filter_1\",\"label\":\"Date Created\",\"name\":\"dateCreated\",\"type\":{\"className\":\"org.joget.plugin.enterprise.DateRangeDataListFilterType\",\"properties\":{\"format\":\"yy-mm-dd\",\"formatJava\":\"yyyy-MM-dd\",\"fromDefaultValue\":\"\",\"fromLabel\":\"From\",\"showFieldLabel\":\"true\",\"toDefaultValue\":\"\",\"toLabel\":\"To\",\"yearRange\":\"c-10:c+10\"}}}],\"hidePageSize\":\"\",\"rowActions\":[],\"showDataWhenFilterSet\":\"\",\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"extraCondition\":\"\",\"filters\":[{\"field\":\"status\",\"join\":\"AND\",\"operator\":\"=\",\"value\":\"Submitted\"},{\"field\":\"username\",\"join\":\"AND\",\"operator\":\"=\",\"value\":\"#currentUser.username#\"}],\"formDefId\":\"ExpensesClaim\"}},\"columns\":[{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.NestedDatalistFormatter\",\"properties\":{\"addEmptyRow\":\"true\",\"customHeaderColor\":\"\",\"exportOptions\":\"\",\"listId\":\"list_ExpensesClaimEntry\",\"requestParams\":[{\"defaultValue\":\"\",\"hrefColumn\":\"id\",\"param\":\"d-1246756-fn_claim\"}]}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_1\",\"label\":\"Title\",\"name\":\"title\",\"sortable\":\"false\",\"style\":\"\",\"width\":\"\"},{\"id\":\"column_0\",\"label\":\"Ref\",\"name\":\"ref\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Approved&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Approved by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;Finance<\\/span>\",\"value\":\"Rejected by Finance\"},{\"label\":\"<span style=\'color:gray;font-weight:bold;\'>Draft<\\/span>\",\"value\":\"Draft\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Rejected&nbsp;by&nbsp;HOD<\\/span>\",\"value\":\"Rejected by HOD\"},{\"label\":\"<span style=\'color:red;font-weight:bold;\'>Resubmit<\\/span>\",\"value\":\"Resubmit\"},{\"label\":\"<span style=\'color:green;font-weight:bold;\'>Verified&nbsp;By&nbsp;Finance<\\/span>\",\"value\":\"Verified by Finance\"},{\"label\":\"<span style=\'color:orange;font-weight:bold;\'>Submitted<\\/span>\",\"value\":\"Submitted\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}}}},\"headerAlignment\":\"\",\"hidden\":\"false\",\"id\":\"column_4\",\"label\":\"Status\",\"name\":\"status\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"alignment\":\"dataListAlignRight\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"headerAlignment\":\"dataListAlignRight\",\"hidden\":\"false\",\"id\":\"column_2\",\"label\":\"Amount $\",\"name\":\"total\",\"sortable\":\"true\",\"style\":\"text-align: right;\",\"width\":\"\"},{\"action\":{\"className\":\"\",\"properties\":{}},\"exclude_export\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"hidden\":\"false\",\"id\":\"column_3\",\"label\":\"Created\",\"name\":\"dateCreated\",\"sortable\":\"true\",\"style\":\"\",\"width\":\"\",\"datalist_type\":\"column\",\"alignment\":\"\",\"headerAlignment\":\"\"}]}','2024-04-19 13:40:09','2024-04-19 13:40:09'),
('expenseclaim',1,'list_ExpensesClaimEntry','Expense Claim Entry',NULL,'{\n    \"actions\": [],\n    \"binder\": {\n        \"className\": \"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\n        \"properties\": {\"formDefId\": \"ExpensesClaimEntry\"}\n    },\n    \"buttonPosition\": \"bottomLeft\",\n    \"checkboxPosition\": \"left\",\n    \"columns\": [\n        {\n            \"format\": {\n                \"className\": \"org.joget.plugin.enterprise.OptionsValueFormatter\",\n                \"properties\": {\n                    \"options\": [],\n                    \"optionsBinder\": {\n                        \"className\": \"org.joget.apps.form.lib.FormOptionsBinder\",\n                        \"properties\": {\n                            \"addEmptyOption\": \"\",\n                            \"emptyLabel\": \"\",\n                            \"extraCondition\": \"\",\n                            \"formDefId\": \"SetupCategory\",\n                            \"groupingColumn\": \"\",\n                            \"idColumn\": \"Category\",\n                            \"labelColumn\": \"Category\",\n                            \"useAjax\": \"\"\n                        }\n                    }\n                }\n            },\n            \"id\": \"column_1\",\n            \"label\": \"Category\",\n            \"name\": \"category\"\n        },\n        {\n            \"action\": {\n                \"className\": \"\",\n                \"properties\": {}\n            },\n            \"alignment\": \"dataListAlignCenter\",\n            \"datalist_type\": \"column\",\n            \"exclude_export\": \"\",\n            \"format\": {\n                \"className\": \"\",\n                \"properties\": {}\n            },\n            \"headerAlignment\": \"dataListAlignCenter\",\n            \"hidden\": \"false\",\n            \"id\": \"column_3\",\n            \"label\": \"Date\",\n            \"name\": \"date\",\n            \"sortable\": \"false\",\n            \"style\": \"\",\n            \"width\": \"\"\n        },\n        {\n            \"id\": \"column_5\",\n            \"label\": \"Purpose\",\n            \"name\": \"purpose\"\n        },\n        {\n            \"action\": {\n                \"className\": \"\",\n                \"properties\": {}\n            },\n            \"alignment\": \"dataListAlignRight\",\n            \"datalist_type\": \"column\",\n            \"exclude_export\": \"\",\n            \"format\": {\n                \"className\": \"\",\n                \"properties\": {}\n            },\n            \"headerAlignment\": \"dataListAlignRight\",\n            \"hidden\": \"false\",\n            \"id\": \"column_0\",\n            \"label\": \"Amount $\",\n            \"name\": \"amount\",\n            \"sortable\": \"false\",\n            \"style\": \"\",\n            \"width\": \"\"\n        }\n    ],\n    \"considerFilterWhenGetTotal\": \"\",\n    \"description\": \"\",\n    \"disableResponsive\": \"\",\n    \"filters\": [{\n        \"datalist_type\": \"filter\",\n        \"filterParamName\": \"d-1246756-fn_claim\",\n        \"hidden\": \"true\",\n        \"id\": \"filter_0\",\n        \"label\": \"claim\",\n        \"name\": \"claim\",\n        \"type\": {\n            \"className\": \"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\n            \"properties\": {\"defaultValue\": \"\"}\n        }\n    }],\n    \"hidePageSize\": \"true\",\n    \"id\": \"list_ExpensesClaimEntry\",\n    \"name\": \"Expense Claim Entry\",\n    \"order\": \"2\",\n    \"orderBy\": \"date\",\n    \"pageSize\": \"100\",\n    \"pageSizeSelectorOptions\": \"10,20,30,40,50,100\",\n    \"responsiveView\": [\n        {\n            \"breakpoint\": \"\",\n            \"columns\": \"\",\n            \"view\": \"Mobile\"\n        },\n        {\n            \"breakpoint\": \"\",\n            \"columns\": \"\",\n            \"view\": \"Tablet\"\n        }\n    ],\n    \"rowActions\": [],\n    \"searchPopup\": \"\",\n    \"showDataWhenFilterSet\": \"\",\n    \"showPageSizeSelector\": \"true\",\n    \"useSession\": \"\"\n}','2024-04-19 13:40:09','2024-04-19 13:40:09'),
('expenseclaim',1,'SetupCategory','Expense Setup Category',NULL,'{\"id\":\"SetupCategory\",\"name\":\"Expense Setup Category\",\"pageSize\":\"50\",\"order\":\"2\",\"orderBy\":\"Category\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"actions\":[],\"description\":\"\",\"filters\":[{\"id\":\"filter_0\",\"label\":\"Expense Category\",\"name\":\"Category\",\"filterParamName\":\"d-5477653-fn_Category\"}],\"hidePageSize\":\"true\",\"rowActions\":[],\"showDataWhenFilterSet\":\"\",\"disableResponsive\":\"\",\"searchPopup\":\"\",\"responsiveView\":[{\"view\":\"Mobile\",\"breakpoint\":\"\",\"columns\":\"\"},{\"view\":\"Tablet\",\"breakpoint\":\"\",\"columns\":\"\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"aggregateField\":[],\"extraCondition\":\"\",\"filters\":[],\"formDefId\":\"SetupCategory\",\"groupBy\":\"\",\"having\":[],\"joins\":[]}},\"columns\":[{\"displayLabel\":\"Expense Category\",\"id\":\"column_1\",\"label\":\"Expense Category\",\"name\":\"Category\"}],\"template\":{\"className\":\"\",\"properties\":{}},\"responsiveMode\":\"\",\"rowActionsMode\":\"\"}','2024-04-19 13:40:09','2024-04-19 13:40:09'),
('isr',1,'d_add_requests','ISR All Requests - Dashboard',NULL,'{\"useSession\":\"\",\"showPageSizeSelector\":\"true\",\"rowActions\":[],\"columns\":[{\"id\":\"column_1\",\"name\":\"ref_id\",\"label\":\"Ref Id\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\"},{\"id\":\"column_0\",\"name\":\"subject\",\"label\":\"Subject\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\"},{\"id\":\"column_2\",\"name\":\"status\",\"label\":\"status\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\"},{\"id\":\"column_6\",\"name\":\"attention\",\"label\":\"Approver\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_3\",\"name\":\"requester_name\",\"label\":\"Requested By\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\"},{\"id\":\"column_4\",\"name\":\"createdDate\",\"label\":\"Requested Date\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\"}],\"pageSize\":\"10\",\"orderBy\":\"\",\"description\":\"\",\"filters\":[],\"showDataWhenFilterSet\":\"\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"hidePageSize\":\"true\",\"checkboxPosition\":\"left\",\"name\":\"ISR All Requests - Dashboard\",\"id\":\"d_add_requests\",\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"isr_new_request\",\"joins\":[],\"filters\":[],\"extraCondition\":\"\",\"groupBy\":\"\",\"functionColumns\":[],\"customSelectionValue\":\"\"}},\"actions\":[],\"order\":\"\",\"considerFilterWhenGetTotal\":\"\",\"rowActionsMode\":\"\",\"searchPopup\":\"\",\"disableResponsive\":\"\",\"responsive_layout\":\"\",\"responsiveView\":[{\"view\":\"Mobile\",\"breakpoint\":\"\",\"columns\":\"\"},{\"view\":\"Tablet\",\"breakpoint\":\"\",\"columns\":\"\"}]}','2024-04-19 13:40:11','2024-04-19 13:40:11'),
('isr',1,'d_my_requests','My Request - Dashboard',NULL,'{\"useSession\":\"\",\"showPageSizeSelector\":\"true\",\"rowActions\":[],\"columns\":[{\"id\":\"column_0\",\"name\":\"ref_id\",\"label\":\"Ref Id\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\"},{\"id\":\"column_2\",\"name\":\"subject\",\"label\":\"Subject\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\"},{\"id\":\"column_1\",\"name\":\"status\",\"label\":\"status\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\"},{\"id\":\"column_6\",\"name\":\"attention\",\"label\":\"Approver\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_5\",\"name\":\"createdDate\",\"label\":\"Requested Date\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\"}],\"pageSize\":\"10\",\"orderBy\":\"dateCreated\",\"description\":\"\",\"filters\":[],\"showDataWhenFilterSet\":\"\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"hidePageSize\":\"true\",\"checkboxPosition\":\"left\",\"name\":\"My Request - Dashboard\",\"id\":\"d_my_requests\",\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"isr_new_request\",\"joins\":[],\"filters\":[],\"extraCondition\":\"\",\"groupBy\":\"\",\"functionColumns\":[],\"customSelectionValue\":\"\"}},\"actions\":[],\"order\":\"1\",\"considerFilterWhenGetTotal\":\"\",\"rowActionsMode\":\"\",\"searchPopup\":\"\",\"disableResponsive\":\"\",\"responsive_layout\":\"\",\"responsiveView\":[{\"view\":\"Mobile\",\"breakpoint\":\"\",\"columns\":\"2\"},{\"view\":\"Tablet\",\"breakpoint\":\"\",\"columns\":\"\"}]}','2024-04-19 13:40:11','2024-04-19 13:40:11'),
('isr',1,'isr_all_requests','ISR All Requests',NULL,'{\"id\":\"isr_all_requests\",\"name\":\"ISR All Requests\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"ref_id\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[{\"id\":\"filter_1\",\"name\":\"ref_id\",\"filterParamName\":\"d-3819911-fn_ref_id\",\"label\":\"#\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_2\",\"name\":\"subject\",\"label\":\"Subject\"},{\"id\":\"filter_0\",\"name\":\"status\",\"filterParamName\":\"d-3819911-fn_status\",\"label\":\"ISR Status\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_3\",\"name\":\"requester_name\",\"label\":\"Requested By\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"isr_new_request\",\"joins\":[],\"filters\":[],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_0\",\"name\":\"ref_id\",\"label\":\"#\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"name\":\"subject\",\"label\":\"Subject\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_2\",\"name\":\"priority\",\"label\":\"Priority\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_5\",\"datalist_type\":\"column\",\"name\":\"status\",\"label\":\"ISR Status\",\"sortable\":\"true\",\"renderHtml\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"formatting\":\"b\",\"size\":\"\",\"color\":\"\",\"formDefId\":\"\",\"field\":\"\"}}},{\"id\":\"column_3\",\"name\":\"requester_name\",\"label\":\"Request By\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_6\",\"name\":\"assignee\",\"label\":\"Assignee\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_4\",\"name\":\"createdDate\",\"label\":\"Request Date\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}]}','2024-04-19 13:40:11','2024-04-19 13:40:11'),
('isr',1,'isr_assigned_requests','ISR Assigned Requests',NULL,'{\"id\":\"isr_assigned_requests\",\"name\":\"ISR Assigned Requests\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[{\"id\":\"filter_3\",\"name\":\"ref_id\",\"filterParamName\":\"d-7417520-fn_ref_id\",\"label\":\"#\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_2\",\"name\":\"subject\",\"label\":\"Subject\"},{\"id\":\"filter_1\",\"name\":\"status\",\"filterParamName\":\"d-3819911-fn_status\",\"label\":\"ISR Status\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_0\",\"name\":\"requester_name\",\"label\":\"Requested By\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"isr_new_request\",\"joins\":[],\"filters\":[{\"join\":\"AND\",\"field\":\"status\",\"operator\":\"=\",\"value\":\"Assigned\"}],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_0\",\"label\":\"Ref Id\",\"name\":\"ref_id\"},{\"id\":\"column_1\",\"label\":\"Subject\",\"name\":\"subject\"},{\"id\":\"column_2\",\"name\":\"priority\",\"label\":\"Priority\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_6\",\"datalist_type\":\"column\",\"name\":\"status\",\"label\":\"ISR Status\",\"sortable\":\"true\",\"renderHtml\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"formatting\":\"b\",\"size\":\"\",\"color\":\"\",\"formDefId\":\"\",\"field\":\"\"}}},{\"id\":\"column_3\",\"label\":\"Assignee\",\"name\":\"assignee\"},{\"id\":\"column_4\",\"name\":\"requester_name\",\"label\":\"Request By\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_5\",\"name\":\"createdDate\",\"label\":\"Request Date\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}]}','2024-04-19 13:40:11','2024-04-19 13:40:11'),
('isr',1,'isr_new_requests','ISR New Requests',NULL,'{\"id\":\"isr_new_requests\",\"name\":\"ISR New Requests\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"ref_id\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[{\"id\":\"filter_3\",\"name\":\"ref_id\",\"filterParamName\":\"d-5925992-fn_ref_id\",\"label\":\"#\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_2\",\"name\":\"subject\",\"label\":\"Subject\"},{\"id\":\"filter_1\",\"name\":\"status\",\"filterParamName\":\"d-3819911-fn_status\",\"label\":\"ISR Status\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_0\",\"name\":\"requester_name\",\"label\":\"Requested By\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"isr_new_request\",\"joins\":[],\"filters\":[{\"join\":\"AND\",\"field\":\"status\",\"operator\":\"=\",\"value\":\"New\"}],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_0\",\"label\":\"Ref Id\",\"name\":\"ref_id\"},{\"id\":\"column_1\",\"label\":\"Subject\",\"name\":\"subject\"},{\"id\":\"column_2\",\"label\":\"Priority\",\"name\":\"priority\"},{\"id\":\"column_5\",\"datalist_type\":\"column\",\"name\":\"status\",\"label\":\"ISR Status\",\"sortable\":\"true\",\"renderHtml\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"formatting\":\"b\",\"size\":\"\",\"color\":\"\",\"formDefId\":\"\",\"field\":\"\"}}},{\"id\":\"column_3\",\"name\":\"requester_name\",\"label\":\"Request By\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_4\",\"label\":\"Requested Date\",\"name\":\"createdDate\"}]}','2024-04-19 13:40:11','2024-04-19 13:40:11'),
('isr',1,'isr_personal_submitted','My Submitted Requests',NULL,'{\"id\":\"isr_personal_submitted\",\"name\":\"My Submitted Requests\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"ref_id\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[{\"name\":\"Data List Hyperlink Action\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"type\":\"text\",\"id\":\"action_0\",\"properties\":{\"href\":\"new_request\",\"target\":\"_self\",\"label\":\"Submit Request\",\"confirmation\":\"\",\"visible\":\"true\"}},{\"name\":\"Data List Hyperlink Action\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"type\":\"text\",\"id\":\"action_1\",\"properties\":{\"href\":\"attending_submitted\",\"target\":\"_self\",\"label\":\"My Inbox\",\"confirmation\":\"\",\"visible\":\"true\"}}],\"filters\":[{\"id\":\"filter_3\",\"name\":\"ref_id\",\"filterParamName\":\"d-1831629-fn_ref_id\",\"label\":\"#\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_2\",\"name\":\"subject\",\"label\":\"Subject\"},{\"id\":\"filter_1\",\"name\":\"status\",\"filterParamName\":\"d-3819911-fn_status\",\"label\":\"ISR Status\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_0\",\"name\":\"requester_name\",\"label\":\"Requested By\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"isr_new_request\",\"joins\":[],\"filters\":[{\"join\":\"AND\",\"field\":\"requester\",\"operator\":\"=\",\"value\":\"#currentUser.username#\"}],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_0\",\"name\":\"ref_id\",\"label\":\"#\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"label\":\"Subject\",\"name\":\"subject\"},{\"id\":\"column_5\",\"name\":\"priority\",\"label\":\"Priority\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_6\",\"datalist_type\":\"column\",\"name\":\"status\",\"label\":\"ISR Status\",\"sortable\":\"true\",\"renderHtml\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"formatting\":\"b\",\"size\":\"\",\"color\":\"\",\"formDefId\":\"\",\"field\":\"\"}}},{\"id\":\"column_3\",\"name\":\"requester_name\",\"label\":\"Request By\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_7\",\"name\":\"assignee\",\"label\":\"Assignee\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_4\",\"label\":\"Requested Date\",\"name\":\"createdDate\"}]}','2024-04-19 13:40:11','2024-04-19 13:40:11'),
('isr',1,'isr_rejected_requests','ISR Rejected Requests',NULL,'{\"id\":\"isr_rejected_requests\",\"name\":\"ISR Rejected Requests\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[{\"id\":\"filter_3\",\"name\":\"ref_id\",\"filterParamName\":\"d-1300920-fn_ref_id\",\"label\":\"#\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_2\",\"name\":\"subject\",\"label\":\"Subject\"},{\"id\":\"filter_1\",\"name\":\"status\",\"filterParamName\":\"d-3819911-fn_status\",\"label\":\"ISR Status\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_0\",\"name\":\"requester_name\",\"label\":\"Requested By\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"isr_new_request\",\"joins\":[],\"filters\":[{\"join\":\"AND\",\"field\":\"status\",\"operator\":\"=\",\"value\":\"Rejected\"}],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_0\",\"name\":\"ref_id\",\"label\":\"#\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"label\":\"Subject\",\"name\":\"subject\"},{\"id\":\"column_2\",\"name\":\"priority\",\"label\":\"Priority\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_3\",\"datalist_type\":\"column\",\"name\":\"status\",\"label\":\"ISR Status\",\"sortable\":\"true\",\"renderHtml\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"formatting\":\"b\",\"size\":\"\",\"color\":\"\",\"formDefId\":\"\",\"field\":\"\"}}},{\"id\":\"column_6\",\"name\":\"requester_name\",\"label\":\"Request By\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_4\",\"name\":\"assignee\",\"label\":\"Assignee\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_5\",\"name\":\"createdDate\",\"label\":\"Request Date\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}]}','2024-04-19 13:40:11','2024-04-19 13:40:11'),
('isr',1,'isr_reopened_requests','ISR Reopened Requests',NULL,'{\"id\":\"isr_reopened_requests\",\"name\":\"ISR Reopened Requests\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"ref_id\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[{\"id\":\"filter_3\",\"name\":\"ref_id\",\"filterParamName\":\"d-810278-fn_ref_id\",\"label\":\"#\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_2\",\"name\":\"subject\",\"label\":\"Subject\"},{\"id\":\"filter_1\",\"name\":\"status\",\"filterParamName\":\"d-3819911-fn_status\",\"label\":\"ISR Status\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_0\",\"name\":\"requester_name\",\"label\":\"Requested By\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"isr_new_request\",\"joins\":[],\"filters\":[{\"join\":\"AND\",\"field\":\"status\",\"operator\":\"=\",\"value\":\"Reopened\"}],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_0\",\"label\":\"Ref Id\",\"name\":\"ref_id\"},{\"id\":\"column_1\",\"label\":\"Subject\",\"name\":\"subject\"},{\"id\":\"column_5\",\"name\":\"priority\",\"label\":\"Priority\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_2\",\"datalist_type\":\"column\",\"name\":\"status\",\"label\":\"ISR Status\",\"sortable\":\"true\",\"renderHtml\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"formatting\":\"b\",\"size\":\"\",\"color\":\"\",\"formDefId\":\"\",\"field\":\"\"}}},{\"id\":\"column_3\",\"label\":\"Requested By\",\"name\":\"requester_name\"},{\"id\":\"column_4\",\"label\":\"Requested Date\",\"name\":\"createdDate\"}]}','2024-04-19 13:40:11','2024-04-19 13:40:11'),
('isr',1,'isr_resolved_requests','ISR Resolved Requests',NULL,'{\"id\":\"isr_resolved_requests\",\"name\":\"ISR Resolved Requests\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"ref_id\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[{\"id\":\"filter_3\",\"name\":\"ref_id\",\"filterParamName\":\"d-6707878-fn_ref_id\",\"label\":\"#\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_2\",\"name\":\"subject\",\"label\":\"Subject\"},{\"id\":\"filter_1\",\"name\":\"status\",\"filterParamName\":\"d-3819911-fn_status\",\"label\":\"ISR Status\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_0\",\"name\":\"requester_name\",\"label\":\"Requested By\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"isr_new_request\",\"joins\":[],\"filters\":[{\"join\":\"AND\",\"field\":\"status\",\"operator\":\"=\",\"value\":\"Resolved\"}],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_0\",\"label\":\"Ref Id\",\"name\":\"ref_id\"},{\"id\":\"column_1\",\"label\":\"Subject\",\"name\":\"subject\"},{\"id\":\"column_7\",\"name\":\"priority\",\"label\":\"Priority\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_2\",\"datalist_type\":\"column\",\"name\":\"status\",\"label\":\"ISR Status\",\"sortable\":\"true\",\"renderHtml\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"formatting\":\"b\",\"size\":\"\",\"color\":\"\",\"formDefId\":\"\",\"field\":\"\"}}},{\"id\":\"column_3\",\"name\":\"requester_name\",\"label\":\"Request By\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_4\",\"name\":\"createdDate\",\"label\":\"Request Date\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}]}','2024-04-19 13:40:11','2024-04-19 13:40:11'),
('isr',1,'isr_verified_requests','ISR Verified Requests',NULL,'{\"id\":\"isr_verified_requests\",\"name\":\"ISR Verified Requests\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"ref_id\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[{\"id\":\"filter_3\",\"name\":\"ref_id\",\"filterParamName\":\"d-8059354-fn_ref_id\",\"label\":\"#\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_2\",\"name\":\"subject\",\"label\":\"Subject\"},{\"id\":\"filter_1\",\"name\":\"status\",\"filterParamName\":\"d-3819911-fn_status\",\"label\":\"ISR Status\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}}},{\"id\":\"filter_0\",\"name\":\"requester_name\",\"label\":\"Requested By\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"isr_new_request\",\"joins\":[],\"filters\":[{\"join\":\"AND\",\"field\":\"status\",\"operator\":\"=\",\"value\":\"Verified\"}],\"extraCondition\":\"\",\"aggregateField\":[],\"groupBy\":\"\",\"having\":[]}},\"columns\":[{\"id\":\"column_0\",\"name\":\"ref_id\",\"label\":\"#\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"label\":\"Subject\",\"name\":\"subject\"},{\"id\":\"column_2\",\"name\":\"priority\",\"label\":\"Priority\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_3\",\"datalist_type\":\"column\",\"name\":\"status\",\"label\":\"ISR Status\",\"sortable\":\"true\",\"renderHtml\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignCenter\",\"headerAlignment\":\"dataListAlignCenter\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"formatting\":\"b\",\"size\":\"\",\"color\":\"\",\"formDefId\":\"\",\"field\":\"\"}}},{\"id\":\"column_4\",\"name\":\"requester_name\",\"label\":\"Request By\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_5\",\"name\":\"assignee\",\"label\":\"Assignee\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_6\",\"name\":\"createdDate\",\"label\":\"Request Date\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}]}','2024-04-19 13:40:12','2024-04-19 13:40:12'),
('JogetDxShowcase',1,'appIcon','Template - App Icon',NULL,'{\"id\":\"appIcon\",\"name\":\"Template - App Icon\",\"pageSize\":\"0\",\"pageSizeSelectorOptions\":\"10\",\"order\":\"\",\"orderBy\":\"\",\"description\":\"\",\"actions\":[],\"rowActions\":[{\"id\":\"rowAction_0\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"properties\":{\"label\":\"<i class=\\\"fas fa-pen\\\"><\\/i> \",\"target\":\"_blank\",\"link-css-display-type\":\"btn btn-sm btn-primary\",\"href\":\"#request.baseURL#\\/web\\/console\\/app\",\"hrefParam\":\";;\",\"hrefColumn\":\"apps.id;apps.version;builders\",\"confirmation\":\"\",\"datalist_type\":\"row_action\",\"rules\":[],\"header_label\":\"\",\"style-border-radius\":\"50%\",\"style-width\":\"30px\",\"style-height\":\"30px\",\"style-position\":\"absolute\",\"style-right\":\"15px\",\"style-top\":\"55px\",\"style-custom\":\"transition: 0.2s display ease-in-out;\\nbox-sizing: border-box;\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{}},\"style-padding-top\":\"8px\",\"style-padding-left\":\"8px\",\"style-padding-right\":\"8px\"},\"hidden\":\"true\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{\"hidden\":\"\"}}}],\"filters\":[],\"binder\":{\"className\":\"org.joget.apps.datalist.lib.JsonApiDatalistBinder\",\"properties\":{\"jsonUrl\":\"#request.baseURL#\\/web\\/json\\/apps\\/published\\/userviews?appCenter=true\",\"requestType\":\"\",\"headers\":[],\"copyCookies\":\"true\",\"multirowBaseObject\":\"apps.userviews\",\"totalRowCountObject\":\"\",\"primaryKey\":\"id\",\"handlePaging\":\"true\",\"debugMode\":\"\"}},\"columns\":[{\"id\":\"column_1\",\"name\":\"name\",\"label\":\"name\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"true\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}},\"style-custom\":\"font-weight: 700;\\nfont-size: 13px;\\nword-wrap: break-word;\\npadding: 0 5px;\\nheight: 39px;\\noverflow: hidden;\\nmargin-bottom: 3px;\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{\"hidden\":\"false\",\"include_export\":\"\",\"exclude_export\":\"true\"}},\"include_export\":\"\"}],\"hidePageSize\":\"true\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"considerFilterWhenGetTotal\":\"\",\"searchPopup\":\"\",\"disableResponsive\":\"\",\"card-style-border-width\":\"0px\",\"card-style-text-align\":\"center\",\"card-style-custom\":\"opacity:0.9;\",\"rowAction_card\":[{\"id\":\"rowAction_1\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"properties\":{\"href\":\"#request.baseURL#\\/web\\/userview\\/\",\"target\":\"_blank\",\"hrefParam\":\";\",\"hrefColumn\":\"apps.id;id\",\"label\":\"Hyperlink\",\"confirmation\":\"\",\"visible\":\"\",\"datalist_type\":\"row_action\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{}}}}],\"card-style-hover-custom\":\"opacity:1;\",\"permission_rules\":[{\"permission_key\":\"9D3F667778064DF2976BDBE2C629EA8D\",\"permission_name\":\"Is Admin\",\"permission\":{\"className\":\"org.joget.plugin.enterprise.AdminUserviewPermission\",\"properties\":{}}}],\"card-style-mobile-width\":\"50%\",\"card-style-max-width\":\"120px\",\"rowActionsMode\":\"\",\"template\":{\"className\":\"org.joget.apps.datalist.lib.AppIconTemplate\",\"properties\":{\"columns_mobile\":\"col-6\",\"columns_tablet\":\"col-md-6\",\"columns_desktop\":\"col-lg-3\"}},\"column_image\":[{\"id\":\"column_0\",\"name\":\"imageUrl\",\"label\":\"imageUrl\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"true\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.ImageFormatter\",\"properties\":{\"imageSrc\":\"\",\"imagefullsize\":\"\",\"height\":\"70px\",\"width\":\"70px\",\"defaultImage\":\"#request.baseURL#\\/web\\/userview\\/screenshot\\/appcenter\\/v\"}},\"style-margin-bottom\":\"3px\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{\"hidden\":\"false\",\"include_export\":\"\",\"exclude_export\":\"true\"}},\"style-border-color\":\"rgba(255, 255, 255, 0.55)\",\"style-border-top-width\":\"4px\",\"style-border-left-width\":\"4px\",\"style-border-right-width\":\"4px\",\"style-border-bottom-width\":\"4px\",\"style-border-radius\":\"50%\",\"style-border-style\":\"solid\",\"include_export\":\"\"}],\"card-style-padding-top\":\"15px\",\"card-style-padding-left\":\"0px\",\"card-style-padding-right\":\"0px\",\"card-style-padding-bottom\":\"0px\",\"responsiveMode\":\"\"}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'candleStick','Candlestick Data',NULL,'{\"id\":\"candleStick\",\"name\":\"Candlestick Data\",\"pageSize\":\"100\",\"order\":\"\",\"orderBy\":\"\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"false\",\"considerFilterWhenGetTotal\":\"\",\"rowActions\":[],\"description\":\"\",\"filters\":[],\"actions\":[],\"hidePageSize\":\"true\",\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"candleStick\"}},\"columns\":[{\"hidden\":\"false\",\"name\":\"Date\",\"width\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"action\":{\"className\":\"\",\"properties\":{}},\"style\":\"text-align: center;\",\"id\":\"column_1\",\"label\":\"Date\",\"sortable\":\"false\",\"exclude_export\":\"\"},{\"hidden\":\"false\",\"name\":\"StockCode\",\"width\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"action\":{\"className\":\"\",\"properties\":{}},\"style\":\"text-align: center;\",\"id\":\"column_2\",\"label\":\"Stock Code\",\"sortable\":\"false\",\"exclude_export\":\"\"},{\"hidden\":\"false\",\"name\":\"Open\",\"width\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"action\":{\"className\":\"\",\"properties\":{}},\"style\":\"text-align: center;\",\"id\":\"column_5\",\"label\":\"Opening Price $\",\"sortable\":\"false\",\"exclude_export\":\"\"},{\"hidden\":\"false\",\"name\":\"Highest\",\"width\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"action\":{\"className\":\"\",\"properties\":{}},\"style\":\"text-align: center;\",\"id\":\"column_3\",\"label\":\"Highest Price $\",\"sortable\":\"false\",\"exclude_export\":\"\"},{\"hidden\":\"false\",\"name\":\"Lowest\",\"width\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"action\":{\"className\":\"\",\"properties\":{}},\"style\":\"text-align: center;\",\"id\":\"column_4\",\"label\":\"Lowest Price $\",\"sortable\":\"false\",\"exclude_export\":\"\"},{\"hidden\":\"false\",\"name\":\"Closing\",\"width\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"action\":{\"className\":\"\",\"properties\":{}},\"style\":\"text-align: center;\",\"id\":\"column_0\",\"label\":\"Closing Price $\",\"sortable\":\"false\",\"exclude_export\":\"\"}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'chartData','Chart Data',NULL,'{\"rowActions\":[],\"columns\":[{\"name\":\"parameter1\",\"id\":\"column_1\",\"label\":\"Parameter 1\",\"datalist_type\":\"column\",\"sortable\":\"false\",\"renderHtml\":\"\",\"hidden\":\"true\",\"include_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"name\":\"parameter2\",\"id\":\"column_2\",\"label\":\"Name\",\"datalist_type\":\"column\",\"sortable\":\"false\",\"renderHtml\":\"\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"hidden\":\"false\",\"name\":\"value\",\"width\":\"\",\"format\":{\"className\":\"\",\"properties\":{}},\"action\":{\"className\":\"\",\"properties\":{}},\"style\":\"\",\"id\":\"column_0\",\"label\":\"Value\",\"sortable\":\"false\",\"exclude_export\":\"\",\"datalist_type\":\"column\"},{\"name\":\"parameter3\",\"id\":\"column_3\",\"label\":\"Value 2\",\"datalist_type\":\"column\",\"sortable\":\"false\",\"renderHtml\":\"\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}],\"name\":\"Chart Data\",\"pageSize\":\"100\",\"orderBy\":\"parameter1\",\"description\":\"\",\"id\":\"chartData\",\"filters\":[{\"name\":\"parameter1\",\"id\":\"filter_0\",\"label\":\"Parameter 1\",\"filterParamName\":\"d-3582458-fn_parameter1\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"chartData\"}},\"actions\":[],\"hidePageSize\":\"true\",\"order\":\"2\",\"template\":{\"className\":\"\",\"properties\":{}}}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'classic','Template - Classic Table',NULL,'{\"id\":\"columnslist\",\"name\":\"Template - Classic Table\",\"pageSize\":\"0\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"order\":\"\",\"orderBy\":\"\",\"description\":\"\",\"actions\":[],\"rowActions\":[{\"id\":\"rowAction_0\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"properties\":{\"label\":\"<i class=\\\"fas fa-pen\\\"><\\/i> Edit App\",\"target\":\"_blank\",\"link-css-display-type\":\"btn btn-link\",\"href\":\"#request.baseURL#\\/web\\/console\\/app\",\"hrefParam\":\";;\",\"hrefColumn\":\"apps.id;apps.version;builders\",\"confirmation\":\"\",\"datalist_type\":\"row_action\",\"rules\":[],\"header_label\":\"\",\"style-custom\":\"transition: 0.2s display ease-in-out;\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{}}},\"hidden\":\"true\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{\"hidden\":\"\"}}}],\"filters\":[],\"binder\":{\"className\":\"org.joget.apps.datalist.lib.JsonApiDatalistBinder\",\"properties\":{\"jsonUrl\":\"#request.baseURL#\\/web\\/json\\/apps\\/published\\/userviews?appCenter=true\",\"requestType\":\"\",\"headers\":[],\"copyCookies\":\"true\",\"multirowBaseObject\":\"apps.userviews\",\"totalRowCountObject\":\"\",\"primaryKey\":\"id\",\"handlePaging\":\"true\",\"debugMode\":\"\"}},\"columns\":[{\"id\":\"column_0\",\"name\":\"name\",\"label\":\"Name\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_2\",\"name\":\"apps.id\",\"label\":\"App Id\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"name\":\"apps.version\",\"label\":\"App Version\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}],\"hidePageSize\":\"true\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"considerFilterWhenGetTotal\":\"\",\"searchPopup\":\"\",\"disableResponsive\":\"\",\"card-style-border-width\":\"0px\",\"permission_rules\":[{\"permission_key\":\"9D3F667778064DF2976BDBE2C629EA8D\",\"permission_name\":\"Is Admin\",\"permission\":{\"className\":\"org.joget.plugin.enterprise.AdminUserviewPermission\",\"properties\":{}}}],\"card-style-mobile-width\":\"50%\",\"rowActionsMode\":\"\",\"template\":{\"className\":\"\",\"properties\":{}},\"card-style-padding-left\":\"0px\",\"card-style-padding-right\":\"0px\",\"card-style-padding-bottom\":\"0px\",\"responsiveMode\":\"\",\"card-style-background-color\":\"#E2E2E2\",\"card-style-border-style\":\"solid\",\"card-style-border-color\":\"#BEBEBE\",\"card-style-border-top-width\":\"1px\",\"card-style-border-left-width\":\"1px\",\"card-style-border-right-width\":\"1px\",\"card-style-border-bottom-width\":\"1px\",\"card-style-border-radius\":\"5px\"}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'columnslist','Template - Columns',NULL,'{\"id\":\"columnslist\",\"name\":\"Template - Columns\",\"pageSize\":\"0\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"order\":\"\",\"orderBy\":\"\",\"description\":\"\",\"actions\":[],\"rowActions\":[{\"id\":\"rowAction_0\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"properties\":{\"label\":\"<i class=\\\"fas fa-pen\\\"><\\/i> Edit App\",\"target\":\"_blank\",\"link-css-display-type\":\"btn btn-link\",\"href\":\"#request.baseURL#\\/web\\/console\\/app\",\"hrefParam\":\";;\",\"hrefColumn\":\"apps.id;apps.version;builders\",\"confirmation\":\"\",\"datalist_type\":\"row_action\",\"rules\":[],\"header_label\":\"\",\"style-custom\":\"transition: 0.2s display ease-in-out;\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{}}},\"hidden\":\"true\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{\"hidden\":\"\"}}}],\"filters\":[],\"binder\":{\"className\":\"org.joget.apps.datalist.lib.JsonApiDatalistBinder\",\"properties\":{\"jsonUrl\":\"#request.baseURL#\\/web\\/json\\/apps\\/published\\/userviews?appCenter=true\",\"requestType\":\"\",\"headers\":[],\"copyCookies\":\"true\",\"multirowBaseObject\":\"apps.userviews\",\"totalRowCountObject\":\"\",\"primaryKey\":\"id\",\"handlePaging\":\"true\",\"debugMode\":\"\"}},\"columns\":[{\"id\":\"column_0\",\"name\":\"name\",\"label\":\"Name\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_2\",\"name\":\"apps.id\",\"label\":\"App Id\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"name\":\"apps.version\",\"label\":\"App Version\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}],\"hidePageSize\":\"true\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"considerFilterWhenGetTotal\":\"\",\"searchPopup\":\"\",\"disableResponsive\":\"\",\"card-style-border-width\":\"0px\",\"permission_rules\":[{\"permission_key\":\"9D3F667778064DF2976BDBE2C629EA8D\",\"permission_name\":\"Is Admin\",\"permission\":{\"className\":\"org.joget.plugin.enterprise.AdminUserviewPermission\",\"properties\":{}}}],\"card-style-mobile-width\":\"50%\",\"rowActionsMode\":\"\",\"template\":{\"className\":\"org.joget.plugin.enterprise.ColumnDataListTemplate\",\"properties\":{}},\"card-style-padding-left\":\"0px\",\"card-style-padding-right\":\"0px\",\"card-style-padding-bottom\":\"0px\",\"responsiveMode\":\"\",\"card-style-background-color\":\"#E2E2E2\",\"card-style-border-style\":\"solid\",\"card-style-border-color\":\"#BEBEBE\",\"card-style-border-top-width\":\"1px\",\"card-style-border-left-width\":\"1px\",\"card-style-border-right-width\":\"1px\",\"card-style-border-bottom-width\":\"1px\",\"card-style-border-radius\":\"5px\"}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'dashboardInbox','Dashboard Approver Inbox',NULL,'{\"id\":\"dashboardInbox\",\"name\":\"Dashboard Approver Inbox\",\"pageSize\":\"50\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"rowActions\":[],\"description\":\"\",\"filters\":[{\"hidden\":\"\",\"name\":\"rcounter\",\"id\":\"filter_1\",\"label\":\"Counter\",\"datalist_type\":\"filter\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}},\"filterParamName\":\"d-1545391-fn_rcounter\"}],\"showDataWhenFilterSet\":\"\",\"hidePageSize\":\"\",\"actions\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"processRequest\"}},\"columns\":[{\"hidden\":\"false\",\"format\":{\"className\":\"\",\"properties\":{}},\"label\":\"Counter\",\"sortable\":\"true\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"name\":\"rcounter\",\"width\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"style\":\"\",\"id\":\"column_4\",\"alignment\":\"\"}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'list_calendarMeeting','List - Calendar - Meeting',NULL,'{\"id\":\"list_calendarMeeting\",\"name\":\"List - Calendar - Meeting\",\"pageSize\":\"100\",\"order\":\"2\",\"orderBy\":\"date\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[{\"name\":\"Data List Hyperlink Action\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"type\":\"text\",\"id\":\"action_0\",\"properties\":{\"href\":\"cv\",\"target\":\"_self\",\"label\":\"View Calendar\",\"confirmation\":\"\",\"visible\":\"\",\"datalist_type\":\"action\",\"hrefParam\":\"\",\"hrefColumn\":\"\"}}],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"calendarMeeting\"}},\"columns\":[{\"id\":\"column_0\",\"label\":\"Date\",\"name\":\"date\"},{\"id\":\"column_2\",\"label\":\"Meeting Name\",\"name\":\"name\"}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'list_featureAdvancedGrid','List - Feature - Advanced Grid',NULL,'{\"id\":\"list_featureAdvancedGrid\",\"name\":\"List - Feature - Advanced Grid\",\"hidePageSize\":\"\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"pageSize\":\"0\",\"order\":\"2\",\"orderBy\":\"dateCreated\",\"description\":\"\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"considerFilterWhenGetTotal\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"featureAdvancedGrid\"}},\"columns\":[{\"id\":\"column_0\",\"label\":\"ID\",\"name\":\"id\"}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'list_featureDateTime','List - Feature - DateTime',NULL,'{\"id\":\"list_featureDateTime\",\"name\":\"List - Feature - DateTime\",\"pageSize\":\"50\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[{\"id\":\"filter_0\",\"name\":\"date1\",\"label\":\"Date\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{}}}],\"disableResponsive\":\"\",\"searchPopup\":\"\",\"responsiveView\":[{\"view\":\"Mobile\",\"breakpoint\":\"\",\"columns\":\"\"},{\"view\":\"Tablet\",\"breakpoint\":\"\",\"columns\":\"\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"featureDateTime\"}},\"columns\":[{\"id\":\"column_0\",\"label\":\"Date\",\"name\":\"date1\",\"hidden\":\"false\",\"sortable\":\"false\"},{\"id\":\"column_1\",\"label\":\"Date & Time\",\"name\":\"date2\",\"hidden\":\"false\",\"sortable\":\"false\"},{\"id\":\"column_2\",\"label\":\"Time\",\"name\":\"date3\",\"hidden\":\"false\",\"sortable\":\"false\"}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'list_featureFormGrid','List - Feature - Form Grid',NULL,'{\"id\":\"list_featureFormGrid\",\"name\":\"List - Feature - Form Grid\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"disableResponsive\":\"\",\"searchPopup\":\"\",\"responsiveView\":[{\"view\":\"Mobile\",\"breakpoint\":\"\",\"columns\":\"\"},{\"view\":\"Tablet\",\"breakpoint\":\"\",\"columns\":\"\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"featureFormGrid\"}},\"columns\":[{\"id\":\"column_0\",\"label\":\"ID\",\"name\":\"id\"}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'list_featureListGrid','List - Feature - List Grid',NULL,'{\"id\":\"list_featureListGrid\",\"name\":\"List - Feature - List Grid\",\"hidePageSize\":\"\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"pageSize\":\"0\",\"order\":\"2\",\"orderBy\":\"dateCreated\",\"description\":\"\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"considerFilterWhenGetTotal\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"featureListGrid\"}},\"columns\":[{\"id\":\"column_0\",\"label\":\"ID\",\"name\":\"id\"}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'list_featureMiscField','List - Feature - Misc Field',NULL,'{\"id\":\"list_featureMiscField\",\"name\":\"List - Feature - Misc Field\",\"hidePageSize\":\"\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"pageSize\":\"0\",\"order\":\"2\",\"orderBy\":\"dateCreated\",\"description\":\"\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"considerFilterWhenGetTotal\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"featureMiscField\"}},\"columns\":[{\"id\":\"column_0\",\"label\":\"Rich Text Editor\",\"displayLabel\":\"Rich Text Editor\",\"name\":\"richTextEditor\"}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'list_featureSelectField','List - Feature - Select Fields',NULL,'{\"id\":\"list_featureSelectField\",\"name\":\"List - Feature - Select Fields\",\"hidePageSize\":\"\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"pageSize\":\"0\",\"order\":\"2\",\"orderBy\":\"dateCreated\",\"description\":\"\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"considerFilterWhenGetTotal\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"featureSelectField\"}},\"columns\":[{\"id\":\"column_0\",\"datalist_type\":\"column\",\"name\":\"checkBox\",\"label\":\"Check Box\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[],\"optionsBinder\":{\"className\":\"org.joget.plugin.enterprise.DepartmentOptionsBinder\",\"properties\":{\"orgId\":\"\",\"addEmptyOption\":\"\",\"emptyLabel\":\"\",\"cacheInterval\":\"\",\"cacheIdlePause\":\"120\"}}}}},{\"id\":\"column_2\",\"datalist_type\":\"column\",\"name\":\"multiSelectBox\",\"label\":\"Multi Select Box\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[],\"optionsBinder\":{\"className\":\"org.joget.plugin.enterprise.GroupOptionsBinder\",\"properties\":{\"orgId\":\"\",\"addEmptyOption\":\"\",\"emptyLabel\":\"\",\"cacheInterval\":\"\",\"cacheIdlePause\":\"120\"}}}}},{\"id\":\"column_4\",\"datalist_type\":\"column\",\"name\":\"radio\",\"label\":\"Radio\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.plugin.enterprise.OptionsValueFormatter\",\"properties\":{\"options\":[],\"optionsBinder\":{\"className\":\"org.joget.plugin.enterprise.GradeOptionsBinder\",\"properties\":{\"orgId\":\"\",\"addEmptyOption\":\"\",\"emptyLabel\":\"\",\"cacheInterval\":\"\",\"cacheIdlePause\":\"120\"}}}}}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'list_featureSpreadsheet','List - Feature - Spreadsheet',NULL,'{\"id\":\"list_featureSpreadsheet\",\"name\":\"List - Feature - Spreadsheet\",\"pageSize\":\"0\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"disableResponsive\":\"\",\"searchPopup\":\"\",\"responsiveView\":[{\"view\":\"移动端\",\"breakpoint\":\"\",\"columns\":\"\"},{\"view\":\"平板\",\"breakpoint\":\"\",\"columns\":\"\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"featureSpreadsheet\"}},\"columns\":[{\"id\":\"column_0\",\"label\":\"ID\",\"name\":\"id\"}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'list_featureStdField','List - Feature - Standard Fields',NULL,'{\"id\":\"list_featureStdField\",\"name\":\"List - Feature - Standard Fields\",\"pageSize\":\"50\",\"order\":\"2\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[{\"id\":\"filter_3\",\"name\":\"textField\",\"label\":\"TextField\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{}}},{\"id\":\"filter_0\",\"name\":\"textArea\",\"label\":\"TextArea\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{}}}],\"disableResponsive\":\"\",\"searchPopup\":\"\",\"responsiveView\":[{\"view\":\"Mobile\",\"breakpoint\":\"\",\"columns\":\"\"},{\"view\":\"Tablet\",\"breakpoint\":\"\",\"columns\":\"\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"featureStdField\"}},\"columns\":[{\"id\":\"column_1\",\"label\":\"TextField\",\"displayLabel\":\"TextField\",\"name\":\"textField\"},{\"id\":\"column_0\",\"label\":\"TextArea\",\"displayLabel\":\"TextArea\",\"name\":\"textArea\"},{\"id\":\"column_2\",\"label\":\"Numeric1\",\"name\":\"numeric1\",\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignRight\",\"headerAlignment\":\"dataListAlignRight\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_3\",\"label\":\"Numeric2\",\"name\":\"numeric2\",\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignRight\",\"headerAlignment\":\"dataListAlignRight\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_4\",\"label\":\"Total\",\"name\":\"calculation\",\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignRight\",\"headerAlignment\":\"dataListAlignRight\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'list_featureUploadField','List - Feature - Upload Fields',NULL,'{\"id\":\"list_featureUploadField\",\"name\":\"List - Feature - Upload Fields\",\"pageSize\":\"50\",\"order\":\"2\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"disableResponsive\":\"\",\"searchPopup\":\"\",\"responsiveView\":[{\"view\":\"Mobile\",\"breakpoint\":\"\",\"columns\":\"\"},{\"view\":\"Tablet\",\"breakpoint\":\"\",\"columns\":\"\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"featureUploadField\"}},\"columns\":[{\"id\":\"column_0\",\"datalist_type\":\"column\",\"name\":\"fileUpload\",\"label\":\"File Upload\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_1\",\"label\":\"Image Upload\",\"name\":\"imageUpload\",\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'list_processRequest','List - Process - Request',NULL,'{\"id\":\"list_processRequest\",\"name\":\"List - Process - Request\",\"pageSize\":\"50\",\"order\":\"1\",\"orderBy\":\"dateCreated\",\"showPageSizeSelector\":\"true\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"buttonPosition\":\"bottomLeft\",\"checkboxPosition\":\"left\",\"useSession\":\"\",\"considerFilterWhenGetTotal\":\"\",\"hidePageSize\":\"\",\"description\":\"\",\"showDataWhenFilterSet\":\"\",\"rowActions\":[],\"actions\":[{\"name\":\"Data List Hyperlink Action\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"type\":\"text\",\"id\":\"action_0\",\"properties\":{\"href\":\"submitRequest\",\"target\":\"_self\",\"label\":\"#i18n.Submit a new reques label#\",\"confirmation\":\"\",\"visible\":\"true\",\"datalist_type\":\"action\",\"hrefParam\":\"\",\"hrefColumn\":\"\"}}],\"filters\":[{\"id\":\"filter_1\",\"datalist_type\":\"filter\",\"name\":\"rcounter\",\"filterParamName\":\"d-1545391-fn_rcounter\",\"label\":\"Counter\",\"type\":{\"className\":\"org.joget.apps.datalist.lib.TextFieldDataListFilterType\",\"properties\":{\"defaultValue\":\"\"}},\"hidden\":\"\"}],\"binder\":{\"className\":\"org.joget.plugin.enterprise.AdvancedFormRowDataListBinder\",\"properties\":{\"formDefId\":\"processRequest\"}},\"columns\":[{\"id\":\"column_4\",\"datalist_type\":\"column\",\"name\":\"rcounter\",\"label\":\"Counter\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_3\",\"datalist_type\":\"column\",\"name\":\"approverUsername1\",\"label\":\"Approver 1\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignRight\",\"headerAlignment\":\"dataListAlignRight\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_0\",\"datalist_type\":\"column\",\"name\":\"approvalStatus1\",\"label\":\"Status\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"formatting\":\"b\",\"size\":\"\",\"color\":\"\",\"formDefId\":\"\",\"field\":\"\"}}},{\"id\":\"column_7\",\"datalist_type\":\"column\",\"name\":\"approverUsername2\",\"label\":\"Approver 2\",\"sortable\":\"false\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"dataListAlignRight\",\"headerAlignment\":\"dataListAlignRight\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_6\",\"datalist_type\":\"column\",\"name\":\"approvalStatus2\",\"label\":\"Status\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.DefaultFormatter\",\"properties\":{\"formatting\":\"b\",\"size\":\"\",\"color\":\"\",\"formDefId\":\"\",\"field\":\"\"}}},{\"id\":\"column_5\",\"datalist_type\":\"column\",\"name\":\"id\",\"label\":\"Process\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.plugin.enterprise.ProcessStatusDatalistFormatter\",\"properties\":{\"showProcessName\":\"true\",\"showFutureActivities\":\"true\",\"showSkippedActivities\":\"true\",\"usernameFormat\":\"name\",\"eventClick\":\"\"}}},{\"id\":\"column_1\",\"datalist_type\":\"column\",\"name\":\"dateCreated\",\"label\":\"Created\",\"sortable\":\"true\",\"hidden\":\"false\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'simplecard','Template - Simple Card',NULL,'{\"id\":\"simplecard\",\"name\":\"Template - Simple Card\",\"pageSize\":\"0\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"order\":\"\",\"orderBy\":\"\",\"description\":\"\",\"actions\":[],\"rowActions\":[{\"id\":\"rowAction_0\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"properties\":{\"label\":\"<i class=\\\"fas fa-pen\\\"><\\/i> \",\"target\":\"_blank\",\"link-css-display-type\":\"btn btn-sm btn-primary\",\"href\":\"#request.baseURL#\\/web\\/console\\/app\",\"hrefParam\":\";;\",\"hrefColumn\":\"apps.id;apps.version;builders\",\"confirmation\":\"\",\"datalist_type\":\"row_action\",\"rules\":[],\"header_label\":\"\",\"style-custom\":\"transition: 0.2s display ease-in-out;\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{}}},\"hidden\":\"true\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{\"hidden\":\"\"}}}],\"filters\":[],\"binder\":{\"className\":\"org.joget.apps.datalist.lib.JsonApiDatalistBinder\",\"properties\":{\"jsonUrl\":\"#request.baseURL#\\/web\\/json\\/apps\\/published\\/userviews?appCenter=true\",\"requestType\":\"\",\"headers\":[],\"copyCookies\":\"true\",\"multirowBaseObject\":\"apps.userviews\",\"totalRowCountObject\":\"\",\"primaryKey\":\"id\",\"handlePaging\":\"true\",\"debugMode\":\"\"}},\"columns\":[{\"id\":\"column_2\",\"name\":\"apps.id\",\"label\":\"App Id\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}},{\"id\":\"column_3\",\"name\":\"apps.version\",\"label\":\"App Version\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}],\"hidePageSize\":\"true\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"considerFilterWhenGetTotal\":\"\",\"searchPopup\":\"\",\"disableResponsive\":\"\",\"card-style-border-width\":\"0px\",\"rowAction_card\":[{\"id\":\"rowAction_1\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"properties\":{\"href\":\"#request.baseURL#\\/web\\/userview\\/\",\"target\":\"_blank\",\"hrefParam\":\";\",\"hrefColumn\":\"apps.id;id\",\"label\":\"Hyperlink\",\"confirmation\":\"\",\"visible\":\"\",\"datalist_type\":\"row_action\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{}}}}],\"permission_rules\":[{\"permission_key\":\"9D3F667778064DF2976BDBE2C629EA8D\",\"permission_name\":\"Is Admin\",\"permission\":{\"className\":\"org.joget.plugin.enterprise.AdminUserviewPermission\",\"properties\":{}}}],\"rowActionsMode\":\"\",\"template\":{\"className\":\"org.joget.apps.datalist.lib.SimpleCardTemplate\",\"properties\":{\"image\":\"true\",\"inlineLabel\":\"true\",\"footerMsg\":\"\",\"cardAction\":\"true\",\"columns_mobile\":\"col-12\",\"columns_tablet\":\"col-md-6\",\"columns_desktop\":\"col-lg-3\"}},\"column_image\":[{\"id\":\"column_0\",\"name\":\"imageUrl\",\"label\":\"imageUrl\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"true\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.ImageFormatter\",\"properties\":{\"imageSrc\":\"\",\"imagefullsize\":\"\",\"height\":\"300px\",\"width\":\"100%\",\"defaultImage\":\"#request.baseURL#\\/web\\/userview\\/screenshot\\/appcenter\\/v\"}},\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{\"hidden\":\"false\",\"include_export\":\"\",\"exclude_export\":\"true\"}},\"include_export\":\"\",\"style-padding-bottom\":\"98%\",\"style-height\":\"0px\",\"style-margin-top\":\"5px\",\"style-margin-left\":\"auto\",\"style-margin-right\":\"auto\",\"style-margin-bottom\":\"5px\",\"style-custom\":\"box-sizing:border-box;\",\"style-width\":\"98%\"}],\"card-style-padding-left\":\"0px\",\"card-style-padding-right\":\"0px\",\"card-style-padding-bottom\":\"0px\",\"responsiveMode\":\"\",\"column_title\":[{\"id\":\"column_1\",\"name\":\"name\",\"label\":\"name\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"true\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}},\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{\"hidden\":\"false\",\"include_export\":\"\",\"exclude_export\":\"true\"}},\"include_export\":\"\"}],\"card-style-background-color\":\"#E2E2E2\",\"card-style-border-style\":\"solid\",\"card-style-border-color\":\"#BEBEBE\",\"card-style-border-top-width\":\"1px\",\"card-style-border-left-width\":\"1px\",\"card-style-border-right-width\":\"1px\",\"card-style-border-bottom-width\":\"1px\",\"card-style-border-radius\":\"5px\"}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'simplelist','Template - Simple List',NULL,'{\"id\":\"simplelist\",\"name\":\"Template - Simple List\",\"pageSize\":\"0\",\"pageSizeSelectorOptions\":\"10,20,30,40,50,100\",\"order\":\"\",\"orderBy\":\"\",\"description\":\"\",\"actions\":[],\"rowActions\":[{\"id\":\"rowAction_0\",\"className\":\"org.joget.apps.datalist.lib.HyperlinkDataListAction\",\"label\":\"Hyperlink\",\"properties\":{\"label\":\"<i class=\\\"fas fa-pen\\\"><\\/i> Edit App\",\"target\":\"_blank\",\"link-css-display-type\":\"btn btn-link\",\"href\":\"#request.baseURL#\\/web\\/console\\/app\",\"hrefParam\":\";;\",\"hrefColumn\":\"apps.id;apps.version;builders\",\"confirmation\":\"\",\"datalist_type\":\"row_action\",\"rules\":[],\"header_label\":\"\",\"style-custom\":\"transition: 0.2s display ease-in-out;\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{}}},\"hidden\":\"true\",\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{\"hidden\":\"\"}}}],\"filters\":[],\"binder\":{\"className\":\"org.joget.apps.datalist.lib.JsonApiDatalistBinder\",\"properties\":{\"jsonUrl\":\"#request.baseURL#\\/web\\/json\\/apps\\/published\\/userviews?appCenter=true\",\"requestType\":\"\",\"headers\":[],\"copyCookies\":\"true\",\"multirowBaseObject\":\"apps.userviews\",\"totalRowCountObject\":\"\",\"primaryKey\":\"id\",\"handlePaging\":\"true\",\"debugMode\":\"\"}},\"columns\":[{\"id\":\"column_2\",\"name\":\"apps.id\",\"label\":\"App Id\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}],\"hidePageSize\":\"true\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"considerFilterWhenGetTotal\":\"\",\"searchPopup\":\"\",\"disableResponsive\":\"\",\"card-style-border-width\":\"0px\",\"permission_rules\":[{\"permission_key\":\"9D3F667778064DF2976BDBE2C629EA8D\",\"permission_name\":\"Is Admin\",\"permission\":{\"className\":\"org.joget.plugin.enterprise.AdminUserviewPermission\",\"properties\":{}}}],\"card-style-mobile-width\":\"50%\",\"rowActionsMode\":\"\",\"template\":{\"className\":\"org.joget.plugin.enterprise.SimpleListTemplate\",\"properties\":{\"actionsStyle\":\"swipeActions\"}},\"card-style-padding-left\":\"0px\",\"card-style-padding-right\":\"0px\",\"card-style-padding-bottom\":\"0px\",\"responsiveMode\":\"\",\"column_title\":[{\"id\":\"column_1\",\"name\":\"name\",\"label\":\"name\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"true\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}},\"permission_rules\":{\"9D3F667778064DF2976BDBE2C629EA8D\":{\"hidden\":\"false\",\"include_export\":\"\",\"exclude_export\":\"true\"}},\"include_export\":\"\"}],\"card-style-background-color\":\"#E2E2E2\",\"card-style-border-style\":\"solid\",\"card-style-border-color\":\"#BEBEBE\",\"card-style-border-top-width\":\"1px\",\"card-style-border-left-width\":\"1px\",\"card-style-border-right-width\":\"1px\",\"card-style-border-bottom-width\":\"1px\",\"card-style-border-radius\":\"5px\",\"column_value\":[{\"id\":\"column_3\",\"name\":\"apps.version\",\"label\":\"App Version\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"\",\"properties\":{}}}],\"column_image\":[{\"id\":\"column_0\",\"name\":\"imageUrl\",\"label\":\"imageUrl\",\"filterable\":true,\"hidden\":\"false\",\"sortable\":\"false\",\"datalist_type\":\"column\",\"renderHtml\":\"\",\"exclude_export\":\"\",\"width\":\"\",\"style\":\"\",\"alignment\":\"\",\"headerAlignment\":\"\",\"action\":{\"className\":\"\",\"properties\":{}},\"format\":{\"className\":\"org.joget.apps.datalist.lib.ImageFormatter\",\"properties\":{\"imageSrc\":\"\",\"imagefullsize\":\"\",\"height\":\"70px\",\"width\":\"70px\",\"defaultImage\":\"#request.baseURL#\\/web\\/userview\\/screenshot\\/appcenter\\/v\"}}}]}','2024-04-19 13:40:16','2024-04-19 13:40:16'),
('JogetDxShowcase',1,'userlist','User List',NULL,'{\"id\":\"userlist\",\"name\":\"User List\",\"hidePageSize\":\"true\",\"pageSize\":\"10\",\"order\":\"2\",\"orderBy\":\"firstName\",\"description\":\"\",\"useSession\":\"\",\"showDataWhenFilterSet\":\"\",\"considerFilterWhenGetTotal\":\"\",\"rowActions\":[],\"actions\":[],\"filters\":[],\"binder\":{\"className\":\"org.joget.plugin.enterprise.JogetEntityDatalistBinder\",\"properties\":{\"entity\":\"User\",\"filters\":[],\"extraCondition\":\"\"}},\"columns\":[{\"id\":\"column_0\",\"label\":\"username\",\"displayLabel\":\"username\",\"name\":\"username\"},{\"id\":\"column_1\",\"label\":\"firstName\",\"displayLabel\":\"firstName\",\"name\":\"firstName\"},{\"id\":\"column_2\",\"label\":\"lastName\",\"displayLabel\":\"lastName\",\"name\":\"lastName\"}]}','2024-04-19 13:40:16','2024-04-19 13:40:16');
/*!40000 ALTER TABLE `app_datalist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_env_variable`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_env_variable` (
  `appId` varchar(255) NOT NULL,
  `appVersion` bigint(20) NOT NULL,
  `id` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  PRIMARY KEY (`appId`,`appVersion`,`id`),
  KEY `FK740A62EC462EF4C7` (`appId`,`appVersion`),
  CONSTRAINT `FK740A62EC462EF4C7` FOREIGN KEY (`appId`, `appVersion`) REFERENCES `app_app` (`appId`, `appVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_env_variable`
--

LOCK TABLES `app_env_variable` WRITE;
/*!40000 ALTER TABLE `app_env_variable` DISABLE KEYS */;
INSERT INTO `app_env_variable` VALUES
('crm',1,'AppName','Customer Relationship Management',NULL),
('crm',1,'refNo','1','Used for plugin: Id Generator Field'),
('dashboard',1,'AppName','Employee Portal',NULL),
('expenseclaim',1,'AppName','Expenses Claim',NULL),
('expenseclaim',1,'counter','1','Used for plugin: Id Generator Field'),
('expenseclaim',1,'dateCreatedYearMonth','String jdbcDriver = \"#platform.jdbcDriver#\";\n\nif (jdbcDriver.equalsIgnoreCase(\"com.microsoft.sqlserver.jdbc.SQLServerDriver\")) {\n    return \"CAST(FORMAT(dateCreated, \'yyyy-MM\') as java.lang.String)\";\n} else if(jdbcDriver.equalsIgnoreCase(\"com.mysql.jdbc.Driver\")){\n    return \"DATE_FORMAT(dateCreated,\'%Y-%m\')\";\n} else {\n    return \"TO_CHAR(dateCreated, \'YYYY-MM\')\";\n}',NULL),
('isr',1,'AppName','Internal Service Request',NULL),
('isr',1,'counter','2','Used for plugin: Id Generator Field'),
('JogetDxShowcase',1,'appName','Joget DX Showcase',NULL),
('JogetDxShowcase',1,'ecounter','1','Used for plugin: Id Generator Field'),
('JogetDxShowcase',1,'rcounter','1','Used for plugin: Id Generator Field');
/*!40000 ALTER TABLE `app_env_variable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd`
--

LOCK TABLES `app_fd` WRITE;
/*!40000 ALTER TABLE `app_fd` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_chart_data`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_chart_data` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_parameter3` longtext DEFAULT NULL,
  `c_value` longtext DEFAULT NULL,
  `c_parameter2` longtext DEFAULT NULL,
  `c_parameter1` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_chart_data`
--

LOCK TABLES `app_fd_j_chart_data` WRITE;
/*!40000 ALTER TABLE `app_fd_j_chart_data` DISABLE KEYS */;
INSERT INTO `app_fd_j_chart_data` VALUES
('0015',NULL,NULL,'admin','Admin Admin','admin','Admin Admin','13','28','Amazon Web Services','Infrastructure As A Service'),
('0016',NULL,NULL,'admin','Admin Admin','admin','Admin Admin','34','5','Google','Infrastructure As A Service'),
('0017',NULL,NULL,'admin','Admin Admin','admin','Admin Admin','26','7','IBM','Infrastructure As A Service'),
('0018',NULL,NULL,'admin','Admin Admin','admin','Admin Admin','43','10','Microsoft','Infrastructure As A Service'),
('0019',NULL,NULL,'admin','Admin Admin','admin','Admin Admin','7','43','Other','Infrastructure As A Service'),
('0020',NULL,NULL,'admin','Admin Admin','admin','Admin Admin','2','3','Rackspace','Infrastructure As A Service'),
('0021',NULL,NULL,'admin','Admin Admin','admin','Admin Admin','14','4','Salesforce','Infrastructure As A Service');
/*!40000 ALTER TABLE `app_fd_j_chart_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_crm_account`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_crm_account` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_country` longtext DEFAULT NULL,
  `c_address` longtext DEFAULT NULL,
  `c_attachment` longtext DEFAULT NULL,
  `c_accountName` longtext DEFAULT NULL,
  `c_city` longtext DEFAULT NULL,
  `c_office` longtext DEFAULT NULL,
  `c_state` longtext DEFAULT NULL,
  `c_fax` longtext DEFAULT NULL,
  `c_email` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_crm_account`
--

LOCK TABLES `app_fd_j_crm_account` WRITE;
/*!40000 ALTER TABLE `app_fd_j_crm_account` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_crm_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_crm_contact`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_crm_contact` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_lastName` longtext DEFAULT NULL,
  `c_country` longtext DEFAULT NULL,
  `c_address` longtext DEFAULT NULL,
  `c_city` longtext DEFAULT NULL,
  `c_mobile` longtext DEFAULT NULL,
  `c_photo` longtext DEFAULT NULL,
  `c_office` longtext DEFAULT NULL,
  `c_title` longtext DEFAULT NULL,
  `c_addressAvailable` longtext DEFAULT NULL,
  `c_firstName` longtext DEFAULT NULL,
  `c_attachment` longtext DEFAULT NULL,
  `c_state` longtext DEFAULT NULL,
  `c_account` longtext DEFAULT NULL,
  `c_email` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_crm_contact`
--

LOCK TABLES `app_fd_j_crm_contact` WRITE;
/*!40000 ALTER TABLE `app_fd_j_crm_contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_crm_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_crm_opportunity`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_crm_opportunity` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_amount` longtext DEFAULT NULL,
  `c_stage` longtext DEFAULT NULL,
  `c_description` longtext DEFAULT NULL,
  `c_source` longtext DEFAULT NULL,
  `c_newAccount` longtext DEFAULT NULL,
  `c_title` longtext DEFAULT NULL,
  `c_account` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_crm_opportunity`
--

LOCK TABLES `app_fd_j_crm_opportunity` WRITE;
/*!40000 ALTER TABLE `app_fd_j_crm_opportunity` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_crm_opportunity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_crm_proposal`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_crm_proposal` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_approver` longtext DEFAULT NULL,
  `c_refNo` longtext DEFAULT NULL,
  `c_comments` longtext DEFAULT NULL,
  `c_notes` longtext DEFAULT NULL,
  `c_proposer` longtext DEFAULT NULL,
  `c_description` longtext DEFAULT NULL,
  `c_selectApprover` longtext DEFAULT NULL,
  `c_title` longtext DEFAULT NULL,
  `c_attachment` longtext DEFAULT NULL,
  `c_dateProposed` longtext DEFAULT NULL,
  `c_dateApproved` longtext DEFAULT NULL,
  `c_account` longtext DEFAULT NULL,
  `c_status` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_crm_proposal`
--

LOCK TABLES `app_fd_j_crm_proposal` WRITE;
/*!40000 ALTER TABLE `app_fd_j_crm_proposal` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_crm_proposal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_expense_approval`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_expense_approval` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_approver` longtext DEFAULT NULL,
  `c_ApprovedDate` longtext DEFAULT NULL,
  `c_ApprovedBy` longtext DEFAULT NULL,
  `c_claim` longtext DEFAULT NULL,
  `c_comment` longtext DEFAULT NULL,
  `c_username` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_expense_approval`
--

LOCK TABLES `app_fd_j_expense_approval` WRITE;
/*!40000 ALTER TABLE `app_fd_j_expense_approval` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_expense_approval` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_expense_cat`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_expense_cat` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_Category` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_expense_cat`
--

LOCK TABLES `app_fd_j_expense_cat` WRITE;
/*!40000 ALTER TABLE `app_fd_j_expense_cat` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_expense_cat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_expense_claim`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_expense_claim` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_spECD` longtext DEFAULT NULL,
  `c_FinanceApprovedBy` longtext DEFAULT NULL,
  `c_ApprovedDate` longtext DEFAULT NULL,
  `c_remark` longtext DEFAULT NULL,
  `c_title` longtext DEFAULT NULL,
  `c_SelectApprover` longtext DEFAULT NULL,
  `c_FinanceApprovedDate` longtext DEFAULT NULL,
  `c_total` longtext DEFAULT NULL,
  `c_finance_comments` longtext DEFAULT NULL,
  `c_ref` longtext DEFAULT NULL,
  `c_approval_comments` longtext DEFAULT NULL,
  `c_ApprovedBy` longtext DEFAULT NULL,
  `c_CreatedDate` longtext DEFAULT NULL,
  `c_receipt` longtext DEFAULT NULL,
  `c_claimant` longtext DEFAULT NULL,
  `c_status` longtext DEFAULT NULL,
  `c_username` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_expense_claim`
--

LOCK TABLES `app_fd_j_expense_claim` WRITE;
/*!40000 ALTER TABLE `app_fd_j_expense_claim` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_expense_claim` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_expense_entry`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_expense_entry` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_date` longtext DEFAULT NULL,
  `c_amount` longtext DEFAULT NULL,
  `c_purpose` longtext DEFAULT NULL,
  `c_claim` longtext DEFAULT NULL,
  `c_category` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_expense_entry`
--

LOCK TABLES `app_fd_j_expense_entry` WRITE;
/*!40000 ALTER TABLE `app_fd_j_expense_entry` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_expense_entry` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_isr_remark`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_isr_remark` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_name` longtext DEFAULT NULL,
  `c_request_id` longtext DEFAULT NULL,
  `c_remarks` longtext DEFAULT NULL,
  `c_username` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_isr_remark`
--

LOCK TABLES `app_fd_j_isr_remark` WRITE;
/*!40000 ALTER TABLE `app_fd_j_isr_remark` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_isr_remark` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_isr_request`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_isr_request` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_ref_id` longtext DEFAULT NULL,
  `c_requester` longtext DEFAULT NULL,
  `c_subject` longtext DEFAULT NULL,
  `c_description` longtext DEFAULT NULL,
  `c_priority` longtext DEFAULT NULL,
  `c_fgR` longtext DEFAULT NULL,
  `c_createdDate` longtext DEFAULT NULL,
  `c_duedate` longtext DEFAULT NULL,
  `c_verifier` longtext DEFAULT NULL,
  `c_attention` longtext DEFAULT NULL,
  `c_assignee` longtext DEFAULT NULL,
  `c_dateVerified` longtext DEFAULT NULL,
  `c_attachment2` longtext DEFAULT NULL,
  `c_department` longtext DEFAULT NULL,
  `c_attachment1` longtext DEFAULT NULL,
  `c_requester_name` longtext DEFAULT NULL,
  `c_remarks` longtext DEFAULT NULL,
  `c_status` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_isr_request`
--

LOCK TABLES `app_fd_j_isr_request` WRITE;
/*!40000 ALTER TABLE `app_fd_j_isr_request` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_isr_request` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_meeting_data`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_meeting_data` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_date` longtext DEFAULT NULL,
  `c_name` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_meeting_data`
--

LOCK TABLES `app_fd_j_meeting_data` WRITE;
/*!40000 ALTER TABLE `app_fd_j_meeting_data` DISABLE KEYS */;
INSERT INTO `app_fd_j_meeting_data` VALUES
('001','2023-02-07 09:43:43.000000','2024-04-18 02:18:00.000000','admin','Admin Admin','admin','Admin Admin','2024-12-18','Meeting'),
('002','2023-02-07 09:44:15.000000','2024-04-18 02:18:50.000000','admin','Admin Admin','admin','Admin Admin','2024-08-15','Meeting'),
('003','2023-02-07 09:44:42.000000','2024-04-18 02:19:25.000000','admin','Admin Admin','admin','Admin Admin','2024-10-19','Meeting'),
('004','2023-02-07 09:45:11.000000','2024-04-18 02:19:57.000000','admin','Admin Admin','admin','Admin Admin','2025-02-01','Meeting'),
('006','2023-02-07 09:42:54.000000','2024-04-18 02:17:00.000000','admin','Admin Admin','admin','Admin Admin','2024-05-16','Meeting'),
('007','2023-02-07 09:43:07.000000','2024-04-18 02:17:36.000000','admin','Admin Admin','admin','Admin Admin','2024-07-08','Meeting'),
('008','2023-02-07 09:43:24.000000','2024-04-18 02:17:14.000000','admin','Admin Admin','admin','Admin Admin','2024-06-30','Meeting'),
('009','2023-02-07 09:44:01.000000','2024-04-18 02:18:28.000000','admin','Admin Admin','admin','Admin Admin','2024-11-20','Meeting'),
('010','2023-02-07 09:44:27.000000','2024-04-18 02:19:05.000000','admin','Admin Admin','admin','Admin Admin','2024-09-25','Meeting'),
('011','2023-02-07 09:44:57.000000','2024-04-18 02:19:45.000000','admin','Admin Admin','admin','Admin Admin','2025-01-21','Meeting'),
('012','2023-02-07 09:45:24.000000','2024-04-18 02:20:15.000000','admin','Admin Admin','admin','Admin Admin','2025-03-06','Meeting');
/*!40000 ALTER TABLE `app_fd_j_meeting_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_sc_grid1`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_sc_grid1` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_date` longtext DEFAULT NULL,
  `c_select` longtext DEFAULT NULL,
  `c_file` longtext DEFAULT NULL,
  `c_fk` longtext DEFAULT NULL,
  `c_name` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_sc_grid1`
--

LOCK TABLES `app_fd_j_sc_grid1` WRITE;
/*!40000 ALTER TABLE `app_fd_j_sc_grid1` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_sc_grid1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_sc_grid2`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_sc_grid2` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_date` longtext DEFAULT NULL,
  `c_select` longtext DEFAULT NULL,
  `c_file` longtext DEFAULT NULL,
  `c_fk` longtext DEFAULT NULL,
  `c_name` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_sc_grid2`
--

LOCK TABLES `app_fd_j_sc_grid2` WRITE;
/*!40000 ALTER TABLE `app_fd_j_sc_grid2` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_sc_grid2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_sc_grid3`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_sc_grid3` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_date` longtext DEFAULT NULL,
  `c_fk` longtext DEFAULT NULL,
  `c_name` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_sc_grid3`
--

LOCK TABLES `app_fd_j_sc_grid3` WRITE;
/*!40000 ALTER TABLE `app_fd_j_sc_grid3` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_sc_grid3` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_sc_grid4`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_sc_grid4` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_firstName` longtext DEFAULT NULL,
  `c_lastName` longtext DEFAULT NULL,
  `c_fk` longtext DEFAULT NULL,
  `c_username` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_sc_grid4`
--

LOCK TABLES `app_fd_j_sc_grid4` WRITE;
/*!40000 ALTER TABLE `app_fd_j_sc_grid4` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_sc_grid4` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_sc_tran`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_sc_tran` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_reason1` longtext DEFAULT NULL,
  `c_approvalStatus2` longtext DEFAULT NULL,
  `c_reason2` longtext DEFAULT NULL,
  `c_page4_key` longtext DEFAULT NULL,
  `c_approvalStatus1` longtext DEFAULT NULL,
  `c_rcounter` longtext DEFAULT NULL,
  `c_page2_key` longtext DEFAULT NULL,
  `c_approverUsername2` longtext DEFAULT NULL,
  `c_approverUsername1` longtext DEFAULT NULL,
  `c_page3_key` longtext DEFAULT NULL,
  `c_page1_key` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_sc_tran`
--

LOCK TABLES `app_fd_j_sc_tran` WRITE;
/*!40000 ALTER TABLE `app_fd_j_sc_tran` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_sc_tran` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_sc_tran_t1`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_sc_tran_t1` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_calculation` longtext DEFAULT NULL,
  `c_signature` longtext DEFAULT NULL,
  `c_date6` longtext DEFAULT NULL,
  `c_date5` longtext DEFAULT NULL,
  `c_date4` longtext DEFAULT NULL,
  `c_date3` longtext DEFAULT NULL,
  `c_date2` longtext DEFAULT NULL,
  `c_date1` longtext DEFAULT NULL,
  `c_textField` longtext DEFAULT NULL,
  `c_richTextEditor` longtext DEFAULT NULL,
  `c_ecounter` longtext DEFAULT NULL,
  `c_numeric2` longtext DEFAULT NULL,
  `c_numeric1` longtext DEFAULT NULL,
  `c_textArea` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_sc_tran_t1`
--

LOCK TABLES `app_fd_j_sc_tran_t1` WRITE;
/*!40000 ALTER TABLE `app_fd_j_sc_tran_t1` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_sc_tran_t1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_sc_tran_t2`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_sc_tran_t2` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_popupSelectBox` longtext DEFAULT NULL,
  `c_selectBox` longtext DEFAULT NULL,
  `c_checkBox` longtext DEFAULT NULL,
  `c_ecounter` longtext DEFAULT NULL,
  `c_multiSelectBox` longtext DEFAULT NULL,
  `c_radio` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_sc_tran_t2`
--

LOCK TABLES `app_fd_j_sc_tran_t2` WRITE;
/*!40000 ALTER TABLE `app_fd_j_sc_tran_t2` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_sc_tran_t2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_sc_tran_t3`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_sc_tran_t3` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_imageUpload_1` longtext DEFAULT NULL,
  `c_ecounter` longtext DEFAULT NULL,
  `c_imageUpload` longtext DEFAULT NULL,
  `c_fileUpload` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_sc_tran_t3`
--

LOCK TABLES `app_fd_j_sc_tran_t3` WRITE;
/*!40000 ALTER TABLE `app_fd_j_sc_tran_t3` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_sc_tran_t3` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_sc_tran_t4`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_sc_tran_t4` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_sc_tran_t4`
--

LOCK TABLES `app_fd_j_sc_tran_t4` WRITE;
/*!40000 ALTER TABLE `app_fd_j_sc_tran_t4` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_sc_tran_t4` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_stock`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_stock` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_firstName` longtext DEFAULT NULL,
  `c_Lowest` longtext DEFAULT NULL,
  `c_Closing` longtext DEFAULT NULL,
  `c_StockCode` longtext DEFAULT NULL,
  `c_Highest` longtext DEFAULT NULL,
  `c_Date` longtext DEFAULT NULL,
  `c_RequestNo` longtext DEFAULT NULL,
  `c_Open` longtext DEFAULT NULL,
  `c_username` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_stock`
--

LOCK TABLES `app_fd_j_stock` WRITE;
/*!40000 ALTER TABLE `app_fd_j_stock` DISABLE KEYS */;
INSERT INTO `app_fd_j_stock` VALUES
('001',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'25.80','25.95','ABCD','26.42','2015/11/01',NULL,'26.24',NULL),
('002',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.18','26.20','ABCD','26.46','2015/11/02',NULL,'26.40',NULL),
('003',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.04','26.08','ABCD','26.41','2015/11/03',NULL,'26.37',NULL),
('004',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.15','26.16','ABCD','26.90','2015/11/04',NULL,'26.78',NULL),
('005',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.51','26.58','ABCD','26.99','2015/11/05',NULL,'26.86',NULL),
('006',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.50','26.55','ABCD','27.11','2015/11/06',NULL,'26.95',NULL),
('007',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.50','26.77','ABCD','26.84','2015/11/07',NULL,'27.06',NULL),
('008',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.43','26.59','ABCD','26.83','2015/11/08',NULL,'26.86',NULL),
('009',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.52','26.59','ABCD','26.98','2015/11/09',NULL,'27.10',NULL),
('010',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.99','27.06','ABCD','27.33','2015/11/10',NULL,'27.21',NULL),
('011',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.91','27.21','ABCD','27.17','2015/11/11',NULL,'27.37',NULL),
('012',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.60','27.02','ABCD','27.15','2015/11/12',NULL,'27.07',NULL),
('013',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.95','26.96','ABCD','27.24','2015/11/13',NULL,'27.33',NULL),
('014',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'26.95','27.23','ABCD','27.41','2015/11/14',NULL,'27.27',NULL),
('015',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'27.07','27.25','ABCD','27.86','2015/11/15',NULL,'27.81',NULL),
('016',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'27.29','27.50','ABCD','28.00','2015/11/16',NULL,'27.94',NULL),
('017',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'27.91','27.97','ABCD','28.39','2015/11/17',NULL,'28.26',NULL),
('018',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'28.05','28.28','ABCD','28.30','2015/11/18',NULL,'28.34',NULL),
('019',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'27.79','27.90','ABCD','28.49','2015/11/19',NULL,'28.34',NULL),
('020',NULL,NULL,'admin','Admin Admin','admin','Admin Admin',NULL,'27.71','27.77','ABCD','27.90','2015/11/20',NULL,'27.84',NULL);
/*!40000 ALTER TABLE `app_fd_j_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_temp`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_temp` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_lastName` longtext DEFAULT NULL,
  `c_reportTo` longtext DEFAULT NULL,
  `c_endDate` longtext DEFAULT NULL,
  `c_jobTitle` longtext DEFAULT NULL,
  `c_active` longtext DEFAULT NULL,
  `c_timeZone` longtext DEFAULT NULL,
  `c_groups` longtext DEFAULT NULL,
  `c_isHod` longtext DEFAULT NULL,
  `c_employeeCode` longtext DEFAULT NULL,
  `c_firstName` longtext DEFAULT NULL,
  `c_userRoles` longtext DEFAULT NULL,
  `c_password` longtext DEFAULT NULL,
  `c_organization` longtext DEFAULT NULL,
  `c_grade` longtext DEFAULT NULL,
  `c_department` longtext DEFAULT NULL,
  `c_email` longtext DEFAULT NULL,
  `c_startDate` longtext DEFAULT NULL,
  `c_username` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_temp`
--

LOCK TABLES `app_fd_j_temp` WRITE;
/*!40000 ALTER TABLE `app_fd_j_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_temp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_fd_j_user_register`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_fd_j_user_register` (
  `id` varchar(255) NOT NULL,
  `dateCreated` datetime(6) DEFAULT NULL,
  `dateModified` datetime(6) DEFAULT NULL,
  `createdBy` varchar(255) DEFAULT NULL,
  `createdByName` varchar(255) DEFAULT NULL,
  `modifiedBy` varchar(255) DEFAULT NULL,
  `modifiedByName` varchar(255) DEFAULT NULL,
  `c_firstName` longtext DEFAULT NULL,
  `c_lastName` longtext DEFAULT NULL,
  `c_userRoles` longtext DEFAULT NULL,
  `c_password` longtext DEFAULT NULL,
  `c_comments` longtext DEFAULT NULL,
  `c_active` longtext DEFAULT NULL,
  `c_verify_password` longtext DEFAULT NULL,
  `c_email` longtext DEFAULT NULL,
  `c_status` longtext DEFAULT NULL,
  `c_username` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_datecreated` (`dateCreated`),
  KEY `idx_createdby` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_fd_j_user_register`
--

LOCK TABLES `app_fd_j_user_register` WRITE;
/*!40000 ALTER TABLE `app_fd_j_user_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `app_fd_j_user_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_form`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_form` (
  `appId` varchar(255) NOT NULL,
  `appVersion` bigint(20) NOT NULL,
  `formId` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `tableName` varchar(255) DEFAULT NULL,
  `json` longtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  PRIMARY KEY (`appId`,`appVersion`,`formId`),
  KEY `FK45957822462EF4C7` (`appId`,`appVersion`),
  KEY `idx_name` (`name`),
  CONSTRAINT `FK45957822462EF4C7` FOREIGN KEY (`appId`, `appVersion`) REFERENCES `app_app` (`appId`, `appVersion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_form`
--

LOCK TABLES `app_form` WRITE;
/*!40000 ALTER TABLE `app_form` DISABLE KEYS */;
INSERT INTO `app_form` VALUES
('crm',1,'AccountContacts','Account: Contacts  Tab','2024-04-19 13:39:54','2024-04-19 13:39:54','j_crm_account','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"name\":\"Account: Contacts  Tab\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"AccountContacts\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"tableName\":\"j_crm_account\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.FormGrid\",\"properties\":{\"validateMaxRow\":\"\",\"formDefId\":\"AccountContactSub\",\"validator\":{\"className\":\"\",\"properties\":{}},\"pageSize\":\"20\",\"enableSorting\":\"\",\"storeBinder\":{\"className\":\"org.joget.plugin.enterprise.MultirowFormBinder\",\"properties\":{\"formDefId\":\"crm_contact\",\"foreignKey\":\"account\"}},\"readonly\":\"\",\"deleteGridData\":\"\",\"options\":[{\"format\":\"\",\"width\":\"\",\"label\":\"Title\",\"formatType\":\"text\",\"value\":\"title\"},{\"format\":\"\",\"width\":\"\",\"label\":\"First Name\",\"formatType\":\"text\",\"value\":\"firstName\"},{\"format\":\"\",\"width\":\"\",\"label\":\"Last Name\",\"formatType\":\"text\",\"value\":\"lastName\"},{\"format\":\"\",\"width\":\"\",\"label\":\"Email\",\"formatType\":\"text\",\"value\":\"email\"},{\"format\":\"\",\"width\":\"\",\"label\":\"Mobile\",\"formatType\":\"text\",\"value\":\"mobile\"},{\"format\":\"\",\"width\":\"\",\"label\":\"Office\",\"formatType\":\"text\",\"value\":\"office\"},{\"format\":\"\",\"width\":\"\",\"label\":\"Country\",\"formatType\":\"text\",\"value\":\"country\"}],\"id\":\"fgC\",\"abortRelatedRunningProcesses\":\"\",\"height\":\"80%\",\"showRowNumber\":\"\",\"disabledDelete\":\"\",\"validateMinRow\":\"\",\"submit-label-normal\":\"\",\"uniqueKey\":\"\",\"errorMessage\":\"Invalid number of rows\",\"deleteSubformData\":\"\",\"deleteMessage\":\"Delete row?\",\"label\":\"\",\"loadBinder\":{\"className\":\"org.joget.plugin.enterprise.MultirowFormBinder\",\"properties\":{\"formDefId\":\"crm_contact\",\"foreignKey\":\"account\"}},\"disabledAdd\":\"\",\"submit-label-readonly\":\"\",\"width\":\"80%\",\"readonlyLabel\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"100%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"section1\",\"label\":\"\",\"storeBinder\":{\"className\":\"\",\"properties\":{}}}}]}',NULL),
('crm',1,'AccountContactSub','Account: Contacts Subform','2024-04-19 13:39:59','2024-04-19 13:39:59','j_crm_contact','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"name\":\"Account: Contacts Subform\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"AccountContactSub\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"tableName\":\"j_crm_contact\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.HiddenField\",\"properties\":{\"useDefaultWhenEmpty\":\"\",\"workflowVariable\":\"\",\"id\":\"account\",\"value\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Title\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"title\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"custom-regex\":\"\",\"type\":\"\",\"message\":\"\",\"mandatory\":\"true\"}},\"label\":\"First Name\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"firstName\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"readonly\":\"\",\"size\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"lastName\",\"label\":\"Last Name\"}},{\"className\":\"org.joget.apps.form.lib.Radio\",\"properties\":{\"controlField\":\"\",\"readonly\":\"\",\"optionsBinder\":{\"className\":\"\",\"properties\":{}},\"options\":[{\"label\":\"Yes\",\"value\":\"Yes\",\"grouping\":\"\"},{\"label\":\"No\",\"value\":\"No\",\"grouping\":\"\"}],\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"addressAvailable\",\"label\":\"Address Available\",\"value\":\"No\",\"readonlyLabel\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}},{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Mobile Number\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"mobile\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Office Number\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"office\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Email Address\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"email\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.ImageUpload\",\"properties\":{\"padding\":\"5px\",\"permissionType\":\"\",\"maxSizeMsg\":\"File size limit exceeded\",\"multiple\":\"true\",\"validator\":{\"className\":\"\",\"properties\":{}},\"createThumbnail\":\"true\",\"maxSize\":\"\",\"label\":\"Photo Attachments\",\"readonly\":\"\",\"removeFile\":\"true\",\"width\":\"100\",\"fileTypeMsg\":\"Invalid file type\",\"id\":\"photo\",\"fileType\":\".jpeg;.jpg;.gif;.png\",\"height\":\"100\"}},{\"className\":\"org.joget.apps.form.lib.FileUpload\",\"properties\":{\"permissionType\":\"\",\"padding\":\"5px\",\"maxSizeMsg\":\"File size limit exceeded\",\"validator\":{\"className\":\"\",\"properties\":{}},\"multiple\":\"\",\"maxSize\":\"\",\"label\":\"Document Attachments\",\"removeFile\":\"\",\"size\":\"\",\"readonly\":\"\",\"attachment\":\"true\",\"fileTypeMsg\":\"Invalid file type\",\"id\":\"attachment\",\"fileType\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"id\":\"contact_details\",\"label\":\"Contact Details\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextArea\",\"properties\":{\"readonly\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"address\",\"label\":\"Address\",\"placeholder\":\"\",\"rows\":\"3\",\"value\":\"\",\"cols\":\"40\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"readonly\":\"\",\"size\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"city\",\"label\":\"City\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}},{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"readonly\":\"\",\"size\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"state\",\"label\":\"State\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Country\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"country\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"addressAvailable\",\"regex\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"address_details\",\"label\":\"Address Details\",\"join\":\"\",\"reverse\":\"\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"Yes\"}}]}',NULL),
('crm',1,'AccountsMain','Account:  Parent','2024-04-19 13:39:59','2024-04-19 13:39:59','j_crm_account','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"name\":\"Account:  Parent\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"AccountsMain\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"tableName\":\"j_crm_account\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.plugin.enterprise.MultiPagedForm\",\"properties\":{\"prevButtonlabel\":\"Prev\",\"css\":\"\",\"nextButtonlabel\":\"Next\",\"partiallyStore\":\"\",\"id\":\"mpfA\",\"label\":\"\",\"onlyAllowSubmitOnLastPage\":\"\",\"numberOfPage\":{\"className\":\"2\",\"properties\":{\"page1_label\":\"#i18n.Account Details#\",\"page1_formDefId\":\"crm_account\",\"page1_readonly\":\"\",\"page1_readonlyLabel\":\"\",\"page1_parentSubFormId\":\"id\",\"page1_subFormParentId\":\"\",\"page1_validate\":\"true\",\"page2_label\":\"#i18n.Contacts#\",\"page2_formDefId\":\"AccountContacts\",\"page2_readonly\":\"\",\"page2_readonlyLabel\":\"\",\"page2_parentSubFormId\":\"id\",\"page2_subFormParentId\":\"\",\"page2_validate\":\"true\"}},\"displayMode\":\"tab\",\"ajaxMode\":\"\",\"storeMainFormOnPartiallyStore\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"100%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"section1\",\"label\":\"Manage Accounts\",\"storeBinder\":{\"className\":\"\",\"properties\":{}}}}]}',NULL),
('crm',1,'crm_account','Account: Accounts Tab','2024-04-19 13:39:59','2024-04-19 13:39:59','j_crm_account','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"name\":\"Account: Accounts Tab\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"crm_account\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"tableName\":\"j_crm_account\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"size\":\"\",\"readonly\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"type\":\"\",\"mandatory\":\"true\"}},\"workflowVariable\":\"\",\"id\":\"id\",\"label\":\"Account ID\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"size\":\"\",\"readonly\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"type\":\"\",\"mandatory\":\"true\"}},\"workflowVariable\":\"\",\"id\":\"accountName\",\"label\":\"Account Name\"}},{\"className\":\"org.joget.apps.form.lib.FileUpload\",\"properties\":{\"permissionType\":\"\",\"padding\":\"5px\",\"maxSizeMsg\":\"File size limit exceeded\",\"validator\":{\"className\":\"\",\"properties\":{}},\"multiple\":\"\",\"maxSize\":\"\",\"label\":\"Document Attachments\",\"removeFile\":\"\",\"size\":\"\",\"readonly\":\"\",\"attachment\":\"true\",\"fileTypeMsg\":\"Invalid file type\",\"id\":\"attachment\",\"fileType\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}},{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Office Number\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"office\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Fax Number\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"fax\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"custom-regex\":\"\",\"type\":\"email\",\"message\":\"\",\"mandatory\":\"\"}},\"label\":\"Email Address\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"email\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"id\":\"account_details\",\"label\":\"Account Details\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextArea\",\"properties\":{\"readonly\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"address\",\"label\":\"Address\",\"placeholder\":\"\",\"rows\":\"3\",\"value\":\"\",\"cols\":\"40\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"readonly\":\"\",\"size\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"city\",\"label\":\"City\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}},{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"readonly\":\"\",\"size\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"state\",\"label\":\"State\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Country\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"country\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"id\":\"address\",\"label\":\"Address Details\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"\"}}]}',NULL),
('crm',1,'crm_contact','Contacts','2024-04-19 13:39:59','2024-04-19 13:39:59','j_crm_contact','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"name\":\"Contacts\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"crm_contact\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"tableName\":\"j_crm_contact\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"controlField\":\"\",\"size\":\"\",\"readonly\":\"\",\"optionsBinder\":{\"className\":\"org.joget.apps.form.lib.FormOptionsBinder\",\"properties\":{\"autoHandleWorkflowVariable\":\"\",\"addEmptyOption\":\"true\",\"groupingColumn\":\"\",\"useAjax\":\"\",\"formDefId\":\"crm_account\",\"labelColumn\":\"accountName\",\"cacheIdlePause\":\"60\",\"extraCondition\":\"\",\"cacheInterval\":\"\",\"emptyLabel\":\"#i18n.Select#\",\"idColumn\":\"id\",\"autoHandleFiles\":\"\"}},\"options\":[],\"multiple\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"type\":\"\",\"message\":\"\",\"mandatory\":\"true\"}},\"workflowVariable\":\"\",\"id\":\"account\",\"label\":\"Account\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Title\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"title\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"type\":\"\",\"message\":\"\",\"mandatory\":\"true\"}},\"label\":\"First name\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"firstName\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"id\":\"lastName\",\"label\":\"Last name\",\"value\":\"\",\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"encryption\":\"\",\"placeholder\":\"\",\"size\":\"\",\"readonly\":\"\",\"readonlyLabel\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.Radio\",\"properties\":{\"controlField\":\"\",\"readonly\":\"\",\"optionsBinder\":{\"className\":\"\",\"properties\":{}},\"options\":[{\"label\":\"Yes\",\"value\":\"Yes\",\"grouping\":\"\"},{\"label\":\"No\",\"value\":\"No\",\"grouping\":\"\"}],\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"addressAvailable\",\"label\":\"Address Available\",\"value\":\"No\",\"readonlyLabel\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}},{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Mobile Number\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"mobile\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Office Number\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"office\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Email Address\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"email\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.plugin.enterprise.ImageUpload\",\"properties\":{\"padding\":\"5px\",\"permissionType\":\"\",\"maxSizeMsg\":\"File size limit exceeded\",\"multiple\":\"true\",\"validator\":{\"className\":\"\",\"properties\":{}},\"createThumbnail\":\"true\",\"maxSize\":\"\",\"label\":\"Photo Attachments\",\"readonly\":\"\",\"removeFile\":\"true\",\"width\":\"100\",\"fileTypeMsg\":\"Invalid file type\",\"id\":\"photo\",\"fileType\":\".jpeg;.jpg;.gif;.png\",\"height\":\"100\"}},{\"className\":\"org.joget.apps.form.lib.FileUpload\",\"properties\":{\"permissionType\":\"\",\"padding\":\"5px\",\"maxSizeMsg\":\"File size limit exceeded\",\"validator\":{\"className\":\"\",\"properties\":{}},\"multiple\":\"\",\"maxSize\":\"\",\"label\":\"Document Attachments\",\"removeFile\":\"\",\"size\":\"\",\"readonly\":\"\",\"attachment\":\"true\",\"fileTypeMsg\":\"Invalid file type\",\"id\":\"attachment\",\"fileType\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"id\":\"contact_details\",\"label\":\"Contact Details\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextArea\",\"properties\":{\"readonly\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"address\",\"label\":\"Address\",\"placeholder\":\"\",\"rows\":\"3\",\"value\":\"\",\"cols\":\"40\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"readonly\":\"\",\"size\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"city\",\"label\":\"City\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}},{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"readonly\":\"\",\"size\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"state\",\"label\":\"State\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"label\":\"Country\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"country\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"addressAvailable\",\"regex\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"address_details\",\"label\":\"Address Details\",\"join\":\"\",\"reverse\":\"\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"Yes\"}}]}',NULL),
('crm',1,'crm_opportunity','Opportunity','2024-04-19 13:39:59','2024-04-19 13:39:59','j_crm_opportunity','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"name\":\"Opportunity\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"crm_opportunity\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"tableName\":\"j_crm_opportunity\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"custom-regex\":\"\",\"type\":\"\",\"message\":\"\",\"mandatory\":\"true\"}},\"label\":\"Opportunity Title\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"title\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextArea\",\"properties\":{\"readonly\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"description\",\"label\":\"Description\",\"placeholder\":\"\",\"rows\":\"4\",\"value\":\"\",\"cols\":\"40\",\"readonlyLabel\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}},{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"prefix\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"useThousandSeparator\":\"\",\"label\":\"Amount\",\"numOfDecimal\":\"2\",\"encryption\":\"\",\"size\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"us\",\"id\":\"amount\",\"placeholder\":\"\",\"postfix\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"true\"}},{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"controlField\":\"\",\"size\":\"\",\"readonly\":\"\",\"optionsBinder\":{\"className\":\"\",\"properties\":{}},\"options\":[{\"label\":\"Open\",\"value\":\"open\",\"grouping\":\"\"},{\"label\":\"Won\",\"value\":\"won\",\"grouping\":\"\"},{\"label\":\"Lost\",\"value\":\"lost\",\"grouping\":\"\"}],\"multiple\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"stage\",\"label\":\"Stage\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"id\":\"source\",\"label\":\"Source\",\"options\":[{\"value\":\"Direct\",\"label\":\"Direct\",\"grouping\":\"\"},{\"value\":\"Indirect\",\"label\":\"Indirect\",\"grouping\":\"\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}},\"value\":\"\",\"multiple\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"controlField\":\"\",\"size\":\"\",\"readonly\":\"\",\"readonlyLabel\":\"\",\"workflowVariable\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"id\":\"opportunity\",\"label\":\"Opportunity\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"\",\"readonly\":\"\",\"readonlyLabel\":\"\",\"join\":\"\",\"reverse\":\"\",\"regex\":\"\",\"permission\":{\"className\":\"\",\"properties\":{}},\"permissionReadonly\":\"\",\"comment\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.Radio\",\"properties\":{\"controlField\":\"\",\"readonly\":\"\",\"optionsBinder\":{\"className\":\"\",\"properties\":{}},\"options\":[{\"value\":\"Yes\",\"label\":\"Yes\",\"grouping\":\"\"},{\"value\":\"No\",\"label\":\"No\",\"grouping\":\"\"}],\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"newAccount\",\"label\":\"New Account\",\"value\":\"No\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.CustomHTML\",\"properties\":{\"autoPopulate\":\"\",\"label\":\"\",\"id\":\"field10\",\"value\":\"<script>\\n    $(function(){\\n        FormUtil.getField(\\\"newAccount\\\").filter(\'[value=No]\').prop(\'checked\', true).trigger(\\\"change\\\");\\n    });\\n<\\/script>\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}},{\"elements\":[],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"49%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"id\":\"accountChoice\",\"label\":\"\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"\",\"readonly\":\"\",\"readonlyLabel\":\"\",\"join\":\"\",\"reverse\":\"\",\"regex\":\"\",\"permission\":{\"className\":\"\",\"properties\":{}},\"permissionReadonly\":\"\",\"comment\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"readonly\":\"\",\"size\":\"\",\"optionsBinder\":{\"className\":\"org.joget.apps.form.lib.FormOptionsBinder\",\"properties\":{\"formDefId\":\"crm_account\",\"labelColumn\":\"accountName\",\"extraCondition\":\"\"}},\"validator\":{\"className\":\"\",\"properties\":{}},\"multiple\":\"\",\"options\":[],\"workflowVariable\":\"\",\"id\":\"account\",\"label\":\"Account\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"100%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"newAccount\",\"regex\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"account_existing\",\"label\":\"Existing Account\",\"join\":\"\",\"reverse\":\"\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"No\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.SubForm\",\"properties\":{\"parentSubFormId\":\"account\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"readonly\":\"\",\"formDefId\":\"crm_account\",\"subFormParentId\":\"\",\"id\":\"account\",\"label\":\"\",\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}}}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"100%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"newAccount\",\"regex\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"account_new\",\"label\":\"New Account\",\"join\":\"\",\"reverse\":\"\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"Yes\"}}]}',NULL),
('crm',1,'crm_proposal_approval_form','Proposal Approval','2024-04-19 13:40:00','2024-04-19 13:40:00','j_crm_proposal','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"name\":\"Proposal Approval\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"crm_proposal_approval_form\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"tableName\":\"j_crm_proposal\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.SubForm\",\"properties\":{\"parentSubFormId\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"readonly\":\"true\",\"formDefId\":\"crm_proposal_form\",\"subFormParentId\":\"\",\"id\":\"proposal\",\"label\":\"\",\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"readonlyLabel\":\"\",\"noframe\":\"true\",\"permissionHidden\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"100%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"id\":\"section1\",\"label\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"permission\":{\"className\":\"\",\"properties\":{}}}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"controlField\":\"\",\"size\":\"\",\"readonly\":\"\",\"optionsBinder\":{\"className\":\"\",\"properties\":{}},\"options\":[{\"label\":\"Approved\",\"value\":\"Approved\",\"grouping\":\"\"},{\"label\":\"Resubmit\",\"value\":\"Resubmit\",\"grouping\":\"\"},{\"label\":\"Rejected\",\"value\":\"Rejected\",\"grouping\":\"\"}],\"multiple\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"custom-regex\":\"\",\"type\":\"\",\"message\":\"\",\"mandatory\":\"true\"}},\"workflowVariable\":\"status\",\"id\":\"status\",\"label\":\"Status\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextArea\",\"properties\":{\"readonly\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"id\":\"comments\",\"label\":\"Approver Comments\",\"rows\":\"5\",\"cols\":\"20\"}},{\"className\":\"org.joget.apps.form.lib.HiddenField\",\"properties\":{\"useDefaultWhenEmpty\":\"\",\"workflowVariable\":\"\",\"id\":\"approver\",\"value\":\"#currentUser.firstName# #currentUser.lastName#\"}},{\"className\":\"org.joget.apps.form.lib.HiddenField\",\"properties\":{\"useDefaultWhenEmpty\":\"\",\"workflowVariable\":\"\",\"id\":\"dateApproved\",\"value\":\"#date.yyyy-MM-dd#\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"100%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"id\":\"section2\",\"label\":\"Proposal Approval\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"permission\":{\"className\":\"\",\"properties\":{}}}}]}',NULL),
('crm',1,'crm_proposal_form','Proposal New','2024-04-19 13:40:00','2024-04-19 13:40:00','j_crm_proposal','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"name\":\"Proposal New\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"crm_proposal_form\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"tableName\":\"j_crm_proposal\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.IdGeneratorField\",\"properties\":{\"hidden\":\"true\",\"format\":\"????\",\"workflowVariable\":\"\",\"envVariable\":\"refNo\",\"id\":\"refNo\",\"label\":\"Reference No\"}},{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"controlField\":\"\",\"size\":\"\",\"readonly\":\"\",\"optionsBinder\":{\"className\":\"org.joget.apps.form.lib.FormOptionsBinder\",\"properties\":{\"addEmptyOption\":\"\",\"groupingColumn\":\"\",\"useAjax\":\"\",\"formDefId\":\"crm_account\",\"labelColumn\":\"accountName\",\"extraCondition\":\"\",\"emptyLabel\":\"\",\"idColumn\":\"\"}},\"options\":[],\"multiple\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"custom-regex\":\"\",\"type\":\"\",\"message\":\"\",\"mandatory\":\"true\"}},\"workflowVariable\":\"\",\"id\":\"account\",\"label\":\"Account\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"custom-regex\":\"\",\"type\":\"\",\"message\":\"\",\"mandatory\":\"true\"}},\"label\":\"Proposal Title\",\"encryption\":\"\",\"size\":\"40\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"title\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextArea\",\"properties\":{\"readonly\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"description\",\"label\":\"Description\",\"placeholder\":\"\",\"rows\":\"5\",\"value\":\"\",\"cols\":\"60\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"controlField\":\"\",\"size\":\"\",\"readonly\":\"\",\"optionsBinder\":{\"className\":\"org.joget.plugin.enterprise.UserOptionsBinder\",\"properties\":{\"addEmptyOption\":\"\",\"optionLabel\":\"\",\"useAjax\":\"\",\"groupId\":\"\",\"deptId\":\"\",\"emptyLabel\":\"\",\"grouping\":\"\",\"orgId\":\"\"}},\"options\":[],\"multiple\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"custom-regex\":\"\",\"type\":\"\",\"message\":\"\",\"mandatory\":\"true\"}},\"workflowVariable\":\"selectApprover\",\"id\":\"selectApprover\",\"label\":\"Select approver\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.FileUpload\",\"properties\":{\"permissionType\":\"\",\"padding\":\"\",\"maxSizeMsg\":\"File size limit exceeded\",\"validator\":{\"className\":\"\",\"properties\":{}},\"multiple\":\"true\",\"maxSize\":\"\",\"label\":\"Document Attachments<br\\/>(Can attach more than 1 file)\",\"removeFile\":\"\",\"size\":\"\",\"readonly\":\"\",\"attachment\":\"true\",\"fileTypeMsg\":\"Invalid file type\",\"id\":\"attachment\",\"fileType\":\"\"}},{\"className\":\"org.joget.apps.form.lib.HiddenField\",\"properties\":{\"useDefaultWhenEmpty\":\"\",\"workflowVariable\":\"\",\"id\":\"status\",\"value\":\"New\"}},{\"className\":\"org.joget.apps.form.lib.HiddenField\",\"properties\":{\"useDefaultWhenEmpty\":\"\",\"workflowVariable\":\"\",\"id\":\"proposer\",\"value\":\"#currentUser.firstName# #currentUser.lastName#\"}},{\"className\":\"org.joget.apps.form.lib.HiddenField\",\"properties\":{\"useDefaultWhenEmpty\":\"\",\"workflowVariable\":\"\",\"id\":\"dateProposed\",\"value\":\"#date.yyyy-MM-dd#\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"100%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"id\":\"section1\",\"label\":\"Proposal Form\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"\"}}]}',NULL),
('crm',1,'crm_proposal_resubmit_form','Proposal Resubmit','2024-04-19 13:40:00','2024-04-19 13:40:00','j_crm_proposal','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"name\":\"Proposal Resubmit\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"crm_proposal_resubmit_form\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"tableName\":\"j_crm_proposal\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.SubForm\",\"properties\":{\"parentSubFormId\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"readonly\":\"true\",\"formDefId\":\"crm_proposal_approval_form\",\"subFormParentId\":\"\",\"id\":\"approval\",\"label\":\"\",\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}}}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"99%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"id\":\"section1\",\"label\":\"Proposal Resubmit\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.SubForm\",\"properties\":{\"id\":\"proposal\",\"label\":\"\",\"formDefId\":\"crm_proposal_form\",\"readonly\":\"\",\"readonlyLabel\":\"\",\"noframe\":\"\",\"parentSubFormId\":\"\",\"subFormParentId\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}}}},{\"className\":\"org.joget.apps.form.lib.HiddenField\",\"properties\":{\"workflowVariable\":\"status\",\"id\":\"status\",\"value\":\"pending\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"99%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"id\":\"section2\",\"label\":\"Proposal Resubmission\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"\"}}]}',NULL),
('crm',1,'crm_proposal_sending_form','Proposal Details','2024-04-19 13:40:00','2024-04-19 13:40:00','j_crm_proposal','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"name\":\"Proposal Details\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"crm_proposal_sending_form\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"tableName\":\"j_crm_proposal\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.SubForm\",\"properties\":{\"id\":\"approval\",\"label\":\"\",\"formDefId\":\"crm_proposal_approval_form\",\"readonly\":\"true\",\"readonlyLabel\":\"\",\"noframe\":\"\",\"parentSubFormId\":\"\",\"subFormParentId\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"permissionHidden\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"99%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"section1\",\"label\":\"\",\"storeBinder\":{\"className\":\"\",\"properties\":{}}}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextArea\",\"properties\":{\"readonly\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"notes\",\"label\":\"Notes\",\"placeholder\":\"\",\"rows\":\"5\",\"value\":\"\",\"cols\":\"40\",\"readonlyLabel\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"99%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"section2\",\"label\":\"Proposal Notes\",\"storeBinder\":{\"className\":\"\",\"properties\":{}}}}]}',NULL),
('crm',1,'Users','Joget Users','2024-04-19 13:40:00','2024-04-19 13:40:00','j_temp','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"You do not have permission to view or edit CRM User Accounts!<br\\/><br\\/>\\n<a href=\\\"dashboard\\\">Return to listing.<\\/a>\",\"loadBinder\":{\"className\":\"org.joget.plugin.enterprise.DirectoryUserFormBinder\",\"properties\":{\"type\":{\"className\":\"\",\"properties\":{\"lastName\":\"lastName\",\"reportTo\":\"reportTo\",\"endDate\":\"endDate\",\"jobTitle\":\"jobTitle\",\"active\":\"active\",\"timeZone\":\"timeZone\",\"groups\":\"groups\",\"locale\":\"locale\",\"isHod\":\"isHod\",\"employeeCode\":\"employeeCode\",\"firstName\":\"firstName\",\"userRoles\":\"userRoles\",\"password\":\"password\",\"organization\":\"organization\",\"grade\":\"grade\",\"department\":\"department\",\"email\":\"email\",\"startDate\":\"startDate\",\"username\":\"username\"}}}},\"name\":\"Joget Users\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"org.joget.plugin.enterprise.AdminUserviewPermission\",\"properties\":{}},\"id\":\"Users\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.plugin.enterprise.DirectoryUserFormBinder\",\"properties\":{\"type\":{\"className\":\"\",\"properties\":{\"lastName\":\"lastName\",\"reportTo\":\"reportTo\",\"endDate\":\"endDate\",\"jobTitle\":\"jobTitle\",\"active\":\"active\",\"timeZone\":\"timeZone\",\"groups\":\"groups\",\"locale\":\"locale\",\"isHod\":\"isHod\",\"employeeCode\":\"employeeCode\",\"firstName\":\"firstName\",\"userRoles\":\"userRoles\",\"password\":\"password\",\"organization\":\"organization\",\"grade\":\"grade\",\"department\":\"department\",\"email\":\"email\",\"startDate\":\"startDate\",\"username\":\"username\"}}}},\"tableName\":\"j_temp\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.HiddenField\",\"properties\":{\"useDefaultWhenEmpty\":\"\",\"workflowVariable\":\"\",\"id\":\"username\",\"value\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"org.joget.plugin.enterprise.DirectoryUserExistValidator\",\"properties\":{\"emptyMsg\":\"Missing required value\",\"field\":\"\",\"type\":\"\",\"errorMsg\":\"Username already exists\"}},\"label\":\"Username\",\"size\":\"\",\"encryption\":\"\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"placeholder\":\"\",\"id\":\"id\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"encryption\":\"\",\"readonly\":\"\",\"size\":\"50\",\"maxlength\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"custom-regex\":\"\",\"message\":\"\",\"type\":\"\",\"mandatory\":\"true\"}},\"workflowVariable\":\"\",\"id\":\"firstName\",\"label\":\"First name\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"encryption\":\"\",\"readonly\":\"\",\"size\":\"50\",\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"lastName\",\"label\":\"Last name\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"maxlength\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"custom-regex\":\"\",\"type\":\"email\",\"message\":\"\",\"mandatory\":\"true\"}},\"label\":\"Email\",\"encryption\":\"\",\"size\":\"50\",\"readonly\":\"\",\"workflowVariable\":\"\",\"style\":\"\",\"id\":\"email\",\"placeholder\":\"\",\"value\":\"\",\"readonlyLabel\":\"\",\"storeNumeric\":\"\"}},{\"className\":\"org.joget.apps.form.lib.PasswordField\",\"properties\":{\"readonly\":\"\",\"size\":\"50\",\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"id\":\"password\",\"label\":\"Password\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.Radio\",\"properties\":{\"controlField\":\"\",\"readonly\":\"\",\"optionsBinder\":{\"className\":\"\",\"properties\":{}},\"validator\":{\"className\":\"\",\"properties\":{}},\"options\":[{\"label\":\"Yes\",\"grouping\":\"\",\"value\":\"1\"},{\"label\":\"No\",\"grouping\":\"\",\"value\":\"0\"}],\"workflowVariable\":\"\",\"id\":\"active\",\"label\":\"Active\",\"value\":\"1\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"controlField\":\"\",\"readonly\":\"\",\"size\":\"\",\"optionsBinder\":{\"className\":\"\",\"properties\":{}},\"validator\":{\"className\":\"\",\"properties\":{}},\"multiple\":\"\",\"options\":[{\"label\":\"Select\",\"grouping\":\"\",\"value\":\"\"},{\"label\":\"(GMT -12:00) Eniwetok, Kwajalein\",\"grouping\":\"\",\"value\":\"-12\"},{\"label\":\"(GMT -11:00) Midway Island, Samoa\",\"grouping\":\"\",\"value\":\"-11\"},{\"label\":\"(GMT -10:00) Hawaii\",\"grouping\":\"\",\"value\":\"-10\"},{\"label\":\"(GMT -09:00) Alaska\",\"grouping\":\"\",\"value\":\"-9\"},{\"label\":\"(GMT -08:00) Pacific Time (US &amp; Canada), Tijuana\",\"grouping\":\"\",\"value\":\"-8\"},{\"label\":\"(GMT -07:00) Mountain Time (US &amp; Canada), Arizona\",\"grouping\":\"\",\"value\":\"-7\"},{\"label\":\"(GMT -06:00) Central Time (US &amp; Canada), Mexico City\",\"grouping\":\"\",\"value\":\"-6\"},{\"label\":\"(GMT -05:00) Eastern Time (US &amp; Canada), Bogota, Lima, Quito\",\"grouping\":\"\",\"value\":\"-5\"},{\"label\":\"(GMT -04:00) Atlantic Time (Canada), Caracas, La Paz\",\"grouping\":\"\",\"value\":\"-4\"},{\"label\":\"(GMT -03:30) Newfoundland\",\"grouping\":\"\",\"value\":\"-3.5\"},{\"label\":\"(GMT -03:00) Brassila, Buenos Aires, Georgetown, Falkland Is\",\"grouping\":\"\",\"value\":\"-3\"},{\"label\":\"(GMT -02:00) Mid-Atlantic, Ascension Is., St. Helena\",\"grouping\":\"\",\"value\":\"-2\"},{\"label\":\"(GMT -01:00) Azores, Cape Verde Islands\",\"grouping\":\"\",\"value\":\"-1\"},{\"label\":\"(GMT  00:00) Casablanca, Dublin, Edinburgh, London, Lisbon, Monrovia\",\"grouping\":\"\",\"value\":\"0\"},{\"label\":\"(GMT +01:00) Amsterdam, Berlin, Brussels, Madrid, Paris, Rome\",\"grouping\":\"\",\"value\":\"1\"},{\"label\":\"(GMT +02:00) Cairo, Helsinki, Kaliningrad, South Africa\",\"grouping\":\"\",\"value\":\"2\"},{\"label\":\"(GMT +03:00) Baghdad, Riyadh, Moscow, Nairobi\",\"grouping\":\"\",\"value\":\"3\"},{\"label\":\"(GMT +03:30) Tehran\",\"grouping\":\"\",\"value\":\"3.5\"},{\"label\":\"(GMT +04:00) Abu Dhabi, Baku, Muscat, Tbilisi\",\"grouping\":\"\",\"value\":\"4\"},{\"label\":\"(GMT +04:30) Kabul\",\"grouping\":\"\",\"value\":\"4.5\"},{\"label\":\"(GMT +05:00) Ekaterinburg, Islamabad, Karachi, Tashkent\",\"grouping\":\"\",\"value\":\"5\"},{\"label\":\"(GMT +05:30) Bombay, Calcutta, Madras, New Delhi\",\"grouping\":\"\",\"value\":\"5.5\"},{\"label\":\"(GMT +05:45) Katmandu\",\"grouping\":\"\",\"value\":\"5.75\"},{\"label\":\"(GMT +06:00) Almaty, Colombo, Dhaka, Novosibirsk\",\"grouping\":\"\",\"value\":\"6\"},{\"label\":\"(GMT +06:30) Rangoon\",\"grouping\":\"\",\"value\":\"6.5\"},{\"label\":\"(GMT +07:00) Bangkok, Hanoi, Jakarta\",\"grouping\":\"\",\"value\":\"7\"},{\"label\":\"(GMT +08:00) Beijing, Hong Kong, Perth, Kuala Lumpur, Singapore, Taipei\",\"grouping\":\"\",\"value\":\"8\"},{\"label\":\"(GMT +09:00) Osaka, Sapporo, Seoul, Tokyo, Yakutsk\",\"grouping\":\"\",\"value\":\"9\"},{\"label\":\"(GMT +09:30) Adelaide, Darwin\",\"grouping\":\"\",\"value\":\"9.5\"},{\"label\":\"(GMT +10:00) Canberra, Guam, Melbourne, Sydney, Vladivostok\",\"grouping\":\"\",\"value\":\"10\"},{\"label\":\"(GMT +11:00) Magadan, New Caledonia, Solomon Islands\",\"grouping\":\"\",\"value\":\"11\"},{\"label\":\"(GMT +12:00) Auckland, Wellington, Fiji, Marshall Island\",\"grouping\":\"\",\"value\":\"12\"}],\"workflowVariable\":\"\",\"id\":\"timeZone\",\"label\":\"Time zone\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"encryption\":\"\",\"readonly\":\"true\",\"size\":\"\",\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"userRoles\",\"label\":\"User Roles\",\"value\":\"ROLE_USER;\",\"readonlyLabel\":\"true\"}},{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"controlField\":\"\",\"readonly\":\"\",\"size\":\"\",\"optionsBinder\":{\"className\":\"org.joget.plugin.enterprise.GroupOptionsBinder\",\"properties\":{\"autoHandleWorkflowVariable\":\"\",\"addEmptyOption\":\"true\",\"cacheIdlePause\":\"60\",\"cacheInterval\":\"\",\"emptyLabel\":\"#i18n.Select#\",\"orgId\":\"\",\"autoHandleFiles\":\"\"}},\"validator\":{\"className\":\"\",\"properties\":{}},\"multiple\":\"\",\"options\":[],\"workflowVariable\":\"\",\"id\":\"groups\",\"label\":\"Groups\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"encryption\":\"\",\"readonly\":\"\",\"size\":\"\",\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"employeeCode\",\"label\":\"Employee code\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"encryption\":\"\",\"readonly\":\"\",\"size\":\"50\",\"maxlength\":\"\",\"validator\":{\"className\":\"\",\"properties\":{}},\"workflowVariable\":\"\",\"id\":\"jobTitle\",\"label\":\"Job title\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"controlField\":\"\",\"readonly\":\"\",\"size\":\"\",\"optionsBinder\":{\"className\":\"org.joget.plugin.enterprise.OrganizationOptionsBinder\",\"properties\":{\"autoHandleWorkflowVariable\":\"\",\"addEmptyOption\":\"true\",\"cacheIdlePause\":\"60\",\"cacheInterval\":\"\",\"emptyLabel\":\"#i18n.Select#\",\"autoHandleFiles\":\"\"}},\"validator\":{\"className\":\"\",\"properties\":{}},\"multiple\":\"\",\"options\":[],\"workflowVariable\":\"\",\"id\":\"organization\",\"label\":\"Organization\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"controlField\":\"\",\"readonly\":\"\",\"size\":\"\",\"optionsBinder\":{\"className\":\"org.joget.plugin.enterprise.DepartmentOptionsBinder\",\"properties\":{\"autoHandleWorkflowVariable\":\"\",\"addEmptyOption\":\"true\",\"cacheIdlePause\":\"60\",\"cacheInterval\":\"\",\"emptyLabel\":\"#i18n.Select#\",\"orgId\":\"\",\"autoHandleFiles\":\"\"}},\"validator\":{\"className\":\"\",\"properties\":{}},\"multiple\":\"\",\"options\":[],\"workflowVariable\":\"\",\"id\":\"department\",\"label\":\"Department\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.Radio\",\"properties\":{\"controlField\":\"\",\"readonly\":\"\",\"optionsBinder\":{\"className\":\"\",\"properties\":{}},\"validator\":{\"className\":\"\",\"properties\":{}},\"options\":[{\"label\":\"Yes\",\"grouping\":\"\",\"value\":\"1\"},{\"label\":\"No\",\"grouping\":\"\",\"value\":\"0\"}],\"workflowVariable\":\"\",\"id\":\"isHod\",\"label\":\"Is Hod?\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"controlField\":\"\",\"readonly\":\"\",\"size\":\"\",\"optionsBinder\":{\"className\":\"org.joget.plugin.enterprise.GradeOptionsBinder\",\"properties\":{\"autoHandleWorkflowVariable\":\"\",\"addEmptyOption\":\"true\",\"cacheIdlePause\":\"60\",\"cacheInterval\":\"\",\"emptyLabel\":\"#i18n.Select#\",\"orgId\":\"\",\"autoHandleFiles\":\"\"}},\"validator\":{\"className\":\"\",\"properties\":{}},\"multiple\":\"\",\"options\":[],\"workflowVariable\":\"\",\"id\":\"grade\",\"label\":\"Grade\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.DatePicker\",\"properties\":{\"yearRange\":\"c-10:c+10\",\"startDateFieldId\":\"\",\"dataFormat\":\"yyyy-MM-dd\",\"validator\":{\"className\":\"\",\"properties\":{}},\"format\":\"dd-mm-yy\",\"label\":\"Employment start date\",\"currentDateAs\":\"\",\"endDateFieldId\":\"\",\"readonly\":\"\",\"allowManual\":\"\",\"workflowVariable\":\"\",\"id\":\"startDate\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.DatePicker\",\"properties\":{\"yearRange\":\"c-10:c+10\",\"startDateFieldId\":\"\",\"dataFormat\":\"yyyy-MM-dd\",\"validator\":{\"className\":\"\",\"properties\":{}},\"format\":\"dd-mm-yy\",\"label\":\"Employment end date\",\"currentDateAs\":\"\",\"endDateFieldId\":\"\",\"readonly\":\"\",\"allowManual\":\"\",\"workflowVariable\":\"\",\"id\":\"endDate\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"controlField\":\"\",\"readonly\":\"\",\"size\":\"\",\"optionsBinder\":{\"className\":\"org.joget.plugin.enterprise.UserOptionsBinder\",\"properties\":{\"orgId\":\"\",\"deptId\":\"\",\"groupId\":\"\",\"addEmptyOption\":\"true\",\"emptyLabel\":\"#i18n.Select#\",\"optionLabel\":\"\",\"grouping\":\"\",\"useAjax\":\"\",\"cacheInterval\":\"\",\"cacheIdlePause\":\"60\",\"autoHandleWorkflowVariable\":\"\",\"autoHandleFiles\":\"\"}},\"validator\":{\"className\":\"\",\"properties\":{}},\"multiple\":\"\",\"options\":[],\"workflowVariable\":\"\",\"id\":\"reportTo\",\"label\":\"Report to\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.CustomHTML\",\"properties\":{\"autoPopulate\":\"\",\"id\":\"field20\",\"label\":\"\",\"value\":\"<!---\\r\\n\\r\\n<script>\\r\\n    if (\'#requestParam.id#\' === \'admin\' || \'requestParam.id\' === \'Admin\') {\\r\\n        document.location.href = \'\\/jw\\/web\\/userview\\/v6_um\\/v6_um\\/_\\/suser\';\\r\\n    }\\r\\n<\\/script>\\r\\n\\r\\n--->\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"100%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"section1\",\"label\":\"Joget User Setup\",\"storeBinder\":{\"className\":\"\",\"properties\":{}}}}]}',NULL),
('dashboard',1,'user_approval','User Approval Form','2024-04-19 13:40:06','2024-04-19 13:40:06','j_user_register','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"name\":\"User Approval Form\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"user_approval\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"tableName\":\"j_user_register\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.SubForm\",\"properties\":{\"parentSubFormId\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":\"{}\"},\"readonly\":\"true\",\"formDefId\":\"user_registration\",\"elementUniqueKey\":\"551\",\"subFormParentId\":\"\",\"id\":\"registration\",\"label\":\"\",\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":\"{}\"},\"readonlyLabel\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"elementUniqueKey\":\"498\",\"width\":\"99%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"\",\"regex\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":\"{}\"},\"elementUniqueKey\":\"494\",\"id\":\"section1\",\"label\":\"\",\"storeBinder\":{\"className\":\"\",\"properties\":\"{}\"},\"visibilityValue\":\"\"}},{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.SelectBox\",\"properties\":{\"id\":\"status\",\"label\":\"Status\",\"options\":[{\"value\":\"Approved\",\"label\":\"Approved\",\"grouping\":\"\"},{\"value\":\"Rejected\",\"label\":\"Rejected\",\"grouping\":\"\"}],\"optionsBinder\":{\"className\":\"\",\"properties\":{}},\"value\":\"\",\"multiple\":\"\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"mandatory\":\"true\",\"type\":\"\",\"custom-regex\":\"\",\"message\":\"\"}},\"controlField\":\"\",\"size\":\"\",\"readonly\":\"\",\"readonlyLabel\":\"\",\"workflowVariable\":\"status\"}},{\"className\":\"org.joget.apps.form.lib.TextArea\",\"properties\":{\"readonly\":\"\",\"elementUniqueKey\":\"511\",\"validator\":{\"className\":\"\",\"properties\":\"{}\"},\"workflowVariable\":\"\",\"id\":\"comments\",\"label\":\"Comments\",\"rows\":\"5\",\"cols\":\"20\",\"value\":\"\",\"readonlyLabel\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"elementUniqueKey\":\"507\",\"width\":\"99%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"\",\"regex\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":\"{}\"},\"elementUniqueKey\":\"501\",\"id\":\"section2\",\"label\":\"Approval Section\",\"storeBinder\":{\"className\":\"\",\"properties\":\"{}\"},\"visibilityValue\":\"\"}}]}',NULL),
('dashboard',1,'user_creation','User Creation Form','2024-04-19 13:40:06','2024-04-19 13:40:06','j_user_register','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"id\":\"user_creation\",\"name\":\"User Creation Form\",\"tableName\":\"j_user_register\",\"description\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"permission\":{\"className\":\"\",\"properties\":{}},\"noPermissionMessage\":\"\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"postProcessorRunOn\":\"both\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.CustomHTML\",\"properties\":{\"elementUniqueKey\":\"1859\",\"validator\":{\"className\":\"\",\"properties\":\"{}\"},\"id\":\"field2\",\"label\":\"\",\"value\":\"User registration approved, please verify the user and login details below, and click on <b>Complete</b> to finish the user registration process.\"}},{\"className\":\"org.joget.apps.form.lib.SubForm\",\"properties\":{\"parentSubFormId\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":\"{}\"},\"readonly\":\"\",\"formDefId\":\"user_registration\",\"elementUniqueKey\":\"1312\",\"subFormParentId\":\"\",\"id\":\"field1\",\"label\":\"\",\"storeBinder\":{\"className\":\"org.joget.plugin.enterprise.DirectoryUserFormBinder\",\"properties\":\"{}\"},\"readonlyLabel\":\"\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"width\":\"99%\"}}],\"className\":\"org.joget.apps.form.model.Section\",\"properties\":{\"visibilityControl\":\"\",\"regex\":\"\",\"loadBinder\":{\"className\":\"\",\"properties\":{}},\"id\":\"section1\",\"label\":\"Confirmation\",\"storeBinder\":{\"className\":\"\",\"properties\":{}},\"visibilityValue\":\"\"}}]}',NULL),
('dashboard',1,'user_registration','User Registration Form','2024-04-19 13:40:06','2024-04-19 13:40:06','j_user_register','{\"className\":\"org.joget.apps.form.model.Form\",\"properties\":{\"noPermissionMessage\":\"\",\"loadBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"name\":\"User Registration Form\",\"description\":\"\",\"postProcessorRunOn\":\"both\",\"permission\":{\"className\":\"\",\"properties\":{}},\"id\":\"user_registration\",\"postProcessor\":{\"className\":\"\",\"properties\":{}},\"storeBinder\":{\"className\":\"org.joget.apps.form.lib.WorkflowFormBinder\",\"properties\":{}},\"tableName\":\"j_user_register\"},\"elements\":[{\"elements\":[{\"elements\":[{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"readonly\":\"\",\"size\":\"\",\"maxlength\":\"\",\"elementUniqueKey\":\"142\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"custom-regex\":\"\",\"message\":\"\",\"type\":\"\",\"mandatory\":\"true\"}},\"workflowVariable\":\"\",\"id\":\"firstName\",\"label\":\"First Name\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"readonly\":\"\",\"size\":\"\",\"maxlength\":\"\",\"elementUniqueKey\":\"143\",\"validator\":{\"className\":\"\",\"properties\":\"{}\"},\"workflowVariable\":\"\",\"id\":\"lastName\",\"label\":\"Last Name\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.TextField\",\"properties\":{\"readonly\":\"\",\"size\":\"\",\"maxlength\":\"\",\"elementUniqueKey\":\"144\",\"validator\":{\"className\":\"org.joget.apps.form.lib.DefaultValidator\",\"properties\":{\"custom-regex\":\"\",\"message\":\"\",\"type\":\"email\",\"mandatory\":\"true\"}},\"workflowVariable\":\"\",\"id\":\"email\",\"label\":\"Email\",\"value\":\"\",\"readonlyLabel\":\"\"}},{\"className\":\"org.joget.apps.form.lib.HiddenField\",\"properties\":{\"id\":\"status\",\"value\":\"Pending\",\"useDefaultWhenEmpty\":\"\",\"workflowVariable\":\"status\"}}],\"className\":\"org.joget.apps.form.model.Column\",\"properties\":{\"elementUniqueKey\":\"138\",\"width\":\"99%\"}}],\"className\":\"o