/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.bytecode.api.ThreadContextThreadLocal;
import org.glowroot.agent.impl.NopTransactionService;
import org.glowroot.agent.impl.ThreadContextImpl;
import org.glowroot.agent.impl.TraceEntryImpl;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.impl.TransactionRegistry;
import org.glowroot.agent.impl.TransactionService;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.Checkers;

class AuxThreadContextImpl
implements AuxThreadContext {
    private static final Logger logger = LoggerFactory.getLogger(AuxThreadContextImpl.class);
    static final ThreadLocal<Boolean> inAuxDebugLogging = new ThreadLocal();
    private final Transaction transaction;
    private final @Nullable TraceEntryImpl parentTraceEntry;
    private final @Nullable TraceEntryImpl parentThreadContextPriorEntry;
    private final  @Nullable ThreadContext.ServletRequestInfo servletRequestInfo;
    private final @Nullable ImmutableList<StackTraceElement> locationStackTrace;
    private final TransactionRegistry transactionRegistry;
    private final TransactionService transactionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AuxThreadContextImpl(Transaction transaction, @Nullable TraceEntryImpl parentTraceEntry, @Nullable TraceEntryImpl parentThreadContextPriorEntry,  @Nullable ThreadContext.ServletRequestInfo servletRequestInfo, @Nullable ImmutableList<StackTraceElement> locationStackTrace, TransactionRegistry transactionRegistry, TransactionService transactionService) {
        this.transaction = transaction;
        this.parentTraceEntry = parentTraceEntry;
        this.parentThreadContextPriorEntry = parentThreadContextPriorEntry;
        this.servletRequestInfo = servletRequestInfo;
        this.locationStackTrace = locationStackTrace;
        this.transactionRegistry = transactionRegistry;
        this.transactionService = transactionService;
        if (logger.isDebugEnabled() && !Thread.currentThread().getName().startsWith("Glowroot-GRPC-") && inAuxDebugLogging.get() == null) {
            inAuxDebugLogging.set(Boolean.TRUE);
            try {
                logger.debug("new AUX thread context: {}, parent thread context: {}, thread name: {}", Checkers.castInitialized(this).hashCode(), AuxThreadContextImpl.getThreadContextDisplay(parentTraceEntry), Thread.currentThread().getName(), new Exception());
            }
            finally {
                inAuxDebugLogging.remove();
            }
        }
    }

    @Override
    public TraceEntry start() {
        return this.start(false);
    }

    @Override
    public TraceEntry startAndMarkAsyncTransactionComplete() {
        return this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TraceEntry start(boolean completeAsyncTransaction) {
        ThreadContextThreadLocal.Holder threadContextHolder = this.transactionRegistry.getCurrentThreadContextHolder();
        ThreadContextImpl context = (ThreadContextImpl)threadContextHolder.get();
        if (context != null) {
            if (completeAsyncTransaction) {
                context.setTransactionAsyncComplete();
            }
            return NopTransactionService.TRACE_ENTRY;
        }
        context = this.transactionService.startAuxThreadContextInternal(this.transaction, this.parentTraceEntry, this.parentThreadContextPriorEntry, this.servletRequestInfo, threadContextHolder);
        if (context == null) {
            return NopTransactionService.TRACE_ENTRY;
        }
        if (logger.isDebugEnabled() && !Thread.currentThread().getName().startsWith("Glowroot-GRPC-") && inAuxDebugLogging.get() == null) {
            inAuxDebugLogging.set(Boolean.TRUE);
            try {
                logger.debug("start AUX thread context: {}, thread context: {}, parent thread context: {}, thread name: {}", this.hashCode(), context.hashCode(), AuxThreadContextImpl.getThreadContextDisplay(this.parentTraceEntry), Thread.currentThread().getName(), new Exception());
            }
            finally {
                inAuxDebugLogging.remove();
            }
        }
        if (completeAsyncTransaction) {
            context.setTransactionAsyncComplete();
        }
        TraceEntryImpl rootEntry = context.getRootEntry();
        if (this.locationStackTrace != null) {
            rootEntry.setLocationStackTrace(this.locationStackTrace);
        }
        return rootEntry;
    }

    private static Object getThreadContextDisplay(@Nullable TraceEntryImpl parentTraceEntry) {
        if (parentTraceEntry == null) {
            return "null (aux thread context limit exceeded)";
        }
        return parentTraceEntry.getThreadContext().hashCode();
    }
}

