/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.impl.AggregateIntervalCollector;
import org.glowroot.agent.impl.TraceCollector;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Queues;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.RateLimitedLogger;
import org.glowroot.agent.util.ThreadFactories;

public class TransactionProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TransactionProcessor.class);
    private static final int TRANSACTION_PENDING_LIMIT = 1000;
    private static final int AGGREGATE_PENDING_LIMIT = 5;
    final Object monitor = new Object();
    private volatile AggregateIntervalCollector activeIntervalCollector;
    private final BlockingQueue<AggregateIntervalCollector> pendingIntervalCollectors = Queues.newLinkedBlockingQueue(5);
    private final ExecutorService processingExecutor;
    private final ExecutorService flushingExecutor;
    private final Collector collector;
    private final TraceCollector traceCollector;
    private final ConfigService configService;
    private final Clock clock;
    private final long aggregateIntervalMillis;
    private final PendingTransaction head;
    @GuardedBy(value="queueLock")
    private PendingTransaction tail = this.head = new PendingTransaction(null);
    @GuardedBy(value="queueLock")
    private int queueLength;
    private final Object queueLock = new Object();
    private final RateLimitedLogger backPressureLogger = new RateLimitedLogger(TransactionProcessor.class);
    private volatile boolean closed;

    public TransactionProcessor(Collector collector, TraceCollector traceCollector, ConfigService configService, long aggregateIntervalMillis, Clock clock) {
        this.collector = collector;
        this.traceCollector = traceCollector;
        this.configService = configService;
        this.clock = clock;
        this.aggregateIntervalMillis = aggregateIntervalMillis;
        this.processingExecutor = Executors.newFixedThreadPool(1, ThreadFactories.create("Glowroot-Aggregate-Processing"));
        this.flushingExecutor = Executors.newFixedThreadPool(1, ThreadFactories.create("Glowroot-Aggregate-Flushing"));
        this.activeIntervalCollector = new AggregateIntervalCollector(clock.currentTimeMillis(), aggregateIntervalMillis, configService.getAdvancedConfig().maxTransactionAggregates(), configService.getAdvancedConfig().maxQueryAggregates(), configService.getAdvancedConfig().maxServiceCallAggregates(), clock);
        this.processingExecutor.execute(new TransactionProcessorLoop());
        this.flushingExecutor.execute(new AggregateFlushingLoop());
    }

    public Set<String> getTransactionTypes() {
        HashSet<String> transactionTypes = Sets.newHashSet();
        transactionTypes.addAll(this.activeIntervalCollector.getTransactionTypes());
        for (AggregateIntervalCollector intervalCollector : this.pendingIntervalCollectors) {
            transactionTypes.addAll(intervalCollector.getTransactionTypes());
        }
        return transactionTypes;
    }

    public List<AggregateIntervalCollector> getOrderedIntervalCollectorsInRange(long from, long to) {
        ArrayList<AggregateIntervalCollector> intervalCollectors = Lists.newArrayList();
        for (AggregateIntervalCollector intervalCollector : this.getOrderedAllIntervalCollectors()) {
            long captureTime = intervalCollector.getCaptureTime();
            if (captureTime <= from || captureTime > to) continue;
            intervalCollectors.add(intervalCollector);
        }
        return intervalCollectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInMemoryData() {
        this.activeIntervalCollector.clear();
        BlockingQueue<AggregateIntervalCollector> blockingQueue = this.pendingIntervalCollectors;
        synchronized (blockingQueue) {
            this.pendingIntervalCollectors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processOnCompletion(Transaction transaction) {
        PendingTransaction newTail = new PendingTransaction(transaction);
        boolean exceededLimit = false;
        Object object = this.queueLock;
        synchronized (object) {
            if (this.queueLength < 1000) {
                newTail.captureTime = this.clock.currentTimeMillis();
                this.tail.next = newTail;
                this.tail = newTail;
                ++this.queueLength;
                Object object2 = this.monitor;
                synchronized (object2) {
                    this.monitor.notifyAll();
                }
            } else {
                exceededLimit = true;
            }
        }
        if (exceededLimit) {
            this.backPressureLogger.warn("not capturing a transaction because of an excessive backlog of {} transactions already waiting to be captured", 1000);
            transaction.setCaptureTime(this.clock.currentTimeMillis());
            transaction.removeFromActiveTransactions();
        }
    }

    private List<AggregateIntervalCollector> getOrderedAllIntervalCollectors() {
        AggregateIntervalCollector activeIntervalCollector = this.activeIntervalCollector;
        ArrayList<AggregateIntervalCollector> intervalCollectors = Lists.newArrayList(this.pendingIntervalCollectors);
        if (intervalCollectors.isEmpty()) {
            return ImmutableList.of(activeIntervalCollector);
        }
        if (!intervalCollectors.contains(activeIntervalCollector)) {
            intervalCollectors.add(activeIntervalCollector);
            return intervalCollectors;
        }
        return intervalCollectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyUsedByTests
    public void close() throws InterruptedException {
        this.closed = true;
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
        this.processingExecutor.shutdown();
        if (!this.processingExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Could not terminate executor");
        }
        this.flushingExecutor.shutdownNow();
        if (!this.flushingExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Could not terminate executor");
        }
    }

    private static class PendingTransaction {
        private final @Nullable Transaction transaction;
        private volatile long captureTime;
        private volatile @Nullable PendingTransaction next;

        private PendingTransaction(@Nullable Transaction transaction) {
            this.transaction = transaction;
        }
    }

    private class AggregateFlushingLoop
    implements Runnable {
        private AggregateFlushingLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!TransactionProcessor.this.closed) {
                try {
                    AggregateIntervalCollector intervalCollector;
                    BlockingQueue blockingQueue = TransactionProcessor.this.pendingIntervalCollectors;
                    synchronized (blockingQueue) {
                        if (TransactionProcessor.this.pendingIntervalCollectors.peek() == null) {
                            TransactionProcessor.this.pendingIntervalCollectors.wait();
                            continue;
                        }
                        intervalCollector = (AggregateIntervalCollector)TransactionProcessor.this.pendingIntervalCollectors.remove();
                    }
                    intervalCollector.flush(TransactionProcessor.this.collector);
                }
                catch (InterruptedException e) {
                    logger.debug(e.getMessage(), e);
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    private class TransactionProcessorLoop
    implements Runnable {
        private TransactionProcessorLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!TransactionProcessor.this.closed) {
                try {
                    boolean hasNext = this.processOne();
                    if (hasNext) continue;
                    Object object = TransactionProcessor.this.monitor;
                    synchronized (object) {
                        TransactionProcessor.this.monitor.wait(Math.min(100L, TransactionProcessor.this.aggregateIntervalMillis));
                    }
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processOne() {
            PendingTransaction pendingTransaction = TransactionProcessor.this.head.next;
            if (pendingTransaction == null) {
                if (TransactionProcessor.this.clock.currentTimeMillis() > TransactionProcessor.this.activeIntervalCollector.getCaptureTime()) {
                    this.maybeEndOfInterval();
                }
                return false;
            }
            Transaction transaction = Preconditions.checkNotNull(pendingTransaction.transaction);
            transaction.setCaptureTime(pendingTransaction.captureTime);
            TransactionProcessor.this.traceCollector.collectTrace(transaction);
            transaction.removeFromActiveTransactions();
            boolean hasNext = false;
            Object object = TransactionProcessor.this.queueLock;
            synchronized (object) {
                PendingTransaction next = pendingTransaction.next;
                TransactionProcessor.this.head.next = next;
                if (next == null) {
                    TransactionProcessor.this.tail = TransactionProcessor.this.head;
                } else {
                    hasNext = true;
                }
                TransactionProcessor.this.queueLength--;
            }
            if (pendingTransaction.captureTime > TransactionProcessor.this.activeIntervalCollector.getCaptureTime()) {
                this.flushAndResetActiveIntervalCollector(pendingTransaction.captureTime);
            }
            TransactionProcessor.this.activeIntervalCollector.add(transaction);
            return hasNext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeEndOfInterval() {
            boolean safeToFlush;
            long currentTime;
            Object object = TransactionProcessor.this.queueLock;
            synchronized (object) {
                if (TransactionProcessor.this.head.next != null) {
                    return;
                }
                currentTime = TransactionProcessor.this.clock.currentTimeMillis();
                safeToFlush = currentTime > TransactionProcessor.this.activeIntervalCollector.getCaptureTime();
            }
            if (safeToFlush) {
                this.flushAndResetActiveIntervalCollector(currentTime);
            }
        }

        private void flushAndResetActiveIntervalCollector(long currentTime) {
            this.flushActiveIntervalCollector();
            TransactionProcessor.this.activeIntervalCollector = new AggregateIntervalCollector(currentTime, TransactionProcessor.this.aggregateIntervalMillis, TransactionProcessor.this.configService.getAdvancedConfig().maxTransactionAggregates(), TransactionProcessor.this.configService.getAdvancedConfig().maxQueryAggregates(), TransactionProcessor.this.configService.getAdvancedConfig().maxServiceCallAggregates(), TransactionProcessor.this.clock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushActiveIntervalCollector() {
            boolean accepted;
            BlockingQueue blockingQueue = TransactionProcessor.this.pendingIntervalCollectors;
            synchronized (blockingQueue) {
                accepted = TransactionProcessor.this.pendingIntervalCollectors.offer(TransactionProcessor.this.activeIntervalCollector);
                if (accepted) {
                    TransactionProcessor.this.pendingIntervalCollectors.notifyAll();
                }
            }
            if (!accepted) {
                logger.warn("not storing an aggregate because of an excessive backlog of {} aggregates already waiting to be stored", (Object)5);
            }
        }
    }
}

