/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.init;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.live.LiveJvmServiceImpl;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.StandardSystemProperty;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.org.glowroot.common.config.JvmConfig;
import org.glowroot.agent.shaded.org.glowroot.common.util.Masking;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class EnvironmentCreator {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentCreator.class);

    private EnvironmentCreator() {
    }

    public static CollectorServiceOuterClass.InitMessage.Environment create(String glowrootVersion, JvmConfig jvmConfig) {
        CollectorServiceOuterClass.InitMessage.Environment.HostInfo hostInfo = EnvironmentCreator.createHostInfo();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        CollectorServiceOuterClass.InitMessage.Environment.ProcessInfo processInfo = EnvironmentCreator.createProcessInfo(runtimeMXBean);
        CollectorServiceOuterClass.InitMessage.Environment.JavaInfo javaInfo = EnvironmentCreator.createJavaInfo(glowrootVersion, jvmConfig, runtimeMXBean);
        return CollectorServiceOuterClass.InitMessage.Environment.newBuilder().setHostInfo(hostInfo).setProcessInfo(processInfo).setJavaInfo(javaInfo).build();
    }

    private static CollectorServiceOuterClass.InitMessage.Environment.HostInfo createHostInfo() {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        CollectorServiceOuterClass.InitMessage.Environment.HostInfo.Builder hostInfo = CollectorServiceOuterClass.InitMessage.Environment.HostInfo.newBuilder();
        try {
            hostInfo.setHostname(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            logger.warn(e.getMessage(), e);
        }
        hostInfo.setAvailableProcessors(operatingSystemMXBean.getAvailableProcessors());
        Long totalPhysicalMemoryBytes = EnvironmentCreator.getTotalPhysicalMemoryBytes(operatingSystemMXBean);
        if (totalPhysicalMemoryBytes != null) {
            hostInfo.setTotalPhysicalMemoryBytes(Proto.OptionalInt64.newBuilder().setValue(totalPhysicalMemoryBytes));
        }
        return hostInfo.setOsName(operatingSystemMXBean.getName()).setOsVersion(operatingSystemMXBean.getVersion()).build();
    }

    private static CollectorServiceOuterClass.InitMessage.Environment.ProcessInfo createProcessInfo(RuntimeMXBean runtimeMXBean) {
        Long processId = LiveJvmServiceImpl.getProcessId();
        CollectorServiceOuterClass.InitMessage.Environment.ProcessInfo.Builder processInfo = CollectorServiceOuterClass.InitMessage.Environment.ProcessInfo.newBuilder();
        if (processId != null) {
            processInfo.setProcessId(Proto.OptionalInt64.newBuilder().setValue(processId).build());
        }
        processInfo.setStartTime(runtimeMXBean.getStartTime());
        return processInfo.build();
    }

    private static CollectorServiceOuterClass.InitMessage.Environment.JavaInfo createJavaInfo(String glowrootVersion, JvmConfig jvmConfig, RuntimeMXBean runtimeMXBean) {
        String jvm = "";
        String javaVmName = StandardSystemProperty.JAVA_VM_NAME.value();
        if (javaVmName != null) {
            jvm = javaVmName + " (" + StandardSystemProperty.JAVA_VM_VERSION.value() + ", " + System.getProperty("java.vm.info") + ")";
        }
        String javaVersion = StandardSystemProperty.JAVA_VERSION.value();
        String heapDumpPath = EnvironmentCreator.getHeapDumpPathFromCommandLine();
        if (heapDumpPath == null) {
            String javaTempDir = MoreObjects.firstNonNull(StandardSystemProperty.JAVA_IO_TMPDIR.value(), ".");
            heapDumpPath = new File(javaTempDir).getAbsolutePath();
        }
        return CollectorServiceOuterClass.InitMessage.Environment.JavaInfo.newBuilder().setVersion(Strings.nullToEmpty(javaVersion)).setVm(jvm).addAllArg(Masking.maskJvmArgs(runtimeMXBean.getInputArguments(), jvmConfig.maskSystemProperties())).setHeapDumpDefaultDir(heapDumpPath).setGlowrootAgentVersion(glowrootVersion).build();
    }

    static @Nullable Long getTotalPhysicalMemoryBytes(OperatingSystemMXBean operatingSystemMXBean) {
        Method method;
        Class<?> sunClass;
        try {
            sunClass = Class.forName("com.sun.management.OperatingSystemMXBean");
        }
        catch (ClassNotFoundException e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
        try {
            method = sunClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
        }
        catch (SecurityException e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
        catch (NoSuchMethodException e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
        method.setAccessible(true);
        try {
            return (Long)method.invoke((Object)operatingSystemMXBean, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
    }

    private static @Nullable String getHeapDumpPathFromCommandLine() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        for (String arg : runtimeMXBean.getInputArguments()) {
            if (!arg.startsWith("-XX:HeapDumpPath=")) continue;
            return arg.substring("-XX:HeapDumpPath=".length());
        }
        return null;
    }
}

