/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.init;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.impl.TraceCollector;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.impl.TransactionRegistry;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.org.glowroot.common.util.ScheduledRunnable;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.Tickers;

class ImmediateTraceStoreWatcher
extends ScheduledRunnable {
    private static final Logger logger = LoggerFactory.getLogger(ImmediateTraceStoreWatcher.class);
    static final int PERIOD_MILLIS = 1000;
    private final ScheduledExecutorService backgroundExecutor;
    private final TransactionRegistry transactionRegistry;
    private final TraceCollector traceCollector;
    private final ConfigService configService;
    private final Ticker ticker;

    ImmediateTraceStoreWatcher(ScheduledExecutorService backgroundExecutor, TransactionRegistry transactionRegistry, TraceCollector traceCollector, ConfigService configService, Ticker ticker) {
        this.backgroundExecutor = backgroundExecutor;
        this.transactionRegistry = transactionRegistry;
        this.traceCollector = traceCollector;
        this.configService = configService;
        this.ticker = ticker;
    }

    @Override
    protected void runInternal() {
        int immediatePartialStoreThresholdSeconds = this.configService.getAdvancedConfig().immediatePartialStoreThresholdSeconds();
        if (immediatePartialStoreThresholdSeconds == 0) {
            return;
        }
        long immediatePartialStoreTick = this.ticker.read() - TimeUnit.SECONDS.toNanos(immediatePartialStoreThresholdSeconds) + TimeUnit.MILLISECONDS.toNanos(1000L);
        for (Transaction transaction : this.transactionRegistry.getTransactions()) {
            if (!Tickers.lessThanOrEqual(transaction.getStartTick(), immediatePartialStoreTick) || transaction.getImmedateTraceStoreRunnable() != null) continue;
            long initialDelayMillis = Math.max(0L, TimeUnit.SECONDS.toMillis(immediatePartialStoreThresholdSeconds) - TimeUnit.NANOSECONDS.toMillis(transaction.getDurationNanos()));
            ImmediateTraceStoreRunnable immediateTraceStoreRunnable = new ImmediateTraceStoreRunnable(transaction, this.traceCollector);
            immediateTraceStoreRunnable.scheduleWithFixedDelay(this.backgroundExecutor, initialDelayMillis, TimeUnit.SECONDS.toMillis(immediatePartialStoreThresholdSeconds), TimeUnit.MILLISECONDS);
            transaction.setImmediateTraceStoreRunnable(immediateTraceStoreRunnable);
        }
    }

    static class ImmediateTraceStoreRunnable
    extends ScheduledRunnable {
        private final Transaction transaction;
        private final TraceCollector traceCollector;
        private volatile boolean transactionPreviouslyCompleted;

        ImmediateTraceStoreRunnable(Transaction transaction, TraceCollector traceCollector) {
            this.transaction = transaction;
            this.traceCollector = traceCollector;
        }

        @Override
        public void runInternal() {
            logger.debug("run(): trace.id={}", (Object)this.transaction.getTraceId());
            if (this.transaction.isCompleted()) {
                if (this.transactionPreviouslyCompleted) {
                    throw new ScheduledRunnable.TerminateSubsequentExecutionsException();
                }
                this.transactionPreviouslyCompleted = true;
                return;
            }
            if (this.traceCollector.shouldStoreSlow(this.transaction)) {
                this.traceCollector.storePartialTrace(this.transaction);
            }
        }
    }
}

