/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.cassandra;

import org.glowroot.agent.plugin.api.AsyncQueryEntry;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.IsEnabled;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.cassandra.ResultSetAspect;

public class ResultSetFutureAspect {

    @Pointcut(className="com.google.common.util.concurrent.AbstractFuture", subTypeRestriction="com.datastax.driver.core.DefaultResultSetFuture", methodName="set", methodParameterTypes={"java.lang.Object"})
    public static class FutureSetAdvice {
        @OnBefore
        public static void onBefore(@BindReceiver ResultSetFutureMixin resultSetFuture) {
            resultSetFuture.glowroot$setCompleted();
            AsyncQueryEntry asyncQueryEntry = resultSetFuture.glowroot$getAsyncQueryEntry();
            if (asyncQueryEntry != null) {
                asyncQueryEntry.end();
            }
        }
    }

    @Pointcut(className="com.google.common.util.concurrent.AbstractFuture", subTypeRestriction="com.datastax.driver.core.DefaultResultSetFuture", methodName="setException", methodParameterTypes={"java.lang.Throwable"})
    public static class FutureSetExceptionAdvice {
        @OnBefore
        public static void onBefore(@BindReceiver ResultSetFutureMixin resultSetFuture, @BindParameter @Nullable Throwable t) {
            if (t == null) {
                return;
            }
            resultSetFuture.glowroot$setCompleted();
            resultSetFuture.glowroot$setException(t);
            AsyncQueryEntry asyncQueryEntry = resultSetFuture.glowroot$getAsyncQueryEntry();
            if (asyncQueryEntry != null) {
                asyncQueryEntry.endWithError(t);
            }
        }
    }

    @Pointcut(className="com.datastax.driver.core.ResultSetFuture", methodName="getUninterruptibly", methodParameterTypes={".."})
    public static class FutureGetUninterruptiblyAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver ResultSetFutureMixin resultSetFuture) {
            return FutureGetAdvice.isEnabled(resultSetFuture);
        }

        @OnBefore
        public static Timer onBefore(ThreadContext threadContext, @BindReceiver ResultSetFutureMixin resultSetFuture) {
            return FutureGetAdvice.onBefore(threadContext, resultSetFuture);
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable ResultSetAspect.ResultSetMixin resultSet, @BindReceiver ResultSetFutureMixin resultSetFuture) {
            FutureGetAdvice.onReturn(resultSet, resultSetFuture);
        }

        @OnAfter
        public static void onAfter(@BindTraveler Timer timer) {
            FutureGetAdvice.onAfter(timer);
        }
    }

    @Pointcut(className="java.util.concurrent.Future", subTypeRestriction="com.datastax.driver.core.ResultSetFuture", methodName="get", methodParameterTypes={".."}, suppressionKey="wait-on-future")
    public static class FutureGetAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver ResultSetFutureMixin resultSetFuture) {
            return resultSetFuture.glowroot$getAsyncQueryEntry() != null;
        }

        @OnBefore
        public static Timer onBefore(ThreadContext threadContext, @BindReceiver ResultSetFutureMixin resultSetFuture) {
            AsyncQueryEntry asyncQueryEntry = resultSetFuture.glowroot$getAsyncQueryEntry();
            return asyncQueryEntry.extendSyncTimer(threadContext);
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable ResultSetAspect.ResultSetMixin resultSet, @BindReceiver ResultSetFutureMixin resultSetFuture) {
            if (resultSet == null) {
                return;
            }
            AsyncQueryEntry asyncQueryEntry = resultSetFuture.glowroot$getAsyncQueryEntry();
            resultSet.glowroot$setQueryEntry(asyncQueryEntry);
        }

        @OnAfter
        public static void onAfter(@BindTraveler Timer timer) {
            timer.stop();
        }
    }

    public static interface ResultSetFutureMixin {
        public void glowroot$setCompleted();

        public boolean glowroot$isCompleted();

        public void glowroot$setException(Throwable var1);

        @Nullable
        public Throwable glowroot$getException();

        @Nullable
        public AsyncQueryEntry glowroot$getAsyncQueryEntry();

        public void glowroot$setAsyncQueryEntry(@Nullable AsyncQueryEntry var1);
    }

    @Mixin(value={"com.datastax.driver.core.ResultSetFuture"})
    public static class ResultSetFutureImpl
    implements ResultSetFutureMixin {
        private volatile transient boolean glowroot$completed;
        @Nullable
        private volatile transient Throwable glowroot$exception;
        @Nullable
        private volatile transient AsyncQueryEntry glowroot$asyncQueryEntry;

        @Override
        public void glowroot$setCompleted() {
            this.glowroot$completed = true;
        }

        @Override
        public boolean glowroot$isCompleted() {
            return this.glowroot$completed;
        }

        @Override
        public void glowroot$setException(Throwable exception) {
            this.glowroot$exception = exception;
        }

        @Override
        @Nullable
        public Throwable glowroot$getException() {
            return this.glowroot$exception;
        }

        @Override
        @Nullable
        public AsyncQueryEntry glowroot$getAsyncQueryEntry() {
            return this.glowroot$asyncQueryEntry;
        }

        @Override
        public void glowroot$setAsyncQueryEntry(@Nullable AsyncQueryEntry asyncQueryEntry) {
            this.glowroot$asyncQueryEntry = asyncQueryEntry;
        }
    }
}

