/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.httpclient;

import org.apache.http.concurrent.FutureCallback;
import org.glowroot.agent.plugin.api.AsyncTraceEntry;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.TraceEntry;

public class FutureCallbackWrapper<T>
implements FutureCallback<T> {
    private final FutureCallback<T> delegate;
    private final AsyncTraceEntry asyncTraceEntry;
    private final AuxThreadContext auxContext;

    public FutureCallbackWrapper(FutureCallback<T> delegate, AsyncTraceEntry asyncTraceEntry, AuxThreadContext auxContext) {
        this.delegate = delegate;
        this.asyncTraceEntry = asyncTraceEntry;
        this.auxContext = auxContext;
    }

    public void completed(T result) {
        this.asyncTraceEntry.end();
        TraceEntry traceEntry = this.auxContext.start();
        try {
            this.delegate.completed(result);
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw FutureCallbackWrapper.rethrow(t);
        }
        traceEntry.end();
    }

    public void failed(Exception exception) {
        this.asyncTraceEntry.endWithError(exception);
        TraceEntry traceEntry = this.auxContext.start();
        try {
            this.delegate.failed(exception);
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw FutureCallbackWrapper.rethrow(t);
        }
        traceEntry.end();
    }

    public void cancelled() {
        this.asyncTraceEntry.end();
        TraceEntry traceEntry = this.auxContext.start();
        try {
            this.delegate.cancelled();
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw FutureCallbackWrapper.rethrow(t);
        }
        traceEntry.end();
    }

    private static RuntimeException rethrow(Throwable t) {
        FutureCallbackWrapper.throwsUnchecked(t);
        throw new AssertionError();
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }
}

