/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.google.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.io.ByteSink;
import org.glowroot.agent.shaded.com.google.common.io.ByteStreams;
import org.glowroot.agent.shaded.com.google.common.io.CharSource;
import org.glowroot.agent.shaded.com.google.common.io.Closer;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;

public abstract class ByteSource {
    protected ByteSource() {
    }

    public CharSource asCharSource(Charset charset) {
        return new AsCharSource(charset);
    }

    public abstract InputStream openStream() throws IOException;

    public Optional<Long> sizeIfKnown() {
        return Optional.absent();
    }

    @CanIgnoreReturnValue
    public long copyTo(OutputStream output) throws IOException {
        Preconditions.checkNotNull(output);
        try (Closer closer = Closer.create();){
            InputStream in = closer.register(this.openStream());
            long l = ByteStreams.copy(in, output);
            return l;
        }
    }

    @CanIgnoreReturnValue
    public long copyTo(ByteSink sink) throws IOException {
        Preconditions.checkNotNull(sink);
        try (Closer closer = Closer.create();){
            InputStream in = closer.register(this.openStream());
            OutputStream out = closer.register(sink.openStream());
            long l = ByteStreams.copy(in, out);
            return l;
        }
    }

    public byte[] read() throws IOException {
        try (Closer closer = Closer.create();){
            InputStream in = closer.register(this.openStream());
            Optional<Long> size = this.sizeIfKnown();
            byte[] byArray = size.isPresent() ? ByteStreams.toByteArray(in, size.get()) : ByteStreams.toByteArray(in);
            return byArray;
        }
    }

    class AsCharSource
    extends CharSource {
        final Charset charset;

        AsCharSource(Charset charset) {
            this.charset = Preconditions.checkNotNull(charset);
        }

        @Override
        public ByteSource asByteSource(Charset charset) {
            if (charset.equals(this.charset)) {
                return ByteSource.this;
            }
            return super.asByteSource(charset);
        }

        @Override
        public Reader openStream() throws IOException {
            return new InputStreamReader(ByteSource.this.openStream(), this.charset);
        }

        @Override
        public String read() throws IOException {
            return new String(ByteSource.this.read(), this.charset);
        }

        public String toString() {
            return ByteSource.this.toString() + ".asCharSource(" + this.charset + ")";
        }
    }
}

