/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.google.protobuf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.glowroot.agent.shaded.com.google.protobuf.AbstractProtobufList;
import org.glowroot.agent.shaded.com.google.protobuf.ByteString;
import org.glowroot.agent.shaded.com.google.protobuf.Internal;
import org.glowroot.agent.shaded.com.google.protobuf.LazyStringList;
import org.glowroot.agent.shaded.com.google.protobuf.UnmodifiableLazyStringList;

public class LazyStringArrayList
extends AbstractProtobufList<String>
implements RandomAccess,
LazyStringList {
    private static final LazyStringArrayList EMPTY_LIST = new LazyStringArrayList();
    @Deprecated
    public static final LazyStringList EMPTY;
    private final List<Object> list;

    public static LazyStringArrayList emptyList() {
        return EMPTY_LIST;
    }

    public LazyStringArrayList() {
        this(10);
    }

    public LazyStringArrayList(int initialCapacity) {
        this(new ArrayList<Object>(initialCapacity));
    }

    public LazyStringArrayList(LazyStringList from) {
        this.list = new ArrayList<Object>(from.size());
        this.addAll(from);
    }

    private LazyStringArrayList(ArrayList<Object> list) {
        this.list = list;
    }

    public LazyStringArrayList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> newList = new ArrayList<Object>(capacity);
        newList.addAll(this.list);
        return new LazyStringArrayList(newList);
    }

    @Override
    public String get(int index) {
        Object o = this.list.get(index);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ByteString) {
            ByteString bs = (ByteString)o;
            String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
                this.list.set(index, s);
            }
            return s;
        }
        byte[] ba = (byte[])o;
        String s = Internal.toStringUtf8(ba);
        if (Internal.isValidUtf8(ba)) {
            this.list.set(index, s);
        }
        return s;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String set(int index, String s) {
        this.ensureIsMutable();
        Object o = this.list.set(index, s);
        return LazyStringArrayList.asString(o);
    }

    @Override
    public void add(int index, String element) {
        this.ensureIsMutable();
        this.list.add(index, element);
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        this.ensureIsMutable();
        Collection<? extends String> collection = c instanceof LazyStringList ? ((LazyStringList)c).getUnderlyingElements() : c;
        boolean ret = this.list.addAll(index, collection);
        ++this.modCount;
        return ret;
    }

    @Override
    public String remove(int index) {
        this.ensureIsMutable();
        Object o = this.list.remove(index);
        ++this.modCount;
        return LazyStringArrayList.asString(o);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        this.list.clear();
        ++this.modCount;
    }

    @Override
    public void add(ByteString element) {
        this.ensureIsMutable();
        this.list.add(element);
        ++this.modCount;
    }

    @Override
    public Object getRaw(int index) {
        return this.list.get(index);
    }

    public ByteString getByteString(int index) {
        Object o = this.list.get(index);
        ByteString b = LazyStringArrayList.asByteString(o);
        if (b != o) {
            this.list.set(index, b);
        }
        return b;
    }

    private static String asString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ByteString) {
            return ((ByteString)o).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])o);
    }

    private static ByteString asByteString(Object o) {
        if (o instanceof ByteString) {
            return (ByteString)o;
        }
        if (o instanceof String) {
            return ByteString.copyFromUtf8((String)o);
        }
        return ByteString.copyFrom((byte[])o);
    }

    @Override
    public List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public LazyStringList getUnmodifiableView() {
        if (this.isModifiable()) {
            return new UnmodifiableLazyStringList(this);
        }
        return this;
    }

    static {
        EMPTY_LIST.makeImmutable();
        EMPTY = EMPTY_LIST;
    }
}

