/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CheckReturnValue;
import org.glowroot.agent.shaded.io.grpc.Attributes;
import org.glowroot.agent.shaded.io.grpc.CallCredentials;
import org.glowroot.agent.shaded.io.grpc.ChannelCredentials;
import org.glowroot.agent.shaded.io.grpc.ChannelLogger;
import org.glowroot.agent.shaded.io.grpc.ForwardingChannelBuilder2;
import org.glowroot.agent.shaded.io.grpc.HttpConnectProxiedSocketAddress;
import org.glowroot.agent.shaded.io.grpc.ManagedChannelBuilder;
import org.glowroot.agent.shaded.io.grpc.internal.AtomicBackoff;
import org.glowroot.agent.shaded.io.grpc.internal.ClientTransportFactory;
import org.glowroot.agent.shaded.io.grpc.internal.ConnectionClientTransport;
import org.glowroot.agent.shaded.io.grpc.internal.GrpcUtil;
import org.glowroot.agent.shaded.io.grpc.internal.KeepAliveManager;
import org.glowroot.agent.shaded.io.grpc.internal.ManagedChannelImplBuilder;
import org.glowroot.agent.shaded.io.grpc.internal.ObjectPool;
import org.glowroot.agent.shaded.io.grpc.internal.SharedResourcePool;
import org.glowroot.agent.shaded.io.grpc.internal.TransportTracer;
import org.glowroot.agent.shaded.io.grpc.netty.GrpcSslContexts;
import org.glowroot.agent.shaded.io.grpc.netty.NegotiationType;
import org.glowroot.agent.shaded.io.grpc.netty.NettyClientTransport;
import org.glowroot.agent.shaded.io.grpc.netty.ProtocolNegotiator;
import org.glowroot.agent.shaded.io.grpc.netty.ProtocolNegotiators;
import org.glowroot.agent.shaded.io.grpc.netty.Utils;
import org.glowroot.agent.shaded.io.netty.channel.Channel;
import org.glowroot.agent.shaded.io.netty.channel.ChannelFactory;
import org.glowroot.agent.shaded.io.netty.channel.ChannelOption;
import org.glowroot.agent.shaded.io.netty.channel.EventLoopGroup;
import org.glowroot.agent.shaded.io.netty.channel.ReflectiveChannelFactory;
import org.glowroot.agent.shaded.io.netty.handler.ssl.SslContext;

@CheckReturnValue
public final class NettyChannelBuilder
extends ForwardingChannelBuilder2<NettyChannelBuilder> {
    private static final boolean DEFAULT_AUTO_FLOW_CONTROL;
    private static final long AS_LARGE_AS_INFINITE;
    private static final ChannelFactory<? extends Channel> DEFAULT_CHANNEL_FACTORY;
    private static final ObjectPool<? extends EventLoopGroup> DEFAULT_EVENT_LOOP_GROUP_POOL;
    private final ManagedChannelImplBuilder managedChannelImplBuilder;
    private TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    private final Map<ChannelOption<?>, Object> channelOptions = new HashMap();
    private ChannelFactory<? extends Channel> channelFactory = DEFAULT_CHANNEL_FACTORY;
    private ObjectPool<? extends EventLoopGroup> eventLoopGroupPool = DEFAULT_EVENT_LOOP_GROUP_POOL;
    private boolean autoFlowControl = DEFAULT_AUTO_FLOW_CONTROL;
    private int flowControlWindow = 0x100000;
    private int maxHeaderListSize = 8192;
    private int maxInboundMessageSize = 0x400000;
    private long keepAliveTimeNanos = Long.MAX_VALUE;
    private long keepAliveTimeoutNanos = GrpcUtil.DEFAULT_KEEPALIVE_TIMEOUT_NANOS;
    private boolean keepAliveWithoutCalls;
    private ProtocolNegotiator.ClientFactory protocolNegotiatorFactory = new DefaultProtocolNegotiator();
    private final boolean freezeProtocolNegotiatorFactory;
    private LocalSocketPicker localSocketPicker;
    private final boolean useGetForSafeMethods = false;
    private Class<? extends SocketAddress> transportSocketType = InetSocketAddress.class;

    public static NettyChannelBuilder forAddress(String host, int port) {
        return NettyChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort(host, port));
    }

    public static NettyChannelBuilder forTarget(String target) {
        return new NettyChannelBuilder(target);
    }

    NettyChannelBuilder(String target) {
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(target, new NettyChannelTransportFactoryBuilder(), new NettyChannelDefaultPortProvider());
        this.freezeProtocolNegotiatorFactory = false;
    }

    NettyChannelBuilder(String target, ChannelCredentials channelCreds, CallCredentials callCreds, ProtocolNegotiator.ClientFactory negotiator) {
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(target, channelCreds, callCreds, new NettyChannelTransportFactoryBuilder(), new NettyChannelDefaultPortProvider());
        this.protocolNegotiatorFactory = Preconditions.checkNotNull(negotiator, "negotiator");
        this.freezeProtocolNegotiatorFactory = true;
    }

    @Override
    protected ManagedChannelBuilder<?> delegate() {
        return this.managedChannelImplBuilder;
    }

    @CanIgnoreReturnValue
    public NettyChannelBuilder channelType(Class<? extends Channel> channelType, @Nullable Class<? extends SocketAddress> transportSocketType) {
        Preconditions.checkNotNull(channelType, "channelType");
        return this.channelFactory(new ReflectiveChannelFactory<Channel>(channelType), transportSocketType);
    }

    @CanIgnoreReturnValue
    public NettyChannelBuilder channelFactory(ChannelFactory<? extends Channel> channelFactory, @Nullable Class<? extends SocketAddress> transportSocketType) {
        this.channelFactory = Preconditions.checkNotNull(channelFactory, "channelFactory");
        this.transportSocketType = transportSocketType;
        return this;
    }

    @CanIgnoreReturnValue
    public NettyChannelBuilder negotiationType(NegotiationType type) {
        Preconditions.checkState(!this.freezeProtocolNegotiatorFactory, "Cannot change security when using ChannelCredentials");
        if (!(this.protocolNegotiatorFactory instanceof DefaultProtocolNegotiator)) {
            return this;
        }
        ((DefaultProtocolNegotiator)this.protocolNegotiatorFactory).negotiationType = type;
        return this;
    }

    @CanIgnoreReturnValue
    NettyChannelBuilder eventLoopGroupPool(ObjectPool<? extends EventLoopGroup> eventLoopGroupPool) {
        this.eventLoopGroupPool = Preconditions.checkNotNull(eventLoopGroupPool, "eventLoopGroupPool");
        return this;
    }

    @CanIgnoreReturnValue
    public NettyChannelBuilder sslContext(SslContext sslContext) {
        Preconditions.checkState(!this.freezeProtocolNegotiatorFactory, "Cannot change security when using ChannelCredentials");
        if (sslContext != null) {
            Preconditions.checkArgument(sslContext.isClient(), "Server SSL context can not be used for client channel");
            GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        }
        if (!(this.protocolNegotiatorFactory instanceof DefaultProtocolNegotiator)) {
            return this;
        }
        ((DefaultProtocolNegotiator)this.protocolNegotiatorFactory).sslContext = sslContext;
        return this;
    }

    @CanIgnoreReturnValue
    public NettyChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTime > 0L, "keepalive time must be positive");
        this.keepAliveTimeNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeNanos = KeepAliveManager.clampKeepAliveTimeInNanos(this.keepAliveTimeNanos);
        if (this.keepAliveTimeNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeNanos = Long.MAX_VALUE;
        }
        return this;
    }

    ClientTransportFactory buildTransportFactory() {
        this.assertEventLoopAndChannelType();
        ProtocolNegotiator negotiator = this.protocolNegotiatorFactory.newNegotiator();
        return new NettyTransportFactory(negotiator, this.channelFactory, this.channelOptions, this.eventLoopGroupPool, this.autoFlowControl, this.flowControlWindow, this.maxInboundMessageSize, this.maxHeaderListSize, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls, this.transportTracerFactory, this.localSocketPicker, false, this.transportSocketType);
    }

    void assertEventLoopAndChannelType() {
        boolean bothProvided = this.channelFactory != DEFAULT_CHANNEL_FACTORY && this.eventLoopGroupPool != DEFAULT_EVENT_LOOP_GROUP_POOL;
        boolean nonProvided = this.channelFactory == DEFAULT_CHANNEL_FACTORY && this.eventLoopGroupPool == DEFAULT_EVENT_LOOP_GROUP_POOL;
        Preconditions.checkState(bothProvided || nonProvided, "Both EventLoopGroup and ChannelType should be provided or neither should be");
    }

    static ProtocolNegotiator createProtocolNegotiatorByType(NegotiationType negotiationType, SslContext sslContext, ObjectPool<? extends Executor> executorPool) {
        switch (negotiationType) {
            case PLAINTEXT: {
                return ProtocolNegotiators.plaintext();
            }
            case PLAINTEXT_UPGRADE: {
                return ProtocolNegotiators.plaintextUpgrade();
            }
            case TLS: {
                return ProtocolNegotiators.tls(sslContext, executorPool);
            }
        }
        throw new IllegalArgumentException("Unsupported negotiationType: " + (Object)((Object)negotiationType));
    }

    static Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }

    static {
        AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
        DEFAULT_CHANNEL_FACTORY = new ReflectiveChannelFactory<Channel>(Utils.DEFAULT_CLIENT_CHANNEL_TYPE);
        DEFAULT_EVENT_LOOP_GROUP_POOL = SharedResourcePool.forResource(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP);
        String autoFlowControl = System.getenv("GRPC_EXPERIMENTAL_AUTOFLOWCONTROL");
        if (autoFlowControl == null) {
            autoFlowControl = "true";
        }
        DEFAULT_AUTO_FLOW_CONTROL = Boolean.parseBoolean(autoFlowControl);
    }

    private static final class NettyTransportFactory
    implements ClientTransportFactory {
        private final ProtocolNegotiator protocolNegotiator;
        private final ChannelFactory<? extends Channel> channelFactory;
        private final Map<ChannelOption<?>, ?> channelOptions;
        private final ObjectPool<? extends EventLoopGroup> groupPool;
        private final EventLoopGroup group;
        private final boolean autoFlowControl;
        private final int flowControlWindow;
        private final int maxMessageSize;
        private final int maxHeaderListSize;
        private final long keepAliveTimeNanos;
        private final AtomicBackoff keepAliveBackoff;
        private final long keepAliveTimeoutNanos;
        private final boolean keepAliveWithoutCalls;
        private final TransportTracer.Factory transportTracerFactory;
        private final LocalSocketPicker localSocketPicker;
        private final boolean useGetForSafeMethods;
        private boolean closed;
        private final Class<? extends SocketAddress> transportSocketType;

        NettyTransportFactory(ProtocolNegotiator protocolNegotiator, ChannelFactory<? extends Channel> channelFactory, Map<ChannelOption<?>, ?> channelOptions, ObjectPool<? extends EventLoopGroup> groupPool, boolean autoFlowControl, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, long keepAliveTimeNanos, long keepAliveTimeoutNanos, boolean keepAliveWithoutCalls, TransportTracer.Factory transportTracerFactory, LocalSocketPicker localSocketPicker, boolean useGetForSafeMethods, Class<? extends SocketAddress> transportSocketType) {
            this.protocolNegotiator = Preconditions.checkNotNull(protocolNegotiator, "protocolNegotiator");
            this.channelFactory = channelFactory;
            this.channelOptions = new HashMap(channelOptions);
            this.groupPool = groupPool;
            this.group = groupPool.getObject();
            this.autoFlowControl = autoFlowControl;
            this.flowControlWindow = flowControlWindow;
            this.maxMessageSize = maxMessageSize;
            this.maxHeaderListSize = maxHeaderListSize;
            this.keepAliveTimeNanos = keepAliveTimeNanos;
            this.keepAliveBackoff = new AtomicBackoff("keepalive time nanos", keepAliveTimeNanos);
            this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
            this.keepAliveWithoutCalls = keepAliveWithoutCalls;
            this.transportTracerFactory = transportTracerFactory;
            this.localSocketPicker = localSocketPicker != null ? localSocketPicker : new LocalSocketPicker();
            this.useGetForSafeMethods = useGetForSafeMethods;
            this.transportSocketType = transportSocketType;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            Preconditions.checkState(!this.closed, "The transport factory is closed.");
            ProtocolNegotiator localNegotiator = this.protocolNegotiator;
            HttpConnectProxiedSocketAddress proxiedAddr = options.getHttpConnectProxiedSocketAddress();
            if (proxiedAddr != null) {
                serverAddress = proxiedAddr.getTargetAddress();
                localNegotiator = ProtocolNegotiators.httpProxy(proxiedAddr.getProxyAddress(), proxiedAddr.getUsername(), proxiedAddr.getPassword(), this.protocolNegotiator);
            }
            final AtomicBackoff.State keepAliveTimeNanosState = this.keepAliveBackoff.getState();
            Runnable tooManyPingsRunnable = new Runnable(){

                @Override
                public void run() {
                    keepAliveTimeNanosState.backoff();
                }
            };
            NettyClientTransport transport = new NettyClientTransport(serverAddress, this.channelFactory, this.channelOptions, this.group, localNegotiator, this.autoFlowControl, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize, keepAliveTimeNanosState.get(), this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls, options.getAuthority(), options.getUserAgent(), tooManyPingsRunnable, this.transportTracerFactory.create(), options.getEagAttributes(), this.localSocketPicker, channelLogger, this.useGetForSafeMethods, Ticker.systemTicker());
            return transport;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.group;
        }

        @Override
        public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
            Preconditions.checkNotNull(channelCreds, "channelCreds");
            ProtocolNegotiators.FromChannelCredentialsResult result = ProtocolNegotiators.from(channelCreds);
            if (result.error != null) {
                return null;
            }
            NettyTransportFactory factory = new NettyTransportFactory(result.negotiator.newNegotiator(), this.channelFactory, this.channelOptions, this.groupPool, this.autoFlowControl, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls, this.transportTracerFactory, this.localSocketPicker, this.useGetForSafeMethods, this.transportSocketType);
            return new ClientTransportFactory.SwapChannelCredentialsResult(factory, result.callCredentials);
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.protocolNegotiator.close();
            this.groupPool.returnObject(this.group);
        }

        @Override
        public Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
            return this.transportSocketType == null ? null : Collections.singleton(this.transportSocketType);
        }
    }

    private final class DefaultProtocolNegotiator
    implements ProtocolNegotiator.ClientFactory {
        private NegotiationType negotiationType = NegotiationType.TLS;
        private SslContext sslContext;

        private DefaultProtocolNegotiator() {
        }

        @Override
        public ProtocolNegotiator newNegotiator() {
            SslContext localSslContext = this.sslContext;
            if (this.negotiationType == NegotiationType.TLS && localSslContext == null) {
                try {
                    localSslContext = GrpcSslContexts.forClient().build();
                }
                catch (SSLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return NettyChannelBuilder.createProtocolNegotiatorByType(this.negotiationType, localSslContext, NettyChannelBuilder.this.managedChannelImplBuilder.getOffloadExecutorPool());
        }

        @Override
        public int getDefaultPort() {
            switch (this.negotiationType) {
                case PLAINTEXT: 
                case PLAINTEXT_UPGRADE: {
                    return 80;
                }
                case TLS: {
                    return 443;
                }
            }
            throw new AssertionError((Object)((Object)((Object)this.negotiationType) + " not handled"));
        }
    }

    public static class LocalSocketPicker {
        @Nullable
        public SocketAddress createSocketAddress(SocketAddress remoteAddress, Attributes attrs) {
            return null;
        }
    }

    private final class NettyChannelDefaultPortProvider
    implements ManagedChannelImplBuilder.ChannelBuilderDefaultPortProvider {
        private NettyChannelDefaultPortProvider() {
        }

        @Override
        public int getDefaultPort() {
            return NettyChannelBuilder.this.protocolNegotiatorFactory.getDefaultPort();
        }
    }

    private final class NettyChannelTransportFactoryBuilder
    implements ManagedChannelImplBuilder.ClientTransportFactoryBuilder {
        private NettyChannelTransportFactoryBuilder() {
        }

        @Override
        public ClientTransportFactory buildClientTransportFactory() {
            return NettyChannelBuilder.this.buildTransportFactory();
        }
    }
}

