/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.util;

import java.util.Arrays;
import java.util.Collection;
import org.glowroot.agent.shaded.io.netty.util.ByteProcessor;
import org.glowroot.agent.shaded.io.netty.util.HashingStrategy;
import org.glowroot.agent.shaded.io.netty.util.internal.MathUtil;
import org.glowroot.agent.shaded.io.netty.util.internal.ObjectUtil;
import org.glowroot.agent.shaded.io.netty.util.internal.PlatformDependent;

public final class AsciiString
implements CharSequence,
Comparable<CharSequence> {
    public static final AsciiString EMPTY_STRING = AsciiString.cached("");
    private final byte[] value;
    private final int offset;
    private final int length;
    private int hash;
    private String string;
    public static final HashingStrategy<CharSequence> CASE_INSENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return AsciiString.contentEqualsIgnoreCase(a, b);
        }
    };
    public static final HashingStrategy<CharSequence> CASE_SENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return AsciiString.contentEquals(a, b);
        }
    };

    public AsciiString(byte[] value) {
        this(value, true);
    }

    public AsciiString(byte[] value, boolean copy) {
        this(value, 0, value.length, copy);
    }

    public AsciiString(byte[] value, int start, int length, boolean copy) {
        if (copy) {
            byte[] rangedCopy = new byte[length];
            System.arraycopy(value, start, rangedCopy, 0, rangedCopy.length);
            this.value = rangedCopy;
            this.offset = 0;
        } else {
            if (MathUtil.isOutOfBounds(start, length, value.length)) {
                throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= value.length(" + value.length + ')');
            }
            this.value = value;
            this.offset = start;
        }
        this.length = length;
    }

    public AsciiString(CharSequence value) {
        this(value, 0, value.length());
    }

    public AsciiString(CharSequence value, int start, int length) {
        if (MathUtil.isOutOfBounds(start, length, value.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= value.length(" + value.length() + ')');
        }
        this.value = PlatformDependent.allocateUninitializedArray(length);
        int i = 0;
        int j = start;
        while (i < length) {
            this.value[i] = AsciiString.c2b(value.charAt(j));
            ++i;
            ++j;
        }
        this.offset = 0;
        this.length = length;
    }

    public int forEachByte(ByteProcessor visitor) throws Exception {
        return this.forEachByte0(0, this.length(), visitor);
    }

    public int forEachByte(int index, int length, ByteProcessor visitor) throws Exception {
        if (MathUtil.isOutOfBounds(index, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + index + ") <= start + length(" + length + ") <= length(" + this.length() + ')');
        }
        return this.forEachByte0(index, length, visitor);
    }

    private int forEachByte0(int index, int length, ByteProcessor visitor) throws Exception {
        int len = this.offset + index + length;
        for (int i = this.offset + index; i < len; ++i) {
            if (visitor.process(this.value[i])) continue;
            return i - this.offset;
        }
        return -1;
    }

    public byte byteAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("index: " + index + " must be in the range [0," + this.length + ")");
        }
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getByte(this.value, index + this.offset);
        }
        return this.value[index + this.offset];
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    public byte[] array() {
        return this.value;
    }

    public int arrayOffset() {
        return this.offset;
    }

    public boolean isEntireArrayUsed() {
        return this.offset == 0 && this.length == this.value.length;
    }

    public byte[] toByteArray() {
        return this.toByteArray(0, this.length());
    }

    public byte[] toByteArray(int start, int end) {
        return Arrays.copyOfRange(this.value, start + this.offset, end + this.offset);
    }

    @Override
    public char charAt(int index) {
        return AsciiString.b2c(this.byteAt(index));
    }

    @Override
    public int compareTo(CharSequence string) {
        if (this == string) {
            return 0;
        }
        int length1 = this.length();
        int length2 = string.length();
        int minLength = Math.min(length1, length2);
        int i = 0;
        int j = this.arrayOffset();
        while (i < minLength) {
            int result = AsciiString.b2c(this.value[j]) - string.charAt(i);
            if (result != 0) {
                return result;
            }
            ++i;
            ++j;
        }
        return length1 - length2;
    }

    public boolean endsWith(CharSequence suffix) {
        int suffixLen = suffix.length();
        return this.regionMatches(this.length() - suffixLen, suffix, 0, suffixLen);
    }

    public boolean contentEqualsIgnoreCase(CharSequence string) {
        if (this == string) {
            return true;
        }
        if (string == null || string.length() != this.length()) {
            return false;
        }
        if (string instanceof AsciiString) {
            AsciiString rhs = (AsciiString)string;
            int i = this.arrayOffset();
            int j = rhs.arrayOffset();
            int end = i + this.length();
            while (i < end) {
                if (!AsciiString.equalsIgnoreCase(this.value[i], rhs.value[j])) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        int i = this.arrayOffset();
        int end = this.length();
        for (int j = 0; j < end; ++j) {
            if (!AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[i]), string.charAt(j))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public AsciiString subSequence(int start, int end) {
        return this.subSequence(start, end, true);
    }

    public AsciiString subSequence(int start, int end, boolean copy) {
        if (MathUtil.isOutOfBounds(start, end - start, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= end (" + end + ") <= length(" + this.length() + ')');
        }
        if (start == 0 && end == this.length()) {
            return this;
        }
        if (end == start) {
            return EMPTY_STRING;
        }
        return new AsciiString(this.value, start + this.offset, end - start, copy);
    }

    public int indexOf(char ch, int start) {
        if (ch > '\u00ff') {
            return -1;
        }
        if (start < 0) {
            start = 0;
        }
        byte chAsByte = AsciiString.c2b0(ch);
        int len = this.offset + this.length;
        for (int i = start + this.offset; i < len; ++i) {
            if (this.value[i] != chAsByte) continue;
            return i - this.offset;
        }
        return -1;
    }

    public boolean regionMatches(int thisStart, CharSequence string, int start, int length) {
        ObjectUtil.checkNotNull(string, "string");
        if (start < 0 || string.length() - start < length) {
            return false;
        }
        int thisLen = this.length();
        if (thisStart < 0 || thisLen - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        int thatEnd = start + length;
        int i = start;
        int j = thisStart + this.arrayOffset();
        while (i < thatEnd) {
            if (AsciiString.b2c(this.value[j]) != string.charAt(i)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public AsciiString toLowerCase() {
        int i;
        boolean lowercased = true;
        int len = this.length() + this.arrayOffset();
        for (i = this.arrayOffset(); i < len; ++i) {
            byte b = this.value[i];
            if (b < 65 || b > 90) continue;
            lowercased = false;
            break;
        }
        if (lowercased) {
            return this;
        }
        byte[] newValue = PlatformDependent.allocateUninitializedArray(this.length());
        i = 0;
        int j = this.arrayOffset();
        while (i < newValue.length) {
            newValue[i] = AsciiString.toLowerCase(this.value[j]);
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public static CharSequence trim(CharSequence c) {
        int start;
        int last;
        if (c instanceof AsciiString) {
            return ((AsciiString)c).trim();
        }
        if (c instanceof String) {
            return ((String)c).trim();
        }
        int end = last = c.length() - 1;
        for (start = 0; start <= end && c.charAt(start) <= ' '; ++start) {
        }
        while (end >= start && c.charAt(end) <= ' ') {
            --end;
        }
        if (start == 0 && end == last) {
            return c;
        }
        return c.subSequence(start, end);
    }

    public AsciiString trim() {
        int start;
        int last;
        int end = last = this.arrayOffset() + this.length() - 1;
        for (start = this.arrayOffset(); start <= end && this.value[start] <= 32; ++start) {
        }
        while (end >= start && this.value[end] <= 32) {
            --end;
        }
        if (start == 0 && end == last) {
            return this;
        }
        return new AsciiString(this.value, start, end - start + 1, false);
    }

    public boolean contentEquals(CharSequence a) {
        if (this == a) {
            return true;
        }
        if (a == null || a.length() != this.length()) {
            return false;
        }
        if (a instanceof AsciiString) {
            return this.equals(a);
        }
        int i = this.arrayOffset();
        for (int j = 0; j < a.length(); ++j) {
            if (AsciiString.b2c(this.value[i]) != a.charAt(j)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = PlatformDependent.hashCodeAscii(this.value, this.offset, this.length);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != AsciiString.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AsciiString other = (AsciiString)obj;
        return this.length() == other.length() && this.hashCode() == other.hashCode() && PlatformDependent.equals(this.array(), this.arrayOffset(), other.array(), other.arrayOffset(), this.length());
    }

    @Override
    public String toString() {
        String cache = this.string;
        if (cache == null) {
            this.string = cache = this.toString(0);
        }
        return cache;
    }

    public String toString(int start) {
        return this.toString(start, this.length());
    }

    public String toString(int start, int end) {
        int length = end - start;
        if (length == 0) {
            return "";
        }
        if (MathUtil.isOutOfBounds(start, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        String str = new String(this.value, 0, start + this.offset, length);
        return str;
    }

    public int parseInt() {
        return this.parseInt(0, this.length(), 10);
    }

    public int parseInt(int start, int end, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start == end) {
            throw new NumberFormatException();
        }
        int i = start;
        boolean bl = negative = this.byteAt(i) == 45;
        if (negative && ++i == end) {
            throw new NumberFormatException(this.subSequence(start, end, false).toString());
        }
        return this.parseInt(i, end, radix, negative);
    }

    private int parseInt(int start, int end, int radix, boolean negative) {
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        int currOffset = start;
        while (currOffset < end) {
            int digit;
            if ((digit = Character.digit((char)(this.value[currOffset++ + this.offset] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            if (max > result) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            int next = result * radix - digit;
            if (next > result) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            result = next;
        }
        if (!negative && (result = -result) < 0) {
            throw new NumberFormatException(this.subSequence(start, end, false).toString());
        }
        return result;
    }

    public static AsciiString of(CharSequence string) {
        return string instanceof AsciiString ? (AsciiString)string : new AsciiString(string);
    }

    public static AsciiString cached(String string) {
        AsciiString asciiString = new AsciiString(string);
        asciiString.string = string;
        return asciiString;
    }

    public static int hashCode(CharSequence value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof AsciiString) {
            return value.hashCode();
        }
        return PlatformDependent.hashCodeAscii(value);
    }

    public static boolean contentEqualsIgnoreCase(CharSequence a, CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof AsciiString) {
            return ((AsciiString)a).contentEqualsIgnoreCase(b);
        }
        if (b instanceof AsciiString) {
            return ((AsciiString)b).contentEqualsIgnoreCase(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (AsciiString.equalsIgnoreCase(a.charAt(i), b.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsContentEqualsIgnoreCase(Collection<CharSequence> collection, CharSequence value) {
        for (CharSequence v : collection) {
            if (!AsciiString.contentEqualsIgnoreCase(value, v)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllContentEqualsIgnoreCase(Collection<CharSequence> a, Collection<CharSequence> b) {
        for (CharSequence v : b) {
            if (AsciiString.containsContentEqualsIgnoreCase(a, v)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(CharSequence a, CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof AsciiString) {
            return ((AsciiString)a).contentEquals(b);
        }
        if (b instanceof AsciiString) {
            return ((AsciiString)b).contentEquals(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(CharSequence cs, char searchChar, int start) {
        int i;
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).indexOf(searchChar, start);
        }
        if (cs == null) {
            return -1;
        }
        int sz = cs.length();
        int n = i = start < 0 ? 0 : start;
        while (i < sz) {
            if (cs.charAt(i) == searchChar) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean equalsIgnoreCase(byte a, byte b) {
        return a == b || AsciiString.toLowerCase(a) == AsciiString.toLowerCase(b);
    }

    private static boolean equalsIgnoreCase(char a, char b) {
        return a == b || AsciiString.toLowerCase(a) == AsciiString.toLowerCase(b);
    }

    private static byte toLowerCase(byte b) {
        return AsciiString.isUpperCase(b) ? (byte)(b + 32) : b;
    }

    public static char toLowerCase(char c) {
        return AsciiString.isUpperCase(c) ? (char)(c + 32) : c;
    }

    public static boolean isUpperCase(byte value) {
        return value >= 65 && value <= 90;
    }

    public static boolean isUpperCase(char value) {
        return value >= 'A' && value <= 'Z';
    }

    public static byte c2b(char c) {
        return (byte)(c > '\u00ff' ? 63 : (int)c);
    }

    private static byte c2b0(char c) {
        return (byte)c;
    }

    public static char b2c(byte b) {
        return (char)(b & 0xFF);
    }
}

