/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;

public class Masking {
    public static final String MASKED_VALUE = "****";

    private Masking() {
    }

    public static List<String> maskJvmArgs(List<String> jvmArgs, List<String> maskSystemProperties) {
        if (maskSystemProperties.isEmpty()) {
            return jvmArgs;
        }
        ImmutableList<Pattern> maskSystemPropertyPatterns = Masking.buildPatternList(maskSystemProperties);
        ArrayList<String> maskedJvmArgs = Lists.newArrayList();
        for (String arg : jvmArgs) {
            maskedJvmArgs.add(Masking.maskSystemProperty(arg, maskSystemPropertyPatterns));
        }
        return maskedJvmArgs;
    }

    public static Map<String, String> maskSystemProperties(Map<String, String> systemProperties, List<String> maskSystemProperties) {
        if (maskSystemProperties.isEmpty()) {
            return systemProperties;
        }
        ImmutableList<Pattern> maskPatterns = Masking.buildPatternList(maskSystemProperties);
        HashMap<String, String> maskedSystemProperties = Maps.newHashMap();
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            String name = entry.getKey();
            if (Masking.matchesAny(name, maskPatterns)) {
                maskedSystemProperties.put(name, MASKED_VALUE);
                continue;
            }
            maskedSystemProperties.put(name, entry.getValue());
        }
        return maskedSystemProperties;
    }

    private static String maskSystemProperty(String arg, List<Pattern> maskPatterns) {
        if (!arg.startsWith("-D")) {
            return arg;
        }
        int index = arg.indexOf(61);
        if (index == -1) {
            return arg;
        }
        String name = arg.substring(2, index);
        String nameLowerCase = name.toLowerCase(Locale.ENGLISH);
        if (!Masking.matchesAny(nameLowerCase, maskPatterns)) {
            return arg;
        }
        return "-D" + name + "=****";
    }

    public static ImmutableList<Pattern> buildPatternList(List<String> properties) {
        ArrayList<Pattern> propertyPatterns = Lists.newArrayList();
        for (String property : properties) {
            propertyPatterns.add(Masking.buildRegexPattern(property.toLowerCase(Locale.ENGLISH)));
        }
        return ImmutableList.copyOf(propertyPatterns);
    }

    public static boolean matchesAny(String text, List<Pattern> patterns) {
        String textLowerCase = text.toLowerCase(Locale.ENGLISH);
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(textLowerCase).matches()) continue;
            return true;
        }
        return false;
    }

    private static Pattern buildRegexPattern(String wildcardPattern) {
        String regex = "\\Q" + wildcardPattern.replace("*", "\\E.*\\Q") + "\\E";
        regex = regex.replace("\\Q\\E", "");
        return Pattern.compile(regex);
    }
}

