/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.util;

import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NotAvailableAware {
    public static final int NA = -1;
    private static final double NANOSECONDS_PER_MILLISECOND = 1000000.0;

    private NotAvailableAware() {
    }

    public static double add(double x, double y) {
        if (NotAvailableAware.isNA(x) || NotAvailableAware.isNA(y)) {
            return -1.0;
        }
        return x + y;
    }

    public static long add(long x, long y) {
        if (NotAvailableAware.isNA(x) || NotAvailableAware.isNA(y)) {
            return -1L;
        }
        long sum = x + y;
        if (sum < 0L) {
            return Long.MAX_VALUE;
        }
        return sum;
    }

    public static boolean isNA(double value) {
        return value == -1.0;
    }

    public static boolean isNA(long value) {
        return value == -1L;
    }

    public static @Nullable Double orNull(double value) {
        return value == -1.0 ? null : Double.valueOf(value);
    }

    public static long millisToNanos(long millis) {
        if (NotAvailableAware.isNA(millis)) {
            return -1L;
        }
        return TimeUnit.MILLISECONDS.toNanos(millis);
    }

    public static double millisToNanos(double millis) {
        if (NotAvailableAware.isNA(millis)) {
            return -1.0;
        }
        return millis * 1000000.0;
    }
}

