/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;

class Accessor {
    private final AccessorType accessorType;
    private final @Nullable Method method;
    private final @Nullable Field field;

    static Accessor fromMethod(Method method) {
        return new Accessor(method);
    }

    static Accessor fromField(Field field) {
        return new Accessor(field);
    }

    static Accessor arrayLength() {
        return new Accessor();
    }

    private Accessor(Method method) {
        this.accessorType = AccessorType.METHOD;
        this.method = method;
        this.field = null;
    }

    private Accessor(Field field) {
        this.accessorType = AccessorType.FIELD;
        this.method = null;
        this.field = field;
    }

    private Accessor() {
        this.accessorType = AccessorType.ARRAY_LENGTH;
        this.method = null;
        this.field = null;
    }

    Class<?> getValueType() {
        switch (this.accessorType) {
            case METHOD: {
                Preconditions.checkNotNull(this.method);
                return this.method.getReturnType();
            }
            case FIELD: {
                Preconditions.checkNotNull(this.field);
                return this.field.getType();
            }
            case ARRAY_LENGTH: {
                return Integer.TYPE;
            }
        }
        throw new AssertionError((Object)("Unexpected accessor type: " + (Object)((Object)this.accessorType)));
    }

    @Nullable Object evaluate(Object object) throws Exception {
        if (this.isArrayEvaluation(object)) {
            return this.evaluateArray((Object[])object);
        }
        switch (this.accessorType) {
            case METHOD: {
                Preconditions.checkNotNull(this.method);
                return this.method.invoke(object, new Object[0]);
            }
            case FIELD: {
                Preconditions.checkNotNull(this.field);
                return this.field.get(object);
            }
            case ARRAY_LENGTH: {
                return Array.getLength(object);
            }
        }
        throw new AssertionError((Object)("Unexpected accessor type: " + (Object)((Object)this.accessorType)));
    }

    private boolean isArrayEvaluation(Object object) {
        return object instanceof Object[] && this.accessorType != AccessorType.ARRAY_LENGTH;
    }

    private Object evaluateArray(Object[] array) throws Exception {
        Object[] values = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            Object item = array[i];
            values[i] = item == null ? null : this.evaluate(item);
        }
        return values;
    }

    private static enum AccessorType {
        METHOD,
        FIELD,
        ARRAY_LENGTH;

    }
}

