/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.io.Closer;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.IsolatedWeavingClassLoader;
import org.immutables.value.Value;

class ClassLoaders {
    private static final Logger logger = LoggerFactory.getLogger(ClassLoaders.class);
    private static final Object lock = new Object();

    private ClassLoaders() {
    }

    static void defineClassesInBootstrapClassLoader(Collection<LazyDefinedClass> lazyDefinedClasses, Instrumentation instrumentation, File generatedJarFile) throws IOException {
        try (Closer closer = Closer.create();){
            FileOutputStream out = closer.register(new FileOutputStream(generatedJarFile));
            JarOutputStream jarOut = closer.register(new JarOutputStream(out));
            ClassLoaders.generate(lazyDefinedClasses, jarOut);
        }
        instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(generatedJarFile));
        ClassLoaders.appendToBootstrapResourcePath(generatedJarFile);
    }

    static void defineClasses(Collection<LazyDefinedClass> lazyDefinedClasses, ClassLoader loader) throws Exception {
        for (LazyDefinedClass lazyDefinedClass : lazyDefinedClasses) {
            ClassLoaders.defineClass(lazyDefinedClass, loader, false);
        }
    }

    static void defineClassIfNotExists(LazyDefinedClass lazyDefinedClass, ClassLoader loader) throws Exception {
        ClassLoaders.defineClass(lazyDefinedClass, loader, true);
    }

    static void defineClass(String name, byte[] bytes, ClassLoader loader) throws Exception {
        if (loader instanceof IsolatedWeavingClassLoader) {
            ((IsolatedWeavingClassLoader)loader).publicDefineClass(name, bytes, 0, bytes.length);
        } else {
            Method defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClassMethod.setAccessible(true);
            defineClassMethod.invoke((Object)loader, name, bytes, 0, bytes.length);
        }
    }

    static void createDirectoryOrCleanPreviousContentsWithPrefix(File dir, String prefix) throws IOException {
        ClassLoaders.deleteIfRegularFile(dir);
        if (dir.exists()) {
            ClassLoaders.deleteFilesWithPrefix(dir, prefix);
        } else {
            ClassLoaders.createDirectory(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void defineClass(LazyDefinedClass lazyDefinedClass, ClassLoader loader, boolean ifNotExists) throws Exception {
        for (LazyDefinedClass dependency : lazyDefinedClass.dependencies()) {
            ClassLoaders.defineClass(dependency, loader, ifNotExists);
        }
        String className = lazyDefinedClass.type().getClassName();
        if (ifNotExists) {
            Object object = lock;
            synchronized (object) {
                if (!ClassLoaders.classExists(className, loader)) {
                    ClassLoaders.defineClass(className, lazyDefinedClass.bytes(), loader);
                }
            }
        } else {
            ClassLoaders.defineClass(className, lazyDefinedClass.bytes(), loader);
        }
    }

    private static boolean classExists(String name, ClassLoader loader) throws Exception {
        if (loader instanceof IsolatedWeavingClassLoader) {
            return ((IsolatedWeavingClassLoader)loader).publicFindLoadedClass(name) != null;
        }
        Method findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
        findLoadedClassMethod.setAccessible(true);
        return findLoadedClassMethod.invoke((Object)loader, name) != null;
    }

    private static void generate(Collection<LazyDefinedClass> lazyDefinedClasses, JarOutputStream jarOut) throws IOException {
        for (LazyDefinedClass lazyDefinedClass : lazyDefinedClasses) {
            JarEntry jarEntry = new JarEntry(lazyDefinedClass.type().getInternalName() + ".class");
            jarOut.putNextEntry(jarEntry);
            jarOut.write(lazyDefinedClass.bytes());
            jarOut.closeEntry();
            ClassLoaders.generate(lazyDefinedClass.dependencies(), jarOut);
        }
    }

    private static void deleteIfRegularFile(File file) throws IOException {
        if (file.isFile() && !file.delete()) {
            throw new IOException("Could not delete file: " + file.getAbsolutePath());
        }
    }

    private static void deleteFilesWithPrefix(File dir, String prefix) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("Could not get listing for directory: " + dir.getAbsolutePath());
        }
        for (File file : files) {
            if (!file.getName().startsWith(prefix) || file.delete()) continue;
            throw new IOException("Could not delete file: " + file.getAbsolutePath());
        }
    }

    private static void createDirectory(File dir) throws IOException {
        if (!dir.mkdirs()) {
            throw new IOException("Could not create directory: " + dir.getAbsolutePath());
        }
    }

    private static void appendToBootstrapResourcePath(File generatedJarFile) {
        try {
            Class<?> launcherClass = Class.forName("sun.misc.Launcher", false, null);
            Method getBootstrapClassPathMethod = launcherClass.getMethod("getBootstrapClassPath", new Class[0]);
            Class<?> urlClassPathClass = Class.forName("sun.misc.URLClassPath", false, null);
            Method addUrlMethod = urlClassPathClass.getMethod("addURL", URL.class);
            Object urlClassPath = getBootstrapClassPathMethod.invoke(null, new Object[0]);
            addUrlMethod.invoke(urlClassPath, generatedJarFile.toURI().toURL());
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
        }
    }

    @Value.Immutable
    public static interface LazyDefinedClass {
        public Type type();

        public byte[] bytes();

        public ImmutableList<LazyDefinedClass> dependencies();
    }
}

