/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassReader;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassWriter;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.JSRInlinerClassVisitor;
import org.glowroot.agent.weaving.PointcutClassVisitor;

public class PointcutClassFileTransformer
implements ClassFileTransformer {
    private static final Logger logger = LoggerFactory.getLogger(PointcutClassFileTransformer.class);

    @Override
    public byte[] transform(@Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        try {
            ClassWriter cw = new ClassWriter(1);
            PointcutClassVisitor cv = new PointcutClassVisitor(cw);
            ClassReader cr = new ClassReader(bytes);
            cr.accept(new JSRInlinerClassVisitor(cv), 8);
            if (cv.isConstructorPointcut() && cv.hasOnBeforeMethod()) {
                return cw.toByteArray();
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return null;
    }
}

