/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.ImmutableColumn;
import org.glowroot.agent.embedded.util.ImmutableIndex;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.cache.Cache;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.hash.Hashing;

class FullQueryTextDao {
    private static final ImmutableList<Schemas.Column> columns = ImmutableList.of((Object)ImmutableColumn.of("full_text_sha1", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("full_text", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("last_capture_time", Schemas.ColumnType.BIGINT));
    private static final ImmutableList<Schemas.Index> indexes = ImmutableList.of((Object)ImmutableIndex.of("full_query_text_idx", (ImmutableList<String>)ImmutableList.of((Object)"full_text_sha1")), (Object)ImmutableIndex.of("full_query_text_last_capture_time_idx", (ImmutableList<String>)ImmutableList.of((Object)"last_capture_time")));
    private final DataSource dataSource;
    private final Cache<String, Boolean> lastCaptureTimeUpdatedInThePastDay = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(10000L).build();
    private final Object lock = new Object();

    FullQueryTextDao(DataSource dataSource) throws Exception {
        this.dataSource = dataSource;
        dataSource.syncTable("full_query_text", (List<Schemas.Column>)columns);
        dataSource.syncIndexes("full_query_text", indexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String updateLastCaptureTime(String fullText, long captureTime) throws SQLException {
        String fullTextSha1 = Hashing.sha1().hashString((CharSequence)fullText, Charsets.UTF_8).toString();
        if (this.lastCaptureTimeUpdatedInThePastDay.getIfPresent((Object)fullTextSha1) != null) {
            return fullTextSha1;
        }
        Object object = this.lock;
        synchronized (object) {
            int updateCount = this.dataSource.update("update full_query_text set last_capture_time = ? where full_text_sha1 = ?", captureTime, fullTextSha1);
            if (updateCount == 0) {
                this.dataSource.update("insert into full_query_text (full_text_sha1, full_text, last_capture_time) values (?, ?, ?)", fullTextSha1, fullText, captureTime);
            }
        }
        this.lastCaptureTimeUpdatedInThePastDay.put((Object)fullTextSha1, (Object)true);
        return fullTextSha1;
    }

    @Nullable String getFullText(final String fullTextSha1) throws SQLException {
        return this.dataSource.queryAtMostOne(new DataSource.JdbcRowQuery<String>(){

            @Override
            public @Untainted String getSql() {
                return "select full_text from full_query_text where full_text_sha1 = ?";
            }

            @Override
            public void bind(PreparedStatement preparedStatement) throws SQLException {
                preparedStatement.setString(1, fullTextSha1);
            }

            @Override
            public String mapRow(ResultSet resultSet) throws Exception {
                return (String)Preconditions.checkNotNull((Object)resultSet.getString(1));
            }
        });
    }

    void deleteBefore(long captureTime) throws SQLException {
        this.dataSource.deleteBeforeUsingLock("full_query_text", "last_capture_time", captureTime - TimeUnit.DAYS.toMillis(1L), this.lock);
    }

    void invalidateCache() {
        this.lastCaptureTimeUpdatedInThePastDay.invalidateAll();
    }
}

