/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.glowroot.agent.shaded.com.google.common.io.BaseEncoding;

public class PasswordHash {
    private static final int ITERATION_COUNT = 500000;
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final BaseEncoding encoder = BaseEncoding.base64().omitPadding();

    private PasswordHash() {
    }

    public static String createHash(String password) throws GeneralSecurityException {
        byte[] salt = new byte[16];
        secureRandom.nextBytes(salt);
        return PasswordHash.hash(password, salt, 500000);
    }

    public static boolean validatePassword(String password, String correctHash) throws GeneralSecurityException {
        int iterationCount;
        byte[] salt;
        String[] correctHashParts = correctHash.split(":");
        if (correctHashParts.length != 3) {
            throw new GeneralSecurityException("Invalid password hash: " + correctHash);
        }
        try {
            salt = encoder.decode((CharSequence)correctHashParts[1]);
        }
        catch (IllegalArgumentException e) {
            throw new GeneralSecurityException(e);
        }
        try {
            iterationCount = Integer.parseInt(correctHashParts[2]);
        }
        catch (NumberFormatException e) {
            throw new GeneralSecurityException(e);
        }
        String hash = PasswordHash.hash(password, salt, iterationCount);
        return hash.equals(correctHash);
    }

    private static String hash(String password, byte[] salt, int iterationCount) throws GeneralSecurityException {
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterationCount, 128);
        SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        byte[] hash = f.generateSecret(spec).getEncoded();
        return encoder.encode(hash) + ':' + encoder.encode(salt) + ':' + 500000;
    }
}

