/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.com.google.common.io.CharSource;

public abstract class ChunkSource {
    public abstract ChunkCopier getCopier(Writer var1) throws IOException;

    static ChunkSource create(final CharSource charSource) {
        return new ChunkSource(){

            @Override
            public ChunkCopier getCopier(Writer writer) throws IOException {
                return new ReaderChunkCopier(charSource.openStream(), writer);
            }
        };
    }

    static ChunkSource wrap(final String str) {
        return new ChunkSource(){

            @Override
            public ChunkCopier getCopier(Writer writer) throws IOException {
                return new StringChunkCopier(str, writer);
            }
        };
    }

    static ChunkSource concat(final List<ChunkSource> chunkSources) {
        return new ChunkSource(){

            @Override
            public ChunkCopier getCopier(Writer writer) throws IOException {
                return new ConcatChunkCopier(chunkSources, writer);
            }
        };
    }

    private static class StringChunkCopier
    implements ChunkCopier {
        private final String str;
        private final Writer writer;
        private volatile boolean closed;

        private StringChunkCopier(String str, Writer writer) {
            this.str = str;
            this.writer = writer;
        }

        @Override
        public boolean copyNext() throws IOException {
            if (this.closed) {
                return false;
            }
            this.writer.write(this.str);
            this.closed = true;
            return true;
        }
    }

    private static class ConcatChunkCopier
    implements ChunkCopier {
        private final Iterator<ChunkSource> chunkSources;
        private final Writer writer;
        private volatile @Nullable ChunkCopier currChunkCopier;

        private ConcatChunkCopier(Iterable<ChunkSource> chunkSources, Writer writer) {
            this.chunkSources = chunkSources.iterator();
            this.writer = writer;
        }

        @Override
        public boolean copyNext() throws IOException {
            if (this.currChunkCopier == null) {
                if (!this.chunkSources.hasNext()) {
                    return false;
                }
                this.currChunkCopier = this.chunkSources.next().getCopier(this.writer);
            }
            if (this.currChunkCopier.copyNext()) {
                return true;
            }
            if (!this.chunkSources.hasNext()) {
                return false;
            }
            this.currChunkCopier = this.chunkSources.next().getCopier(this.writer);
            return this.copyNext();
        }
    }

    private static class ReaderChunkCopier
    implements ChunkCopier {
        private static final int CHUNK_SIZE = 8192;
        private final Reader reader;
        private final Writer writer;
        private final char[] buffer = new char[8192];

        private ReaderChunkCopier(Reader reader, Writer writer) {
            this.reader = reader;
            this.writer = writer;
        }

        @Override
        public boolean copyNext() throws IOException {
            int total = ReaderChunkCopier.readFully(this.reader, this.buffer);
            if (total == 0) {
                return false;
            }
            this.writer.write(this.buffer, 0, total);
            return true;
        }

        private static int readFully(Reader reader, char[] buffer) throws IOException {
            int n;
            int total = 0;
            while ((n = reader.read(buffer, total, buffer.length - total)) != -1 && (total += n) != buffer.length) {
            }
            return total;
        }
    }

    public static interface ChunkCopier {
        public boolean copyNext() throws IOException;
    }
}

