/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConfigJsonService.GeneralConfigDto", generator="Immutables")
@Immutable
final class ImmutableGeneralConfigDto
extends ConfigJsonService.GeneralConfigDto {
    private final String display;
    private final @org.checkerframework.checker.nullness.qual.Nullable String defaultDisplay;
    private final String version;

    private ImmutableGeneralConfigDto(String display, @org.checkerframework.checker.nullness.qual.Nullable String defaultDisplay, String version) {
        this.display = display;
        this.defaultDisplay = defaultDisplay;
        this.version = version;
    }

    @Override
    @JsonProperty(value="display")
    String display() {
        return this.display;
    }

    @Override
    @JsonProperty(value="defaultDisplay")
    @org.checkerframework.checker.nullness.qual.Nullable String defaultDisplay() {
        return this.defaultDisplay;
    }

    @Override
    @JsonProperty(value="version")
    String version() {
        return this.version;
    }

    public final ImmutableGeneralConfigDto withDisplay(String value) {
        String newValue = Objects.requireNonNull(value, "display");
        if (this.display.equals(newValue)) {
            return this;
        }
        return new ImmutableGeneralConfigDto(newValue, this.defaultDisplay, this.version);
    }

    public final ImmutableGeneralConfigDto withDefaultDisplay(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.defaultDisplay, value)) {
            return this;
        }
        return new ImmutableGeneralConfigDto(this.display, value, this.version);
    }

    public final ImmutableGeneralConfigDto withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableGeneralConfigDto(this.display, this.defaultDisplay, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeneralConfigDto && this.equalTo(0, (ImmutableGeneralConfigDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableGeneralConfigDto another) {
        return this.display.equals(another.display) && Objects.equals(this.defaultDisplay, another.defaultDisplay) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.display.hashCode();
        h += (h << 5) + Objects.hashCode(this.defaultDisplay);
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GeneralConfigDto").omitNullValues().add("display", (Object)this.display).add("defaultDisplay", (Object)this.defaultDisplay).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGeneralConfigDto fromJson(Json json) {
        Builder builder = ImmutableGeneralConfigDto.builder();
        if (json.display != null) {
            builder.display(json.display);
        }
        if (json.defaultDisplay != null) {
            builder.defaultDisplay(json.defaultDisplay);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutableGeneralConfigDto copyOf(ConfigJsonService.GeneralConfigDto instance) {
        if (instance instanceof ImmutableGeneralConfigDto) {
            return (ImmutableGeneralConfigDto)instance;
        }
        return ImmutableGeneralConfigDto.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfigJsonService.GeneralConfigDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DISPLAY = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private long initBits = 3L;
        @Nullable
        private String display;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String defaultDisplay;
        @Nullable
        private String version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ConfigJsonService.GeneralConfigDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.display(instance.display());
            @org.checkerframework.checker.nullness.qual.Nullable String defaultDisplayValue = instance.defaultDisplay();
            if (defaultDisplayValue != null) {
                this.defaultDisplay(defaultDisplayValue);
            }
            this.version(instance.version());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder display(String display) {
            this.display = Objects.requireNonNull(display, "display");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultDisplay(@org.checkerframework.checker.nullness.qual.Nullable String defaultDisplay) {
            this.defaultDisplay = defaultDisplay;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGeneralConfigDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGeneralConfigDto(this.display, this.defaultDisplay, this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("display");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build GeneralConfigDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConfigJsonService.GeneralConfigDto", generator="Immutables")
    static final class Json
    extends ConfigJsonService.GeneralConfigDto {
        @Nullable
        String display;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String defaultDisplay;
        @Nullable
        String version;

        Json() {
        }

        @JsonProperty(value="display")
        public void setDisplay(String display) {
            this.display = display;
        }

        @JsonProperty(value="defaultDisplay")
        public void setDefaultDisplay(@org.checkerframework.checker.nullness.qual.Nullable String defaultDisplay) {
            this.defaultDisplay = defaultDisplay;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @Override
        String display() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable String defaultDisplay() {
            throw new UnsupportedOperationException();
        }

        @Override
        String version() {
            throw new UnsupportedOperationException();
        }
    }
}

