/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionJsonService.TransactionPercentileRequest", generator="Immutables")
@Immutable
final class ImmutableTransactionPercentileRequest
implements TransactionJsonService.TransactionPercentileRequest {
    private final String transactionType;
    private final @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
    private final long from;
    private final long to;
    private final ImmutableList<Double> percentile;

    private ImmutableTransactionPercentileRequest(String transactionType, @org.checkerframework.checker.nullness.qual.Nullable String transactionName, long from, long to, ImmutableList<Double> percentile) {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.from = from;
        this.to = to;
        this.percentile = percentile;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    public @org.checkerframework.checker.nullness.qual.Nullable String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="percentile")
    public ImmutableList<Double> percentile() {
        return this.percentile;
    }

    public final ImmutableTransactionPercentileRequest withTransactionType(String value) {
        String newValue = Objects.requireNonNull(value, "transactionType");
        if (this.transactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableTransactionPercentileRequest(newValue, this.transactionName, this.from, this.to, this.percentile);
    }

    public final ImmutableTransactionPercentileRequest withTransactionName(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.transactionName, value)) {
            return this;
        }
        return new ImmutableTransactionPercentileRequest(this.transactionType, value, this.from, this.to, this.percentile);
    }

    public final ImmutableTransactionPercentileRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        return new ImmutableTransactionPercentileRequest(this.transactionType, this.transactionName, value, this.to, this.percentile);
    }

    public final ImmutableTransactionPercentileRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        return new ImmutableTransactionPercentileRequest(this.transactionType, this.transactionName, this.from, value, this.percentile);
    }

    public final ImmutableTransactionPercentileRequest withPercentile(double ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Doubles.asList((double[])elements));
        return new ImmutableTransactionPercentileRequest(this.transactionType, this.transactionName, this.from, this.to, (ImmutableList<Double>)newValue);
    }

    public final ImmutableTransactionPercentileRequest withPercentile(Iterable<Double> elements) {
        if (this.percentile == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransactionPercentileRequest(this.transactionType, this.transactionName, this.from, this.to, (ImmutableList<Double>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionPercentileRequest && this.equalTo(0, (ImmutableTransactionPercentileRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransactionPercentileRequest another) {
        return this.transactionType.equals(another.transactionType) && Objects.equals(this.transactionName, another.transactionName) && this.from == another.from && this.to == another.to && this.percentile.equals(another.percentile);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionType.hashCode();
        h += (h << 5) + Objects.hashCode(this.transactionName);
        h += (h << 5) + Longs.hashCode((long)this.from);
        h += (h << 5) + Longs.hashCode((long)this.to);
        h += (h << 5) + this.percentile.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransactionPercentileRequest").omitNullValues().add("transactionType", (Object)this.transactionType).add("transactionName", (Object)this.transactionName).add("from", this.from).add("to", this.to).add("percentile", this.percentile).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTransactionPercentileRequest fromJson(Json json) {
        Builder builder = ImmutableTransactionPercentileRequest.builder();
        if (json.transactionType != null) {
            builder.transactionType(json.transactionType);
        }
        if (json.transactionName != null) {
            builder.transactionName(json.transactionName);
        }
        if (json.fromIsSet) {
            builder.from(json.from);
        }
        if (json.toIsSet) {
            builder.to(json.to);
        }
        if (json.percentile != null) {
            builder.addAllPercentile((Iterable<Double>)json.percentile);
        }
        return builder.build();
    }

    public static ImmutableTransactionPercentileRequest copyOf(TransactionJsonService.TransactionPercentileRequest instance) {
        if (instance instanceof ImmutableTransactionPercentileRequest) {
            return (ImmutableTransactionPercentileRequest)instance;
        }
        return ImmutableTransactionPercentileRequest.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionJsonService.TransactionPercentileRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_TYPE = 1L;
        private static final long INIT_BIT_FROM = 2L;
        private static final long INIT_BIT_TO = 4L;
        private long initBits = 7L;
        @Nullable
        private String transactionType;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
        private long from;
        private long to;
        private ImmutableList.Builder<Double> percentile = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TransactionJsonService.TransactionPercentileRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TransactionJsonService.RequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String transactionNameValue;
            TransactionJsonService.RequestBase instance;
            long bits = 0L;
            if (object instanceof TransactionJsonService.TransactionPercentileRequest) {
                instance = (TransactionJsonService.TransactionPercentileRequest)object;
                if ((bits & 2L) == 0L) {
                    this.transactionType(instance.transactionType());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.from(instance.from());
                    bits |= 4L;
                }
                this.addAllPercentile((Iterable<Double>)instance.percentile());
                if ((bits & 8L) == 0L) {
                    this.to(instance.to());
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    transactionNameValue = instance.transactionName();
                    if (transactionNameValue != null) {
                        this.transactionName(transactionNameValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TransactionJsonService.RequestBase) {
                instance = (TransactionJsonService.RequestBase)object;
                if ((bits & 2L) == 0L) {
                    this.transactionType(instance.transactionType());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.from(instance.from());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.to(instance.to());
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    transactionNameValue = instance.transactionName();
                    if (transactionNameValue != null) {
                        this.transactionName(transactionNameValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder transactionType(String transactionType) {
            this.transactionType = Objects.requireNonNull(transactionType, "transactionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionName(@org.checkerframework.checker.nullness.qual.Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(long from) {
            this.from = from;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder to(long to) {
            this.to = to;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPercentile(double element) {
            this.percentile.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPercentile(double ... elements) {
            this.percentile.addAll((Iterable)Doubles.asList((double[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder percentile(Iterable<Double> elements) {
            this.percentile = ImmutableList.builder();
            return this.addAllPercentile(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPercentile(Iterable<Double> elements) {
            this.percentile.addAll(elements);
            return this;
        }

        public ImmutableTransactionPercentileRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransactionPercentileRequest(this.transactionType, this.transactionName, this.from, this.to, this.percentile.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("from");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("to");
            }
            return "Cannot build TransactionPercentileRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionJsonService.TransactionPercentileRequest", generator="Immutables")
    static final class Json
    implements TransactionJsonService.TransactionPercentileRequest {
        @Nullable
        String transactionType;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String transactionName;
        long from;
        boolean fromIsSet;
        long to;
        boolean toIsSet;
        @Nullable
        ImmutableList<Double> percentile = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="transactionType")
        public void setTransactionType(String transactionType) {
            this.transactionType = transactionType;
        }

        @JsonProperty(value="transactionName")
        public void setTransactionName(@org.checkerframework.checker.nullness.qual.Nullable String transactionName) {
            this.transactionName = transactionName;
        }

        @JsonProperty(value="from")
        public void setFrom(long from) {
            this.from = from;
            this.fromIsSet = true;
        }

        @JsonProperty(value="to")
        public void setTo(long to) {
            this.to = to;
            this.toIsSet = true;
        }

        @JsonProperty(value="percentile")
        public void setPercentile(ImmutableList<Double> percentile) {
            this.percentile = percentile;
        }

        @Override
        public String transactionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String transactionName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long from() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long to() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<Double> percentile() {
            throw new UnsupportedOperationException();
        }
    }
}

