/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableUserConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.RoleConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.UserConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.PasswordHash;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableAllRolesResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableUserConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableUserConfigResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonServiceException;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.POST;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

@JsonService
class UserConfigJsonService {
    private static final Logger logger = LoggerFactory.getLogger(UserConfigJsonService.class);
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private static final Ordering<UserConfig> orderingByName = new Ordering<UserConfig>(){

        public int compare(UserConfig left, UserConfig right) {
            return left.username().compareToIgnoreCase(right.username());
        }
    };
    private final ConfigRepository configRepository;

    UserConfigJsonService(ConfigRepository configRepository) {
        this.configRepository = configRepository;
    }

    @GET(path="/backend/admin/users", permission="admin:view:user")
    String getUserConfig(@BindRequest UserConfigRequest request) throws Exception {
        Optional<String> username = request.username();
        if (username.isPresent()) {
            return this.getUserConfigInternal((String)username.get());
        }
        ArrayList responses = Lists.newArrayList();
        ImmutableList userConfigs = this.configRepository.getUserConfigs().toCompletableFuture().join();
        userConfigs = orderingByName.immutableSortedCopy(userConfigs);
        for (UserConfig userConfig : userConfigs) {
            responses.add(UserConfigDto.create(userConfig));
        }
        return mapper.writeValueAsString((Object)responses);
    }

    @GET(path="/backend/admin/all-role-names", permission="admin:edit:user")
    String getAllRoleNames() throws Exception {
        return mapper.writeValueAsString((Object)ImmutableAllRolesResponse.builder().allRoles(this.getAllRoleNamesInternal()).ldapAvailable(!this.configRepository.getLdapConfig().toCompletableFuture().join().host().isEmpty()).build());
    }

    @POST(path="/backend/admin/users/add", permission="admin:edit:user")
    String addUser(@BindRequest UserConfigDto userConfigDto) throws Exception {
        UserConfig userConfig = userConfigDto.convert(null);
        try {
            try {
                this.configRepository.insertUserConfig(userConfig, CassandraProfile.web).toCompletableFuture().join();
            }
            catch (CompletionException e) {
                if (e.getCause() instanceof ConfigRepository.DuplicateUsernameException) {
                    throw (ConfigRepository.DuplicateUsernameException)e.getCause();
                }
            }
        }
        catch (ConfigRepository.DuplicateUsernameException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new JsonServiceException(HttpResponseStatus.CONFLICT, "username");
        }
        return this.getUserConfigInternal(userConfig.username());
    }

    @POST(path="/backend/admin/users/update", permission="admin:edit:user")
    String updateUser(@BindRequest UserConfigDto userConfigDto) throws Exception {
        UserConfig existingUserConfig = this.configRepository.getUserConfig(userConfigDto.username()).toCompletableFuture().join();
        if (existingUserConfig == null) {
            throw new ConfigRepository.UserNotFoundException();
        }
        UserConfig userConfig = userConfigDto.convert(existingUserConfig);
        String version = (String)userConfigDto.version().get();
        try {
            this.configRepository.updateUserConfig(userConfig, version, CassandraProfile.web).toCompletableFuture().join();
        }
        catch (ConfigRepository.DuplicateUsernameException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new JsonServiceException(HttpResponseStatus.CONFLICT, "username");
        }
        return this.getUserConfigInternal(userConfig.username());
    }

    @POST(path="/backend/admin/users/remove", permission="admin:edit:user")
    String removeUser(@BindRequest UserConfigRequest request) throws Exception {
        try {
            this.configRepository.deleteUserConfig((String)request.username().get(), CassandraProfile.web).toCompletableFuture().join();
        }
        catch (ConfigRepository.CannotDeleteLastUserException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"errorCannotDeleteLastUser\":true}";
        }
        return "{}";
    }

    private String getUserConfigInternal(String username) throws Exception {
        UserConfig userConfig = this.configRepository.getUserConfig(username).toCompletableFuture().join();
        if (userConfig == null) {
            throw new JsonServiceException(HttpResponseStatus.NOT_FOUND);
        }
        return mapper.writeValueAsString((Object)ImmutableUserConfigResponse.builder().config(UserConfigDto.create(userConfig)).allRoles(this.getAllRoleNamesInternal()).ldapAvailable(!this.configRepository.getLdapConfig().toCompletableFuture().join().host().isEmpty()).build());
    }

    private List<String> getAllRoleNamesInternal() {
        ArrayList roleNames = Lists.newArrayList();
        for (RoleConfig roleConfig : this.configRepository.getRoleConfigs().toCompletableFuture().join()) {
            roleNames.add(roleConfig.name());
        }
        return roleNames;
    }

    @Value.Immutable
    static abstract class UserConfigDto {
        UserConfigDto() {
        }

        abstract String username();

        abstract boolean ldap();

        @Value.Default
        String newPassword() {
            return "";
        }

        abstract ImmutableList<String> roles();

        abstract Optional<String> version();

        private UserConfig convert(@Nullable UserConfig existingUserConfig) throws GeneralSecurityException {
            String newPassword = this.newPassword();
            String passwordHash = this.ldap() || this.username().equalsIgnoreCase("anonymous") ? "" : (newPassword.isEmpty() ? ((UserConfig)Preconditions.checkNotNull((Object)existingUserConfig)).passwordHash() : PasswordHash.createHash(newPassword));
            return ImmutableUserConfig.builder().username(this.username()).ldap(this.ldap()).passwordHash(passwordHash).roles((Iterable<String>)this.roles()).build();
        }

        private static UserConfigDto create(UserConfig config) {
            return ImmutableUserConfigDto.builder().username(config.username()).ldap(config.ldap()).roles((Iterable<String>)config.roles()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static interface AllRolesResponse {
        public ImmutableList<String> allRoles();

        public boolean ldapAvailable();
    }

    @Value.Immutable
    static interface UserConfigResponse {
        public UserConfigDto config();

        public ImmutableList<String> allRoles();

        public boolean ldapAvailable();
    }

    @Value.Immutable
    static interface UserConfigRequest {
        public Optional<String> username();
    }
}

