/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.server.pg;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.glowroot.agent.embedded.shaded.org.h2.Driver;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.server.Service;
import org.glowroot.agent.embedded.shaded.org.h2.server.pg.PgServerThread;
import org.glowroot.agent.embedded.shaded.org.h2.util.NetUtils;
import org.glowroot.agent.embedded.shaded.org.h2.util.New;
import org.glowroot.agent.embedded.shaded.org.h2.util.Tool;

public class PgServer
implements Service {
    private final HashSet<Integer> typeSet = New.hashSet();
    private int port = 5435;
    private boolean portIsSet;
    private boolean stop;
    private boolean trace;
    private ServerSocket serverSocket;
    private final Set<PgServerThread> running = Collections.synchronizedSet(new HashSet());
    private final AtomicInteger pid = new AtomicInteger();
    private String baseDir;
    private boolean allowOthers;
    private boolean isDaemon;
    private boolean ifExists;
    private String key;
    private String keyDatabase;

    @Override
    public void init(String ... stringArray) {
        this.port = 5435;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (Tool.isOption(string, "-trace")) {
                this.trace = true;
                continue;
            }
            if (Tool.isOption(string, "-pgPort")) {
                this.port = Integer.decode(stringArray[++i]);
                this.portIsSet = true;
                continue;
            }
            if (Tool.isOption(string, "-baseDir")) {
                this.baseDir = stringArray[++i];
                continue;
            }
            if (Tool.isOption(string, "-pgAllowOthers")) {
                this.allowOthers = true;
                continue;
            }
            if (Tool.isOption(string, "-pgDaemon")) {
                this.isDaemon = true;
                continue;
            }
            if (Tool.isOption(string, "-ifExists")) {
                this.ifExists = true;
                continue;
            }
            if (!Tool.isOption(string, "-key")) continue;
            this.key = stringArray[++i];
            this.keyDatabase = stringArray[++i];
        }
        Driver.load();
    }

    boolean getTrace() {
        return this.trace;
    }

    void trace(String string) {
        if (this.trace) {
            System.out.println(string);
        }
    }

    synchronized void remove(PgServerThread pgServerThread) {
        this.running.remove(pgServerThread);
    }

    void traceError(Exception exception) {
        if (this.trace) {
            exception.printStackTrace();
        }
    }

    @Override
    public String getURL() {
        return "pg://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    private boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(socket);
        }
        catch (UnknownHostException unknownHostException) {
            this.traceError(unknownHostException);
            return false;
        }
    }

    @Override
    public void start() {
        this.stop = false;
        try {
            this.serverSocket = NetUtils.createServerSocket(this.port, false);
        }
        catch (DbException dbException) {
            if (!this.portIsSet) {
                this.serverSocket = NetUtils.createServerSocket(0, false);
            }
            throw dbException;
        }
        this.port = this.serverSocket.getLocalPort();
    }

    @Override
    public void listen() {
        block4: {
            String string = Thread.currentThread().getName();
            try {
                while (!this.stop) {
                    Socket socket = this.serverSocket.accept();
                    if (!this.allow(socket)) {
                        this.trace("Connection not allowed");
                        socket.close();
                        continue;
                    }
                    PgServerThread pgServerThread = new PgServerThread(socket, this);
                    this.running.add(pgServerThread);
                    pgServerThread.setProcessId(this.pid.incrementAndGet());
                    Thread thread = new Thread((Runnable)pgServerThread, string + " thread");
                    thread.setDaemon(this.isDaemon);
                    pgServerThread.setThread(thread);
                    thread.start();
                }
            }
            catch (Exception exception) {
                if (this.stop) break block4;
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void stop() {
        if (!this.stop) {
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.serverSocket = null;
            }
        }
        for (PgServerThread pgServerThread : New.arrayList(this.running)) {
            pgServerThread.close();
            try {
                Thread thread = pgServerThread.getThread();
                if (thread == null) continue;
                thread.join(100L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public boolean isRunning(boolean bl) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket socket = NetUtils.createLoopbackSocket(this.serverSocket.getLocalPort(), false);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.traceError(exception);
            }
            return false;
        }
    }

    PgServerThread getThread(int n) {
        for (PgServerThread pgServerThread : New.arrayList(this.running)) {
            if (pgServerThread.getProcessId() != n) continue;
            return pgServerThread;
        }
        return null;
    }

    String getBaseDir() {
        return this.baseDir;
    }

    @Override
    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    @Override
    public String getType() {
        return "PG";
    }

    @Override
    public String getName() {
        return "H2 PG Server";
    }

    boolean getIfExists() {
        return this.ifExists;
    }

    public static int convertType(int n) {
        switch (n) {
            case 16: {
                return 16;
            }
            case 12: {
                return 1043;
            }
            case 2005: {
                return 25;
            }
            case 1: {
                return 1042;
            }
            case 5: {
                return 21;
            }
            case 4: {
                return 23;
            }
            case -5: {
                return 20;
            }
            case 3: {
                return 1700;
            }
            case 7: {
                return 700;
            }
            case 8: {
                return 701;
            }
            case 92: {
                return 1083;
            }
            case 91: {
                return 1082;
            }
            case 93: {
                return 1114;
            }
            case -3: {
                return 17;
            }
            case 2004: {
                return 26;
            }
            case 2003: {
                return 1009;
            }
        }
        return 705;
    }

    HashSet<Integer> getTypeSet() {
        return this.typeSet;
    }

    void checkType(int n) {
        if (!this.typeSet.contains(n)) {
            this.trace("Unsupported type: " + n);
        }
    }

    public String checkKeyAndGetDatabaseName(String string) {
        if (this.key == null) {
            return string;
        }
        if (this.key.equals(string)) {
            return this.keyDatabase;
        }
        throw DbException.get(28000);
    }

    @Override
    public boolean isDaemon() {
        return this.isDaemon;
    }
}

