/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.net.logstash.logback.appender.destination;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DestinationParser {
    private static final Pattern DESTINATION_PATTERN = Pattern.compile("^\\s*(\\S+?)\\s*(:\\s*(\\S+)\\s*)?$");
    private static final int HOSTNAME_GROUP = 1;
    private static final int PORT_GROUP = 3;

    public static List<InetSocketAddress> parse(String destinations, int defaultPort) {
        String[] destinationStrings = (destinations == null ? "" : destinations.trim()).split("\\s*,\\s*");
        ArrayList<InetSocketAddress> destinationList = new ArrayList<InetSocketAddress>(destinationStrings.length);
        for (String entry : destinationStrings) {
            int port;
            if (entry.contains("_IS_UNDEFINED")) {
                throw new IllegalArgumentException("Invalid destination '" + entry + "': unparseable value (expected format 'host[:port]').");
            }
            Matcher matcher = DESTINATION_PATTERN.matcher(entry);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid destination '" + entry + "': unparseable value (expected format 'host[:port]').");
            }
            String host = matcher.group(1);
            String portString = matcher.group(3);
            try {
                port = portString != null ? Integer.parseInt(portString) : defaultPort;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid destination '" + entry + "': unparseable port (was '" + portString + "').");
            }
            destinationList.add(InetSocketAddress.createUnresolved(host, port));
        }
        return destinationList;
    }
}

