/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.bytecode.api.BytecodeSafe;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassReader;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassWriter;
import org.glowroot.agent.shaded.org.objectweb.asm.MethodVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.AdviceAdapter;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

class ManagementFactoryHackClassFileTransformer
implements ClassFileTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ManagementFactoryHackClassFileTransformer.class);

    ManagementFactoryHackClassFileTransformer() {
    }

    @Override
    public byte[] transform(@Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        try {
            if ("java/lang/management/ManagementFactory".equals(className)) {
                ClassWriter cw = new ClassWriter(0);
                ManagementFactoryHackClassVisitor cv = new ManagementFactoryHackClassVisitor(cw);
                ClassReader cr = new ClassReader(bytes);
                cr.accept(cv, 8);
                return cw.toByteArray();
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return null;
    }

    private static class ManagementFactoryHackMethodVisitor
    extends AdviceAdapter {
        private ManagementFactoryHackMethodVisitor(MethodVisitor mv, int access, String name, String descriptor) {
            super(589824, mv, access, name, descriptor);
        }

        @Override
        protected void onMethodExit(int opcode) {
            if (opcode != 191) {
                this.visitMethodInsn(184, Type.getType(BytecodeSafe.class).getInternalName(), "exitingGetPlatformMBeanServer", "()V", false);
            }
        }
    }

    private static class ManagementFactoryHackClassVisitor
    extends ClassVisitor {
        private final ClassWriter cw;

        private ManagementFactoryHackClassVisitor(ClassWriter cw) {
            super(589824, cw);
            this.cw = cw;
        }

        @Override
        public @Nullable MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
            MethodVisitor mv = this.cw.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals("getPlatformMBeanServer") && descriptor.equals("()Ljavax/management/MBeanServer;")) {
                return new ManagementFactoryHackMethodVisitor(mv, access, name, descriptor);
            }
            return mv;
        }
    }
}

