/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.central;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.central.ImmutableCollectorTarget;
import org.glowroot.agent.central.ImmutableParsedCollectorAddress;
import org.glowroot.agent.central.MultipleAddressNameResolverFactory;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.base.Stopwatch;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.io.grpc.ManagedChannel;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.StatusRuntimeException;
import org.glowroot.agent.shaded.io.grpc.netty.GrpcSslContexts;
import org.glowroot.agent.shaded.io.grpc.netty.NegotiationType;
import org.glowroot.agent.shaded.io.grpc.netty.NettyChannelBuilder;
import org.glowroot.agent.shaded.io.grpc.stub.StreamObserver;
import org.glowroot.agent.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.glowroot.common.util.Throwables;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.RateLimitedLogger;
import org.glowroot.agent.util.ThreadFactories;
import org.immutables.value.Value;

class CentralConnection {
    private static final Logger logger = LoggerFactory.getLogger(CentralConnection.class);
    private final ThreadLocal<Boolean> suppressLogCollector = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final ExecutorService channelExecutor;
    private final ManagedChannel channel;
    private final ScheduledExecutorService retryExecutor;
    private final AtomicBoolean inConnectionFailure;
    private final Random random = new Random();
    private final RateLimitedLogger connectionErrorLogger = new RateLimitedLogger(CentralConnection.class);
    private final String collectorAddress;
    private volatile boolean inMaybeInitFailure;
    private volatile boolean initCallSucceeded;
    private volatile boolean closed;

    CentralConnection(String collectorAddress, @Nullable String collectorAuthority, List<File> confDirs, AtomicBoolean inConnectionFailure) throws SSLException {
        NettyChannelBuilder builder;
        ParsedCollectorAddress parsedCollectorAddress = CentralConnection.parseCollectorAddress(collectorAddress);
        this.channelExecutor = Executors.newFixedThreadPool(1, ThreadFactories.create("Glowroot-GRPC-Executor"));
        if (parsedCollectorAddress.targets().size() == 1) {
            CollectorTarget target = parsedCollectorAddress.targets().get(0);
            builder = NettyChannelBuilder.forAddress(target.host(), target.port());
            if (collectorAuthority != null) {
                builder.overrideAuthority(collectorAuthority);
            }
        } else {
            String authority;
            if (collectorAuthority != null) {
                authority = collectorAuthority;
            } else if (!parsedCollectorAddress.https()) {
                authority = "dummy-service-authority";
            } else {
                throw new IllegalStateException("collector.authority is required when connecting over HTTPS to a comma-separated list of glowroot central collectors");
            }
            builder = (NettyChannelBuilder)NettyChannelBuilder.forTarget("dummy-target").nameResolverFactory(new MultipleAddressNameResolverFactory(parsedCollectorAddress.targets(), authority));
        }
        ((NettyChannelBuilder)((NettyChannelBuilder)builder.defaultLoadBalancingPolicy("round_robin")).executor(this.channelExecutor)).keepAliveTime(20L, TimeUnit.SECONDS);
        if (parsedCollectorAddress.https()) {
            SslContextBuilder sslContext = GrpcSslContexts.forClient();
            File trustCertCollectionFile = CentralConnection.getTrustCertCollectionFile(confDirs);
            if (trustCertCollectionFile != null) {
                sslContext.trustManager(trustCertCollectionFile);
            }
            this.channel = builder.sslContext(sslContext.build()).negotiationType(NegotiationType.TLS).build();
        } else {
            this.channel = builder.negotiationType(NegotiationType.PLAINTEXT).build();
        }
        this.retryExecutor = Executors.newSingleThreadScheduledExecutor(ThreadFactories.create("Glowroot-Collector-Retry"));
        this.inConnectionFailure = inConnectionFailure;
        this.collectorAddress = collectorAddress;
    }

    boolean suppressLogCollector() {
        return this.suppressLogCollector.get();
    }

    ManagedChannel getChannel() {
        return this.channel;
    }

    <T> void blockingCallOnce(GrpcCall<T> call) throws InterruptedException {
        this.blockingCallWithAFewRetries(-1, call);
    }

    <T> void blockingCallWithAFewRetries(GrpcCall<T> call) throws InterruptedException {
        this.blockingCallWithAFewRetries(30000, call);
    }

    private <T> void blockingCallWithAFewRetries(int maxTotalMillis, GrpcCall<T> call) throws InterruptedException {
        if (this.closed) {
            return;
        }
        if (this.inConnectionFailure.get()) {
            return;
        }
        RetryingStreamObserver responseObserver = new RetryingStreamObserver(call, maxTotalMillis, maxTotalMillis, false);
        call.call(responseObserver);
        responseObserver.waitForFinish();
    }

    <T> void asyncCallOnce(GrpcCall<T> call) {
        if (this.closed) {
            return;
        }
        if (this.inConnectionFailure.get()) {
            return;
        }
        RetryingStreamObserver responseObserver = new RetryingStreamObserver(call, -1, -1, false);
        call.call(responseObserver);
    }

    <T> void asyncCallInit(GrpcCall<T> call) {
        if (this.closed) {
            return;
        }
        call.call(new RetryingStreamObserver(call, 15000, -1, true));
    }

    void suppressLogCollector(Runnable runnable) {
        boolean priorValue = this.suppressLogCollector.get();
        this.suppressLogCollector.set(true);
        try {
            runnable.run();
        }
        finally {
            this.suppressLogCollector.set(priorValue);
        }
    }

    @OnlyUsedByTests
    void close() {
        this.closed = true;
        this.retryExecutor.shutdown();
        this.channel.shutdown();
    }

    @OnlyUsedByTests
    void awaitClose() throws InterruptedException {
        if (!this.retryExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Could not terminate executor");
        }
        if (!this.channel.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Could not terminate channel");
        }
        this.channelExecutor.shutdown();
        if (!this.channelExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Could not terminate executor");
        }
    }

    private static ParsedCollectorAddress parseCollectorAddress(String collectorAddress) {
        boolean https = false;
        ArrayList<ImmutableCollectorTarget> targets = Lists.newArrayList();
        for (String addr : Splitter.on(',').trimResults().omitEmptyStrings().split(collectorAddress)) {
            int port;
            if (addr.startsWith("https://")) {
                if (!targets.isEmpty() && !https) {
                    throw new IllegalStateException("Cannot mix http and https addresses when using client side load balancing: " + collectorAddress);
                }
                addr = addr.substring("https://".length());
                https = true;
            } else {
                if (https) {
                    throw new IllegalStateException("Cannot mix http and https addresses when using client side load balancing: " + collectorAddress);
                }
                if (addr.startsWith("http://")) {
                    addr = addr.substring("http://".length());
                }
            }
            int index = addr.indexOf(58);
            if (index == -1) {
                throw new IllegalStateException("Invalid collector.address (missing port): " + addr);
            }
            String host = addr.substring(0, index);
            try {
                port = Integer.parseInt(addr.substring(index + 1));
            }
            catch (NumberFormatException e) {
                logger.debug(e.getMessage(), e);
                throw new IllegalStateException("Invalid collector.address (invalid port): " + addr);
            }
            targets.add(ImmutableCollectorTarget.builder().host(host).port(port).build());
        }
        return ImmutableParsedCollectorAddress.builder().https(https).addAllTargets(targets).build();
    }

    private static @Nullable File getTrustCertCollectionFile(List<File> confDirs) {
        for (File confDir : confDirs) {
            File confFile = new File(confDir, "grpc-trusted-root-certs.pem");
            if (!confFile.exists()) continue;
            return confFile;
        }
        return null;
    }

    class RetryingStreamObserver<T>
    implements StreamObserver<T> {
        private final GrpcCall<T> grpcCall;
        private final int maxSingleDelayMillis;
        private final int maxTotalMillis;
        private final boolean init;
        private final Stopwatch stopwatch = Stopwatch.createStarted();
        private volatile long nextDelayMillis = 2000L;
        private final CountDownLatch latch = new CountDownLatch(1);

        private RetryingStreamObserver(GrpcCall<T> grpcCall, int maxSingleDelayMillis, int maxTotalMillis, boolean init) {
            this.grpcCall = grpcCall;
            this.maxSingleDelayMillis = maxSingleDelayMillis;
            this.maxTotalMillis = maxTotalMillis;
            this.init = init;
        }

        @Override
        public void onNext(T value) {
            try {
                this.grpcCall.doWithResponse(value);
            }
            catch (RuntimeException t) {
                logger.error(t.getMessage(), t);
                throw t;
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
                throw new RuntimeException(t);
            }
        }

        @Override
        public void onCompleted() {
            if (this.init) {
                CentralConnection.this.inMaybeInitFailure = false;
                CentralConnection.this.initCallSucceeded = true;
            }
            this.latch.countDown();
        }

        @Override
        public void onError(Throwable t) {
            try {
                this.onErrorInternal(t);
            }
            catch (RuntimeException u) {
                logger.error(u.getMessage(), u);
                throw u;
            }
            catch (Throwable u) {
                logger.error(u.getMessage(), u);
                throw new RuntimeException(u);
            }
        }

        private void waitForFinish() throws InterruptedException {
            this.latch.await();
        }

        private void onErrorInternal(final Throwable t) throws InterruptedException {
            if (CentralConnection.this.closed) {
                this.latch.countDown();
                return;
            }
            if (this.init && !CentralConnection.this.inMaybeInitFailure) {
                CentralConnection.this.inMaybeInitFailure = true;
                this.grpcCall.call(this);
                return;
            }
            if (this.init && !CentralConnection.this.inConnectionFailure.getAndSet(true)) {
                CentralConnection.this.suppressLogCollector(new Runnable(){

                    @Override
                    public void run() {
                        logger.warn("unable to establish connection with the central collector {} (will keep trying...): {}", (Object)CentralConnection.this.collectorAddress, (Object)Throwables.getBestMessage(t));
                        logger.debug(t.getMessage(), t);
                    }
                });
            }
            if (!this.init && CentralConnection.this.inConnectionFailure.get()) {
                this.latch.countDown();
                return;
            }
            if (logger.isDebugEnabled()) {
                CentralConnection.this.suppressLogCollector(new Runnable(){

                    @Override
                    public void run() {
                        logger.debug(t.getMessage(), t);
                    }
                });
            }
            if (!this.retryOnError(t)) {
                if (CentralConnection.this.initCallSucceeded) {
                    CentralConnection.this.suppressLogCollector(new Runnable(){

                        @Override
                        public void run() {
                            CentralConnection.this.connectionErrorLogger.warn("unable to send data to the central collector: {}", Throwables.getBestMessage(t));
                            logger.debug(t.getMessage(), t);
                        }
                    });
                }
                this.latch.countDown();
                return;
            }
            if (this.init) {
                TimeUnit.MILLISECONDS.sleep(this.nextDelayMillis);
            } else {
                double randomizedDoubling = 0.5 + CentralConnection.this.random.nextDouble();
                TimeUnit.MILLISECONDS.sleep((long)((double)this.nextDelayMillis * randomizedDoubling));
            }
            this.nextDelayMillis = Math.min(this.nextDelayMillis * 2L, (long)this.maxSingleDelayMillis);
            this.grpcCall.call(this);
        }

        private boolean retryOnError(Throwable t) {
            return this.init || !this.isResourceExhaustedException(t) && this.stopwatch.elapsed(TimeUnit.MILLISECONDS) < (long)this.maxTotalMillis;
        }

        private boolean isResourceExhaustedException(Throwable t) {
            return t instanceof StatusRuntimeException && ((StatusRuntimeException)t).getStatus() == Status.RESOURCE_EXHAUSTED;
        }
    }

    static abstract class GrpcCall<T> {
        GrpcCall() {
        }

        abstract void call(StreamObserver<T> var1);

        void doWithResponse(T response) {
        }
    }

    @Value.Immutable
    static interface CollectorTarget {
        public String host();

        public int port();
    }

    @Value.Immutable
    static interface ParsedCollectorAddress {
        public boolean https();

        public List<CollectorTarget> targets();
    }
}

