/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.io.File;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.config.PluginCache;
import org.glowroot.agent.config.PluginDescriptor;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PluginCache", generator="Immutables")
@Immutable
public final class ImmutablePluginCache
extends PluginCache {
    private final ImmutableList<File> pluginJars;
    private final ImmutableList<PluginDescriptor> pluginDescriptors;

    private ImmutablePluginCache(ImmutableList<File> pluginJars, ImmutableList<PluginDescriptor> pluginDescriptors) {
        this.pluginJars = pluginJars;
        this.pluginDescriptors = pluginDescriptors;
    }

    @Override
    @JsonProperty(value="pluginJars")
    public ImmutableList<File> pluginJars() {
        return this.pluginJars;
    }

    @Override
    @JsonProperty(value="pluginDescriptors")
    public ImmutableList<PluginDescriptor> pluginDescriptors() {
        return this.pluginDescriptors;
    }

    public final ImmutablePluginCache withPluginJars(File ... elements) {
        ImmutableList<File> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePluginCache(newValue, this.pluginDescriptors);
    }

    public final ImmutablePluginCache withPluginJars(Iterable<? extends File> elements) {
        if (this.pluginJars == elements) {
            return this;
        }
        ImmutableList<File> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePluginCache(newValue, this.pluginDescriptors);
    }

    public final ImmutablePluginCache withPluginDescriptors(PluginDescriptor ... elements) {
        ImmutableList<PluginDescriptor> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePluginCache(this.pluginJars, newValue);
    }

    public final ImmutablePluginCache withPluginDescriptors(Iterable<? extends PluginDescriptor> elements) {
        if (this.pluginDescriptors == elements) {
            return this;
        }
        ImmutableList<PluginDescriptor> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePluginCache(this.pluginJars, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePluginCache && this.equalTo(0, (ImmutablePluginCache)another);
    }

    private boolean equalTo(int synthetic, ImmutablePluginCache another) {
        return this.pluginJars.equals(another.pluginJars) && this.pluginDescriptors.equals(another.pluginDescriptors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pluginJars.hashCode();
        h += (h << 5) + this.pluginDescriptors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PluginCache").omitNullValues().add("pluginJars", this.pluginJars).add("pluginDescriptors", this.pluginDescriptors).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePluginCache fromJson(Json json) {
        Builder builder = ImmutablePluginCache.builder();
        if (json.pluginJars != null) {
            builder.addAllPluginJars(json.pluginJars);
        }
        if (json.pluginDescriptors != null) {
            builder.addAllPluginDescriptors(json.pluginDescriptors);
        }
        return builder.build();
    }

    public static ImmutablePluginCache copyOf(PluginCache instance) {
        if (instance instanceof ImmutablePluginCache) {
            return (ImmutablePluginCache)instance;
        }
        return ImmutablePluginCache.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PluginCache", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<File> pluginJars = ImmutableList.builder();
        private ImmutableList.Builder<PluginDescriptor> pluginDescriptors = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(PluginCache instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllPluginJars(instance.pluginJars());
            this.addAllPluginDescriptors(instance.pluginDescriptors());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPluginJars(File element) {
            this.pluginJars.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPluginJars(File ... elements) {
            this.pluginJars.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pluginJars(Iterable<? extends File> elements) {
            this.pluginJars = ImmutableList.builder();
            return this.addAllPluginJars(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPluginJars(Iterable<? extends File> elements) {
            this.pluginJars.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPluginDescriptors(PluginDescriptor element) {
            this.pluginDescriptors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPluginDescriptors(PluginDescriptor ... elements) {
            this.pluginDescriptors.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pluginDescriptors(Iterable<? extends PluginDescriptor> elements) {
            this.pluginDescriptors = ImmutableList.builder();
            return this.addAllPluginDescriptors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPluginDescriptors(Iterable<? extends PluginDescriptor> elements) {
            this.pluginDescriptors.addAll(elements);
            return this;
        }

        public ImmutablePluginCache build() {
            return new ImmutablePluginCache((ImmutableList)this.pluginJars.build(), (ImmutableList)this.pluginDescriptors.build());
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PluginCache", generator="Immutables")
    static final class Json
    extends PluginCache {
        @Nullable
        ImmutableList<File> pluginJars = ImmutableList.of();
        @Nullable
        ImmutableList<PluginDescriptor> pluginDescriptors = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="pluginJars")
        public void setPluginJars(ImmutableList<File> pluginJars) {
            this.pluginJars = pluginJars;
        }

        @JsonProperty(value="pluginDescriptors")
        public void setPluginDescriptors(ImmutableList<PluginDescriptor> pluginDescriptors) {
            this.pluginDescriptors = pluginDescriptors;
        }

        @Override
        public ImmutableList<File> pluginJars() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<PluginDescriptor> pluginDescriptors() {
            throw new UnsupportedOperationException();
        }
    }
}

