/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.config.PropertyDescriptor;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.config.PropertyValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PropertyDescriptor", generator="Immutables")
@Immutable
public final class ImmutablePropertyDescriptor
extends PropertyDescriptor {
    private final String name;
    private final PropertyValue.PropertyType type;
    private final @org.checkerframework.checker.nullness.qual.Nullable PropertyValue defaultValue;
    private final String label;
    private final String checkboxLabel;
    private final String description;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePropertyDescriptor(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.defaultValue = builder.defaultValue;
        this.label = builder.label;
        if (builder.checkboxLabel != null) {
            this.initShim.checkboxLabel(builder.checkboxLabel);
        }
        if (builder.description != null) {
            this.initShim.description(builder.description);
        }
        this.checkboxLabel = this.initShim.checkboxLabel();
        this.description = this.initShim.description();
        this.initShim = null;
    }

    private ImmutablePropertyDescriptor(String name, PropertyValue.PropertyType type, @org.checkerframework.checker.nullness.qual.Nullable PropertyValue defaultValue, String label, String checkboxLabel, String description) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.label = label;
        this.checkboxLabel = checkboxLabel;
        this.description = description;
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="type")
    public PropertyValue.PropertyType type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="default")
    public @org.checkerframework.checker.nullness.qual.Nullable PropertyValue defaultValue() {
        return this.defaultValue;
    }

    @Override
    @JsonProperty(value="label")
    public String label() {
        return this.label;
    }

    @Override
    @JsonProperty(value="checkboxLabel")
    public String checkboxLabel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.checkboxLabel() : this.checkboxLabel;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        InitShim shim = this.initShim;
        return shim != null ? shim.description() : this.description;
    }

    public final ImmutablePropertyDescriptor withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePropertyDescriptor(newValue, this.type, this.defaultValue, this.label, this.checkboxLabel, this.description);
    }

    public final ImmutablePropertyDescriptor withType(PropertyValue.PropertyType value) {
        PropertyValue.PropertyType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutablePropertyDescriptor(this.name, newValue, this.defaultValue, this.label, this.checkboxLabel, this.description);
    }

    public final ImmutablePropertyDescriptor withDefaultValue(@org.checkerframework.checker.nullness.qual.Nullable PropertyValue value) {
        if (this.defaultValue == value) {
            return this;
        }
        return new ImmutablePropertyDescriptor(this.name, this.type, value, this.label, this.checkboxLabel, this.description);
    }

    public final ImmutablePropertyDescriptor withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new ImmutablePropertyDescriptor(this.name, this.type, this.defaultValue, newValue, this.checkboxLabel, this.description);
    }

    public final ImmutablePropertyDescriptor withCheckboxLabel(String value) {
        String newValue = Objects.requireNonNull(value, "checkboxLabel");
        if (this.checkboxLabel.equals(newValue)) {
            return this;
        }
        return new ImmutablePropertyDescriptor(this.name, this.type, this.defaultValue, this.label, newValue, this.description);
    }

    public final ImmutablePropertyDescriptor withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutablePropertyDescriptor(this.name, this.type, this.defaultValue, this.label, this.checkboxLabel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePropertyDescriptor && this.equalTo(0, (ImmutablePropertyDescriptor)another);
    }

    private boolean equalTo(int synthetic, ImmutablePropertyDescriptor another) {
        return this.name.equals(another.name) && this.type.equals((Object)another.type) && Objects.equals(this.defaultValue, another.defaultValue) && this.label.equals(another.label) && this.checkboxLabel.equals(another.checkboxLabel) && this.description.equals(another.description);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.defaultValue);
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.checkboxLabel.hashCode();
        h += (h << 5) + this.description.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PropertyDescriptor").omitNullValues().add("name", this.name).add("type", (Object)this.type).add("defaultValue", this.defaultValue).add("label", this.label).add("checkboxLabel", this.checkboxLabel).add("description", this.description).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePropertyDescriptor fromJson(Json json) {
        Builder builder = ImmutablePropertyDescriptor.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.defaultValue != null) {
            builder.defaultValue(json.defaultValue);
        }
        if (json.label != null) {
            builder.label(json.label);
        }
        if (json.checkboxLabel != null) {
            builder.checkboxLabel(json.checkboxLabel);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        return builder.build();
    }

    public static ImmutablePropertyDescriptor copyOf(PropertyDescriptor instance) {
        if (instance instanceof ImmutablePropertyDescriptor) {
            return (ImmutablePropertyDescriptor)instance;
        }
        return ImmutablePropertyDescriptor.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PropertyDescriptor", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_LABEL = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private PropertyValue.PropertyType type;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable PropertyValue defaultValue;
        @Nullable
        private String label;
        @Nullable
        private String checkboxLabel;
        @Nullable
        private String description;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(PropertyDescriptor instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.type(instance.type());
            @org.checkerframework.checker.nullness.qual.Nullable PropertyValue defaultValueValue = instance.defaultValue();
            if (defaultValueValue != null) {
                this.defaultValue(defaultValueValue);
            }
            this.label(instance.label());
            this.checkboxLabel(instance.checkboxLabel());
            this.description(instance.description());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(PropertyValue.PropertyType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultValue(@org.checkerframework.checker.nullness.qual.Nullable PropertyValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder checkboxLabel(String checkboxLabel) {
            this.checkboxLabel = Objects.requireNonNull(checkboxLabel, "checkboxLabel");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        public ImmutablePropertyDescriptor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePropertyDescriptor(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("label");
            }
            return "Cannot build PropertyDescriptor, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PropertyDescriptor", generator="Immutables")
    static final class Json
    extends PropertyDescriptor {
        @Nullable
        String name;
        @Nullable
        PropertyValue.PropertyType type;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable PropertyValue defaultValue;
        @Nullable
        String label;
        @Nullable
        String checkboxLabel;
        @Nullable
        String description;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="type")
        public void setType(PropertyValue.PropertyType type) {
            this.type = type;
        }

        @JsonProperty(value="default")
        public void setDefaultValue(@org.checkerframework.checker.nullness.qual.Nullable PropertyValue defaultValue) {
            this.defaultValue = defaultValue;
        }

        @JsonProperty(value="label")
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty(value="checkboxLabel")
        public void setCheckboxLabel(String checkboxLabel) {
            this.checkboxLabel = checkboxLabel;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PropertyValue.PropertyType type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable PropertyValue defaultValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String label() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String checkboxLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="PropertyDescriptor", generator="Immutables")
    private final class InitShim {
        private byte checkboxLabelBuildStage = 0;
        private String checkboxLabel;
        private byte descriptionBuildStage = 0;
        private String description;

        private InitShim() {
        }

        String checkboxLabel() {
            if (this.checkboxLabelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.checkboxLabelBuildStage == 0) {
                this.checkboxLabelBuildStage = (byte)-1;
                this.checkboxLabel = Objects.requireNonNull(ImmutablePropertyDescriptor.super.checkboxLabel(), "checkboxLabel");
                this.checkboxLabelBuildStage = 1;
            }
            return this.checkboxLabel;
        }

        void checkboxLabel(String checkboxLabel) {
            this.checkboxLabel = checkboxLabel;
            this.checkboxLabelBuildStage = 1;
        }

        String description() {
            if (this.descriptionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.descriptionBuildStage == 0) {
                this.descriptionBuildStage = (byte)-1;
                this.description = Objects.requireNonNull(ImmutablePropertyDescriptor.super.description(), "description");
                this.descriptionBuildStage = 1;
            }
            return this.description;
        }

        void description(String description) {
            this.description = description;
            this.descriptionBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.checkboxLabelBuildStage == -1) {
                attributes.add("checkboxLabel");
            }
            if (this.descriptionBuildStage == -1) {
                attributes.add("description");
            }
            return "Cannot build PropertyDescriptor, attribute initializers form cycle " + attributes;
        }
    }
}

