/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.init;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.init.ImmutableRawCounterValue;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Queues;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.glowroot.common.config.GaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableMBeanAttribute;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.ScheduledRunnable;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.JavaVersion;
import org.glowroot.agent.util.LazyPlatformMBeanServer;
import org.glowroot.agent.util.RateLimitedLogger;
import org.glowroot.agent.util.ThreadFactories;
import org.glowroot.agent.weaving.Java9;
import org.immutables.value.Value;

class GaugeCollector
extends ScheduledRunnable {
    private static volatile Logger logger = LoggerFactory.getLogger(GaugeCollector.class);
    private static final int PENDING_LIMIT = 60;
    private final ConfigService configService;
    private final Collector collector;
    private final LazyPlatformMBeanServer lazyPlatformMBeanServer;
    private final Clock clock;
    private final Ticker ticker;
    private final long startTimeMillis;
    private final Set<String> pendingLoggedMBeanGauges = Sets.newConcurrentHashSet();
    private final Set<String> loggedMBeanGauges = Sets.newConcurrentHashSet();
    private final ScheduledExecutorService collectionExecutor;
    private final ExecutorService flushingExecutor;
    private final BlockingQueue<List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue>> pending = Queues.newLinkedBlockingQueue(60);
    private final RateLimitedLogger backPressureLogger = new RateLimitedLogger(GaugeCollector.class);
    private @MonotonicNonNull Map<String, RawCounterValue> priorRawCounterValues;
    private volatile boolean closed;

    GaugeCollector(ConfigService configService, Collector collector, LazyPlatformMBeanServer lazyPlatformMBeanServer, final @Nullable Instrumentation instrumentation, Clock clock, Ticker ticker) {
        this.configService = configService;
        this.collector = collector;
        this.lazyPlatformMBeanServer = lazyPlatformMBeanServer;
        this.clock = clock;
        this.ticker = ticker;
        this.startTimeMillis = clock.currentTimeMillis();
        this.collectionExecutor = Executors.newSingleThreadScheduledExecutor(ThreadFactories.create("Glowroot-Gauge-Collection"));
        this.flushingExecutor = Executors.newFixedThreadPool(1, ThreadFactories.create("Glowroot-Gauge-Flushing"));
        lazyPlatformMBeanServer.addInitListener(new LazyPlatformMBeanServer.InitListener(){

            @Override
            public void postInit(MBeanServer mbeanServer) {
                try {
                    if (JavaVersion.isGreaterThanOrEqualToJava9() && instrumentation != null) {
                        Java9.grantAccess(instrumentation, "org.glowroot.agent.init.GaugeCollector", "sun.management.ManagementFactoryHelper", true);
                    }
                    Class<?> sunManagementFactoryHelperClass = Class.forName("sun.management.ManagementFactoryHelper");
                    Method registerInternalMBeansMethod = sunManagementFactoryHelperClass.getDeclaredMethod("registerInternalMBeans", MBeanServer.class);
                    registerInternalMBeansMethod.setAccessible(true);
                    registerInternalMBeansMethod.invoke(null, mbeanServer);
                }
                catch (Throwable t) {
                    logger.debug(t.getMessage(), t);
                }
            }
        });
        this.flushingExecutor.execute(new GaugeFlushingLoop());
    }

    @Override
    protected void runInternal() throws Exception {
        ArrayList<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> gaugeValues = Lists.newArrayList();
        if (this.priorRawCounterValues == null) {
            this.priorRawCounterValues = Maps.newHashMap();
        }
        List<MBeanServer> mbeanServers = this.lazyPlatformMBeanServer.findAllMBeanServers();
        for (GaugeConfig gaugeConfig : this.configService.getGaugeConfigs()) {
            gaugeValues.addAll(this.collectGaugeValues(gaugeConfig, mbeanServers));
        }
        if (!this.pending.offer(gaugeValues)) {
            this.backPressureLogger.warn("not storing a gauge collection because of an excessive backlog of {} gauge collections already waiting to be stored", 60);
        }
    }

    void scheduleWithFixedDelay(long period, TimeUnit unit) {
        this.scheduleWithFixedDelay(this.collectionExecutor, 0L, period, unit);
    }

    void close() throws InterruptedException {
        this.closed = true;
        this.collectionExecutor.shutdown();
        if (!this.collectionExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Could not terminate executor");
        }
        this.flushingExecutor.shutdownNow();
        if (!this.flushingExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Could not terminate executor");
        }
    }

    @RequiresNonNull(value={"priorRawCounterValues"})
    List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> collectGaugeValues(GaugeConfig gaugeConfig, List<MBeanServer> mbeanServers) throws Exception {
        ObjectName objectName;
        String mbeanObjectName = gaugeConfig.mbeanObjectName();
        try {
            objectName = ObjectName.getInstance(mbeanObjectName);
        }
        catch (MalformedObjectNameException e) {
            logger.debug(e.getMessage(), e);
            this.logFirstTimeMBeanException(mbeanObjectName, e);
            return ImmutableList.of();
        }
        if (!objectName.isPattern()) {
            return this.collectGaugeValues(objectName, gaugeConfig.mbeanAttributes(), mbeanObjectName, mbeanServers);
        }
        Set<ObjectName> matchingObjectNames = this.lazyPlatformMBeanServer.queryNames(objectName, null, mbeanServers);
        if (matchingObjectNames.isEmpty()) {
            this.logFirstTimeMBeanNotMatchedOrFound(mbeanObjectName);
            return ImmutableList.of();
        }
        this.pendingLoggedMBeanGauges.remove(mbeanObjectName);
        ArrayList<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> gaugeValues = Lists.newArrayList();
        for (ObjectName matchingObjectName : matchingObjectNames) {
            gaugeValues.addAll(this.collectGaugeValues(matchingObjectName, gaugeConfig.mbeanAttributes(), matchingObjectName.getDomain() + ":" + matchingObjectName.getKeyPropertyListString(), mbeanServers));
        }
        return gaugeValues;
    }

    @RequiresNonNull(value={"priorRawCounterValues"})
    private List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> collectGaugeValues(ObjectName objectName, List<ImmutableMBeanAttribute> mbeanAttributes, String mbeanObjectName, List<MBeanServer> mbeanServers) throws Exception {
        ArrayList<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> gaugeValues = Lists.newArrayList();
        long captureTime = this.clock.currentTimeMillis();
        for (GaugeConfig.MBeanAttribute mBeanAttribute : mbeanAttributes) {
            Object attributeValue;
            String mbeanAttributeName = mBeanAttribute.name();
            try {
                if (mbeanAttributeName.contains(".")) {
                    String[] path = mbeanAttributeName.split("\\.");
                    attributeValue = this.lazyPlatformMBeanServer.getAttribute(objectName, path[0], mbeanServers);
                    CompositeData compositeData = (CompositeData)attributeValue;
                    if (compositeData == null) continue;
                    attributeValue = compositeData.get(path[1]);
                } else {
                    attributeValue = this.lazyPlatformMBeanServer.getAttribute(objectName, mbeanAttributeName, mbeanServers);
                }
            }
            catch (InstanceNotFoundException e) {
                logger.debug(e.getMessage(), e);
                this.logFirstTimeMBeanNotMatchedOrFound(mbeanObjectName);
                break;
            }
            catch (AttributeNotFoundException e) {
                logger.debug(e.getMessage(), e);
                this.logFirstTimeMBeanAttributeNotFound(mbeanObjectName, mbeanAttributeName);
                continue;
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), e);
                this.logFirstTimeMBeanAttributeError(mbeanObjectName, mbeanAttributeName, e);
                continue;
            }
            Double value = null;
            if (attributeValue instanceof Number) {
                value = ((Number)attributeValue).doubleValue();
            } else if (attributeValue instanceof String) {
                try {
                    value = Double.parseDouble((String)attributeValue);
                }
                catch (NumberFormatException e) {
                    this.logFirstTimeMBeanAttributeError(mbeanObjectName, mbeanAttributeName, "MBean attribute value is not a valid number: \"" + attributeValue + "\"");
                }
            } else {
                this.logFirstTimeMBeanAttributeError(mbeanObjectName, mbeanAttributeName, "MBean attribute value is not a number or string");
            }
            if (value == null) continue;
            StringBuilder gaugeName = new StringBuilder(mbeanObjectName.length() + 1 + mbeanAttributeName.length() + "[counter]".length());
            gaugeName.append(mbeanObjectName);
            gaugeName.append(':');
            gaugeName.append(mbeanAttributeName);
            if (mBeanAttribute.counter()) {
                gaugeName.append("[counter]");
                String gaugeNameStr = gaugeName.toString();
                RawCounterValue priorRawCounterValue = this.priorRawCounterValues.get(gaugeNameStr);
                long captureTick = this.ticker.read();
                if (priorRawCounterValue != null) {
                    long intervalNanos = captureTick - priorRawCounterValue.captureTick();
                    double averageDeltaPerSecond = 1.0E9 * (value - priorRawCounterValue.value()) / (double)intervalNanos;
                    gaugeValues.add(CollectorServiceOuterClass.GaugeValueMessage.GaugeValue.newBuilder().setGaugeName(gaugeNameStr).setCaptureTime(captureTime).setValue(averageDeltaPerSecond).setWeight(intervalNanos).build());
                }
                this.priorRawCounterValues.put(gaugeNameStr, ImmutableRawCounterValue.of(value, captureTick));
                continue;
            }
            gaugeValues.add(CollectorServiceOuterClass.GaugeValueMessage.GaugeValue.newBuilder().setGaugeName(gaugeName.toString()).setCaptureTime(captureTime).setValue(value).setWeight(1L).build());
        }
        return gaugeValues;
    }

    private void logFirstTimeMBeanNotMatchedOrFound(String mbeanObjectName) {
        int delaySeconds = this.configService.getAdvancedConfig().mbeanGaugeNotFoundDelaySeconds();
        if (this.clock.currentTimeMillis() - this.startTimeMillis < (long)delaySeconds * 1000L) {
            this.pendingLoggedMBeanGauges.add(mbeanObjectName);
        } else if (this.loggedMBeanGauges.add(mbeanObjectName)) {
            String matchedOrFound;
            String string = matchedOrFound = mbeanObjectName.contains("*") ? "matched" : "found";
            if (this.pendingLoggedMBeanGauges.remove(mbeanObjectName)) {
                logger.warn("mbean not {}: {} (waited {} seconds after jvm startup before logging this warning to allow time for mbean registration - this wait time can be changed under Configuration > Advanced)", matchedOrFound, mbeanObjectName, delaySeconds);
            } else {
                logger.warn("mbean not {}: {}", (Object)matchedOrFound, (Object)mbeanObjectName);
            }
        }
    }

    private void logFirstTimeMBeanAttributeNotFound(String mbeanObjectName, String mbeanAttributeName) {
        if (this.loggedMBeanGauges.add(mbeanObjectName + ":" + mbeanAttributeName)) {
            logger.warn("mbean attribute {} not found in {}", (Object)mbeanAttributeName, (Object)mbeanObjectName);
        }
    }

    private void logFirstTimeMBeanException(String mbeanObjectName, Exception e) {
        if (this.loggedMBeanGauges.add(mbeanObjectName)) {
            logger.warn("error accessing mbean: {}", (Object)mbeanObjectName, (Object)e);
        }
    }

    private void logFirstTimeMBeanAttributeError(String mbeanObjectName, String mbeanAttributeName, String message) {
        if (this.loggedMBeanGauges.add(mbeanObjectName + ":" + mbeanAttributeName)) {
            logger.warn("error accessing mbean attribute {} {}: {}", mbeanObjectName, mbeanAttributeName, message);
        }
    }

    private void logFirstTimeMBeanAttributeError(String mbeanObjectName, String mbeanAttributeName, Exception e) {
        if (this.loggedMBeanGauges.add(mbeanObjectName + ":" + mbeanAttributeName)) {
            logger.warn("error accessing mbean attribute: {} {}", mbeanObjectName, mbeanAttributeName, e);
        }
    }

    public void setLoggerForTesting(Logger logger) {
        GaugeCollector.logger = logger;
    }

    private class GaugeFlushingLoop
    implements Runnable {
        private GaugeFlushingLoop() {
        }

        @Override
        public void run() {
            while (!GaugeCollector.this.closed) {
                try {
                    GaugeCollector.this.collector.collectGaugeValues((List)GaugeCollector.this.pending.take());
                }
                catch (InterruptedException e) {
                    logger.debug(e.getMessage(), e);
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface RawCounterValue {
        public double value();

        public long captureTick();
    }
}

