/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.live;

import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.live.ClasspathCache;
import org.glowroot.agent.live.ImmutablePointcutClassName;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.cache.CacheLoader;
import org.glowroot.agent.shaded.com.google.common.cache.LoadingCache;
import org.glowroot.agent.shaded.com.google.common.collect.ArrayListMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.ComparisonChain;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Multimap;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveWeavingService;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.DownstreamServiceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.MaybePatterns;
import org.glowroot.agent.weaving.AdviceCache;
import org.glowroot.agent.weaving.AnalyzedWorld;
import org.immutables.value.Value;

public class LiveWeavingServiceImpl
implements LiveWeavingService {
    private static final Logger logger = LoggerFactory.getLogger(LiveWeavingServiceImpl.class);
    private static final String THE_SINGLE_KEY = "THE_SINGLE_KEY";
    private static final Splitter splitter = Splitter.on(' ').omitEmptyStrings();
    private final AnalyzedWorld analyzedWorld;
    private final @Nullable Instrumentation instrumentation;
    private final ConfigService configService;
    private final AdviceCache adviceCache;
    private final boolean jvmRetransformClassesSupported;
    private final LoadingCache<String, ClasspathCache> classpathCache = CacheBuilder.newBuilder().softValues().maximumSize(1L).build(new CacheLoader<String, ClasspathCache>(){

        @Override
        public ClasspathCache load(String key) throws Exception {
            return new ClasspathCache(LiveWeavingServiceImpl.this.analyzedWorld, LiveWeavingServiceImpl.this.instrumentation);
        }
    });

    public LiveWeavingServiceImpl(AnalyzedWorld analyzedWorld, @Nullable Instrumentation instrumentation, ConfigService configService, AdviceCache adviceCache, boolean jvmRetransformClassesSupported) {
        this.analyzedWorld = analyzedWorld;
        this.instrumentation = instrumentation;
        this.configService = configService;
        this.adviceCache = adviceCache;
        this.jvmRetransformClassesSupported = jvmRetransformClassesSupported;
    }

    @Override
    public DownstreamServiceOuterClass.GlobalMeta getGlobalMeta(String agentId) {
        return DownstreamServiceOuterClass.GlobalMeta.newBuilder().setJvmOutOfSync(this.adviceCache.isOutOfSync(this.configService.getInstrumentationConfigs())).setJvmRetransformClassesSupported(this.jvmRetransformClassesSupported).build();
    }

    @Override
    public void preloadClasspathCache(String agentId) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                LiveWeavingServiceImpl.this.getClasspathCache().updateCache();
            }
        });
        thread.setName("Glowroot-Preload-Classpath-Cache");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public List<String> getMatchingClassNames(String agentId, String partialClassName, int limit) {
        return this.getClasspathCache().getMatchingClassNames(partialClassName, limit);
    }

    @Override
    public List<String> getMatchingMethodNames(String agentId, String className, String partialMethodName, int limit) {
        String partialMethodNameUpper = partialMethodName.toUpperCase(Locale.ENGLISH);
        HashSet<String> methodNames = Sets.newHashSet();
        for (ClasspathCache.UiAnalyzedMethod analyzedMethod : this.getClasspathCache().getAnalyzedMethods(className)) {
            String methodName = analyzedMethod.name();
            if (methodName.equals("<init>") || methodName.equals("<clinit>") || !methodName.toUpperCase(Locale.ENGLISH).contains(partialMethodNameUpper)) continue;
            methodNames.add(methodName);
        }
        ImmutableList<String> sortedMethodNames = Ordering.natural().immutableSortedCopy(methodNames);
        if (methodNames.size() > limit) {
            return sortedMethodNames.subList(0, limit);
        }
        return sortedMethodNames;
    }

    @Override
    public List<DownstreamServiceOuterClass.MethodSignature> getMethodSignatures(String agentId, String className, String methodName) {
        if (methodName.contains("*") || methodName.contains("|")) {
            return ImmutableList.of();
        }
        List<ClasspathCache.UiAnalyzedMethod> analyzedMethods = this.getAnalyzedMethods(className, methodName);
        ArrayList<DownstreamServiceOuterClass.MethodSignature> methodSignatures = Lists.newArrayList();
        for (ClasspathCache.UiAnalyzedMethod analyzedMethod : analyzedMethods) {
            DownstreamServiceOuterClass.MethodSignature.Builder builder = DownstreamServiceOuterClass.MethodSignature.newBuilder();
            builder.setName(analyzedMethod.name());
            builder.addAllParameterType(analyzedMethod.parameterTypes());
            builder.setReturnType(analyzedMethod.returnType());
            int reducedModifiers = analyzedMethod.modifiers() & 0xFFFFFFEF & 0xFFFFFFDF;
            String modifierNames = Modifier.toString(reducedModifiers);
            for (String modifier : splitter.split(modifierNames)) {
                builder.addModifier(modifier.toLowerCase(Locale.ENGLISH));
            }
            methodSignatures.add(builder.build());
        }
        return methodSignatures;
    }

    @Override
    public int reweave(String agentId) throws Exception {
        if (this.instrumentation == null) {
            return 0;
        }
        Preconditions.checkState(this.instrumentation.isRetransformClassesSupported(), "Retransform classes is not supported");
        return this.reweaveInternal();
    }

    private List<ClasspathCache.UiAnalyzedMethod> getAnalyzedMethods(String className, String methodName) {
        HashSet<ClasspathCache.UiAnalyzedMethod> analyzedMethods = Sets.newHashSet();
        for (ClasspathCache.UiAnalyzedMethod analyzedMethod : this.getClasspathCache().getAnalyzedMethods(className)) {
            if (!analyzedMethod.name().equals(methodName)) continue;
            analyzedMethods.add(analyzedMethod);
        }
        return new UiAnalyzedMethodOrdering().sortedCopy(analyzedMethods);
    }

    private ClasspathCache getClasspathCache() {
        return this.classpathCache.getUnchecked(THE_SINGLE_KEY);
    }

    @RequiresNonNull(value={"instrumentation"})
    private int reweaveInternal() throws Exception {
        List<InstrumentationConfig> configs = this.configService.getInstrumentationConfigs();
        this.adviceCache.updateAdvisors(configs);
        HashSet<PointcutClassName> pointcutClassNames = Sets.newHashSet();
        for (InstrumentationConfig config : configs) {
            String className;
            PointcutClassName subTypeRestrictionPointClassName = null;
            String subTypeRestriction = config.subTypeRestriction();
            if (!subTypeRestriction.isEmpty()) {
                subTypeRestrictionPointClassName = PointcutClassName.fromMaybePattern(subTypeRestriction, null, false);
            }
            if ((className = config.className()).isEmpty()) continue;
            pointcutClassNames.add(PointcutClassName.fromMaybePattern(className, subTypeRestrictionPointClassName, config.methodName().equals("<init>")));
        }
        HashSet<Class<?>> classes = Sets.newHashSet();
        Set<Class<?>> possibleNewReweavableClasses = LiveWeavingServiceImpl.getExistingModifiableSubClasses(pointcutClassNames, this.instrumentation.getAllLoadedClasses(), this.instrumentation);
        List<Class<?>> existingReweavableClasses = this.analyzedWorld.getClassesWithReweavableAdvice(true);
        this.analyzedWorld.removeClasses(possibleNewReweavableClasses);
        classes.addAll(existingReweavableClasses);
        classes.addAll(possibleNewReweavableClasses);
        if (classes.isEmpty()) {
            return 0;
        }
        this.instrumentation.retransformClasses(Iterables.toArray(classes, Class.class));
        List<Class<?>> updatedReweavableClasses = this.analyzedWorld.getClassesWithReweavableAdvice(false);
        int count = existingReweavableClasses.size();
        for (Class<?> possibleNewReweavableClass : possibleNewReweavableClasses) {
            if (!updatedReweavableClasses.contains(possibleNewReweavableClass) || existingReweavableClasses.contains(possibleNewReweavableClass)) continue;
            ++count;
        }
        return count;
    }

    public static void initialReweave(Set<PointcutClassName> pointcutClassNames, Class<?>[] initialLoadedClasses, Instrumentation instrumentation) {
        if (!instrumentation.isRetransformClassesSupported()) {
            return;
        }
        Set<Class<?>> classes = LiveWeavingServiceImpl.getExistingModifiableSubClasses(pointcutClassNames, initialLoadedClasses, instrumentation);
        for (Class<?> clazz : classes) {
            if (clazz.isInterface()) continue;
            try {
                instrumentation.retransformClasses(clazz);
            }
            catch (UnmodifiableClassException e) {
                logger.debug(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Set<Class<?>> getExistingModifiableSubClasses(Set<PointcutClassName> pointcutClassNames, Class<?>[] classes, Instrumentation instrumentation) {
        void var7_9;
        ArrayList<Class<?>> matchingClasses = Lists.newArrayList();
        ArrayListMultimap<Class<?>, Class<?>> subClasses = ArrayListMultimap.create();
        Class<?>[] classArray = classes;
        int n = classArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            Class<?> clazz = classArray[var7_9];
            if (instrumentation.isModifiableClass(clazz)) {
                Class<?> superclass = clazz.getSuperclass();
                if (superclass != null) {
                    subClasses.put(superclass, clazz);
                }
                for (Class<?> iface : clazz.getInterfaces()) {
                    subClasses.put(iface, clazz);
                }
                for (PointcutClassName pointcutClassName : pointcutClassNames) {
                    if (!pointcutClassName.appliesTo(clazz.getName())) continue;
                    matchingClasses.add(clazz);
                    break;
                }
            }
            ++var7_9;
        }
        HashSet<Class<?>> matchingSubClasses = Sets.newHashSet();
        for (Class clazz : matchingClasses) {
            LiveWeavingServiceImpl.addToMatchingSubClasses(clazz, matchingSubClasses, subClasses);
        }
        return matchingSubClasses;
    }

    private static void addToMatchingSubClasses(Class<?> clazz, Set<Class<?>> matchingSubClasses, Multimap<Class<?>, Class<?>> subClasses) {
        matchingSubClasses.add(clazz);
        for (Class<?> subClass : subClasses.get(clazz)) {
            LiveWeavingServiceImpl.addToMatchingSubClasses(subClass, matchingSubClasses, subClasses);
        }
    }

    @Value.Immutable
    public static abstract class PointcutClassName {
        abstract @Nullable Pattern pattern();

        abstract @Nullable String nonPattern();

        abstract @Nullable PointcutClassName subTypeRestriction();

        abstract boolean doNotMatchSubClasses();

        public static PointcutClassName fromMaybePattern(String maybePattern, @Nullable PointcutClassName subTypeRestriction, boolean doNotMatchSubClasses) {
            Pattern pattern = MaybePatterns.buildPattern(maybePattern);
            if (pattern == null) {
                return PointcutClassName.fromNonPattern(maybePattern, subTypeRestriction, doNotMatchSubClasses);
            }
            return PointcutClassName.fromPattern(pattern, subTypeRestriction, doNotMatchSubClasses);
        }

        public static PointcutClassName fromPattern(Pattern pattern, @Nullable PointcutClassName subTypeRestrictionPointcutClassName, boolean doNotMatchSubClasses) {
            return ImmutablePointcutClassName.builder().pattern(pattern).nonPattern(null).subTypeRestriction(subTypeRestrictionPointcutClassName).doNotMatchSubClasses(doNotMatchSubClasses).build();
        }

        public static PointcutClassName fromNonPattern(String nonPattern, @Nullable PointcutClassName subTypeRestrictionPointcutClassName, boolean doNotMatchSubClasses) {
            return ImmutablePointcutClassName.builder().pattern(null).nonPattern(nonPattern).subTypeRestriction(subTypeRestrictionPointcutClassName).doNotMatchSubClasses(doNotMatchSubClasses).build();
        }

        private boolean appliesTo(String className) {
            PointcutClassName subTypeRestriction = this.subTypeRestriction();
            if (subTypeRestriction != null && !subTypeRestriction.appliesTo(className)) {
                return false;
            }
            Pattern pattern = this.pattern();
            if (pattern != null) {
                return pattern.matcher(className).matches();
            }
            return Preconditions.checkNotNull(this.nonPattern()).equals(className);
        }
    }

    static class UiAnalyzedMethodOrdering
    extends Ordering<ClasspathCache.UiAnalyzedMethod> {
        UiAnalyzedMethodOrdering() {
        }

        @Override
        public int compare(ClasspathCache.UiAnalyzedMethod left, ClasspathCache.UiAnalyzedMethod right) {
            return ComparisonChain.start().compare(UiAnalyzedMethodOrdering.getAccessibility(left), UiAnalyzedMethodOrdering.getAccessibility(right)).compare((Comparable<?>)((Object)left.name()), (Comparable<?>)((Object)right.name())).compare(left.parameterTypes().size(), right.parameterTypes().size()).result();
        }

        private static int getAccessibility(ClasspathCache.UiAnalyzedMethod analyzedMethod) {
            int modifiers = analyzedMethod.modifiers();
            if (Modifier.isPublic(modifiers)) {
                return 1;
            }
            if (Modifier.isProtected(modifiers)) {
                return 2;
            }
            if (Modifier.isPrivate(modifiers)) {
                return 4;
            }
            return 3;
        }
    }
}

