/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.model.QueryData;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;

public class AsyncQueryData
implements QueryData {
    private final String queryText;
    private final @Nullable AsyncQueryData limitExceededBucket;
    private final AtomicLong sumOfStartTicks = new AtomicLong();
    private final AtomicLong sumOfEndTicks = new AtomicLong();
    private final AtomicLong executionCount = new AtomicLong();
    private final AtomicInteger activeCount = new AtomicInteger();
    private final AtomicLong totalRows = new AtomicLong(-1L);

    public AsyncQueryData(String queryText, @Nullable AsyncQueryData limitExceededBucket) {
        this.queryText = queryText;
        this.limitExceededBucket = limitExceededBucket;
    }

    @Override
    public String getQueryText() {
        return this.queryText;
    }

    public long getTotalDurationNanos(Ticker ticker) {
        if (this.activeCount.get() > 0) {
            long currTick = ticker.read();
            return this.sumOfEndTicks.get() + currTick * (long)this.activeCount.get() - this.sumOfStartTicks.get();
        }
        return this.sumOfEndTicks.get() - this.sumOfStartTicks.get();
    }

    public long getExecutionCount() {
        return this.executionCount.get();
    }

    public boolean hasTotalRows() {
        return this.totalRows.get() != -1L;
    }

    public long getTotalRows() {
        long totalRows = this.totalRows.get();
        return totalRows == -1L ? 0L : totalRows;
    }

    public boolean isActive() {
        return this.activeCount.get() > 0;
    }

    @Override
    public void start(long startTick, long batchSize) {
        this.sumOfStartTicks.getAndAdd(startTick);
        this.executionCount.getAndAdd(batchSize);
        this.activeCount.getAndIncrement();
        if (this.limitExceededBucket != null) {
            this.limitExceededBucket.start(startTick, batchSize);
        }
    }

    @Override
    public void end(long endTick) {
        this.sumOfEndTicks.getAndAdd(endTick);
        this.activeCount.getAndDecrement();
        if (this.limitExceededBucket != null) {
            this.limitExceededBucket.end(endTick);
        }
    }

    @Override
    public void setHasTotalRows() {
        this.totalRows.compareAndSet(-1L, 0L);
        if (this.limitExceededBucket != null) {
            this.limitExceededBucket.setHasTotalRows();
        }
    }

    @Override
    public void incrementRowCount(long inc) {
        this.totalRows.compareAndSet(-1L, 0L);
        this.totalRows.getAndAdd(inc);
        if (this.limitExceededBucket != null) {
            this.limitExceededBucket.incrementRowCount(inc);
        }
    }

    @Override
    public void extend(long startTick) {
        this.sumOfStartTicks.getAndAdd(startTick);
        this.activeCount.getAndIncrement();
        if (this.limitExceededBucket != null) {
            this.limitExceededBucket.extend(startTick);
        }
    }
}

