/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.elasticsearch;

import org.glowroot.agent.plugin.api.AsyncQueryEntry;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.IsEnabled;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.Pointcut;

public class ActionFutureAspect {

    @Pointcut(className="org.elasticsearch.common.util.concurrent.BaseFuture", subTypeRestriction="org.elasticsearch.action.ActionFuture", methodName="set", methodParameterTypes={"java.lang.Object"})
    public static class FutureSetAdvice {
        @OnBefore
        public static void onBefore(@BindReceiver ActionFutureMixin actionFuture) {
            actionFuture.glowroot$setCompleted();
            AsyncQueryEntry asyncQueryEntry = actionFuture.glowroot$getAsyncQueryEntry();
            if (asyncQueryEntry != null) {
                asyncQueryEntry.end();
            }
        }
    }

    @Pointcut(className="org.elasticsearch.common.util.concurrent.BaseFuture", subTypeRestriction="org.elasticsearch.action.ActionFuture", methodName="setException", methodParameterTypes={"java.lang.Throwable"})
    public static class FutureSetExceptionAdvice {
        @OnBefore
        public static void onBefore(@BindReceiver ActionFutureMixin actionFuture, @BindParameter @Nullable Throwable t) {
            if (t == null) {
                return;
            }
            actionFuture.glowroot$setCompleted();
            actionFuture.glowroot$setException(t);
            AsyncQueryEntry asyncQueryEntry = actionFuture.glowroot$getAsyncQueryEntry();
            if (asyncQueryEntry != null) {
                asyncQueryEntry.endWithError(t);
            }
        }
    }

    @Pointcut(className="java.util.concurrent.Future", subTypeRestriction="org.elasticsearch.action.ActionFuture", methodName="get", methodParameterTypes={".."}, suppressionKey="wait-on-future")
    public static class FutureGetAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver ActionFutureMixin actionFuture) {
            return actionFuture.glowroot$getAsyncQueryEntry() != null;
        }

        @OnBefore
        public static Timer onBefore(ThreadContext threadContext, @BindReceiver ActionFutureMixin actionFuture) {
            AsyncQueryEntry asyncQueryEntry = actionFuture.glowroot$getAsyncQueryEntry();
            return asyncQueryEntry.extendSyncTimer(threadContext);
        }

        @OnAfter
        public static void onAfter(@BindTraveler Timer timer) {
            timer.stop();
        }
    }

    public static interface ActionFutureMixin {
        public void glowroot$setCompleted();

        public boolean glowroot$isCompleted();

        public void glowroot$setException(Throwable var1);

        @Nullable
        public Throwable glowroot$getException();

        @Nullable
        public AsyncQueryEntry glowroot$getAsyncQueryEntry();

        public void glowroot$setAsyncQueryEntry(@Nullable AsyncQueryEntry var1);
    }

    @Mixin(value={"org.elasticsearch.action.ActionFuture"})
    public static class ActionFutureImpl
    implements ActionFutureMixin {
        private volatile transient boolean glowroot$completed;
        @Nullable
        private volatile transient Throwable glowroot$exception;
        @Nullable
        private volatile transient AsyncQueryEntry glowroot$asyncQueryEntry;

        @Override
        public void glowroot$setCompleted() {
            this.glowroot$completed = true;
        }

        @Override
        public boolean glowroot$isCompleted() {
            return this.glowroot$completed;
        }

        @Override
        public void glowroot$setException(Throwable exception) {
            this.glowroot$exception = exception;
        }

        @Override
        @Nullable
        public Throwable glowroot$getException() {
            return this.glowroot$exception;
        }

        @Override
        @Nullable
        public AsyncQueryEntry glowroot$getAsyncQueryEntry() {
            return this.glowroot$asyncQueryEntry;
        }

        @Override
        public void glowroot$setAsyncQueryEntry(@Nullable AsyncQueryEntry asyncQueryEntry) {
            this.glowroot$asyncQueryEntry = asyncQueryEntry;
        }
    }
}

