/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.httpclient;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.httpclient.bclglowrootbcl.Uris;

public class ApacheHttpClient3xAspect {

    @Pointcut(className="org.apache.commons.httpclient.HttpClient", methodName="executeMethod", methodParameterTypes={"org.apache.commons.httpclient.HostConfiguration", "org.apache.commons.httpclient.HttpMethod", "org.apache.commons.httpclient.HttpState"}, nestingGroup="http-client", timerName="http client request")
    public static class ExecuteMethodAdvice {
        private static final TimerName timerName = Agent.getTimerName(ExecuteMethodAdvice.class);

        @OnBefore
        @Nullable
        public static TraceEntry onBefore(ThreadContext context, @BindParameter @Nullable HostConfiguration hostConfiguration, @BindParameter @Nullable HttpMethod methodObj) {
            String uri;
            if (methodObj == null) {
                return null;
            }
            String method = methodObj.getName();
            method = method == null ? "" : method + " ";
            try {
                URI uriObj = methodObj.getURI();
                if (uriObj == null) {
                    uri = "";
                } else {
                    uri = uriObj.getURI();
                    if (uri == null) {
                        uri = "";
                    }
                }
            }
            catch (URIException e) {
                uri = "";
            }
            return context.startServiceCallEntry("HTTP", method + Uris.stripQueryString(uri), MessageSupplier.create("http client request: {}{}", method, uri), timerName);
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.end();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler TraceEntry traceEntry) {
            traceEntry.endWithError(t);
        }
    }
}

