/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jakartaservlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletRequest;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.Pointcut;

public class AsyncServletAspect {
    static final String GLOWROOT_AUX_CONTEXT_REQUEST_ATTRIBUTE = "glowroot$auxContext";

    @Pointcut(className="jakarta.servlet.AsyncContext", methodName="dispatch", methodParameterTypes={".."}, nestingGroup="servlet-dispatch")
    public static class DispatchAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context, @BindReceiver AsyncContext asyncContext) {
            ServletRequest request = asyncContext.getRequest();
            if (request == null) {
                return;
            }
            request.setAttribute(AsyncServletAspect.GLOWROOT_AUX_CONTEXT_REQUEST_ATTRIBUTE, (Object)context.createAuxThreadContext());
        }
    }

    @Pointcut(className="jakarta.servlet.AsyncContext", methodName="complete", methodParameterTypes={})
    public static class CompleteAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context) {
            context.setTransactionAsyncComplete();
        }
    }

    @Pointcut(className="jakarta.servlet.ServletRequest", methodName="startAsync", methodParameterTypes={".."})
    public static class StartAsyncAdvice {
        @OnReturn
        public static void onReturn(@BindReturn AsyncContext asyncContext, final ThreadContext context) {
            context.setTransactionAsync();
            asyncContext.addListener(new AsyncListener(){

                public void onComplete(AsyncEvent event) {
                    context.setTransactionAsyncComplete();
                }

                public void onTimeout(AsyncEvent event) {
                    Throwable throwable = event.getThrowable();
                    if (throwable != null) {
                        context.setTransactionError(throwable);
                    }
                    context.setTransactionAsyncComplete();
                }

                public void onError(AsyncEvent event) {
                    Throwable throwable = event.getThrowable();
                    if (throwable != null) {
                        context.setTransactionError(throwable);
                    }
                    context.setTransactionAsyncComplete();
                }

                public void onStartAsync(AsyncEvent event) {
                    AsyncContext asyncContext = event.getAsyncContext();
                    if (asyncContext != null) {
                        asyncContext.addListener((AsyncListener)this);
                    }
                }
            });
        }
    }
}

