/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jakartaservlet;

import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;

public class RequestDispatcherAspect {

    @Pointcut(className="jakarta.servlet.RequestDispatcher", methodName="forward|include", methodParameterTypes={"jakarta.servlet.ServletRequest", "jakarta.servlet.ServletResponse"}, nestingGroup="servlet-dispatch", timerName="servlet dispatch")
    public static class DispatchAdvice {
        private static final TimerName timerName = Agent.getTimerName(DispatchAdvice.class);

        @OnBefore
        public static TraceEntry onBefore(ThreadContext context, @BindReceiver RequestDispatcherMixin requestDispatcher) {
            return context.startTraceEntry(MessageSupplier.create("servlet dispatch: {}", requestDispatcher.glowroot$getPath()), timerName);
        }

        @OnReturn
        public static void onReturn(@BindTraveler TraceEntry traceEntry) {
            traceEntry.end();
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler TraceEntry traceEntry) {
            traceEntry.endWithError(t);
        }
    }

    @Pointcut(className="jakarta.servlet.ServletRequest|jakarta.servlet.ServletContext", methodName="getRequestDispatcher|getNamedDispatcher", methodParameterTypes={"java.lang.String"}, nestingGroup="servlet-inner-call")
    public static class GetParameterAdvice {
        @OnReturn
        public static void onReturn(@BindReturn @Nullable RequestDispatcherMixin requestDispatcher, @BindParameter @Nullable String path) {
            if (requestDispatcher == null) {
                return;
            }
            requestDispatcher.glowroot$setPath(path);
        }
    }

    public static interface RequestDispatcherMixin {
        @Nullable
        public String glowroot$getPath();

        public void glowroot$setPath(@Nullable String var1);
    }

    @Mixin(value={"jakarta.servlet.RequestDispatcher"})
    public static abstract class RequestDispatcherImpl
    implements RequestDispatcherMixin {
        @Nullable
        private transient String glowroot$path;

        @Override
        @Nullable
        public String glowroot$getPath() {
            return this.glowroot$path;
        }

        @Override
        public void glowroot$setPath(@Nullable String path) {
            this.glowroot$path = path;
        }
    }
}

