/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.glowroot.agent.plugin.api.Logger;
import org.glowroot.agent.plugin.api.MethodInfo;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.util.Reflection;

public class ResourceMethodMeta {
    private static final Logger logger = Logger.getLogger(ResourceMethodMeta.class);
    private final String resourceClassName;
    private final String methodName;
    private final boolean hasHttpMethodAnnotation;
    private final String path;
    private final String altTransactionName;
    private final boolean hasClassPathAnnotation;

    public ResourceMethodMeta(MethodInfo methodInfo) {
        this.resourceClassName = methodInfo.getDeclaringClassName();
        this.methodName = methodInfo.getName();
        Class<?> clazz = ResourceMethodMeta.getClass(methodInfo);
        String classPath = ResourceMethodMeta.getPath(clazz);
        MethodAnnotations methodAnnotations = ResourceMethodMeta.getMethodAnnotations(methodInfo, clazz);
        if (methodAnnotations == null) {
            this.hasHttpMethodAnnotation = false;
            this.path = ResourceMethodMeta.combine(classPath, null);
        } else {
            this.hasHttpMethodAnnotation = methodAnnotations.hasHttpMethodAnnotation;
            this.path = ResourceMethodMeta.combine(classPath, methodAnnotations.pathAnnotation);
        }
        this.altTransactionName = ResourceMethodMeta.getSimpleName(this.resourceClassName) + "#" + this.methodName;
        this.hasClassPathAnnotation = classPath != null;
    }

    String getResourceClassName() {
        return this.resourceClassName;
    }

    String getMethodName() {
        return this.methodName;
    }

    boolean hasHttpMethodAnnotation() {
        return this.hasHttpMethodAnnotation;
    }

    String getPath() {
        return this.path;
    }

    String getAltTransactionName() {
        return this.altTransactionName;
    }

    boolean hasClassPathAnnotation() {
        return this.hasClassPathAnnotation;
    }

    @Nullable
    private static String getPath(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                if (!annotationClass.getName().equals("javax.ws.rs.Path") && !annotationClass.getName().equals("jakarta.ws.rs.Path")) continue;
                return ResourceMethodMeta.getPathAttribute(annotationClass, annotation, "value");
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return null;
    }

    @Nullable
    private static MethodAnnotations getMethodAnnotations(MethodInfo methodInfo, @Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        MethodAnnotations methodAnnotations = ResourceMethodMeta.getMethodAnnotations(ResourceMethodMeta.getMethod(methodInfo, clazz));
        if (methodAnnotations != null) {
            return methodAnnotations;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && (methodAnnotations = ResourceMethodMeta.getMethodAnnotations(methodInfo, superclass)) != null) {
            return methodAnnotations;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            methodAnnotations = ResourceMethodMeta.getMethodAnnotations(methodInfo, iface);
            if (methodAnnotations == null) continue;
            return methodAnnotations;
        }
        return null;
    }

    @Nullable
    private static MethodAnnotations getMethodAnnotations(@Nullable Method method) {
        if (method == null) {
            return null;
        }
        try {
            String pathAnnotation = null;
            boolean hasHttpMethodAnnotation = false;
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                if (annotationClass.getName().equals("javax.ws.rs.Path") || annotationClass.getName().equals("jakarta.ws.rs.Path")) {
                    pathAnnotation = ResourceMethodMeta.getPathAttribute(annotationClass, annotation, "value");
                    continue;
                }
                if (!ResourceMethodMeta.isHttpMethodAnnotation(annotationClass)) continue;
                hasHttpMethodAnnotation = true;
            }
            if (pathAnnotation != null || hasHttpMethodAnnotation) {
                return new MethodAnnotations(pathAnnotation, hasHttpMethodAnnotation);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return null;
    }

    private static boolean isHttpMethodAnnotation(Class<?> annotationClass) {
        for (Annotation annotation : annotationClass.getDeclaredAnnotations()) {
            Class<? extends Annotation> metaClass = annotation.annotationType();
            if (!metaClass.getName().equals("javax.ws.rs.HttpMethod") && !metaClass.getName().equals("jakarta.ws.rs.HttpMethod")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getPathAttribute(Class<?> pathClass, Object path, String attributeName) throws Exception {
        Method method = pathClass.getMethod(attributeName, new Class[0]);
        return (String)method.invoke(path, new Object[0]);
    }

    @Nullable
    private static Class<?> getClass(MethodInfo methodInfo) {
        return Reflection.getClass(methodInfo.getDeclaringClassName(), methodInfo.getLoader());
    }

    @Nullable
    private static Method getMethod(MethodInfo methodInfo, @Nullable Class<?> declaringClass) {
        if (declaringClass == null) {
            return null;
        }
        Class[] parameterTypes = methodInfo.getParameterTypes().toArray(new Class[methodInfo.getParameterTypes().size()]);
        try {
            return declaringClass.getDeclaredMethod(methodInfo.getName(), parameterTypes);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
    }

    static String combine(@Nullable String classPath, @Nullable String methodPath) {
        if (classPath == null || classPath.isEmpty() || classPath.equals("/")) {
            return ResourceMethodMeta.normalize(methodPath);
        }
        if (methodPath == null || methodPath.isEmpty() || methodPath.equals("/")) {
            return ResourceMethodMeta.normalize(classPath);
        }
        return ResourceMethodMeta.normalize(classPath) + ResourceMethodMeta.normalize(methodPath);
    }

    private static String normalize(@Nullable String path) {
        boolean addLeadingSlash;
        if (path == null || path.isEmpty() || path.equals("/")) {
            return "/";
        }
        boolean bl = addLeadingSlash = path.charAt(0) != '/';
        if (addLeadingSlash) {
            return '/' + ResourceMethodMeta.replacePathSegmentsWithAsterisk(path);
        }
        return ResourceMethodMeta.replacePathSegmentsWithAsterisk(path);
    }

    private static String replacePathSegmentsWithAsterisk(String path) {
        return path.replaceAll("\\{[^}]*\\}", "*");
    }

    private static String getSimpleName(String className) {
        return ResourceMethodMeta.substringAfterLast(ResourceMethodMeta.substringAfterLast(className, '.'), '$');
    }

    private static String substringAfterLast(String str, char c) {
        int index = str.lastIndexOf(c);
        if (index == -1) {
            return str;
        }
        return str.substring(index + 1);
    }

    private static class MethodAnnotations {
        @Nullable
        private final String pathAnnotation;
        private final boolean hasHttpMethodAnnotation;

        private MethodAnnotations(@Nullable String pathAnnotation, boolean hasHttpMethodAnnotation) {
            this.pathAnnotation = pathAnnotation;
            this.hasHttpMethodAnnotation = hasHttpMethodAnnotation;
        }
    }
}

