/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jsp;

import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.jsp.HttpJspPages;

public class HttpJspPageAspect {

    @Pointcut(className="javax.servlet.jsp.HttpJspPage|jakarta.servlet.jsp.HttpJspPage", methodName="_jspService", methodParameterTypes={"javax.servlet.http.HttpServletRequest|jakarta.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse|jakarta.servlet.http.HttpServletResponse"}, nestingGroup="jsp", timerName="jsp render")
    public static class HttpJspPageAdvice {
        private static final TimerName timerName = Agent.getTimerName(HttpJspPageAdvice.class);

        @OnBefore
        public static TraceEntry onBefore(ThreadContext context, @BindReceiver Object httpJspPage) {
            String filename = HttpJspPages.getFilename(httpJspPage.getClass());
            return context.startTraceEntry(MessageSupplier.create("jsp render: {}", filename), timerName);
        }

        @OnReturn
        public static void onReturn(@BindTraveler TraceEntry traceEntry) {
            traceEntry.end();
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler TraceEntry traceEntry) {
            traceEntry.endWithError(t);
        }
    }
}

