/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.logger;

import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.Message;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.logger.LoggerPlugin;

public class JavaLoggingAspect {
    private static final String TIMER_NAME = "logging";

    private static class LogMessageSupplier
    extends MessageSupplier {
        private final String level;
        private final String loggerName;
        private final String messageText;

        private LogMessageSupplier(String level, String loggerName, String messageText) {
            this.level = level;
            this.loggerName = loggerName;
            this.messageText = messageText;
        }

        @Override
        public Message get() {
            return Message.create("log {}: {} - {}", this.level, LoggerPlugin.getAbbreviatedLoggerName(this.loggerName), this.messageText);
        }
    }

    private static class DummyFormatter
    extends Formatter {
        private DummyFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            throw new UnsupportedOperationException();
        }
    }

    private static class LogAdviceTraveler {
        private final TraceEntry traceEntry;
        private final int level;
        private final String formattedMessage;
        @Nullable
        private final Throwable throwable;

        private LogAdviceTraveler(TraceEntry traceEntry, int level, String formattedMessage, @Nullable Throwable throwable) {
            this.traceEntry = traceEntry;
            this.level = level;
            this.formattedMessage = formattedMessage;
            this.throwable = throwable;
        }
    }

    @Pointcut(className="org.jboss.logmanager.LoggerNode", methodName="publish", methodParameterTypes={"org.jboss.logmanager.ExtLogRecord"}, nestingGroup="logging", timerName="logging")
    public static class JBossLogAdvice {
        @OnBefore
        @Nullable
        public static LogAdviceTraveler onBefore(ThreadContext context, @BindParameter @Nullable LogRecord record) {
            if (record == null) {
                return null;
            }
            return LogAdvice.onBeforeCommon(context, record, record.getLevel());
        }

        @OnAfter
        public static void onAfter(@BindTraveler @Nullable LogAdviceTraveler traveler) {
            LogAdvice.onAfter(traveler);
        }
    }

    @Pointcut(className="java.util.logging.Logger", methodName="log", methodParameterTypes={"java.util.logging.LogRecord"}, nestingGroup="logging", timerName="logging")
    public static class LogAdvice {
        private static final TimerName timerName = Agent.getTimerName(LogAdvice.class);
        private static final Formatter formatter = new DummyFormatter();

        @OnBefore
        @Nullable
        public static LogAdviceTraveler onBefore(ThreadContext context, @BindParameter @Nullable LogRecord record, @BindReceiver Object logger) {
            if (record == null) {
                return null;
            }
            Level level = record.getLevel();
            if (!((Logger)logger).isLoggable(level)) {
                return null;
            }
            return LogAdvice.onBeforeCommon(context, record, level);
        }

        @OnAfter
        public static void onAfter(@BindTraveler @Nullable LogAdviceTraveler traveler) {
            if (traveler == null) {
                return;
            }
            Throwable t = traveler.throwable;
            if (t != null) {
                if (traveler.level >= Level.WARNING.intValue()) {
                    traveler.traceEntry.endWithError(t);
                } else {
                    traveler.traceEntry.endWithInfo(t);
                }
            } else if (traveler.level >= Level.WARNING.intValue()) {
                traveler.traceEntry.endWithError(traveler.formattedMessage);
            } else {
                traveler.traceEntry.end();
            }
        }

        private static LogAdviceTraveler onBeforeCommon(ThreadContext context, LogRecord record, Level level) {
            String formattedMessage = LogAdvice.nullToEmpty(formatter.formatMessage(record));
            int lvl = level.intValue();
            Throwable t = record.getThrown();
            if (LoggerPlugin.markTraceAsError(lvl >= Level.SEVERE.intValue(), lvl >= Level.WARNING.intValue(), t != null)) {
                context.setTransactionError(formattedMessage, t);
            }
            TraceEntry traceEntry = context.startTraceEntry(new LogMessageSupplier(level.getName().toLowerCase(), record.getLoggerName(), formattedMessage), timerName);
            return new LogAdviceTraveler(traceEntry, lvl, formattedMessage, t);
        }

        private static String nullToEmpty(@Nullable String s) {
            return s == null ? "" : s;
        }
    }
}

